/**
 * Implementation of a DEMReader for the NASA 1 arc-second dataset.
 * The complete set of tiles is held at https://e4ftl01.cr.usgs.gov/MEASURES/NASADEM_HGT.001/2000.02.11/
 * This dataset is not auto-downloadable by TerrainTool.
 * To access the data you need to be logged in to a NASA Earthdata account
 * You can set up one of these by registering at https://urs.earthdata.nasa.gov/users/new/
 */
package uk.co.mccombe.terrain;

import javax.swing.JComponent;

/**
 *
 * @author Mike McCombe
 */
public class NASADEMReader extends SRTM3Reader {

    public NASADEMReader(JComponent item) throws MissingDataFileException, DataFileException {
        super(item);
    }

    @Override
    public String formatstring() {
        return FILENAMEFORMAT;
    }

    @Override
    public String zipEntryName(String name) {
        int i = name.length();
        String s = name.substring(i - 7);
        return s + ".hgt";
    }

    @Override
    public String datasetName() {
        return NAME;
    }

    @Override
    public String[] copyright() {
        return copyright;
    }


    @Override
    protected String eastWest(double val) {
        if (val >= 0) {
            return "e";
        }
        return "w";
    }

    @Override
    protected String northSouth(double val) {
        if (val >= 0) {
            return "n";
        }
        return "s";
    }

    @Override
    public boolean downloadable() {
        return DOWNLOADABLE;
    }
    @Override
    protected String getDownloadSiteName() {
        return demURL;
    }
    @Override
    protected void setDownloadSiteName(String s){
        demURL = s;
    }
    protected String demURL = "Not Defined";
    protected static boolean DOWNLOADABLE = false;
    protected static final String SITENAME = "https://e4ftl01.cr.usgs.gov/MEASURES/NASADEM_HGT.001/2000.02.11/";
    protected static final String FILENAMEFORMAT = "NASADEM_HGT_%1s%02d%1s%03d";
    protected static final String NAME = "NASA 1 arc-second";
    protected static final String[] copyright
            = {"Data derived from:-", "",
                "NASA JPL (2020). NASADEM Merged DEM Global 1 arc second V001. ",
                "NASA EOSDIS Land Processes DAAC.",
                "Accessed from https://doi.org/10.5067/MEaSUREs/NASADEM/NASADEM_HGT.001"};

}
