// Clone shims for aggregates are generated by just calling the Clone shims for all their members.
// Those calls generate a lot of unnecessary IR if the members are Copy. This test ensures that we
// optimize away those inner calls without needing to inline them.

//@ compile-flags: -Cno-prepopulate-passes -Csymbol-mangling-version=v0 -Zinline-mir=no
#![crate_type = "lib"]

pub type Test = (i32, i32, *const i32);
pub static TEST: fn(&Test) -> Test = <Test as core::clone::Clone>::clone;

// CHECK-NOT: call <i32 as core::clone::Clone>::clone
// CHECK-NOT: call <*const i32 as core::clone::Clone>::clone
// CHECK:     ; <(i32, i32, *const i32) as core::clone::Clone>::clone
// CHECK-NOT: call <i32 as core::clone::Clone>::clone
// CHECK-NOT: call <*const i32 as core::clone::Clone>::clone
