% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{read_stars}
\alias{read_stars}
\alias{is_big}
\title{read raster/array dataset from file or connection}
\usage{
read_stars(
  .x,
  ...,
  options = character(0),
  driver = character(0),
  sub = TRUE,
  quiet = FALSE,
  NA_value = NA_real_,
  along = NA_integer_,
  RasterIO = list(),
  proxy = !length(curvilinear) && is_big(.x, sub = sub, driver = driver, ...),
  curvilinear = character(0),
  normalize_path = TRUE,
  RAT = character(0)
)

is_big(x, ..., sub = sub, n_proxy = options("stars.n_proxy")[[1]] \%||\% 1e+08)
}
\arguments{
\item{.x}{character vector with name(s) of file(s) or data source(s) to be read}

\item{...}{passed on to \link{st_as_stars} if \code{curvilinear} was set}

\item{options}{character; opening options}

\item{driver}{character; driver to use for opening file. To override fixing for subdatasets and autodetect them as well, use \code{NULL}.}

\item{sub}{character, integer or logical; name, index or indicator of sub-dataset(s) to be read}

\item{quiet}{logical; print progress output?}

\item{NA_value}{numeric value to be used for conversion into NA values; by default this is read from the input file}

\item{along}{length-one character or integer, or list; determines how several arrays are combined, see Details.}

\item{RasterIO}{list with named parameters for GDAL's RasterIO, to further control the extent, resolution and bands to be read from the data source; see details.}

\item{proxy}{logical; if \code{TRUE}, an object of class \code{stars_proxy} is read which contains array
metadata only; if \code{FALSE} the full array data is read in memory. Always \code{FALSE} for curvilinear girds.
If not set, defaults to \code{TRUE} when the number of cells to be read is larger than \code{options(stars.n_proxy},
or to 1e8 if that option was not set.}

\item{curvilinear}{length two character vector with names of subdatasets holding longitude and latitude values for all raster cells, or named length 2 list holding longitude and latitude matrices; the names of this list should correspond to raster dimensions referred to}

\item{normalize_path}{logical; if \code{FALSE}, suppress a call to \link{normalizePath} on \code{.x}}

\item{RAT}{character; raster attribute table column name to use as factor levels}

\item{x}{object to be read with \link{read_stars}}

\item{n_proxy}{integer; number of cells above which .x will be read as stars
proxy object, i.e. not as in-memory arrays but left on disk}
}
\value{
object of class \code{stars}
}
\description{
read raster/array dataset from file or connection
}
\details{
In case \code{.x} contains multiple files, they will all be read and combined with \link{c.stars}. Along which dimension, or how should objects be merged? If \code{along} is set to \code{NA} it will merge arrays as new attributes if all objects have identical dimensions, or else try to merge along time if a dimension called \code{time} indicates different time stamps. A single name (or positive value) for \code{along} will merge along that dimension, or create a new one if it does not already exist. If the arrays should be arranged along one of more dimensions with values (e.g. time stamps), a named list can passed to \code{along} to specify them; see example.

\code{RasterIO} is a list with zero or more of the following named arguments:
\code{nXOff}, \code{nYOff} (both 1-based: the first row/col has offset value 1),
\code{nXSize}, \code{nYSize}, \code{nBufXSize}, \code{nBufYSize}, \code{bands}, code{resample}.
see https://www.gdal.org/classGDALDataset.html#a80d005ed10aefafa8a55dc539c2f69da for their meaning;
\code{bands} is an integer vector containing the band numbers to be read (1-based: first band is 1)
Note that if \code{nBufXSize} or \code{nBufYSize} are specified for downsampling an image,
resulting in an adjusted geotransform. \code{resample} reflects the resampling method and
has to be one of: "nearest_neighbour" (the default),
"bilinear", "cubic", "cubic_spline", "lanczos", "average", "mode", or "Gauss".
}
\examples{
tif = system.file("tif/L7_ETMs.tif", package = "stars")
(x1 = read_stars(tif))
(x2 = read_stars(c(tif, tif)))
(x3 = read_stars(c(tif, tif), along = "band"))
(x4 = read_stars(c(tif, tif), along = "new_dimensions")) # create 4-dimensional array
x1o = read_stars(tif, options = "OVERVIEW_LEVEL=1")
t1 = as.Date("2018-07-31")
# along is a named list indicating two dimensions:
read_stars(c(tif, tif, tif, tif), along = list(foo = c("bar1", "bar2"), time = c(t1, t1+2)))

m = matrix(1:120, nrow = 12, ncol = 10)
dim(m) = c(x = 10, y = 12) # named dim
st = st_as_stars(m)
attr(st, "dimensions")$y$delta = -1
attr(st, "dimensions")$y$offset = 12
st
tmp = tempfile(fileext = ".tif")
write_stars(st, tmp)
(red <- read_stars(tmp))
read_stars(tmp, RasterIO = list(nXOff = 1, nYOff = 1, nXSize = 10, nYSize = 12,
   nBufXSize = 2, nBufYSize = 2))[[1]]
(red <- read_stars(tmp, RasterIO = list(nXOff = 1, nYOff = 1, nXSize = 10, nYSize = 12,
   nBufXSize = 2, nBufYSize = 2)))
red[[1]] # cell values of subsample grid:
\dontrun{
  plot(st, reset = FALSE, axes = TRUE, ylim = c(-.1,12.1), xlim = c(-.1,10.1),
    main = "nBufXSize & nBufYSize demo", text_values = TRUE)
  plot(st_as_sfc(red, as_points = TRUE), add = TRUE, col = 'red', pch = 16)
  plot(st_as_sfc(st_as_stars(st), as_points = FALSE), add = TRUE, border = 'grey')
  plot(st_as_sfc(red, as_points = FALSE), add = TRUE, border = 'green', lwd = 2)
}
file.remove(tmp)
}
