% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list-transpose.R
\name{list_transpose}
\alias{list_transpose}
\title{Transpose a list}
\usage{
list_transpose(
  x,
  ...,
  template = NULL,
  simplify = NA,
  ptype = NULL,
  default = NULL
)
}
\arguments{
\item{x}{A list of vectors to transpose.}

\item{...}{These dots are for future extensions and must be empty.}

\item{template}{A "template" that describes the output list. Can either be
a character vector (where elements are extracted by name), or an integer
vector (where elements are extracted by position). Defaults to the union
of the names of the elements of \code{x}, or if they're not present, the
union of the integer indices.}

\item{simplify}{Should the result be \link[=list_simplify]{simplified}?
\itemize{
\item \code{TRUE}: simplify or die trying.
\item \code{NA}: simplify if possible.
\item \code{FALSE}: never try to simplify, always leaving as a list.
}

Alternatively, a named list specifying the simplification by output
element.}

\item{ptype}{An optional vector prototype used to control the simplification.
Alternatively, a named list specifying the prototype by output element.}

\item{default}{A default value to use if a value is absent or \code{NULL}.
Alternatively, a named list specifying the default by output element.}
}
\description{
\code{list_transpose()} turns a list-of-lists "inside-out". For instance it turns a pair of
lists into a list of pairs, or a list of pairs into a pair of lists. For
example, if you had a list of length \code{n} where each component had values \code{a}
and \code{b}, \code{list_transpose()} would make a list with elements \code{a} and
\code{b} that contained lists of length \code{n}.

It's called transpose because \code{x[["a"]][["b"]]} is equivalent to
\code{list_transpose(x)[["b"]][["a"]]}, i.e. transposing a list flips the order of
indices in a similar way to transposing a matrix.
}
\examples{
# list_transpose() is useful in conjunction with safely()
x <- list("a", 1, 2)
y <- x |> map(safely(log))
y |> str()
# Put all the errors and results together
y |> list_transpose() |> str()
# Supply a default result to further simplify
y |> list_transpose(default = list(result = NA)) |> str()

# list_transpose() will try to simplify by default:
x <- list(list(a = 1, b = 2), list(a = 3, b = 4), list(a = 5, b = 6))
x |> list_transpose()
# this makes list_tranpose() not completely symmetric
x |> list_transpose() |> list_transpose()

# use simplify = FALSE to always return lists:
x |> list_transpose(simplify = FALSE) |> str()
x |>
  list_transpose(simplify = FALSE) |>
  list_transpose(simplify = FALSE) |> str()

# Provide an explicit template if you know which elements you want to extract
ll <- list(
  list(x = 1, y = "one"),
  list(z = "deux", x = 2)
)
ll |> list_transpose()
ll |> list_transpose(template = c("x", "y", "z"))
ll |> list_transpose(template = 1)

# And specify a default if you want to simplify
ll |> list_transpose(template = c("x", "y", "z"), default = NA)
}
