% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_scores.R
\name{get_scores}
\alias{get_scores}
\title{Get Scores from Principal Component Analysis (PCA)}
\usage{
get_scores(x, n_items = NULL)
}
\arguments{
\item{x}{An object returned by \code{\link{principal_components}}.}

\item{n_items}{Number of required (i.e. non-missing) items to build the sum score. If \code{NULL}, the value is chosen to match half of the number of columns in a data frame.}
}
\value{
A data frame with subscales, which are average sum scores for all items from each component.
}
\description{
\code{get_scores()} takes \code{n_items} amount of items that load the most (either by loading cutoff or number) on a component, and then computes their average.
}
\details{
\code{get_scores()} takes the results from \code{\link{principal_components}}
  and extracts the variables for each component found by the PCA. Then, for
  each of these "subscales", row means are calculated (which equals adding
  up the single items and dividing by the number of items). This results in
  a sum score for each component from the PCA, which is on the same scale as
  the original, single items that were used to compute the PCA.
}
\examples{
if (require("psych")) {
  pca <- principal_components(mtcars[, 1:7], n = 2, rotation = "varimax")

  # PCA extracted two components
  pca

  # assignment of items to each component
  closest_component(pca)

  # now we want to have sum scores for each component
  get_scores(pca)

  # compare to manually computed sum score for 2nd component, which
  # consists of items "hp" and "qsec"
  (mtcars$hp + mtcars$qsec) / 2
}
}
