% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/m_str_extents.R
\name{m_str_extents}
\alias{m_str_extents}
\title{Compute string extents for a vector of string.}
\usage{
m_str_extents(
  x,
  fontname = "sans",
  fontsize = 10,
  bold = FALSE,
  italic = FALSE,
  fontfile = NULL
)
}
\arguments{
\item{x}{Character vector of strings to measure}

\item{fontname}{Font name. A vector of character to match with x.}

\item{fontsize}{Font size. A vector of numeric to match with x.}

\item{bold, italic}{Is text bold/italic?. A vector of logical to match with x.}

\item{fontfile}{Font file. A vector of character to match with x.}
}
\description{
For each \code{x} element, determines the width and height of a bounding box that's big enough
to (just) enclose the provided text. Unit is pixel.
}
\examples{
\donttest{
# The first run can be slow when font caches are missing
# as font files are then being scanned to build those font caches.
m_str_extents(letters, fontsize = 1:26)
m_str_extents(letters[1:3],
  bold = c(TRUE, FALSE, TRUE),
  italic = c(FALSE, TRUE, TRUE),
  fontname = c("sans", "sans", "sans") )
}
}
