% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize_errors.R
\name{visualize_error_boxplot}
\alias{visualize_error_boxplot}
\title{visualize_error_boxplot}
\usage{
visualize_error_boxplot(list_models, discrimination = TRUE)
}
\arguments{
\item{list_models}{list object that contains all error values for all trained calibration models. For the specific format, see the calling function \code{\link{visualize_calibratR}}.}

\item{discrimination}{boolean (TRUE or FALSE). If TRUE, discrimination errors are compared between models; if FALSE calibration error is compared, Default: TRUE}
}
\value{
An object of class list, with the following components:
\cr if \code{discrimination}=TRUE
\item{sens}{ggplot2 boxplot that compares all evaluated calibration models with regard to sensitivity.}
\item{spec}{ggplot2 boxplot that compares all evaluated calibration models with regard to specificity}
\item{acc}{ggplot2 boxplot that compares all evaluated calibration models with regard to accuracy}
\item{auc}{ggplot2 boxplot that compares all evaluated calibration models with regard to AUC}
\item{list_errors}{list object that contains all discrimination error values that were used to construct the boxplots}
\cr if \code{discrimination}=FALSE
\item{ece}{ggplot2 boxplot that compares all evaluated calibration models with regard to expected calibration error}
\item{mce}{ggplot2 boxplot that compares all evaluated calibration models with regard to maximum expected calibration error (MCE)}
\item{rmse}{ggplot2 boxplot that compares all evaluated calibration models with regard to root mean square error (RMSE)}
\item{cle_0}{ggplot2 boxplot that compares all evaluated calibration models with regard to class 0 classification error (CLE)}
\item{cle_1}{ggplot2 boxplot that compares all evaluated calibration models with regard to class 1 classification error (CLE)}
\item{list_errors}{list object that contains all calibration error values that were used to construct the boxplots}
}
\description{
compares error values among different calibration models. A boxplots is created from the n error values that were obtained during the n-times repeated Cross-Validation procedure.
Different error values are implemented and can be compared:
\cr discrimination error = sensitivity, specificity, accuracy, AUC (when \code{discrimination}=TRUE)
\cr calibration error = ece, mce, rmse, class 0 cle, class 1 cle (when \code{discrimination}=FALSE)
For the calculation of the errors, see the respective methods listed in the "see also" section
}
\seealso{
\code{\link[ggplot2]{ggplot}},\code{\link[ggplot2]{aes}},\code{\link[ggplot2]{ggtitle}},\code{\link[ggplot2]{scale_x_discrete}},\code{\link[ggplot2]{geom_boxplot}},\code{\link[ggplot2]{theme}},\code{\link[ggplot2]{element_text}}
 \code{\link[reshape2]{melt}},\code{\link{get_CLE_class}},\code{\link{getECE}},\code{\link{getMCE}},\code{\link{getRMSE}}, \code{\link{evaluate_discrimination}}
}
