% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_compare_indels.R
\name{plot_compare_indels}
\alias{plot_compare_indels}
\title{Compare two indel mutation profiles}
\usage{
plot_compare_indels(
  profile1,
  profile2,
  profile_names = c("profile 1", "profile 2"),
  profile_ymax = 0.2,
  diff_ylim = c(-0.1, 0.1)
)
}
\arguments{
\item{profile1}{First mutation profile}

\item{profile2}{Second mutation profile}

\item{profile_names}{Character vector with names of the mutations profiles
used for plotting, default = c("profile 1", "profile 2")}

\item{profile_ymax}{Maximum value of y-axis (relative contribution) for
profile plotting. This can only be used to increase the y axis.
If bars fall outside this limit, the maximum value is
automatically increased. default = 0.2.}

\item{diff_ylim}{Y-axis limits for profile difference plot,
default = c(-0.1, 0.1)}
}
\value{
A ggplot2 object
}
\description{
Plots two indel mutation profiles and their difference, reports the residual
sum of squares (RSS).
}
\examples{

## Get the indel counts
## See 'count_indel_contexts()' for more info on how to do this.
indel_counts <- readRDS(system.file("states/blood_indel_counts.rds",
  package = "MutationalPatterns"
))

## Get indel refit info.
## See 'fit_to_signatures()' for more info on how to do this.
fit_res <- readRDS(system.file("states/indel_refit.rds",
  package = "MutationalPatterns"
))

## Compare the reconstructed profile of sample 1 with the original profile
## The same thing could be done with a reconstructed profile from NMF.
plot_compare_indels(indel_counts[, 1], fit_res$reconstructed[, 1])

## You could also compare regular mutation profiles with eachother.
plot_compare_indels(
  indel_counts[, 1],
  indel_counts[, 2]
)

## Or change the names of the profiles
plot_compare_indels(indel_counts[, 1],
  indel_counts[, 2],
  profile_names = c("Original", "Reconstructed")
)

## You can also change the y limits.
## This can be done separately for the profiles and the different facets.
plot_compare_indels(indel_counts[, 1],
  indel_counts[, 2],
  profile_ymax = 0.3,
  diff_ylim = c(-0.03, 0.03)
)
}
\seealso{
\code{\link{plot_compare_profiles}},
\code{\link{plot_compare_dbs}},
\code{\link{plot_compare_mbs}}

Other Indels: 
\code{\link{count_indel_contexts}()},
\code{\link{get_indel_context}()},
\code{\link{plot_indel_contexts}()},
\code{\link{plot_main_indel_contexts}()}
}
\concept{Indels}
