% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{newCellDataSet}
\alias{newCellDataSet}
\title{Creates a new CellDateSet object.}
\usage{
newCellDataSet(cellData, phenoData = NULL, featureData = NULL,
  lowerDetectionLimit = 0.1, expressionFamily = VGAM::negbinomial.size())
}
\arguments{
\item{cellData}{expression data matrix for an experiment}

\item{phenoData}{data frame containing attributes of individual cells}

\item{featureData}{data frame containing attributes of features (e.g. genes)}

\item{lowerDetectionLimit}{the minimum expression level that consistitutes true expression}

\item{expressionFamily}{the VGAM family function to be used for expression response variables}
}
\value{
a new CellDataSet object
}
\description{
Creates a new CellDateSet object.
}
\examples{
\dontrun{
sample_sheet_small <- read.delim("../data/sample_sheet_small.txt", row.names=1)
sample_sheet_small$Time <- as.factor(sample_sheet_small$Time)
gene_annotations_small <- read.delim("../data/gene_annotations_small.txt", row.names=1)
fpkm_matrix_small <- read.delim("../data/fpkm_matrix_small.txt")
pd <- new("AnnotatedDataFrame", data = sample_sheet_small)
fd <- new("AnnotatedDataFrame", data = gene_annotations_small)
HSMM <- new("CellDataSet", exprs = as.matrix(fpkm_matrix_small), phenoData = pd, featureData = fd)
}
}
