# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.iothub import IotHubClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-iothub
# USAGE
    python iothub_create_or_update.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = IotHubClient(
        credential=DefaultAzureCredential(),
        subscription_id="91d12660-3dec-467a-be2a-213b5544ddc0",
    )

    response = client.iot_hub_resource.begin_create_or_update(
        resource_group_name="myResourceGroup",
        resource_name="testHub",
        iot_hub_description={
            "etag": "AAAAAAFD6M4=",
            "location": "centraluseuap",
            "properties": {
                "cloudToDevice": {
                    "defaultTtlAsIso8601": "PT1H",
                    "feedback": {"lockDurationAsIso8601": "PT1M", "maxDeliveryCount": 10, "ttlAsIso8601": "PT1H"},
                    "maxDeliveryCount": 10,
                },
                "enableDataResidency": True,
                "enableFileUploadNotifications": False,
                "eventHubEndpoints": {"events": {"partitionCount": 2, "retentionTimeInDays": 1}},
                "features": "None",
                "ipFilterRules": [],
                "ipVersion": "ipv4ipv6",
                "messagingEndpoints": {
                    "fileNotifications": {
                        "lockDurationAsIso8601": "PT1M",
                        "maxDeliveryCount": 10,
                        "ttlAsIso8601": "PT1H",
                    }
                },
                "minTlsVersion": "1.2",
                "networkRuleSets": {
                    "applyToBuiltInEventHubEndpoint": True,
                    "defaultAction": "Deny",
                    "ipRules": [
                        {"action": "Allow", "filterName": "rule1", "ipMask": "131.117.159.53"},
                        {"action": "Allow", "filterName": "rule2", "ipMask": "157.55.59.128/25"},
                    ],
                },
                "rootCertificate": {"enableRootCertificateV2": True},
                "routing": {
                    "endpoints": {
                        "eventHubs": [],
                        "serviceBusQueues": [],
                        "serviceBusTopics": [],
                        "storageContainers": [],
                    },
                    "fallbackRoute": {
                        "condition": "true",
                        "endpointNames": ["events"],
                        "isEnabled": True,
                        "name": "$fallback",
                        "source": "DeviceMessages",
                    },
                    "routes": [],
                },
                "storageEndpoints": {
                    "$default": {"connectionString": "", "containerName": "", "sasTtlAsIso8601": "PT1H"}
                },
            },
            "sku": {"capacity": 1, "name": "S1"},
            "tags": {},
        },
    ).result()
    print(response)


# x-ms-original-file: specification/iothub/resource-manager/Microsoft.Devices/IoTHub/preview/2025-08-01-preview/examples/iothub_createOrUpdate.json
if __name__ == "__main__":
    main()
