/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.BlockUml;
import net.sourceforge.plantuml.BlockUmlBuilder;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.FileImageData;
import net.sourceforge.plantuml.GeneratedImage;
import net.sourceforge.plantuml.GeneratedImageImpl;
import net.sourceforge.plantuml.ISourceFileReader;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.PSystemUtils;
import net.sourceforge.plantuml.SuggestedFile;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.api.ImageDataSimple;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.error.PSystemError;
import net.sourceforge.plantuml.preproc.FileWithSuffix;
import net.sourceforge.plantuml.security.SFile;
import net.sourceforge.plantuml.security.SecurityUtils;

public abstract class SourceFileReaderAbstract
implements ISourceFileReader {
    protected File file;
    protected File outputDirectory;
    protected File outputFile;
    protected BlockUmlBuilder builder;
    protected FileFormatOption fileFormatOption;
    private boolean checkMetadata;
    private boolean noerror;
    protected int cpt;

    @Override
    public void setCheckMetadata(boolean checkMetadata) {
        this.checkMetadata = checkMetadata;
    }

    @Override
    public boolean hasError() {
        for (BlockUml b : this.builder.getBlockUmls()) {
            if (!(b.getDiagram() instanceof PSystemError)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<BlockUml> getBlocks() {
        return this.builder.getBlockUmls();
    }

    protected Reader getReader(String charset) throws FileNotFoundException, UnsupportedEncodingException {
        if (charset == null) {
            Log.info("Using default charset");
            return new InputStreamReader(new BufferedInputStream(new FileInputStream(this.file)));
        }
        Log.info("Using charset " + charset);
        return new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(this.file)), charset);
    }

    public final Set<FileWithSuffix> getIncludedFiles() {
        return this.builder.getIncludedFiles();
    }

    @Override
    public final void setFileFormatOption(FileFormatOption fileFormatOption) {
        this.fileFormatOption = fileFormatOption;
    }

    protected boolean endsWithSlashOrAntislash(String newName) {
        return newName.endsWith("/") || newName.endsWith("\\");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<GeneratedImage> getCrashedImage(BlockUml blockUml, Throwable t, SFile outputFile) throws IOException {
        GeneratedImageImpl image = new GeneratedImageImpl(outputFile, "Crash Error", blockUml, 503);
        try (BufferedOutputStream os = null;){
            os = outputFile.createBufferedOutputStream();
            UmlDiagram.exportDiagramError(os, t, this.fileFormatOption, 42L, null, blockUml.getFlashData(), UmlDiagram.getFailureText2(t, blockUml.getFlashData()));
        }
        return Collections.singletonList(image);
    }

    protected void exportWarnOrErrIfWord(SFile f, Diagram system) throws FileNotFoundException {
        String warnOrError;
        if (OptionFlags.getInstance().isWord() && f != null && (warnOrError = system.getWarningOrError()) != null) {
            String name = f.getName().substring(0, f.getName().length() - 4) + ".err";
            SFile errorFile = f.getParentFile().file(name);
            PrintStream ps = SecurityUtils.createPrintStream(errorFile.createFileOutputStream());
            ps.print(warnOrError);
            ps.close();
        }
    }

    @Override
    public final List<GeneratedImage> getGeneratedImages() throws IOException {
        Log.info("Reading file: " + this.file);
        this.cpt = 0;
        ArrayList<GeneratedImageImpl> result = new ArrayList<GeneratedImageImpl>();
        for (BlockUml blockUml : this.builder.getBlockUmls()) {
            List<Object> exportDiagrams;
            Diagram system;
            SuggestedFile suggested = this.getSuggestedFile(blockUml);
            try {
                system = blockUml.getDiagram();
            }
            catch (Throwable t) {
                t.printStackTrace();
                if (OptionFlags.getInstance().isSilentlyCompletelyIgnoreErrors()) continue;
                return this.getCrashedImage(blockUml, t, suggested.getFile(0));
            }
            if (OptionFlags.getInstance().isSilentlyCompletelyIgnoreErrors() && system instanceof PSystemError) continue;
            OptionFlags.getInstance().logData(SFile.fromFile(this.file), system);
            if (this.noerror) {
                exportDiagrams = new ArrayList<FileImageData>();
                exportDiagrams.add(new FileImageData(null, new ImageDataSimple(new Dimension2DDouble(0.0, 0.0), 400)));
            } else {
                exportDiagrams = PSystemUtils.exportDiagrams(system, suggested, this.fileFormatOption, this.checkMetadata);
            }
            if (exportDiagrams.size() > 1) {
                this.cpt += exportDiagrams.size() - 1;
            }
            for (FileImageData fileImageData : exportDiagrams) {
                String desc = "[" + this.file.getName() + "] " + system.getDescription();
                SFile f = fileImageData.getFile();
                this.exportWarnOrErrIfWord(f, system);
                GeneratedImageImpl generatedImage = new GeneratedImageImpl(f, desc, blockUml, fileImageData.getStatus());
                result.add(generatedImage);
            }
        }
        Log.info("Number of image(s): " + result.size());
        return Collections.unmodifiableList(result);
    }

    protected abstract SuggestedFile getSuggestedFile(BlockUml var1) throws FileNotFoundException;

    protected final void setNoerror(boolean noerror) {
        this.noerror = noerror;
    }
}

