---
id: fast-colors.colorrgba64
title: ColorRGBA64 class
hide_title: true
---
<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[@microsoft/fast-colors](./fast-colors.md) &gt; [ColorRGBA64](./fast-colors.colorrgba64.md)

## ColorRGBA64 class

A RGBA color with 64 bit channels.

<b>Signature:</b>

```typescript
export declare class ColorRGBA64 
```

## Example


```ts
new ColorRGBA64(1, 0, 0, 1) // red

```

## Constructors

|  Constructor | Modifiers | Description |
|  --- | --- | --- |
|  [(constructor)(red, green, blue, alpha)](./fast-colors.colorrgba64._constructor_.md) |  | Constructs a new instance of the <code>ColorRGBA64</code> class |

## Properties

|  Property | Modifiers | Type | Description |
|  --- | --- | --- | --- |
|  [a](./fast-colors.colorrgba64.a.md) |  | number | The alpha value |
|  [b](./fast-colors.colorrgba64.b.md) |  | number | The blue value |
|  [g](./fast-colors.colorrgba64.g.md) |  | number | The green value |
|  [r](./fast-colors.colorrgba64.r.md) |  | number | The red value |

## Methods

|  Method | Modifiers | Description |
|  --- | --- | --- |
|  [clamp()](./fast-colors.colorrgba64.clamp.md) |  | Returns a new [ColorRGBA64](./fast-colors.colorrgba64.md) with channel values clamped between 0 and 1. |
|  [equalValue(rhs)](./fast-colors.colorrgba64.equalvalue.md) |  | Determines if one color is equal to another. |
|  [fromObject(data)](./fast-colors.colorrgba64.fromobject.md) | <code>static</code> | Construct a [ColorRGBA64](./fast-colors.colorrgba64.md) from a [ColorRGBA64Config](./fast-colors.colorrgba64config.md) |
|  [roundToPrecision(precision)](./fast-colors.colorrgba64.roundtoprecision.md) |  | Returns a new [ColorRGBA64](./fast-colors.colorrgba64.md) rounded to the provided precision |
|  [toObject()](./fast-colors.colorrgba64.toobject.md) |  | Converts the [ColorRGBA64](./fast-colors.colorrgba64.md) to a [ColorRGBA64Config](./fast-colors.colorrgba64config.md)<!-- -->. |
|  [toStringHexARGB()](./fast-colors.colorrgba64.tostringhexargb.md) |  | Returns the color formatted as a string; \#AARRGGBB |
|  [toStringHexRGB()](./fast-colors.colorrgba64.tostringhexrgb.md) |  | Returns the color formatted as a string; \#RRGGBB |
|  [toStringHexRGBA()](./fast-colors.colorrgba64.tostringhexrgba.md) |  | Returns the color formatted as a string; \#RRGGBBAA |
|  [toStringWebRGB()](./fast-colors.colorrgba64.tostringwebrgb.md) |  | Returns the color formatted as a string; "rgb(0xRR, 0xGG, 0xBB)" |
|  [toStringWebRGBA()](./fast-colors.colorrgba64.tostringwebrgba.md) |  | Returns the color formatted as a string; "rgba(0xRR, 0xGG, 0xBB, a)" |
