/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper;

import com.google.caliper.Measurement;
import com.google.common.annotations.GwtCompatible;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@GwtCompatible
public final class MeasurementSet
implements Serializable {
    private List<Measurement> measurements;
    private Map<String, Integer> unitNames;
    private int systemOutCharCount;
    private int systemErrCharCount;

    public MeasurementSet(Measurement ... measurements) {
        this(0, 0, MeasurementSet.getUnitNamesFromMeasurements(measurements), Arrays.asList(measurements));
    }

    private static Map<String, Integer> getUnitNamesFromMeasurements(Measurement ... measurements) {
        HashMap<String, Integer> unitNameToAssign = null;
        for (Measurement measurement : measurements) {
            if (unitNameToAssign == null) {
                unitNameToAssign = new HashMap<String, Integer>(measurement.getUnitNames());
                continue;
            }
            if (unitNameToAssign.equals(measurement.getUnitNames())) continue;
            throw new IllegalArgumentException("incompatible unit names: " + unitNameToAssign + " and " + measurement.getUnitNames());
        }
        return unitNameToAssign;
    }

    private MeasurementSet(int systemOutCharCount, int systemErrCharCount, Map<String, Integer> unitNames, List<Measurement> measurements) {
        this.systemOutCharCount = systemOutCharCount;
        this.systemErrCharCount = systemErrCharCount;
        this.unitNames = unitNames;
        this.measurements = measurements;
    }

    public Map<String, Integer> getUnitNames(Map<String, Integer> defaultValue) {
        if (this.unitNames == null) {
            return defaultValue;
        }
        return new HashMap<String, Integer>(this.unitNames);
    }

    public Map<String, Integer> getUnitNames() {
        return new HashMap<String, Integer>(this.unitNames);
    }

    public List<Measurement> getMeasurements() {
        return new ArrayList<Measurement>(this.measurements);
    }

    public int size() {
        return this.measurements.size();
    }

    public int getSystemOutCharCount() {
        return this.systemOutCharCount;
    }

    public int getSystemErrCharCount() {
        return this.systemErrCharCount;
    }

    public List<Double> getMeasurementsRaw() {
        ArrayList<Double> measurementRaw = new ArrayList<Double>();
        for (Measurement measurement : this.measurements) {
            measurementRaw.add(measurement.getRaw());
        }
        return measurementRaw;
    }

    public List<Double> getMeasurementUnits() {
        ArrayList<Double> measurementUnits = new ArrayList<Double>();
        for (Measurement measurement : this.measurements) {
            measurementUnits.add(measurement.getProcessed());
        }
        return measurementUnits;
    }

    public double medianRaw() {
        return this.median(this.getMeasurementsRaw());
    }

    public double medianUnits() {
        return this.median(this.getMeasurementUnits());
    }

    private double median(List<Double> doubles) {
        Collections.sort(doubles);
        int n = doubles.size();
        return n % 2 == 0 ? (doubles.get(n / 2 - 1) + doubles.get(n / 2)) / 2.0 : doubles.get(n / 2);
    }

    public double meanRaw() {
        return this.mean(this.getMeasurementsRaw());
    }

    public double meanUnits() {
        return this.mean(this.getMeasurementUnits());
    }

    private double mean(List<Double> doubles) {
        double sum = 0.0;
        for (double d : doubles) {
            sum += d;
        }
        return sum / (double)doubles.size();
    }

    public double standardDeviationRaw() {
        return this.standardDeviation(this.getMeasurementsRaw());
    }

    public double standardDeviationUnits() {
        return this.standardDeviation(this.getMeasurementUnits());
    }

    private double standardDeviation(List<Double> doubles) {
        double mean = this.mean(doubles);
        double sumOfSquares = 0.0;
        for (double d : doubles) {
            double delta = d - mean;
            sumOfSquares += delta * delta;
        }
        return Math.sqrt(sumOfSquares / (double)(doubles.size() - 1));
    }

    public double minRaw() {
        return this.min(this.getMeasurementsRaw());
    }

    public double minUnits() {
        return this.min(this.getMeasurementUnits());
    }

    private double min(List<Double> doubles) {
        Collections.sort(doubles);
        return doubles.get(0);
    }

    public double maxRaw() {
        return this.max(this.getMeasurementsRaw());
    }

    public double maxUnits() {
        return this.max(this.getMeasurementUnits());
    }

    private double max(List<Double> doubles) {
        Collections.sort(doubles, Collections.reverseOrder());
        return doubles.get(0);
    }

    public MeasurementSet plusMeasurement(Measurement measurement) {
        if (this.unitNames != null && !this.unitNames.equals(measurement.getUnitNames())) {
            throw new IllegalArgumentException("new measurement incompatible with units of measurement set. Expected " + this.unitNames + " but got " + measurement.getUnitNames());
        }
        ArrayList<Measurement> resultMeasurements = new ArrayList<Measurement>(this.measurements);
        resultMeasurements.add(measurement);
        Map<String, Integer> newUnitNames = this.unitNames == null ? measurement.getUnitNames() : this.unitNames;
        return new MeasurementSet(this.systemOutCharCount, this.systemErrCharCount, newUnitNames, resultMeasurements);
    }

    public MeasurementSet plusCharCounts(int systemOutCharCount, int systemErrCharCount) {
        return new MeasurementSet(this.systemOutCharCount + systemOutCharCount, this.systemErrCharCount + systemErrCharCount, this.unitNames, this.measurements);
    }

    public boolean equals(Object o) {
        return o instanceof MeasurementSet && ((MeasurementSet)o).measurements.equals(this.measurements) && ((MeasurementSet)o).unitNames.equals(this.unitNames) && ((MeasurementSet)o).systemOutCharCount == this.systemOutCharCount && ((MeasurementSet)o).systemErrCharCount == this.systemErrCharCount;
    }

    public int hashCode() {
        return this.measurements.hashCode() + this.unitNames.hashCode() * 37 + this.systemOutCharCount * 1373 + this.systemErrCharCount * 53549;
    }

    public String toString() {
        return this.measurements.toString() + " " + this.unitNames + " " + this.systemOutCharCount + "/" + this.systemErrCharCount;
    }

    private MeasurementSet() {
    }
}

