; NOTE: Assertions have been autogenerated by utils/update_mir_test_checks.py
; RUN: llc -global-isel -mtriple=amdgcn-mesa-mesa3d -mcpu=gfx900 -stop-after=legalizer -o - %s | FileCheck -check-prefix=GFX9 %s
; RUN: llc -global-isel -mtriple=amdgcn-mesa-mesa3d -mcpu=gfx1010 -stop-after=legalizer -o - %s | FileCheck -check-prefix=GFX10 %s

define amdgpu_ps <4 x float> @load_mip_1d(<8 x i32> inreg %rsrc, i16 %s) {
  ; GFX9-LABEL: name: load_mip_1d
  ; GFX9: bb.1.main_body:
  ; GFX9:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0
  ; GFX9:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; GFX9:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; GFX9:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; GFX9:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; GFX9:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; GFX9:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; GFX9:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; GFX9:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; GFX9:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; GFX9:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; GFX9:   [[COPY9:%[0-9]+]]:_(s32) = COPY [[COPY8]](s32)
  ; GFX9:   [[DEF:%[0-9]+]]:_(s32) = G_IMPLICIT_DEF
  ; GFX9:   [[BUILD_VECTOR_TRUNC:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR_TRUNC [[COPY9]](s32), [[DEF]](s32)
  ; GFX9:   [[AMDGPU_INTRIN_IMAGE_LOAD:%[0-9]+]]:_(<4 x s32>) = G_AMDGPU_INTRIN_IMAGE_LOAD intrinsic(@llvm.amdgcn.image.load.mip.1d), 15, [[BUILD_VECTOR_TRUNC]](<2 x s16>), 0, [[BUILD_VECTOR]](<8 x s32>), 0, 0, 3 :: (dereferenceable load (<4 x s32>) from custom "ImageResource")
  ; GFX9:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32), [[UV2:%[0-9]+]]:_(s32), [[UV3:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[AMDGPU_INTRIN_IMAGE_LOAD]](<4 x s32>)
  ; GFX9:   $vgpr0 = COPY [[UV]](s32)
  ; GFX9:   $vgpr1 = COPY [[UV1]](s32)
  ; GFX9:   $vgpr2 = COPY [[UV2]](s32)
  ; GFX9:   $vgpr3 = COPY [[UV3]](s32)
  ; GFX9:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3
  ; GFX10-LABEL: name: load_mip_1d
  ; GFX10: bb.1.main_body:
  ; GFX10:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0
  ; GFX10:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; GFX10:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; GFX10:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; GFX10:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; GFX10:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; GFX10:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; GFX10:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; GFX10:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; GFX10:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; GFX10:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; GFX10:   [[COPY9:%[0-9]+]]:_(s32) = COPY [[COPY8]](s32)
  ; GFX10:   [[DEF:%[0-9]+]]:_(s32) = G_IMPLICIT_DEF
  ; GFX10:   [[BUILD_VECTOR_TRUNC:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR_TRUNC [[COPY9]](s32), [[DEF]](s32)
  ; GFX10:   [[AMDGPU_INTRIN_IMAGE_LOAD:%[0-9]+]]:_(<4 x s32>) = G_AMDGPU_INTRIN_IMAGE_LOAD intrinsic(@llvm.amdgcn.image.load.mip.1d), 15, [[BUILD_VECTOR_TRUNC]](<2 x s16>), 0, [[BUILD_VECTOR]](<8 x s32>), 0, 0, 3 :: (dereferenceable load (<4 x s32>) from custom "ImageResource")
  ; GFX10:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32), [[UV2:%[0-9]+]]:_(s32), [[UV3:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[AMDGPU_INTRIN_IMAGE_LOAD]](<4 x s32>)
  ; GFX10:   $vgpr0 = COPY [[UV]](s32)
  ; GFX10:   $vgpr1 = COPY [[UV1]](s32)
  ; GFX10:   $vgpr2 = COPY [[UV2]](s32)
  ; GFX10:   $vgpr3 = COPY [[UV3]](s32)
  ; GFX10:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3
main_body:
  %v = call <4 x float> @llvm.amdgcn.image.load.mip.1d.v4f32.i16(i32 15, i16 %s, i16 0, <8 x i32> %rsrc, i32 0, i32 0)
  ret <4 x float> %v
}

define amdgpu_ps <4 x float> @load_mip_2d(<8 x i32> inreg %rsrc, i16 %s, i16 %t) {
  ; GFX9-LABEL: name: load_mip_2d
  ; GFX9: bb.1.main_body:
  ; GFX9:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1
  ; GFX9:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; GFX9:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; GFX9:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; GFX9:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; GFX9:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; GFX9:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; GFX9:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; GFX9:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; GFX9:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; GFX9:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; GFX9:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; GFX9:   [[COPY10:%[0-9]+]]:_(s32) = COPY [[COPY8]](s32)
  ; GFX9:   [[COPY11:%[0-9]+]]:_(s32) = COPY [[COPY9]](s32)
  ; GFX9:   [[BUILD_VECTOR_TRUNC:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR_TRUNC [[COPY10]](s32), [[COPY11]](s32)
  ; GFX9:   [[AMDGPU_INTRIN_IMAGE_LOAD:%[0-9]+]]:_(<4 x s32>) = G_AMDGPU_INTRIN_IMAGE_LOAD intrinsic(@llvm.amdgcn.image.load.mip.2d), 15, [[BUILD_VECTOR_TRUNC]](<2 x s16>), $noreg, 0, [[BUILD_VECTOR]](<8 x s32>), 0, 0, 3 :: (dereferenceable load (<4 x s32>) from custom "ImageResource")
  ; GFX9:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32), [[UV2:%[0-9]+]]:_(s32), [[UV3:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[AMDGPU_INTRIN_IMAGE_LOAD]](<4 x s32>)
  ; GFX9:   $vgpr0 = COPY [[UV]](s32)
  ; GFX9:   $vgpr1 = COPY [[UV1]](s32)
  ; GFX9:   $vgpr2 = COPY [[UV2]](s32)
  ; GFX9:   $vgpr3 = COPY [[UV3]](s32)
  ; GFX9:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3
  ; GFX10-LABEL: name: load_mip_2d
  ; GFX10: bb.1.main_body:
  ; GFX10:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1
  ; GFX10:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; GFX10:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; GFX10:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; GFX10:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; GFX10:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; GFX10:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; GFX10:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; GFX10:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; GFX10:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; GFX10:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; GFX10:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; GFX10:   [[COPY10:%[0-9]+]]:_(s32) = COPY [[COPY8]](s32)
  ; GFX10:   [[COPY11:%[0-9]+]]:_(s32) = COPY [[COPY9]](s32)
  ; GFX10:   [[BUILD_VECTOR_TRUNC:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR_TRUNC [[COPY10]](s32), [[COPY11]](s32)
  ; GFX10:   [[AMDGPU_INTRIN_IMAGE_LOAD:%[0-9]+]]:_(<4 x s32>) = G_AMDGPU_INTRIN_IMAGE_LOAD intrinsic(@llvm.amdgcn.image.load.mip.2d), 15, [[BUILD_VECTOR_TRUNC]](<2 x s16>), $noreg, 0, [[BUILD_VECTOR]](<8 x s32>), 0, 0, 3 :: (dereferenceable load (<4 x s32>) from custom "ImageResource")
  ; GFX10:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32), [[UV2:%[0-9]+]]:_(s32), [[UV3:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[AMDGPU_INTRIN_IMAGE_LOAD]](<4 x s32>)
  ; GFX10:   $vgpr0 = COPY [[UV]](s32)
  ; GFX10:   $vgpr1 = COPY [[UV1]](s32)
  ; GFX10:   $vgpr2 = COPY [[UV2]](s32)
  ; GFX10:   $vgpr3 = COPY [[UV3]](s32)
  ; GFX10:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3
main_body:
  %v = call <4 x float> @llvm.amdgcn.image.load.mip.2d.v4f32.i16(i32 15, i16 %s, i16 %t, i16 0, <8 x i32> %rsrc, i32 0, i32 0)
  ret <4 x float> %v
}

define amdgpu_ps <4 x float> @load_mip_3d(<8 x i32> inreg %rsrc, i16 %s, i16 %t, i16 %u) {
  ; GFX9-LABEL: name: load_mip_3d
  ; GFX9: bb.1.main_body:
  ; GFX9:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1, $vgpr2
  ; GFX9:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; GFX9:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; GFX9:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; GFX9:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; GFX9:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; GFX9:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; GFX9:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; GFX9:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; GFX9:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; GFX9:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; GFX9:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; GFX9:   [[COPY10:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; GFX9:   [[COPY11:%[0-9]+]]:_(s32) = COPY [[COPY8]](s32)
  ; GFX9:   [[COPY12:%[0-9]+]]:_(s32) = COPY [[COPY9]](s32)
  ; GFX9:   [[BUILD_VECTOR_TRUNC:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR_TRUNC [[COPY11]](s32), [[COPY12]](s32)
  ; GFX9:   [[COPY13:%[0-9]+]]:_(s32) = COPY [[COPY10]](s32)
  ; GFX9:   [[DEF:%[0-9]+]]:_(s32) = G_IMPLICIT_DEF
  ; GFX9:   [[BUILD_VECTOR_TRUNC1:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR_TRUNC [[COPY13]](s32), [[DEF]](s32)
  ; GFX9:   [[CONCAT_VECTORS:%[0-9]+]]:_(<4 x s16>) = G_CONCAT_VECTORS [[BUILD_VECTOR_TRUNC]](<2 x s16>), [[BUILD_VECTOR_TRUNC1]](<2 x s16>)
  ; GFX9:   [[AMDGPU_INTRIN_IMAGE_LOAD:%[0-9]+]]:_(<4 x s32>) = G_AMDGPU_INTRIN_IMAGE_LOAD intrinsic(@llvm.amdgcn.image.load.mip.3d), 15, [[CONCAT_VECTORS]](<4 x s16>), $noreg, $noreg, 0, [[BUILD_VECTOR]](<8 x s32>), 0, 0, 3 :: (dereferenceable load (<4 x s32>) from custom "ImageResource")
  ; GFX9:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32), [[UV2:%[0-9]+]]:_(s32), [[UV3:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[AMDGPU_INTRIN_IMAGE_LOAD]](<4 x s32>)
  ; GFX9:   $vgpr0 = COPY [[UV]](s32)
  ; GFX9:   $vgpr1 = COPY [[UV1]](s32)
  ; GFX9:   $vgpr2 = COPY [[UV2]](s32)
  ; GFX9:   $vgpr3 = COPY [[UV3]](s32)
  ; GFX9:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3
  ; GFX10-LABEL: name: load_mip_3d
  ; GFX10: bb.1.main_body:
  ; GFX10:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1, $vgpr2
  ; GFX10:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; GFX10:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; GFX10:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; GFX10:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; GFX10:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; GFX10:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; GFX10:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; GFX10:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; GFX10:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; GFX10:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; GFX10:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; GFX10:   [[COPY10:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; GFX10:   [[COPY11:%[0-9]+]]:_(s32) = COPY [[COPY8]](s32)
  ; GFX10:   [[COPY12:%[0-9]+]]:_(s32) = COPY [[COPY9]](s32)
  ; GFX10:   [[BUILD_VECTOR_TRUNC:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR_TRUNC [[COPY11]](s32), [[COPY12]](s32)
  ; GFX10:   [[COPY13:%[0-9]+]]:_(s32) = COPY [[COPY10]](s32)
  ; GFX10:   [[DEF:%[0-9]+]]:_(s32) = G_IMPLICIT_DEF
  ; GFX10:   [[BUILD_VECTOR_TRUNC1:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR_TRUNC [[COPY13]](s32), [[DEF]](s32)
  ; GFX10:   [[CONCAT_VECTORS:%[0-9]+]]:_(<4 x s16>) = G_CONCAT_VECTORS [[BUILD_VECTOR_TRUNC]](<2 x s16>), [[BUILD_VECTOR_TRUNC1]](<2 x s16>)
  ; GFX10:   [[AMDGPU_INTRIN_IMAGE_LOAD:%[0-9]+]]:_(<4 x s32>) = G_AMDGPU_INTRIN_IMAGE_LOAD intrinsic(@llvm.amdgcn.image.load.mip.3d), 15, [[CONCAT_VECTORS]](<4 x s16>), $noreg, $noreg, 0, [[BUILD_VECTOR]](<8 x s32>), 0, 0, 3 :: (dereferenceable load (<4 x s32>) from custom "ImageResource")
  ; GFX10:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32), [[UV2:%[0-9]+]]:_(s32), [[UV3:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[AMDGPU_INTRIN_IMAGE_LOAD]](<4 x s32>)
  ; GFX10:   $vgpr0 = COPY [[UV]](s32)
  ; GFX10:   $vgpr1 = COPY [[UV1]](s32)
  ; GFX10:   $vgpr2 = COPY [[UV2]](s32)
  ; GFX10:   $vgpr3 = COPY [[UV3]](s32)
  ; GFX10:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3
main_body:
  %v = call <4 x float> @llvm.amdgcn.image.load.mip.3d.v4f32.i16(i32 15, i16 %s, i16 %t, i16 %u, i16 0, <8 x i32> %rsrc, i32 0, i32 0)
  ret <4 x float> %v
}

define amdgpu_ps <4 x float> @load_mip_1darray(<8 x i32> inreg %rsrc, i16 %s, i16 %t) {
  ; GFX9-LABEL: name: load_mip_1darray
  ; GFX9: bb.1.main_body:
  ; GFX9:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1
  ; GFX9:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; GFX9:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; GFX9:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; GFX9:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; GFX9:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; GFX9:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; GFX9:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; GFX9:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; GFX9:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; GFX9:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; GFX9:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; GFX9:   [[COPY10:%[0-9]+]]:_(s32) = COPY [[COPY8]](s32)
  ; GFX9:   [[COPY11:%[0-9]+]]:_(s32) = COPY [[COPY9]](s32)
  ; GFX9:   [[BUILD_VECTOR_TRUNC:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR_TRUNC [[COPY10]](s32), [[COPY11]](s32)
  ; GFX9:   [[AMDGPU_INTRIN_IMAGE_LOAD:%[0-9]+]]:_(<4 x s32>) = G_AMDGPU_INTRIN_IMAGE_LOAD intrinsic(@llvm.amdgcn.image.load.mip.1darray), 15, [[BUILD_VECTOR_TRUNC]](<2 x s16>), $noreg, 0, [[BUILD_VECTOR]](<8 x s32>), 0, 0, 3 :: (dereferenceable load (<4 x s32>) from custom "ImageResource")
  ; GFX9:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32), [[UV2:%[0-9]+]]:_(s32), [[UV3:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[AMDGPU_INTRIN_IMAGE_LOAD]](<4 x s32>)
  ; GFX9:   $vgpr0 = COPY [[UV]](s32)
  ; GFX9:   $vgpr1 = COPY [[UV1]](s32)
  ; GFX9:   $vgpr2 = COPY [[UV2]](s32)
  ; GFX9:   $vgpr3 = COPY [[UV3]](s32)
  ; GFX9:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3
  ; GFX10-LABEL: name: load_mip_1darray
  ; GFX10: bb.1.main_body:
  ; GFX10:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1
  ; GFX10:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; GFX10:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; GFX10:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; GFX10:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; GFX10:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; GFX10:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; GFX10:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; GFX10:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; GFX10:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; GFX10:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; GFX10:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; GFX10:   [[COPY10:%[0-9]+]]:_(s32) = COPY [[COPY8]](s32)
  ; GFX10:   [[COPY11:%[0-9]+]]:_(s32) = COPY [[COPY9]](s32)
  ; GFX10:   [[BUILD_VECTOR_TRUNC:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR_TRUNC [[COPY10]](s32), [[COPY11]](s32)
  ; GFX10:   [[AMDGPU_INTRIN_IMAGE_LOAD:%[0-9]+]]:_(<4 x s32>) = G_AMDGPU_INTRIN_IMAGE_LOAD intrinsic(@llvm.amdgcn.image.load.mip.1darray), 15, [[BUILD_VECTOR_TRUNC]](<2 x s16>), $noreg, 0, [[BUILD_VECTOR]](<8 x s32>), 0, 0, 3 :: (dereferenceable load (<4 x s32>) from custom "ImageResource")
  ; GFX10:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32), [[UV2:%[0-9]+]]:_(s32), [[UV3:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[AMDGPU_INTRIN_IMAGE_LOAD]](<4 x s32>)
  ; GFX10:   $vgpr0 = COPY [[UV]](s32)
  ; GFX10:   $vgpr1 = COPY [[UV1]](s32)
  ; GFX10:   $vgpr2 = COPY [[UV2]](s32)
  ; GFX10:   $vgpr3 = COPY [[UV3]](s32)
  ; GFX10:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3
main_body:
  %v = call <4 x float> @llvm.amdgcn.image.load.mip.1darray.v4f32.i16(i32 15, i16 %s, i16 %t, i16 0, <8 x i32> %rsrc, i32 0, i32 0)
  ret <4 x float> %v
}

define amdgpu_ps <4 x float> @load_mip_2darray(<8 x i32> inreg %rsrc, i16 %s, i16 %t, i16 %u) {
  ; GFX9-LABEL: name: load_mip_2darray
  ; GFX9: bb.1.main_body:
  ; GFX9:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1, $vgpr2
  ; GFX9:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; GFX9:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; GFX9:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; GFX9:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; GFX9:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; GFX9:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; GFX9:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; GFX9:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; GFX9:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; GFX9:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; GFX9:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; GFX9:   [[COPY10:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; GFX9:   [[COPY11:%[0-9]+]]:_(s32) = COPY [[COPY8]](s32)
  ; GFX9:   [[COPY12:%[0-9]+]]:_(s32) = COPY [[COPY9]](s32)
  ; GFX9:   [[BUILD_VECTOR_TRUNC:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR_TRUNC [[COPY11]](s32), [[COPY12]](s32)
  ; GFX9:   [[COPY13:%[0-9]+]]:_(s32) = COPY [[COPY10]](s32)
  ; GFX9:   [[DEF:%[0-9]+]]:_(s32) = G_IMPLICIT_DEF
  ; GFX9:   [[BUILD_VECTOR_TRUNC1:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR_TRUNC [[COPY13]](s32), [[DEF]](s32)
  ; GFX9:   [[CONCAT_VECTORS:%[0-9]+]]:_(<4 x s16>) = G_CONCAT_VECTORS [[BUILD_VECTOR_TRUNC]](<2 x s16>), [[BUILD_VECTOR_TRUNC1]](<2 x s16>)
  ; GFX9:   [[AMDGPU_INTRIN_IMAGE_LOAD:%[0-9]+]]:_(<4 x s32>) = G_AMDGPU_INTRIN_IMAGE_LOAD intrinsic(@llvm.amdgcn.image.load.mip.2darray), 15, [[CONCAT_VECTORS]](<4 x s16>), $noreg, $noreg, 0, [[BUILD_VECTOR]](<8 x s32>), 0, 0, 3 :: (dereferenceable load (<4 x s32>) from custom "ImageResource")
  ; GFX9:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32), [[UV2:%[0-9]+]]:_(s32), [[UV3:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[AMDGPU_INTRIN_IMAGE_LOAD]](<4 x s32>)
  ; GFX9:   $vgpr0 = COPY [[UV]](s32)
  ; GFX9:   $vgpr1 = COPY [[UV1]](s32)
  ; GFX9:   $vgpr2 = COPY [[UV2]](s32)
  ; GFX9:   $vgpr3 = COPY [[UV3]](s32)
  ; GFX9:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3
  ; GFX10-LABEL: name: load_mip_2darray
  ; GFX10: bb.1.main_body:
  ; GFX10:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1, $vgpr2
  ; GFX10:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; GFX10:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; GFX10:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; GFX10:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; GFX10:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; GFX10:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; GFX10:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; GFX10:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; GFX10:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; GFX10:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; GFX10:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; GFX10:   [[COPY10:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; GFX10:   [[COPY11:%[0-9]+]]:_(s32) = COPY [[COPY8]](s32)
  ; GFX10:   [[COPY12:%[0-9]+]]:_(s32) = COPY [[COPY9]](s32)
  ; GFX10:   [[BUILD_VECTOR_TRUNC:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR_TRUNC [[COPY11]](s32), [[COPY12]](s32)
  ; GFX10:   [[COPY13:%[0-9]+]]:_(s32) = COPY [[COPY10]](s32)
  ; GFX10:   [[DEF:%[0-9]+]]:_(s32) = G_IMPLICIT_DEF
  ; GFX10:   [[BUILD_VECTOR_TRUNC1:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR_TRUNC [[COPY13]](s32), [[DEF]](s32)
  ; GFX10:   [[CONCAT_VECTORS:%[0-9]+]]:_(<4 x s16>) = G_CONCAT_VECTORS [[BUILD_VECTOR_TRUNC]](<2 x s16>), [[BUILD_VECTOR_TRUNC1]](<2 x s16>)
  ; GFX10:   [[AMDGPU_INTRIN_IMAGE_LOAD:%[0-9]+]]:_(<4 x s32>) = G_AMDGPU_INTRIN_IMAGE_LOAD intrinsic(@llvm.amdgcn.image.load.mip.2darray), 15, [[CONCAT_VECTORS]](<4 x s16>), $noreg, $noreg, 0, [[BUILD_VECTOR]](<8 x s32>), 0, 0, 3 :: (dereferenceable load (<4 x s32>) from custom "ImageResource")
  ; GFX10:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32), [[UV2:%[0-9]+]]:_(s32), [[UV3:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[AMDGPU_INTRIN_IMAGE_LOAD]](<4 x s32>)
  ; GFX10:   $vgpr0 = COPY [[UV]](s32)
  ; GFX10:   $vgpr1 = COPY [[UV1]](s32)
  ; GFX10:   $vgpr2 = COPY [[UV2]](s32)
  ; GFX10:   $vgpr3 = COPY [[UV3]](s32)
  ; GFX10:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3
main_body:
  %v = call <4 x float> @llvm.amdgcn.image.load.mip.2darray.v4f32.i16(i32 15, i16 %s, i16 %t, i16 %u, i16 0, <8 x i32> %rsrc, i32 0, i32 0)
  ret <4 x float> %v
}

define amdgpu_ps <4 x float> @load_mip_cube(<8 x i32> inreg %rsrc, i16 %s, i16 %t, i16 %u) {
  ; GFX9-LABEL: name: load_mip_cube
  ; GFX9: bb.1.main_body:
  ; GFX9:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1, $vgpr2
  ; GFX9:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; GFX9:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; GFX9:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; GFX9:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; GFX9:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; GFX9:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; GFX9:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; GFX9:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; GFX9:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; GFX9:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; GFX9:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; GFX9:   [[COPY10:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; GFX9:   [[COPY11:%[0-9]+]]:_(s32) = COPY [[COPY8]](s32)
  ; GFX9:   [[COPY12:%[0-9]+]]:_(s32) = COPY [[COPY9]](s32)
  ; GFX9:   [[BUILD_VECTOR_TRUNC:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR_TRUNC [[COPY11]](s32), [[COPY12]](s32)
  ; GFX9:   [[COPY13:%[0-9]+]]:_(s32) = COPY [[COPY10]](s32)
  ; GFX9:   [[DEF:%[0-9]+]]:_(s32) = G_IMPLICIT_DEF
  ; GFX9:   [[BUILD_VECTOR_TRUNC1:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR_TRUNC [[COPY13]](s32), [[DEF]](s32)
  ; GFX9:   [[CONCAT_VECTORS:%[0-9]+]]:_(<4 x s16>) = G_CONCAT_VECTORS [[BUILD_VECTOR_TRUNC]](<2 x s16>), [[BUILD_VECTOR_TRUNC1]](<2 x s16>)
  ; GFX9:   [[AMDGPU_INTRIN_IMAGE_LOAD:%[0-9]+]]:_(<4 x s32>) = G_AMDGPU_INTRIN_IMAGE_LOAD intrinsic(@llvm.amdgcn.image.load.mip.cube), 15, [[CONCAT_VECTORS]](<4 x s16>), $noreg, $noreg, 0, [[BUILD_VECTOR]](<8 x s32>), 0, 0, 3 :: (dereferenceable load (<4 x s32>) from custom "ImageResource")
  ; GFX9:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32), [[UV2:%[0-9]+]]:_(s32), [[UV3:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[AMDGPU_INTRIN_IMAGE_LOAD]](<4 x s32>)
  ; GFX9:   $vgpr0 = COPY [[UV]](s32)
  ; GFX9:   $vgpr1 = COPY [[UV1]](s32)
  ; GFX9:   $vgpr2 = COPY [[UV2]](s32)
  ; GFX9:   $vgpr3 = COPY [[UV3]](s32)
  ; GFX9:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3
  ; GFX10-LABEL: name: load_mip_cube
  ; GFX10: bb.1.main_body:
  ; GFX10:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1, $vgpr2
  ; GFX10:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; GFX10:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; GFX10:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; GFX10:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; GFX10:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; GFX10:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; GFX10:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; GFX10:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; GFX10:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; GFX10:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; GFX10:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; GFX10:   [[COPY10:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; GFX10:   [[COPY11:%[0-9]+]]:_(s32) = COPY [[COPY8]](s32)
  ; GFX10:   [[COPY12:%[0-9]+]]:_(s32) = COPY [[COPY9]](s32)
  ; GFX10:   [[BUILD_VECTOR_TRUNC:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR_TRUNC [[COPY11]](s32), [[COPY12]](s32)
  ; GFX10:   [[COPY13:%[0-9]+]]:_(s32) = COPY [[COPY10]](s32)
  ; GFX10:   [[DEF:%[0-9]+]]:_(s32) = G_IMPLICIT_DEF
  ; GFX10:   [[BUILD_VECTOR_TRUNC1:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR_TRUNC [[COPY13]](s32), [[DEF]](s32)
  ; GFX10:   [[CONCAT_VECTORS:%[0-9]+]]:_(<4 x s16>) = G_CONCAT_VECTORS [[BUILD_VECTOR_TRUNC]](<2 x s16>), [[BUILD_VECTOR_TRUNC1]](<2 x s16>)
  ; GFX10:   [[AMDGPU_INTRIN_IMAGE_LOAD:%[0-9]+]]:_(<4 x s32>) = G_AMDGPU_INTRIN_IMAGE_LOAD intrinsic(@llvm.amdgcn.image.load.mip.cube), 15, [[CONCAT_VECTORS]](<4 x s16>), $noreg, $noreg, 0, [[BUILD_VECTOR]](<8 x s32>), 0, 0, 3 :: (dereferenceable load (<4 x s32>) from custom "ImageResource")
  ; GFX10:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32), [[UV2:%[0-9]+]]:_(s32), [[UV3:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[AMDGPU_INTRIN_IMAGE_LOAD]](<4 x s32>)
  ; GFX10:   $vgpr0 = COPY [[UV]](s32)
  ; GFX10:   $vgpr1 = COPY [[UV1]](s32)
  ; GFX10:   $vgpr2 = COPY [[UV2]](s32)
  ; GFX10:   $vgpr3 = COPY [[UV3]](s32)
  ; GFX10:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3
main_body:
  %v = call <4 x float> @llvm.amdgcn.image.load.mip.cube.v4f32.i16(i32 15, i16 %s, i16 %t, i16 %u, i16 0, <8 x i32> %rsrc, i32 0, i32 0)
  ret <4 x float> %v
}

define amdgpu_ps void @store_mip_1d(<8 x i32> inreg %rsrc, <4 x float> %vdata, i16 %s) {
  ; GFX9-LABEL: name: store_mip_1d
  ; GFX9: bb.1.main_body:
  ; GFX9:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4
  ; GFX9:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; GFX9:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; GFX9:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; GFX9:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; GFX9:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; GFX9:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; GFX9:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; GFX9:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; GFX9:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; GFX9:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; GFX9:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; GFX9:   [[COPY10:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; GFX9:   [[COPY11:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; GFX9:   [[BUILD_VECTOR1:%[0-9]+]]:_(<4 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32), [[COPY10]](s32), [[COPY11]](s32)
  ; GFX9:   [[COPY12:%[0-9]+]]:_(s32) = COPY $vgpr4
  ; GFX9:   [[COPY13:%[0-9]+]]:_(s32) = COPY [[COPY12]](s32)
  ; GFX9:   [[DEF:%[0-9]+]]:_(s32) = G_IMPLICIT_DEF
  ; GFX9:   [[BUILD_VECTOR_TRUNC:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR_TRUNC [[COPY13]](s32), [[DEF]](s32)
  ; GFX9:   G_AMDGPU_INTRIN_IMAGE_STORE intrinsic(@llvm.amdgcn.image.store.mip.1d), [[BUILD_VECTOR1]](<4 x s32>), 15, [[BUILD_VECTOR_TRUNC]](<2 x s16>), 0, [[BUILD_VECTOR]](<8 x s32>), 0, 0, 3 :: (dereferenceable store (<4 x s32>) into custom "ImageResource")
  ; GFX9:   S_ENDPGM 0
  ; GFX10-LABEL: name: store_mip_1d
  ; GFX10: bb.1.main_body:
  ; GFX10:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4
  ; GFX10:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; GFX10:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; GFX10:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; GFX10:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; GFX10:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; GFX10:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; GFX10:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; GFX10:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; GFX10:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; GFX10:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; GFX10:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; GFX10:   [[COPY10:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; GFX10:   [[COPY11:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; GFX10:   [[BUILD_VECTOR1:%[0-9]+]]:_(<4 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32), [[COPY10]](s32), [[COPY11]](s32)
  ; GFX10:   [[COPY12:%[0-9]+]]:_(s32) = COPY $vgpr4
  ; GFX10:   [[COPY13:%[0-9]+]]:_(s32) = COPY [[COPY12]](s32)
  ; GFX10:   [[DEF:%[0-9]+]]:_(s32) = G_IMPLICIT_DEF
  ; GFX10:   [[BUILD_VECTOR_TRUNC:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR_TRUNC [[COPY13]](s32), [[DEF]](s32)
  ; GFX10:   G_AMDGPU_INTRIN_IMAGE_STORE intrinsic(@llvm.amdgcn.image.store.mip.1d), [[BUILD_VECTOR1]](<4 x s32>), 15, [[BUILD_VECTOR_TRUNC]](<2 x s16>), 0, [[BUILD_VECTOR]](<8 x s32>), 0, 0, 3 :: (dereferenceable store (<4 x s32>) into custom "ImageResource")
  ; GFX10:   S_ENDPGM 0
main_body:
  call void @llvm.amdgcn.image.store.mip.1d.v4f32.i16(<4 x float> %vdata, i32 15, i16 %s, i16 0, <8 x i32> %rsrc, i32 0, i32 0)
  ret void
}

define amdgpu_ps void @store_mip_2d(<8 x i32> inreg %rsrc, <4 x float> %vdata, i16 %s, i16 %t) {
  ; GFX9-LABEL: name: store_mip_2d
  ; GFX9: bb.1.main_body:
  ; GFX9:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4, $vgpr5
  ; GFX9:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; GFX9:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; GFX9:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; GFX9:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; GFX9:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; GFX9:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; GFX9:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; GFX9:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; GFX9:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; GFX9:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; GFX9:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; GFX9:   [[COPY10:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; GFX9:   [[COPY11:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; GFX9:   [[BUILD_VECTOR1:%[0-9]+]]:_(<4 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32), [[COPY10]](s32), [[COPY11]](s32)
  ; GFX9:   [[COPY12:%[0-9]+]]:_(s32) = COPY $vgpr4
  ; GFX9:   [[COPY13:%[0-9]+]]:_(s32) = COPY $vgpr5
  ; GFX9:   [[COPY14:%[0-9]+]]:_(s32) = COPY [[COPY12]](s32)
  ; GFX9:   [[COPY15:%[0-9]+]]:_(s32) = COPY [[COPY13]](s32)
  ; GFX9:   [[BUILD_VECTOR_TRUNC:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR_TRUNC [[COPY14]](s32), [[COPY15]](s32)
  ; GFX9:   G_AMDGPU_INTRIN_IMAGE_STORE intrinsic(@llvm.amdgcn.image.store.mip.2d), [[BUILD_VECTOR1]](<4 x s32>), 15, [[BUILD_VECTOR_TRUNC]](<2 x s16>), $noreg, 0, [[BUILD_VECTOR]](<8 x s32>), 0, 0, 3 :: (dereferenceable store (<4 x s32>) into custom "ImageResource")
  ; GFX9:   S_ENDPGM 0
  ; GFX10-LABEL: name: store_mip_2d
  ; GFX10: bb.1.main_body:
  ; GFX10:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4, $vgpr5
  ; GFX10:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; GFX10:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; GFX10:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; GFX10:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; GFX10:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; GFX10:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; GFX10:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; GFX10:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; GFX10:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; GFX10:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; GFX10:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; GFX10:   [[COPY10:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; GFX10:   [[COPY11:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; GFX10:   [[BUILD_VECTOR1:%[0-9]+]]:_(<4 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32), [[COPY10]](s32), [[COPY11]](s32)
  ; GFX10:   [[COPY12:%[0-9]+]]:_(s32) = COPY $vgpr4
  ; GFX10:   [[COPY13:%[0-9]+]]:_(s32) = COPY $vgpr5
  ; GFX10:   [[COPY14:%[0-9]+]]:_(s32) = COPY [[COPY12]](s32)
  ; GFX10:   [[COPY15:%[0-9]+]]:_(s32) = COPY [[COPY13]](s32)
  ; GFX10:   [[BUILD_VECTOR_TRUNC:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR_TRUNC [[COPY14]](s32), [[COPY15]](s32)
  ; GFX10:   G_AMDGPU_INTRIN_IMAGE_STORE intrinsic(@llvm.amdgcn.image.store.mip.2d), [[BUILD_VECTOR1]](<4 x s32>), 15, [[BUILD_VECTOR_TRUNC]](<2 x s16>), $noreg, 0, [[BUILD_VECTOR]](<8 x s32>), 0, 0, 3 :: (dereferenceable store (<4 x s32>) into custom "ImageResource")
  ; GFX10:   S_ENDPGM 0
main_body:
  call void @llvm.amdgcn.image.store.mip.2d.v4f32.i16(<4 x float> %vdata, i32 15, i16 %s, i16 %t, i16 0, <8 x i32> %rsrc, i32 0, i32 0)
  ret void
}

define amdgpu_ps void @store_mip_3d(<8 x i32> inreg %rsrc, <4 x float> %vdata, i16 %s, i16 %t, i16 %u) {
  ; GFX9-LABEL: name: store_mip_3d
  ; GFX9: bb.1.main_body:
  ; GFX9:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4, $vgpr5, $vgpr6
  ; GFX9:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; GFX9:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; GFX9:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; GFX9:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; GFX9:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; GFX9:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; GFX9:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; GFX9:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; GFX9:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; GFX9:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; GFX9:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; GFX9:   [[COPY10:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; GFX9:   [[COPY11:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; GFX9:   [[BUILD_VECTOR1:%[0-9]+]]:_(<4 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32), [[COPY10]](s32), [[COPY11]](s32)
  ; GFX9:   [[COPY12:%[0-9]+]]:_(s32) = COPY $vgpr4
  ; GFX9:   [[COPY13:%[0-9]+]]:_(s32) = COPY $vgpr5
  ; GFX9:   [[COPY14:%[0-9]+]]:_(s32) = COPY $vgpr6
  ; GFX9:   [[COPY15:%[0-9]+]]:_(s32) = COPY [[COPY12]](s32)
  ; GFX9:   [[COPY16:%[0-9]+]]:_(s32) = COPY [[COPY13]](s32)
  ; GFX9:   [[BUILD_VECTOR_TRUNC:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR_TRUNC [[COPY15]](s32), [[COPY16]](s32)
  ; GFX9:   [[COPY17:%[0-9]+]]:_(s32) = COPY [[COPY14]](s32)
  ; GFX9:   [[DEF:%[0-9]+]]:_(s32) = G_IMPLICIT_DEF
  ; GFX9:   [[BUILD_VECTOR_TRUNC1:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR_TRUNC [[COPY17]](s32), [[DEF]](s32)
  ; GFX9:   [[CONCAT_VECTORS:%[0-9]+]]:_(<4 x s16>) = G_CONCAT_VECTORS [[BUILD_VECTOR_TRUNC]](<2 x s16>), [[BUILD_VECTOR_TRUNC1]](<2 x s16>)
  ; GFX9:   G_AMDGPU_INTRIN_IMAGE_STORE intrinsic(@llvm.amdgcn.image.store.mip.3d), [[BUILD_VECTOR1]](<4 x s32>), 15, [[CONCAT_VECTORS]](<4 x s16>), $noreg, $noreg, 0, [[BUILD_VECTOR]](<8 x s32>), 0, 0, 3 :: (dereferenceable store (<4 x s32>) into custom "ImageResource")
  ; GFX9:   S_ENDPGM 0
  ; GFX10-LABEL: name: store_mip_3d
  ; GFX10: bb.1.main_body:
  ; GFX10:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4, $vgpr5, $vgpr6
  ; GFX10:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; GFX10:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; GFX10:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; GFX10:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; GFX10:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; GFX10:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; GFX10:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; GFX10:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; GFX10:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; GFX10:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; GFX10:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; GFX10:   [[COPY10:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; GFX10:   [[COPY11:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; GFX10:   [[BUILD_VECTOR1:%[0-9]+]]:_(<4 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32), [[COPY10]](s32), [[COPY11]](s32)
  ; GFX10:   [[COPY12:%[0-9]+]]:_(s32) = COPY $vgpr4
  ; GFX10:   [[COPY13:%[0-9]+]]:_(s32) = COPY $vgpr5
  ; GFX10:   [[COPY14:%[0-9]+]]:_(s32) = COPY $vgpr6
  ; GFX10:   [[COPY15:%[0-9]+]]:_(s32) = COPY [[COPY12]](s32)
  ; GFX10:   [[COPY16:%[0-9]+]]:_(s32) = COPY [[COPY13]](s32)
  ; GFX10:   [[BUILD_VECTOR_TRUNC:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR_TRUNC [[COPY15]](s32), [[COPY16]](s32)
  ; GFX10:   [[COPY17:%[0-9]+]]:_(s32) = COPY [[COPY14]](s32)
  ; GFX10:   [[DEF:%[0-9]+]]:_(s32) = G_IMPLICIT_DEF
  ; GFX10:   [[BUILD_VECTOR_TRUNC1:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR_TRUNC [[COPY17]](s32), [[DEF]](s32)
  ; GFX10:   [[CONCAT_VECTORS:%[0-9]+]]:_(<4 x s16>) = G_CONCAT_VECTORS [[BUILD_VECTOR_TRUNC]](<2 x s16>), [[BUILD_VECTOR_TRUNC1]](<2 x s16>)
  ; GFX10:   G_AMDGPU_INTRIN_IMAGE_STORE intrinsic(@llvm.amdgcn.image.store.mip.3d), [[BUILD_VECTOR1]](<4 x s32>), 15, [[CONCAT_VECTORS]](<4 x s16>), $noreg, $noreg, 0, [[BUILD_VECTOR]](<8 x s32>), 0, 0, 3 :: (dereferenceable store (<4 x s32>) into custom "ImageResource")
  ; GFX10:   S_ENDPGM 0
main_body:
  call void @llvm.amdgcn.image.store.mip.3d.v4f32.i16(<4 x float> %vdata, i32 15, i16 %s, i16 %t, i16 %u, i16 0, <8 x i32> %rsrc, i32 0, i32 0)
  ret void
}

define amdgpu_ps void @store_mip_1darray(<8 x i32> inreg %rsrc, <4 x float> %vdata, i16 %s, i16 %t) {
  ; GFX9-LABEL: name: store_mip_1darray
  ; GFX9: bb.1.main_body:
  ; GFX9:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4, $vgpr5
  ; GFX9:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; GFX9:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; GFX9:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; GFX9:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; GFX9:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; GFX9:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; GFX9:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; GFX9:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; GFX9:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; GFX9:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; GFX9:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; GFX9:   [[COPY10:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; GFX9:   [[COPY11:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; GFX9:   [[BUILD_VECTOR1:%[0-9]+]]:_(<4 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32), [[COPY10]](s32), [[COPY11]](s32)
  ; GFX9:   [[COPY12:%[0-9]+]]:_(s32) = COPY $vgpr4
  ; GFX9:   [[COPY13:%[0-9]+]]:_(s32) = COPY $vgpr5
  ; GFX9:   [[COPY14:%[0-9]+]]:_(s32) = COPY [[COPY12]](s32)
  ; GFX9:   [[COPY15:%[0-9]+]]:_(s32) = COPY [[COPY13]](s32)
  ; GFX9:   [[BUILD_VECTOR_TRUNC:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR_TRUNC [[COPY14]](s32), [[COPY15]](s32)
  ; GFX9:   G_AMDGPU_INTRIN_IMAGE_STORE intrinsic(@llvm.amdgcn.image.store.mip.1darray), [[BUILD_VECTOR1]](<4 x s32>), 15, [[BUILD_VECTOR_TRUNC]](<2 x s16>), $noreg, 0, [[BUILD_VECTOR]](<8 x s32>), 0, 0, 3 :: (dereferenceable store (<4 x s32>) into custom "ImageResource")
  ; GFX9:   S_ENDPGM 0
  ; GFX10-LABEL: name: store_mip_1darray
  ; GFX10: bb.1.main_body:
  ; GFX10:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4, $vgpr5
  ; GFX10:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; GFX10:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; GFX10:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; GFX10:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; GFX10:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; GFX10:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; GFX10:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; GFX10:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; GFX10:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; GFX10:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; GFX10:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; GFX10:   [[COPY10:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; GFX10:   [[COPY11:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; GFX10:   [[BUILD_VECTOR1:%[0-9]+]]:_(<4 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32), [[COPY10]](s32), [[COPY11]](s32)
  ; GFX10:   [[COPY12:%[0-9]+]]:_(s32) = COPY $vgpr4
  ; GFX10:   [[COPY13:%[0-9]+]]:_(s32) = COPY $vgpr5
  ; GFX10:   [[COPY14:%[0-9]+]]:_(s32) = COPY [[COPY12]](s32)
  ; GFX10:   [[COPY15:%[0-9]+]]:_(s32) = COPY [[COPY13]](s32)
  ; GFX10:   [[BUILD_VECTOR_TRUNC:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR_TRUNC [[COPY14]](s32), [[COPY15]](s32)
  ; GFX10:   G_AMDGPU_INTRIN_IMAGE_STORE intrinsic(@llvm.amdgcn.image.store.mip.1darray), [[BUILD_VECTOR1]](<4 x s32>), 15, [[BUILD_VECTOR_TRUNC]](<2 x s16>), $noreg, 0, [[BUILD_VECTOR]](<8 x s32>), 0, 0, 3 :: (dereferenceable store (<4 x s32>) into custom "ImageResource")
  ; GFX10:   S_ENDPGM 0
main_body:
  call void @llvm.amdgcn.image.store.mip.1darray.v4f32.i16(<4 x float> %vdata, i32 15, i16 %s, i16 %t, i16 0, <8 x i32> %rsrc, i32 0, i32 0)
  ret void
}

define amdgpu_ps void @store_mip_2darray(<8 x i32> inreg %rsrc, <4 x float> %vdata, i16 %s, i16 %t, i16 %u) {
  ; GFX9-LABEL: name: store_mip_2darray
  ; GFX9: bb.1.main_body:
  ; GFX9:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4, $vgpr5, $vgpr6
  ; GFX9:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; GFX9:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; GFX9:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; GFX9:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; GFX9:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; GFX9:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; GFX9:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; GFX9:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; GFX9:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; GFX9:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; GFX9:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; GFX9:   [[COPY10:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; GFX9:   [[COPY11:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; GFX9:   [[BUILD_VECTOR1:%[0-9]+]]:_(<4 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32), [[COPY10]](s32), [[COPY11]](s32)
  ; GFX9:   [[COPY12:%[0-9]+]]:_(s32) = COPY $vgpr4
  ; GFX9:   [[COPY13:%[0-9]+]]:_(s32) = COPY $vgpr5
  ; GFX9:   [[COPY14:%[0-9]+]]:_(s32) = COPY $vgpr6
  ; GFX9:   [[COPY15:%[0-9]+]]:_(s32) = COPY [[COPY12]](s32)
  ; GFX9:   [[COPY16:%[0-9]+]]:_(s32) = COPY [[COPY13]](s32)
  ; GFX9:   [[BUILD_VECTOR_TRUNC:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR_TRUNC [[COPY15]](s32), [[COPY16]](s32)
  ; GFX9:   [[COPY17:%[0-9]+]]:_(s32) = COPY [[COPY14]](s32)
  ; GFX9:   [[DEF:%[0-9]+]]:_(s32) = G_IMPLICIT_DEF
  ; GFX9:   [[BUILD_VECTOR_TRUNC1:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR_TRUNC [[COPY17]](s32), [[DEF]](s32)
  ; GFX9:   [[CONCAT_VECTORS:%[0-9]+]]:_(<4 x s16>) = G_CONCAT_VECTORS [[BUILD_VECTOR_TRUNC]](<2 x s16>), [[BUILD_VECTOR_TRUNC1]](<2 x s16>)
  ; GFX9:   G_AMDGPU_INTRIN_IMAGE_STORE intrinsic(@llvm.amdgcn.image.store.mip.2darray), [[BUILD_VECTOR1]](<4 x s32>), 15, [[CONCAT_VECTORS]](<4 x s16>), $noreg, $noreg, 0, [[BUILD_VECTOR]](<8 x s32>), 0, 0, 3 :: (dereferenceable store (<4 x s32>) into custom "ImageResource")
  ; GFX9:   S_ENDPGM 0
  ; GFX10-LABEL: name: store_mip_2darray
  ; GFX10: bb.1.main_body:
  ; GFX10:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4, $vgpr5, $vgpr6
  ; GFX10:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; GFX10:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; GFX10:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; GFX10:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; GFX10:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; GFX10:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; GFX10:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; GFX10:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; GFX10:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; GFX10:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; GFX10:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; GFX10:   [[COPY10:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; GFX10:   [[COPY11:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; GFX10:   [[BUILD_VECTOR1:%[0-9]+]]:_(<4 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32), [[COPY10]](s32), [[COPY11]](s32)
  ; GFX10:   [[COPY12:%[0-9]+]]:_(s32) = COPY $vgpr4
  ; GFX10:   [[COPY13:%[0-9]+]]:_(s32) = COPY $vgpr5
  ; GFX10:   [[COPY14:%[0-9]+]]:_(s32) = COPY $vgpr6
  ; GFX10:   [[COPY15:%[0-9]+]]:_(s32) = COPY [[COPY12]](s32)
  ; GFX10:   [[COPY16:%[0-9]+]]:_(s32) = COPY [[COPY13]](s32)
  ; GFX10:   [[BUILD_VECTOR_TRUNC:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR_TRUNC [[COPY15]](s32), [[COPY16]](s32)
  ; GFX10:   [[COPY17:%[0-9]+]]:_(s32) = COPY [[COPY14]](s32)
  ; GFX10:   [[DEF:%[0-9]+]]:_(s32) = G_IMPLICIT_DEF
  ; GFX10:   [[BUILD_VECTOR_TRUNC1:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR_TRUNC [[COPY17]](s32), [[DEF]](s32)
  ; GFX10:   [[CONCAT_VECTORS:%[0-9]+]]:_(<4 x s16>) = G_CONCAT_VECTORS [[BUILD_VECTOR_TRUNC]](<2 x s16>), [[BUILD_VECTOR_TRUNC1]](<2 x s16>)
  ; GFX10:   G_AMDGPU_INTRIN_IMAGE_STORE intrinsic(@llvm.amdgcn.image.store.mip.2darray), [[BUILD_VECTOR1]](<4 x s32>), 15, [[CONCAT_VECTORS]](<4 x s16>), $noreg, $noreg, 0, [[BUILD_VECTOR]](<8 x s32>), 0, 0, 3 :: (dereferenceable store (<4 x s32>) into custom "ImageResource")
  ; GFX10:   S_ENDPGM 0
main_body:
  call void @llvm.amdgcn.image.store.mip.2darray.v4f32.i16(<4 x float> %vdata, i32 15, i16 %s, i16 %t, i16 %u, i16 0, <8 x i32> %rsrc, i32 0, i32 0)
  ret void
}

define amdgpu_ps void @store_mip_cube(<8 x i32> inreg %rsrc, <4 x float> %vdata, i16 %s, i16 %t, i16 %u) {
  ; GFX9-LABEL: name: store_mip_cube
  ; GFX9: bb.1.main_body:
  ; GFX9:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4, $vgpr5, $vgpr6
  ; GFX9:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; GFX9:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; GFX9:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; GFX9:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; GFX9:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; GFX9:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; GFX9:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; GFX9:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; GFX9:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; GFX9:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; GFX9:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; GFX9:   [[COPY10:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; GFX9:   [[COPY11:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; GFX9:   [[BUILD_VECTOR1:%[0-9]+]]:_(<4 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32), [[COPY10]](s32), [[COPY11]](s32)
  ; GFX9:   [[COPY12:%[0-9]+]]:_(s32) = COPY $vgpr4
  ; GFX9:   [[COPY13:%[0-9]+]]:_(s32) = COPY $vgpr5
  ; GFX9:   [[COPY14:%[0-9]+]]:_(s32) = COPY $vgpr6
  ; GFX9:   [[COPY15:%[0-9]+]]:_(s32) = COPY [[COPY12]](s32)
  ; GFX9:   [[COPY16:%[0-9]+]]:_(s32) = COPY [[COPY13]](s32)
  ; GFX9:   [[BUILD_VECTOR_TRUNC:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR_TRUNC [[COPY15]](s32), [[COPY16]](s32)
  ; GFX9:   [[COPY17:%[0-9]+]]:_(s32) = COPY [[COPY14]](s32)
  ; GFX9:   [[DEF:%[0-9]+]]:_(s32) = G_IMPLICIT_DEF
  ; GFX9:   [[BUILD_VECTOR_TRUNC1:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR_TRUNC [[COPY17]](s32), [[DEF]](s32)
  ; GFX9:   [[CONCAT_VECTORS:%[0-9]+]]:_(<4 x s16>) = G_CONCAT_VECTORS [[BUILD_VECTOR_TRUNC]](<2 x s16>), [[BUILD_VECTOR_TRUNC1]](<2 x s16>)
  ; GFX9:   G_AMDGPU_INTRIN_IMAGE_STORE intrinsic(@llvm.amdgcn.image.store.mip.cube), [[BUILD_VECTOR1]](<4 x s32>), 15, [[CONCAT_VECTORS]](<4 x s16>), $noreg, $noreg, 0, [[BUILD_VECTOR]](<8 x s32>), 0, 0, 3 :: (dereferenceable store (<4 x s32>) into custom "ImageResource")
  ; GFX9:   S_ENDPGM 0
  ; GFX10-LABEL: name: store_mip_cube
  ; GFX10: bb.1.main_body:
  ; GFX10:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4, $vgpr5, $vgpr6
  ; GFX10:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; GFX10:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; GFX10:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; GFX10:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; GFX10:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; GFX10:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; GFX10:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; GFX10:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; GFX10:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; GFX10:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; GFX10:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; GFX10:   [[COPY10:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; GFX10:   [[COPY11:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; GFX10:   [[BUILD_VECTOR1:%[0-9]+]]:_(<4 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32), [[COPY10]](s32), [[COPY11]](s32)
  ; GFX10:   [[COPY12:%[0-9]+]]:_(s32) = COPY $vgpr4
  ; GFX10:   [[COPY13:%[0-9]+]]:_(s32) = COPY $vgpr5
  ; GFX10:   [[COPY14:%[0-9]+]]:_(s32) = COPY $vgpr6
  ; GFX10:   [[COPY15:%[0-9]+]]:_(s32) = COPY [[COPY12]](s32)
  ; GFX10:   [[COPY16:%[0-9]+]]:_(s32) = COPY [[COPY13]](s32)
  ; GFX10:   [[BUILD_VECTOR_TRUNC:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR_TRUNC [[COPY15]](s32), [[COPY16]](s32)
  ; GFX10:   [[COPY17:%[0-9]+]]:_(s32) = COPY [[COPY14]](s32)
  ; GFX10:   [[DEF:%[0-9]+]]:_(s32) = G_IMPLICIT_DEF
  ; GFX10:   [[BUILD_VECTOR_TRUNC1:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR_TRUNC [[COPY17]](s32), [[DEF]](s32)
  ; GFX10:   [[CONCAT_VECTORS:%[0-9]+]]:_(<4 x s16>) = G_CONCAT_VECTORS [[BUILD_VECTOR_TRUNC]](<2 x s16>), [[BUILD_VECTOR_TRUNC1]](<2 x s16>)
  ; GFX10:   G_AMDGPU_INTRIN_IMAGE_STORE intrinsic(@llvm.amdgcn.image.store.mip.cube), [[BUILD_VECTOR1]](<4 x s32>), 15, [[CONCAT_VECTORS]](<4 x s16>), $noreg, $noreg, 0, [[BUILD_VECTOR]](<8 x s32>), 0, 0, 3 :: (dereferenceable store (<4 x s32>) into custom "ImageResource")
  ; GFX10:   S_ENDPGM 0
main_body:
  call void @llvm.amdgcn.image.store.mip.cube.v4f32.i16(<4 x float> %vdata, i32 15, i16 %s, i16 %t, i16 %u, i16 0, <8 x i32> %rsrc, i32 0, i32 0)
  ret void
}

declare <4 x float> @llvm.amdgcn.image.load.mip.1d.v4f32.i16(i32 immarg, i16, i16, <8 x i32>, i32 immarg, i32 immarg) #0
declare <4 x float> @llvm.amdgcn.image.load.mip.2d.v4f32.i16(i32 immarg, i16, i16, i16, <8 x i32>, i32 immarg, i32 immarg) #0
declare <4 x float> @llvm.amdgcn.image.load.mip.3d.v4f32.i16(i32 immarg, i16, i16, i16, i16, <8 x i32>, i32 immarg, i32 immarg) #0
declare <4 x float> @llvm.amdgcn.image.load.mip.1darray.v4f32.i16(i32 immarg, i16, i16, i16, <8 x i32>, i32 immarg, i32 immarg) #0
declare <4 x float> @llvm.amdgcn.image.load.mip.2darray.v4f32.i16(i32 immarg, i16, i16, i16, i16, <8 x i32>, i32 immarg, i32 immarg) #0
declare <4 x float> @llvm.amdgcn.image.load.mip.cube.v4f32.i16(i32 immarg, i16, i16, i16, i16, <8 x i32>, i32 immarg, i32 immarg) #0
declare void @llvm.amdgcn.image.store.mip.1d.v4f32.i16(<4 x float>, i32 immarg, i16, i16, <8 x i32>, i32 immarg, i32 immarg) #1
declare void @llvm.amdgcn.image.store.mip.2d.v4f32.i16(<4 x float>, i32 immarg, i16, i16, i16, <8 x i32>, i32 immarg, i32 immarg) #1
declare void @llvm.amdgcn.image.store.mip.3d.v4f32.i16(<4 x float>, i32 immarg, i16, i16, i16, i16, <8 x i32>, i32 immarg, i32 immarg) #1
declare void @llvm.amdgcn.image.store.mip.cube.v4f32.i16(<4 x float>, i32 immarg, i16, i16, i16, i16, <8 x i32>, i32 immarg, i32 immarg) #1
declare void @llvm.amdgcn.image.store.mip.1darray.v4f32.i16(<4 x float>, i32 immarg, i16, i16, i16, <8 x i32>, i32 immarg, i32 immarg) #1
declare void @llvm.amdgcn.image.store.mip.2darray.v4f32.i16(<4 x float>, i32 immarg, i16, i16, i16, i16, <8 x i32>, i32 immarg, i32 immarg) #1

attributes #0 = { nounwind readonly }
attributes #1 = { nounwind writeonly }
