/*
 * Copyright (c) 2009, 2020 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0, which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the
 * Eclipse Public License v. 2.0 are satisfied: GNU General Public License,
 * version 2 with the GNU Classpath Exception, which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 */

/*
 * $Id:$
 */
package servlet.tck.api.jakarta_servlet_http.httpservletrequest30;

import servlet.tck.common.request.HttpRequestClient;
import servlet.tck.common.servlets.CommonServlets;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class HttpServletRequest30Tests extends HttpRequestClient {

  @BeforeEach
  public void setupServletName() throws Exception {
    setServletName("LoginTestServlet");
  }

  /**
   * Deployment for the test
   */
  @Deployment(testable = false)
  public static WebArchive getTestArchive() throws Exception {
    return ShrinkWrap.create(WebArchive.class, "servlet_jsh_httpservletrequest30_web.war")
            .addAsLibraries(CommonServlets.getCommonServletsArchive())
            .addClasses(LoginTestServlet.class)
            .setWebXML(HttpServletRequest30Tests.class.getResource("servlet_jsh_httpservletrequest30_web.xml"));
  }

  /*
   * @class.setup_props: webServerHost; webServerPort; ts_home;
   *
   */

  /* Run test */

  // ---------------------------- HttpServletRequest
  // -----------------------------

  /*
   * @testName: loginTest
   *
   * @assertion_ids: Servlet:JAVADOC:761;
   *
   * @test_Strategy: Send an HttpServletRequest to server; Verify that
   * login(null, null) throw ServletException.
   */
  @Test
  public void loginTest() throws Exception {
    TEST_PROPS.get().setProperty(REQUEST,
        "GET " + getContextRoot() + "/LoginTestServlet HTTP/1.1");
    TEST_PROPS.get().setProperty(UNEXPECTED_RESPONSE_MATCH, "Test FAILED");
    TEST_PROPS.get().setProperty(STATUS_CODE, OK);
    TEST_PROPS.get().setProperty(SEARCH_STRING, "Test PASSED");
    invoke();
  }

  // -------------------------- END HttpServletRequest
  // ---------------------------
}
