/* Code generated by IfcQuery EXPRESS generator, www.ifcquery.com */
#include <sstream>
#include <limits>

#include "ifcpp/model/AttributeObject.h"
#include "ifcpp/model/BuildingException.h"
#include "ifcpp/model/BuildingGuid.h"
#include "ifcpp/reader/ReaderUtil.h"
#include "ifcpp/writer/WriterUtil.h"
#include "ifcpp/IFC4/include/IfcActorRole.h"
#include "ifcpp/IFC4/include/IfcOrganization.h"
#include "ifcpp/IFC4/include/IfcPerson.h"
#include "ifcpp/IFC4/include/IfcPersonAndOrganization.h"

// ENTITY IfcPersonAndOrganization 
IfcPersonAndOrganization::IfcPersonAndOrganization( int id ) { m_entity_id = id; }
IfcPersonAndOrganization::~IfcPersonAndOrganization() {}
shared_ptr<BuildingObject> IfcPersonAndOrganization::getDeepCopy( BuildingCopyOptions& options )
{
	shared_ptr<IfcPersonAndOrganization> copy_self( new IfcPersonAndOrganization() );
	if( m_ThePerson ) { copy_self->m_ThePerson = dynamic_pointer_cast<IfcPerson>( m_ThePerson->getDeepCopy(options) ); }
	if( m_TheOrganization ) { copy_self->m_TheOrganization = dynamic_pointer_cast<IfcOrganization>( m_TheOrganization->getDeepCopy(options) ); }
	for( size_t ii=0; ii<m_Roles.size(); ++ii )
	{
		auto item_ii = m_Roles[ii];
		if( item_ii )
		{
			copy_self->m_Roles.emplace_back( dynamic_pointer_cast<IfcActorRole>(item_ii->getDeepCopy(options) ) );
		}
	}
	return copy_self;
}
void IfcPersonAndOrganization::getStepLine( std::stringstream& stream ) const
{
	stream << "#" << m_entity_id << "= IFCPERSONANDORGANIZATION" << "(";
	if( m_ThePerson ) { stream << "#" << m_ThePerson->m_entity_id; } else { stream << "$"; }
	stream << ",";
	if( m_TheOrganization ) { stream << "#" << m_TheOrganization->m_entity_id; } else { stream << "$"; }
	stream << ",";
	writeEntityList( stream, m_Roles );
	stream << ");";
}
void IfcPersonAndOrganization::getStepParameter( std::stringstream& stream, bool ) const { stream << "#" << m_entity_id; }
const std::wstring IfcPersonAndOrganization::toString() const { return L"IfcPersonAndOrganization"; }
void IfcPersonAndOrganization::readStepArguments( const std::vector<std::wstring>& args, const std::map<int,shared_ptr<BuildingEntity> >& map )
{
	const size_t num_args = args.size();
	if( num_args != 3 ){ std::stringstream err; err << "Wrong parameter count for entity IfcPersonAndOrganization, expecting 3, having " << num_args << ". Entity ID: " << m_entity_id << std::endl; throw BuildingException( err.str().c_str() ); }
	readEntityReference( args[0], m_ThePerson, map );
	readEntityReference( args[1], m_TheOrganization, map );
	readEntityReferenceList( args[2], m_Roles, map );
}
void IfcPersonAndOrganization::getAttributes( std::vector<std::pair<std::string, shared_ptr<BuildingObject> > >& vec_attributes ) const
{
	vec_attributes.emplace_back( std::make_pair( "ThePerson", m_ThePerson ) );
	vec_attributes.emplace_back( std::make_pair( "TheOrganization", m_TheOrganization ) );
	if( !m_Roles.empty() )
	{
		shared_ptr<AttributeObjectVector> Roles_vec_object( new AttributeObjectVector() );
		std::copy( m_Roles.begin(), m_Roles.end(), std::back_inserter( Roles_vec_object->m_vec ) );
		vec_attributes.emplace_back( std::make_pair( "Roles", Roles_vec_object ) );
	}
}
void IfcPersonAndOrganization::getAttributesInverse( std::vector<std::pair<std::string, shared_ptr<BuildingObject> > >& vec_attributes_inverse ) const
{
}
void IfcPersonAndOrganization::setInverseCounterparts( shared_ptr<BuildingEntity> ptr_self_entity )
{
	shared_ptr<IfcPersonAndOrganization> ptr_self = dynamic_pointer_cast<IfcPersonAndOrganization>( ptr_self_entity );
	if( !ptr_self ) { throw BuildingException( "IfcPersonAndOrganization::setInverseCounterparts: type mismatch" ); }
	if( m_TheOrganization )
	{
		m_TheOrganization->m_Engages_inverse.emplace_back( ptr_self );
	}
	if( m_ThePerson )
	{
		m_ThePerson->m_EngagedIn_inverse.emplace_back( ptr_self );
	}
}
void IfcPersonAndOrganization::unlinkFromInverseCounterparts()
{
	if( m_TheOrganization )
	{
		std::vector<weak_ptr<IfcPersonAndOrganization> >& Engages_inverse = m_TheOrganization->m_Engages_inverse;
		for( auto it_Engages_inverse = Engages_inverse.begin(); it_Engages_inverse != Engages_inverse.end(); )
		{
			weak_ptr<IfcPersonAndOrganization> self_candidate_weak = *it_Engages_inverse;
			if( self_candidate_weak.expired() )
			{
				++it_Engages_inverse;
				continue;
			}
			shared_ptr<IfcPersonAndOrganization> self_candidate( *it_Engages_inverse );
			if( self_candidate.get() == this )
			{
				it_Engages_inverse= Engages_inverse.erase( it_Engages_inverse );
			}
			else
			{
				++it_Engages_inverse;
			}
		}
	}
	if( m_ThePerson )
	{
		std::vector<weak_ptr<IfcPersonAndOrganization> >& EngagedIn_inverse = m_ThePerson->m_EngagedIn_inverse;
		for( auto it_EngagedIn_inverse = EngagedIn_inverse.begin(); it_EngagedIn_inverse != EngagedIn_inverse.end(); )
		{
			weak_ptr<IfcPersonAndOrganization> self_candidate_weak = *it_EngagedIn_inverse;
			if( self_candidate_weak.expired() )
			{
				++it_EngagedIn_inverse;
				continue;
			}
			shared_ptr<IfcPersonAndOrganization> self_candidate( *it_EngagedIn_inverse );
			if( self_candidate.get() == this )
			{
				it_EngagedIn_inverse= EngagedIn_inverse.erase( it_EngagedIn_inverse );
			}
			else
			{
				++it_EngagedIn_inverse;
			}
		}
	}
}
