package resourcehealth

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AvailabilityStateValues enumerates the values for availability state values.
type AvailabilityStateValues string

const (
	// AvailabilityStateValuesAvailable ...
	AvailabilityStateValuesAvailable AvailabilityStateValues = "Available"
	// AvailabilityStateValuesDegraded ...
	AvailabilityStateValuesDegraded AvailabilityStateValues = "Degraded"
	// AvailabilityStateValuesUnavailable ...
	AvailabilityStateValuesUnavailable AvailabilityStateValues = "Unavailable"
	// AvailabilityStateValuesUnknown ...
	AvailabilityStateValuesUnknown AvailabilityStateValues = "Unknown"
)

// PossibleAvailabilityStateValuesValues returns an array of possible values for the AvailabilityStateValues const type.
func PossibleAvailabilityStateValuesValues() []AvailabilityStateValues {
	return []AvailabilityStateValues{AvailabilityStateValuesAvailable, AvailabilityStateValuesDegraded, AvailabilityStateValuesUnavailable, AvailabilityStateValuesUnknown}
}

// ReasonChronicityTypes enumerates the values for reason chronicity types.
type ReasonChronicityTypes string

const (
	// ReasonChronicityTypesPersistent ...
	ReasonChronicityTypesPersistent ReasonChronicityTypes = "Persistent"
	// ReasonChronicityTypesTransient ...
	ReasonChronicityTypesTransient ReasonChronicityTypes = "Transient"
)

// PossibleReasonChronicityTypesValues returns an array of possible values for the ReasonChronicityTypes const type.
func PossibleReasonChronicityTypesValues() []ReasonChronicityTypes {
	return []ReasonChronicityTypes{ReasonChronicityTypesPersistent, ReasonChronicityTypesTransient}
}

// ReasonTypeValues enumerates the values for reason type values.
type ReasonTypeValues string

const (
	// ReasonTypeValuesPlanned ...
	ReasonTypeValuesPlanned ReasonTypeValues = "Planned"
	// ReasonTypeValuesUnplanned ...
	ReasonTypeValuesUnplanned ReasonTypeValues = "Unplanned"
	// ReasonTypeValuesUserInitiated ...
	ReasonTypeValuesUserInitiated ReasonTypeValues = "UserInitiated"
)

// PossibleReasonTypeValuesValues returns an array of possible values for the ReasonTypeValues const type.
func PossibleReasonTypeValuesValues() []ReasonTypeValues {
	return []ReasonTypeValues{ReasonTypeValuesPlanned, ReasonTypeValuesUnplanned, ReasonTypeValuesUserInitiated}
}
