static char rcsid[] = "$Id: stage3hr.c 224747 2021-12-04 15:56:44Z twu $";
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "stage3hr.h"
#include "stage3hrdef.h"

#include <stdlib.h>		/* For qsort */
#include <string.h>
#include <strings.h>
#include <ctype.h>		/* For islower */
#include <math.h>		/* For exp() and log10() */
#include "assert.h"
#include "mem.h"
#include "univcoord.h"

#include "chrnum.h"
#include "complement.h"
#include "interval.h"
#include "univdiag.h"
#include "univdiagdef.h"
#include "substring.h"
#include "junction.h"
#include "genome128_hr.h"
#include "mapq.h"
#include "cigar.h"
#include "comp.h"		/* For Stage3end_run_gmap */
#include "maxent_hr.h"
#include "fastlog.h"
#include "transcript.h"
#include "kmer-search.h"
#include "exon.h"


/* Scores for alts_status_inside */
#define ALTS_RESOLVED_BYLENGTH 0
#define ALTS_NOT_AMBIGUOUS 1


/* Eliminates distant splices if short splices are found */
/* #define DISTANT_SPLICE_SPECIAL 1 */

#define CONCORDANT_TEXT "concordant"
#define PAIRED_TEXT "paired"
#define UNPAIRED_TEXT "unpaired"

#ifdef USE_TALLY_RATIO
#define TALLY_RATIO 2.0
#endif

/* #define SUBSUMPTION_SLOP 10 */	/* Should allow for short insert lengths */
#define ADJ_NMATCHES_SLOP 2	/* Corresponds to one mismatch, sacrificing for a better splice score */
#define NMATCHES_SLOP 6
/* #define NMATCHES_TO_TRIMS_SLOP 9 */ /* Looser to allow for different splice options */
#define INSERTLENGTH_SLOP 100
#define OUTERLENGTH_SLOP 1000
#define SPLICE_SCORE_SLOP 0.03

/* #define MIN_ALIGNMENT_LEN 20  -- Now taken care of by min-coverage */

#define SPLICED_END_PENALTY 1		/* For long spliced ends.  Add to score 1 point per each 8 bp */

#if 0
/* Now using a combination of these two factors in spliced_end_p */
#define SPLICED_END_PROB 0.85	/* Adding to spliced_trim if the exon has this prob or more */
#define SPLICED_END_EXONLENGTH 50	/* Adding to spliced_trim if the exon has this length or more */
#endif


/* If we subtract from score, then we can have ref_score_within_trims < 0) */
/*#define NONSPLICED_END_RESTORE 6 */		/* For long spliced ends.  Reduce score by 6 points per each 8 bp */

#define END_BINSIZE 8

#define SCORE_EVENTRIM_SLOP 2
#define SCORE_INDELS_EVENTRIM 1 /* Needed to compare genomic positions with and without indels */
#define EVENTRIM_BADINTRON_PENALTY 2
#define DO_FINAL 1

#define MIN_RESOLVE_TRIMLENGTH 6

#ifdef CHECK_ASSERTIONS
#define CHECK_NMISMATCHES 1
#endif


#if 0
/* This is a bad idea.  Better to use nconcordant as a guide to stopping */
#define MAX_HITS 100		/* For evaluating concordance */
#endif

/* #define USE_ALLOCA_FOR_HITS 1 -- can lead to stack overflow */


/* Stage3end_new */
#ifdef DEBUG0
#define debug0(x) x
#else
#define debug0(x)
#endif

/* Stage3end_filter */
#ifdef DEBUG1
#define debug1(x) x
#else
#define debug1(x)
#endif


/* transcript-guided alignment */
/* May want to turn on debug2 in transcript.c */
#ifdef DEBUG2
#define debug2(x) x
#else
#define debug2(x)
#endif

/* Stage3pair_resolve_inside_softclips */
#ifdef DEBUG3
#define debug3(x) x
#else
#define debug3(x)
#endif

/* Stage3end_T comparisons.  Need to modify calls from path-solve.c */
#ifdef DEBUG4
#define debug4(x) x
#else
#define debug4(x)
#endif

/* Stage3end_remap_transcriptome */
#ifdef DEBUG5
#define debug5(x) x
#else
#define debug5(x)
#endif

/* Stage3end_nmatches_substrings */
#ifdef DEBUG7
#define debug7(x) x
#else
#define debug7(x)
#endif


/* Stage3pair_T comparisons */
#ifdef DEBUG8
#define debug8(x) x
#else
#define debug8(x)
#endif


/* Resolving insides */
#ifdef DEBUG9
#define debug9(x) x
#else
#define debug9(x)
#endif

/* insert length calculation */
#ifdef DEBUG10
#define debug10(x) x
#else
#define debug10(x)
#endif

/* circular chromosomes */
#ifdef DEBUG12
#define debug12(x) x
#else
#define debug12(x)
#endif

/* substring_gmap */
#ifdef DEBUG13
#define debug13(x) x
#else
#define debug13(x)
#endif

/* Stage3_determine_pairtype */
#ifdef DEBUG14
#define debug14(x) x
#else
#define debug14(x)
#endif

/* Stage3pair_overlap */
#ifdef DEBUG15
#define debug15(x) x
#else
#define debug15(x)
#endif



#define MAPQ_MAXIMUM_SCORE 40

static bool only_concordant_p = false; /* CONCORDANT_UNIQ, CONCORDANT_MULT, and CONCORDANT_CIRC */
static bool omit_concordant_uniq_p = false;
static bool omit_concordant_mult_p = false;
static bool filter_within_trims_p = false;

/* static int kmer_search_sizelimit = 100; */

static int subopt_levels;

static bool want_random_p;
static bool transcriptomep;
static bool novelsplicingp;

static bool invert_first_p;
static bool invert_second_p;
static Genome_T genomebits;
static Genome_T genomebits_alt;

static Univ_IIT_T chromosome_iit;
static int nchromosomes;
static int circular_typeint;

static Genome_T transcriptomebits;
static Transcriptome_T transcriptome;
static Univ_IIT_T transcript_iit;
static IIT_T transcript_map_iit; /* Used for resolve_inside_softclips and remap_transcriptome */

static IIT_T tally_iit;
static int *tally_divint_crosstable;
static IIT_T runlength_iit;
static int *runlength_divint_crosstable;

static Chrpos_T pairmax_linear;
static Chrpos_T pairmax_circular;

static Chrpos_T expected_pairlength;
static Chrpos_T pairlength_deviation;

static Chrpos_T expected_pairlength_low;
static Chrpos_T expected_pairlength_high;
static Chrpos_T expected_pairlength_very_high;

static int localsplicing_penalty;
static int indel_penalty_middle;
static int antistranded_penalty;

static int ambig_end_interval;	/* For penalizing large ambiguous ends
				   in GMAP alignments, since such ends
				   should have been found */

static Univcoord_T genomelength;
static bool *circularp;
static bool *altlocp;
static Univcoord_T *alias_starts;
static Univcoord_T *alias_ends;

static char *failedinput_root;
static Outputtype_T output_type;
static bool merge_samechr_p;
static bool method_print_p = false;

static bool allow_softclipped_p = true;


/* Probably not good to use in certain genomic regions, unless we also
   use known splicesites with distance information. */
/* But sometimes need to use to get correct mapping */
static bool favor_ambiguous_p;


void
Stage3hr_setup (bool transcriptomep_in, bool novelsplicingp_in, bool invert_first_p_in, bool invert_second_p_in,
		Genome_T genomebits_in, Genome_T genomebits_alt_in,
		Univ_IIT_T chromosome_iit_in, Univcoord_T genomelength_in, int nchromosomes_in, int circular_typeint_in,

		Genome_T transcriptomebits_in, Transcriptome_T transcriptome_in,
		Univ_IIT_T transcript_iit_in, IIT_T transcript_map_iit_in,

		IIT_T tally_iit_in, int *tally_divint_crosstable_in,
		IIT_T runlength_iit_in, int *runlength_divint_crosstable_in,
		bool distances_observed_p,
		Chrpos_T pairmax_linear_in, Chrpos_T pairmax_circular_in,
		Chrpos_T expected_pairlength_in, Chrpos_T pairlength_deviation_in,
		int localsplicing_penalty_in, int indel_penalty_middle_in,
		int antistranded_penalty_in, int subopt_levels_in,
		bool *circularp_in, bool *altlocp_in,
		Univcoord_T *alias_starts_in, Univcoord_T *alias_ends_in, bool filter_within_trims_p_in,
		bool only_concordant_p_in, bool omit_concordant_uniq_p_in, bool omit_concordant_mult_p_in,
		bool allow_softclipped_p_in, char *failedinput_root_in, Outputtype_T output_type_in,
		bool merge_samechr_p_in, bool method_print_p_in, bool want_random_p_in) {

  transcriptomep = transcriptomep_in;
  novelsplicingp = novelsplicingp_in;
  invert_first_p = invert_first_p_in;
  invert_second_p = invert_second_p_in;
  genomebits = genomebits_in;
  genomebits_alt = genomebits_alt_in;

  chromosome_iit = chromosome_iit_in;
  nchromosomes = nchromosomes_in;
  circular_typeint = circular_typeint_in;

  transcriptomebits = transcriptomebits_in;
  transcriptome = transcriptome_in;
  transcript_iit = transcript_iit_in;
  transcript_map_iit = transcript_map_iit_in;

  tally_iit = tally_iit_in;
  tally_divint_crosstable = tally_divint_crosstable_in;
  runlength_iit = runlength_iit_in;
  runlength_divint_crosstable = runlength_divint_crosstable_in;
  localsplicing_penalty = localsplicing_penalty_in;
  indel_penalty_middle = indel_penalty_middle_in;
  antistranded_penalty = antistranded_penalty_in;

  pairmax_linear = pairmax_linear_in;
  pairmax_circular = pairmax_circular_in;
  expected_pairlength = expected_pairlength_in;
  pairlength_deviation = pairlength_deviation_in;

  if (pairlength_deviation > expected_pairlength) {
    expected_pairlength_low = 0;
  } else {
    expected_pairlength_low = expected_pairlength - pairlength_deviation;
  }
  expected_pairlength_high = expected_pairlength + pairlength_deviation;
  expected_pairlength_very_high = expected_pairlength + 10*pairlength_deviation;

  if (distances_observed_p == true) {
    favor_ambiguous_p = false;
  } else {
    favor_ambiguous_p = true;
  }

#if 0
  ambig_end_interval = index1part + (index1interval - 1);
#else
  ambig_end_interval = 8;	/* Since GMAP uses 8-mers */
#endif

  subopt_levels = subopt_levels_in;

  genomelength = genomelength_in;
  circularp = circularp_in;
  altlocp = altlocp_in;
  alias_starts = alias_starts_in;
  alias_ends = alias_ends_in;

  failedinput_root = failedinput_root_in;

  filter_within_trims_p = filter_within_trims_p_in;
  only_concordant_p = only_concordant_p_in;
  omit_concordant_uniq_p = omit_concordant_uniq_p_in;
  omit_concordant_mult_p = omit_concordant_mult_p_in;
  allow_softclipped_p = allow_softclipped_p_in;

  output_type = output_type_in;
  merge_samechr_p = merge_samechr_p_in;
  method_print_p = method_print_p_in;
  want_random_p = want_random_p_in;

  return;
}



#define T Stage3end_T

Hittype_T
Stage3end_hittype (T this) {
  return this->hittype;
}

static char *
hittype_string (Hittype_T hittype) {
  switch (hittype) {
  case EXACT: return "exact";
  case SUB: return "sub";
  case HALFSPLICE_DONOR: return "donor";
  case HALFSPLICE_ACCEPTOR: return "acceptor";
  case SPLICE: return "splice";
  case SAMECHR_SPLICE: return "samechr_splice";
  case TRANSLOC_SPLICE: return "transloc_splice";
  case SUBSTRINGS: return "substrings";
  default: abort();
  }
}

char *
Stage3end_hittype_string (T this) {
  return hittype_string(this->hittype);
}

Method_T
Stage3end_method (T this) {
  return this->method;
}


int
Stage3end_genestrand (T this) {
  return this->genestrand;
}

List_T
Stage3end_transcripts_consistent (T this) {
  return this->transcripts_consistent;
}

List_T
Stage3end_transcripts_inconsistent (T this) {
  return this->transcripts_inconsistent;
}


static bool
hit_overlap_p (T x, T y) {
  if (x->chrnum != y->chrnum) {
    return false;		/* Different chrnums */
  } else if (x->plusp != y->plusp) {
    return false;		/* Different strands */
  } else if (x->high_chrbound < y->low_chrbound) {
    return false;
  } else if (x->low_chrbound > y->high_chrbound) {
    return false;
  } else {
    return true;
  }
}

#if 0
static bool
hit_equal_ignore_trim_p (T x, T y) {
  List_T p, q;
  Substring_T substring_x, substring_y;

  if (x->plusp != y->plusp) {
    return false;		/* Different strands */
  } else {
    p = x->substrings_1toN;
    q = y->substrings_1toN;
    while (p != NULL && q != NULL) {
      substring_x = (Substring_T) p->first;
      substring_y = (Substring_T) q->first;
      if (Substring_equal_ignore_trim(substring_x,substring_y) == false) {
	return false;
      }
      p = List_next(p);
      q = List_next(q);
    }
    if (p != NULL || q != NULL) {
      return false;
    }

    return true;
  }
}
#endif


#if 0
/* Transferring transcripts leads to inconsistencies and probably isn't necessary */
static void
transfer_transcripts (T dest, T source, Listpool_T listpool) {
  List_T q;
  Transcript_T transcript;
  int trim_low_adj, trim_high_adj;

  debug2(printf("Calling Stage3end_transfer_transcripts: sensedir %d and %d\n",
		dest->sensedir,source->sensedir));

  /* Previously checked for SENSE_CONSISTENT_P(dest->sensedir,source->sensedir) == false */
  /* But this doesn't work for unpaired alignments */

  if (hit_equal_ignore_trim_p(dest,source) == false) {
#if 0
    /* Transcripts will be freed by Stage3end_free */
    debug2(printf("No overlap between dest and source\n"));
    for (q = source->transcripts_consistent; q != NULL; q = List_next(q)) {
      transcript = (Transcript_T) List_head(q);
      Transcript_free(&transcript);
    }
    /* List_free(&source->transcripts_consistent); -- allocated by Listpool_push */

    for (q = source->transcripts_inconsistent; q != NULL; q = List_next(q)) {
      transcript = (Transcript_T) List_head(q);
      Transcript_free(&transcript);
    }
    /* List_free(&source->transcripts_inconsistent); -- allocated by Listpool_push */
#endif

  } else {
#ifdef DEBUG2
    printf("Transferring %d+%d transcripts from %s with query %d..%d to %s with query %d..%d\n",
	   List_length(source->transcripts_consistent),List_length(source->transcripts_inconsistent),
	   hittype_string(source->hittype),source->querystart_trimmed,source->queryend_trimmed,
	   hittype_string(dest->hittype),dest->querystart_trimmed,dest->queryend_trimmed);

    printf("Before:\n");
    printf("Dest: ");
    Transcript_print_nums(dest->transcripts_consistent);
    Transcript_print_nums(dest->transcripts_inconsistent);
    printf("\n");
    printf("Source: ");
    Transcript_print_nums(source->transcripts_consistent);
    Transcript_print_nums(source->transcripts_inconsistent);
    printf("\n");
#endif
    
    if (source->plusp == true) {
      debug2(printf("plus\n"));
      trim_low_adj = dest->querystart_trimmed - source->querystart_trimmed;
      trim_high_adj = -(dest->queryend_trimmed - source->queryend_trimmed);
    } else {
      debug2(printf("minus\n"));
      trim_low_adj = -(dest->queryend_trimmed - source->queryend_trimmed);
      trim_high_adj = dest->querystart_trimmed - source->querystart_trimmed;
    }

    for (q = source->transcripts_consistent; q != NULL; q = List_next(q)) {
      transcript = (Transcript_T) List_head(q);
      if (Transcript_in_list_p(transcript,dest->transcripts_consistent) == true) {
	/* Transcript_free(&transcript); -- freed by Stage3end_free */
      } else if (Transcript_trim(transcript,trim_low_adj,trim_high_adj,listpool) == true) {
	dest->transcripts_consistent = Listpool_push(dest->transcripts_consistent,listpool,
						     (void *) Transcript_copy(transcript,listpool));
      } else {
	dest->transcripts_inconsistent = Listpool_push(dest->transcripts_inconsistent,listpool,
						       (void *) Transcript_copy(transcript,listpool));
      }
    }
    /* List_free(&source->transcripts_consistent); -- allocated by Listpool_push */

    for (q = source->transcripts_inconsistent; q != NULL; q = List_next(q)) {
      transcript = (Transcript_T) List_head(q);
      if (Transcript_in_list_p(transcript,dest->transcripts_inconsistent) == true) {
	/* Transcript_free(&transcript); -- freed by Stage3end_free */
      } else if (Transcript_trim(transcript,trim_low_adj,trim_high_adj,listpool) == true) {
	dest->transcripts_consistent = Listpool_push(dest->transcripts_consistent,listpool,
						     (void *) Transcript_copy(transcript,listpool));
      } else {
	dest->transcripts_inconsistent = Listpool_push(dest->transcripts_inconsistent,listpool,
						       (void *) Transcript_copy(transcript,listpool));
      }
    }
    /* List_free(&source->transcripts_inconsistent); -- allocated by Listpool_push */

#ifdef DEBUG2
    printf("After:\n");
    printf("Dest: ");
    Transcript_print_nums(dest->transcripts_consistent);
    Transcript_print_nums(dest->transcripts_inconsistent);
    printf("\n");
    /* Source lists will be empty */
#endif
  }

  return;
}
#endif


bool
Stage3end_softclippedp (T this) {
  if (this->querystart_trimmed > 0 || this->querylength - this->queryend_trimmed > 0) {
    return true;
  } else {
    return false;
  }
}


int
Stage3end_distant_splice_i (T this) {
  return this->distant_splice_i;
}

bool
Stage3end_distant_splice_p (T this) {
  if (this->distant_splice_i >= 0) {
    return true;
  } else {
    return false;
  }
}


Chrnum_T
Stage3end_chrnum (T this) {
  if (this == NULL) {
    /* Can happen if we call upon a mate in a halfmapping */
    return 0;
  } else {
    return this->chrnum;
  }
}

Chrnum_T
Stage3end_effective_chrnum (T this) {
  if (this == NULL) {
    /* Can happen if we call upon a mate in a halfmapping */
    return 0;
  } else {
    return this->effective_chrnum;
  }
}

Chrnum_T
Stage3end_other_chrnum (T this) {
  if (this == NULL) {
    /* Can happen if we call upon a mate in a halfmapping */
    return 0;
  } else {
    return this->other_chrnum;
  }
}

Univcoord_T
Stage3end_chroffset (T this) {
  return this->chroffset;
}

Univcoord_T
Stage3end_chrhigh (T this) {
  return this->chrhigh;
}

Chrpos_T
Stage3end_chrlength (T this) {
  if (this == NULL) {
    /* Can happen if we call upon a mate in a halfmapping */
    return 0;
  } else {
    return this->chrlength;
  }
}

Chrpos_T
Stage3end_chrpos_low (T this) {
  return this->low_trimmed - this->chroffset;
}

Chrpos_T
Stage3end_chrpos_high (T this) {
  return this->high_trimmed - this->chroffset;
}


Univcoord_T
Stage3end_genomicstart (T this) {
  return this->genomicstart;
}

Univcoord_T
Stage3end_genomicend (T this) {
  return this->genomicend;
}

#if 0
/* For Goby */
int
Stage3end_query_alignment_length (T this) {
  int length = 0;
  List_T p;
  Substring_T substring;
  Junction_T junction;

  for (p = this->substrings_LtoH; p != NULL; p = List_next(p)) {
    substring = (Substring_T) List_head(p);
    length += Substring_match_length(substring);
  }
  for (p = this->junctions_LtoH; p != NULL; p = List_next(p)) {
    junction = (Junction_T) List_head(p);
    if (Junction_type(junction) == INS_JUNCTION) {
      length += Junction_nindels(junction);
    }
  }

  return length;
}
#endif


#if 0
Chrpos_T
Stage3end_genomic_alignment_length (T this) {
  Chrpos_T length = 0;
  List_T p;
  Substring_T substring;
  Junction_T junction;

  for (p = this->substrings_LtoH; p != NULL; p = List_next(p)) {
    substring = (Substring_T) List_head(p);
    length += Substring_genomic_alignment_length(substring);
  }
  for (p = this->junctions_LtoH; p != NULL; p = List_next(p)) {
    junction = (Junction_T) List_head(p);
    if (Junction_type(junction) == DEL_JUNCTION) {
      length += (Chrpos_T) Junction_nindels(junction);
    }
  }

  return length;
}
#endif


int
Stage3end_mapq_score (T this) {
  return this->mapq_score;
}

int
Stage3end_absmq_score (T this) {
  return this->absmq_score;
}

int
Stage3end_nmismatches_bothdiff (T this) {
  return this->nmismatches_bothdiff;
}

int
Stage3end_nmismatches_refdiff (T this) {
  return this->nmismatches_refdiff;
}


int
Stage3end_nindels (T this) {
  return this->nindels;
}

int
Stage3end_querylength (T this) {
  return this->querylength;
}

bool
Stage3end_plusp (T this) {
  return this->plusp;
}

bool
Stage3end_paired_usedp (T this) {
  return this->paired_usedp;
}

int
Stage3end_max_trim (T this) {
  if (this->querystart_trimmed > this->querylength - this->queryend_trimmed) {
    return this->querystart_trimmed;
  } else {
    return this->querylength - this->queryend_trimmed;
  }
}


static int
start_amb_length (T this) {
  return Substring_start_amb_length((Substring_T) List_head(this->substrings_1toN));
}

static int
end_amb_length (T this) {
  return Substring_end_amb_length((Substring_T) List_head(this->substrings_Nto1));
}

#if 0
static int
n_amb_ends (T this) {
  int n = 0;

  if (start_amb_length(this) > 0) {
    n++;
  }
  if (end_amb_length(this) > 0) {
    n++;
  }

  return n;
}
#endif


#ifdef DEBUG8
static int
amb_length (T this) {
  return Substring_start_amb_length((Substring_T) List_head(this->substrings_1toN)) +
    Substring_end_amb_length((Substring_T) List_head(this->substrings_Nto1));
}
#endif


#if 0
/* Two types of ambiguity: known amb (mapped to >1 genomic place) and unknown amb (splice site seen) */
static bool
known_ambiguous_p (T this) {
  if (Substring_ambiguous_p((Substring_T) List_head(this->substrings_1toN))) {
    return true;
  } else if (Substring_ambiguous_p((Substring_T) List_head(this->substrings_Nto1))) {
    return true;
  } else {
    return false;
  }
}
#endif


/* Includes amb and non-amb */
int
Stage3end_total_trim (T this) {
  return this->querystart_trimmed + (this->querylength - this->queryend_trimmed);
}


int
Stage3end_circularpos (T this) {
  return this->circularpos;
}


Junction_T
Stage3end_junctionD (T this) {
  if (this->sensedir == SENSE_ANTI) {
    return (Junction_T) List_head(this->junctions_Nto1);
  } else {
    return (Junction_T) List_head(this->junctions_1toN);
  }
}

Junction_T
Stage3end_junctionA (T this) {
  if (this->sensedir == SENSE_ANTI) {
    return (Junction_T) List_head(this->junctions_1toN);
  } else {
    return (Junction_T) List_head(this->junctions_Nto1);
  }
}

List_T
Stage3end_substrings_LtoH (T this) {
  if (this->plusp == true) {
    return this->substrings_1toN;
  } else {
    return this->substrings_Nto1;
  }
}

List_T
Stage3end_junctions_LtoH (T this) {
  if (this->plusp == true) {
    return this->junctions_1toN;
  } else {
    return this->junctions_Nto1;
  }
}


List_T
Stage3end_substrings_1toN (T this) {
  return this->substrings_1toN;
}

List_T
Stage3end_substrings_Nto1 (T this) {
  return this->substrings_Nto1;
}

List_T
Stage3end_junctions_1toN (T this) {
  return this->junctions_1toN;
}

List_T
Stage3end_junctions_Nto1 (T this) {
  return this->junctions_Nto1;
}


/* Called only by samprint currently */
Substring_T
Stage3end_substring1 (T this) {
  return (Substring_T) List_head(this->substrings_1toN);
}

/* Called only by samprint currently */
Substring_T
Stage3end_substringN (T this) {
  return (Substring_T) List_head(this->substrings_Nto1);
}


#if 0
Substring_T
Stage3end_substringL (T this) {
  if (this->plusp == true) {
    return (Substring_T) List_head(this->substrings_1toN);
  } else {
    return (Substring_T) List_head(this->substrings_Nto1);
  }
}
#endif

#if 0
Substring_T
Stage3end_substringH (T this) {
  if (this->plusp == true) {
    return (Substring_T) List_head(this->substrings_Nto1);
  } else {
    return (Substring_T) List_head(this->substrings_1toN);
  }
}
#endif


Substring_T
Stage3end_substring_for_concordance (T this, bool first_read_p) {
  if (first_read_p == true) {
    return (Substring_T) List_head(this->substrings_Nto1);
  } else {
    return (Substring_T) List_head(this->substrings_1toN);
  }
}

Substring_T
Stage3end_substring_other (T this, bool first_read_p) {
  if (first_read_p == true) {
    return (Substring_T) List_head(this->substrings_1toN);
  } else {
    return (Substring_T) List_head(this->substrings_Nto1);
  }
}


#if 0
bool
Stage3end_donor_concordant_p (T this, bool first_read_p) {
  if (this->sensedir != SENSE_ANTI) {
    if (first_read_p == true) {
      return false;
    } else {
      return true;
    }
  } else {
    if (first_read_p == true) {
      return true;
    } else {
      return false;
    }
  }
}
#endif

int
Stage3end_splice_hardclip1 (T this) {
  if (this->sensedir != SENSE_ANTI) {
    return Substring_siteD_pos(this->substring_donor);
  } else {
    return Substring_siteA_pos(this->substring_acceptor);
  }
}

int
Stage3end_splice_hardclipN (T this) {
  if (this->sensedir != SENSE_ANTI) {
    return this->querylength - Substring_siteA_pos(this->substring_acceptor);
  } else {
    return this->querylength - Substring_siteD_pos(this->substring_donor);
  }
}


Substring_T
Stage3end_substring_donor (T this) {
  return this->substring_donor;
}

Substring_T
Stage3end_substring_acceptor (T this) {
  return this->substring_acceptor;
}


#if 0
/* If sensedir is SENSE_NULL, the XT:Z: field will have XX-XX as dinucleotides */
bool
Stage3end_splice_substrings (Substring_T *donor, Substring_T *acceptor, T this) {
  List_T p;
  int nexons, exoni;

  if (this->distant_splice_i < 0) {
    return false;

  } else {
#if 0
    if (this->sensedir != SENSE_ANTI) {
      p = this->substrings_1toN;
      for (exoni = 0; exoni < this->distant_splice_i; exoni++) {
	p = List_next(p);
      }

    } else {
      nexons = List_length(this->substrings_Nto1);
      p = this->substrings_Nto1;
      for (exoni = 0; exoni < (nexons - 2) - this->distant_splice_i; exoni++) {
	p = List_next(p);
      }
    }

    *donor = (Substring_T) List_head(p);
    *acceptor = (Substring_T) List_head(List_next(p));
#else
    *donor = this->substring_donor;
    *acceptor = this->substring_acceptor;
#endif

    return true;
  }
}
#endif


#if 0
/* Use Stage3end_substring_donor instead */
Substring_T
Stage3end_substringD (T this) {
  if (this->sensedir == SENSE_ANTI) {
    return (Substring_T) List_head(this->substrings_Nto1);
  } else {
    return (Substring_T) List_head(this->substrings_1toN);
  }
}
#endif

#if 0
/* Use Stage3end_substring_acceptor instead */
Substring_T
Stage3end_substringA (T this) {
  if (this->sensedir == SENSE_ANTI) {
    return (Substring_T) List_head(this->substrings_1toN);
  } else {
    return (Substring_T) List_head(this->substrings_Nto1);
  }
}
#endif

#if 0
Substring_T
Stage3end_substringS (T this) {
  return (Substring_T) List_head(List_next(this->substrings_1toN));
}
#endif



/* Same logic as in print_substrings in samprint.c to get the first substring for CIGAR or MD string */
Substring_T
Stage3end_substring_low (T this, int hardclip_low) {
  List_T p;

  debug15(printf("Entered Stage3end_substring_low\n"));

  if (this == NULL) {
    return (Substring_T) NULL;

  } else if (this->plusp == true) {
    p = this->substrings_1toN;  /* substrings_LtoH */
    if (Substring_has_alts_p((Substring_T) List_head(p)) == true) {
      p = List_next(p);
    }
    while (p != NULL && Substring_queryend((Substring_T) List_head(p)) <= hardclip_low) {
      debug15(printf("Plus: Skipping substring %d..%d against hardclip_low %d\n",
		     Substring_querystart((Substring_T) List_head(p)),Substring_queryend((Substring_T) List_head(p)),
		     hardclip_low));
      p = List_next(p);
    }

    if (p == NULL) {
      return (Substring_T) NULL;
    } else {
      debug15(printf("Plus: Returning substring %d..%d against hardclip_low %d\n",
		     Substring_querystart((Substring_T) List_head(p)),Substring_queryend((Substring_T) List_head(p)),
		     hardclip_low));
      return (Substring_T) List_head(p);
    }

  } else {
#ifdef DEBUG15
    for (p = this->substrings_LtoH; p != NULL; p = List_next(p)) {
      printf("LtoH: %d..%d\n",
	     Substring_querystart((Substring_T) List_head(p)),Substring_queryend((Substring_T) List_head(p)));
    }
#endif

    p = this->substrings_Nto1;  /* substrings_LtoH */
    if (Substring_has_alts_p((Substring_T) List_head(p)) == true) {
      p = List_next(p);
    }

    while (p != NULL && Substring_querystart((Substring_T) List_head(p)) >= this->querylength - hardclip_low) {
      debug15(printf("Minus: Skipping substring %d..%d against %d = querylength %d - hardclip_low %d\n",
		     Substring_querystart((Substring_T) List_head(p)),Substring_queryend((Substring_T) List_head(p)),
		     this->querylength - hardclip_low,this->querylength,hardclip_low));
      p = List_next(p);
    }

    if (p == NULL) {
      return (Substring_T) NULL;
    } else {
      debug15(printf("Minus: Returning substring %d..%d against %d = querylength %d - hardclip_low %d\n",
		     Substring_querystart((Substring_T) List_head(p)),Substring_queryend((Substring_T) List_head(p)),
		     this->querylength - hardclip_low,this->querylength,hardclip_low));
      return (Substring_T) List_head(p);
    }
  }
}


#if 0
/* Modified from Stage3end_substring_low */
Substring_T
Stage3end_substring_high (T this, int hardclip_high) {
  List_T p;

  debug15(printf("Entered Stage3end_substring_high\n"));

  if (this == NULL) {
    return (Substring_T) NULL;

  } else if (this->plusp == true) {
    p = this->substrings_HtoL;
    if (Substring_has_alts_p((Substring_T) List_head(p)) == true) {
      p = List_next(p);
    }

    while (p != NULL && Substring_querystart((Substring_T) List_head(p)) >= this->querylength - hardclip_high) {
      debug15(printf("Plus: Skipping substring %d..%d against %d = querylength %d - hardclip_high %d\n",
		     Substring_querystart((Substring_T) List_head(p)),Substring_queryend((Substring_T) List_head(p)),
		     this->querylength - hardclip_high,this->querylength,hardclip_high));
      p = List_next(p);
    }

    if (p == NULL) {
      return (Substring_T) NULL;
    } else {
      debug15(printf("Plus: Returning substring %d..%d against %d = querylength %d - hardclip_high %d\n",
		     Substring_querystart((Substring_T) List_head(p)),Substring_queryend((Substring_T) List_head(p)),
		     this->querylength - hardclip_high,this->querylength,hardclip_high));
      return (Substring_T) List_head(p);
    }

  } else {
#ifdef DEBUG15
    for (p = this->substrings_HtoL; p != NULL; p = List_next(p)) {
      printf("HtoL: %d..%d\n",
	     Substring_querystart((Substring_T) List_head(p)),Substring_queryend((Substring_T) List_head(p)));
    }
#endif

    p = this->substrings_HtoL;
    if (Substring_has_alts_p((Substring_T) List_head(p)) == true) {
      p = List_next(p);
    }

    while (p != NULL && Substring_queryend((Substring_T) List_head(p)) <= hardclip_high) {
      debug15(printf("Minus: Skipping substring %d..%d against hardclip_high %d\n",
		     Substring_querystart((Substring_T) List_head(p)),Substring_queryend((Substring_T) List_head(p)),
		     hardclip_high));
      p = List_next(p);
    }

    if (p == NULL) {
      return (Substring_T) NULL;
    } else {
      debug15(printf("Minus: Returning substring %d..%d against hardclip_high %d\n",
		     Substring_querystart((Substring_T) List_head(p)),Substring_queryend((Substring_T) List_head(p)),
		     hardclip_high));
      return (Substring_T) List_head(p);
    }
  }
}
#endif



Substring_T
Stage3end_substring_containing (T this, int querypos) {
  Substring_T substring;
  List_T substrings_LtoH, p;

  if (this->plusp == true) {
    substrings_LtoH = this->substrings_1toN;
  } else {
    substrings_LtoH = this->substrings_Nto1;
  }

  for (p = substrings_LtoH; p != NULL; p = List_next(p)) {
    substring = (Substring_T) List_head(p);
    if (Substring_contains_p(substring,querypos) == true) {
      return substring;
    }
  }

  return (Substring_T) NULL;
}


double
Stage3end_min_evalue (T this) {
  double min_evalue = 1000.0, evalue;
  Substring_T substring;
  List_T p;

  for (p = this->substrings_1toN; p != NULL; p = List_next(p)) {
    substring = (Substring_T) List_head(p);
    if ((evalue = Substring_evalue(substring)) < min_evalue) {
      min_evalue = evalue;
    }
  }

  return min_evalue;
}


double
Stage3end_chimera_prob (T this) {
  List_T p;
  Junction_T junction;

  for (p = this->junctions_1toN; p != NULL; p = List_next(p)) {
    junction = (Junction_T) List_head(p);
    if (Junction_type(junction) == CHIMERA_JUNCTION) {
      return Junction_prob(junction);
    }
  }

  return 0.0;
}

static double
Stage3end_prob (T this) {
  double prob = 0.0;
  List_T p;
  Junction_T junction;

  for (p = this->junctions_1toN; p != NULL; p = List_next(p)) {
    junction = (Junction_T) List_head(p);
    prob += Junction_prob(junction);
  }

  return prob;
}


#if 0
/* Should eventually look for substrings adjacent to the chimeric junction */
Univcoord_T
Stage3end_chimera_segmenti_left (T this) {
  Univcoord_T x_segmenti, x_segmentj;
  Substring_T substring_donor, substring_acceptor;

  if (this->sensedir == SENSE_ANTI) {
    substring_donor = (Substring_T) List_head(this->substrings_Nto1);
    substring_acceptor = (Substring_T) List_head(this->substrings_1toN);
  } else {
    substring_donor = (Substring_T) List_head(this->substrings_1toN);
    substring_acceptor = (Substring_T) List_head(this->substrings_Nto1);
  }

  x_segmenti = Substring_left_genomicseg(substring_donor);
  x_segmentj = Substring_left_genomicseg(substring_acceptor);
  if (x_segmenti < x_segmentj) {
    return x_segmenti;
  } else {
    return x_segmentj;
  }
}  
#endif

#if 0
/* Should eventually look for substrings adjacent to the chimeric junction */
Univcoord_T
Stage3end_chimera_segmentj_left (T this) {
  Univcoord_T x_segmenti, x_segmentj;
  Substring_T substring_donor, substring_acceptor;

  if (this->sensedir == SENSE_ANTI) {
    substring_donor = (Substring_T) List_head(this->substrings_Nto1);
    substring_acceptor = (Substring_T) List_head(this->substrings_1toN);
  } else {
    substring_donor = (Substring_T) List_head(this->substrings_1toN);
    substring_acceptor = (Substring_T) List_head(this->substrings_Nto1);
  }

  x_segmenti = Substring_left_genomicseg(substring_donor);
  x_segmentj = Substring_left_genomicseg(substring_acceptor);
  if (x_segmenti > x_segmentj) {
    return x_segmenti;
  } else {
    return x_segmentj;
  }
}  
#endif


#if 0
int
Stage3end_chimera_segmenti_cmp (const void *a, const void *b) {
  T x = * (T *) a;
  T y = * (T *) b;
  Univcoord_T x_segmenti, x_segmentj, y_segmenti, y_segmentj, temp;
  Substring_T x_substring_donor, x_substring_acceptor,
    y_substring_donor, y_substring_acceptor;

  if (x->sensedir == SENSE_ANTI) {
    x_substring_donor = (Substring_T) List_head(x->substrings_Nto1);
    x_substring_acceptor = (Substring_T) List_head(x->substrings_1toN);
  } else {
    x_substring_donor = (Substring_T) List_head(x->substrings_1toN);
    x_substring_acceptor = (Substring_T) List_head(x->substrings_Nto1);
  }

  if (y->sensedir == SENSE_ANTI) {
    y_substring_donor = (Substring_T) List_head(y->substrings_Nto1);
    y_substring_acceptor = (Substring_T) List_head(y->substrings_1toN);
  } else {
    y_substring_donor = (Substring_T) List_head(y->substrings_1toN);
    y_substring_acceptor = (Substring_T) List_head(y->substrings_Nto1);
  }

  x_segmenti = Substring_left_genomicseg(x_substring_donor);
  x_segmentj = Substring_left_genomicseg(x_substring_acceptor);
  if (x_segmentj < x_segmenti) {
    temp = x_segmentj;
    x_segmentj = x_segmenti;
    x_segmenti = temp;
  }

  y_segmenti = Substring_left_genomicseg(y_substring_donor);
  y_segmentj = Substring_left_genomicseg(y_substring_acceptor);
  if (y_segmentj < y_segmenti) {
    temp = y_segmentj;
    y_segmentj = y_segmenti;
    y_segmenti = temp;
  }

  if (x_segmenti < y_segmenti) {
    return -1;
  } else if (y_segmenti < x_segmenti) {
    return +1;
  } else if (x_segmentj > y_segmentj) {
    return -1;
  } else if (y_segmentj > x_segmentj) {
    return +1;
  } else {
    return 0;
  }
}
#endif


#if 0
int
Stage3end_chimera_segmentj_cmp (const void *a, const void *b) {
  T x = * (T *) a;
  T y = * (T *) b;
  Univcoord_T x_segmenti, x_segmentj, y_segmenti, y_segmentj, temp;
  Substring_T x_substring_donor, x_substring_acceptor,
    y_substring_donor, y_substring_acceptor;

  if (x->sensedir == SENSE_ANTI) {
    x_substring_donor = (Substring_T) List_head(x->substrings_Nto1);
    x_substring_acceptor = (Substring_T) List_head(x->substrings_1toN);
  } else {
    x_substring_donor = (Substring_T) List_head(x->substrings_1toN);
    x_substring_acceptor = (Substring_T) List_head(x->substrings_Nto1);
  }

  if (y->sensedir == SENSE_ANTI) {
    y_substring_donor = (Substring_T) List_head(y->substrings_Nto1);
    y_substring_acceptor = (Substring_T) List_head(y->substrings_1toN);
  } else {
    y_substring_donor = (Substring_T) List_head(y->substrings_1toN);
    y_substring_acceptor = (Substring_T) List_head(y->substrings_Nto1);
  }


  x_segmenti = Substring_left_genomicseg(x_substring_donor);
  x_segmentj = Substring_left_genomicseg(x_substring_acceptor);
  if (x_segmentj < x_segmenti) {
    temp = x_segmentj;
    x_segmentj = x_segmenti;
    x_segmenti = temp;
  }

  y_segmenti = Substring_left_genomicseg(y_substring_donor);
  y_segmentj = Substring_left_genomicseg(y_substring_acceptor);
  if (y_segmentj < y_segmenti) {
    temp = y_segmentj;
    y_segmentj = y_segmenti;
    y_segmenti = temp;
  }

  if (x_segmentj < y_segmentj) {
    return -1;
  } else if (y_segmentj < x_segmentj) {
    return +1;
  } else if (x_segmenti > y_segmenti) {
    return -1;
  } else if (y_segmenti > x_segmenti) {
    return +1;
  } else {
    return 0;
  }
}
#endif


int
Stage3end_sensedir (T this) {
  if (this == NULL) {
    /* Can happen if we call upon a mate in a halfmapping */
    return SENSE_NULL;
  } else {
    return this->sensedir;
  }
}

#if 0
int
Stage3end_cdna_direction (T this) {
  if (this == NULL) {
    return SENSE_NULL;
  } else if (this->sensedir == SENSE_FORWARD) {
    return +1;
  } else if (this->sensedir == SENSE_ANTI) {
    return -1;
  } else {
    return SENSE_NULL;
  }
}
#endif

#if 0
bool
Stage3end_start_ambiguous_p (T this) {
  Substring_T substring;

  substring = (Substring_T) List_head(this->substrings_1toN);
  return Substring_ambiguous_p(substring);
}
#endif

#if 0
bool
Stage3end_end_ambiguous_p (T this) {
  Substring_T substring;

  substring = (Substring_T) List_head(this->substrings_Nto1);
  return Substring_ambiguous_p(substring);
}
#endif

bool
Stage3end_start_has_alts_p (T this) {
  Substring_T substring;

  substring = (Substring_T) List_head(this->substrings_1toN);
  return Substring_has_alts_p(substring);
}

bool
Stage3end_end_has_alts_p (T this) {
  Substring_T substring;

  substring = (Substring_T) List_head(this->substrings_Nto1);
  return Substring_has_alts_p(substring);
}


Univcoord_T *
Stage3end_start_alts_coords (T this) {
  Substring_T substring;

  substring = (Substring_T) List_head(this->substrings_1toN);
  if (Substring_has_alts_p(substring) == false) {
    return (Univcoord_T *) NULL;
  } else {
    return Substring_alts_coords(substring);
  }
}

Univcoord_T *
Stage3end_end_alts_coords (T this) {
  Substring_T substring;

  substring = (Substring_T) List_head(this->substrings_Nto1);
  if (Substring_has_alts_p(substring) == false) {
    return (Univcoord_T *) NULL;
  } else {
    return Substring_alts_coords(substring);
  }
}

int
Stage3end_start_alts_ncoords (T this) {
  Substring_T substring;

  substring = (Substring_T) List_head(this->substrings_1toN);
  if (Substring_has_alts_p(substring) == false) {
    return 0;
  } else {
    return Substring_alts_ncoords(substring);
  }
}

int
Stage3end_end_alts_ncoords (T this) {
  Substring_T substring;

  substring = (Substring_T) List_head(this->substrings_Nto1);
  if (Substring_has_alts_p(substring) == false) {
    return 0;
  } else {
    return Substring_alts_ncoords(substring);
  }
}


int
Stage3end_substrings_querystart (T this) {
  Substring_T substring;

  substring = (Substring_T) List_head(this->substrings_1toN);
  return Substring_querystart(substring);
}

int
Stage3end_substrings_queryend (T this) {
  Substring_T substring;

  substring = (Substring_T) List_head(this->substrings_Nto1);
  return Substring_queryend(substring);
}


void
Stage3end_count_hits (int *npaths_primary, int *npaths_altloc, List_T hits) {
  T hit;

  *npaths_primary = *npaths_altloc = 0;

  while (hits != NULL) {
    hit = (T) List_head(hits);
    if (altlocp[hit->chrnum] == true) {
      *npaths_altloc += 1;
    } else {
      *npaths_primary += 1;
    }
    hits = List_next(hits);
  }

  return;
}

#if 0
static long int
Stage3end_compute_tally (T this) {
  long int tally = 0L;
  List_T p;
  Substring_T substring;

  for (p = this->substrings_1toN; p != NULL; p = List_next(p)) {
    substring = (Substring_T) List_head(p);
    tally += Substring_tally(substring,tally_iit,tally_divint_crosstable);
  }

  return tally;
}
#endif

#if 0
static bool
Stage3end_runlength_p (T this) {
  List_T p;
  Substring_T substring;

  for (p = this->substrings_1toN; p != NULL; p = List_next(p)) {
    substring = (Substring_T) List_head(p);
    if (Substring_runlength_p(substring,runlength_iit,runlength_divint_crosstable) == true) {
      return true;
    }
  }

  return false;
}
#endif


void
Stage3end_free (T *old) {
  List_T p;
  Substring_T substring;
  Junction_T junction;


  if (*old != NULL) {
    debug0(printf("Freeing Stage3end %p from method %s\n",*old,Method_string((*old)->method)));

    if ((*old)->transcripts_inconsistent != NULL) {
      Transcript_gc(&(*old)->transcripts_inconsistent);
    }
    if ((*old)->transcripts_consistent != NULL) {
      Transcript_gc(&(*old)->transcripts_consistent);
    }

    for (p = (*old)->substrings_1toN; p != NULL; p = List_next(p)) {
      substring = (Substring_T) List_head(p);
      Substring_free(&substring);
    }
    /* List_free(&(*old)->substrings_1toN); -- allocated by Listpool_push */
    /* List_free(&(*old)->substrings_Nto1); -- allocated by Listpool_push */
    /* List_free(&(*old)->substrings_LtoH); -- allocated by Listpool_push */
    /* List_free(&(*old)->substrings_HtoL); -- allocated by Listpool_push */

    for (p = (*old)->junctions_1toN; p != NULL; p = List_next(p)) {
      junction = (Junction_T) List_head(p);
      Junction_free(&junction);
    }
    /* List_free(&(*old)->junctions_1toN); -- allocated by Listpool_push */
    /* List_free(&(*old)->junctions_Nto1); -- allocated by Listpool_push */
    /* List_free(&(*old)->junctions_LtoH); -- allocated by Listpool_push */
    /* List_free(&(*old)->junctions_HtoL); */

    FREE_OUT(*old);
  }

  return;
}


/* Used for freeing list contents in Concordance_pair_up procedures */
/* Do not free the list itself, though, which was previously freed in
   stage1hr.c, and now allocated by Hitlistpool_T */
void
Stage3end_gc (List_T values) {
  List_T p;
  T hit;

  for (p = values; p != NULL; p = p->rest) {
    if ((hit = (T) p->first) != NULL) {
      Stage3end_free(&hit);
    }
  }
  Hitlist_free(&values);
  return;
}



bool
Stage3pair_distant_splice_p (Stage3pair_T this) {
  if (this->hit5 != NULL && this->hit5->distant_splice_i >= 0) {
    return true;
  } else if (this->hit3 != NULL && this->hit3->distant_splice_i >= 0) {
    return true;
  } else {
    return false;
  }
}


int
Stage3pair_genestrand (Stage3pair_T this) {
  return this->genestrand;
}

Stage3end_T
Stage3pair_hit5 (Stage3pair_T this) {
  return this->hit5;
}

Stage3end_T
Stage3pair_hit3 (Stage3pair_T this) {
  return this->hit3;
}

int
Stage3pair_mapq_score (Stage3pair_T this) {
  return this->mapq_score;
}

int
Stage3pair_absmq_score (Stage3pair_T this) {
  return this->absmq_score;
}

Chrpos_T
Stage3pair_pairlength (Stage3pair_T this) {
  return this->insertlength;
}

int
Stage3pair_relationship (Stage3pair_T this) {
  return this->pair_relationship;
}

int
Stage3pair_total_trim (Stage3pair_T this) {
  return Stage3end_total_trim(this->hit5) + Stage3end_total_trim(this->hit3);
}

int
Stage3pair_max_trim (Stage3pair_T this) {
  int trim5, trim3;
  T hit;

#if 0
  /* Don't want ambiguous ends for purpose of defining concordant terminals */
  trim5 = Stage3end_total_trim(this->hit5);
  trim3 = Stage3end_total_trim(this->hit3);
#else
  hit = this->hit5;
  trim5 = hit->querystart_trimmed + (hit->querylength - hit->queryend_trimmed);
  hit = this->hit3;
  trim3 = hit->querystart_trimmed + (hit->querylength - hit->queryend_trimmed);
#endif

  if (trim5 > trim3) {
    return trim5;
  } else {
    return trim3;
  }
}

int
Stage3pair_nmatches_to_trims (int *nmatches5, int *nmatches3, Stage3pair_T this) {
  *nmatches5 = this->hit5->refalt_nmatches_to_trims;
  *nmatches3 = this->hit3->refalt_nmatches_to_trims;
  return (*nmatches5) + (*nmatches3);
}

int
Stage3pair_ref_nmatches_to_trims (int *nmatches5, int *nmatches3, Stage3pair_T this) {
  *nmatches5 = this->hit5->ref_nmatches_to_trims;
  *nmatches3 = this->hit3->ref_nmatches_to_trims;
  return (*nmatches5) + (*nmatches3);
}


int
Stage3pair_best_refalt_nmatches_plus_spliced_trims (int *best_nmatches_5, int *best_nmatches_3,
						    List_T hitpairs) {
  int best_nmatches = 0, nmatches;
  List_T p;
  Stage3pair_T hitpair;

  *best_nmatches_5 = *best_nmatches_3 = 0;
  for (p = hitpairs; p != NULL; p = List_next(p)) {
    hitpair = (Stage3pair_T) List_head(p);
    if ((nmatches = hitpair->hit5->refalt_nmatches_plus_spliced_trims +
	 hitpair->hit3->refalt_nmatches_plus_spliced_trims) > best_nmatches) {
      *best_nmatches_5 = hitpair->hit5->refalt_nmatches_plus_spliced_trims;
      *best_nmatches_3 = hitpair->hit3->refalt_nmatches_plus_spliced_trims;
      best_nmatches = nmatches;
    }
  }

  return best_nmatches;
}


void
Stage3pair_count_hits (int *npaths_primary, int *npaths_altloc, List_T hitpairs) {
  Stage3pair_T hitpair;

  *npaths_primary = *npaths_altloc = 0;

  while (hitpairs != NULL) {
    hitpair = (Stage3pair_T) List_head(hitpairs);
    if (altlocp[hitpair->hit5->chrnum] == true) {
      *npaths_altloc += 1;
    } else if (altlocp[hitpair->hit3->chrnum] == true) {
      *npaths_altloc += 1;
    } else {
      *npaths_primary += 1;
    }
    hitpairs = List_next(hitpairs);
  }

  return;
}


/* Returns true if ilengths are valid */
static bool
find_ilengths (int *ilength_low, int *ilength_high, Stage3end_T hit, Univcoord_T common_genomicpos) {
  List_T p, q;
  Substring_T substring;
  Junction_T junction;


  debug15(printf("Finding ilengths for common_genomicpos %u\n",(Chrpos_T) (common_genomicpos - chroffset)));
  if (hit->plusp == true) {
#ifdef DEBUG15
    printf("plus.  Checking common genomicpos %llu against\n",common_genomicpos - hit->chroffset);
    for (p = hit->substrings_1toN; p != NULL; p = List_next(p)) {
      substring = (Substring_T) List_head(p);
      printf("substring %p: %u..%u, trimmed %d..%d\n",
	     substring,Substring_alignstart_trim(substring) - hit->chroffset,
	     Substring_alignend_trim(substring) - 1U - hit->chroffset,
	     Substring_querystart_trimmed(substring),Substring_queryend_trimmed(substring));
    }
    printf("\n");
#endif
    /* Plus: Subtract 1 from alignend */
    *ilength_low = 0;
    for (p = hit->substrings_1toN, q = hit->junctions_1toN; p != NULL; p = List_next(p), q = List_next(q)) {
      substring = (Substring_T) List_head(p);
      debug15(printf("substring %p: %u..%u, trimmed %d..%d\n",substring,
		     Substring_alignstart_trim(substring) - hit->chroffset,
		     Substring_alignend_trim(substring) - 1U - hit->chroffset,
		     Substring_querystart_trimmed(substring),Substring_queryend_trimmed(substring)));
      if (Substring_overlap_point_trimmed_p(substring,common_genomicpos) == false) {
	*ilength_low += Substring_genomic_alignment_length(substring);
	if (q != NULL) {
	  junction = (Junction_T) List_head(q);
	  if (Junction_type(junction) == INS_JUNCTION) {
	    *ilength_low += Junction_nindels(junction);
	  }
	}

      } else {
	*ilength_low += (common_genomicpos - Substring_alignstart_trim(substring) + 1);
	*ilength_high = ((Substring_alignend_trim(substring) - 1) - common_genomicpos + 1);
	p = List_next(p);
	while (p != NULL) {
	  substring = (Substring_T) List_head(p);
	  *ilength_high += Substring_genomic_alignment_length(substring);
	  p = List_next(p);
	}
	while (q != NULL) {
	  junction = (Junction_T) List_head(q);
	  if (Junction_type(junction) == INS_JUNCTION) {
	    *ilength_high += Junction_nindels(junction);
	  }
	  q = List_next(q);
	}
	debug15(printf("Plus: Have ilength_low %d and ilength_high %d\n",*ilength_low,*ilength_high));
	return true;
      }
    }
  } else {
#ifdef DEBUG15
    printf("minus.  Checking common genomicpos %llu against\n",common_genomicpos - hit->chroffset);
    for (p = hit->substrings_1toN; p != NULL; p = List_next(p)) {
      substring = (Substring_T) List_head(p);
      printf("substring %p: %u..%u, trimmed %d..%d\n",
	     substring,Substring_alignstart_trim(substring) - hit->chroffset,
	     Substring_alignend_trim(substring) - 1U - hit->chroffset,
	     Substring_querystart_trimmed(substring),Substring_queryend_trimmed(substring));
    }
    printf("\n");
#endif
    /* Minus: Subtract 1 from alignstart */
    *ilength_high = 0;
    for (p = hit->substrings_1toN, q = hit->junctions_1toN; p != NULL; p = List_next(p), q = List_next(q)) {
      substring = (Substring_T) List_head(p);
      debug15(printf("substring: %u..%u\n",
		     Substring_alignstart_trim(substring) - 1U - hit->chroffset,
		     Substring_alignend_trim(substring) - hit->chroffset));
      if (Substring_overlap_point_trimmed_p(substring,common_genomicpos) == false) {
	*ilength_high += Substring_genomic_alignment_length(substring);
	if (q != NULL) {
	  junction = (Junction_T) List_head(q);
	  if (Junction_type(junction) == INS_JUNCTION) {
	    *ilength_high += Junction_nindels(junction);
	  }
	}

      } else {
	*ilength_high += ((Substring_alignstart_trim(substring) - 1) - common_genomicpos + 1);
	*ilength_low = (common_genomicpos - (Substring_alignend_trim(substring) /*+ 1*/) + 1);
	p = List_next(p);
	while (p != NULL) {
	  substring = (Substring_T) List_head(p);
	  *ilength_low += Substring_genomic_alignment_length(substring);
	  p = List_next(p);
	}
	while (q != NULL) {
	  junction = (Junction_T) List_head(q);
	  if (Junction_type(junction) == INS_JUNCTION) {
	    *ilength_low += Junction_nindels(junction);
	  }
	  q = List_next(q);
	}
	debug15(printf("Minus: Have ilength_low %d and ilength_high %d\n",*ilength_low,*ilength_high));
	return true;
      }
    }
  }

  return false;
}



/* Needed to compute overlap properly.  Based on pair_insert_length below, plus code for handling GMAP. */
static Univcoord_T
pair_common_genomicpos (Stage3end_T hit5, Stage3end_T hit3) {
  Univcoord_T common_genomicpos;
  Univcoord_T start5, end5, start3, end3;
  List_T p, q;
  Substring_T substring, substring5, substring3;

  if (hit5->plusp == true && hit3->plusp == true) {
    /* plus/plus */
    debug15(printf("Computing overlap using substrings plus/plus\n"));

    start5 = hit5->genomicstart + hit5->querystart_trimmed + start_amb_length(hit5);
    end5 = (hit5->genomicend - 1) - (hit5->querylength - hit5->queryend_trimmed) - end_amb_length(hit5);
    start3 = hit3->genomicstart + hit3->querystart_trimmed + start_amb_length(hit3);
    end3 = (hit3->genomicend - 1) - (hit3->querylength - hit3->queryend_trimmed) - end_amb_length(hit3);
    debug15(printf("hit5 endpoints are %u..%u.  hit3 endpoints are %u..%u\n",
		   start5-hit5->chroffset,end5-hit5->chroffset,start3-hit3->chroffset,end3-hit3->chroffset));

    if (end3 < start5) {
      /* Case 1 */
      return false;
    } else if (end5 < start3) {
      /* Case 6 */
      return false;
    } else if (start3 < start5) {
      if (end3 < end5) {
	/* Case 2: Tails overlap.  Go from start5 to end3 */
	debug15(printf("plus/plus case 2a: start5 %u\n",start5 - hit5->chroffset));
	for (p = hit3->substrings_1toN; p != NULL; p = List_next(p)) {
	  substring = (Substring_T) List_head(p);
	  if (Substring_overlap_point_trimmed_p(substring,start5)) {
	    return start5;
	  }
	}

	/* Case 2: Tails overlap.  Go from start5 to end3 */
	debug15(printf("plus/plus case 2b: end3 %u\n",end3 - hit3->chroffset));
	for (p = hit5->substrings_Nto1; p != NULL; p = List_next(p)) {
	  substring = (Substring_T) List_head(p);
	  if (Substring_overlap_point_trimmed_p(substring,end3)) {
	    return end3;
	  }
	}
	/* Fall through to general algorithm */

      } else {
	/* Case 3: hit3 subsumes hit5 */
	debug15(printf("plus/plus case 3\n"));
	for (p = hit3->substrings_Nto1; p != NULL; p = List_next(p)) {
	  substring = (Substring_T) List_head(p);
	  if (Substring_overlap_point_trimmed_p(substring,end5)) {
	    return end5;
	  }
	}
	/* Fall through to general algorithm */
      }

    } else {
      if (end3 < end5) {
	/* Case 4: hit5 subsumes hit3 */
	debug15(printf("plus/plus case 4\n"));
	for (p = hit5->substrings_1toN; p != NULL; p = List_next(p)) {
	  substring = (Substring_T) List_head(p);
	  if (Substring_overlap_point_trimmed_p(substring,start3)) {
	    return start3;
	  }
	}
	/* Fall through to general algorithm */

      } else {
	/* Case 5: Based on hit3_trimmed_length */
	debug15(printf("plus/plus case 5a\n"));
	for (p = hit5->substrings_1toN; p != NULL; p = List_next(p)) {
	  substring = (Substring_T) List_head(p);
	  if (Substring_overlap_point_trimmed_p(substring,start3)) {
	    return start3;
	  }
	}

	/* Case 5: Based on hit5_trimmed_length */
	debug15(printf("plus/plus case 5b\n"));
	for (p = hit3->substrings_Nto1; p != NULL; p = List_next(p)) {
	  substring = (Substring_T) List_head(p);
	  if (Substring_overlap_point_trimmed_p(substring,end5)) {
	    return end5;
	  }
	}
	/* Fall through to general algorithm */
      }
    }

    /* General algorithm */
    debug15(printf("plus/plus general\n"));
    for (p = hit3->substrings_1toN; p != NULL; p = List_next(p)) {
      substring3 = (Substring_T) List_head(p);
      for (q = hit5->substrings_1toN; q != NULL; q = List_next(q)) {
	substring5 = (Substring_T) List_head(q);
	if ((common_genomicpos = Substring_overlap_segment_trimmed(substring5,substring3)) != 0) {
	  return common_genomicpos;
	}
      }
    }

    return 0;

  } else if (hit5->plusp == true && hit3->plusp == false) {
    /* plus/minus */
    debug15(printf("Computing overlap using substrings plus/minus\n"));
    return 0;

#if 0
    start5 = hit5->genomicstart + hit5->querystart_trimmed + start_amb_length(hit5);
    end5 = hit5->genomicend - (hit5->querylength - hit5->queryend_trimmed) - end_amb_length(hit5);
    start3 = hit3->genomicstart - hit3->querystart_trimmed - start_amb_length(hit3);
    end3 = hit3->genomicend + (hit3->querylength - hit3->queryend_trimmed) + end_amb_length(hit3);

    if (start3 < start5) {
      /* Case 1 */
      return 0;
    } else if (end5 < end3) {
      /* Case 6 */
      return 0;
    } else if (end3 < start5) {
      if (start3 < end5) {
	/* Case 2: Tails overlap.  Go from start5 to start3 */
	debug15(printf("plus case 2a: start5 %u\n",start5 - hit5->chroffset));
	if (Substring_overlap_point_trimmed_p(hit3->substring0,start5)) {
	  return start5;
	} else if (Substring_overlap_point_trimmed_p(hit3->substring1,start5)) {
	  return start5;
	} else if (Substring_overlap_point_trimmed_p(hit3->substring2,start5)) {
	  return start5;
	}

	/* Case 2: Tails overlap.  Go from start5 to start3 */
	debug15(printf("plus case 2b: start3 %u\n",start3 - hit3->chroffset));
	if (Substring_overlap_point_trimmed_p(hit5->substring2,start3)) {
	  return start3;
	} else if (Substring_overlap_point_trimmed_p(hit5->substring1,start3)) {
	  return start3;
	} else if (Substring_overlap_point_trimmed_p(hit5->substring0,start3)) {
	  return start3;
	}
	/* Fall through to general algorithm */

      } else {
	/* Case 3: hit3 subsumes hit5 */
	debug15(printf("plus case 3\n"));
	if (Substring_overlap_point_trimmed_p(hit3->substring2,end5)) {
	  return end5;
	} else if (Substring_overlap_point_trimmed_p(hit3->substring1,end5)) {
	  return end5;
	} else if (Substring_overlap_point_trimmed_p(hit3->substring0,end5)) {
	  return end5;
	}
	/* Fall through to general algorithm */
      }

    } else {
      if (start3 < end5) {
	/* Case 4: hit5 subsumes hit3 */
	debug15(printf("plus case 4\n"));
	if (Substring_overlap_point_trimmed_p(hit5->substring0,end3)) {
	  return end3;
	} else if (Substring_overlap_point_trimmed_p(hit5->substring1,end3)) {
	  return end3;
	} else if (Substring_overlap_point_trimmed_p(hit5->substring2,end3)) {
	  return end3;
	}
	/* Fall through to general algorithm */

      } else {
	/* Case 5: Based on hit3_trimmed_length */
	debug15(printf("plus case 5a\n"));
	if (Substring_overlap_point_trimmed_p(hit5->substring0,end3)) {
	  return end3;
	} else if (Substring_overlap_point_trimmed_p(hit5->substring1,end3)) {
	  return end3;
	} else if (Substring_overlap_point_trimmed_p(hit5->substring2,end3)) {
	  return end3;
	}

	/* Case 5: Based on hit5_trimmed_length */
	debug15(printf("plus case 5b\n"));
	if (Substring_overlap_point_trimmed_p(hit3->substring2,end5)) {
	  return end5;
	} else if (Substring_overlap_point_trimmed_p(hit3->substring1,end5)) {
	  return end5;
	} else if (Substring_overlap_point_trimmed_p(hit3->substring0,end5)) {
	  return end5;
	}
	/* Fall through to general algorithm */
      }
    }

    /* General algorithm */
    debug15(printf("plus general: hit3->substring1\n"));
    if ((common_genomicpos = Substring_overlap_segment_trimmed(hit5->substring1,hit3->substring1)) != 0) {
      return common_genomicpos;
    } else if (hit5->substring2 != NULL &&
	       (common_genomicpos = Substring_overlap_segment_trimmed(hit5->substring2,hit3->substring1)) != 0) {
      return common_genomicpos;
    } else if (hit5->substring0 != NULL &&
	       (common_genomicpos = Substring_overlap_segment_trimmed(hit5->substring0,hit3->substring1)) != 0) {
      return common_genomicpos;
    }

    if (hit3->substring2 != NULL) {
      debug15(printf("plus general: hit3->substring2\n"));
      if ((common_genomicpos = Substring_overlap_segment_trimmed(hit5->substring1,hit3->substring2)) != 0) {
	return common_genomicpos;
      } else if (hit5->substring2 != NULL &&
		 (common_genomicpos = Substring_overlap_segment_trimmed(hit5->substring2,hit3->substring2)) != 0) {
	return common_genomicpos;
      } else if (hit5->substring0 != NULL &&
		 (common_genomicpos = Substring_overlap_segment_trimmed(hit5->substring0,hit3->substring2)) != 0) {
	return common_genomicpos;
      }
    }

    if (hit3->substring0 != NULL) {
      debug15(printf("plus general: hit3->substring0\n"));
      if ((common_genomicpos = Substring_overlap_segment_trimmed(hit5->substring1,hit3->substring0)) != 0) {
	return common_genomicpos;
      } else if (hit5->substring2 != NULL &&
		 (common_genomicpos = Substring_overlap_segment_trimmed(hit5->substring2,hit3->substring0)) != 0) {
	return common_genomicpos;
      } else if (hit5->substring0 != NULL &&
		 (common_genomicpos = Substring_overlap_segment_trimmed(hit5->substring0,hit3->substring0)) != 0) {
	return common_genomicpos;
      }
    }

    return 0U;
#endif

  } else if (hit5->plusp == false && hit3->plusp == true) {
    /* minus/plus */
    debug15(printf("Computing overlap using substrings minus/plus\n"));
    return 0;

#if 0
    start5 = hit5->genomicstart - hit5->querystart_trimmed - start_amb_length(hit5);
    end5 = hit5->genomicend + (hit5->querylength - hit5->queryend_trimmed) + end_amb_length(hit5);
    start3 = hit3->genomicstart + hit3->querystart_trimmed + start_amb_length(hit3);
    end3 = hit3->genomicend - (hit3->querylength - hit3->queryend_trimmed) - end_amb_length(hit3);

    if (end3 < end5) {
      /* Case 1 */
      return 0;
    } else if (start5 < start3) {
      /* Case 6 */
      return 0;
    } else if (start3 < end5) {
      if (end3 < start5) {
	/* Case 2: Tails overlap.  Go from end5 to end3 */
	debug15(printf("plus case 2a: end5 %u\n",end5 - hit5->chroffset));
	if (Substring_overlap_point_trimmed_p(hit3->substring0,end5)) {
	  return end5;
	} else if (Substring_overlap_point_trimmed_p(hit3->substring1,end5)) {
	  return end5;
	} else if (Substring_overlap_point_trimmed_p(hit3->substring2,end5)) {
	  return end5;
	}

	/* Case 2: Tails overlap.  Go from end5 to end3 */
	debug15(printf("plus case 2b: end3 %u\n",end3 - hit3->chroffset));
	if (Substring_overlap_point_trimmed_p(hit5->substring2,end3)) {
	  return end3;
	} else if (Substring_overlap_point_trimmed_p(hit5->substring1,end3)) {
	  return end3;
	} else if (Substring_overlap_point_trimmed_p(hit5->substring0,end3)) {
	  return end3;
	}
	/* Fall through to general algorithm */

      } else {
	/* Case 3: hit3 subsumes hit5 */
	debug15(printf("plus case 3\n"));
	if (Substring_overlap_point_trimmed_p(hit3->substring2,start5)) {
	  return start5;
	} else if (Substring_overlap_point_trimmed_p(hit3->substring1,start5)) {
	  return start5;
	} else if (Substring_overlap_point_trimmed_p(hit3->substring0,start5)) {
	  return start5;
	}
	/* Fall through to general algorithm */
      }

    } else {
      if (end3 < start5) {
	/* Case 4: hit5 subsumes hit3 */
	debug15(printf("plus case 4\n"));
	if (Substring_overlap_point_trimmed_p(hit5->substring0,start3)) {
	  return start3;
	} else if (Substring_overlap_point_trimmed_p(hit5->substring1,start3)) {
	  return start3;
	} else if (Substring_overlap_point_trimmed_p(hit5->substring2,start3)) {
	  return start3;
	}
	/* Fall through to general algorithm */

      } else {
	/* Case 5: Based on hit3_trimmed_length */
	debug15(printf("plus case 5a\n"));
	if (Substring_overlap_point_trimmed_p(hit5->substring0,start3)) {
	  return start3;
	} else if (Substring_overlap_point_trimmed_p(hit5->substring1,start3)) {
	  return start3;
	} else if (Substring_overlap_point_trimmed_p(hit5->substring2,start3)) {
	  return start3;
	}

	/* Case 5: Based on hit5_trimmed_length */
	debug15(printf("plus case 5b\n"));
	if (Substring_overlap_point_trimmed_p(hit3->substring2,start5)) {
	  return start5;
	} else if (Substring_overlap_point_trimmed_p(hit3->substring1,start5)) {
	  return start5;
	} else if (Substring_overlap_point_trimmed_p(hit3->substring0,start5)) {
	  return start5;
	}
	/* Fall through to general algorithm */
      }
    }

    /* General algorithm */
    debug15(printf("plus general: hit3->substring1\n"));
    if ((common_genomicpos = Substring_overlap_segment_trimmed(hit5->substring1,hit3->substring1)) != 0) {
      return common_genomicpos;
    } else if (hit5->substring2 != NULL &&
	       (common_genomicpos = Substring_overlap_segment_trimmed(hit5->substring2,hit3->substring1)) != 0) {
      return common_genomicpos;
    } else if (hit5->substring0 != NULL &&
	       (common_genomicpos = Substring_overlap_segment_trimmed(hit5->substring0,hit3->substring1)) != 0) {
      return common_genomicpos;
    }

    if (hit3->substring2 != NULL) {
      debug15(printf("plus general: hit3->substring2\n"));
      if ((common_genomicpos = Substring_overlap_segment_trimmed(hit5->substring1,hit3->substring2)) != 0) {
	return common_genomicpos;
      } else if (hit5->substring2 != NULL &&
		 (common_genomicpos = Substring_overlap_segment_trimmed(hit5->substring2,hit3->substring2)) != 0) {
	return common_genomicpos;
      } else if (hit5->substring0 != NULL &&
		 (common_genomicpos = Substring_overlap_segment_trimmed(hit5->substring0,hit3->substring2)) != 0) {
	return common_genomicpos;
      }
    }

    if (hit3->substring0 != NULL) {
      debug15(printf("plus general: hit3->substring0\n"));
      if ((common_genomicpos = Substring_overlap_segment_trimmed(hit5->substring1,hit3->substring0)) != 0) {
	return common_genomicpos;
      } else if (hit5->substring2 != NULL &&
		 (common_genomicpos = Substring_overlap_segment_trimmed(hit5->substring2,hit3->substring0)) != 0) {
	return common_genomicpos;
      } else if (hit5->substring0 != NULL &&
		 (common_genomicpos = Substring_overlap_segment_trimmed(hit5->substring0,hit3->substring0)) != 0) {
	return common_genomicpos;
      }
    }

    return 0;
#endif

  } else if (hit5->plusp == false && hit3->plusp == false) {
    /* minus/minus */
    debug15(printf("Computing overlap using substrings minus/minus\n"));

    start5 = (hit5->genomicstart - 1) - hit5->querystart_trimmed /*- start_amb_length(hit5)*/;
    end5 = hit5->genomicend + (hit5->querylength - hit5->queryend_trimmed) /*+ end_amb_length(hit5)*/;
    start3 = (hit3->genomicstart - 1) - hit3->querystart_trimmed /*- start_amb_length(hit3)*/;
    end3 = hit3->genomicend + (hit3->querylength - hit3->queryend_trimmed) /*+ end_amb_length(hit3)*/;
    debug15(printf("hit5 endpoints are %u..%u.  hit3 endpoints are %u..%u\n",
		   start5-hit5->chroffset,end5-hit5->chroffset,start3-hit3->chroffset,end3-hit3->chroffset));

    if (end3 > start5) {
      /* Case 1 */
      return 0;
    } else if (end5 > start3) {
      /* Case 6 */
      return 0;
    } else if (start3 > start5) {
      if (end3 > end5) {
	/* Case 2: Tails overlap.  Go from start5 to end3 */
	debug15(printf("minus/minus case 2a: start5 %llu (%u)\n",start5,start5 - hit5->chroffset));
	for (p = hit3->substrings_1toN; p != NULL; p = List_next(p)) {
	  substring = (Substring_T) List_head(p);
	  if (Substring_overlap_point_trimmed_p(substring,start5)) {
	    return start5;
	  }
	}

	/* Case 2: Tails overlap.  Go from start5 to end3 */
	debug15(printf("plus case 2b: end3 %u\n",end3 - hit3->chroffset));
	for (p = hit5->substrings_Nto1; p != NULL; p = List_next(p)) {
	  substring = (Substring_T) List_head(p);
	  if (Substring_overlap_point_trimmed_p(substring,end3)) {
	    return end3;
	  }
	}
	/* Fall through to general algorithm */

      } else {
	/* Case 3: hit3 subsumes hit5 */
	debug15(printf("minus/minus case 3: end5 %u\n",end5 - hit5->chroffset));
	for (p = hit3->substrings_1toN; p != NULL; p = List_next(p)) {
	  substring = (Substring_T) List_head(p);
	  if (Substring_overlap_point_trimmed_p(substring,end5)) {
	    return end5;
	  }
	}

	/* Fall through to general algorithm */
      }

    } else {
      if (end3 > end5) {
	/* Case 4: hit5 subsumes hit3 */
	debug15(printf("minus/minus case 4: start3 %u\n",(Chrpos_T) (start3 - hit3->chroffset)));
	for (p = hit5->substrings_1toN; p != NULL; p = List_next(p)) {
	  substring = (Substring_T) List_head(p);
	  if (Substring_overlap_point_trimmed_p(substring,start3)) {
	    return start3;
	  }
	}
	/* Fall through to general algorithm */

      } else {
	/* Case 5: Based on hit3_trimmed_length */
	debug15(printf("minus case 5a: start3 %u\n",start3 - hit3->chroffset));
	for (p = hit5->substrings_1toN; p != NULL; p = List_next(p)) {
	  substring = (Substring_T) List_head(p);
	  if (Substring_overlap_point_trimmed_p(substring,start3)) {
	    return start3;
	  }
	}

	/* Case 5: Based on hit5_trimmed_length */
	debug15(printf("minus case 5b: end5 %u\n",end5 - hit5->chroffset));
	for (p = hit3->substrings_Nto1; p != NULL; p = List_next(p)) {
	  substring = (Substring_T) List_head(p);
	  if (Substring_overlap_point_trimmed_p(substring,end5)) {
	    return end5;
	  }
	}
	/* Fall through to general algorithm */
      }
    }

    /* General algorithm */
    debug15(printf("minus/minus general\n"));
    for (p = hit3->substrings_1toN; p != NULL; p = List_next(p)) {
      substring3 = (Substring_T) List_head(p);
      for (q = hit5->substrings_1toN; q != NULL; q = List_next(q)) {
	substring5 = (Substring_T) List_head(q);
	if ((common_genomicpos = Substring_overlap_segment_trimmed(substring5,substring3)) != 0) {
	  return common_genomicpos;
	}
      }
    }

    return 0;

  } else {
    abort();
    return 0;
  }
}


static bool
test_hardclips (Univcoord_T *common_genomicpos, int hardclip_low, Stage3end_T hit_low,
		int hardclip_high, Stage3end_T hit_high, Univcoord_T chroffset) {
  Substring_T low_substring, high_substring;
  int low_querypos, high_querypos;
  int low_querylength, high_querylength;
  bool plusp;

  low_querylength = hit_low->querylength;
  high_querylength = hit_high->querylength;

  debug15(printf("Entering test_hardclips with hardclip_low %d, hardclip_high %d\n",
		 hardclip_low,hardclip_high));
  debug15(printf("querylength_low %d, querylength_high %d\n",low_querylength,high_querylength));

  plusp = Stage3end_plusp(hit_low);

  if (plusp == true) {
    low_querypos = hardclip_low;
    high_querypos = high_querylength /*- 1*/ - hardclip_high;
    debug15(printf("Both substrings, plus.  low_querypos %d, high_querypos %d\n",low_querypos,high_querypos));

    if ((low_substring = Stage3end_substring_containing(hit_low,low_querypos)) == NULL) {
      debug15(printf("Fails because low_querypos %d gives a NULL substring\n",low_querypos));
      return false;
    } else if (Stage3end_substring_containing(hit_low,low_querypos-1) != low_substring) {
      debug15(printf("Fails because low_querypos %d - 1 gives substring %p\n",
		     low_querypos,Stage3end_substring_containing(hit_low,low_querypos-1)));
      return false;
    } else if (Stage3end_substring_containing(hit_low,low_querypos+1) != low_substring) {
      debug15(printf("Fails because low_querypos %d + 1 gives substring %p\n",
		     low_querypos,Stage3end_substring_containing(hit_low,low_querypos+1)));
      return false;
    } else if ((high_substring = Stage3end_substring_containing(hit_high,high_querypos)) == NULL) {
      debug15(printf("Fails because high_querypos %d gives a NULL substring\n",high_querypos));
      return false;
    } else if (Stage3end_substring_containing(hit_high,high_querypos-1) != high_substring) {
      debug15(printf("Fails because high_querypos %d - 1 gives substring %p\n",
		     high_querypos,Stage3end_substring_containing(hit_high,high_querypos-1)));
      return false;
    } else if (Stage3end_substring_containing(hit_high,high_querypos+1) != high_substring) {
      debug15(printf("Fails because high_querypos %d + 1 gives substring %p\n",
		     high_querypos,Stage3end_substring_containing(hit_high,high_querypos+1)));
      return false;
    } else if (Substring_genomicstart(low_substring) + low_querypos - chroffset != Substring_genomicstart(high_substring) + high_querypos - chroffset) {
      debug15(printf("Fails because low chrpos %u != high chrpos %u\n",
		     Substring_genomicstart(low_substring) + low_querypos - chroffset,
		     Substring_genomicstart(high_substring) + high_querypos - chroffset));
      return false;
    } else {
      *common_genomicpos = Substring_genomicstart(low_substring) + low_querypos; /* Want univcoord */
      debug15(printf("Succeeds with common point %u\n",*common_genomicpos - chroffset));
      return true;
    }

  } else {
    low_querypos = low_querylength /*- 1*/ - hardclip_low;
    high_querypos = hardclip_high;
    debug15(printf("Both substrings, minus.  low_querypos %d, high_querypos %d\n",low_querypos,high_querypos));

    if ((low_substring = Stage3end_substring_containing(hit_low,low_querypos)) == NULL) {
      debug15(printf("Fails because low_querypos %d gives a NULL substring\n",low_querypos));
      return false;
    } else if (Stage3end_substring_containing(hit_low,low_querypos-1) != low_substring) {
      debug15(printf("Fails because low_querypos %d - 1 gives substring %p\n",
		     low_querypos,Stage3end_substring_containing(hit_low,low_querypos-1)));
      return false;
    } else if (Stage3end_substring_containing(hit_low,low_querypos+1) != low_substring) {
      debug15(printf("Fails because low_querypos %d + 1 gives substring %p\n",
		     low_querypos,Stage3end_substring_containing(hit_low,low_querypos+1)));
      return false;
    } else if ((high_substring = Stage3end_substring_containing(hit_high,high_querypos)) == NULL) {
      debug15(printf("Fails because high_querypos %d gives a NULL substring\n",high_querypos));
      return false;
    } else if (Stage3end_substring_containing(hit_high,high_querypos-1) != high_substring) {
      debug15(printf("Fails because high_querypos %d - 1 gives substring %p\n",
		     high_querypos,Stage3end_substring_containing(hit_high,high_querypos-1)));
      return false;
    } else if (Stage3end_substring_containing(hit_high,high_querypos+1) != high_substring) {
      debug15(printf("Fails because high_querypos %d + 1 gives substring %p\n",
		     high_querypos,Stage3end_substring_containing(hit_high,high_querypos+1)));
      return false;
    }  else if ((Substring_genomicstart(low_substring) - 1) - low_querypos - chroffset != (Substring_genomicstart(high_substring) - 1) - high_querypos - chroffset) {
      debug15(printf("Fails because low chrpos %u != high chrpos %u\n",
		     (Substring_genomicstart(low_substring) - 1) - low_querypos - chroffset,
		     (Substring_genomicstart(high_substring) - 1) - high_querypos - chroffset));
      return false;
    } else {
      *common_genomicpos = (Substring_genomicstart(low_substring) - 1) - low_querypos; /* Want univcoord */
      debug15(printf("Succeeds with common point %u\n",*common_genomicpos - chroffset));
      return true;
    }
  }
}



/* Replaces adjust_hardclips in samprint.c */
static Univcoord_T
adjust_hardclips_right (int *shift, int hardclip_low, Stage3end_T hit_low,
			int hardclip_high, Stage3end_T hit_high, Univcoord_T chroffset) {
  Substring_T low_substring, high_substring;
  int low_querypos, high_querypos;
  int low_querylength, high_querylength;
  Chrpos_T low_chrpos, high_chrpos;
  bool plusp;


  low_querylength = hit_low->querylength;
  high_querylength = hit_high->querylength;

  debug15(printf("Entering adjust_hardclips_right with hardclip_low %d, hardclip_high %d\n",
		 hardclip_low,hardclip_high));
  *shift = 1;			/* Making an initial move before each while loop */
  plusp = Stage3end_plusp(hit_low);

  if (plusp == true) {
    low_querypos = hardclip_low;
    high_querypos = high_querylength /*- 1*/ - hardclip_high;
    debug15(printf("Both substrings, plus.  low_querypos %d, high_querypos %d\n",low_querypos,high_querypos));

    low_querypos++;
    high_querypos++;
    debug15(printf("right shift %d: Advancing to low_querypos %d and high_querypos %d\n",*shift,low_querypos,high_querypos));
    while ((low_querypos + 1) < low_querylength && (high_querypos + 1) < high_querylength &&
	   ((low_substring = Stage3end_substring_containing(hit_low,low_querypos)) == NULL ||
	    Stage3end_substring_containing(hit_low,low_querypos-1) != low_substring ||
	    Stage3end_substring_containing(hit_low,low_querypos+1) != low_substring ||
	    (high_substring = Stage3end_substring_containing(hit_high,high_querypos)) == NULL ||
	    Stage3end_substring_containing(hit_high,high_querypos-1) != high_substring ||
	    Stage3end_substring_containing(hit_high,high_querypos+1) != high_substring ||
	    Substring_genomicstart(low_substring) + low_querypos - chroffset != Substring_genomicstart(high_substring) + high_querypos - chroffset)) {
      (*shift) += 1;
      if ((low_substring = Stage3end_substring_containing(hit_low,low_querypos)) == NULL) {
	low_querypos++;
      } else if ((high_substring = Stage3end_substring_containing(hit_high,high_querypos)) == NULL) {
	high_querypos++;
      } else {
	low_chrpos = Substring_genomicstart(low_substring) + low_querypos - chroffset;
	high_chrpos = Substring_genomicstart(high_substring) + high_querypos - chroffset;
	if (low_chrpos < high_chrpos) {
	  debug15(printf("low_chrpos %u < high_chrpos %u, so advancing low_querypos\n",low_chrpos,high_chrpos));
	  low_querypos++;
	} else if (high_chrpos < low_chrpos) {
	  debug15(printf("high_chrpos %u < low_chrpos %u, so advancing high_querypos\n",high_chrpos,low_chrpos));
	  high_querypos++;
	} else {
	  low_querypos++;
	  high_querypos++;
	}
      }
      debug15(printf("right shift %d: Advancing to low_querypos %d and high_querypos %d\n",*shift,low_querypos,high_querypos));
    }

    if ((low_querypos + 1) >= low_querylength ||
	(high_querypos + 1) >= high_querylength ||
	(low_substring = Stage3end_substring_containing(hit_low,low_querypos)) == NULL ||
	Stage3end_substring_containing(hit_high,high_querypos) == NULL) {
      *shift = 0;
      return 0;
    } else {
      debug15(printf("Returning %u + %d\n",Substring_genomicstart(low_substring) - chroffset,
		     low_querypos));
      assert((low_substring = Stage3end_substring_containing(hit_low,low_querypos)) != NULL);
      assert((high_substring = Stage3end_substring_containing(hit_high,high_querypos)) != NULL);
      assert(Stage3end_substring_containing(hit_low,low_querypos-1) == low_substring);
      assert(Stage3end_substring_containing(hit_low,low_querypos+1) == low_substring);
      assert(Stage3end_substring_containing(hit_high,high_querypos-1) == high_substring);
      assert(Stage3end_substring_containing(hit_high,high_querypos+1) == high_substring);
      return Substring_genomicstart(low_substring) + low_querypos; /* Want univcoord */
    }

  } else {
    low_querypos = low_querylength /*- 1*/ - hardclip_low;
    high_querypos = hardclip_high;
    debug15(printf("Both substrings, minus.  low_querypos %d, high_querypos %d\n",low_querypos,high_querypos));

    low_querypos--;
    high_querypos--;
    debug15(printf("right shift %d: Advancing to low_querypos %d and high_querypos %d\n",*shift,low_querypos,high_querypos));
    while ((low_querypos - 1) >= 0 && (high_querypos - 1) >= 0 &&
	   ((low_substring = Stage3end_substring_containing(hit_low,low_querypos)) == NULL ||
	    Stage3end_substring_containing(hit_low,low_querypos-1) != low_substring ||
	    Stage3end_substring_containing(hit_low,low_querypos+1) != low_substring ||
	    (high_substring = Stage3end_substring_containing(hit_high,high_querypos)) == NULL ||
	    Stage3end_substring_containing(hit_high,high_querypos-1) != high_substring ||
	    Stage3end_substring_containing(hit_high,high_querypos+1) != high_substring ||
	    (Substring_genomicstart(low_substring) - 1) - low_querypos - chroffset != (Substring_genomicstart(high_substring) - 1) - high_querypos - chroffset)) {
      (*shift) += 1;
      if ((low_substring = Stage3end_substring_containing(hit_low,low_querypos)) == NULL) {
	low_querypos--;
      } else if ((high_substring = Stage3end_substring_containing(hit_high,high_querypos)) == NULL) {
	high_querypos--;
      } else {
	low_chrpos = (Substring_genomicstart(low_substring) - 1) - low_querypos - chroffset;
	high_chrpos = (Substring_genomicstart(high_substring) - 1) - high_querypos - chroffset;
	if (low_chrpos < high_chrpos) {
	  debug15(printf("low_chrpos %u < high_chrpos %u, so decreasing low_querypos\n",low_chrpos,high_chrpos));
	  low_querypos--;
	} else if (high_chrpos < low_chrpos) {
	  debug15(printf("high_chrpos %u < low_chrpos %u, so decreasing high_querypos\n",high_chrpos,low_chrpos));
	  high_querypos--;
	} else {
	  low_querypos--;
	  high_querypos--;
	}
      }
      debug15(printf("right shift %d: Advancing to low_querypos %d and high_querypos %d\n",*shift,low_querypos,high_querypos));
    }

    if ((low_querypos - 1) < 0 ||
	(high_querypos - 1) < 0 ||
	(low_substring = Stage3end_substring_containing(hit_low,low_querypos)) == NULL ||
	Stage3end_substring_containing(hit_high,high_querypos) == NULL) {
      *shift = 0;
      return 0;
    } else {
      debug15(printf("Returning %u - %d\n",Substring_genomicstart(low_substring) - chroffset,
		     low_querypos));
      assert((low_substring = Stage3end_substring_containing(hit_low,low_querypos)) != NULL);
      assert((high_substring = Stage3end_substring_containing(hit_high,high_querypos)) != NULL);
      assert(Stage3end_substring_containing(hit_low,low_querypos-1) == low_substring);
      assert(Stage3end_substring_containing(hit_low,low_querypos+1) == low_substring);
      assert(Stage3end_substring_containing(hit_high,high_querypos-1) == high_substring);
      assert(Stage3end_substring_containing(hit_high,high_querypos+1) == high_substring);
      return (Substring_genomicstart(low_substring) - 1) - low_querypos; /* Want univcoord */
    }
  }
}


/* Replaces adjust_hardclips in samprint.c */
static Univcoord_T
adjust_hardclips_left (int *shift, int hardclip_low, Stage3end_T hit_low,
		       int hardclip_high, Stage3end_T hit_high, Univcoord_T chroffset) {
  Substring_T low_substring, high_substring;
  int low_querypos, high_querypos;
  int low_querylength, high_querylength;
  Chrpos_T low_chrpos, high_chrpos;
  bool plusp;


  low_querylength = hit_low->querylength;
  high_querylength = hit_high->querylength;

  debug15(printf("Entering adjust_hardclips_left with hardclip_low %d, hardclip_high %d\n",
		 hardclip_low,hardclip_high));
  *shift = 1;			/* Making an initial move before each while loop */
  plusp = Stage3end_plusp(hit_low);

  if (plusp == true) {
    low_querypos = hardclip_low;
    high_querypos = high_querylength /*- 1*/ - hardclip_high;
    debug15(printf("Both substrings, plus.  low_querypos %d, high_querypos %d\n",low_querypos,high_querypos));

    low_querypos--;
    high_querypos--;
    debug15(printf("left shift %d: Advancing to low_querypos %d and high_querypos %d\n",*shift,low_querypos,high_querypos));
    while ((low_querypos - 1) >= 0 && (high_querypos - 1) >= 0 &&
	   ((low_substring = Stage3end_substring_containing(hit_low,low_querypos)) == NULL ||
	    Stage3end_substring_containing(hit_low,low_querypos-1) != low_substring ||
	    Stage3end_substring_containing(hit_low,low_querypos+1) != low_substring ||
	    (high_substring = Stage3end_substring_containing(hit_high,high_querypos)) == NULL ||
	    Stage3end_substring_containing(hit_high,high_querypos-1) != high_substring ||
	    Stage3end_substring_containing(hit_high,high_querypos+1) != high_substring ||
	    Substring_genomicstart(low_substring) + low_querypos - chroffset != Substring_genomicstart(high_substring) + high_querypos - chroffset)) {
      (*shift) += 1;
      if ((low_substring = Stage3end_substring_containing(hit_low,low_querypos)) == NULL) {
	low_querypos--;
      } else if ((high_substring = Stage3end_substring_containing(hit_high,high_querypos)) == NULL) {
	high_querypos--;
      } else {
	low_chrpos = Substring_genomicstart(low_substring) + low_querypos - chroffset;
	high_chrpos = Substring_genomicstart(high_substring) + high_querypos - chroffset;
	if (low_chrpos > high_chrpos) {
	  debug15(printf("low_chrpos %u > high_chrpos %u, so decreasing low_querypos\n",low_chrpos,high_chrpos));
	  low_querypos--;
	} else if (high_chrpos > low_chrpos) {
	  debug15(printf("high_chrpos %u > low_chrpos %u, so decreasing high_querypos\n",high_chrpos,low_chrpos));
	  high_querypos--;
	} else {
	  low_querypos--;
	  high_querypos--;
	}
      }
      debug15(printf("left shift %d: Advancing to low_querypos %d and high_querypos %d\n",*shift,low_querypos,high_querypos));
    }

    if ((low_querypos - 1) < 0 || (high_querypos - 1) < 0 ||
	(low_substring = Stage3end_substring_containing(hit_low,low_querypos)) == NULL ||
	Stage3end_substring_containing(hit_high,high_querypos) == NULL) {
      *shift = 0;
      return 0;
    } else {
      debug15(printf("Returning %u + %d\n",Substring_genomicstart(low_substring) - chroffset,
		     low_querypos));
      assert((low_substring = Stage3end_substring_containing(hit_low,low_querypos)) != NULL);
      assert((high_substring = Stage3end_substring_containing(hit_high,high_querypos)) != NULL);
      assert(Stage3end_substring_containing(hit_low,low_querypos-1) == low_substring);
      assert(Stage3end_substring_containing(hit_low,low_querypos+1) == low_substring);
      assert(Stage3end_substring_containing(hit_high,high_querypos-1) == high_substring);
      assert(Stage3end_substring_containing(hit_high,high_querypos+1) == high_substring);
      return Substring_genomicstart(low_substring) + low_querypos; /* Want univcoord */
    }

  } else {
    low_querypos = low_querylength /*- 1*/ - hardclip_low;
    high_querypos = hardclip_high;
    debug15(printf("Both substrings, minus.  low_querypos %d, high_querypos %d\n",low_querypos,high_querypos));

    low_querypos++;
    high_querypos++;
    debug15(printf("left shift %d: Advancing to low_querypos %d and high_querypos %d\n",*shift,low_querypos,high_querypos));
    while ((low_querypos + 1) < low_querylength && (high_querypos + 1) < high_querylength &&
	   ((low_substring = Stage3end_substring_containing(hit_low,low_querypos)) == NULL ||
	    Stage3end_substring_containing(hit_low,low_querypos-1) != low_substring ||
	    Stage3end_substring_containing(hit_low,low_querypos+1) != low_substring ||
	    (high_substring = Stage3end_substring_containing(hit_high,high_querypos)) == NULL ||
	    Stage3end_substring_containing(hit_high,high_querypos-1) != high_substring ||
	    Stage3end_substring_containing(hit_high,high_querypos+1) != high_substring ||
	    (Substring_genomicstart(low_substring) - 1) - low_querypos - chroffset != (Substring_genomicstart(high_substring) - 1) - high_querypos - chroffset)) {
      (*shift) += 1;
      if ((low_substring = Stage3end_substring_containing(hit_low,low_querypos)) == NULL) {
	low_querypos++;
      } else if ((high_substring = Stage3end_substring_containing(hit_high,high_querypos)) == NULL) {
	high_querypos++;
      } else {
	low_chrpos = (Substring_genomicstart(low_substring) - 1) - low_querypos - chroffset;
	high_chrpos = (Substring_genomicstart(high_substring) - 1) - high_querypos - chroffset;
	if (low_chrpos > high_chrpos) {
	  debug15(printf("low_chrpos %u > high_chrpos %u, so advancing low_querypos\n",low_chrpos,high_chrpos));
	  low_querypos++;
	} else if (high_chrpos > low_chrpos) {
	  debug15(printf("high_chrpos %u > low_chrpos %u, so advancing high_querypos\n",high_chrpos,low_chrpos));
	  high_querypos++;
	} else {
	  low_querypos++;
	  high_querypos++;
	}
      }
      debug15(printf("left shift %d: Advancing to low_querypos %d and high_querypos %d\n",*shift,low_querypos,high_querypos));
    }

    if ((low_querypos + 1) >= low_querylength || (high_querypos + 1) >= high_querylength ||
	(low_substring = Stage3end_substring_containing(hit_low,low_querypos)) == NULL ||
	Stage3end_substring_containing(hit_high,high_querypos) == NULL) {
      *shift = 0;
      return 0;
    } else {
      debug15(printf("Returning %u - %d\n",Substring_genomicstart(low_substring) - chroffset,
		     low_querypos));
      assert((low_substring = Stage3end_substring_containing(hit_low,low_querypos)) != NULL);
      assert((high_substring = Stage3end_substring_containing(hit_high,high_querypos)) != NULL);
      assert(Stage3end_substring_containing(hit_low,low_querypos-1) == low_substring);
      assert(Stage3end_substring_containing(hit_low,low_querypos+1) == low_substring);
      assert(Stage3end_substring_containing(hit_high,high_querypos-1) == high_substring);
      assert(Stage3end_substring_containing(hit_high,high_querypos+1) == high_substring);
      return (Substring_genomicstart(low_substring) - 1) - low_querypos; /* Want univcoord */
    }
  }
}



/* Note: Do not alter this->insertlength, which is used for SAM
   output.  The insertlength computed here is used only for performing
   --clip-overlap or --merge-overlap */
int
Stage3pair_overlap (int *hardclip5_low, int *hardclip5_high, int *hardclip3_low, int *hardclip3_high, Stage3pair_T this) {
  Stage3end_T hit5, hit3;
  int clipdir;
  int ilength53, ilength35, ilength5_low, ilength5_high, ilength3_low, ilength3_high;
  int common_shift, common_left, common_right;
  Univcoord_T common_genomicpos, common_genomicpos_right, common_genomicpos_left;
  int shift_right, shift_left;
#ifdef DEBUG15
  int overlap;
#endif


  *hardclip5_low = *hardclip5_high = *hardclip3_low = *hardclip3_high = 0;

  hit5 = this->hit5;
  hit3 = this->hit3;

  debug15(printf("Entered Stage3pair_overlap with hittype %s and %s\n",
		 hittype_string(hit5->hittype),hittype_string(hit3->hittype)));
  if (hit5->hittype == SAMECHR_SPLICE || hit5->hittype == TRANSLOC_SPLICE) {
    return 0;
  } else if (hit3->hittype == SAMECHR_SPLICE || hit3->hittype == TRANSLOC_SPLICE) {
    return 0;
  } else if (hit5->plusp != hit3->plusp) {
    debug15(printf("The two ends are not on the same strand, so returning 0\n"));
    return 0;
  } else {
    debug15(printf("hit5 querystart_trimmed %d + amb_start %d, queryend_trimmed %d + amb_end %d, hit3 querystart_trimmed %d + amb_start %d, queryend_trimmed %d + amb_end %d\n",
		   hit5->querystart_trimmed,start_amb_length(hit5),hit5->queryend_trimmed,end_amb_length(hit5),
		   hit3->querystart_trimmed,start_amb_length(hit3),hit3->queryend_trimmed,end_amb_length(hit3)));
    if (hit5->plusp == true) {
      /* plus */
#if 0
      hit5_trimmed_length = hit5->querylength - hit5->querystart_trimmed - hit5->queryend_trimmed - start_amb_length(hit5) - end_amb_length(hit5);
      hit3_trimmed_length = hit3->querylength - hit3->querystart_trimmed - hit3->queryend_trimmed - start_amb_length(hit3) - end_amb_length(hit3);
      totallength = hit5_trimmed_length + hit3_trimmed_length;
      debug15(printf("totallength = %d, hit5 trimmed length = %d, hit3 trimmed length = %d\n",
		     totallength,hit5_trimmed_length,hit3_trimmed_length));
      debug15(printf("original insertlength: %d, trim+amb5: %d..%d, trim+amb3: %d..%d\n",
		     this->insertlength,hit5->querystart_trimmed + start_amb_length(hit5),
		     hit5->queryend_trimmed + end_amb_length(hit5),hit3->querystart_trimmed + start_amb_length(hit3),
		     hit3->queryend_trimmed + end_amb_length(hit3)));
#endif

      if ((common_genomicpos = pair_common_genomicpos(hit5,hit3)) == 0) {
	debug15(printf("Cannot determine a common point, so returning 0\n"));
	return 0;

      } else if (find_ilengths(&ilength5_low,&ilength5_high,hit5,common_genomicpos) == false ||
		 find_ilengths(&ilength3_low,&ilength3_high,hit3,common_genomicpos) == false) {
	debug15(printf("Cannot determine ilengths, so returning 0\n"));
	return 0;

      } else {
	debug15(printf("Inclusive: ilengths5: %d|%d.  ilengths3: %d|%d\n",ilength5_low,ilength5_high,ilength3_low,ilength3_high));
	debug15(printf("ilength53 is %d, ilength 35 is %d\n",ilength5_low + ilength3_high - 1,ilength3_low + ilength5_high - 1));

	common_left = (ilength5_low < ilength3_low) ? ilength5_low : ilength3_low;
	common_right = (ilength5_high < ilength3_high) ? ilength5_high : ilength3_high;
	if (common_right > common_left) {
	  common_shift = common_right/2 - (common_left - 1)/2;
	  debug15(printf("Common shift is %d = common_right %d/2 - (common_left %d - 1)/2\n",
			 common_shift,common_right,common_left));
	  assert(ilength5_low > 0);
	  assert(ilength3_low > 0);
	  ilength5_low -= 1;
	  ilength3_low -= 1;
	} else {
	  common_shift = (common_right - 1)/2 - common_left/2;
	  debug15(printf("Common shift is %d = (common_right %d - 1)/2 - common_left %d/2\n",
			 common_shift,common_right,common_left));
	  assert(ilength5_high > 0);
	  assert(ilength3_high > 0);
	  ilength5_high -= 1;
	  ilength3_high -= 1;
	}
	debug15(printf("Exclusive: ilengths5: %d|%d.  ilengths3: %d|%d\n",ilength5_low,ilength5_high,ilength3_low,ilength3_high));


	if ((ilength53 = ilength5_low + ilength3_high) >= (ilength35 = ilength3_low + ilength5_high)) {
	  /* Use >=, not >, so we favor clipping heads over clipping tails in case of a tie */
	  debug15(printf("plus, ilength53 is longer.  Clipping heads.\n"));
	  debug15(printf("Overlap is %d = common_left %d + common_right %d - 1\n",
			 common_left+common_right-1,common_left,common_right));
	  clipdir = +1;

	  /* Want to clip 5 high and 3 low */
	  *hardclip5_high = ilength5_high - common_shift;
	  *hardclip3_low = ilength3_low + common_shift;
	  debug15(printf("Overlap clip for ilength53 plus is hardclip5 %d..%d and hardclip3 %d..%d\n",
			 *hardclip5_low,*hardclip5_high,*hardclip3_low,*hardclip3_high));
	  *hardclip5_high += (hit5->querylength - hit5->queryend_trimmed) /*+ end_amb_length(hit5)*/;
	  *hardclip3_low += hit3->querystart_trimmed /*+ start_amb_length(hit3)*/;
	  debug15(printf("Ambig clip for ilength53 plus is hardclip5 %d..%d and hardclip3 %d..%d\n",
			 *hardclip5_low,*hardclip5_high,*hardclip3_low,*hardclip3_high));

	  if (common_shift != 0) {
	    if (test_hardclips(&common_genomicpos,*hardclip3_low,hit3,*hardclip5_high,hit5,hit3->chroffset) == true) {
	      /* No adjustment needed, but need to recompute ilengths for shifted common_genomicpos */
	    } else {
	      common_genomicpos_right = adjust_hardclips_right(&shift_right,*hardclip3_low,hit3,*hardclip5_high,hit5,hit3->chroffset);
	      common_genomicpos_left = adjust_hardclips_left(&shift_left,*hardclip3_low,hit3,*hardclip5_high,hit5,hit3->chroffset);
	      debug15(printf("shift_right %d, shift_left %d\n",shift_right,shift_left));
	      if (shift_right == 0 && shift_left == 0) {
		/* Try original position without a shift */
		*hardclip5_high = ilength5_high /*- common_shift*/;
		*hardclip3_low = ilength3_low /*+ common_shift*/;
		*hardclip5_high += (hit5->querylength - hit5->queryend_trimmed) /*+ end_amb_length(hit5)*/;
		*hardclip3_low += hit3->querystart_trimmed /*+ start_amb_length(hit3)*/;
		if (test_hardclips(&common_genomicpos,*hardclip3_low,hit3,*hardclip5_high,hit5,hit3->chroffset) == false) {
		  *hardclip5_low = *hardclip5_high = *hardclip3_low = *hardclip3_high = 0;
		  return 0;
		}
	      } else if (shift_left == 0) {
		common_genomicpos = common_genomicpos_right;
	      } else if (shift_right == 0) {
		common_genomicpos = common_genomicpos_left;
	      } else if (shift_right <= shift_left) {
		common_genomicpos = common_genomicpos_right;
	      } else {
		common_genomicpos = common_genomicpos_left;
	      }
	    }

	    debug15(printf("New common point is %u\n",common_genomicpos - hit3->chroffset));
	    /* Recompute hardclips */
	    if (find_ilengths(&ilength5_low,&ilength5_high,hit5,common_genomicpos) == false ||
		find_ilengths(&ilength3_low,&ilength3_high,hit3,common_genomicpos) == false) {
	      *hardclip5_low = *hardclip5_high = *hardclip3_low = *hardclip3_high = 0;
	      return 0;
	    } else if (ilength3_low > ilength5_high) {
	      debug15(printf("Uneven: ilengths5: %d|%d.  ilengths3: %d|%d\n",ilength5_low,ilength5_high,ilength3_low,ilength3_high));
	      assert(ilength3_low > 0);
	      ilength3_low -= 1;
	    } else {
	      debug15(printf("Uneven: ilengths5: %d|%d.  ilengths3: %d|%d\n",ilength5_low,ilength5_high,ilength3_low,ilength3_high));
	      assert(ilength5_high > 0);
	      ilength5_high -= 1;
	    }
	    debug15(printf("Even: ilengths5: %d|%d.  ilengths3: %d|%d\n",ilength5_low,ilength5_high,ilength3_low,ilength3_high));

	    *hardclip5_high = ilength5_high /*- common_shift*/;
	    *hardclip3_low = ilength3_low /*+ common_shift*/;
	    debug15(printf("Initial computation of clip for ilength53 plus is hardclip5 %d..%d and hardclip3 %d..%d\n",
			   *hardclip5_low,*hardclip5_high,*hardclip3_low,*hardclip3_high));

	    *hardclip5_high += (hit5->querylength - hit5->queryend_trimmed) /*+ end_amb_length(hit5)*/;
	    *hardclip3_low += hit3->querystart_trimmed /*+ start_amb_length(hit3)*/;
	    debug15(printf("Recomputed clip for ilength53 plus is hardclip5 %d..%d and hardclip3 %d..%d\n",
			   *hardclip5_low,*hardclip5_high,*hardclip3_low,*hardclip3_high));
	  }

#if 0
	  if (*hardclip5_high < 0) {
	    *hardclip5_high = 0;
	  }
	  if (*hardclip3_low < 0) {
	    *hardclip3_low = 0;
	  }
	  debug15(printf("Positive clip for ilength53 plus is hardclip5 %d..%d and hardclip3 %d..%d\n",
			 *hardclip5_low,*hardclip5_high,*hardclip3_low,*hardclip3_high));
#endif

	} else {
	  debug15(printf("plus, ilength35 is longer.  Clipping tails.\n"));
	  debug15(printf("Overlap is %d = common_left %d + common_right %d - 1\n",
			 common_left+common_right-1,common_left,common_right));
	  clipdir = -1;

	  /* Want to clip 5 low and 3 high */
	  *hardclip5_low = ilength5_low + common_shift;
	  *hardclip3_high = ilength3_high - common_shift;
	  debug15(printf("Overlap clip for ilength35 plus is hardclip5 %d..%d and hardclip3 %d..%d\n",
			 *hardclip5_low,*hardclip5_high,*hardclip3_low,*hardclip3_high));
	  *hardclip5_low += hit5->querystart_trimmed /*+ start_amb_length(hit5)*/;
	  *hardclip3_high += (hit3->querylength - hit3->queryend_trimmed) /*+ end_amb_length(hit3)*/;
	  debug15(printf("Ambig clip for ilength35 plus is hardclip5 %d..%d and hardclip3 %d..%d\n",
			 *hardclip5_low,*hardclip5_high,*hardclip3_low,*hardclip3_high));

	  if (common_shift != 0) {
	    if (test_hardclips(&common_genomicpos,*hardclip5_low,hit5,*hardclip3_high,hit3,hit3->chroffset) == true) {
	      /* No adjustment needed, but need to recompute ilengths for shifted common_genomicpos */
	    } else {
	      common_genomicpos_right = adjust_hardclips_right(&shift_right,*hardclip5_low,hit5,*hardclip3_high,hit3,hit3->chroffset);
	      common_genomicpos_left = adjust_hardclips_left(&shift_left,*hardclip5_low,hit5,*hardclip3_high,hit3,hit3->chroffset);
	      debug15(printf("shift_right %d, shift_left %d\n",shift_right,shift_left));
	      if (shift_right == 0 && shift_left == 0) {
		/* Try original position without a shift */
		*hardclip5_low = ilength5_low /*+ common_shift*/;
		*hardclip3_high = ilength3_high /*- common_shift*/;
		*hardclip5_low += hit5->querystart_trimmed /*+ start_amb_length(hit5)*/;
		*hardclip3_high += (hit3->querylength - hit3->queryend_trimmed) /*+ end_amb_length(hit3)*/;
		if (test_hardclips(&common_genomicpos,*hardclip3_low,hit3,*hardclip5_high,hit5,hit3->chroffset) == false) {
		  *hardclip5_low = *hardclip5_high = *hardclip3_low = *hardclip3_high = 0;
		  return 0;
		}
	      } else if (shift_left == 0) {
		common_genomicpos = common_genomicpos_right;
	      } else if (shift_right == 0) {
		common_genomicpos = common_genomicpos_left;
	      } else if (shift_right <= shift_left) {
		common_genomicpos = common_genomicpos_right;
	      } else {
		common_genomicpos = common_genomicpos_left;
	      }
	    }

	    debug15(printf("New common point is %u\n",common_genomicpos - hit3->chroffset));
	    /* Recompute hardclips */
	    if (find_ilengths(&ilength5_low,&ilength5_high,hit5,common_genomicpos) == false ||
		find_ilengths(&ilength3_low,&ilength3_high,hit3,common_genomicpos) == false) {
	      *hardclip5_low = *hardclip5_high = *hardclip3_low = *hardclip3_high = 0;
	      return 0;
	    } else if (ilength5_low > ilength3_high) {
	      debug15(printf("Uneven: ilengths5: %d|%d.  ilengths3: %d|%d\n",ilength5_low,ilength5_high,ilength3_low,ilength3_high));
	      assert(ilength5_low > 0);
	      ilength5_low -= 1;
	    } else {
	      debug15(printf("Uneven: ilengths5: %d|%d.  ilengths3: %d|%d\n",ilength5_low,ilength5_high,ilength3_low,ilength3_high));
	      assert(ilength3_high > 0);
	      ilength3_high -= 1;
	    }
	    debug15(printf("Even: ilengths5: %d|%d.  ilengths3: %d|%d\n",ilength5_low,ilength5_high,ilength3_low,ilength3_high));

	    *hardclip5_low = ilength5_low /*+ common_shift*/;
	    *hardclip3_high = ilength3_high /*- common_shift*/;
	    debug15(printf("Initial computation of clip for ilength35 plus is hardclip5 %d..%d and hardclip3 %d..%d\n",
			   *hardclip5_low,*hardclip5_high,*hardclip3_low,*hardclip3_high));

	    *hardclip5_low += hit5->querystart_trimmed /*+ start_amb_length(hit5)*/;
	    *hardclip3_high += (hit3->querylength - hit3->queryend_trimmed) /*+ end_amb_length(hit3)*/;
	    debug15(printf("Recomputed clip for ilength35 plus is hardclip5 %d..%d and hardclip3 %d..%d\n",
			   *hardclip5_low,*hardclip5_high,*hardclip3_low,*hardclip3_high));
	  }

#if 0
	  if (*hardclip5_low < 0) {
	    *hardclip5_low = 0;
	  }
	  if (*hardclip3_high < 0) {
	    *hardclip3_high = 0;
	  }
	  debug15(printf("Positive clip for ilength35 plus is hardclip5 %d..%d and hardclip3 %d..%d\n",
			 *hardclip5_low,*hardclip5_high,*hardclip3_low,*hardclip3_high));
#endif
	}

	debug15(printf("returning clipdir %d\n",clipdir));
	return clipdir;
      }

    } else {
      /* minus */
#if 0
      hit5_trimmed_length = hit5->querylength - hit5->querystart_trimmed - (hit5->querylength - hit5->queryend_trimmed) - start_amb_length(hit5) - end_amb_length(hit5);
      hit3_trimmed_length = hit3->querylength - hit3->querystart_trimmed - (hit3->querylength - hit3->queryend_trimmed) - start_amb_length(hit3) - end_amb_length(hit3);
      totallength = hit5_trimmed_length + hit3_trimmed_length;
      debug15(printf("totallength = %d, hit5 trimmed length = %d, hit3 trimmed length = %d\n",
		     totallength,hit5_trimmed_length,hit3_trimmed_length));
      debug15(printf("original insertlength: %d, trim+amb5: %d..%d, trim+amb3: %d..%d\n",
		     this->insertlength,hit5->querystart_trimmed + start_amb_length(hit5),
		     hit5->queryend_trimmed + hit5->end_amb_length,hit3->querystart_trimmed + start_amb_length(hit3),
		     hit3->queryend_trimmed + hit3->end_amb_length));
#endif

      if ((common_genomicpos = pair_common_genomicpos(hit5,hit3)) == 0) {
	debug15(printf("Cannot determine a common point, so returning 0\n"));
	return 0;

      } else if (find_ilengths(&ilength5_low,&ilength5_high,hit5,common_genomicpos) == false ||
		 find_ilengths(&ilength3_low,&ilength3_high,hit3,common_genomicpos) == false) {
	debug15(printf("Cannot determine ilengths, so returning 0\n"));
	return 0;

      } else {
	debug15(printf("Inclusive: ilengths5: %d|%d.  ilengths3: %d|%d\n",ilength5_low,ilength5_high,ilength3_low,ilength3_high));
	debug15(printf("ilength53lh is %d, ilength35lh is %d\n",ilength5_low + ilength3_high - 1,ilength3_low + ilength5_high - 1));

	common_left = (ilength5_low < ilength3_low) ? ilength5_low : ilength3_low;
	common_right = (ilength5_high < ilength3_high) ? ilength5_high : ilength3_high;
	if (common_right > common_left) {
	  common_shift = common_right/2 - (common_left - 1)/2;
	  debug15(printf("Common shift is %d = common_right %d/2 - (common_left %d - 1)/2\n",
			 common_shift,common_right,common_left));
	  assert(ilength5_low > 0);
	  assert(ilength3_low > 0);
	  ilength5_low -= 1;
	  ilength3_low -= 1;
	} else {
	  common_shift = (common_right - 1)/2 - common_left/2;
	  debug15(printf("Common shift is %d = (common_right %d - 1)/2 - common_left %d/2\n",
			 common_shift,common_right,common_left));
	  assert(ilength5_high > 0);
	  assert(ilength3_high > 0);
	  ilength5_high -= 1;
	  ilength3_high -= 1;
	}
	debug15(printf("Exclusive: ilengths5: %d|%d.  ilengths3: %d|%d\n",ilength5_low,ilength5_high,ilength3_low,ilength3_high));

	if ((ilength53 = ilength5_low + ilength3_high) > (ilength35 = ilength3_low + ilength5_high)) {
	  /* Use >, not >=, so we favor clipping heads over clipping tails in case of a tie */
	  debug15(printf("minus, ilength53 is longer.  Clipping tails.\n"));
	  debug15(overlap = common_left + common_right - 1);
	  debug15(printf("Overlap is %d = common_left %d + common_right %d - 1\n",
			 overlap,common_left,common_right));
	  clipdir = +1;


	  /* Want to clip 5 high and 3 low */
	  *hardclip5_high = ilength5_high - common_shift;
	  *hardclip3_low = ilength3_low + common_shift;
	  debug15(printf("Overlap clip for ilength53 minus is hardclip5 %d..%d and hardclip3 %d..%d\n",
			 *hardclip5_low,*hardclip5_high,*hardclip3_low,*hardclip3_high));
	  *hardclip5_high += hit5->querystart_trimmed /*+ start_amb_length(hit5)*/;
	  *hardclip3_low += (hit3->querylength - hit3->queryend_trimmed) /*+ end_amb_length(hit3)*/;
	  debug15(printf("Ambig clip for ilength53 minus is hardclip5 %d..%d and hardclip3 %d..%d\n",
			 *hardclip5_low,*hardclip5_high,*hardclip3_low,*hardclip3_high));

	  if (common_shift != 0) {
	    if (test_hardclips(&common_genomicpos,*hardclip3_low,hit3,*hardclip5_high,hit5,hit3->chroffset) == true) {
	      /* No adjustment needed, but need to recompute ilengths for shifted common_genomicpos */
	    } else {
	      common_genomicpos_right = adjust_hardclips_right(&shift_right,*hardclip3_low,hit3,*hardclip5_high,hit5,hit3->chroffset);
	      common_genomicpos_left = adjust_hardclips_left(&shift_left,*hardclip3_low,hit3,*hardclip5_high,hit5,hit3->chroffset);
	      debug15(printf("shift_right %d, shift_left %d\n",shift_right,shift_left));
	      if (shift_right == 0 && shift_left == 0) {
		/* Try original position without a shift */
		*hardclip5_high = ilength5_high /*- common_shift*/;
		*hardclip3_low = ilength3_low /*+ common_shift*/;
		*hardclip5_high += hit5->querystart_trimmed /*+ start_amb_length(hit5)*/;
		*hardclip3_low += (hit3->querylength - hit3->queryend_trimmed) /*+ end_amb_length(hit3)*/;
		if (test_hardclips(&common_genomicpos,*hardclip3_low,hit3,*hardclip5_high,hit5,hit3->chroffset) == false) {
		  *hardclip5_low = *hardclip5_high = *hardclip3_low = *hardclip3_high = 0;
		  return 0;
		}
	      } else if (shift_left == 0) {
		common_genomicpos = common_genomicpos_right;
	      } else if (shift_right == 0) {
		common_genomicpos = common_genomicpos_left;
	      } else if (shift_right <= shift_left) {
		common_genomicpos = common_genomicpos_right;
	      } else {
		common_genomicpos = common_genomicpos_left;
	      }
	    }

	    debug15(printf("New common point is %u\n",common_genomicpos - hit3->chroffset));
	    /* Recompute hardclips */
	    if (find_ilengths(&ilength5_low,&ilength5_high,hit5,common_genomicpos) == false ||
		find_ilengths(&ilength3_low,&ilength3_high,hit3,common_genomicpos) == false) {
	      *hardclip5_low = *hardclip5_high = *hardclip3_low = *hardclip3_high = 0;
	      return 0;
	    } else if (ilength3_low > ilength5_high) {
	      debug15(printf("Uneven: ilengths5: %d|%d.  ilengths3: %d|%d\n",ilength5_low,ilength5_high,ilength3_low,ilength3_high));
	      assert(ilength3_low > 0);
	      ilength3_low -= 1;
	    } else {
	      debug15(printf("Uneven: ilengths5: %d|%d.  ilengths3: %d|%d\n",ilength5_low,ilength5_high,ilength3_low,ilength3_high));
	      assert(ilength5_high > 0);
	      ilength5_high -= 1;
	    }
	    debug15(printf("Even: ilengths5: %d|%d.  ilengths3: %d|%d\n",ilength5_low,ilength5_high,ilength3_low,ilength3_high));

	    *hardclip5_high = ilength5_high /*- common_shift*/;
	    *hardclip3_low = ilength3_low /*+ common_shift*/;
	    debug15(printf("Initial computation of clip for ilength53 minus is hardclip5 %d..%d and hardclip3 %d..%d\n",
			   *hardclip5_low,*hardclip5_high,*hardclip3_low,*hardclip3_high));

	    *hardclip5_high += hit5->querystart_trimmed /*+ start_amb_length(hit5)*/;
	    *hardclip3_low += (hit3->querylength - hit3->queryend_trimmed) /*+ end_amb_length(hit3)*/;
	    debug15(printf("Recomputed clip for ilength53 minus is hardclip5 %d..%d and hardclip3 %d..%d\n",
			   *hardclip5_low,*hardclip5_high,*hardclip3_low,*hardclip3_high));
	  }

#if 0
	  if (*hardclip5_high < 0) {
	    *hardclip5_high = 0;
	  }
	  if (*hardclip3_low < 0) {
	    *hardclip3_low = 0;
	  }
	  debug15(printf("Positive clip for ilength53 minus is hardclip5 %d..%d and hardclip3 %d..%d\n",
			 *hardclip5_low,*hardclip5_high,*hardclip3_low,*hardclip3_high));
#endif

	} else {
	  debug15(printf("minus, ilength35 is longer.  Clipping heads.\n"));
	  debug15(overlap = common_left + common_right - 1);
	  debug15(printf("Overlap is %d = common_left %d + common_right %d - 1\n",
			 overlap,common_left,common_right));
	  clipdir = -1;

	  /* Want to clip 5 low and 3 high */
	  *hardclip5_low = ilength5_low + common_shift;
	  *hardclip3_high = ilength3_high - common_shift;
	  debug15(printf("Overlap clip for ilength35 minus is hardclip5 %d..%d and hardclip3 %d..%d\n",
			 *hardclip5_low,*hardclip5_high,*hardclip3_low,*hardclip3_high));
	  *hardclip5_low += (hit5->querylength - hit5->queryend_trimmed) /*+ end_amb_length(hit5)*/;
	  *hardclip3_high += hit3->querystart_trimmed /*+ start_amb_length(hit3)*/;
	  debug15(printf("Ambig clip for ilength35 minus is hardclip5 %d..%d and hardclip3 %d..%d\n",
			 *hardclip5_low,*hardclip5_high,*hardclip3_low,*hardclip3_high));

	  if (common_shift != 0) {
	    if (test_hardclips(&common_genomicpos,*hardclip5_low,hit5,*hardclip3_high,hit3,hit3->chroffset) == true) {
	      /* No adjustment needed, but need to recompute ilengths for shifted common_genomicpos */
	    } else {
	      common_genomicpos_right = adjust_hardclips_right(&shift_right,*hardclip5_low,hit5,*hardclip3_high,hit3,hit3->chroffset);
	      common_genomicpos_left = adjust_hardclips_left(&shift_left,*hardclip5_low,hit5,*hardclip3_high,hit3,hit3->chroffset);
	      debug15(printf("shift_right %d, shift_left %d\n",shift_right,shift_left));
	      if (shift_right == 0 && shift_left == 0) {
		/* Try original position without a shift */
		*hardclip5_low = ilength5_low /*+ common_shift*/;
		*hardclip3_high = ilength3_high /*- common_shift*/;
		*hardclip5_low += (hit5->querylength - hit5->queryend_trimmed) /*+ end_amb_length(hit5)*/;
		*hardclip3_high += hit3->querystart_trimmed /*+ start_amb_length(hit3)*/;
		if (test_hardclips(&common_genomicpos,*hardclip3_low,hit3,*hardclip5_high,hit5,hit3->chroffset) == false) {
		  *hardclip5_low = *hardclip5_high = *hardclip3_low = *hardclip3_high = 0;
		  return 0;
		}
	      } else if (shift_left == 0) {
		common_genomicpos = common_genomicpos_right;
	      } else if (shift_right == 0) {
		common_genomicpos = common_genomicpos_left;
	      } else if (shift_right <= shift_left) {
		common_genomicpos = common_genomicpos_right;
	      } else {
		common_genomicpos = common_genomicpos_left;
	      }
	    }

	    debug15(printf("New common point is %u\n",common_genomicpos - hit3->chroffset));
	    /* Recompute hardclips */
	    if (find_ilengths(&ilength5_low,&ilength5_high,hit5,common_genomicpos) == false ||
		find_ilengths(&ilength3_low,&ilength3_high,hit3,common_genomicpos) == false) {
	      *hardclip5_low = *hardclip5_high = *hardclip3_low = *hardclip3_high = 0;
	      return 0;
	    } else if (ilength5_low > ilength3_high) {
	      debug15(printf("Uneven: ilengths5: %d|%d.  ilengths3: %d|%d\n",ilength5_low,ilength5_high,ilength3_low,ilength3_high));
	      assert(ilength5_low > 0);
	      ilength5_low -= 1;
	    } else {
	      debug15(printf("Uneven: ilengths5: %d|%d.  ilengths3: %d|%d\n",ilength5_low,ilength5_high,ilength3_low,ilength3_high));
	      assert(ilength3_high > 0);
	      ilength3_high -= 1;
	    }
	    debug15(printf("Even: ilengths5: %d|%d.  ilengths3: %d|%d\n",ilength5_low,ilength5_high,ilength3_low,ilength3_high));

	    *hardclip5_low = ilength5_low /*+ common_shift*/;
	    *hardclip3_high = ilength3_high /*- common_shift*/;
	    debug15(printf("Initial computation of clip for ilength35 minus is hardclip5 %d..%d and hardclip3 %d..%d\n",
			   *hardclip5_low,*hardclip5_high,*hardclip3_low,*hardclip3_high));

	    *hardclip5_low += (hit5->querylength - hit5->queryend_trimmed) /*+ end_amb_length(hit5)*/;
	    *hardclip3_high += hit3->querystart_trimmed /*+ start_amb_length(hit3)*/;
	    debug15(printf("Recomputed clip for ilength35 minus is hardclip5 %d..%d and hardclip3 %d..%d\n",
			   *hardclip5_low,*hardclip5_high,*hardclip3_low,*hardclip3_high));
	  }

#if 0
	  if (*hardclip5_low < 0) {
	    *hardclip5_low = 0;
	  }
	  if (*hardclip3_high < 0) {
	    *hardclip3_high = 0;
	  }
	  debug15(printf("Positive clip for ilength35 minus is hardclip5 %d..%d and hardclip3 %d..%d\n",
			 *hardclip5_low,*hardclip5_high,*hardclip3_low,*hardclip3_high));
#endif
	}
      }

      debug15(printf("returning clipdir %d\n",clipdir));
      return clipdir;
    }
  }
}


void
Stage3pair_free (Stage3pair_T *old) {
  debug0(printf("Freeing pair %p with hits %p and %p\n",*old,(*old)->hit5,(*old)->hit3));
  assert((*old)->hit3 != NULL);
  debug0(printf("Freeing end3 at %p\n",(*old)->hit3));
  Stage3end_free(&(*old)->hit3);

  assert((*old)->hit5 != NULL);
  debug0(printf("Freeing end5 at %p\n",(*old)->hit5));
  Stage3end_free(&(*old)->hit5);

  FREE_OUT(*old);
  return;
}



#if 0
static long int
Stage3pair_tally (Stage3pair_T this) {

  if (tally_iit == NULL) {
    return 0L;
  } else if (this->tally >= 0) {
    return this->tally;
  } else {
    this->tally = Stage3end_compute_tally(this->hit5) + Stage3end_compute_tally(this->hit3);
    return this->tally;
  }
}
#endif


static char complCode[128] = COMPLEMENT_LC;

#if 0
static char *
make_complement_buffered (char *complement, char *sequence, unsigned int length) {
  int i, j;

  /* complement = (char *) CALLOC_OUT(length+1,sizeof(char)); */
  for (i = length-1, j = 0; i >= 0; i--, j++) {
    complement[j] = complCode[(int) sequence[i]];
  }
  complement[length] = '\0';
  return complement;
}
#endif

static char *
make_complement_inplace (char *sequence, unsigned int length) {
  char temp;
  unsigned int i, j;

  for (i = 0, j = length-1; i < length/2; i++, j--) {
    temp = complCode[(int) sequence[i]];
    sequence[i] = complCode[(int) sequence[j]];
    sequence[j] = temp;
  }
  if (i == j) {
    sequence[i] = complCode[(int) sequence[i]];
  }

  return sequence;
}


/* full sequence, then omitting successive distal substrings (ending with inner) */
List_T
Stage3end_substrings_genomic_sequence (char **master, T this, bool first_read_p) {
  List_T subsequences = NULL;
  int seqlength;
  char *gbuffer;
  List_T p, q;
  Substring_T substring;
  Junction_T junction;
  int querypos, querystart, queryend, querylength, substring_length, subsequence_length;

  seqlength = 0;
  for (p = this->substrings_1toN; p != NULL; p = List_next(p)) {
    substring = (Substring_T) List_head(p);
    querystart = Substring_querystart(substring);
    queryend = Substring_queryend(substring);
    seqlength += queryend - querystart;
  }
  for (p = this->junctions_1toN; p != NULL; p = List_next(p)) {
    junction = (Junction_T) List_head(p);
    if (Junction_type(junction) == DEL_JUNCTION) {
      seqlength += Junction_nindels(junction);
    }
  }

  *master = (char *) MALLOC((seqlength+1) * sizeof(char));
  querylength = this->querylength;

  if (this->plusp == true) {
    /* Build master from querystart to queryend because Genome_fill_buffer gets plus strand */
    querypos = 0;
    for (p = this->substrings_1toN, q = this->junctions_1toN; p != NULL; p = List_next(p), q = List_next(q)) {
      substring = (Substring_T) List_head(p);
      querystart = Substring_querystart(substring);
      queryend = Substring_queryend(substring);
      substring_length = queryend - querystart;
      Genome_fill_buffer(Substring_left(substring) + querystart,
			 substring_length,&((*master)[querypos]));
      querypos += substring_length;
      
      if (q != NULL) {
	junction = (Junction_T) List_head(q);
	if (Junction_type(junction) == DEL_JUNCTION) {
	  substring_length = Junction_nindels(junction);
	  Genome_fill_buffer(Junction_deletionpos(junction),
			     substring_length,&((*master)[querypos]));
	  querypos += substring_length;
	}
      }
    }



  } else {
    /* Build master from queryend to querystart because Genome_fill_buffer gets plus strand */
    querypos = 0;
    for (p = this->substrings_Nto1, q = this->junctions_Nto1; p != NULL; p = List_next(p), q = List_next(q)) {
      substring = (Substring_T) List_head(p);
      querystart = Substring_querystart(substring);
      queryend = Substring_queryend(substring);
      substring_length = queryend - querystart;
      Genome_fill_buffer(Substring_left(substring) + (querylength - queryend),
			 substring_length,&((*master)[querypos]));
      querypos += substring_length;

      if (q != NULL) {
	junction = (Junction_T) List_head(q);
	if (Junction_type(junction) == DEL_JUNCTION) {
	  substring_length = Junction_nindels(junction);
	  Genome_fill_buffer(Junction_deletionpos(junction),
			     substring_length,&((*master)[querypos]));
	  querypos += substring_length;
	}
      }
    }
    make_complement_inplace(*master,seqlength);
  }

  debug5(printf("Master is %s\n",*master));


  /* Take subsequences from inner to outer */
  if (first_read_p == true) {
    subsequence_length = 0;
    for (p = this->substrings_Nto1, q = this->junctions_Nto1; p != NULL; p = List_next(p), q = List_next(q)) {
      substring = (Substring_T) List_head(p);
      querystart = Substring_querystart(substring);
      queryend = Substring_queryend(substring);
      subsequence_length += queryend - querystart;
      
      gbuffer = (char *) MALLOC((subsequence_length+1)*sizeof(char));
      strncpy(gbuffer,&((*master)[seqlength - subsequence_length]),subsequence_length);
      gbuffer[subsequence_length] = '\0';
      debug5(printf("(1) Pushing %s\n",gbuffer));
      subsequences = List_push(subsequences,(void *) gbuffer);
      
      if (q != NULL) {
	junction = (Junction_T) List_head(q);
	if (Junction_type(junction) == DEL_JUNCTION) {
	  subsequence_length += Junction_nindels(junction);
	}
      }
    }
    
  } else {
    subsequence_length = 0;
    for (p = this->substrings_1toN, q = this->junctions_1toN; p != NULL; p = List_next(p), q = List_next(q)) {
      substring = (Substring_T) List_head(p);
      querystart = Substring_querystart(substring);
      queryend = Substring_queryend(substring);
      subsequence_length += queryend - querystart;
      
      gbuffer = (char *) MALLOC((subsequence_length+1)*sizeof(char));
      strncpy(gbuffer,*master,subsequence_length);
      gbuffer[subsequence_length] = '\0';
      debug5(printf("(2) Pushing %s\n",gbuffer));
      subsequences = List_push(subsequences,(void *) gbuffer);
      
      if (q != NULL) {
	junction = (Junction_T) List_head(q);
	if (Junction_type(junction) == DEL_JUNCTION) {
	  subsequence_length += Junction_nindels(junction);
	}
      }
    }
  }

  debug5(printf("\n"));
  return subsequences;
}


const Except_T Copy_Substring = { "Substring invalid during copy" };

static T
Stage3end_copy (T old, Listpool_T listpool) {
  T new = (T) MALLOC_OUT(sizeof(*new));
  List_T p;
  Substring_T old_substring, new_substring;
  Junction_T old_junction, new_junction;

  debug0(printf("*****Copying Stage3end %p -> %p of type %s and distant_splice_i %d\n",
		old,new,hittype_string(old->hittype),old->distant_splice_i));

  new->hittype = old->hittype;
  new->distant_splice_i = old->distant_splice_i;
  new->method = old->method;
  new->level = old->level;

  new->querylength = old->querylength;
  new->querylength_adj = old->querylength_adj;

  new->transcripts_consistent = Transcript_copy_list(old->transcripts_consistent,listpool);
  new->transcripts_inconsistent = Transcript_copy_list(old->transcripts_inconsistent,listpool);

  new->substrings_1toN = (List_T) NULL;
  new->substrings_Nto1 = (List_T) NULL;
  new->substring_donor = (Substring_T) NULL;
  new->substring_acceptor = (Substring_T) NULL;

  new->junctions_1toN = (List_T) NULL;
  new->junctions_Nto1 = (List_T) NULL;

  for (p = old->substrings_1toN; p != NULL; p = List_next(p)) {
    old_substring = (Substring_T) List_head(p);
    new_substring = Substring_copy(old_substring);
    new->substrings_1toN = Listpool_push(new->substrings_1toN,listpool,(void *) new_substring);

    if (old_substring == old->substring_donor) {
      new->substring_donor = new_substring;
    } else if (old_substring == old->substring_acceptor) {
      new->substring_acceptor = new_substring;
    }
  }

  for (p = old->junctions_1toN; p != NULL; p = List_next(p)) {
    old_junction = (Junction_T) List_head(p);
    new_junction = Junction_copy(old_junction);
    new->junctions_1toN = Listpool_push(new->junctions_1toN,listpool,(void *) new_junction);
  }

  new->substrings_Nto1 = Listpool_copy(new->substrings_1toN,listpool); /* Before reversal of 1toN */
  new->junctions_Nto1 = Listpool_copy(new->junctions_1toN,listpool);   /* Before reversal of 1toN */

  /* Reversals to handle builds of 1toN */
  new->substrings_1toN = List_reverse(new->substrings_1toN);
  new->junctions_1toN = List_reverse(new->junctions_1toN);


  new->querystart_chrbound = old->querystart_chrbound;
  new->queryend_chrbound = old->queryend_chrbound;
  new->querystart_trimmed = old->querystart_trimmed;
  new->queryend_trimmed = old->queryend_trimmed;
  new->querystart_trimmed_splicep = old->querystart_trimmed_splicep;
  new->queryend_trimmed_splicep = old->queryend_trimmed_splicep;

  new->genomicstart = old->genomicstart;
  new->genomicend = old->genomicend;

  new->low_chrbound = old->low_chrbound;
  new->high_chrbound = old->high_chrbound;
  new->low_trimmed = old->low_trimmed;
  new->high_trimmed = old->high_trimmed;

  new->genomiclength = old->genomiclength;
  new->guided_insertlength = old->guided_insertlength;

  new->shortdistancep = old->shortdistancep;
  new->chrnum = old->chrnum;
  new->effective_chrnum = old->effective_chrnum;
  new->other_chrnum = old->other_chrnum;
  new->chroffset = old->chroffset;
  new->chrhigh = old->chrhigh;
  new->chrlength = old->chrlength;
  new->plusp = old->plusp;
  new->genestrand = old->genestrand;

  new->sensedir = old->sensedir;
  new->sensedir_for_concordance = old->sensedir_for_concordance;

  new->nsplices = old->nsplices;
  new->splice_score = old->splice_score;
  new->nindels = old->nindels;

  new->nmismatches_bothdiff = old->nmismatches_bothdiff;
  new->nmismatches_refdiff = old->nmismatches_refdiff;
  new->nsegments = old->nsegments;

  new->refalt_nmatches_to_trims = old->refalt_nmatches_to_trims;
  new->ref_nmatches_to_trims = old->ref_nmatches_to_trims;
  new->refalt_nmatches_plus_spliced_trims = old->refalt_nmatches_plus_spliced_trims;
  new->ref_nmatches_plus_spliced_trims = old->ref_nmatches_plus_spliced_trims;

  new->refalt_score_overall = old->refalt_score_overall;
  new->refalt_score_within_trims = old->refalt_score_within_trims;

  new->paired_usedp = old->paired_usedp;

  new->circularalias = old->circularalias;
  new->circularpos = old->circularpos;
  new->altlocp = old->altlocp;
  debug12(printf("Copying circularpos of %d from hit %p to hit %p\n",new->circularpos,old,new));

  new->score_eventrim = old->score_eventrim;
  new->mapq_loglik = old->mapq_loglik;
  new->mapq_score = old->mapq_score;
  new->absmq_score = old->absmq_score;

  /* Actually, the assertion is excluded only for the JOIN hittype */
  assert(new->hittype == SPLICE || Substring_querystart(List_head(new->substrings_1toN)) <= Substring_querystart(List_head(new->substrings_Nto1)));

  debug0(printf("*****Copy %p has type %s and distant_splice_i %d\n",
		new,hittype_string(new->hittype),new->distant_splice_i));

  return new;
}


static int
compute_circularpos (int *circularalias, T hit) {
  int circularpos;
  List_T substrings_LtoH, p;
  Substring_T substring;


  debug12(printf("Computing circularpos on hit at %u..%u, plusp %d, trimmed %d..%d\n",
		 hit->low_trimmed - hit->chroffset,hit->high_trimmed - hit->chroffset,
		 hit->plusp,hit->querystart_trimmed,hit->queryend_trimmed));
  if (circularp[hit->chrnum] == false) {
    debug12(printf("Chromosome #%d is not circular\n",hit->chrnum));
    /* This also handles hit->chrnum == 0, where translocation cannot be circular */
    *circularalias = 0;
    return -1;

  } else if (hit->low_trimmed - hit->chroffset >= hit->chrlength) {
    /* All of read after trimming is in high part.  Previously
       checked hit->high_trimmed against hit->chrhigh, for circularalias of
       +2, but that should be fixed now */

    debug12(printf("Circular chromosome of length %u\n",hit->chrlength));
    debug12(printf("All of read after trimming %u..%u is in high part\n",
		   hit->low_trimmed - hit->chroffset,hit->high_trimmed - hit->chroffset));
    *circularalias = +1;		/* All of read is in second copy */
    debug12(printf("For hit %p, returning circularpos -1, circularalias is %d\n",hit,*circularalias));
    return -1;

  } else if (hit->high_trimmed - hit->chroffset < hit->chrlength) {
    /* All of read after trimming is in low part.  Previously
       checked hit->low_trimmed against hit->chroffset for circularalias of
       -2, but that should be fixed now */

    debug12(printf("Circular chromosome of length %u\n",hit->chrlength));
    debug12(printf("All of read after trimming %u..%u is in low part\n",
		   hit->low_trimmed - hit->chroffset,hit->high_trimmed - hit->chroffset));
    *circularalias = -1;		/* All of read is in first copy */
    debug12(printf("For hit %p, returning circularpos -1, circularalias is %d\n",hit,*circularalias));
    return -1;

  } else {
    *circularalias = 0;	/* Straddling middle */
    if (hit->plusp == true) {
      substrings_LtoH = hit->substrings_1toN;
    } else {
      substrings_LtoH = hit->substrings_Nto1;
    }

    debug12(printf("Circular chromosome of length %u\n",hit->chrlength));
    for (p = substrings_LtoH; p != NULL; p = List_next(p)) {
      substring = (Substring_T) List_head(p);
      if ((circularpos = Substring_circularpos(substring)) > 0) {
	debug12(printf("For hit %p, returning circularpos %d from substring (plus)\n",hit,circularpos));
	return circularpos;
      }
    }      
    debug12(printf("For hit %p, returning circularpos -1, circularalias is %d\n",hit,*circularalias));
    return -1;
  }
}


static void
compute_ends (T this, bool first_read_p) {
  Substring_T substring1, substringN;
  Univcoord_T genomicstart, genomicend;

  if (this->shortdistancep == true) {
    substring1 = (Substring_T) List_head(this->substrings_1toN);
    substringN = (Substring_T) List_head(this->substrings_Nto1);

  } else if (first_read_p == true) {
    /* Translocation: Pick inner substring */
    substring1 = substringN = (Substring_T) List_head(this->substrings_Nto1);

  } else {
    /* Translocation: Pick inner substring */
    substring1 = substringN = (Substring_T) List_head(this->substrings_1toN);
  }

  this->querystart_trimmed = Substring_querystart_trimmed(substring1);
  this->querystart_trimmed_splicep = Substring_querystart_trimmed_splicep(substring1);
  this->queryend_trimmed = Substring_queryend_trimmed(substringN);
  this->queryend_trimmed_splicep = Substring_queryend_trimmed_splicep(substringN);

  this->querystart_chrbound = Substring_querystart_chrbound(substring1);
  this->queryend_chrbound = Substring_queryend_chrbound(substringN);
  debug0(printf("  querystart_chrbound %d, queryend_chrbound %d\n",this->querystart_chrbound,this->queryend_chrbound));

  if (this->querystart_trimmed < this->querystart_chrbound) {
    this->querystart_trimmed = this->querystart_chrbound;
  }
  if (this->queryend_trimmed > this->queryend_chrbound) {
    this->queryend_trimmed = this->queryend_chrbound;
  }

  genomicstart = this->genomicstart = Substring_genomicstart(substring1);
  genomicend = this->genomicend = Substring_genomicend(substringN);

  if (this->plusp == true) {
    this->low_chrbound = genomicstart + this->querystart_chrbound;
    this->high_chrbound = genomicend - (this->querylength - this->queryend_chrbound);
    this->low_trimmed = genomicstart + this->querystart_trimmed;
    this->high_trimmed = genomicend - (this->querylength - this->queryend_trimmed);
    this->genomiclength = genomicend - genomicstart;
  } else {
    this->low_chrbound = genomicend + (this->querylength - this->queryend_chrbound);
    this->high_chrbound = genomicstart - this->querystart_chrbound;
    this->low_trimmed = genomicend + (this->querylength - this->queryend_trimmed);
    this->high_trimmed = genomicstart - this->querystart_trimmed;
    this->genomiclength = genomicstart - genomicend;
  }
  assert(this->low_trimmed < this->high_trimmed);
  debug0(printf("low %u, high %u\n",this->low_trimmed - this->chroffset,this->high_trimmed - this->chroffset));

  debug0(printf("  trimmed: %d (splicep %d)..%d (splicep %d)\n",
		this->querystart_trimmed,this->querystart_trimmed_splicep,
		this->queryend_trimmed,this->queryend_trimmed_splicep));


  return;
}


static bool
spliced_end_p (double splice_prob, int exonlength) {
  if (exonlength >= 50) {
    return (splice_prob > 0.85) ? true : false;
  } else if (exonlength >= 30) {
    return (splice_prob > 0.95) ? true : false;
  } else {
    return false;
  }
}


static void
compute_scores (T this) {
  List_T p;
  Substring_T substring1, substringN, substring;
  Junction_T junction;
  int indel_score, adj, adj0;

  substring1 = (Substring_T) List_head(this->substrings_1toN);
  substringN = (Substring_T) List_head(this->substrings_Nto1);

  this->refalt_nmatches_to_trims = this->ref_nmatches_to_trims = 0;
  /* Note: Cannot use substrings variable here.  Need to use this->substrings_1toN */
  for (p = this->substrings_1toN; p != NULL; p = List_next(p)) {
    substring = (Substring_T) List_head(p);
    this->refalt_nmatches_to_trims += Substring_nmatches_to_trims(substring);
    this->ref_nmatches_to_trims += Substring_ref_nmatches_to_trims(substring);
  }
  debug0(printf("Setting nmatches_to_trims to be %d\n",this->refalt_nmatches_to_trims));

  this->refalt_nmatches_plus_spliced_trims = this->refalt_nmatches_to_trims;
  this->ref_nmatches_plus_spliced_trims = this->ref_nmatches_to_trims;

  if (spliced_end_p(Substring_start_amb_prob(substring1),Substring_match_length(substring1)) == false) {
    /* Not a good spliced trim */
    debug0(printf("substring1 has a prob of %.2f and length %d, so ignoring\n",
		  Substring_start_amb_prob(substring1),Substring_match_length(substring1)));
  } else {
    debug0(printf("substring1 has a prob of %.2f and length %d, so accepting\n",
		  Substring_start_amb_prob(substring1),Substring_match_length(substring1)));
    this->refalt_nmatches_plus_spliced_trims += Substring_start_amb_length(substring1);
    this->ref_nmatches_plus_spliced_trims += Substring_start_amb_length(substring1);
  }

  if (spliced_end_p(Substring_end_amb_prob(substringN),Substring_match_length(substringN)) == false) {
    /* Not a good spliced trim */
    debug0(printf("substringN has a prob of %.2f and length %d, so ignoring\n",
		  Substring_end_amb_prob(substringN),Substring_match_length(substringN)));
  } else {
    debug0(printf("substringN has a prob of %.2f and length %d, so accepting\n",
		  Substring_end_amb_prob(substringN),Substring_match_length(substringN)));
    this->refalt_nmatches_plus_spliced_trims += Substring_end_amb_length(substringN);
    this->ref_nmatches_plus_spliced_trims += Substring_end_amb_length(substringN);
  }

  debug0(printf("Setting nmatches_plus_spliced_trims to be %d = %d (+ %d) (+ %d) (probs %.2f and %.2f)\n",
		this->ref_nmatches_plus_spliced_trims,this->ref_nmatches_to_trims,
		Substring_start_amb_length(substring1),Substring_end_amb_length(substringN),
		Substring_start_amb_prob(substring1),Substring_end_amb_prob(substringN)));
  
  indel_score = 0;
  adj = 0;
  for (p = this->junctions_1toN; p != NULL; p = List_next(p)) {
    junction = List_head(p);
    if ((adj0 = Junction_adj(junction)) != 0) {
      adj += adj0;
      indel_score += indel_penalty_middle;
    }
    this->refalt_nmatches_plus_spliced_trims += Junction_ninserts(junction);
    this->ref_nmatches_plus_spliced_trims += Junction_ninserts(junction);
  }
  this->querylength_adj = this->querylength + adj;

  assert(this->refalt_nmatches_plus_spliced_trims >= 0);
  assert(this->refalt_nmatches_plus_spliced_trims <= this->querylength);

  this->refalt_score_overall = this->querylength - this->refalt_nmatches_to_trims;
  /* Needed to make -m flag work properly.  Generally improves alignments */
#if 1
  this->refalt_score_overall += indel_score; /* -nindels was an attempt to compensate for missing matches */
#endif

  this->refalt_score_within_trims = this->querylength - this->refalt_nmatches_plus_spliced_trims;

#if 0
  if (Substring_querystart_trimmed_splicep(substring1) == false) {
    this->refalt_score_within_trims -= NONSPLICED_END_RESTORE*(Substring_querystart(substring1)/END_BINSIZE);
  } else {
    this->refalt_score_within_trims += SPLICED_END_PENALTY*(Substring_querystart(substring1)/END_BINSIZE);
  }
#else
  if (this->querystart_trimmed_splicep == true) {
    this->refalt_score_within_trims += SPLICED_END_PENALTY*(Substring_querystart(substring1)/END_BINSIZE);
  }
#endif

#if 0
  if (Substring_queryend_trimmed_splicep(substringN) == false) {
    this->refalt_score_within_trims -= NONSPLICED_END_RESTORE*((this->querylength - Substring_queryend(substringN))/END_BINSIZE);
  } else {
    this->refalt_score_within_trims += SPLICED_END_PENALTY*((this->querylength - Substring_queryend(substringN))/END_BINSIZE);
  }
#else
  if (this->queryend_trimmed_splicep == true) {
    this->refalt_score_within_trims += SPLICED_END_PENALTY*((this->querylength - Substring_queryend(substringN))/END_BINSIZE);
  }
#endif
  /* was Substring_start_amb_length(substring1)/AMB_PENALTY - Substring_end_amb_length(substringN)/AMB_PENALTY, but doesn't work for DNA-seq */

#if 0
  if (this->chrlength == 0) {
    /* Cannot compare querylength with chrlength, which is 0 */
  } else if (chrlength < (Univcoord_T) this->querylength) {
    this->refalt_score_overall -= ((Univcoord_T) this->querylength - chrlength);
    this->refalt_score_within_trims -= ((Univcoord_T) this->querylength - chrlength);
  }
#endif
  assert(this->refalt_score_within_trims >= 0); 

  return;
}



/* Modified from Stage3end_new_precomputed for a single substring */
T
Stage3end_new_terminal (int *found_score_overall, int *found_score_within_trims,
			Substring_T substring_in, int querylength,
			bool gplusp, int genestrand, bool first_read_p, int sensedir,
			Listpool_T listpool, Method_T method, int level) {
  T new;

  Substring_T substring;
  Chrnum_T chrnum;
  Univcoord_T chroffset, chrhigh;
  Chrpos_T chrlength;

  List_T substrings;


  substring = Substring_copy(substring_in); /* Always make a copy of the input substring */
  chrnum = Substring_chrnum(substring);
  chroffset = Substring_chroffset(substring);
  chrhigh = Substring_chrhigh(substring);
  chrlength = Substring_chrlength(substring);

  debug0(printf("Entered Stage3end_new_terminal, method %s, with chrnum %d, query %d..%d\n",
		Method_string(method),chrnum,Substring_querystart(substring),Substring_queryend(substring)));

  new = (T) MALLOC_OUT(sizeof(*new));
  new->hittype = SUBSTRINGS;
  new->distant_splice_i = -1;	/* new->distant_splice_p = false; */
  new->method = method;
  new->level = level;

  /* Caller must not free these lists */
  new->transcripts_consistent = (List_T) NULL;
  new->transcripts_inconsistent = (List_T) NULL;

  /* Unlike Stage3end_new_substrings, where substrings and junctions
     are in opposite orders, substrings and junctions here are in the
     same order. */

  substrings = Listpool_push(NULL,listpool,(void *) substring);
  new->substrings_1toN = substrings;
  new->substrings_Nto1 = Listpool_copy(substrings,listpool);
  new->substring_donor = (Substring_T) NULL;
  new->substring_acceptor = (Substring_T) NULL;
  /* Do not use substrings after this */

  new->junctions_1toN = new->junctions_Nto1 = (List_T) NULL;
  /* There is no junctions_HtoL field */
  /* Do not use junctions after this */

#if 0
  /* No need to reverse for a single substring */
  if (gplusp == true) {
    /* Substrings, head to tail, are query low to high and genome low to high */
    new->substrings_HtoL = List_reverse(new->substrings_HtoL);
  } else {
    /* Substrings, head to tail, are query low to high and genome high to low */
    new->substrings_LtoH = List_reverse(new->substrings_LtoH);
    new->junctions_LtoH = List_reverse(new->junctions_LtoH);
  }
#endif

#ifdef DEBUG0
  printf("NEW SUBSTRING\n");
  printf("%d..%d\t%u..%u\tmismatches:%d\tmatches_to_trims:%d\tamb:%d\n",Substring_querystart(substring),Substring_queryend(substring),
    Substring_alignstart_trim_chr(substring),Substring_alignend_trim_chr(substring),Substring_nmismatches_bothdiff(substring),
    Substring_nmatches_to_trims(substring),Substring_amb_length(substring));
  printf("\n");
#endif
  
  new->guided_insertlength = 0U;

  new->shortdistancep = true;
  new->chrnum = new->effective_chrnum = chrnum;
  new->other_chrnum = 0;
  new->chroffset = chroffset;
  new->chrhigh = chrhigh;
  new->chrlength = chrlength;
  new->plusp = gplusp;
  new->genestrand = genestrand;

  new->querylength = querylength;
  compute_ends(new,first_read_p);

  if (allow_softclipped_p == false) {
    if (new->querystart_trimmed > 0) {
      Stage3end_free(&new);
      return (Stage3end_T) NULL;
    } else if (new->queryend_trimmed < querylength) {
      Stage3end_free(&new);
      return (Stage3end_T) NULL;
    }
  }


  new->sensedir_for_concordance = new->sensedir = sensedir;

  new->nsplices = 0;
  new->splice_score = 0.0;
  new->nindels = 0;

  new->nmismatches_bothdiff = Substring_nmismatches_bothdiff(substring); /* Trimmed */
  new->nmismatches_refdiff = Substring_nmismatches_refdiff(substring);
  new->nsegments = List_length(new->substrings_1toN);

  compute_scores(new);

  /* found_score_overall does not compensate for spliced ends, so gives motivation to find distant splicing */
  if (new->refalt_score_overall < *found_score_overall) {
    *found_score_overall = new->refalt_score_overall;
  }
  /* found_score_within_trims does compensate for spliced trims, and guides how much further alignment is necessary */
  if (new->refalt_score_within_trims < *found_score_within_trims) {
    *found_score_within_trims = new->refalt_score_within_trims;
  }


  /* new->penalties = 0; */

  /* new->gene_overlap = NO_KNOWN_GENE; -- initialized later when resolving multimappers */
  /* new->tally = -1L; */

  new->paired_usedp = false;

  /* Terminals shouldn't have sense, which allow them to pair up with another mate */
  new->sensedir = SENSE_NULL;

  /* new->query_splicepos = -1; */
  new->circularpos = compute_circularpos(&new->circularalias,new);
  debug0(printf("Circularalias is %d\n",new->circularalias));

  if ((new->altlocp = altlocp[chrnum]) == false) {
    debug0(printf("*****Method %s: Stage3end_new_terminal returning primary %p at %u..%u, sensedir %d\n\n",
		  Method_string(method),new,new->genomicstart - chroffset,new->genomicend - chroffset,
		  new->sensedir));
    debug0(printf("score refalt_score_overall %d\n",new->refalt_score_overall));
    debug0(printf("score refalt_score_within_trims %d\n",new->refalt_score_within_trims));
    debug0(printf("score refalt_nmatches_plus_spliced_trims %d\n",new->refalt_nmatches_plus_spliced_trims));
    return new;

  } else {
    debug0(printf("*****Method %s: Stage3end_new_terminal returning altloc %p at %u..%u, sensedir %d\n\n",
		  Method_string(method),new,new->genomicstart - chroffset,new->genomicend - chroffset,
		  new->sensedir));
    debug0(printf("score refalt_score_overall %d\n",new->refalt_score_overall));
    debug0(printf("score refalt_score_within_trims %d\n",new->refalt_score_within_trims));
    debug0(printf("score refalt_nmatches_plus_spliced_trims %d\n",new->refalt_nmatches_plus_spliced_trims));
    return new;
  }
}



/* Called only by kmer-search.c */
T
Stage3end_new_precomputed (int *found_score_overall, int *found_score_within_trims,
			   int nmismatches_bothdiff, int nmismatches_refdiff,
			   List_T substrings, List_T junctions, List_T transcripts,
			   int querylength, Chrnum_T chrnum, Univcoord_T chroffset,
			   Univcoord_T chrhigh, Chrpos_T chrlength,
			   bool gplusp, int genestrand, bool first_read_p, int sensedir,
			   Listpool_T listpool, Method_T method, int level) {
  T new;

#ifdef DEBUG0
  Substring_T substring;
#endif
  Junction_T junction;
  Transcript_T transcript;
  List_T p;
  int nsites;
  double prob_total;


#ifdef DEBUG0
  printf("Entered Stage3end_new_precomputed, method %s, with gplusp %d, sensedir %d\n",
	 Method_string(method),gplusp,sensedir);
  printf("%d substrings\n",List_length(substrings));
  printf("%d junctions\n",List_length(junctions));
  printf("%d transcripts\n",List_length(transcripts));
#endif
  assert(List_length(substrings) == List_length(junctions) + 1);

  new = (T) MALLOC_OUT(sizeof(*new));
  new->hittype = SUBSTRINGS;
  new->distant_splice_i = -1;	/* new->distant_splice_p = false; */
  new->method = method;
  new->level = level;

  /* Caller must not free these lists */
  debug2(printf("Stage3end_new_precomputed (sensedir %d) on chrnum %d has %d transcripts_consistent\n",
		sensedir,chrnum,List_length(transcripts_consistent)));

  new->transcripts_consistent = (List_T) NULL;
  new->transcripts_inconsistent = (List_T) NULL;

  for (p = transcripts; p != NULL; p = List_next(p)) {
    transcript = (Transcript_T) List_head(p);
    if (Transcript_velocity(transcript) == V_UTR) {
      new->transcripts_inconsistent = Listpool_push(new->transcripts_inconsistent,listpool,transcript);
      abort();
    } else {
      new->transcripts_consistent = Listpool_push(new->transcripts_consistent,listpool,transcript);
    }
  }
  /* List_free(&transcripts);  -- Alloated by Listpool_push */


  /* Unlike Stage3end_new_substrings, where substrings and junctions
     are in opposite orders, substrings and junctions here are in the
     same order. */

  new->substrings_1toN = substrings;
  new->substrings_Nto1 = List_reverse(Listpool_copy(substrings,listpool));
  new->substring_donor = (Substring_T) NULL;
  new->substring_acceptor = (Substring_T) NULL;
  
  new->junctions_1toN = junctions;
  new->junctions_Nto1 = List_reverse(Listpool_copy(junctions,listpool));


  /* There is no junctions_HtoL field */

#if 0
  if (gplusp == true) {
    /* Substrings, head to tail, are query low to high and genome low to high */
    new->substrings_LtoH = Listpool_copy(new->substrings_1toN,listpool);
    new->substrings_HtoL = Listpool_copy(new->substrings_Nto1,listpool);
    new->junctions_LtoH = Listpool_copy(new->junctions_1toN,listpool);
    /* new->junctions_HtoL = Listpool_copy(new->junctions_Nto1,listpool); */
  } else {
    /* Substrings, head to tail, are query low to high and genome high to low */
    new->substrings_LtoH = Listpool_copy(new->substrings_Nto1,listpool);
    new->substrings_HtoL = Listpool_copy(new->substrings_1toN,listpool);
    new->junctions_LtoH = Listpool_copy(new->junctions_Nto1,listpool);
    /* new->junctions_HtoL = Listpool_copy(new->junctions_1toN,listpool); */
  }
#endif
  /* Do not use substrings after this */
  /* Do not use junctions after this */



#ifdef DEBUG0
  printf("NEW SUBSTRINGS (query order) (1)\n");
  for (p = new->substrings_1toN; p != NULL; p = List_next(p)) {
    substring = List_head(p);
    if (Substring_ambiguous_p(substring) == true) {
      printf("%d..%d\t%u..%u\tmismatches:%d\tmatches_to_trims:%d\tamb:%d\tprobs:%f and %f\tsensedir:%d\n",Substring_querystart(substring),Substring_queryend(substring),
	     Substring_alignstart_trim_chr(substring),Substring_alignend_trim_chr(substring),Substring_nmismatches_bothdiff(substring),
	     Substring_nmatches_to_trims(substring),Substring_amb_length(substring),Substring_alt_donor_prob(substring),Substring_alt_acceptor_prob(substring),Substring_sensedir(substring));
    } else {
      printf("%d..%d\t%u..%u\tmismatches:%d\tmatches_to_trims:%d\tamb:%d\tsensedir:%d\n",Substring_querystart(substring),Substring_queryend(substring),
	     Substring_alignstart_trim_chr(substring),Substring_alignend_trim_chr(substring),Substring_nmismatches_bothdiff(substring),
	     Substring_nmatches_to_trims(substring),Substring_amb_length(substring),Substring_sensedir(substring));
    }
  }
  printf("\n");

  printf("NEW JUNCTIONS (query order)\n");
  for (p = new->junctions_1toN; p != NULL; p = List_next(p)) {
    junction = List_head(p);
    printf("splice distance %u, nindels %d\n",Junction_splice_distance(junction),Junction_nindels(junction));
  }
  printf("\n");
#endif
  
  new->guided_insertlength = 0U;

  new->shortdistancep = true;
  new->chrnum = new->effective_chrnum = chrnum;
  new->other_chrnum = 0;
  new->chroffset = chroffset;
  new->chrhigh = chrhigh;
  new->chrlength = chrlength;
  new->plusp = gplusp;
  new->genestrand = genestrand;

  new->querylength = querylength;
  compute_ends(new,first_read_p);

  if (allow_softclipped_p == false) {
    if (new->querystart_trimmed > 0) {
      /* Stage3end_free(&new); */
      /* Caller frees substrings and junctions */
      FREE(new);
      return (Stage3end_T) NULL;
    } else if (new->queryend_trimmed < querylength) {
      /* Stage3end_free(&new); */
      /* Caller frees substrings and junctions */
      FREE(new);
      return (Stage3end_T) NULL;
    }
  }




  prob_total = 0.0;
  nsites = 0;
  new->nsplices = 0;
  for (p = junctions; p != NULL; p = List_next(p)) {
    junction = (Junction_T) List_head(p);
    if (Junction_type(junction) == SPLICE_JUNCTION) {
      prob_total += Junction_splice_score(junction);
      nsites += 2;
      new->nsplices += 1;
    }
  }
  if (nsites == 0) {
    new->splice_score = 0.0;
  } else {
    new->splice_score = prob_total / (double) nsites;
  }
  debug0(printf("SPLICE SCORE: %f\n",new->splice_score));
  new->nindels = 0;


  new->nmismatches_bothdiff = nmismatches_bothdiff; /* Trimmed */
  new->nmismatches_refdiff = nmismatches_refdiff;
  new->nsegments = List_length(new->substrings_1toN);

  compute_scores(new);

  /* found_score_overall does not compensate for spliced ends, so gives motivation to find distant splicing */
  if (new->refalt_score_overall < *found_score_overall) {
    *found_score_overall = new->refalt_score_overall;
  }
  /* found_score_within_trims does compensate for spliced trims, and guides how much further alignment is necessary */
  if (new->refalt_score_within_trims < *found_score_within_trims) {
    *found_score_within_trims = new->refalt_score_within_trims;
  }


  /* new->penalties = 0; */

  /* new->gene_overlap = NO_KNOWN_GENE; -- initialized later when resolving multimappers */
  /* new->tally = -1L; */

  new->sensedir_for_concordance = new->sensedir = sensedir;

  new->paired_usedp = false;

  /* new->query_splicepos = -1; */
  new->circularpos = compute_circularpos(&new->circularalias,new);
  debug0(printf("Circularalias is %d\n",new->circularalias));

  if ((new->altlocp = altlocp[chrnum]) == false) {
    debug0(printf("*****Method %s: Stage3end_new_precomputed returning primary %p at %u..%u with sensedir %d and splice_score %f\n\n",
		  Method_string(method),new,new->genomicstart - chroffset,new->genomicend - chroffset,
		  new->sensedir,new->splice_score));
    debug0(printf("score refalt_score_overall %d\n",new->refalt_score_overall));
    debug0(printf("score refalt_score_within_trims %d\n",new->refalt_score_within_trims));
    debug0(printf("score refalt_nmatches_plus_spliced_trims %d\n",new->refalt_nmatches_plus_spliced_trims));
    return new;

  } else {
    debug0(printf("*****Method %s: Stage3end_new_precomputed returning altloc %p at %u..%u with sensedir %d and splice_score %f\n\n",
		  Method_string(method),new,new->genomicstart - chroffset,new->genomicend - chroffset,
		  new->sensedir,new->splice_score));
    debug0(printf("score refalt_score_overall %d\n",new->refalt_score_overall));
    debug0(printf("score refalt_score_within_trims %d\n",new->refalt_score_within_trims));
    debug0(printf("score refalt_nmatches_plus_spliced_trims %d\n",new->refalt_nmatches_plus_spliced_trims));
    return new;
  }
}


int
Stage3end_nmatches_substrings (int *ref_nmatches, Intlist_T endpoints, Univcoordlist_T univdiagonals,
			       Intlist_T nmismatches_list, Intlist_T ref_nmismatches_list, List_T junctions,
			       int querylength, Compress_T query_compress,
			       Substring_T qend_alts, Substring_T qstart_alts, bool plusp, int genestrand,
			       Chrnum_T chrnum, Univcoord_T chroffset, Univcoord_T chrhigh, Chrpos_T chrlength,
			       bool splice5p_in, bool splice3p_in, Listpool_T listpool) {
  int nmatches, substring_nmatches, substring_ref_nmatches;
  int qstart, qend;
  Univcoord_T univdiagonal, left;
  Intlist_T r, x, y;
  Univcoordlist_T q;
  Junction_T junction;
#ifdef MAKE_JUNCTION
  Junction_T qstart_junction = NULL, qend_junction = NULL;
  double donor_prob, acceptor_prob;
#endif
  List_T newjunctions, p, j;
  bool splice5p, splice3p;
  int adj0;			/* deletions - insertions */
  int nmismatches, ref_nmismatches, indel_score = 0, nindels = 0;
  int nindelbreaks, n_large_indels;
  /* double donor_prob, acceptor_prob; */


  debug0(printf("Entered Stage3end_nmatches_substrings with %s, plusp %d, splice5p %d, splice3p %d\n",
		Intlist_to_string(endpoints),plusp,splice5p_in,splice3p_in));

  nmatches = 0;
  *ref_nmatches = 0;

#ifdef DEBUG7
  printf("Entered Stage3end_nmatches_substrings, at univdiagonal %u [%u], with chrnum #%d, plusp %d, and endpoints %s\n",
	 Univcoordlist_head(univdiagonals),Univcoordlist_head(univdiagonals) - chroffset,chrnum,plusp,Intlist_to_string(endpoints));
  printf("There are %d endpoints, %d univdiagonals, %d nmismatches, and %d junctions\n",
	 Intlist_length(endpoints),Univcoordlist_length(univdiagonals),Intlist_length(nmismatches_list),List_length(junctions));
  if (qstart_alts != NULL) {
    printf("qstart_alts at %d..%d\n",Substring_querystart(qstart_alts),Substring_queryend(qstart_alts));
  }
  if (qend_alts != NULL) {
    printf("qend_alts at %d..%d\n",Substring_querystart(qend_alts),Substring_queryend(qend_alts));
  }
  printf("Endpoints: %s\n",Intlist_to_string(endpoints));
  printf("Univdiagonals: %s\n",Univcoordlist_to_string_offset(univdiagonals,chroffset));
  printf("Mismatches: %s\n",Intlist_to_string(nmismatches_list));
  printf("Ref mismatches: %s\n",Intlist_to_string(ref_nmismatches_list));
#endif

  assert(Univcoordlist_length(univdiagonals) == Intlist_length(endpoints) - 1);
  assert(Intlist_length(nmismatches_list) == Intlist_length(endpoints) - 1);
  assert(Intlist_length(ref_nmismatches_list) == Intlist_length(endpoints) - 1);
  assert(List_length(junctions) == Intlist_length(endpoints) - 2);

  
  newjunctions = Listpool_copy(junctions,listpool);


#ifdef DEBUG0
  for (p = junctions; p != NULL; p = List_next(p)) {
    Junction_print((Junction_T) List_head(p));
  }
  printf("\n");
#endif


  qstart = Intlist_head(endpoints);
  nmismatches = Intlist_head(nmismatches_list);
  ref_nmismatches = Intlist_head(ref_nmismatches_list);
  
  if (plusp == true) {
    j = newjunctions;		/* Put here before we handle querystart_alts */
    if (qstart_alts != NULL) {
      debug7(printf("Adding %d matches for qstart_alts\n",Substring_nmatches(qstart_alts)));
      nmatches += Substring_nmatches(qstart_alts); /* Not nmatches_to_trims, which is 0 for alts_substring */
      *ref_nmatches += Substring_ref_nmatches(qstart_alts); /* Not nmatches_to_trims, which is 0 for alts_substring */
#ifdef MAKE_JUNCTION
      donor_prob = Substring_alt_donor_prob(qstart_alts);
      acceptor_prob = Substring_alt_acceptor_prob(qstart_alts);
      qstart_junction = Junction_new_ambig_splice(orig_sensedir,donor_prob,acceptor_prob);
      newjunctions = Listpool_push(newjunctions,listpool,(void *) qstart_junction);
#else
      newjunctions = Listpool_push(newjunctions,listpool,(void *) NULL);
#endif
      splice5p = false;
    } else {
      splice5p = splice5p_in;
    }

    /* Add qpos to get alignstart/alignend */
    for (q = univdiagonals, x = nmismatches_list, y = ref_nmismatches_list, r = Intlist_next(endpoints); q != NULL;
	 q = Univcoordlist_next(q), x = Intlist_next(x), y = Intlist_next(y), r = Intlist_next(r), j = List_next(j)) {
      qend = Intlist_head(r);
      nmismatches = Intlist_head(x);
      ref_nmismatches = Intlist_head(y);
      univdiagonal = Univcoordlist_head(q);
      left = univdiagonal - (Univcoord_T) querylength;
      debug0(printf("Stage3end_nmatches_substrings: qstart %d..qend %d at univdiagonal %u [%u]\n",
		    qstart,qend,univdiagonal,univdiagonal - chroffset));

      /* genomicstart = left; */
      /* genomicend = left + querylength; */
      /* alignstart = genomicstart + qstart; */
      /* alignend = genomicstart + qend; */

      if (nmismatches >= 0 && ref_nmismatches >= 0) {
	debug7(printf("Checking mismatches at %u from querystart %d to queryend %d\n",univdiagonal - chroffset,qstart,qend));
	debug7(printf("%d vs %d\n",nmismatches,
		      Genome_count_mismatches_substring(&ref_nmismatches,genomebits,genomebits_alt,query_compress,left,
							/*pos5*/qstart,/*pos3*/qend,/*plusp*/true,genestrand)));
#ifdef CHECK_NMISMATCHES
	assert(nmismatches == Genome_count_mismatches_substring(&ref_nmismatches,genomebits,genomebits_alt,query_compress,left,
								/*pos5*/qstart,/*pos3*/qend,/*plusp*/true,genestrand));
#endif
      } else {
	nmismatches = Genome_count_mismatches_substring(&ref_nmismatches,genomebits,genomebits_alt,query_compress,left,
							/*pos5*/qstart,/*pos3*/qend,/*plusp*/true,genestrand);
	Intlist_head_set(x,nmismatches);		/* Save for Stage3end_new_substrings */
	Intlist_head_set(y,ref_nmismatches);		/* Save for Stage3end_new_substrings */
	debug7(printf("%d (%d ref) mismatches from genome over querypos %d..%d\n",
		      nmismatches,ref_nmismatches,qstart,qend));
      }
      if (Univcoordlist_next(q) != NULL || qend_alts != NULL) {
	splice3p = false;
      } else {
	splice3p = splice3p_in;
      }

      if (splice5p == false && splice3p == false) {
	/* Could potentially check here if qstart < qend, but relying upon caller to use endpoints_acceptable_p */
	debug7(printf("Shortcut computes matches of %d = (%d - %d) - nmismatches %d\n",
		      (qend-qstart)-nmismatches,qend,qstart,nmismatches));
	nmatches += (qend - qstart) - nmismatches;
	*ref_nmatches += (qend - qstart) - ref_nmismatches;
      } else {
        substring_nmatches =
	  Substring_compute_nmatches(&substring_ref_nmatches,left,/*querystart*/qstart,/*queryend*/qend,querylength,
				     /*plusp*/true,genestrand,query_compress,genomebits,genomebits_alt,
				     chrnum,chroffset,chrhigh,chrlength,
				     /*splice_querystart_p*/splice5p,/*splice_queryend_p*/splice3p,/*chrnum_fixed_p*/true);
	if (substring_nmatches < 0) {
	  /* Don't know how to fix junctions */
	  debug0(printf("Poor substring (plus) for %d..%d, so returning -1 from Stage3end_nmatches_substrings\n",
			qstart,qend));
	  *ref_nmatches = -1;
	  return -1;
	} else {
	  debug7(printf("Substring_compute_nmatches returns nmatches %d over querypos %d..%d\n",
			substring_nmatches,qstart,qend));
	  nmatches += substring_nmatches;
	  *ref_nmatches += substring_ref_nmatches;
	}
      }

      /* Prepare for next iteration */
      qstart = qend;
      if (j != NULL) {
	if ((junction = (Junction_T) List_head(j)) == NULL) {
	  /* qstart_junction */
	} else if ((adj0 = Junction_adj(junction)) != 0) {
	  /* adj += adj0; */
	  indel_score += indel_penalty_middle;
	  nindels += Junction_nindels(junction);
	  if (adj0 < 0) {
	    debug7(printf("Adjusting qstart %d up by %d\n",qstart,-adj0));
	    qstart -= adj0;	/* Insertion */
	  }
	}
      }
      splice5p = false;
    }

  } else {
    j = newjunctions;		/* Put here before we handle querystart_alts */
    if (qstart_alts != NULL) {
      debug7(printf("Adding %d matches for qstart_alts\n",Substring_nmatches(qstart_alts)));
      nmatches += Substring_nmatches(qstart_alts); /* Not nmatches_to_trims, which is 0 for alts_substring */
      *ref_nmatches += Substring_ref_nmatches(qstart_alts); /* Not nmatches_to_trims, which is 0 for alts_substring */
#ifdef MAKE_JUNCTION
      donor_prob = Substring_alt_donor_prob(qstart_alts);
      acceptor_prob = Substring_alt_acceptor_prob(qstart_alts);
      qstart_junction = Junction_new_ambig_splice(orig_sensedir,donor_prob,acceptor_prob);
      /* printf("Creating junction with donor_prob %f and acceptor_prob %f\n",donor_prob,acceptor_prob); */
      newjunctions = Listpool_push(newjunctions,listpool,(void *) qstart_junction);
#else
      newjunctions = Listpool_push(newjunctions,listpool,(void *) NULL);
#endif
      splice5p = false;
    } else {
      splice5p = splice5p_in;
    }

    /* Subtract querypos to get alignstart/alignend */
    for (q = univdiagonals, x = nmismatches_list, y = ref_nmismatches_list, r = Intlist_next(endpoints); q != NULL;
	 q = Univcoordlist_next(q), x = Intlist_next(x), y = Intlist_next(y), r = Intlist_next(r), j = List_next(j)) {
      qend = Intlist_head(r);
      nmismatches = Intlist_head(x);
      ref_nmismatches = Intlist_head(y);
      univdiagonal = Univcoordlist_head(q);
      left = univdiagonal - (Univcoord_T) querylength;
      debug0(printf("Stage3end_nmatches_substrings: qstart %d..qend %d at univdiagonal %u [%u]\n",
		    qstart,qend,univdiagonal,univdiagonal - chroffset));

      /* genomicend = left; */
      /* genomicstart = left + querylength; */
      /* genomicend_adj = genomicend - adj; */
      /* genomicstart_adj = genomicend - adj; */
      /* alignstart = genomicstart - (querylength - qend); */
      /* alignend = genomicstart - (querylength - qstart); */

      if (nmismatches >= 0 && ref_nmismatches >= 0) {
#ifdef CHECK_NMISMATCHES
	assert(nmismatches == Genome_count_mismatches_substring(&ref_nmismatches,genomebits,genomebits_alt,query_compress,left,
								/*pos5*/qstart,/*pos3*/qend,/*plusp*/false,genestrand));
#endif
      } else {
	nmismatches = Genome_count_mismatches_substring(&ref_nmismatches,genomebits,genomebits_alt,query_compress,left,
							/*pos5*/qstart,/*pos3*/qend,/*plusp*/false,genestrand);
	Intlist_head_set(x,nmismatches);		/* Save for Stage3end_new_substrings */
	Intlist_head_set(y,ref_nmismatches);		/* Save for Stage3end_new_substrings */
	debug7(printf("%d (%d ref) mismatches from genome over querypos %d..%d\n",
		      nmismatches,ref_nmismatches,querylength - qend,querylength - qstart));
      }
      if (Univcoordlist_next(q) != NULL || qend_alts != NULL) {
	splice3p = false;
      } else {
	splice3p = splice3p_in;
      }

      if (splice5p == false && splice3p == false) {
	/* Could potentially check here if qstart < qend, but relying upon caller to use endpoints_acceptable_p */
	debug7(printf("Shortcut computes matches of %d = (%d - %d) - nmismatches %d\n",
		      (qend-qstart)-nmismatches,querylength - qstart,querylength - qend,nmismatches));
	nmatches += (qend - qstart) - nmismatches;
	*ref_nmatches += (qend - qstart) - ref_nmismatches;
      } else {
	substring_nmatches =
	  Substring_compute_nmatches(&substring_ref_nmatches,left,/*querystart*/querylength - qend,
				     /*queryend*/querylength - qstart,querylength,
				     /*plusp*/false,genestrand,query_compress,genomebits,genomebits_alt,
				     chrnum,chroffset,chrhigh,chrlength,/*splice_querystart_p*/splice3p,
				     /*splice_queryend_p*/splice5p,/*chrnum_fixed_p*/true);
	if (substring_nmatches < 0) {
	  /* Don't know how to fix junctions */
	  debug0(printf("Poor substring (minus) for querypos %d..%d, so returning -1 from Stage3end_new_substrings\n",
			querylength - qend,querylength - qstart));
	  *ref_nmatches = -1;
	  return -1;
	} else {
	  debug7(printf("Substring_compute_nmatches returns nmatches %d over querypos %d..%d\n",
			substring_nmatches,querylength - qend,querylength - qstart));
	  nmatches += substring_nmatches;
	  *ref_nmatches += substring_ref_nmatches;
	}
      }

      /* Prepare for next iteration */
      qstart = qend;
      if (j != NULL) {
	if ((junction = (Junction_T) List_head(j)) == NULL) {
	  /* qstart_junction */
	} else if ((adj0 = Junction_adj(junction)) != 0) {
	  /* adj += adj0; */
	  indel_score += indel_penalty_middle;
	  nindels += Junction_nindels(junction);
	  if (adj0 < 0) {
	    debug7(printf("Adjusting qstart %d up by %d\n",qstart,-adj0));
	    qstart -= adj0;	/* Insertion */
	  }
	}
      }
      splice5p = false;
    }
  }

  if (qend_alts != NULL) {
    debug7(printf("Adding %d matches for qend_alts\n",Substring_nmatches(qend_alts)));
    nmatches += Substring_nmatches(qend_alts); /* Not nmatches_to_trims, which is 0 for alts_substring */
    *ref_nmatches += Substring_ref_nmatches(qend_alts); /* Not nmatches_to_trims, which is 0 for alts_substring */
#ifdef MAKE_JUNCTION
    newjunctions = List_reverse(newjunctions);
    donor_prob = Substring_alt_donor_prob(qend_alts);
    acceptor_prob = Substring_alt_acceptor_prob(qend_alts);
    qend_junction = Junction_new_ambig_splice(orig_sensedir,donor_prob,acceptor_prob);
    /* printf("Creating junction with donor_prob %f and acceptor_prob %f\n",donor_prob,acceptor_prob); */
    newjunctions = Listpool_push(newjunctions,listpool,(void *) qend_junction);
    newjunctions = List_reverse(newjunctions);
#endif
  }

    
  nindelbreaks = 0;
  n_large_indels = 0;

  for (p = newjunctions; p != NULL; p = List_next(p)) {
    junction = (Junction_T) List_head(p);
    /* CHIMERA_JUNCTION not possible */
    if (junction == NULL) {
      /* qstart_junction */
    } else if (Junction_type(junction) == SPLICE_JUNCTION) {
      /* No indel breaks.  ? Add penalty for bad splice probs */

    } else if (Junction_type(junction) == INS_JUNCTION) {
      nindelbreaks++;
      if (Junction_nindels(junction) > 6) {
	n_large_indels++;
      }
    } else if (Junction_type(junction) == DEL_JUNCTION) {
      nindelbreaks++;
      if (Junction_nindels(junction) > 6) {
	n_large_indels++;
      }
    }
  }

#if 0
  nmatches = nmatches - nindelbreaks*indel_penalty_middle - n_large_indels*3;
  for (p = newjunctions; p != NULL; p = List_next(p)) {
    if ((junction = List_head(p)) != NULL) {
      nmatches += Junction_ninserts(junction);
    }
  }
#endif


#ifdef MAKE_JUNCTION
  Junction_free(&qstart_junction);
  Junction_free(&qend_junction);
#endif
  
  debug7(printf("Stage3end_nmatches_substrings returning %d matches\n",nmatches));
  /* List_free(&newjunctions); -- allocated by Listpool_push */

  assert(nmatches <= querylength);
  return nmatches;
}



/* endpoints are all in qstart/qend convention.  Need to convert to
   querystart and queryend when creating Substring_T objects */
/* Three actions at each end: extend, chop, or compute_trim */
T
Stage3end_new_substrings (int *found_score_overall, int *found_score_within_trims,
			  Intlist_T endpoints, Univcoordlist_T univdiagonals,
			  Intlist_T nmismatches_list, Intlist_T ref_nmismatches_list, List_T junctions,
			  int querylength, Compress_T query_compress,
			  Substring_T qend_alts, Substring_T qstart_alts,
			  bool plusp, int genestrand, bool first_read_p, int try_sensedir,
			  Chrnum_T chrnum, Univcoord_T chroffset, Univcoord_T chrhigh, Chrpos_T chrlength,
			  bool splice5p_in, Splicetype_T splicetype5, double ambig_prob_5,
			  bool splice3p_in, Splicetype_T splicetype3, double ambig_prob_3,
			  Listpool_T listpool, Method_T method, int level) {
  T new;

  int querylength_trimmed = 0;
  int qstart, qend, queryspan;
  Univcoord_T univdiagonal, left;
  Intlist_T r, x, y;
  Univcoordlist_T q;
  Substring_T substring, substring1, substringN;
  Junction_T junction;
  List_T substrings_HtoL, substrings_LtoH, junctions_LtoH;
  List_T substrings = NULL, p, j;
  List_T newjunctions;
  bool splice5p, splice3p, passp;
  int adj = 0, adj0;			/* deletions - insertions */
  int nmismatches, ref_nmismatches, nindels = 0;
  int nmismatches_bothdiff = 0, nmismatches_refdiff = 0;
  int new_sensedir;
  bool sensep, antisensep, contradictionp;
  int nsites, nindelbreaks, n_large_indels;
  double prob_total, donor_prob, acceptor_prob;


  debug7(printf("Entered Stage3end_new_substrings, method %s, with %s, plusp %d, splice5p %d, splice3p %d\n",
		Method_string(method),Intlist_to_string(endpoints),plusp,splice5p_in,splice3p_in));

#ifdef DEBUG0
  printf("Entered Stage3end_new_substrings, method %s, at univdiagonal %u [%u], with chrnum #%d, plusp %d, try_sensedir %d, and endpoints %s\n",
	 Method_string(method),Univcoordlist_head(univdiagonals),Univcoordlist_head(univdiagonals) - chroffset,chrnum,plusp,try_sensedir,Intlist_to_string(endpoints));
  printf("There are %d endpoints, %d univdiagonals, %d nmismatches, and %d junctions\n",
	 Intlist_length(endpoints),Univcoordlist_length(univdiagonals),Intlist_length(nmismatches_list),List_length(junctions));
  if (qstart_alts != NULL) {
    printf("qstart_alts at %d..%d.  ",Substring_querystart(qstart_alts),Substring_queryend(qstart_alts));
    Substring_print_alts_coords(qstart_alts);
    printf("\n");
  }
  if (qend_alts != NULL) {
    printf("qend_alts at %d..%d.  ",Substring_querystart(qend_alts),Substring_queryend(qend_alts));
    Substring_print_alts_coords(qend_alts);
    printf("\n");
  }
  printf("Endpoints: %s\n",Intlist_to_string(endpoints));
  printf("Univdiagonals: %s\n",Univcoordlist_to_string_offset(univdiagonals,chroffset));
  printf("Mismatches: %s\n",Intlist_to_string(nmismatches_list));
  printf("Ref mismatches: %s\n",Intlist_to_string(ref_nmismatches_list));
#endif

  assert(Univcoordlist_length(univdiagonals) == Intlist_length(endpoints) - 1);
  assert(Intlist_length(nmismatches_list) == Intlist_length(endpoints) - 1);
  assert(Intlist_length(ref_nmismatches_list) == Intlist_length(endpoints) - 1);
  assert(List_length(junctions) == Intlist_length(endpoints) - 2);

  
  newjunctions = Junction_copy_list(junctions,listpool);

#ifdef DEBUG0
  for (p = newjunctions; p != NULL; p = List_next(p)) {
    Junction_print((Junction_T) List_head(p));
  }
  printf("\n");
#endif

  qstart = Intlist_head(endpoints);
  nmismatches = Intlist_head(nmismatches_list);
  ref_nmismatches = Intlist_head(ref_nmismatches_list);

  if (plusp == true) {
    j = newjunctions;		/* Put here before we handle qstart_alts */
    if (qstart_alts != NULL) {
      substrings = Listpool_push(substrings,listpool,(void *) Substring_copy(qstart_alts));
      donor_prob = Substring_alt_donor_prob(qstart_alts);
      acceptor_prob = Substring_alt_acceptor_prob(qstart_alts);
      junction = Junction_new_ambig_splice(try_sensedir,donor_prob,acceptor_prob);
      newjunctions = Listpool_push(newjunctions,listpool,(void *) junction);
      splice5p = false;
    } else {
      splice5p = splice5p_in;
    }

    /* Add qpos to get alignstart/alignend */
    for (q = univdiagonals, x = nmismatches_list, y = ref_nmismatches_list, r = Intlist_next(endpoints); q != NULL;
	 q = Univcoordlist_next(q), x = Intlist_next(x), y = Intlist_next(y), r = Intlist_next(r), j = List_next(j)) {
      qend = Intlist_head(r);
      nmismatches = Intlist_head(x);
      ref_nmismatches = Intlist_head(y);
      univdiagonal = Univcoordlist_head(q);
      left = univdiagonal - (Univcoord_T) querylength;
      debug0(printf("Stage3end_new_substrings: qstart %d..qend %d at univdiagonal %u [%u}\n",
		    qstart,qend,univdiagonal,univdiagonal - chroffset));

      /* genomicstart = left; */
      /* genomicend = left + querylength; */
      /* alignstart = genomicstart + qstart; */
      /* alignend = genomicstart + queryend; */

      if (nmismatches >= 0 && ref_nmismatches >= 0) {
	debug7(printf("Checking mismatches at %u from querystart %d to queryend %d\n",univdiagonal - chroffset,qstart,qend));
	debug7(printf("%d vs %d\n",nmismatches,
		      Genome_count_mismatches_substring(&ref_nmismatches,genomebits,genomebits_alt,query_compress,left,
							/*pos5*/qstart,/*pos3*/qend,/*plusp*/true,genestrand)));
#ifdef CHECK_NMISMATCHES
	assert(nmismatches == Genome_count_mismatches_substring(&ref_nmismatches,genomebits,genomebits_alt,query_compress,left,
								/*pos5*/qstart,/*pos3*/qend,/*plusp*/true,genestrand));
#endif
      } else {
	nmismatches = Genome_count_mismatches_substring(&ref_nmismatches,genomebits,genomebits_alt,query_compress,left,
							/*pos5*/qstart,/*pos3*/qend,/*plusp*/true,genestrand);
      }
      if (Univcoordlist_next(q) != NULL || qend_alts != NULL) {
	splice3p = false;
      } else {
	splice3p = splice3p_in;
      }

      if ((substring = Substring_new(nmismatches,ref_nmismatches,left,/*querystart*/qstart,/*queryend*/qend,querylength,
				     /*plusp*/true,genestrand,query_compress,genomebits,genomebits_alt,
				     chrnum,chroffset,chrhigh,chrlength,
				     /*splice_querystart_p*/splice5p,/*splicetype_querystart*/splicetype5,
				     /*ambig_prob_querystart*/ambig_prob_5,
				     /*splice_queryend_p*/splice3p,/*splicetype_queryend*/splicetype3,
				     /*ambig_prob_queryend*/ambig_prob_3,try_sensedir)) == NULL) {
	/* Don't know how to fix junctions */
	debug0(printf("Poor substring (plus) for %d..%d, so returning NULL from Stage3end_new_substrings\n",
		      qstart,qend));
	for (p = substrings; p != NULL; p = List_next(p)) {
	  substring = (Substring_T) List_head(p);
	  if (substring == qstart_alts) {
	    /* qstart_alts freed by calling procedure.  Need to free junction created for querystart_alts. */
	    /* junctions = List_pop(junctions,(void **) &junction); */
	    /* Junction_free(&junction); */
	  } else {
	    Substring_free(&substring);
	  }
	}
	/* List_free(&substrings); -- allocated by Listpool_push */
	debug0(printf("Stage3end_new_substrings returning NULL\n"));
	Junction_list_gc(&newjunctions);
	return (T) NULL;

      } else {
	debug7(printf("Substring_new returns nmismatches %d, nmatches %d, ambp %d, amb %d over querypos %d..%d\n",
		      Substring_nmismatches_bothdiff(substring),
		      Substring_nmatches(substring),Substring_ambiguous_p(substring),
		      Substring_amb_length(substring),Substring_querystart(substring),Substring_queryend(substring)));

	debug0(printf("Substring_new returns nmismatches %d, nmatches %d, ambp %d, amb %d over querypos %d..%d\n",
		      Substring_nmismatches_bothdiff(substring),
		      Substring_nmatches(substring),Substring_ambiguous_p(substring),
		      Substring_amb_length(substring),Substring_querystart(substring),Substring_queryend(substring)));
	substrings = Listpool_push(substrings,listpool,(void *) substring);
	nmismatches_bothdiff += Substring_nmismatches_bothdiff(substring);
	nmismatches_refdiff += Substring_nmismatches_refdiff(substring);
	querylength_trimmed += Substring_match_length(substring);
      }

      /* Prepare for next iteration */
      qstart = qend;
      if (j != NULL) {
	junction = (Junction_T) List_head(j);
	if ((adj0 = Junction_adj(junction)) != 0) {
	  adj += adj0;
	  /* indel_score += indel_penalty_middle; */
	  nindels += Junction_nindels(junction);
	  if (adj0 < 0) {
	    qstart -= adj0;	/* Insertion */
	  }
	}
      }
      splice5p = false;
    }

  } else {
    j = newjunctions;		/* Put here before we handle querystart_alts */
    if (qstart_alts != NULL) {
      substrings = Listpool_push(substrings,listpool,(void *) Substring_copy(qstart_alts));
      donor_prob = Substring_alt_donor_prob(qstart_alts);
      acceptor_prob = Substring_alt_acceptor_prob(qstart_alts);
      junction = Junction_new_ambig_splice(try_sensedir,donor_prob,acceptor_prob);
      /* printf("Creating junction with donor_prob %f and acceptor_prob %f\n",donor_prob,acceptor_prob); */
      newjunctions = Listpool_push(newjunctions,listpool,(void *) junction);
      splice5p = false;
    } else {
      splice5p = splice5p_in;
    }

    /* Subtract qpos to get alignstart/alignend */
    for (q = univdiagonals, x = nmismatches_list, y = ref_nmismatches_list, r = Intlist_next(endpoints); q != NULL;
	 q = Univcoordlist_next(q), x = Intlist_next(x), y = Intlist_next(y), r = Intlist_next(r), j = List_next(j)) {
      qend = Intlist_head(r);
      nmismatches = Intlist_head(x);
      ref_nmismatches = Intlist_head(y);
      univdiagonal = Univcoordlist_head(q);
      left = univdiagonal - (Univcoord_T) querylength;
      debug0(printf("Stage3end_new_substrings: qstart %d..qend %d at univdiagonal %u [%u]\n",
		    qstart,qend,univdiagonal,univdiagonal - chroffset));

      /* genomicend = left; */
      /* genomicstart = left + querylength; */
      /* genomicend_adj = genomicend - adj; */
      /* genomicstart_adj = genomicend - adj; */
      /* alignstart = genomicstart - (querylength - qend); */
      /* alignend = genomicstart - (querylength - qstart); */

      if (nmismatches >= 0 && ref_nmismatches >= 0) {
#ifdef CHECK_NMISMATCHES
	assert(nmismatches == Genome_count_mismatches_substring(&ref_nmismatches,genomebits,genomebits_alt,query_compress,left,
								/*pos5*/qstart,/*pos3*/qend,/*plusp*/false,genestrand));
#endif
      } else {
	nmismatches = Genome_count_mismatches_substring(&ref_nmismatches,genomebits,genomebits_alt,query_compress,left,
							/*pos5*/qstart,/*pos3*/qend,/*plusp*/false,genestrand);
      }
      if (Univcoordlist_next(q) != NULL || qend_alts != NULL) {
	splice3p = false;
      } else {
	splice3p = splice3p_in;
      }

      if ((substring = Substring_new(nmismatches,ref_nmismatches,left,/*querystart*/querylength - qend,
				     /*queryend*/querylength - qstart,querylength,
				     /*plusp*/false,genestrand,query_compress,genomebits,genomebits_alt,
				     chrnum,chroffset,chrhigh,chrlength,
				     /*splice_querystart_p*/splice3p,/*splicetype_querystart*/splicetype3,
				     /*ambig_prob_querystart*/ambig_prob_3,
				     /*splice_queryend_p*/splice5p,/*splicetype_queryend*/splicetype5,
				     /*ambig_prob_queryend*/ambig_prob_5,try_sensedir)) == NULL) {
	/* Don't know how to fix junctions */
	debug0(printf("Poor substring (minus) for %d..%d, so returning NULL from Stage3end_new_substrings\n",
		      querylength - qend,querylength - qstart));
	for (p = substrings; p != NULL; p = List_next(p)) {
	  substring = (Substring_T) List_head(p);
	  if (substring == qstart_alts) {
	    /* querystart_alts freed by calling procedure.  Need to free junction created for querystart_alts. */
	    /* junctions = List_pop(junctions,(void **) &junction); */
	    /* Junction_free(&junction); */
	  } else {
	    Substring_free(&substring);
	  }
	}
	/* List_free(&substrings); -- allocated by Listpool_push */

	debug0(printf("Stage3end_new_substrings returning NULL\n"));
	Junction_list_gc(&newjunctions);
	return (T) NULL;

      } else {
	debug7(printf("Substring_new returns nmismatches %d, nmatches %d, ambp %d, amb %d over querypos %d..%d\n",
		      Substring_nmismatches_bothdiff(substring),
		      Substring_nmatches(substring),Substring_ambiguous_p(substring),
		      Substring_amb_length(substring),Substring_querystart(substring),Substring_queryend(substring)));

	debug0(printf("Substring_new returns nmismatches %d, nmatches %d, ambp %d, amb %d over querypos %d..%d\n",
		      Substring_nmismatches_bothdiff(substring),
		      Substring_nmatches(substring),Substring_ambiguous_p(substring),
		      Substring_amb_length(substring),Substring_querystart(substring),Substring_queryend(substring)));
	substrings = Listpool_push(substrings,listpool,(void *) substring);
	nmismatches_bothdiff += Substring_nmismatches_bothdiff(substring);
	nmismatches_refdiff += Substring_nmismatches_refdiff(substring);
	querylength_trimmed += Substring_match_length(substring);
      }

      /* Prepare for next iteration */
      qstart = qend;
      if (j != NULL) {
	junction = (Junction_T) List_head(j);
	if ((adj0 = Junction_adj(junction)) != 0) {
	  adj += adj0;
	  /* indel_score += indel_penalty_middle; */
	  nindels += Junction_nindels(junction);
	  if (adj0 < 0) {
	    qstart -= adj0;	/* Insertion */
	  }
	}
      }
      splice5p = false;
    }
  }

  if (qend_alts != NULL) {
    substrings = Listpool_push(substrings,listpool,(void *) Substring_copy(qend_alts));
    newjunctions = List_reverse(newjunctions);
    donor_prob = Substring_alt_donor_prob(qend_alts);
    acceptor_prob = Substring_alt_acceptor_prob(qend_alts);
    junction = Junction_new_ambig_splice(try_sensedir,donor_prob,acceptor_prob);
    /* printf("Creating junction with donor_prob %f and acceptor_prob %f\n",donor_prob,acceptor_prob); */
    newjunctions = Listpool_push(newjunctions,listpool,(void *) junction);
    newjunctions = List_reverse(newjunctions);
  }

#ifdef DEBUG0
  printf("NEW JUNCTIONS\n");
  for (p = newjunctions; p != NULL; p = List_next(p)) {
    Junction_print(List_head(p));
  }
  printf("\n");
#endif


  if (plusp == true) {
    substring1 = List_last_value(substrings,NULL);
    substringN = List_head(substrings);
  } else {
    substring1 = List_head(substrings);
    substringN = List_last_value(substrings,NULL);
  }

  debug0(printf("Trimmed: %d..%d\n",
		Substring_querystart_trimmed(substring1),Substring_queryend_trimmed(substringN)));

  passp = true;
  if (Substring_chrnum(substring1) != Substring_chrnum(substringN)) {
    debug0(printf("ABORTING BECAUSE SUBSTRINGS HAVE DIFFERENT CHRNUMS: %d AND %d\n",
		  Substring_chrnum(substring1),Substring_chrnum(substringN)));
    passp = false;

  } else if (circularp[chrnum] == true && plusp == true && Substring_alignend_trim(substringN) - Substring_alignstart_trim(substring1) >= chrlength) {
    debug0(printf("ABORTING BECAUSE CIRCULAR CHROMOSOME CHRLENGTH %u AND ALIGNMENT %u..%u\n",
		  chrlength,Substring_alignstart_trim(substring1),Substring_alignend_trim(substringN)));
    passp = false;

  } else if (circularp[chrnum] == true && plusp == false && Substring_alignstart_trim(substring1) - Substring_alignend_trim(substringN) >= chrlength) {
    debug0(printf("ABORTING BECAUSE CIRCULAR CHROMOSOME CHRLENGTH %u AND ALIGNMENT %u..%u\n",
		  chrlength,Substring_alignstart_trim(substring1),Substring_alignend_trim(substringN)));
    passp = false;

  } else if ((queryspan = Substring_queryend(substringN) - Substring_querystart(substring1)) == querylength) {
    /* Allow short queries to match completely */

#if 0
  } else if (queryspan < MIN_ALIGNMENT_LEN) {
    debug0(printf("ABORTING BECAUSE QUERYSPAN %d < MIN_ALIGNMENT_LEN %d\n",
		  queryspan,MIN_ALIGNMENT_LEN));
    passp = false;
#endif

  }


  if (passp == false) {
    for (p = substrings; p != NULL; p = List_next(p)) {
      substring = (Substring_T) List_head(p);
      if (substring == qstart_alts || substring == qend_alts) {
	/* qstart_alts and qend_alts freed by calling procedure */
      } else {
	Substring_free(&substring);
      }
    }
    /* List_free(&substrings); -- allocated by Listpool_push */

    debug0(printf("Stage3end_new_substrings returning NULL\n"));
    Junction_list_gc(&newjunctions);
    return (T) NULL;
  }


  new = (T) MALLOC_OUT(sizeof(*new));
  new->hittype = SUBSTRINGS;
  new->distant_splice_i = -1;	/* new->distant_splice_p = false; */
  new->method = method;
  new->level = level;

  new->transcripts_consistent = (List_T) NULL;
  new->transcripts_inconsistent = (List_T) NULL;

  /* Note differences between substrings and junctions.  Substrings
     were pushed onto lists above, and junctions were created by the
     caller, so they are originally in opposite orders */
  substrings_HtoL = substrings;
  substrings_LtoH = List_reverse(Listpool_copy(substrings,listpool));
  junctions_LtoH = newjunctions;

  if (plusp == true) {
    new->substrings_1toN = substrings_LtoH;
    new->substrings_Nto1 = substrings_HtoL;

    new->junctions_1toN = junctions_LtoH;
    new->junctions_Nto1 = List_reverse(Listpool_copy(junctions_LtoH,listpool));

  } else {
    new->substrings_1toN = substrings_HtoL;
    new->substrings_Nto1 = substrings_LtoH;

    new->junctions_1toN = List_reverse(Listpool_copy(junctions_LtoH,listpool));
    new->junctions_Nto1 = junctions_LtoH;
  }

  new->substring_donor = (Substring_T) NULL;
  new->substring_acceptor = (Substring_T) NULL;

#ifdef DEBUG0
  printf("NEW SUBSTRINGS\n");
  for (p = new->substrings_1toN; p != NULL; p = List_next(p)) {
    substring = List_head(p);
    if (Substring_has_alts_p(substring) == true) {
      printf("%d..%d\t#%d\talts\tmatches_to_trims: %d\tamb:%d\t%d common_prob:%f sensedir:%d alts:",
	     Substring_querystart(substring),Substring_queryend(substring),Substring_chrnum(substring),
	     Substring_nmatches_to_trims(substring),Substring_amb_length(substring),
	     Substring_alts_ncoords(substring),Substring_alts_common_prob(substring),
	     Substring_sensedir(substring));
      Substring_print_alts_coords(substring);
      printf("\n");

    } else if (Substring_ambiguous_p(substring) == true) {
      printf("%d..%d\t#%d\t%u..%u\tambig\tmismatches:%d\tmatches_to_trims:%d\tamb:%d\tprobs:%f and %f\tsensedir:%d\n",
	     Substring_querystart(substring),Substring_queryend(substring),Substring_chrnum(substring),
	     Substring_alignstart_trim_chr(substring),Substring_alignend_trim_chr(substring),
	     Substring_nmismatches_bothdiff(substring),Substring_nmatches_to_trims(substring),Substring_amb_length(substring),
	     Substring_alt_donor_prob(substring),Substring_alt_acceptor_prob(substring),
	     Substring_sensedir(substring));
    } else {
      printf("%d..%d\t#%d\t%u..%u\tmismatches:%d\tmatches_to_trims:%d\tamb:%d\tsensedir:%d\n",
	     Substring_querystart(substring),Substring_queryend(substring),Substring_chrnum(substring),
	     Substring_alignstart_trim_chr(substring),Substring_alignend_trim_chr(substring),
	     Substring_nmismatches_bothdiff(substring),Substring_nmatches_to_trims(substring),
	     Substring_amb_length(substring),Substring_sensedir(substring));
    }
  }
  printf("\n");
#endif
  
  new->guided_insertlength = 0U;

  new->shortdistancep = true;
  new->chrnum = new->effective_chrnum = chrnum;
  new->other_chrnum = 0;
  new->chroffset = chroffset;
  new->chrhigh = chrhigh;
  new->chrlength = chrlength;
  new->plusp = plusp;
  new->genestrand = genestrand;

  new->querylength = querylength;
  compute_ends(new,first_read_p);

  if (allow_softclipped_p == false) {
    if (new->querystart_trimmed > 0) {
      Stage3end_free(&new);
      return (Stage3end_T) NULL;
    } else if (new->queryend_trimmed < querylength) {
      Stage3end_free(&new);
      return (Stage3end_T) NULL;
    }
  }

  assert(try_sensedir != SENSE_NULL);
  if (try_sensedir != SENSE_NULL) {
    debug0(printf("try_sensedir is %d (original)\n",try_sensedir));
    /* Check to see if sensedir should be converted to NULL */
    sensep = antisensep = false;

    for (p = new->substrings_1toN; p != NULL; p = List_next(p)) {
      substring = (Substring_T) List_head(p);
      debug0(printf("substring has sensedir %d\n",Substring_sensedir(substring)));
      if (Substring_sensedir(substring) == SENSE_FORWARD) {
	sensep = true;
      } else if (Substring_sensedir(substring) == SENSE_ANTI) {
	antisensep = true;
      }
    }

    for (p = new->junctions_1toN; p != NULL; p = List_next(p)) {
      junction = (Junction_T) List_head(p);
      debug0(printf("junction has sensedir %d\n",Junction_sensedir(junction)));
      if (Junction_sensedir(junction) == SENSE_FORWARD) {
	sensep = true;
      } else if (Junction_sensedir(junction) == SENSE_ANTI) {
	antisensep = true;
      }
    }

    if (sensep == true && antisensep == false) {
      new->sensedir = SENSE_FORWARD;
    } else if (sensep == false && antisensep == true) {
      new->sensedir = SENSE_ANTI;
    } else {
      debug0(printf("Stage3end_new_substrings setting sensedir to be NULL\n"));
      new->sensedir = SENSE_NULL;
    }

  } else {
    /* Check to see if sensedir can be assigned */
    new->sensedir = SENSE_NULL;
    contradictionp = false;
    for (p = new->substrings_1toN; p != NULL; p = List_next(p)) {
      substring = (Substring_T) List_head(p);
      debug0(printf("substring has sensedir %d\n",Substring_sensedir(substring)));
      if (Substring_sensedir(substring) == SENSE_NULL) {
	/* Ignore */
      } else if (new_sensedir == SENSE_NULL) {
	new_sensedir = Substring_sensedir(substring);
      } else if (Substring_sensedir(substring) != new_sensedir) {
	contradictionp = true;
      }
    }
  
    for (p = new->junctions_1toN; p != NULL; p = List_next(p)) {
      junction = (Junction_T) List_head(p);
      debug0(printf("junction has sensedir %d\n",Junction_sensedir(junction)));
      if (Junction_sensedir(junction) == SENSE_NULL) {
	/* Ignore.  Probably an indel. */
      } else if (new_sensedir == SENSE_NULL) {
	new_sensedir = Junction_sensedir(junction);
      } else if (Junction_sensedir(junction) != new_sensedir) {
	contradictionp = true;
      }
    }

    if (contradictionp == true) {
      debug0(printf("CONTRADICTION IN SENSEDIR\n"));
      new->sensedir = SENSE_NULL;
    } else {
      debug0(printf("sensedir is %d\n",new_sensedir));
      new->sensedir = new_sensedir;
    }
  }
  new->sensedir_for_concordance = new->sensedir;

  prob_total = 0.0;
  nsites = 0;
  if (splice5p_in == true) {
    prob_total += ambig_prob_5;
    nsites++;
  }
  if (splice3p_in == true) {
    prob_total += ambig_prob_3;
    nsites++;
  }

  new->nsplices = 0;
  for (p = newjunctions; p != NULL; p = List_next(p)) {
    junction = (Junction_T) List_head(p);
    if (Junction_type(junction) == SPLICE_JUNCTION) {
      prob_total += Junction_splice_score(junction);
      nsites += 2;
      new->nsplices += 1;
    }
  }
  if (nsites == 0) {
    new->splice_score = 0.0;
  } else {
    new->splice_score = prob_total / (double) nsites;
  }
  debug0(printf("SPLICE SCORE: %f\n",new->splice_score));


  nindelbreaks = 0;
  n_large_indels = 0;
  for (p = newjunctions; p != NULL; p = List_next(p)) {
    junction = (Junction_T) List_head(p);
    /* CHIMERA_JUNCTION not possible */
    if (Junction_type(junction) == INS_JUNCTION) {
      nindelbreaks++;
      if (Junction_nindels(junction) > 6) {
	n_large_indels++;
      }
    } else if (Junction_type(junction) == DEL_JUNCTION) {
      nindelbreaks++;
      if (Junction_nindels(junction) > 6) {
	n_large_indels++;
      }
    }
  }


  /* nmismatches_bothdiff is computed after trimming */
  new->nindels = nindels;
  new->nmismatches_bothdiff = nmismatches_bothdiff; /* Trimmed */
  new->nmismatches_refdiff = nmismatches_refdiff;
  new->nsegments = List_length(new->substrings_1toN);

  compute_scores(new);

  /* found_score_overall does not compensate for spliced ends, so gives motivation to find distant splicing */
  if (new->refalt_score_overall < *found_score_overall) {
    *found_score_overall = new->refalt_score_overall;
  }
  /* found_score_within_trims does compensate for spliced trims, and guides how much further alignment is necessary */
  if (new->refalt_score_within_trims < *found_score_within_trims) {
    *found_score_within_trims = new->refalt_score_within_trims;
  }


  /* new->penalties = 0; */

  /* new->gene_overlap = NO_KNOWN_GENE; -- initialized later when resolving multimappers */
  /* new->tally = -1L; */

  new->paired_usedp = false;

  /* new->query_splicepos = -1; */
  new->circularpos = compute_circularpos(&new->circularalias,new);
  debug0(printf("Circularalias is %d\n",new->circularalias));

  debug0(printf("%d substrings\n",List_length(new->substrings_1toN)));
  debug0(printf("%d junctions\n",List_length(new->junctions_1toN)));
  assert(List_length(new->substrings_1toN) == List_length(new->junctions_1toN) + 1);


  /* Previously checked for (new->circularalias == +2 || new->circularalias == -2) */

  debug7(printf("Stage3end_new_substrings returning %d matches_plus_spliced_trims\n",
		new->refalt_nmatches_plus_spliced_trims));

#ifdef DEBUG0
  for (p = new->substrings_1toN; p != NULL; p = List_next(p)) {
    substring = (Substring_T) List_head(p);
    printf("Substring nmatches_to_trims (ambp %d): %d\n",
	   Substring_ambiguous_p(substring),Substring_nmatches_to_trims(substring));
  }
#endif

  if (new->circularpos >= 0) {
    new->altlocp = false;
    debug0(printf("*****Method %s: Stage3end_new_substrings returning circular %p from Stage3end_new_substrings with score %d within trims, %d overall (found_score %d), nmatches %d, sensedir %d, splice score %f\n\n",
		  Method_string(method),new,new->refalt_score_within_trims,new->refalt_score_overall,*found_score_within_trims,
		  new->refalt_nmatches_plus_spliced_trims,new->sensedir,new->splice_score));
    debug0(printf("score refalt_score_overall %d\n",new->refalt_score_overall));
    debug0(printf("score refalt_score_within_trims %d\n",new->refalt_score_within_trims));
    debug0(printf("score refalt_nmatches_plus_spliced_trims %d\n",new->refalt_nmatches_plus_spliced_trims));
    return new;
    
  } else if ((new->altlocp = altlocp[chrnum]) == false) {
    debug0(printf("*****Method %s: Stage3end_new_substrings returning primary %p from Stage3end_new_substrings with score %d within trims, %d overall (found_score %d), nmatches %d, sensedir %d, splice score %f\n\n",
		  Method_string(method),new,new->refalt_score_within_trims,new->refalt_score_overall,*found_score_within_trims,
		  new->refalt_nmatches_plus_spliced_trims,new->sensedir,new->splice_score));
    debug0(printf("score refalt_score_overall %d\n",new->refalt_score_overall));
    debug0(printf("score refalt_score_within_trims %d\n",new->refalt_score_within_trims));
    debug0(printf("score refalt_nmatches_plus_spliced_trims %d\n",new->refalt_nmatches_plus_spliced_trims));
    return new;

  } else {
    debug0(printf("*****Method %s: Stage3end_new_substrings returning altloc %p from Stage3end_new_substrings with score %d within trims, %d overall (found_score %d), nmatches %d, sensedir %d, splice score %f\n\n",
		  Method_string(method),new,new->refalt_score_within_trims,new->refalt_score_overall,*found_score_within_trims,
		  new->refalt_nmatches_plus_spliced_trims,new->sensedir,new->splice_score));
    debug0(printf("score refalt_score_overall %d\n",new->refalt_score_overall));
    debug0(printf("score refalt_score_within_trims %d\n",new->refalt_score_within_trims));
    debug0(printf("score refalt_nmatches_plus_spliced_trims %d\n",new->refalt_nmatches_plus_spliced_trims));
    return new;
  }
}


#define add_bounded(x,plusterm,highbound) ((x + (plusterm) >= highbound) ? (highbound - 1) : x + (plusterm))
#define subtract_bounded(x,minusterm,lowbound) ((x < lowbound + (minusterm)) ? lowbound : x - (minusterm))


T
Stage3end_new_substitution (int *found_score_overall, int *found_score_within_trims,
			    Univcoord_T univdiagonal, int pos5, int pos3, int querylength,
			    int *mismatch_positions_alloc, Spliceinfo_T spliceinfo, Compress_T query_compress,
			    bool plusp, int genestrand, bool first_read_p, int try_sensedir, int nmismatches_allowed,
			    Chrnum_T chrnum, Univcoord_T chroffset, Univcoord_T chrhigh,
			    Chrpos_T chrlength, Listpool_T listpool, Method_T method, int level) {
  T new;
  Univcoord_T left;
  Substring_T substring;
  int qstart, qend, nmismatches, ref_nmismatches;
  bool splice_querystart_p, splice_queryend_p;
  int sensedir, found_sensedir;
  Splicetype_T splicetype_querystart, splicetype_queryend;
  double ambig_prob_querystart, ambig_prob_queryend;


  debug0(printf("Entered Stage3end_new_substitution, method %s, try_sensedir %d at univdiagonal %u [%u] and chrhigh %u\n",
		Method_string(method),try_sensedir,univdiagonal,univdiagonal - chroffset,chrhigh));

  left = univdiagonal - (Univcoord_T) querylength;

  if (plusp == true) {
    splice_querystart_p = Substring_qstart_trim(&qstart,&splicetype_querystart,&ambig_prob_querystart,spliceinfo,
						&found_sensedir,try_sensedir,univdiagonal,pos3,querylength,plusp,genestrand,
						mismatch_positions_alloc,query_compress,genomebits,genomebits_alt,chroffset,
						novelsplicingp);
    splice_queryend_p = Substring_qend_trim(&qend,&splicetype_queryend,&ambig_prob_queryend,spliceinfo,
					    &found_sensedir,try_sensedir,univdiagonal,pos5,querylength,plusp,genestrand,
					    mismatch_positions_alloc,query_compress,genomebits,genomebits_alt,chroffset,chrhigh,
					    novelsplicingp);

    if (splice_querystart_p == false && splice_queryend_p == false) {
      debug0(printf("Setting sensedir to be SENSE_NULL\n"));
      sensedir = SENSE_NULL;
    } else {
      sensedir = try_sensedir;
    }

    debug0(printf("Trimming querystart yields splicep %d, qstart %d, prob %f\n",splice_querystart_p,qstart,ambig_prob_querystart));
    debug0(printf("Trimming queryend yields splicep %d, qend %d, prob %f\n",splice_queryend_p,qend,ambig_prob_queryend));

    if (qstart < 0 || qend < 0) {
      debug0(printf("Returning NULL\n"));
      return (T) NULL;

    } else if (qend <= qstart) {
      /* Otherwise, calling Genome_count_mismatches_substring will not be defined */
      debug0(printf("Returning NULL\n"));
      return (T) NULL;

    } else {
      nmismatches = Genome_count_mismatches_substring(&ref_nmismatches,genomebits,genomebits_alt,query_compress,left,
						      /*pos5*/qstart,/*pos3*/qend,/*plusp*/true,genestrand);
      if (nmismatches > nmismatches_allowed) {
	debug0(printf("Returning NULL\n"));
	return (T) NULL;

      } else if ((substring = Substring_new(nmismatches,ref_nmismatches,left,/*querystart*/qstart,/*queryend*/qend,
					    querylength,/*plusp*/true,genestrand,query_compress,genomebits,genomebits_alt,
					    chrnum,chroffset,chrhigh,chrlength,
					    splice_querystart_p,splicetype_querystart,ambig_prob_querystart,
					    splice_queryend_p,splicetype_queryend,ambig_prob_queryend,
					    sensedir)) == NULL) {
	debug0(printf("Returning NULL\n"));
	return (T) NULL;
      }
    }

  } else {
    /* querystart_trimmed and queryend_trimmed Genome_count_mismatches_substring are flipped, but not for Substring_new */
    splice_querystart_p = Substring_qend_trim(&qend,&splicetype_querystart,&ambig_prob_querystart,spliceinfo,
					      &found_sensedir,try_sensedir,
					      univdiagonal,pos5,querylength,plusp,genestrand,
					      mismatch_positions_alloc,query_compress,genomebits,genomebits_alt,
					      chroffset,chrhigh,novelsplicingp);
    splice_queryend_p = Substring_qstart_trim(&qstart,&splicetype_queryend,&ambig_prob_queryend,spliceinfo,
					      &found_sensedir,try_sensedir,
					      univdiagonal,pos3,querylength,plusp,genestrand,
					      mismatch_positions_alloc,query_compress,genomebits,genomebits_alt,
					      chroffset,novelsplicingp);

    debug0(printf("Trimming querystart yields splicep %d, qstart %d, prob %f\n",splice_querystart_p,qstart,ambig_prob_querystart));
    debug0(printf("Trimming queryend yields splicep %d, qend %d, prob %f\n",splice_queryend_p,qend,ambig_prob_queryend));

    if (splice_querystart_p == false && splice_queryend_p == false) {
      debug0(printf("Setting sensedir to be SENSE_NULL\n"));
      sensedir = SENSE_NULL;
    } else {
      sensedir = try_sensedir;
    }

    if (qstart < 0 || qend < 0) {
      debug0(printf("Returning NULL\n"));
      return (T) NULL;

    } else if (qend <= qstart) {
      /* Otherwise, calling Genome_count_mismatches_substring will not be defined */
      debug0(printf("Returning NULL\n"));
      return (T) NULL;

    } else {
      nmismatches = Genome_count_mismatches_substring(&ref_nmismatches,genomebits,genomebits_alt,query_compress,left,
						      /*pos5*/qstart,/*pos3*/qend,/*plusp*/false,genestrand);

      if (nmismatches > nmismatches_allowed) {
	debug0(printf("Returning NULL\n"));
	return (T) NULL;

      } else if ((substring = Substring_new(nmismatches,ref_nmismatches,left,/*querystart*/querylength - qend,/*queryend*/querylength - qstart,
					    querylength,/*plusp*/false,genestrand,query_compress,genomebits,genomebits_alt,
					    chrnum,chroffset,chrhigh,chrlength,
					    splice_querystart_p,splicetype_querystart,ambig_prob_querystart,
					    splice_queryend_p,splicetype_queryend,ambig_prob_queryend,
					    sensedir)) == NULL) {
	debug0(printf("Returning NULL\n"));
	return (T) NULL;
      }
    }
  }

  new = (T) MALLOC_OUT(sizeof(*new));
  debug0(printf("Stage3end_new_substitution %p: univdiagonal %llu, chrnum %d, nmismatches %d\n",
		new,(unsigned long long) univdiagonal,Substring_chrnum(substring),nmismatches));
  
  new->transcripts_consistent = (List_T) NULL;
  new->transcripts_inconsistent = (List_T) NULL;

  new->substrings_1toN = Listpool_push(NULL,listpool,(void *) substring);
  new->substrings_Nto1 = Listpool_push(NULL,listpool,(void *) substring);
  new->substring_donor = (Substring_T) NULL;
  new->substring_acceptor = (Substring_T) NULL;
  
  new->junctions_1toN = (List_T) NULL;
  new->junctions_Nto1 = (List_T) NULL;
  
  new->guided_insertlength = 0U;
  
  /* Note: It is possible that Substring_new has assigned a new chrnum, different from the one given */
  new->shortdistancep = true;
  new->chrnum = new->effective_chrnum = Substring_chrnum(substring);
  new->other_chrnum = 0;
  new->chroffset = Substring_chroffset(substring);
  new->chrhigh = Substring_chrhigh(substring);
  new->chrlength = Substring_chrlength(substring);
  new->plusp = plusp;
  new->genestrand = genestrand;

  new->querylength = querylength;
  compute_ends(new,first_read_p);

  if (allow_softclipped_p == false) {
    if (new->querystart_trimmed > 0) {
      Stage3end_free(&new);
      return (Stage3end_T) NULL;
    } else if (new->queryend_trimmed < querylength) {
      Stage3end_free(&new);
      return (Stage3end_T) NULL;
    }
  }

#if 0
  if (nmismatches == 0) {
    /* Proper hittype needed so we can eliminate identical hits */
    new->hittype = EXACT;
  } else {
    new->hittype = SUB;
  }
#else
  new->hittype = SUB;
#endif
  new->distant_splice_i = -1;	/* new->distant_splice_p = false; */
  new->method = method;
  new->level = level;
  
  
  new->sensedir_for_concordance = new->sensedir = sensedir;
  
#if 0
  new->mapq_loglik = Substring_mapq_loglik(substring);
  new->mapq_score = 0;
  new->absmq_score = 0;
#endif
  
  new->nindels = 0;
  new->nmismatches_bothdiff = Substring_nmismatches_bothdiff(substring);
  new->nmismatches_refdiff = Substring_nmismatches_refdiff(substring);
  new->nsegments = 1;
  
  compute_scores(new);
  
  /* found_score_overall does not compensate for spliced ends, so gives motivation to find distant splicing */
  if (new->refalt_score_overall < *found_score_overall) {
    *found_score_overall = new->refalt_score_overall;
  }
  /* found_score_within_trims does compensate for spliced trims, and guides how much further alignment is necessary */
  if (new->refalt_score_within_trims < *found_score_within_trims) {
    *found_score_within_trims = new->refalt_score_within_trims;
  }
  
  
  /* new->penalties = 0; */
  
  /* new->gene_overlap = NO_KNOWN_GENE; -- initialized later when resolving multimappers */
  /* new->tally = -1L; */
  
  new->nsplices = 0;
  if (splice_querystart_p == true && splice_queryend_p == true) {
    new->splice_score = (ambig_prob_querystart + ambig_prob_queryend)/2.0;
  } else if (splice_querystart_p == true) {
    new->splice_score = ambig_prob_querystart;
  } else if (splice_queryend_p == true) {
    new->splice_score = ambig_prob_queryend;
  } else {
    new->splice_score = 0.0;
  }
  
  new->paired_usedp = false;
  
  /* new->query_splicepos = -1; */
  new->circularpos = compute_circularpos(&new->circularalias,new);
  debug0(printf("Circularalias is %d\n",new->circularalias));
  
  debug0(printf("*****Method %s: Stage3end_new_substitution returning %p at %u..%u with nmatches_to_trims %d and amb length %d+%d\n\n",
		Method_string(method),new,new->genomicstart - chroffset,new->genomicend - chroffset,new->ref_nmatches_to_trims,
		start_amb_length(new),end_amb_length(new)));
  debug0(printf("score refalt_score_overall %d\n",new->refalt_score_overall));
  debug0(printf("score refalt_score_within_trims %d\n",new->refalt_score_within_trims));
  debug0(printf("score refalt_nmatches_plus_spliced_trims %d\n",new->refalt_nmatches_plus_spliced_trims));
  
  /* Previously checked for (new->circularalias == +2 || new->circularalias == -2) */
  
  if (new->circularpos >= 0) {
    new->altlocp = false;
    return new;
    
  } else if ((new->altlocp = altlocp[chrnum]) == false) {
    return new;
    
  } else {
    return new;
  }
}



/* Previously allowed donor or acceptor to be NULL, when we performed Splice_group_by_segment */
/* Previously new->substring1 was donor and new->substring2 was acceptor */
/* TODO: Modify a Stage3end_new_splice to take two Stage3end_T parts, somewhat like a Stage3pair_T */
T
Stage3end_new_splice (int *found_score_overall, int *found_score_within_trims,
		      Substring_T donor, Substring_T acceptor,
		      Chrpos_T distance, bool shortdistancep, int querylength,
		      bool copy_donor_p, bool copy_acceptor_p, bool first_read_p, int orig_sensedir,
		      Listpool_T listpool, Method_T method, int level) {
  T new;
  Substring_T substring_for_concordance; /* always the inner substring */
  Substring_T substring_other;		 /* the outer substring */
  Substring_T substring1, substringN;
  Junction_T junction;
  double donor_prob, acceptor_prob;

#ifdef DEBUG0
  Substring_T substring;
  List_T p;
#endif


  if (Substring_nmatches_to_trims(donor) < 15 || 
      Substring_nmatches_to_trims(acceptor) < 15) {
    /* Not enough evidence to find each end of the translocation */
    return (T) NULL;
  } else {
    new = (T) MALLOC_OUT(sizeof(*new));
  }

  donor_prob = Substring_siteD_prob(donor);
  acceptor_prob = Substring_siteA_prob(acceptor);

  debug0(printf("Stage3end_new_splice, method %s: %p with first_read_p %d, sensedir %d, donor substring %p and acceptor substring %p, donor_prob %f and acceptor_prob %f\n",
		Method_string(method),new,first_read_p,orig_sensedir,donor,acceptor,donor_prob,acceptor_prob));

#if 0
  assert(Substring_match_length_orig(donor) + Substring_match_length_orig(acceptor) + amb_length == querylength);
#endif

  new->nindels = 0;

  new->transcripts_consistent = (List_T) NULL;
  new->transcripts_inconsistent = (List_T) NULL;

  new->splice_score = donor_prob + acceptor_prob;

  new->method = method;
  new->level = level;

  if (shortdistancep == true) {
    new->hittype = SPLICE;
    new->distant_splice_i = -1;	/* new->distant_splice_p = false; */
    new->genestrand = Substring_genestrand(donor);
    new->chrnum = Substring_chrnum(donor);
    new->chroffset = Substring_chroffset(donor);
    new->chrhigh = Substring_chrhigh(donor);
    new->chrlength = Substring_chrlength(donor);

    assert(Substring_plusp(donor) == Substring_plusp(acceptor));
    assert(SENSE_CONSISTENT_P(Substring_sensedir(donor),Substring_sensedir(acceptor)));

  } else if (Substring_chrnum(donor) == Substring_chrnum(acceptor) &&
	     Substring_plusp(donor) == Substring_plusp(acceptor) &&
	     SENSE_CONSISTENT_P(Substring_sensedir(donor),Substring_sensedir(acceptor))) {
    new->genestrand = Substring_genestrand(donor);
    new->hittype = SAMECHR_SPLICE;
    if (merge_samechr_p == true) {
      new->distant_splice_i = -1;
    } else {
      new->distant_splice_i = 0; /* new->distant_splice_p = true; */
    }
    new->chrnum = Substring_chrnum(donor);
    new->chroffset = Substring_chroffset(donor);
    new->chrhigh = Substring_chrhigh(donor);
    new->chrlength = Substring_chrlength(donor);
  } else {
    new->hittype = TRANSLOC_SPLICE;
    new->distant_splice_i = 0; /* new->distant_splice_p = true; */
    new->genestrand = 0;
    new->chrnum = 0;
    new->chroffset = 0;
    new->chrhigh = 0;
    new->chrlength = 0;
  }

  /* printf("Making splice with shortdistancep = %d, donor chrnum %d, and acceptor chrnum %d => chrnum %d\n",
     shortdistancep,Substring_chrnum(donor),Substring_chrnum(acceptor),new->chrnum); */

  new->guided_insertlength = 0U;
  new->nsegments = 2;
  new->nsplices = 1;

  /* Define substrings and junctions */
  if (new->chrnum != 0) {
    new->sensedir = orig_sensedir;
    junction = Junction_new_splice(distance,orig_sensedir,donor_prob,acceptor_prob);

  } else if (Substring_querystart(donor) < Substring_querystart(acceptor)) {
    /* Translocation, sense */
    new->sensedir = SENSE_FORWARD;
    junction = Junction_new_chimera(/*sensedir:SENSE_FORWARD,*/donor_prob,acceptor_prob);

  } else {
    /* Translocation, antisense */
    new->sensedir = SENSE_ANTI;
    junction = Junction_new_chimera(/*sensedir:SENSE_ANTI,*/donor_prob,acceptor_prob);
  }
  new->sensedir_for_concordance = new->sensedir;

  debug0(printf("donor querypos %d..%d\n",Substring_querystart(donor),Substring_queryend(donor)));
  debug0(printf("acceptor querypos %d..%d\n",Substring_querystart(acceptor),Substring_queryend(acceptor)));
  debug0(printf("sensedir %d\n",new->sensedir));


  /* new->junctions_LtoH = Listpool_push(NULL,listpool,(void *) junction); */
  /* new->junctions_HtoL = Listpool_push(NULL,listpool,(void *) junction); */
  new->junctions_1toN = Listpool_push(NULL,listpool,(void *) junction);
  new->junctions_Nto1 = Listpool_push(NULL,listpool,(void *) junction);

  donor = copy_donor_p ? Substring_copy(donor) : donor;
  acceptor = copy_acceptor_p ? Substring_copy(acceptor) : acceptor;
  new->substring_donor = donor;
  new->substring_acceptor = acceptor;

#if 0
  if (new->sensedir != SENSE_ANTI) {
    /* SENSE_FORWARD or SENSE_NULL */
    /* Order is donor (substring1), acceptor (substring2) */
    new->substrings_1toN = Listpool_push(NULL,listpool,(void *) acceptor);
    new->substrings_1toN = Listpool_push(new->substrings_1toN,listpool,(void *) donor);
    assert(Substring_queryend(donor) == Substring_querystart(acceptor));
  } else {
    /* SENSE_ANTI */
    /* Order is acceptor (substring1), donor (substring2) */
    new->substrings_1toN = Listpool_push(NULL,listpool,(void *) donor);
    new->substrings_1toN = Listpool_push(new->substrings_1toN,listpool,(void *) acceptor);
    assert(Substring_queryend(acceptor) == Substring_querystart(donor));
  }
#else
  if (Substring_queryend(donor) == Substring_querystart(acceptor)) {
    new->substrings_1toN = Listpool_push(NULL,listpool,(void *) acceptor);
    new->substrings_1toN = Listpool_push(new->substrings_1toN,listpool,(void *) donor);
  } else if (Substring_queryend(acceptor) == Substring_querystart(donor)) {
    new->substrings_1toN = Listpool_push(NULL,listpool,(void *) donor);
    new->substrings_1toN = Listpool_push(new->substrings_1toN,listpool,(void *) acceptor);
  } else {
    fprintf(stderr,"Donor and acceptor do not touch each other\n");
    abort();
  }
#endif
  /* printf("Stage3end_new_splice has siteD_pos %d, siteA_pos %d\n",
     Substring_siteD_pos(donor),Substring_siteA_pos(acceptor)); */

  new->substrings_Nto1 = List_reverse(Listpool_copy(new->substrings_1toN,listpool));
  assert(Substring_querystart(List_head(new->substrings_1toN)) < Substring_querystart(List_head(new->substrings_Nto1)));
  /* Done assigning substrings */


  substring1 = (Substring_T) List_head(new->substrings_1toN);
  substringN = (Substring_T) List_head(new->substrings_Nto1);

  new->shortdistancep = shortdistancep;
  if (new->shortdistancep == true) {
    /* Ordinary splice.  No need to distinguish effective_chrnum and other_chrnum */
    substring_for_concordance = substring_other = (Substring_T) NULL;
    new->effective_chrnum = new->chrnum;
    new->other_chrnum = 0;

    /* Define coordinates as usual */
    new->genomicstart = Substring_genomicstart(substring1);
    new->genomicend = Substring_genomicend(substringN);
    if (first_read_p == true) {
      new->plusp = Substring_plusp(substringN);
    } else {
      new->plusp = Substring_plusp(substring1);
    }

  } else {
    /* Translocation.  Concordant substring is the inner one */
    if (first_read_p == true) {
      substring_for_concordance = substringN;  /* (Substring_T) List_head(new->substrings_Nto1); */
      substring_other = substring1;  /* (Substring_T) List_head(new->substrings_1toN); */
      debug0(printf("(1) Since first read, substring for concordance is at chr %d\n",Substring_chrnum(substring_for_concordance)));
    } else {
      substring_for_concordance = substring1;  /* (Substring_T) List_head(new->substrings_1toN); */
      substring_other = substringN;  /* (Substring_T) List_head(new->substrings_Nto1); */
      debug0(printf("(1) Since second read, substring for concordance is at chr %d\n",Substring_chrnum(substring_for_concordance)));
    }
      
    new->effective_chrnum = Substring_chrnum(substring_for_concordance);
    new->other_chrnum = Substring_chrnum(substring_other);

    /* This plusp is somewhat artificial, based on substring_for_concordance,
       but it defines order of substrings_LtoH */
    new->plusp = Substring_plusp(substring_for_concordance);
  }

#ifdef DEBUG0
  printf("NEW SUBSTRINGS (query order) (2)\n");
  for (p = new->substrings_1toN; p != NULL; p = List_next(p)) {
    substring = List_head(p);
    if (Substring_ambiguous_p(substring) == true) {
      printf("%d..%d\t%d:%u..%u\tmismatches:%d\tmatches_to_trims:%d\tamb:%d\tprobs:%f and %f\tsensedir:%d\n",
	     Substring_querystart(substring),Substring_queryend(substring),Substring_chrnum(substring),
	     Substring_alignstart_trim_chr(substring),Substring_alignend_trim_chr(substring),Substring_nmismatches_bothdiff(substring),
	     Substring_nmatches_to_trims(substring),Substring_amb_length(substring),
	     Substring_alt_donor_prob(substring),Substring_alt_acceptor_prob(substring),
	     Substring_sensedir(substring));
    } else {
      printf("%d..%d\t%d:%u..%u\tmismatches:%d\tmatches_to_trims:%d\tamb:%d\tsensedir:%d\n",
	     Substring_querystart(substring),Substring_queryend(substring),Substring_chrnum(substring),
	     Substring_alignstart_trim_chr(substring),Substring_alignend_trim_chr(substring),Substring_nmismatches_bothdiff(substring),
	     Substring_nmatches_to_trims(substring),Substring_amb_length(substring),
	     Substring_sensedir(substring));
    }
  }
  printf("\n");
#endif

  new->querylength = querylength;
  compute_ends(new,first_read_p);

  if (allow_softclipped_p == false) {
    if (new->querystart_trimmed > 0) {
      Stage3end_free(&new);
      return (Stage3end_T) NULL;
    } else if (new->queryend_trimmed < querylength) {
      Stage3end_free(&new);
      return (Stage3end_T) NULL;
    }
  }

  debug0(printf("  hittype is %s, distant_splice_i %d, plusp %d, genomicpos %u..%u\n",
		hittype_string(new->hittype),new->distant_splice_i,
		new->plusp,new->genomicstart - new->chroffset,new->genomicend - new->chroffset));


  new->nmismatches_bothdiff = Substring_nmismatches_bothdiff(donor) + Substring_nmismatches_bothdiff(acceptor);
  new->nmismatches_refdiff = Substring_nmismatches_refdiff(donor) + Substring_nmismatches_refdiff(acceptor);

  compute_scores(new);

  /* found_score_overall does not compensate for spliced ends, so gives motivation to find distant splicing */
  if (new->refalt_score_overall < *found_score_overall) {
    *found_score_overall = new->refalt_score_overall;
  }
  /* found_score_within_trims does compensate for spliced trims, and guides how much further alignment is necessary */
  if (new->refalt_score_within_trims < *found_score_within_trims) {
    *found_score_within_trims = new->refalt_score_within_trims;
  }

  debug0(printf("New splice has donor %d + acceptor %d matches, sensedir %d\n",
		Substring_nmatches(donor),Substring_nmatches(acceptor),new->sensedir));

  /* new->penalties = splicing_penalty; */

  /* new->gene_overlap = NO_KNOWN_GENE; -- initialized later when resolving multimappers */
  /* new->tally = -1L; */

#if 0
  new->mapq_score = 0;
  new->absmq_score = 0;
#endif

  new->paired_usedp = false;

#if 0
  if (new->sensedir != SENSE_ANTI) {
    assert(Substring_queryend(donor) == Substring_querystart(acceptor));
    /* new->query_splicepos = Substring_queryend(donor); */
  } else {
    assert(Substring_queryend(acceptor) == Substring_querystart(donor));
    /* new->query_splicepos = Substring_queryend(acceptor); */
  }
  assert(new->query_splicepos > 0 && new->query_splicepos < querylength - 1);
#endif

  new->circularpos = compute_circularpos(&new->circularalias,new);
  debug0(printf("Circularalias is %d\n",new->circularalias));
  /* Previously checked for (new->circularalias == +2 || new->circularalias == -2) */

  if (new->circularpos >= 0) {
    new->altlocp = false;
  } else if ((new->altlocp = altlocp[new->chrnum]) == false) {
  } else {
  }
  
  debug0(printf("*****Method %s: Returning new splice %p at genomic %u..%u, donor %p (%u => %u), acceptor %p (%u => %u), score %d\n\n",
		Method_string(method),new,new->genomicstart - new->chroffset,new->genomicend - new->chroffset,donor,
		donor == NULL ? 0 : Substring_left_genomicseg(donor),
		donor == NULL ? 0 : Substring_splicecoord_D(donor),
		acceptor,acceptor == NULL ? 0 : Substring_left_genomicseg(acceptor),
		acceptor == NULL ? 0 : Substring_splicecoord_A(acceptor),new->refalt_score_within_trims));
  debug0(printf("score refalt_score_overall %d\n",new->refalt_score_overall));
  debug0(printf("score refalt_score_within_trims %d\n",new->refalt_score_within_trims));
  debug0(printf("score refalt_nmatches_plus_spliced_trims %d\n",new->refalt_nmatches_plus_spliced_trims));

  return new;
}


T
Stage3end_new_distant (int *found_score_overall, int *found_score_within_trims,
		       Substring_T startfrag, Substring_T endfrag, int splice_pos,
		       int nmismatches1, int nmismatches2,
		       double prob1, double prob2, int sensedir_distant_guess,
		       Chrpos_T distance, bool shortdistancep, int querylength,
		       bool first_read_p, Listpool_T listpool, int level) {
  T new;
  Substring_T substring_for_concordance; /* always the inner substring */
  Substring_T substring_other;		 /* the outer substring */
  Substring_T donor, acceptor;
  Junction_T junction;

#ifdef DEBUG0
  Substring_T substring;
  List_T p;
#endif

  new = (T) MALLOC_OUT(sizeof(*new));

  debug0(printf("Stage3end_new_distant: %p with first_read_p %d, shortdistancep %d, sensedir guessed to be %d\n",
		new,first_read_p,shortdistancep,sensedir_distant_guess));

  new->nindels = 0;

  new->transcripts_consistent = (List_T) NULL;
  new->transcripts_inconsistent = (List_T) NULL;

  new->splice_score = 0.0;

  new->method = DISTANT_DNA;
  new->level = level;

  debug0(printf("chrnum: %d and %d, plusp: %d and %d, sensedir: %d and %d\n",
		Substring_chrnum(startfrag),Substring_chrnum(endfrag),
		Substring_plusp(startfrag),Substring_plusp(endfrag),
		Substring_sensedir(startfrag),Substring_sensedir(endfrag)));

  new->shortdistancep = shortdistancep;
  if (shortdistancep == true) {
    new->hittype = SPLICE;
    new->distant_splice_i = -1; /* new->distant_splice_p = false; */
    new->genestrand = Substring_genestrand(startfrag);
    new->chrnum = Substring_chrnum(startfrag);
    new->chroffset = Substring_chroffset(startfrag);
    new->chrhigh = Substring_chrhigh(startfrag);
    new->chrlength = Substring_chrlength(startfrag);

    assert(Substring_plusp(startfrag) == Substring_plusp(endfrag));
    assert(SENSE_CONSISTENT_P(Substring_sensedir(startfrag),Substring_sensedir(endfrag)));

  } else {
    new->hittype = TRANSLOC_SPLICE;
    new->distant_splice_i = 0; /* new->distant_splice_p = true; */
    new->genestrand = 0;
    new->chrnum = 0;
    new->chroffset = 0;
    new->chrhigh = 0;
    new->chrlength = 0;
  }

  /* printf("Making splice with shortdistancep = %d, startfrag chrnum %d, and endfrag chrnum %d => chrnum %d\n",
     shortdistancep,Substring_chrnum(startfrag),Substring_chrnum(endfrag),new->chrnum); */

  new->guided_insertlength = 0U;
  new->nsegments = 2;
  new->nsplices = 1;

  /* Trim startfrag and endfrag at splice_pos */
  startfrag = Substring_trim_startfrag(nmismatches1,/*old*/startfrag,/*new_queryend*/splice_pos,
				       genomebits,genomebits_alt);
  endfrag = Substring_trim_endfrag(nmismatches2,/*old*/endfrag,/*new_querystart*/splice_pos,
				   genomebits,genomebits_alt);

  /* Define substrings and junctions */
  new->sensedir_for_concordance = sensedir_distant_guess; /* was SENSE_NULL */
  new->sensedir = sensedir_distant_guess;
  if (sensedir_distant_guess != SENSE_ANTI) {
    /* Order is donor (substring1), acceptor (substring2) */
    donor = startfrag;
    Substring_label_donor(donor,splice_pos,prob1,sensedir_distant_guess);

    acceptor = endfrag;
    Substring_label_acceptor(acceptor,splice_pos,prob2,sensedir_distant_guess);

    new->substrings_1toN = Listpool_push(NULL,listpool,(void *) acceptor);
    new->substrings_1toN = Listpool_push(new->substrings_1toN,listpool,(void *) donor);

  } else {
    /* Order is acceptor (substring1), donor (substring2) */
    acceptor = startfrag;
    Substring_label_acceptor(acceptor,splice_pos,prob1,sensedir_distant_guess);

    donor = endfrag;
    Substring_label_donor(donor,splice_pos,prob2,sensedir_distant_guess);

    new->substrings_1toN = Listpool_push(NULL,listpool,(void *) donor);
    new->substrings_1toN = Listpool_push(new->substrings_1toN,listpool,(void *) acceptor);
  }

  new->substring_donor = donor;
  new->substring_acceptor = acceptor;

  if (shortdistancep == true) {
    junction = Junction_new_splice(distance,sensedir_distant_guess,Substring_siteD_prob(donor),Substring_siteA_prob(acceptor));
  } else {
    junction = Junction_new_chimera(/*sensedir_distant_guess,*/Substring_siteD_prob(donor),Substring_siteA_prob(acceptor));
  }

  /* new->junctions_LtoH = Listpool_push(NULL,listpool,(void *) junction); */
  /* new->junctions_HtoL = Listpool_push(NULL,listpool,(void *) junction); */
  new->junctions_1toN = Listpool_push(NULL,listpool,(void *) junction);
  new->junctions_Nto1 = Listpool_push(NULL,listpool,(void *) junction);

  new->substrings_Nto1 = List_reverse(Listpool_copy(new->substrings_1toN,listpool));
  assert(Substring_querystart(List_head(new->substrings_1toN)) < Substring_querystart(List_head(new->substrings_Nto1)));
  /* Done assigning substrings */

  /* Translocation.  Concordant substring is the inner one */
  if (first_read_p == true) {
    substring_for_concordance = (Substring_T) List_head(new->substrings_Nto1);
    substring_other = (Substring_T) List_head(new->substrings_1toN);
    debug0(printf("(2) Since first read, substring for concordance is at chr %d\n",Substring_chrnum(substring_for_concordance)));
  } else {
    substring_for_concordance = (Substring_T) List_head(new->substrings_1toN);
    substring_other = (Substring_T) List_head(new->substrings_Nto1);
    debug0(printf("(2) Since second read, substring for concordance is at chr %d\n",Substring_chrnum(substring_for_concordance)));
  }
      
  new->effective_chrnum = Substring_chrnum(substring_for_concordance);
  new->other_chrnum = Substring_chrnum(substring_other);

  /* Define coordinates based on substring for concordance */
  new->genomicstart = Substring_genomicstart(substring_for_concordance);
  new->genomicend = Substring_genomicend(substring_for_concordance);

  /* This plusp is somewhat artificial, based on substring_for_concordance,
     but it defines order of substrings_LtoH */
  new->plusp = Substring_plusp(substring_for_concordance);
      
#ifdef DEBUG0
  printf("NEW SUBSTRINGS (query order) (3)\n");
  for (p = new->substrings_1toN; p != NULL; p = List_next(p)) {
    substring = List_head(p);
    if (Substring_ambiguous_p(substring) == true) {
      printf("%d..%d\t%d:%u..%u\tmismatches:%d\tmatches_to_trims:%d\tamb:%d\tprobs:%f and %f\tsensedir:%d\n",
	     Substring_querystart(substring),Substring_queryend(substring),Substring_chrnum(substring),
	     Substring_alignstart_trim_chr(substring),Substring_alignend_trim_chr(substring),Substring_nmismatches_bothdiff(substring),
	     Substring_nmatches_to_trims(substring),Substring_amb_length(substring),
	     Substring_alt_donor_prob(substring),Substring_alt_acceptor_prob(substring),
	     Substring_sensedir(substring));
    } else {
      printf("%d..%d\t%d:%u..%u\tmismatches:%d\tmatches_to_trims:%d\tamb:%d\tsensedir:%d\n",
	     Substring_querystart(substring),Substring_queryend(substring),Substring_chrnum(substring),
	     Substring_alignstart_trim_chr(substring),Substring_alignend_trim_chr(substring),Substring_nmismatches_bothdiff(substring),
	     Substring_nmatches_to_trims(substring),Substring_amb_length(substring),
	     Substring_sensedir(substring));
    }
  }
  printf("\n");
#endif

  new->querylength = querylength;
  compute_ends(new,first_read_p);

  if (allow_softclipped_p == false) {
    if (new->querystart_trimmed > 0) {
      Stage3end_free(&new);
      return (Stage3end_T) NULL;
    } else if (new->queryend_trimmed < querylength) {
      Stage3end_free(&new);
      return (Stage3end_T) NULL;
    }
  }

  debug0(printf("  hittype is %s, plusp %d, genomicpos %u..%u\n",
		hittype_string(new->hittype),new->plusp,new->genomicstart - new->chroffset,new->genomicend - new->chroffset));

  new->nmismatches_bothdiff = Substring_nmismatches_bothdiff(startfrag) + Substring_nmismatches_bothdiff(endfrag);
  new->nmismatches_refdiff = Substring_nmismatches_refdiff(startfrag) + Substring_nmismatches_refdiff(endfrag);

  compute_scores(new);

  /* found_score_overall does not compensate for spliced ends, so gives motivation to find distant splicing */
  if (new->refalt_score_overall < *found_score_overall) {
    *found_score_overall = new->refalt_score_overall;
  }
  /* found_score_within_trims does compensate for spliced trims, and guides how much further alignment is necessary */
  if (new->refalt_score_within_trims < *found_score_within_trims) {
    *found_score_within_trims = new->refalt_score_within_trims;
  }

  debug0(printf("New distant has startfrag %d + endfrag %d matches, sensedir %d, score %d overall and %d within trims\n",
		Substring_nmatches(startfrag),Substring_nmatches(endfrag),new->sensedir,
		new->refalt_score_overall,new->refalt_score_within_trims));

  /* new->penalties = splicing_penalty; */

  /* new->gene_overlap = NO_KNOWN_GENE; -- initialized later when resolving multimappers */
  /* new->tally = -1L; */

#if 0
  new->mapq_score = 0;
  new->absmq_score = 0;
#endif

  new->paired_usedp = false;
  /* new->query_splicepos = splice_pos; */

  new->circularpos = compute_circularpos(&new->circularalias,new);
  debug0(printf("Circularalias is %d\n",new->circularalias));
  /* Previously checked for (new->circularalias == +2 || new->circularalias == -2) */

  if (new->circularpos >= 0) {
    new->altlocp = false;
  } else if ((new->altlocp = altlocp[new->chrnum]) == false) {
  } else {
  }
  
  debug0(printf("*****Method distant: Returning new distant %p at genomic %u..%u, startfrag %p (%u => ), endfrag %p (%u => ), score %d\n\n",
		new,new->genomicstart - new->chroffset,new->genomicend - new->chroffset,
		startfrag,Substring_left_genomicseg(startfrag),endfrag,Substring_left_genomicseg(endfrag),
		new->refalt_score_within_trims));
  debug0(printf("score refalt_score_overall %d\n",new->refalt_score_overall));
  debug0(printf("score refalt_score_within_trims %d\n",new->refalt_score_within_trims));
  debug0(printf("score refalt_nmatches_plus_spliced_trims %d\n",new->refalt_nmatches_plus_spliced_trims));

  return new;
}


static int
Stage3end_output_cmp (const void *a, const void *b) {
  T x = * (T *) a;
  T y = * (T *) b;

  if (x->refalt_nmatches_plus_spliced_trims > y->refalt_nmatches_plus_spliced_trims) {
    return -1;
  } else if (y->refalt_nmatches_plus_spliced_trims > x->refalt_nmatches_plus_spliced_trims) {
    return +1;
  } else if (x->ref_nmatches_plus_spliced_trims > y->ref_nmatches_plus_spliced_trims) {
    return -1;
  } else if (y->ref_nmatches_plus_spliced_trims > x->ref_nmatches_plus_spliced_trims) {
    return +1;
  } else if (x->mapq_loglik > y->mapq_loglik) {
    return -1;
  } else if (y->mapq_loglik > x->mapq_loglik) {
    return +1;
  } else if (x->distant_splice_i < 0 && y->distant_splice_i >= 0) {
    return -1;
  } else if (y->distant_splice_i < 0 && x->distant_splice_i >= 0) {
    return +1;
  } else if (x->guided_insertlength > 0 && y->guided_insertlength == 0) {
    return -1;
  } else if (y->guided_insertlength > 0 && x->guided_insertlength == 0) {
    return +1;
  } else if (x->guided_insertlength < y->guided_insertlength) {
    return -1;
  } else if (y->guided_insertlength < x->guided_insertlength) {
    return +1;
  } else if (x->refalt_score_within_trims < y->refalt_score_within_trims) {
    return -1;
  } else if (y->refalt_score_within_trims < x->refalt_score_within_trims) {
    return +1;

    /* This genomic ordering will be undone if want_random_p is true */
  } else if (x->genomicstart < y->genomicstart) {
    return -1;
  } else if (y->genomicstart < x->genomicstart) {
    return +1;

  } else if (x->genomicend < y->genomicend) {
    return -1;
  } else if (y->genomicend < x->genomicend) {
    return +1;

  } else if (x->plusp == true && y->plusp == false) {
    return -1;
  } else if (x->plusp == false && y->plusp == true) {
    return +1;

  } else if (x->hittype < y->hittype) {
    return -1;
  } else if (y->hittype < x->hittype) {
    return +1;

  } else {
    return 0;
  }
}


static int
Stage3pair_output_cmp (const void *a, const void *b) {
  Stage3pair_T x = * (Stage3pair_T *) a;
  Stage3pair_T y = * (Stage3pair_T *) b;

#ifdef USE_BINGO
  if (x->absdifflength_bingo_p == true && y->absdifflength_bingo_p == false) {
    return -1;
  } else if (y->absdifflength_bingo_p == true && x->absdifflength_bingo_p == false) {
    return +1;
  }
#endif

  if (x->hit5->refalt_nmatches_plus_spliced_trims +
      x->hit3->refalt_nmatches_plus_spliced_trims >
      y->hit5->refalt_nmatches_plus_spliced_trims +
      y->hit3->refalt_nmatches_plus_spliced_trims) {
    return -1;
  } else if (y->hit5->refalt_nmatches_plus_spliced_trims +
	     y->hit3->refalt_nmatches_plus_spliced_trims >
	     x->hit5->refalt_nmatches_plus_spliced_trims +
	     x->hit3->refalt_nmatches_plus_spliced_trims) {
    return +1;
  } else if (x->hit5->ref_nmatches_plus_spliced_trims +
	     x->hit3->ref_nmatches_plus_spliced_trims >
	     y->hit5->ref_nmatches_plus_spliced_trims +
	     y->hit3->ref_nmatches_plus_spliced_trims) {
    return -1;
  } else if (y->hit5->ref_nmatches_plus_spliced_trims +
	     y->hit3->ref_nmatches_plus_spliced_trims >
	     x->hit5->ref_nmatches_plus_spliced_trims +
	     x->hit3->ref_nmatches_plus_spliced_trims) {
    return +1;
  } else if (x->mapq_loglik > y->mapq_loglik) {
    return -1;
  } else if (y->mapq_loglik > x->mapq_loglik) {
    return +1;
  } else if (x->insertlength > 0 && y->insertlength == 0) {
    return -1;
  } else if (y->insertlength > 0 && x->insertlength == 0) {
    return +1;
  } else if (x->insertlength < y->insertlength) {
    return -1;
  } else if (y->insertlength < x->insertlength) {
    return +1;
  } else if (x->hit5->refalt_score_within_trims +
	     x->hit3->refalt_score_within_trims <
	     y->hit5->refalt_score_within_trims +
	     y->hit3->refalt_score_within_trims) {
    return -1;
  } else if (y->hit5->refalt_score_within_trims +
	     y->hit3->refalt_score_within_trims <
	     x->hit5->refalt_score_within_trims +
	     x->hit3->refalt_score_within_trims) {
    return +1;

    /* This genomic ordering will be undone if want_random_p is true */
  } else if (x->low_chrbound < y->low_chrbound) {
    return -1;
  } else if (y->low_chrbound < x->low_chrbound) {
    return +1;

  } else if (x->high_chrbound < y->high_chrbound) {
    return -1;
  } else if (y->high_chrbound < x->high_chrbound) {
    return +1;

  } else {
    return 0;
  }
}



static float
Stage3end_compute_mapq (Stage3end_T this, char *quality_string,
			Genome_T genomebits, Genome_T genomebits_alt) {
  List_T p;
  Substring_T substring;

  if (this == NULL) {
    return 0.0;

  } else {
    this->mapq_loglik = 0.0;
    for (p = this->substrings_1toN; p != NULL; p = List_next(p)) {
      substring = (Substring_T) List_head(p);
      this->mapq_loglik += Substring_compute_mapq(substring,quality_string,genomebits,genomebits_alt);
    }
  }

  return this->mapq_loglik;
}


/* Checking for internal 'i' symbol, which would mean a splice out of an intron */
/* Note: exons are expected to be in reverse order */
static bool
exons_intron_splice_p (List_T reversed_exons) {
  List_T p;
  Exon_T exon;

  if (List_length(reversed_exons) == 1) {
    return false;
  } else {
    p = reversed_exons;

    /* First exon (which is really the last one, so check firstchar) */
    exon = (Exon_T) List_head(p);
    if (exon->firstchar == 'i') {
      debug5(printf("Exons are illegal\n"));
      return true;
    }

    /* Middle exons */
    for (p = List_next(p); List_next(p) != NULL; p = List_next(p)) {
      exon = (Exon_T) List_head(p);
      if (exon->firstchar == 'i' || exon->lastchar == 'i') {
	debug5(printf("Exons are illegal\n"));
	return true;
      }
    }
      
    /* Last exon (which is really the first one, so check lastchar) */
    exon = (Exon_T) List_head(p);
    if (exon->lastchar == 'i') {
      debug5(printf("Exons are illegal\n"));
      return true;
    }

    return false;
  }
}


/* Note: exons are expected to be in forward order */
static Bitvector_T
exons_spliced_introns (List_T exons, int nexons) {
  Bitvector_T spliced_introns;
  List_T p, q;
  Exon_T prev_exon, next_exon, exon;


  if (List_length(exons) == 1) {
    exon = (Exon_T) List_head(exons);
    if (exon->firstchar != 's' && exon->lastchar != 's') {
      return (Bitvector_T) NULL;
    } else {
      spliced_introns = Bitvector_new(/*nintrons*/nexons - 1);
      if (exon->firstchar == 's') {
	Bitvector_set(spliced_introns,/*introni*/exon->exoni - 1);
      }
      if (exon->lastchar == 's') {
	Bitvector_set(spliced_introns,/*introni*/exon->exoni);
      }
      return spliced_introns;
    }

  } else {
    spliced_introns = Bitvector_new(/*nintrons*/nexons - 1);

    p = exons;
    q = List_next(exons);
    while (q != NULL) {
      /* Really the later one, so check firstchar */
      prev_exon = (Exon_T) List_head(p);
      next_exon = (Exon_T) List_head(q);
      if (prev_exon->lastchar == 's' && next_exon->firstchar == 's') {
	Bitvector_set(spliced_introns,/*introni*/prev_exon->exoni);
      }

      p = q;
      q = List_next(q);
    }

    return spliced_introns;
  }
}


static void
remap_transcriptome (T this, Listpool_T listpool) {
  bool inconsistent_only_p;
  int *matches, index;
  int nmatches, matchi;
#ifdef DEBUG5
  char *label;
  bool alloc_label_p;
#endif
  Substring_T substring, substringA, substringZ,
    indel_chain_start, indel_chain_end;
  int querystart, queryend, querylength; /* querystart and queryend are for each indel chain */

  Junction_T prev_junction, next_junction;

  List_T pstart, qstart, pend, p, q;
  Chrpos_T exonstart, exonend, alignstart, alignend, pos;
  int trstart, trpos;
  bool overlapp, validp, consistentp;

  char firstchar, lastchar;
  List_T exons;
  Bitvector_T cryptic_introns, retained_introns, spliced_introns;
  bool utr5p, utr3p;

  int nexons, exoni;
  
  Chrpos_T *exonstarts_array;
  int *exonbounds, exonlength, trlength;

  Transcript_T transcript;

  if (transcript_map_iit == NULL) {
    return;
  } else if (this->chrnum == 0) {
    return;
  }

  if (this->method != TR) {
    /* Need to find both transcripts_consistent and transcripts_inconsistent */
    debug5(printf("remap_transcriptome called on %s alignment\n",Method_string(this->method)));
    inconsistent_only_p = false;

  } else if (this->querystart_trimmed == 0 && this->queryend_trimmed == this->querylength) {
    /* All transcripts should have been found already in kmer-search.c */
    /* Note: Still need to compute, though, in case the other read needs it for pairing */
    debug5(printf("remap_transcriptome called on a full TR alignment\n"));
#ifdef DEBUG5
    debug5(Transcript_dump_list_stdout(this->transcripts_consistent));
    debug5(Transcript_dump_list_stdout(this->transcripts_inconsistent));
#endif
    inconsistent_only_p = true;

  } else {
    /* It is possible that trimming allows for more spliced transcripts to be found, so re-compute */
    Transcript_gc(&this->transcripts_consistent);
    this->transcripts_consistent = (List_T) NULL;
    inconsistent_only_p = false;
  }

  querylength = this->querylength;

  matches = IIT_get_with_divno(&nmatches,transcript_map_iit,this->chrnum,
			       this->low_trimmed - this->chroffset + 1 /* 1-based */,
			       this->high_trimmed - this->chroffset,/*sortp*/false);

  if (this->plusp == true) {
    for (matchi = 0; matchi < nmatches; matchi++) {
      index = matches[matchi];
      nexons = Transcriptome_exons(&exonbounds,&exonstarts_array,transcriptome,/*trnum*/index);
      trlength = exonbounds[nexons - 1];
      debug5(printf("%s\n",IIT_label(transcript_map_iit,index,&alloc_label_p)));

      overlapp = false;
      trstart = -1; trpos = 0;

      exons = (List_T) NULL;
      cryptic_introns = Bitvector_new(/*nintrons*/nexons - 1);
      retained_introns = Bitvector_new(/*nintrons*/nexons - 1);
      utr5p = utr3p = false; validp = consistentp = true;

      if (IIT_interval_sign(transcript_map_iit,matches[matchi]) > 0) {
	/* Transcript is on plus strand.  Read is on plus strand.  SENSE */
	debug5(printf("Case 1\n"));
	pstart = this->substrings_1toN;
	qstart = this->junctions_1toN;
	if (Substring_has_alts_p(substringA = (Substring_T) List_head(pstart))) {
	  pstart = List_next(pstart);
	  qstart = List_next(qstart);
	  substringA = (Substring_T) List_head(pstart);
	}

	pend = (List_T) NULL;
	if (Substring_has_alts_p(substringZ = (Substring_T) List_last_value(pstart,NULL))) {
	  pend = List_last_item(pstart,NULL);
	  substringZ = (Substring_T) List_last_value(pstart,pend);
	}

	prev_junction = (Junction_T) NULL;
 	for (p = pstart, q = qstart, exoni = 0; p != pend && exoni < nexons; p = List_next(p)) {
	  substring = (Substring_T) List_head(p);
	  debug5(printf("Substring %d..%d, %u..%u\n",
			Substring_querystart(substring),Substring_queryend(substring),
			Substring_alignstart_trim_chr(substring),
			Substring_alignend_trim_chr(substring)));

	  if (q == NULL) {
	    next_junction = (Junction_T) NULL;
	  } else {
	    next_junction = (Junction_T) List_head(q);
	  }

	  if (prev_junction == NULL || Junction_adj(prev_junction) == 0) {
	    indel_chain_start = substring;
	    alignstart = Substring_alignstart_trim_chr(substring) + 1; /* 1-based */
	    querystart = Substring_querystart(substring);
	  }

	  if (next_junction == NULL || Junction_adj(next_junction) == 0) {
	    indel_chain_end = substring;
	    alignend = Substring_alignend_trim_chr(substring);
	    queryend = Substring_queryend(substring);

	    if (overlapp == false) {
	      /* exoni = 0; */
	      exonlength = exonbounds[0];
	      while (exoni < nexons && (exonend = exonstarts_array[exoni] + (Chrpos_T) exonlength - 1) < alignstart) {
		trpos += exonlength;
		debug5(printf("(1) trpos = %d.  exonend %u < alignstart %u\n",trpos,exonend,alignstart));
		exonlength = exonbounds[exoni+1] - exonbounds[exoni];
		exoni++;
	      }
	      /* exon1 = exoni; */
	    }

	    if (exoni >= nexons) {
	      /* Beyond the end of the transcript */
	      debug5(printf("Beyond end of transcript\n"));

	    } else {
	      exonstart = exonstarts_array[exoni];
	      exonend = exonstart + (Chrpos_T) exonlength - 1;

	      if (alignend < exonstart) {
		if (exoni == 0) {
		  /* Entirely in 5' UTR -- not valid */
		  debug5(printf("5' UTR: exon %u..%u, align %u..%u\n",exonstart,exonend,alignstart,alignend));
		  validp = false;

		} else {
		  /* Entirely in intron */
		  debug5(printf("Intron: exon %u..%u, align %u..%u\n",exonstart,exonend,alignstart,alignend));
		  if (overlapp == false) {trstart = trpos; overlapp = true;}
		  debug5(printf("Exon: ii\n"));
		  exons = Listpool_push(exons,listpool,Exon_new('i',/*exoni*/-1,'i'));
		  Bitvector_set(retained_introns,/*introni*/exoni - 1); consistentp = false;
		}

	      } else {
		if (alignstart < exonstart) {
		  /* Extends beyond 5' end of exon */
		  debug5(printf("Extends beyond 5': exon %u..%u, align %u..%u\n",exonstart,exonend,alignstart,alignend));
		  if (exoni == 0) {
		    firstchar = 'u'; utr5p = true; consistentp = false;
		  } else if (indel_chain_start == substringA) {
		    firstchar = 'i'; Bitvector_set(retained_introns,/*introni*/exoni - 1); consistentp = false;
		  } else {
		    firstchar = 'X'; Bitvector_set(cryptic_introns,/*introni*/exoni - 1); consistentp = false;
		  }
		  pos = exonstart;

		} else if (alignstart == exonstart) {
		  /* Matches 5' end of exon */
		  debug5(printf("Matches 5': exon %u..%u, align %u..%u\n",exonstart,exonend,alignstart,alignend));
		  if (exoni > 0 && querystart > 0) {
		    firstchar = 's';
		  } else {
		    firstchar = '.';
		  }
		  pos = exonstart;

		} else {
		  /* Starts within 5' end of exon */
		  debug5(printf("Starts with 5': exon %u..%u, align %u..%u\n",exonstart,exonend,alignstart,alignend));
		  if (exoni == 0) {
		    firstchar = '.';
		  } else if (indel_chain_start == substringA) {
		    firstchar = '.';
		  } else {
		    firstchar = 'x'; Bitvector_set(cryptic_introns,/*introni*/exoni - 1); consistentp = false;
		  }
		  trpos += alignstart - exonstart; /* Do not add +1 */
		  debug5(printf("(2) trpos = %d\n",trpos));
		  pos = alignstart;
		}

		if (overlapp == false) {
		  if (alignstart < exonstart && exoni == 0) {
		    trstart = (int) (alignstart - exonstart); /* Extend into 5' UTR */
		  } else {
		    trstart = trpos;
		  }
		  debug5(printf("trstart is %d\n",trstart));
		  overlapp = true;
		}


		if (alignend > exonend) {
		  /* Extends beyond 3' end of exon */
		  debug5(printf("Extends beyond 3': exon %u..%u, align %u..%u\n",exonstart,exonend,alignstart,alignend));
		  if (exoni == nexons - 1) {
		    lastchar = 'u'; utr3p = true; consistentp = false;
		    trpos += alignend - pos + 1; /* Extend into 3' UTR */
		  } else if (indel_chain_end == substringZ) {
		    lastchar = 'i'; Bitvector_set(retained_introns,/*introni*/exoni); consistentp = false;
		    trpos += exonend - pos + 1;
		  } else {
		    lastchar = 'X'; Bitvector_set(cryptic_introns,/*introni*/exoni); consistentp = false;
		    trpos += exonend - pos + 1;
		  }
		  debug5(printf("(3) trpos = %d\n",trpos));

		} else if (alignend == exonend) {
		  /* Matches 3' end of exon */
		  debug5(printf("Matches 3': exon %u..%u, align %u..%u\n",exonstart,exonend,alignstart,alignend));
		  if (exoni < nexons - 1 && queryend < querylength) {
		    lastchar = 's';
		  } else {
		    lastchar = '.';
		  }
		  trpos += exonend - pos + 1;
		  debug5(printf("(4) trpos = %d\n",trpos));

		} else {
		  /* Ends within 3' end of exon */
		  debug5(printf("Ends with 3': exon %u..%u, align %u..%u\n",exonstart,exonend,alignstart,alignend));
		  if (exoni == nexons - 1) {
		    lastchar = '.';
		  } else if (indel_chain_end == substringZ) {
		    lastchar = '.';
		  } else {
		    lastchar = 'x'; Bitvector_set(cryptic_introns,/*introni*/exoni); consistentp = false;
		  }
		  trpos += alignend - pos + 1;
		  debug5(printf("(5) trpos = %d\n",trpos));
		}

		debug5(printf("Exon: %c%d%c\n",firstchar,exoni+1,lastchar));
		exons = Listpool_push(exons,listpool,Exon_new(firstchar,exoni,lastchar));

		exonlength = exonbounds[exoni+1] - exonbounds[exoni]; exoni++;
	      }
	    }
	  }

	  prev_junction = next_junction;
	  if (q != NULL) {
	    q = List_next(q);
	  }
	}

	while (p != NULL) {
	  /* Ran out of exons */
#ifdef DEBUG5
	  substring = (Substring_T) List_head(p);
	  printf("Substring %d..%d, %u..%u\n",
		 Substring_querystart(substring),Substring_queryend(substring),
		 Substring_alignstart_trim_chr(substring),
		 Substring_alignend_trim_chr(substring));
#endif

	  if (q == NULL) {
	    next_junction = (Junction_T) NULL;
	  } else {
	    next_junction = (Junction_T) List_head(q);
	  }

	  if (next_junction == NULL || Junction_adj(next_junction) == 0) {
	    /* Entirely in 3' UTR -- not valid */
	    debug5(printf("3' UTR: exon %u..%u, align %u..%u\n",exonstart,exonend,alignstart,alignend));
	    validp = false;
	  }

	  prev_junction = next_junction;

	  p = List_next(p);
	  if (q != NULL) {
	    q = List_next(q);
	  }
	}

	if (exons == NULL) {
	  /* Skip */
	  Bitvector_free(&cryptic_introns); Bitvector_free(&retained_introns); 

	} else if (validp == false) {
	  Exon_list_gc(&exons);
	  Bitvector_free(&cryptic_introns); Bitvector_free(&retained_introns); 

	} else if (exons_intron_splice_p(exons) == true) {
	  Exon_list_gc(&exons);
	  Bitvector_free(&cryptic_introns); Bitvector_free(&retained_introns); 

	} else if (inconsistent_only_p == true && consistentp == true) {
	  Exon_list_gc(&exons);
	  Bitvector_free(&cryptic_introns); Bitvector_free(&retained_introns); 

	} else {
	  exons = List_reverse(exons);
	  spliced_introns = exons_spliced_introns(exons,nexons);
	  transcript = Transcript_new_with_exons(/*num*/index,/*transcript_genestrand*/+1,nexons,
						 /*start*/trstart,/*end*/trpos,trlength,
						 /*querystart*/Substring_querystart(substringA),
						 /*queryend*/Substring_queryend(substringZ),
						 querylength,exons,cryptic_introns,
						 retained_introns,spliced_introns,utr5p,utr3p); /* SENSE */
	  if (consistentp == true) {
	    debug5(printf("Pushing transcript onto transcripts_consistent\n"));
	    this->transcripts_consistent = Listpool_push(this->transcripts_consistent,listpool,(void *) transcript);
	  } else {
	    debug5(printf("Pushing transcript onto transcripts_inconsistent\n"));
	    this->transcripts_inconsistent = Listpool_push(this->transcripts_inconsistent,listpool,(void *) transcript);
	  }
	}

      } else {
	/* Transcript is on minus strand.  Read is on plus strand.  ANTISENSE */
	debug5(printf("Case 2\n"));
	pstart = this->substrings_Nto1;
	qstart = this->junctions_Nto1;
	if (Substring_has_alts_p(substringA = (Substring_T) List_head(pstart))) {
	  pstart = List_next(pstart);
	  qstart = List_next(qstart);
	  substringA = (Substring_T) List_head(pstart);
	}

	pend = (List_T) NULL;
	if (Substring_has_alts_p(substringZ = (Substring_T) List_last_value(pstart,NULL))) {
	  pend = List_last_item(pstart,NULL);
	  substringZ = (Substring_T) List_last_value(pstart,pend);
	}

	prev_junction = (Junction_T) NULL;
 	for (p = pstart, q = qstart, exoni = 0; p != pend && exoni < nexons; p = List_next(p)) {
	  substring = (Substring_T) List_head(p);
	  debug5(printf("Substring %d..%d, %u..%u\n",
			Substring_querystart(substring),Substring_queryend(substring),
			Substring_alignstart_trim_chr(substring),
			Substring_alignend_trim_chr(substring)));

	  if (q == NULL) {
	    next_junction = (Junction_T) NULL;
	  } else {
	    next_junction = (Junction_T) List_head(q);
	  }

	  if (prev_junction == NULL || Junction_adj(prev_junction) == 0) {
	    indel_chain_start = substring;
	    alignend = Substring_alignend_trim_chr(substring);
	    queryend = Substring_queryend(substring);
	  }

	  if (next_junction == NULL || Junction_adj(next_junction) == 0) {
	    indel_chain_end = substring;
	    alignstart = Substring_alignstart_trim_chr(substring) + 1; /* 1-based */
	    querystart = Substring_querystart(substring);

	    if (overlapp == false) {
	      /* exoni = 0; */
	      exonlength = exonbounds[0];
	      while (exoni < nexons && (exonend = exonstarts_array[exoni] - (Chrpos_T) exonlength + 1) > alignend) {
		trpos += exonlength;
		debug5(printf("(1) trpos = %d.  exonend %u > alignend %u\n",trpos,exonend,alignend));
		exonlength = exonbounds[exoni+1] - exonbounds[exoni];
		exoni++;
	      }
	      /* exon1 = exoni; */
	    }

	    if (exoni >= nexons) {
	      /* Beyond the end of the transcript */
	      debug5(printf("Beyond end of transcript\n"));

	    } else {
	      exonstart = exonstarts_array[exoni];
	      exonend = exonstart - (Chrpos_T) exonlength + 1;

	      if (alignstart > exonstart) {
		if (exoni == 0) {
		  /* Entirely in 5' UTR -- not valid */
		  debug5(printf("5' UTR: exon %u..%u, align %u..%u\n",exonstart,exonend,alignstart,alignend));
		  validp = false;

		} else {
		  /* Entirely in intron */
		  debug5(printf("Intron: exon %u..%u, align %u..%u\n",exonstart,exonend,alignstart,alignend));
		  if (overlapp == false) {trstart = trpos; overlapp = true;}
		  debug5(printf("Exon: ii\n"));
		  exons = Listpool_push(exons,listpool,Exon_new('i',/*exoni*/-1,'i'));
		  Bitvector_set(retained_introns,/*introni*/exoni - 1); consistentp = false;
		}

	      } else {
		if (alignend > exonstart) {
		  /* Extends beyond 5' end of exon */
		  debug5(printf("Extends beyond 5': exon %u..%u, align %u..%u\n",exonstart,exonend,alignstart,alignend));
		  if (exoni == 0) {
		    firstchar = 'u'; utr5p = true; consistentp = false;
		  } else if (indel_chain_start == substringA) {
		    firstchar = 'i'; Bitvector_set(retained_introns,/*introni*/exoni - 1); consistentp = false;
		  } else {
		    firstchar = 'X'; Bitvector_set(cryptic_introns,/*introni*/exoni - 1); consistentp = false;
		  }
		  pos = exonstart;

		} else if (alignend == exonstart) {
		  /* Matches 5' end of exon */
		  debug5(printf("Matches 5': exon %u..%u, align %u..%u\n",exonstart,exonend,alignstart,alignend));
		  if (exoni > 0 && queryend < querylength) {
		    firstchar = 's';
		  } else {
		    firstchar = '.';
		  }
		  pos = exonstart;

		} else {
		  /* Starts within 5' end of exon */
		  debug5(printf("Starts with 5': exon %u..%u, align %u..%u\n",exonstart,exonend,alignstart,alignend));
		  if (exoni == 0) {
		    firstchar = '.';
		  } else if (indel_chain_start == substringA) {
		    firstchar = '.';
		  } else {
		    firstchar = 'x'; Bitvector_set(cryptic_introns,/*introni*/exoni - 1); consistentp = false;
		  }
		  trpos += exonstart - alignend; /* Do not add +1 */
		  debug5(printf("(2) trpos = %d\n",trpos));
		  pos = alignend;
		}

		if (overlapp == false) {
		  if (alignend > exonstart && exoni == 0) {
		    trstart = (int) (exonstart - alignend); /* Extend into 5' UTR */
		  } else {
		    trstart = trpos;
		  }
		  debug5(printf("trstart is %d\n",trstart));
		  overlapp = true;
		}


		if (alignstart < exonend) {
		  /* Extends beyond 3' end of exon */
		  debug5(printf("Extends beyond 3': exon %u..%u, align %u..%u\n",exonstart,exonend,alignstart,alignend));
		  if (exoni == nexons - 1) {
		    lastchar = 'u'; utr3p = true; consistentp = false;
		    trpos += pos - alignstart + 1; /* Extend into 3' UTR */
		  } else if (indel_chain_end == substringZ) {
		    lastchar = 'i'; Bitvector_set(retained_introns,/*introni*/exoni); consistentp = false;
		    trpos += pos - exonend + 1;
		  } else {
		    lastchar = 'X'; Bitvector_set(cryptic_introns,/*introni*/exoni); consistentp = false;
		    trpos += pos - exonend + 1;
		  }
		  debug5(printf("(3) trpos = %d\n",trpos));

		} else if (alignstart == exonend) {
		  /* Matches 3' end of exon */
		  debug5(printf("Matches 3': exon %u..%u, align %u..%u\n",exonstart,exonend,alignstart,alignend));
		  if (exoni < nexons - 1 && querystart > 0) {
		    lastchar = 's';
		  } else {
		    lastchar = '.';
		  }
		  trpos += pos - exonend + 1;
		  debug5(printf("(4) trpos = %d\n",trpos));

		} else {
		  /* Ends within 3' end of exon */
		  debug5(printf("Ends with 3': exon %u..%u, align %u..%u\n",exonstart,exonend,alignstart,alignend));
		  if (exoni == nexons - 1) {
		    lastchar = '.';
		  } else if (indel_chain_end == substringZ) {
		    lastchar = '.';
		  } else {
		    lastchar = 'x'; Bitvector_set(cryptic_introns,/*introni*/exoni); consistentp = false;
		  }
		  trpos += pos - alignstart + 1;
		  debug5(printf("(5) trpos = %d\n",trpos));
		}

		debug5(printf("Exon: %c%d%c\n",firstchar,exoni+1,lastchar));
		exons = Listpool_push(exons,listpool,Exon_new(firstchar,exoni,lastchar));

		exonlength = exonbounds[exoni+1] - exonbounds[exoni]; exoni++;
	      }
	    }
	  }

	  prev_junction = next_junction;
	  if (q != NULL) {
	    q = List_next(q);
	  }
	}

	while (p != NULL) {
	  /* Ran out of exons */
#ifdef DEBUG5
	  substring = (Substring_T) List_head(p);
	  printf("Substring %d..%d, %u..%u\n",
		 Substring_querystart(substring),Substring_queryend(substring),
		 Substring_alignstart_trim_chr(substring),
		 Substring_alignend_trim_chr(substring));
#endif

	  if (q == NULL) {
	    next_junction = (Junction_T) NULL;
	  } else {
	    next_junction = (Junction_T) List_head(q);
	  }

	  if (next_junction == NULL || Junction_adj(next_junction) == 0) {
	    /* Entirely in 3' UTR -- not valid */
	    debug5(printf("3' UTR: exon %u..%u, align %u..%u\n",exonstart,exonend,alignstart,alignend));
	    validp = false;
	  }

	  prev_junction = next_junction;

	  p = List_next(p);
	  if (q != NULL) {
	    q = List_next(q);
	  }
	}

	if (exons == NULL) {
	  /* Skip */
	  Bitvector_free(&cryptic_introns); Bitvector_free(&retained_introns); 

	} else if (validp == false) {
	  Exon_list_gc(&exons);
	  Bitvector_free(&cryptic_introns); Bitvector_free(&retained_introns); 

	} else if (exons_intron_splice_p(exons) == true) {
	  Exon_list_gc(&exons);
	  Bitvector_free(&cryptic_introns); Bitvector_free(&retained_introns); 

	} else if (inconsistent_only_p == true && consistentp == true) {
	  Exon_list_gc(&exons);
	  Bitvector_free(&cryptic_introns); Bitvector_free(&retained_introns); 

	} else {
	  exons = List_reverse(exons);
	  spliced_introns = exons_spliced_introns(exons,nexons);
	  transcript = Transcript_new_with_exons(/*num*/index,/*transcript_genestrand*/-1,nexons,
						  /*start*/trpos,/*end*/trstart,trlength,
						  /*querystart*/Substring_querystart(substringZ),
						  /*queryend*/Substring_queryend(substringA),
						  querylength,exons,cryptic_introns,
						  retained_introns,spliced_introns,utr5p,utr3p); /* ANTISENSE */
	  if (consistentp == true) {
	    debug5(printf("Pushing transcript onto transcripts_consistent\n"));
	    this->transcripts_consistent = Listpool_push(this->transcripts_consistent,listpool,(void *) transcript);
	  } else {
	    debug5(printf("Pushing transcript onto transcripts_inconsistent\n"));
	    this->transcripts_inconsistent = Listpool_push(this->transcripts_inconsistent,listpool,(void *) transcript);
	  }
	}
      }
    }

  } else {
    for (matchi = 0; matchi < nmatches; matchi++) {
      index = matches[matchi];
      nexons = Transcriptome_exons(&exonbounds,&exonstarts_array,transcriptome,/*trnum*/index);
      trlength = exonbounds[nexons - 1];
      debug5(printf("%s\n",IIT_label(transcript_map_iit,index,&alloc_label_p)));

      overlapp = false;
      trstart = -1; trpos = 0;

      exons = (List_T) NULL;
      cryptic_introns = Bitvector_new(/*nintrons*/nexons - 1);
      retained_introns = Bitvector_new(/*nintrons*/nexons - 1);
      utr5p = utr3p = false; validp = consistentp = true;

      if (IIT_interval_sign(transcript_map_iit,matches[matchi]) > 0) {
	/* Transcript is on plus strand.  Read is on minus strand.  ANTISENSE */
	debug5(printf("Case 3\n"));
	pstart = this->substrings_Nto1;
	qstart = this->junctions_Nto1;
	if (Substring_has_alts_p(substringA = (Substring_T) List_head(pstart))) {
	  pstart = List_next(pstart);
	  qstart = List_next(qstart);
	  substringA = (Substring_T) List_head(pstart);
	}

	pend = (List_T) NULL;
	if (Substring_has_alts_p(substringZ = (Substring_T) List_last_value(pstart,NULL))) {
	  pend = List_last_item(pstart,NULL);
	  substringZ = (Substring_T) List_last_value(pstart,pend);
	}

	prev_junction = (Junction_T) NULL;
 	for (p = pstart, q = qstart, exoni = 0; p != pend && exoni < nexons; p = List_next(p)) {
	  substring = (Substring_T) List_head(p);
	  debug5(printf("Substring %d..%d, %u..%u\n",
			Substring_querystart(substring),Substring_queryend(substring),
			Substring_alignstart_trim_chr(substring),
			Substring_alignend_trim_chr(substring)));

	  if (q == NULL) {
	    next_junction = (Junction_T) NULL;
	  } else {
	    next_junction = (Junction_T) List_head(q);
	  }

	  if (prev_junction == NULL || Junction_adj(prev_junction) == 0) {
	    indel_chain_start = substring;
	    alignend = Substring_alignend_trim_chr(substring) + 1; /* 1-based */
	    queryend = Substring_queryend(substring);
	  }

	  if (next_junction == NULL || Junction_adj(next_junction) == 0) {
	    indel_chain_end = substring;
	    alignstart = Substring_alignstart_trim_chr(substring);
	    querystart = Substring_querystart(substring);

	    if (overlapp == false) {
	      /* exoni = 0; */
	      exonlength = exonbounds[0];
	      while (exoni < nexons && (exonend = exonstarts_array[exoni] + (Chrpos_T) exonlength - 1) < alignend) {
		trpos += exonlength;
		debug5(printf("(1) trpos = %d.  exonend %u < alignend %u\n",trpos,exonend,alignend));
		exonlength = exonbounds[exoni+1] - exonbounds[exoni];
		exoni++;
	      }
	      /* exon1 = exoni; */
	    }

	    if (exoni >= nexons) {
	      /* Beyond the end of the transcript */
	      debug5(printf("Beyond end of transcript\n"));

	    } else {
	      exonstart = exonstarts_array[exoni];
	      exonend = exonstart + (Chrpos_T) exonlength - 1;

	      if (alignstart < exonstart) {
		if (exoni == 0) {
		  /* Entirely in 5' UTR -- not valid */
		  debug5(printf("5' UTR: exon %u..%u, align %u..%u\n",exonstart,exonend,alignstart,alignend));
		  validp = false;

		} else {
		  /* Entirely in intron */
		  debug5(printf("Intron: exon %u..%u, align %u..%u\n",exonstart,exonend,alignstart,alignend));
		  if (overlapp == false) {trstart = trpos; overlapp = true;}
		  debug5(printf("Exon: ii\n"));
		  exons = Listpool_push(exons,listpool,Exon_new('i',/*exoni*/-1,'i'));
		  Bitvector_set(retained_introns,/*introni*/exoni - 1); consistentp = false;
		}

	      } else {
		if (alignend < exonstart) {
		  /* Extends beyond 5' end of exon */
		  debug5(printf("Extends beyond 5': exon %u..%u, align %u..%u\n",exonstart,exonend,alignstart,alignend));
		  if (exoni == 0) {
		    firstchar = 'u'; utr5p = true; consistentp = false;
		  } else if (indel_chain_start == substringA) {
		    firstchar = 'i'; Bitvector_set(retained_introns,/*introni*/exoni - 1); consistentp = false;
		  } else {
		    firstchar = 'X'; Bitvector_set(cryptic_introns,/*introni*/exoni - 1); consistentp = false;
		  }
		  pos = exonstart;

		} else if (alignend == exonstart) {
		  /* Matches 5' end of exon */
		  debug5(printf("Matches 5': exon %u..%u, align %u..%u\n",exonstart,exonend,alignstart,alignend));
		  if (exoni > 0 && queryend < querylength) {
		    firstchar = 's';
		  } else {
		    firstchar = '.';
		  }
		  pos = exonstart;

		} else {
		  /* Starts within 5' end of exon */
		  debug5(printf("Starts with 5': exon %u..%u, align %u..%u\n",exonstart,exonend,alignstart,alignend));
		  if (exoni == 0) {
		    firstchar = '.';
		  } else if (indel_chain_start == substringA) {
		    firstchar = '.';
		  } else {
		    firstchar = 'x'; Bitvector_set(cryptic_introns,/*introni*/exoni - 1); consistentp = false;
		  }
		  trpos += alignend - exonstart; /* Do not add +1 */
		  debug5(printf("(2) trpos = %d\n",trpos));
		  pos = alignend;
		}

		if (overlapp == false) {
		  if (alignend < exonstart && exoni == 0) {
		    trstart = (int) (alignend - exonstart); /* Extend into 5' UTR */
		  } else {
		    trstart = trpos;
		  }
		  debug5(printf("trstart is %d\n",trstart));
		  overlapp = true;
		}

		if (alignstart > exonend) {
		  /* Extends beyond 3' end of exon */
		  debug5(printf("Extends beyond 3': exon %u..%u, align %u..%u\n",exonstart,exonend,alignstart,alignend));
		  if (exoni == nexons - 1) {
		    lastchar = 'u'; utr3p = true; consistentp = false;
		    trpos += alignstart - pos + 1; /* Extend into 3' UTR */
		  } else if (indel_chain_end == substringZ) {
		    lastchar = 'i'; Bitvector_set(retained_introns,/*introni*/exoni); consistentp = false;
		    trpos += exonend - pos + 1;
		  } else {
		    lastchar = 'X'; Bitvector_set(cryptic_introns,/*introni*/exoni); consistentp = false;
		    trpos += exonend - pos + 1;
		  }
		  debug5(printf("(3) trpos = %d\n",trpos));

		} else if (alignstart == exonend) {
		  /* Matches 3' end of exon */
		  debug5(printf("Matches 3': exon %u..%u, align %u..%u\n",exonstart,exonend,alignstart,alignend));
		  if (exoni < nexons - 1 && querystart > 0) {
		    lastchar = 's';
		  } else {
		    lastchar = '.';
		  }
		  trpos += exonend - pos + 1;
		  debug5(printf("(4) trpos = %d\n",trpos));

		} else {
		  /* Ends within 3' end of exon */
		  debug5(printf("Ends with 3': exon %u..%u, align %u..%u\n",exonstart,exonend,alignstart,alignend));
		  if (exoni == nexons - 1) {
		    lastchar = '.';
		  } else if (indel_chain_end == substringZ) {
		    lastchar = '.';
		  } else {
		    lastchar = 'x'; Bitvector_set(cryptic_introns,/*introni*/exoni); consistentp = false;
		  }
		  trpos += alignstart - pos + 1;
		  debug5(printf("(5) trpos = %d\n",trpos));
		}

		debug5(printf("Exon: %c%d%c\n",firstchar,exoni+1,lastchar));
		exons = Listpool_push(exons,listpool,Exon_new(firstchar,exoni,lastchar));

		exonlength = exonbounds[exoni+1] - exonbounds[exoni]; exoni++;
	      }
	    }
	  }

	  prev_junction = next_junction;
	  if (q != NULL) {
	    q = List_next(q);
	  }
	}

	while (p != NULL) {
	  /* Ran out of exons */
#ifdef DEBUG5
	  substring = (Substring_T) List_head(p);
	  printf("Substring %d..%d, %u..%u\n",
		 Substring_querystart(substring),Substring_queryend(substring),
		 Substring_alignstart_trim_chr(substring),
		 Substring_alignend_trim_chr(substring));
#endif

	  if (q == NULL) {
	    next_junction = (Junction_T) NULL;
	  } else {
	    next_junction = (Junction_T) List_head(q);
	  }

	  if (next_junction == NULL || Junction_adj(next_junction) == 0) {
	    /* Entirely in 3' UTR -- not valid */
	    debug5(printf("3' UTR: exon %u..%u, align %u..%u\n",exonstart,exonend,alignstart,alignend));
	    validp = false;
	  }

	  prev_junction = next_junction;

	  p = List_next(p);
	  if (q != NULL) {
	    q = List_next(q);
	  }
	}

	if (exons == NULL) {
	  /* Skip */
	  Bitvector_free(&cryptic_introns); Bitvector_free(&retained_introns); 

	} else if (validp == false) {
	  Exon_list_gc(&exons);
	  Bitvector_free(&cryptic_introns); Bitvector_free(&retained_introns); 

	} else if (exons_intron_splice_p(exons) == true) {
	  Exon_list_gc(&exons);
	  Bitvector_free(&cryptic_introns); Bitvector_free(&retained_introns); 

	} else if (inconsistent_only_p == true && consistentp == true) {
	  Exon_list_gc(&exons);
	  Bitvector_free(&cryptic_introns); Bitvector_free(&retained_introns); 

	} else {
	  exons = List_reverse(exons);
	  spliced_introns = exons_spliced_introns(exons,nexons);
	  transcript = Transcript_new_with_exons(/*num*/index,/*transcript_genestrand*/+1,nexons,
						  /*start*/trpos,/*end*/trstart,trlength,
						  /*querystart*/Substring_querystart(substringZ),
						  /*queryend*/Substring_queryend(substringA),
						  querylength,exons,cryptic_introns,
						  retained_introns,spliced_introns,utr5p,utr3p); /* ANTISENSE */
	  if (consistentp == true) {
	    debug5(printf("Pushing transcript onto transcripts_consistent\n"));
	    this->transcripts_consistent = Listpool_push(this->transcripts_consistent,listpool,(void *) transcript);
	  } else {
	    debug5(printf("Pushing transcript onto transcripts_inconsistent\n"));
	    this->transcripts_inconsistent = Listpool_push(this->transcripts_inconsistent,listpool,(void *) transcript);
	  }
	}

      } else {
	/* Transcript is on minus strand.  Read is on minus strand.  SENSE */
	debug5(printf("Case 4\n"));
	pstart = this->substrings_1toN;
	qstart = this->junctions_1toN;
	if (Substring_has_alts_p(substringA = (Substring_T) List_head(pstart))) {
	  pstart = List_next(pstart);
	  qstart = List_next(qstart);
	  substringA = (Substring_T) List_head(pstart);
	}

	pend = (List_T) NULL;
	if (Substring_has_alts_p(substringZ = (Substring_T) List_last_value(pstart,NULL))) {
	  pend = List_last_item(pstart,NULL);
	  substringZ = (Substring_T) List_last_value(pstart,pend);
	}

	prev_junction = (Junction_T) NULL;
 	for (p = pstart, q = qstart, exoni = 0; p != pend && exoni < nexons; p = List_next(p)) {
	  substring = (Substring_T) List_head(p);
	  debug5(printf("Substring %d..%d, %u..%u\n",
			Substring_querystart(substring),Substring_queryend(substring),
			Substring_alignstart_trim_chr(substring),
			Substring_alignend_trim_chr(substring)));

	  if (q == NULL) {
	    next_junction = (Junction_T) NULL;
	  } else {
	    next_junction = (Junction_T) List_head(q);
	  }

	  if (prev_junction == NULL || Junction_adj(prev_junction) == 0) {
	    indel_chain_start = substring;
	    alignstart = Substring_alignstart_trim_chr(substring);
	    querystart = Substring_querystart(substring);
	  }

	  if (next_junction == NULL || Junction_adj(next_junction) == 0) {
	    indel_chain_end = substring;
	    alignend = Substring_alignend_trim_chr(substring) + 1; /* 1-based */
	    queryend = Substring_queryend(substring);

	    if (overlapp == false) {
	      /* exoni = 0; */
	      exonlength = exonbounds[0];
	      while (exoni < nexons && (exonend = exonstarts_array[exoni] - (Chrpos_T) exonlength + 1) > alignstart) {
		trpos += exonlength;
		debug5(printf("(1) trpos = %d.  exonend %u > alignstart %u\n",trpos,exonend,alignstart));
		exonlength = exonbounds[exoni+1] - exonbounds[exoni];
		exoni++;
	      }
	      /* exon1 = exoni; */
	    }

	    if (exoni >= nexons) {
	      /* Beyond the end of the transcript */
	      debug5(printf("Beyond end of transcript\n"));

	    } else {
	      exonstart = exonstarts_array[exoni];
	      exonend = exonstart - (Chrpos_T) exonlength + 1;

	      if (alignend > exonstart) {
		if (exoni == 0) {
		  /* Entirely in 5' UTR -- not valid */
		  debug5(printf("5' UTR: exon %u..%u, align %u..%u\n",exonstart,exonend,alignstart,alignend));
		  validp = false;

		} else {
		  /* Entirely in intron */
		  debug5(printf("Intron: exon %u..%u, align %u..%u\n",exonstart,exonend,alignstart,alignend));
		  if (overlapp == false) {trstart = trpos; overlapp = true;}
		  debug5(printf("Exon: ii\n"));
		  exons = Listpool_push(exons,listpool,Exon_new('i',/*exoni*/-1,'i'));
		  Bitvector_set(retained_introns,/*introni*/exoni - 1); consistentp = false;
		}

	      } else {
		if (alignstart > exonstart) {
		  /* Extends beyond 5' end of exon */
		  debug5(printf("Extends beyond 5': exon %u..%u, align %u..%u\n",exonstart,exonend,alignstart,alignend));
		  if (exoni == 0) {
		    firstchar = 'u'; utr5p = true; consistentp = false;
		  } else if (indel_chain_start == substringA) {
		    firstchar = 'i'; Bitvector_set(retained_introns,/*introni*/exoni - 1); consistentp = false;
		  } else {
		    firstchar = 'X'; Bitvector_set(cryptic_introns,/*introni*/exoni - 1); consistentp = false;
		  }
		  pos = exonstart;

		} else if (alignstart == exonstart) {
		  /* Matches 5' end of exon */
		  debug5(printf("Matches 5': exon %u..%u, align %u..%u\n",exonstart,exonend,alignstart,alignend));
		  if (exoni > 0 && querystart > 0) {
		    firstchar = 's';
		  } else {
		    firstchar = '.';
		  }
		  pos = exonstart;

		} else {
		  /* Starts within 5' end of exon */
		  debug5(printf("Starts with 5': exon %u..%u, align %u..%u\n",exonstart,exonend,alignstart,alignend));
		  if (exoni == 0) {
		    firstchar = '.';
		  } else if (indel_chain_start == substringA) {
		    firstchar = '.';
		  } else {
		    firstchar = 'x'; Bitvector_set(cryptic_introns,/*introni*/exoni - 1); consistentp = false;
		  }
		  trpos += exonstart - alignstart; /* Do not add +1 */
		  debug5(printf("(2) trpos = %d\n",trpos));
		  pos = alignstart;
		}

		if (overlapp == false) {
		  if (alignstart > exonstart && exoni == 0) {
		    trstart = (int) (exonstart - alignstart); /* Extend into 5' UTR */
		  } else {
		    trstart = trpos;
		  }
		  debug5(printf("trstart is %d\n",trstart));
		  overlapp = true;
		}

		if (alignend < exonend) {
		  /* Extends beyond 3' end of exon */
		  debug5(printf("Extends beyond 3': exon %u..%u, align %u..%u\n",exonstart,exonend,alignstart,alignend));
		  if (exoni == nexons - 1) {
		    lastchar = 'u'; utr3p = true; consistentp = false;
		    trpos += pos - alignend + 1; /* Extend into 3' UTR */
		  } else if (indel_chain_end == substringZ) {
		    lastchar = 'i'; Bitvector_set(retained_introns,/*introni*/exoni); consistentp = false;
		    trpos += pos - exonend + 1;
		  } else {
		    lastchar = 'X'; Bitvector_set(cryptic_introns,/*introni*/exoni); consistentp = false;
		    trpos += pos - exonend + 1;
		  }
		  debug5(printf("(3) trpos = %d\n",trpos));

		} else if (alignend == exonend) {
		  /* Matches 3' end of exon */
		  debug5(printf("Matches 3': exon %u..%u, align %u..%u\n",exonstart,exonend,alignstart,alignend));
		  if (exoni < nexons - 1 && queryend < querylength) {
		    lastchar = 's';
		  } else {
		    lastchar = '.';
		  }
		  trpos += pos - exonend + 1;
		  debug5(printf("(4) trpos = %d\n",trpos));

		} else {
		  /* Ends within 3' end of exon */
		  debug5(printf("Ends with 3': exon %u..%u, align %u..%u\n",exonstart,exonend,alignstart,alignend));
		  if (exoni == nexons - 1) {
		    lastchar = '.';
		  } else if (indel_chain_end == substringZ) {
		    lastchar = '.';
		  } else {
		    lastchar = 'x'; Bitvector_set(cryptic_introns,/*introni*/exoni); consistentp = false;
		  }
		  trpos += pos - alignend + 1;
		  debug5(printf("(5) trpos = %d\n",trpos));
		}

		debug5(printf("Exon: %c%d%c\n",firstchar,exoni+1,lastchar));
		exons = Listpool_push(exons,listpool,Exon_new(firstchar,exoni,lastchar));

		exonlength = exonbounds[exoni+1] - exonbounds[exoni]; exoni++;
	      }
	    }
	  }

	  prev_junction = next_junction;
	  if (q != NULL) {
	    q = List_next(q);
	  }
	}

	while (p != NULL) {
	  /* Ran out of exons */
#ifdef DEBUG5
	  substring = (Substring_T) List_head(p);
	  printf("Substring %d..%d, %u..%u\n",
		 Substring_querystart(substring),Substring_queryend(substring),
		 Substring_alignstart_trim_chr(substring),
		 Substring_alignend_trim_chr(substring));
#endif

	  if (q == NULL) {
	    next_junction = (Junction_T) NULL;
	  } else {
	    next_junction = (Junction_T) List_head(q);
	  }

	  if (next_junction == NULL || Junction_adj(next_junction) == 0) {
	    /* Entirely in 3' UTR -- not valid */
	    debug5(printf("3' UTR: exon %u..%u, align %u..%u\n",exonstart,exonend,alignstart,alignend));
	    validp = false;
	  }

	  prev_junction = next_junction;

	  p = List_next(p);
	  if (q != NULL) {
	    q = List_next(q);
	  }
	}

	if (exons == NULL) {
	  /* Skip */
	  Bitvector_free(&cryptic_introns); Bitvector_free(&retained_introns); 

	} else if (validp == false) {
	  Exon_list_gc(&exons);
	  Bitvector_free(&cryptic_introns); Bitvector_free(&retained_introns); 

	} else if (exons_intron_splice_p(exons) == true) {
	  Exon_list_gc(&exons);
	  Bitvector_free(&cryptic_introns); Bitvector_free(&retained_introns); 

	} else if (inconsistent_only_p == true && consistentp == true) {
	  Exon_list_gc(&exons);
	  Bitvector_free(&cryptic_introns); Bitvector_free(&retained_introns); 

	} else {
	  exons = List_reverse(exons);
	  spliced_introns = exons_spliced_introns(exons,nexons);
	  transcript = Transcript_new_with_exons(/*num*/index,/*transcript_genestrand*/-1,nexons,
						  /*start*/trstart,/*end*/trpos,trlength,
						  /*querystart*/Substring_querystart(substringA),
						  /*queryend*/Substring_queryend(substringZ),
						  querylength,exons,cryptic_introns,
						  retained_introns,spliced_introns,utr5p,utr3p); /* SENSE */
	  if (consistentp == true) {
	    debug5(printf("Pushing transcript onto transcripts_consistent\n"));
	    this->transcripts_consistent = Listpool_push(this->transcripts_consistent,listpool,(void *) transcript);
	  } else {
	    debug5(printf("Pushing transcript onto transcripts_inconsistent\n"));
	    this->transcripts_inconsistent = Listpool_push(this->transcripts_inconsistent,listpool,(void *) transcript);
	  }
	}
      }
    }
  }

  FREE(matches);

  this->transcripts_consistent = List_reverse(this->transcripts_consistent);
  this->transcripts_inconsistent = List_reverse(this->transcripts_inconsistent);

  return;
}


static void
Stage3end_display_prep (Stage3end_T this, Listpool_T listpool,
			char *queryuc_ptr, bool first_read_p) {
  List_T p, q;
  Substring_T substring;
  Junction_T pre_junction, post_junction;
  Junctiontype_T type;
  int extraleft, extraright;
  bool sam_print_xt_p = false;
  /* int type; */
  /* int extralow, extrahigh; */

  if (this != NULL) {
    if (output_type == SAM_OUTPUT) {
      if (this->hittype == TRANSLOC_SPLICE ||
	  (this->hittype == SAMECHR_SPLICE && merge_samechr_p == false) ||
	  this->distant_splice_i >= 0) {
	  /* This is the condition in samprint to print the XT field, which needs the splice information */
	sam_print_xt_p = true;
      }
    }

    debug0(printf("Doing a display prep of end %p\n",this));
    remap_transcriptome(this,listpool);

    this->nmismatches_refdiff = 0;

    /* First segments */
    /* For operations on substrings, proceed in 1toN order, not LtoH order */
    substring = (Substring_T) List_head(this->substrings_1toN);
    if (output_type == STD_OUTPUT) {
      extraleft = Substring_querystart(substring); /* terminal start */
    } else {
      extraleft = 0;
    }

    if (List_length(this->substrings_1toN) == 1) {
      post_junction = (Junction_T) NULL;
      if (output_type == STD_OUTPUT) {
	extraright = this->querylength - Substring_queryend(substring); /* terminal end */
      } else {
	extraright = 0;
      }
    } else {
      post_junction = (Junction_T) List_head(this->junctions_1toN);
      /* Junction_print(post_junction); */

      if (output_type == M8_OUTPUT) {
	extraright = 0;
      } else if ((type = Junction_type(post_junction)) == CHIMERA_JUNCTION || sam_print_xt_p == true) {
	extraright = 2;
      } else if (output_type == SAM_OUTPUT) {
	extraright = 0;
      } else if (type == SPLICE_JUNCTION) {
	extraright = 2;
      } else if (first_read_p == true && type == DEL_JUNCTION) {
	extraright = Junction_nindels(post_junction);
      } else {
	extraright = 0;
      }
    }
      
    if (Substring_has_alts_p(substring) == true) {
      /* Skip */
    } else {
      this->nmismatches_refdiff += 
	Substring_display_prep(substring,queryuc_ptr,this->querylength,extraleft,extraright,
			       genomebits);
    }

    assert(List_length(this->substrings_1toN) == List_length(this->junctions_1toN) + 1);
    if ((p = List_next(this->substrings_1toN)) == NULL) {
      /* No middle segments */
    } else {
      for (q = List_next(this->junctions_1toN); q != NULL; p = List_next(p), q = List_next(q)) {
	/* Middle segments */
	pre_junction = post_junction;
	post_junction = List_head(q);

	/* Junction_print(pre_junction); */
	/* Junction_print(post_junction); */

	if (output_type == M8_OUTPUT) {
	  extraleft = 0;
	} else if ((type = Junction_type(pre_junction)) == CHIMERA_JUNCTION || sam_print_xt_p == true) {
	  extraleft = 2;
	} else if (output_type == SAM_OUTPUT) {
	  extraleft = 0;
	} else if (type == SPLICE_JUNCTION) {
	  extraleft = 2;
	} else if (first_read_p == false && type == DEL_JUNCTION) {
	  extraleft = Junction_nindels(pre_junction);
	} else {
	  extraleft = 0;
	}

	if (output_type == M8_OUTPUT) {
	  extraright = 0;
	} else if ((type = Junction_type(post_junction)) == CHIMERA_JUNCTION || sam_print_xt_p == true) {
	  extraright = 2;
	} else if (output_type == SAM_OUTPUT) {
	  extraright = 0;
	} else if (type == SPLICE_JUNCTION) {
	  extraright = 2;
	} else if (first_read_p == true && type == DEL_JUNCTION) {
	  extraright = Junction_nindels(post_junction);
	} else {
	  extraright = 0;
	}

	substring = (Substring_T) List_head(p);
	if (Substring_has_alts_p(substring) == true) {
	  /* Skip */
	} else {
	  this->nmismatches_refdiff += 
	    Substring_display_prep(substring,queryuc_ptr,this->querylength,extraleft,extraright,
				   genomebits);
	}
      }

      /* Last segment */
      pre_junction = post_junction;
      /* Junction_print(pre_junction); */

      if (output_type == M8_OUTPUT) {
	extraleft = 0;
      } else if ((type = Junction_type(pre_junction)) == CHIMERA_JUNCTION || sam_print_xt_p == true) {
	extraleft = 2;
      } else if (output_type == SAM_OUTPUT) {
	extraleft = 0;
      } else if (type == SPLICE_JUNCTION) {
	extraleft = 2;
      } else if (first_read_p == false && type == DEL_JUNCTION) {
	extraleft = Junction_nindels(pre_junction);
      } else {
	extraleft = 0;
      }

      substring = (Substring_T) List_head(p);
      if (output_type == STD_OUTPUT) {
	extraright = this->querylength - Substring_queryend(substring);
      } else {
	extraright = 0;
      }
	
      if (Substring_has_alts_p(substring) == true) {
	/* Skip */
      } else {
	this->nmismatches_refdiff += 
	  Substring_display_prep(substring,queryuc_ptr,this->querylength,extraleft,extraright,
				 genomebits);
      }
    }
  }

  return;
}


List_T
Stage3end_filter (List_T hits, Hitlistpool_T hitlistpool,
		  int max_mismatches_refalt, int max_mismatches_ref, int min_coverage) {
  List_T newhits = NULL, p;
  Stage3end_T hit;

  debug1(printf("Entered Stage3end_filter with max_mismatches_refalt %d, max_mismatches_ref %d, and min_coverage %d\n",
		max_mismatches_refalt,max_mismatches_ref,min_coverage));

  if (filter_within_trims_p == false) {
    /* Generally want overall mismatches for DNA-seq, so use refalt_score_overall */
    for (p = hits; p != NULL; p = List_next(p)) {
      hit = (Stage3end_T) List_head(p);
      debug1(printf("DNA-seq %p: Comparing refalt score %d against max_mismatches_refalt %d, ref %d against %d, and coverage %d against min_coverage %d\n",
		    hit,hit->refalt_score_overall,max_mismatches_refalt,
		    hit->refalt_score_overall,max_mismatches_ref,
		    hit->queryend_trimmed - hit->querystart_trimmed - hit->nindels,min_coverage));
      debug1(printf("Coverage is queryend_trimmed %d - querystart_trimmed %d - nindels %d\n",
		    hit->queryend_trimmed,hit->querystart_trimmed,hit->nindels));

      if (hit->refalt_score_overall > max_mismatches_refalt) {
	debug1(printf(" => FREE\n"));
	Stage3end_free(&hit);
      } else if (hit->refalt_score_overall > max_mismatches_ref) {
	debug1(printf(" => FREE\n"));
	Stage3end_free(&hit);
      } else if (hit->queryend_trimmed - hit->querystart_trimmed - hit->nindels < min_coverage) {
	debug1(printf(" => FREE\n"));
	Stage3end_free(&hit);
      } else {
	debug1(printf(" => KEEP\n"));
	newhits = Hitlist_push(newhits,hitlistpool,(void *) hit);
      }
    }

  } else {
    /* Generally expect trims for RNA-seq, so use refalt_score_within_trims */
    for (p = hits; p != NULL; p = List_next(p)) {
      hit = (Stage3end_T) List_head(p);
      debug1(printf("RNA-seq %p: Comparing refalt score %d against max_mismatches_refalt %d, and coverage %d against min_coverage %d\n",
		    hit,hit->refalt_score_within_trims,max_mismatches_refalt,
		    hit->queryend_trimmed - hit->querystart_trimmed,min_coverage));
      debug1(printf("Coverage is queryend_trimmed %d - querystart_trimmed %d - nindels %d\n",
		    hit->queryend_trimmed,hit->querystart_trimmed,hit->nindels));
      debug1(printf("nmatches is %d or %d vs min_coverage %d\n",
		    hit->ref_nmatches_to_trims,hit->refalt_nmatches_plus_spliced_trims,min_coverage));

      if (hit->refalt_score_within_trims > max_mismatches_refalt) {
	debug1(printf(" => FREE\n"));
	Stage3end_free(&hit);
      } else if (hit->queryend_trimmed - hit->querystart_trimmed - hit->nindels < min_coverage) {
	debug1(printf(" => FREE\n"));
	Stage3end_free(&hit);
      } else {
	debug1(printf(" => KEEP\n"));
	newhits = Hitlist_push(newhits,hitlistpool,(void *) hit);
      }
    }
  }


  Hitlist_free(&hits);
  return newhits;
}




Stage3end_T *
Stage3end_eval_and_sort (int npaths, int *first_absmq, int *second_absmq,
			 Stage3end_T *stage3array, char *queryuc_ptr, char *quality_string,
			 bool displayp, Listpool_T listpool) {
  float maxlik, loglik;
  float total, q;		/* For Bayesian mapq calculation */
  int compute_npaths;

  int randomi, i;
  Stage3end_T temp, hit;

  if (npaths == 0) {
    /* Skip */
    *first_absmq = 0;
    *second_absmq = 0;

  } else if (npaths == 1) {
    hit = stage3array[0];
    hit->mapq_loglik = MAPQ_MAXIMUM_SCORE;
    hit->mapq_score = MAPQ_max_quality_score(quality_string,hit->querylength);
    hit->absmq_score = MAPQ_MAXIMUM_SCORE;

    if (displayp == true) {
      Stage3end_display_prep(hit,listpool,queryuc_ptr,/*first_read_p*/true);
    }
    *first_absmq = hit->absmq_score;
    *second_absmq = 0;

  } else {
    /* Compute mapq_loglik */
    for (i = 0; i < npaths; i++) {
      Stage3end_compute_mapq(stage3array[i],quality_string,genomebits,genomebits_alt);
    }

    /* Sort by nmatches, then mapq */
    qsort(stage3array,npaths,sizeof(Stage3end_T),Stage3end_output_cmp);

    if (want_random_p) {
      /* Randomize among best alignments */
      i = 1;
      while (i < npaths && Stage3end_output_cmp(&(stage3array[i]),&(stage3array[0])) == 0) {
	i++;
      }
      if (i > 1) {		/* i is number of ties */
	/* randomi = (int) ((double) i * rand()/((double) RAND_MAX + 1.0)); */
	randomi = (int) (rand() / (((double) RAND_MAX + 1.0) / (double) i));
	/* fprintf(stderr,"%d dups => random %d\n",i,randomi); */
	temp = stage3array[0];
	stage3array[0] = stage3array[randomi];
	stage3array[randomi] = temp;
      }
    }

    /* Enforce monotonicity */
    for (i = npaths - 1; i > 0; i--) {
      if (stage3array[i-1]->mapq_loglik < stage3array[i]->mapq_loglik) {
	stage3array[i-1]->mapq_loglik = stage3array[i]->mapq_loglik;
      }
    }
    maxlik = stage3array[0]->mapq_loglik;
    
    /* Subtract maxlik to avoid underflow */
    for (i = 0; i < npaths; i++) {
      stage3array[i]->mapq_loglik -= maxlik;
    }

#if 0
    /* Save on computation if possible */
    /* Not possible, since we are going to select randomly from among all npaths */
    if (npaths < maxpaths) {
      compute_npaths = npaths;
    } else {
      compute_npaths = maxpaths;
    }
    if (compute_npaths < 2) {
      compute_npaths = 2;
    }
#else
    compute_npaths = npaths;
#endif

    /* Compute absolute mapq */
    for (i = 0; i < compute_npaths; i++) {
      loglik = stage3array[i]->mapq_loglik + MAPQ_MAXIMUM_SCORE;
      if (loglik < 0.0) {
	loglik = 0.0;
      }
      stage3array[i]->absmq_score = rint(loglik);
    }
    *first_absmq = stage3array[0]->absmq_score;
    *second_absmq = stage3array[1]->absmq_score;


    /* Compute Bayesian mapq */
    total = 0.0;
    for (i = 0; i < npaths; i++) {
      total += (stage3array[i]->mapq_loglik = fasterexp(stage3array[i]->mapq_loglik));
    }

    /* Obtain posterior probabilities of being true */
    for (i = 0; i < compute_npaths; i++) {
      stage3array[i]->mapq_loglik /= total;
    }

    /* Convert to Phred scores */
    for (i = 0; i < compute_npaths; i++) {
      if ((q = 1.0 - stage3array[i]->mapq_loglik) < 2.5e-10 /* 10^-9.6 */) {
	stage3array[i]->mapq_score = 96;
      } else {
	stage3array[i]->mapq_score = rint(-10.0 * log10(q));
      }
    }

    if (displayp == true) {
      /* Prepare for display */
      for (i = 0; i < compute_npaths; i++) {
	Stage3end_display_prep(stage3array[i],listpool,queryuc_ptr,/*first_read_p*/true);
      }
    }

#if 0
    /* Apply filtering for mapq unique -- currently not used since mapq_unique_score is high */
    if (stage3array[0]->mapq_score >= mapq_unique_score &&
	stage3array[1]->mapq_score < mapq_unique_score) {
      for (i = 1; i < *npaths; i++) {
	Stage3end_free(&(stage3array[i]));
      }
      *npaths = 1;
    }
#endif
  }

  return stage3array;
}


static int
insertlength_expected (Chrpos_T insertlength) {
  if (insertlength < expected_pairlength_low) {
    return -1;
  } else if (insertlength > expected_pairlength_very_high) {
    return -1;
  } else if (insertlength > expected_pairlength_high) {
    return 0;
  } else {
    return +1;
  }
}


/* For concordant ends */
static Chrpos_T
pair_insert_length (int *pair_relationship, Stage3end_T hit5, Stage3end_T hit3) {
  List_T p, q;
  Substring_T substring5, substring3;

  if (hit5->plusp != hit3->plusp) {
    debug10(printf("pair_insert_length: hit5->plusp %d != hit3->plusp %d, so returning 0\n",
		   hit5->plusp,hit3->plusp));
    *pair_relationship = 0;
    return 0;
  }

  if (hit5->chrnum != 0 && hit3->chrnum != 0) {
    for (q = hit3->substrings_1toN; q != NULL; q = List_next(q)) {
      substring3 = (Substring_T) List_head(q);
      for (p = hit5->substrings_1toN; p != NULL; p = List_next(p)) {
	substring5 = (Substring_T) List_head(p);
	if (Substring_overlap_p(substring5,substring3)) {
	  debug10(printf("Calling Substring_insert_length on %d..%d and %d..%d\n",
			 Substring_querystart(substring5),Substring_queryend(substring5),
			 Substring_querystart(substring3),Substring_queryend(substring3)));
	  return Substring_insert_length(&(*pair_relationship),substring5,substring3);
	}
      }
    }
  }

  /* No overlap found between any combination of substrings */
  if (hit5->plusp == true) {
    /* Was hit5->high > hit3->low + hit5->querylength + hit3->querylength */
    if (hit5->genomicend > hit3->genomicstart + hit5->querylength + hit3->querylength) {
      debug10(printf("pair_insert_length: no overlap found, and %u - %u + %d + %d < 0, so returning 0\n",
		     hit3->genomicstart - hit3->chroffset,hit5->genomicend - hit5->chroffset,
		     hit5->querylength,hit3->querylength));
      *pair_relationship = 0;
      return 0;
    } else {
      debug10(printf("pair_insert_length: no overlap found, so returning %u - %u + %d + %d\n",
		     hit3->genomicstart - hit3->chroffset,hit5->genomicend - hit5->chroffset,
		     hit5->querylength,hit3->querylength));
    }
    *pair_relationship = +1;
    return hit3->genomicstart - hit5->genomicend + hit5->querylength + hit3->querylength;

  } else {
    /* Was hit3->high > hit5->low + hit5->querylength + hit3->querylength */
    if (hit3->genomicstart > hit5->genomicend + hit5->querylength + hit3->querylength) {
      debug10(printf("pair_insert_length: no overlap found, and %u - %u + %d + %d < 0, so returning 0\n",
		     hit5->genomicend - hit5->chroffset,hit3->genomicstart - hit3->chroffset,
		     hit5->querylength,hit3->querylength));
      *pair_relationship = 0;
      return 0;
    } else {
      debug10(printf("pair_insert_length: no overlap found, so returning %u - %u + %d + %d\n",
		     hit5->genomicend - hit5->chroffset,hit3->genomicstart - hit3->chroffset,
		     hit5->querylength,hit3->querylength));
      *pair_relationship = -1;
      return hit5->genomicend - hit3->genomicstart + hit5->querylength + hit3->querylength;
    }
  }
}



/* For unpaired ends */
static Chrpos_T
pair_insert_length_unpaired (Stage3end_T hit5, Stage3end_T hit3) {

  if (hit5->effective_chrnum != hit3->effective_chrnum) {
    debug10(printf("pair_insert_length: hit5->plusp %d != hit3->plusp %d, so returning 0\n",
		   hit5->plusp,hit3->plusp));
    return 0;
  } else if (hit5->distant_splice_i >= 0) {
    return 0;
  } else if (hit3->distant_splice_i >= 0) {
    return 0;
  } else if (hit5->genomicstart < hit3->genomicstart) {
    /* was hit3->low - hit5->high + hit5->querylength + hit3->querylength; */
    return hit3->genomicstart - hit5->genomicstart;
  } else if (hit3->genomicstart < hit5->genomicstart) {
    /* was hit5->low - hit3->high + hit5->querylength + hit3->querylength; */
    return hit5->genomicstart - hit3->genomicstart;
  } else {
    return hit5->querylength + hit3->querylength;
  }
}


Stage3end_T *
Stage3end_eval_and_sort_guided (int npaths, int *first_absmq, int *second_absmq, Stage3end_T guide,
				Stage3end_T *stage3array, char *queryuc_ptr, char *quality_string,
				bool displayp, Listpool_T listpool) {
  float maxlik, loglik;
  float total, q;		/* For Bayesian mapq calculation */
  int compute_npaths;

  int randomi, i;
  Stage3end_T temp, hit;

  if (npaths == 0) {
    /* Skip */
    *first_absmq = 0;
    *second_absmq = 0;

  } else if (npaths == 1) {
    hit = stage3array[0];
    hit->mapq_loglik = MAPQ_MAXIMUM_SCORE;
    hit->mapq_score = MAPQ_max_quality_score(quality_string,hit->querylength);
    hit->absmq_score = MAPQ_MAXIMUM_SCORE;

    if (displayp == true) {
      Stage3end_display_prep(hit,listpool,queryuc_ptr,/*first_read_p*/true);
    }
    *first_absmq = hit->absmq_score;
    *second_absmq = 0;

  } else {
    /* Compute mapq_loglik */
    for (i = 0; i < npaths; i++) {
      Stage3end_compute_mapq(stage3array[i],quality_string,genomebits,genomebits_alt);
    }

    /* Compute insert_length relative to guide.  This is the only change from the unguided procedure. */
    for (i = 0; i < npaths; i++) {
      stage3array[i]->guided_insertlength = pair_insert_length_unpaired(stage3array[i],guide);
    }

    /* Sort by nmatches, then mapq */
    qsort(stage3array,npaths,sizeof(Stage3end_T),Stage3end_output_cmp);

    if (want_random_p) {
      /* Randomize among best alignments */
      i = 1;
      while (i < npaths && Stage3end_output_cmp(&(stage3array[i]),&(stage3array[0])) == 0) {
	i++;
      }
      if (i > 1) {		/* i is number of ties */
	/* randomi = (int) ((double) i * rand()/((double) RAND_MAX + 1.0)); */
	randomi = (int) (rand() / (((double) RAND_MAX + 1.0) / (double) i));
	/* fprintf(stderr,"%d dups => random %d\n",i,randomi); */
	temp = stage3array[0];
	stage3array[0] = stage3array[randomi];
	stage3array[randomi] = temp;
      }
    }

    /* Enforce monotonicity */
    for (i = npaths - 1; i > 0; i--) {
      if (stage3array[i-1]->mapq_loglik < stage3array[i]->mapq_loglik) {
	stage3array[i-1]->mapq_loglik = stage3array[i]->mapq_loglik;
      }
    }
    maxlik = stage3array[0]->mapq_loglik;
    
    /* Subtract maxlik to avoid underflow */
    for (i = 0; i < npaths; i++) {
      stage3array[i]->mapq_loglik -= maxlik;
    }

#if 0
    /* Save on computation if possible */
    /* Not possible, since we are going to select randomly from among all paths */
    if (npaths < maxpaths) {
      compute_npaths = npaths;
    } else {
      compute_npaths = maxpaths;
    }
    if (compute_npaths < 2) {
      compute_npaths = 2;
    }
#else
    compute_npaths = npaths;
#endif

    /* Compute absolute mapq */
    for (i = 0; i < compute_npaths; i++) {
      loglik = stage3array[i]->mapq_loglik + MAPQ_MAXIMUM_SCORE;
      if (loglik < 0.0) {
	loglik = 0.0;
      }
      stage3array[i]->absmq_score = rint(loglik);
    }
    *first_absmq = stage3array[0]->absmq_score;
    *second_absmq = stage3array[1]->absmq_score;


    /* Compute Bayesian mapq */
    total = 0.0;
    for (i = 0; i < npaths; i++) {
      total += (stage3array[i]->mapq_loglik = fasterexp(stage3array[i]->mapq_loglik));
    }

    /* Obtain posterior probabilities of being true */
    for (i = 0; i < compute_npaths; i++) {
      stage3array[i]->mapq_loglik /= total;
    }

    /* Convert to Phred scores */
    for (i = 0; i < compute_npaths; i++) {
      if ((q = 1.0 - stage3array[i]->mapq_loglik) < 2.5e-10 /* 10^-9.6 */) {
	stage3array[i]->mapq_score = 96;
      } else {
	stage3array[i]->mapq_score = rint(-10.0 * log10(q));
      }
    }

    if (displayp == true) {
      /* Prepare for display */
      for (i = 0; i < compute_npaths; i++) {
	Stage3end_display_prep(stage3array[i],listpool,queryuc_ptr,/*first_read_p*/true);
      }
    }

#if 0
    /* Apply filtering for mapq unique -- currently not used since mapq_unique_score is high */
    if (stage3array[0]->mapq_score >= mapq_unique_score &&
	stage3array[1]->mapq_score < mapq_unique_score) {
      for (i = 1; i < *npaths; i++) {
	Stage3end_free(&(stage3array[i]));
      }
      *npaths = 1;
    }
#endif
  }

  return stage3array;
}


/* Note: single-end terminals can be present with non-terminals when
   paired-end reads are searched for concordance, which can accumulate
   terminal alignments */

/* Pre-final: max (max-terminal, min-other)
   Final: max (min-terminal, max-GMAP, min-other) */


static List_T
Stage3end_optimal_score_prefinal (bool *eliminatedp, List_T hitlist, 
				  Hitlistpool_T hitlistpool, int querylength) {
  List_T optimal = NULL, p, q;
  T hit;
  Substring_T substring;
  Junction_T junction;
  int n;
  int cutoff_level, ref_nmismatches;
  int minscore = querylength;
  int querystart_trimmed = 0, queryend_trimmed = querylength;


#ifdef DISTANT_SPLICE_SPECIAL
  bool shortdistance_p = false;
#endif


  *eliminatedp = false;
  n = List_length(hitlist);
  debug4(printf("\nEntered Stage3end_optimal_score with %d hits\n",n));

  if (n <= 1) {
    return hitlist;
  }

  /* Use eventrim for comparing alignments.  Previously picked
     smallest trims, but now picking largest ones */
  for (p = hitlist; p != NULL; p = p->rest) {
    hit = (T) p->first;

    debug4(printf("hit %d..%d, %u..%u method %s, nsegments %d, nindels %d, querystart_trimmed: %d%s, queryend_trimmed %d%s, start_ambig %d, end_ambig %d.  sensedir %d\n",
		  hit->querystart_trimmed,hit->queryend_trimmed,
		  hit->genomicstart - hit->chroffset,hit->genomicend - hit->chroffset,Method_string(hit->method),
		  hit->nsegments,hit->nindels,hit->querystart_trimmed,hit->querystart_trimmed_splicep ? " (splice)" : "",
		  hit->queryend_trimmed,hit->queryend_trimmed_splicep ? " (splice)" : "",
		  start_amb_length(hit),end_amb_length(hit),hit->sensedir));

    if (hit->querystart_trimmed_splicep == true) {
      /* Skip */
    } else if (hit->querystart_trimmed > querystart_trimmed) {
      querystart_trimmed = hit->querystart_trimmed;
    }
    if (hit->queryend_trimmed_splicep == true) {
      /* Skip */
    } else if (hit->queryend_trimmed < queryend_trimmed) {
      queryend_trimmed = hit->queryend_trimmed;
    }
  }

  if (querystart_trimmed == querylength) {
    querystart_trimmed = 0;
  }
  if (queryend_trimmed == 0) {
    queryend_trimmed = querylength;
  }
  debug4(printf("querystart_trimmed: %d, queryend_trimmed %d\n",querystart_trimmed,queryend_trimmed));

  for (p = hitlist; p != NULL; p = p->rest) {
    hit = (T) p->first;

#ifdef CONSIDER_ENDS_IN_EVAL
    hit->score_eventrim = hit->querystart_trimmed / 8 + (hit->querylength - hit->queryend_trimmed) / 8;
#else
    hit->score_eventrim = 0;
#endif

    debug4(printf("score OTHER:"));

    if (querystart_trimmed >= queryend_trimmed) {
      for (q = hit->substrings_1toN; q != NULL; q = List_next(q)) {
	substring = (Substring_T) List_head(q);
	hit->score_eventrim += Substring_nmismatches_bothdiff(substring);
      }
	
    } else {
      for (q = hit->substrings_1toN; q != NULL; q = List_next(q)) {
	substring = (Substring_T) List_head(q);
	hit->score_eventrim += Substring_count_mismatches_region(&ref_nmismatches,substring,querystart_trimmed,queryend_trimmed,
								 genomebits,genomebits_alt);
	debug4(printf("  substring (%d..%d) %d.",querystart_trimmed,queryend_trimmed,
		      Substring_count_mismatches_region(&ref_nmismatches,substring,querystart_trimmed,queryend_trimmed,
							genomebits,genomebits_alt)));
      }
    }

    for (q = hit->junctions_1toN; q != NULL; q = List_next(q)) {
      junction = (Junction_T) List_head(q);
      if (Junction_nindels(junction) > 0) {
	hit->score_eventrim += indel_penalty_middle;
	debug4(printf(" => add %d.",indel_penalty_middle));
      }
    }


#if 0
    /* Accept a single indel */
#ifdef SCORE_INDELS_EVENTRIM
    if (hit->hittype == INSERTION || hit->hittype == DELETION) {
      debugee(printf("  indel at %d",hit->indel_pos));
      if (hit->indel_pos > querystart_trimmed && hit->indel_pos < queryend_trimmed) {
	hit->score_eventrim += indel_penalty_middle;
	debug4(printf(" => add %d.",indel_penalty_middle));
      }
    }
#endif
#endif
    debug4(printf("  RESULT: %d\n",hit->score_eventrim));

    if (hit->score_eventrim < minscore) {
      minscore = hit->score_eventrim;
    }
  }
  debug4(printf("MINSCORE: %d\n",minscore));


  /* Prefinal: Use score_eventrim */
  debug4(printf("Stage3end_optimal_score over %d hits: minscore = %d + subopt:%d\n",
		n,minscore,subopt_levels));
  minscore += subopt_levels;
  cutoff_level = minscore;

  for (p = hitlist; p != NULL; p = p->rest) {
    hit = (T) p->first;

    if (hit->score_eventrim > cutoff_level + SCORE_EVENTRIM_SLOP) {
      debug4(printf("Prefinal: Eliminating hit %p at %d..%d, %u..%u with score_eventrim %d > cutoff_level %d\n",
		    hit,hit->querystart_trimmed,hit->queryend_trimmed,
		    hit->low_trimmed - hit->chroffset,hit->high_trimmed - hit->chroffset,
		    hit->score_eventrim,cutoff_level));
      Stage3end_free(&hit);
      *eliminatedp = true;

    } else {
      debug4(printf("Prefinal: Keeping hit %p at %d..%d, %u..%u with score_eventrim %d <= cutoff_level %d\n",
		    hit,hit->querystart_trimmed,hit->queryend_trimmed,
		    hit->low_trimmed - hit->chroffset,hit->high_trimmed - hit->chroffset,
		    hit->score_eventrim,cutoff_level));
      optimal = Hitlist_push(optimal,hitlistpool,(void *) hit);
    }
  }
  Hitlist_free(&hitlist);


#if 0
  /* Filter on nsegments */
  if (finalp == true && optimal != NULL) {
    hitlist = optimal;
    optimal = (List_T) NULL;

    hit = (T) hitlist->first;
    best_nsegments = hit->nsegments;

    for (p = hitlist; p != NULL; p = p->rest) {
      hit = (T) p->first;
      if (hit->nsegments < best_nsegments) {
	best_nsegments = hit->nsegments;
      }
    }

    for (p = hitlist; p != NULL; p = p->rest) {
      hit = (T) p->first;
      if (hit->nsegments > best_nsegments + 2) {
	debug4(printf("Eliminating a hit with nsegments %d\n",hit->nsegments));
	Stage3end_free(&hit);
	*eliminatedp = true;
      } else {
	debug4(printf("Keeping a hit with nsegments %d, nindels %d\n",hit->nsegments,hit->nindels));
	optimal = Hitlist_push(optimal,hitlitpool,(void *) hit);
      }
    }

    Hitlist_free(&hitlist);
  }
#endif

  debug4(printf("hitlist now has %d entries\n",List_length(optimal)));
  return optimal;
}


static int
hit_position_cmp (const void *a, const void *b) {
  T x = * (T *) a;
  T y = * (T *) b;
  
  if (x->plusp < y->plusp) {
    return -1;
  } else if (y->plusp < x->plusp) {
    return +1;
  } else if (x->low_chrbound < y->low_chrbound) {
    return -1;
  } else if (y->low_chrbound < x->low_chrbound) {
    return +1;
  } else if (x->high_chrbound > y->high_chrbound) {
    return -1;
  } else if (y->high_chrbound > x->high_chrbound) {
    return +1;
  } else {
    return 0;
  }
}

static bool
hit_equal (Stage3end_T x, Stage3end_T y) {
  List_T p, q;
  Substring_T substring_x, substring_y;

  if (x->plusp != y->plusp) {
    return false;		/* Different strands */
  } else {
    p = x->substrings_1toN;
    q = y->substrings_1toN;
    while (p != NULL && q != NULL) {
      substring_x = (Substring_T) p->first;
      substring_y = (Substring_T) q->first;
      if (Substring_equal(substring_x,substring_y) == false) {
	return false;
      }
      p = List_next(p);
      q = List_next(q);
    }
    if (p != NULL || q != NULL) {
      return false;
    }

    return true;
  }
}


static List_T
Stage3end_optimal_score_final (bool *eliminatedp, List_T hitlist, Hitlistpool_T hitlistpool,
			       int querylength) {
  List_T optimal = NULL, p;
  /* T besthit; -- Needed when we transferred transcripts; */
  T hit;
  int n;
  int max_adj_nmatches, score;
  /* int best_nmatches_to_trims; */
  int cutoff_level;
  /* int querystart_trimmed, queryend_trimmed, min_trim; */


  *eliminatedp = false;
  n = List_length(hitlist);
  debug4(printf("\nEntered Stage3end_optimal_score with %d hits\n",n));

  if (n <= 1) {
    return hitlist;
  }

#ifdef DEBUG4
  for (p = hitlist; p != NULL; p = p->rest) {
    hit = (Stage3end_T) p->first;
    printf("%p %d..%d, %u..%u method %s, score_eventrim %d, nmatches %d (%d to_trims), refalt score %d\n",
	   hit,hit->querystart_trimmed,hit->queryend_trimmed,
	   hit->low_trimmed - hit->chroffset,hit->high_trimmed - hit->chroffset,
	   Method_string(hit->method),hit->score_eventrim,hit->refalt_nmatches_plus_spliced_trims,hit->refalt_nmatches_to_trims,
	   hit->refalt_score_overall);
  }
  printf("\n");
#endif

  /* (1) Prune based on nmatches adjusted by score to get a tradeoff between matches and parsimony */
  max_adj_nmatches = -querylength;
  for (p = hitlist; p != NULL; p = p->rest) {
    hit = (Stage3end_T) p->first;
    if ((score = hit->refalt_nmatches_plus_spliced_trims) > max_adj_nmatches) {
      max_adj_nmatches = score;
      /* besthit = hit; */
    }
  }

  cutoff_level = max_adj_nmatches - subopt_levels;
  debug4(printf("(1) refalt cutoff level %d = max_adj_nmatches %d - subopt_levels %d\n",
		cutoff_level,max_adj_nmatches,subopt_levels));

  for (p = hitlist; p != NULL; p = List_next(p)) {
    hit = (Stage3end_T) p->first;

    if (hit->refalt_nmatches_plus_spliced_trims < cutoff_level /*- NMATCHES_SLOP*/) {
      debug4(printf("Final (adj nmatches %d < %d): Eliminating hit %p at %d..%d, %u..%u with nmatches %d (%d to_trims) < cutoff_level %d\n",
		    hit->refalt_nmatches_plus_spliced_trims,cutoff_level /*- NMATCHES_SLOP*/,
		    hit,hit->querystart_trimmed,hit->queryend_trimmed,
		    hit->low_trimmed - hit->chroffset,hit->high_trimmed - hit->chroffset,
		    hit->refalt_nmatches_plus_spliced_trims,hit->refalt_nmatches_to_trims,cutoff_level));
      /* transfer_transcripts(besthit,hit,listpool); */
      Stage3end_free(&hit);
      *eliminatedp = true;

    } else {
      debug4(printf("Final (nmatches %d >= %d): Keeping hit %p at %d..%d, %u..%u with nmatches %d (%d to_trims) >= cutoff_level %d\n",
		    hit->refalt_nmatches_plus_spliced_trims,cutoff_level /*- NMATCHES_SLOP*/,
		    hit,hit->querystart_trimmed,hit->queryend_trimmed,
		    hit->low_trimmed - hit->chroffset,hit->high_trimmed - hit->chroffset,
		    hit->refalt_nmatches_plus_spliced_trims,hit->refalt_nmatches_to_trims,cutoff_level));
      optimal = Hitlist_push(optimal,hitlistpool,(void *) hit);
    }
  }
  Hitlist_free(&hitlist);
  hitlist = optimal;

#if 0
  /* (2) Prune based on ref_nmatches_to_trims */
  optimal = (List_T) NULL;

  best_nmatches_to_trims = 0;
  for (p = hitlist; p != NULL; p = p->rest) {
    hit = (Stage3end_T) p->first;
    if (hit->ref_nmatches_to_trims > best_nmatches_to_trims) {
      best_nmatches_to_trims = hit->ref_nmatches_to_trims;
      /* besthit = hit; */
      assert(best_nmatches_to_trims <= querylength);
    }
  }

  cutoff_level = best_nmatches_to_trims - subopt_levels;
  debug4(printf("cutoff level %d = best_nmatches_to_trims %d\n",cutoff_level,best_nmatches_to_trims));

  /* Do not allow slop for final */
  for (p = hitlist; p != NULL; p = List_next(p)) {
    hit = (Stage3end_T) p->first;

    if (hit->ref_nmatches_to_trims < cutoff_level /*- NMATCHES_TO_TRIMS_SLOP*/) {
      debug4(printf("Final (nmatches_to_trims %d < %d): Eliminating hit %p at %d..%d, %u..%u with nmatches_to_trims %d (%d to_trims) < cutoff_level %d\n",
		    hit->ref_nmatches_to_trims,cutoff_level /*- NMATCHES_TO_TRIMS_SLOP*/,hit,
		    hit->querystart_trimmed,hit->queryend_trimmed,
		    hit->low_trimmed - hit->chroffset,hit->high_trimmed - hit->chroffset,
		    hit->ref_nmatches_plus_spliced_trims,hit->ref_nmatches_to_trims,cutoff_level));
      /* transfer_transcripts(besthit,hit,listpool); */
      Stage3end_free(&hit);
      *eliminatedp = true;

    } else {
      debug4(printf("Final (nmatches_to_trims %d >= %d): Keeping hit %p at %d..%d, %u..%u with nmatches_to_trims %d (%d to_trims) >= cutoff_level %d\n",
		    hit->ref_nmatches_to_trims,cutoff_level /*- NMATCHES_TO_TRIMS_SLOP*/,hit,
		    hit->querystart_trimmed,hit->queryend_trimmed,
		    hit->low_trimmed - hit->chroffset,hit->high_trimmed - hit->chroffset,
		    hit->ref_nmatches_plus_spliced_trims,hit->ref_nmatches_to_trims,cutoff_level));
      optimal = Hitlist_push(optimal,hitlistpool,(void *) hit);
    }
  }
  Hitlist_free(&hitlist);
  hitlist = optimal;
#endif

  /* Shouldn't need to eliminate within loci, since that was done during prefinal */

  debug4(printf("Exiting Stage3end_optimal_score_final with %d hits\n",List_length(hitlist)));
  return hitlist;
}



List_T
Stage3end_optimal_score (List_T hitlist, Hitlistpool_T hitlistpool,
			 int querylength, bool finalp) {
  List_T optimal;
  bool eliminatedp;

  if (finalp == false) {
    optimal = Stage3end_optimal_score_prefinal(&eliminatedp,hitlist,hitlistpool,querylength);
    while (eliminatedp == true) {
      optimal = Stage3end_optimal_score_prefinal(&eliminatedp,optimal,hitlistpool,querylength);
    }

  } else {
    optimal = Stage3end_optimal_score_final(&eliminatedp,hitlist,hitlistpool,querylength);
    while (eliminatedp == true) {
      optimal = Stage3end_optimal_score_final(&eliminatedp,optimal,hitlistpool,querylength);
    }
  }

  return optimal;
}


static void
unalias_circular (T hit) {
  Chrpos_T chrlength = hit->chrlength;
  List_T p;
  Substring_T substring;

  assert(hit->circularalias == +1);
  debug12(printf("Calling unalias_circular on substrings\n"));
  for (p = hit->substrings_1toN; p != NULL; p = List_next(p)) {
    substring = (Substring_T) List_head(p);
    Substring_unalias_circular(substring);
  }

  /* Doesn't fix hitpair->low and hitpair->high */
  hit->genomicstart -= chrlength;
  hit->genomicend -= chrlength;
  hit->low_chrbound -= chrlength;
  hit->high_chrbound -= chrlength;
  hit->low_trimmed -= chrlength;
  hit->high_trimmed -= chrlength;

  hit->circularalias = -1;
  debug12(printf("Changing circularalias to be -1\n"));

  return;
}


#if 0
List_T
Stage3end_unalias_circular (List_T hitlist) {
  List_T p;
  T hit;

  for (p = hitlist; p != NULL; p = p->rest) {
    hit = (T) p->first;
    if (hit->circularalias == +1) {
      unalias_circular(hit);
    }
  }

  return hitlist;
}
#endif

List_T
Stage3end_remove_circular_alias (List_T hitlist, Hitlistpool_T hitlistpool) {
  List_T newlist = NULL, p;
  T hit;

  debug12(printf("Calling Stage3end_remove_circular_alias on %d hits\n",List_length(hitlist)));
  for (p = hitlist; p != NULL; p = p->rest) {
    hit = (T) p->first;
    debug12(printf("hit has circularalias %d\n",hit->circularalias));

    if (hit->circularalias == +1) {
      /* First, try to salvage alias +1 */
      unalias_circular(hit);
    }

    if (hit->chrnum == 0) {
      /* Translocation */
      newlist = Hitlist_push(newlist,hitlistpool,(void *) hit);

    } else if (hit->low_trimmed - hit->chroffset >= hit->chrlength) {
      /* All in circular alias */
      debug12(printf("Freeing hit because all is in circular alias\n"));
      Stage3end_free(&hit);

    } else {
      newlist = Hitlist_push(newlist,hitlistpool,(void *) hit);
    }
  }

  Hitlist_free(&hitlist);
  return newlist;
}


#if 0
int
Stage3end_noptimal (List_T hitlist, int querylength) {
  int noptimal;
  List_T p;
  T hit;
  int minscore = querylength;

  noptimal = 0;
  for (p = hitlist; p != NULL; p = p->rest) {
    hit = (T) p->first;
    if (hit->score < minscore) {
      minscore = hit->score;
      noptimal = 0;
    }
    if (hit->score == minscore) {
      noptimal++;
    }
  }

  return noptimal;
}
#endif


static Univcoord_T
normalize_coord (Univcoord_T orig, int circularalias, Chrpos_T chrlength) {
  if (circularalias == +1) {
    return orig - chrlength;
  } else {
    return orig;
  }
}



static int
duplicate_sort_cmp (const void *a, const void *b) {
  int cmp;
  T x = * (T *) a;
  T y = * (T *) b;
  Univcoord_T x_genomicstart, y_genomicstart;
  Univcoord_T x_genomicend, y_genomicend;
  List_T p, q;
  Substring_T x_substring, y_substring;

  if (altlocp[x->chrnum] == true && altlocp[y->chrnum] == true) {
    if (alias_ends[y->chrnum] >= alias_starts[x->chrnum] &&
	alias_starts[y->chrnum] <= alias_ends[x->chrnum]) {
      /* The primary regions overlap */
      return 0;
    } else if (alias_starts[x->chrnum] < alias_starts[y->chrnum]) {
      return -1;
    } else if (alias_starts[y->chrnum] < alias_starts[x->chrnum]) {
      return +1;
    } else if (alias_ends[x->chrnum] < alias_ends[y->chrnum]) {
      return -1;
    } else if (alias_ends[y->chrnum] < alias_ends[x->chrnum]) {
      return +1;
    } else {
      return 0;
    }

  } else if (altlocp[x->chrnum] == true) {
    if (y->genomicend >= alias_starts[x->chrnum] &&
	y->genomicstart <= alias_ends[x->chrnum]) {
      /* y overlaps with the primary region for x */
      return +1;		/* Put primary region first */
    }
    /* Don't overlap, so fall through to rest of procedure */

  } else if (altlocp[y->chrnum] == true) {
    if (alias_ends[y->chrnum] >= x->genomicstart &&
	alias_starts[y->chrnum] <= x->genomicend) {
      /* x overlaps with the primary region for y */
      return -1;		/* Put primary region first */
    }
    /* Don't overlap, so fall through to rest of procedure */
  }


  x_genomicstart = normalize_coord(x->genomicstart,x->circularalias,x->chrlength);
  x_genomicend = normalize_coord(x->genomicend,x->circularalias,x->chrlength);

  y_genomicstart = normalize_coord(y->genomicstart,y->circularalias,y->chrlength);
  y_genomicend = normalize_coord(y->genomicend,y->circularalias,y->chrlength);

  
  if (x_genomicstart < y_genomicstart) {
    return -1;
  } else if (x_genomicstart > y_genomicstart) {
    return +1;
  } else if (x->hittype < y->hittype) {
    return -1;
  } else if (x->hittype > y->hittype) {
    return +1;
  } else if (x_genomicend < y_genomicend) {
    return -1;
  } else if (x_genomicend > y_genomicend) {
    return +1;

    /* Favor transcriptome method over other methods because it trims at exon boundaries */
  } else if (x->method < y->method) {
    return -1;
  } else if (y->method < x->method) {
    return +1;

#if 0
  /* sensedir is relevant for transcriptome-guided alignment, with overlapping genes */
  } else if (x->sensedir > y->sensedir) {
    return -1;
  } else if (y->sensedir > x->sensedir) {
    return +1;
#endif

  } else {
    for (p = x->substrings_1toN, q = y->substrings_1toN; p != NULL && q != NULL; p = List_next(p), q = List_next(q)) {
      x_substring = (Substring_T) List_head(p);
      y_substring = (Substring_T) List_head(q);
      if ((cmp = Substring_compare(x_substring,y_substring,x->circularalias,y->circularalias,x->chrlength,y->chrlength)) != 0) {
	return cmp;
      }
    }
    if (p == NULL && q != NULL) {
      return -1;
    } else if (p != NULL && q == NULL) {
      return +1;
    }

#if 0
    /* Need to change to search on junctions */
    if (x->indel_low < y->indel_low) {
      return -1;
    } else if (y->indel_low < x->indel_low) {
      return +1;
    }
#endif

    return 0;
  }
}

/* Same as duplicate_sort_cmp, except for indel_low */
static int
duplicate_equiv_cmp (const void *a, const void *b) {
  int cmp;
  T x = * (T *) a;
  T y = * (T *) b;
  List_T p, q;
  Substring_T x_substring, y_substring;

  Univcoord_T x_genomicstart, x_genomicend, y_genomicstart, y_genomicend;

  if (altlocp[x->chrnum] == true && altlocp[y->chrnum] == true) {
    if (alias_ends[y->chrnum] >= alias_starts[x->chrnum] &&
	alias_starts[y->chrnum] <= alias_ends[x->chrnum]) {
      /* The primary regions overlap */
      return 0;
    }

  } else if (altlocp[x->chrnum] == true) {
    if (y->genomicend >= alias_starts[x->chrnum] &&
	y->genomicstart <= alias_ends[x->chrnum]) {
      /* y overlaps with the primary region for x */
      return 0;
    }

  } else if (altlocp[y->chrnum] == true) {
    if (alias_ends[y->chrnum] >= x->genomicstart &&
	alias_starts[y->chrnum] <= x->genomicend) {
      /* x overlaps with the primary region for y */
      return 0;
    }
  }

  x_genomicstart = normalize_coord(x->genomicstart,x->circularalias,x->chrlength);
  x_genomicend = normalize_coord(x->genomicend,x->circularalias,x->chrlength);

  y_genomicstart = normalize_coord(y->genomicstart,y->circularalias,y->chrlength);
  y_genomicend = normalize_coord(y->genomicend,y->circularalias,y->chrlength);

  if (x_genomicstart < y_genomicstart) {
    return -1;
  } else if (x_genomicstart > y_genomicstart) {
    return +1;
#if 0
  } else if (x->hittype < y->hittype) {
    return -1;
  } else if (x->hittype > y->hittype) {
    return +1;
#endif
  } else if (x_genomicend < y_genomicend) {
    return -1;
  } else if (x_genomicend > y_genomicend) {
    return +1;

    /* sensedir is relevant for transcriptome-guided alignment, with overlapping genes */
  } else if (x->sensedir > y->sensedir) {
    return -1;
  } else if (y->sensedir > x->sensedir) {
    return +1;

  } else {
    for (p = x->substrings_1toN, q = y->substrings_1toN; p != NULL && q != NULL; p = List_next(p), q = List_next(q)) {
      x_substring = (Substring_T) List_head(p);
      y_substring = (Substring_T) List_head(q);
      if ((cmp = Substring_compare(x_substring,y_substring,x->circularalias,y->circularalias,x->chrlength,y->chrlength)) != 0) {
	return cmp;
      }
    }
    if (p == NULL && q != NULL) {
      return -1;
    } else if (p != NULL && q == NULL) {
      return +1;
    } else {
      return 0;
    }
  }
}


#if defined(DEBUG0) || defined(DEBUG4)
static void
Stage3end_print_substrings (Stage3end_T hit) {
  List_T p;
  Substring_T substring;

  for (p = hit->substrings_1toN; p != NULL; p = List_next(p)) {
    if ((substring = (Substring_T) List_head(p)) == NULL) {
      printf("NA ");
    } else {
      printf("#%d:%llu..%llu ",
	     Substring_chrnum(substring),
	     (unsigned long long) Substring_alignstart_trim(substring),
	     (unsigned long long) Substring_alignend_trim(substring));
    }
  }
  return;
}
#endif


const Except_T Duplicate_Pairing = { "Duplicates both seen in pairing" };

List_T
Stage3end_remove_duplicates (List_T hitlist, Hitlistpool_T hitlistpool) {
#ifdef DEBUG4
  List_T p;
#endif
  T x, y, *hits;
  int n, usedi, i, j, k;
  bool *eliminate, eliminatep;

  debug4(printf("Entered Stage3end_remove_duplicates with %d hits\n",List_length(hitlist)));
  if ((n = List_length(hitlist)) == 0) {
    return (List_T) NULL;
  } else {
#ifdef USE_ALLOCA_FOR_HITS
    eliminate = (bool *) CALLOCA(n,sizeof(bool));
    hits = (T *) MALLOCA(n * sizeof(T));    
    List_fill_array((void **) hits,hitlist); /* hitlist is a return value */
#else
    eliminate = (bool *) CALLOC(n,sizeof(bool));
    hits = (T *) List_to_array(hitlist,NULL);
#endif
  }


  /* By equivalence */
  debug4(printf("Stage3end_remove_duplicates: checking %d hits by equivalence class\n",n));
  qsort(hits,n,sizeof(T),duplicate_sort_cmp);

  debug4(
	 for (i = 0; i < n; i++) {
	   x = hits[i];
	   printf("  Initial %d (%s): %p %d..%d, #%d:%u..%u, circularalias %d, nmatches %d (%d to_trims), score %d, sense %d ",
		  i,Method_string(x->method),x,
		  x->querystart_trimmed,x->queryend_trimmed,
		  x->chrnum,x->low_trimmed - x->chroffset,x->high_trimmed - x->chroffset,
		  x->circularalias,x->refalt_nmatches_plus_spliced_trims,x->refalt_nmatches_to_trims,x->refalt_score_within_trims,x->sensedir);
	   Stage3end_print_substrings(x);
	   Transcript_print_list_debug(x->transcripts_consistent);
	   Transcript_print_list_debug(x->transcripts_inconsistent);
	   printf("\n");
	 }
	 );

  eliminatep = false;
  i = 0;
  while (i < n) {
    j = i+1;
    while (j < n && duplicate_equiv_cmp(&(hits[j]),&(hits[i])) == 0) {
      j++;
    }

    if (j > i+1) {
      debug4(printf("Equivalence class #%d through #%d.  ",i,j-1));

      x = hits[i];
      if (x->paired_usedp == true) {
	usedi = i;
      } else {
	usedi = -1;
      }
      
      for (k = i+1; k < j; k++) {
	y = hits[k];
	if (y->paired_usedp == true) {
	  if (usedi >= 0) {
	    debug4(printf("  #%d equivalent to #%d and both used (%p and %p)\n",k,usedi,hits[k],hits[usedi]));
#if 0
	    /* This doesn't matter anymore.  Example from NM_001033853:
	       TTGCCCTTGGTCACCCCGATGACGTCGATCATCTCATCCTGCCCAAACACTTGGTTCACAGGTACCTGCTGCTCA
	       AGTGATGAATCCAAGAGGCGTTTCTATAAGAATTGGCATAAATCTAAGAAGAAGGCCCACCTGATGGAGATCCAG */
	    fprintf(stderr,"Duplicates of Stage3end_T both seen\n");
#if 0
	    /* No longer providing queryseq1 and queryseq2 */
	    Shortread_print_query_pairedend_fasta(stderr,queryseq1,queryseq2,
						  /*invert_first_p*/false,/*invert_second_p*/true);
#endif
	    Except_raise(&Duplicate_Pairing, __FILE__, __LINE__);
#endif
	  } else {
	    usedi = k;
	  }
	}
      }

      if (usedi < 0) {
	debug4(printf("None used yet so eliminating #%d through #%d\n",i+1,j-1));
	for (k = i+1; k < j; k++) {
	  y = hits[k];
	  /* transfer_transcripts(x,y,listpool); */
	  eliminate[k] = true;
	  eliminatep = true;
	}
      } else {
	debug4(printf("One used already so eliminating all but #%d\n",usedi));
	for (k = i; k < j; k++) {
	  if (k != usedi) {
	    y = hits[k];
	    /* transfer_transcripts(x,y,listpool); */
	    eliminate[k] = true;
	    eliminatep = true;
	  }
	}
      }
    }

    i = j;
  }
    

#if 0
  nkept = 0;
  for (i = 0; i < n; i++) {
    if (eliminate[i] == false) {
      nkept++;
    }
  }
  if (nkept == 0) {
    /* All entries eliminated one another, so keep the first one */
    eliminate[0] = false;
  }
#endif

  if (eliminatep == false) {
    debug4(printf("No eliminations, so hitlist is unchanged\n"));
  } else {
    Hitlist_free(&hitlist);
    for (i = n-1; i >= 0; i--) {
      x = hits[i];
      if (eliminate[i] == false) {
#ifdef DEBUG4
	printf("  Keeping #%d at %d..%d, chr #%d:%u..%u, score %d, nmatches %d (nindels %d, chrnum %d) (plusp = %d, sensedir = %d) ",
	       i,x->querystart_trimmed,x->queryend_trimmed,
	       x->chrnum,x->low_trimmed - x->chroffset,x->high_trimmed - x->chroffset,
	       x->refalt_score_within_trims,x->refalt_nmatches_plus_spliced_trims,x->nindels,x->chrnum,x->plusp,x->sensedir);
	Stage3end_print_substrings(x);
	Transcript_print_nums(x->transcripts_consistent);
	Transcript_print_nums(x->transcripts_inconsistent);
	printf("\n");
#endif
	hitlist = Hitlist_push(hitlist,hitlistpool,(void *) x);

      } else {
#ifdef DEBUG4
	printf("  Eliminating hit %p #%d at %d..%d, chr #%d:%u..%u, score %d, nmatches %d (nindels %d, chrnum %d) (plusp = %d, sensedir = %d) ",
	       x,i,x->querystart_trimmed,x->queryend_trimmed,
	       x->chrnum,x->low_trimmed - x->chroffset,x->high_trimmed - x->chroffset,
	       x->refalt_score_within_trims,x->refalt_nmatches_plus_spliced_trims,x->nindels,x->chrnum,x->plusp,x->sensedir);
	Stage3end_print_substrings(x);
	Transcript_print_nums(x->transcripts_consistent);
	Transcript_print_nums(x->transcripts_inconsistent);
	printf("\n");
#endif
	Stage3end_free(&x);
      }
    }
  }

#ifdef USE_ALLOCA_FOR_HITS
  FREEA(hits);
  FREEA(eliminate);
#else
  FREE(hits);
  FREE(eliminate);
#endif

#ifdef DEBUG4
  for (p = hitlist, i = 0; p != NULL; p = p->rest, i++) {
    x = (T) p->first;
    printf("  Final %d: %d..%d, #%d:%u..%u (plusp = %d, sensedir = %d) ",
	   i,x->querystart_trimmed,x->queryend_trimmed,
	   x->chrnum,x->genomicstart - x->chroffset,x->genomicend - x->chroffset,x->plusp,x->sensedir);
    Stage3end_print_substrings(x);
    Transcript_print_nums(x->transcripts_consistent);
    Transcript_print_nums(x->transcripts_inconsistent);
    printf("\n");
  }
#endif

  debug4(printf("Exited Stage3end_remove_duplicates with %d hits\n",List_length(hitlist)));
  return hitlist;
}



T *
Stage3end_remove_duplicates_array (int *nunique, List_T *duplicates, T *hits, int nhits,
				   Hitlistpool_T hitlistpool) {
  T *unique, *out, x, y;
  int usedi, i, j, k;
  bool *eliminate, eliminatep;

  debug4(printf("Entered Stage3end_remove_duplicates_array with %d hits\n",nhits));
  if (nhits == 0) {
    *nunique = 0;
    return (T *) NULL;

  } else {
    eliminate = (bool *) CALLOC(nhits,sizeof(bool));
  }

  /* By equivalence */
  debug4(printf("Stage3end_remove_duplicates_array: checking %d hits by equivalence class\n",nhits));
  qsort(hits,nhits,sizeof(T),duplicate_sort_cmp);

  debug4(
	 for (i = 0; i < nhits; i++) {
	   x = hits[i];
	   printf("  Initial %d (%s): %p %d..%d, #%d:%u..%u, circularalias %d, nmatches %d (%d to_trims), score %d, sense %d ",
		  i,Method_string(x->method),x,
		  x->querystart_trimmed,x->queryend_trimmed,
		  x->chrnum,x->genomicstart - x->chroffset,x->genomicend - x->chroffset,
		  x->circularalias,x->refalt_nmatches_plus_spliced_trims,x->refalt_nmatches_to_trims,x->refalt_score_within_trims,x->sensedir);
	   Stage3end_print_substrings(x);
	   Transcript_print_list_debug(x->transcripts_consistent);
	   Transcript_print_list_debug(x->transcripts_inconsistent);
	   printf("\n");
	 }
	 );

  eliminatep = false;
  i = 0;
  while (i < nhits) {
    j = i+1;
    while (j < nhits && duplicate_equiv_cmp(&(hits[j]),&(hits[i])) == 0) {
      j++;
    }

    if (j > i+1) {
      debug4(printf("Equivalence class #%d through #%d.  ",i,j-1));

      x = hits[i];
      if (x->paired_usedp == true) {
	usedi = i;
      } else {
	usedi = -1;
      }
      
      for (k = i+1; k < j; k++) {
	y = hits[k];
	if (y->paired_usedp == true) {
	  if (usedi >= 0) {
	    debug4(printf("  #%d equivalent to #%d and both used (%p and %p)\n",k,usedi,hits[k],hits[usedi]));
#if 0
	    /* This doesn't matter anymore.  Example from NM_001033853:
	       TTGCCCTTGGTCACCCCGATGACGTCGATCATCTCATCCTGCCCAAACACTTGGTTCACAGGTACCTGCTGCTCA
	       AGTGATGAATCCAAGAGGCGTTTCTATAAGAATTGGCATAAATCTAAGAAGAAGGCCCACCTGATGGAGATCCAG */
	    fprintf(stderr,"Duplicates of Stage3end_T both seen\n");
#if 0
	    /* No longer providing queryseq1 and queryseq2 */
	    Shortread_print_query_pairedend_fasta(stderr,queryseq1,queryseq2,
						  /*invert_first_p*/false,/*invert_second_p*/true);
#endif
	    Except_raise(&Duplicate_Pairing, __FILE__, __LINE__);
#endif
	  } else {
	    usedi = k;
	  }
	}
      }

      if (usedi < 0) {
	debug4(printf("None used yet so eliminating #%d through #%d\n",i+1,j-1));
	for (k = i+1; k < j; k++) {
	  y = hits[k];
	  /* transfer_transcripts(x,y,listpool); */
	  eliminate[k] = true;
	  eliminatep = true;
	}
      } else {
	debug4(printf("One used already so eliminating all but #%d\n",usedi));
	for (k = i; k < j; k++) {
	  if (k != usedi) {
	    y = hits[k];
	    /* transfer_transcripts(x,y,listpool); */
	    eliminate[k] = true;
	    eliminatep = true;
	  }
	}
      }
    }

    i = j;
  }
    

#if 0
  nkept = 0;
  for (i = 0; i < nhits; i++) {
    if (eliminate[i] == false) {
      nkept++;
    }
  }
  if (nkept == 0) {
    /* All entries eliminated one another, so keep the first one */
    eliminate[0] = false;
  }
#endif

  if (eliminatep == false) {
    debug4(printf("No eliminations, so hits are unchanged\n"));
    unique = hits;
    *nunique = nhits;

  } else {
    /* Caller needs (*nunique)+1, but since we are guaranteed to have one elimination, nhits will suffice */
    out = unique = (T *) MALLOC(nhits*sizeof(T));

    for (i = nhits-1; i >= 0; i--) {
      x = hits[i];
      if (eliminate[i] == false) {
#ifdef DEBUG4
	printf("  Keeping %d..%d, #%d:%u..%u, score %d, nmatches %d (nindels %d, chrnum %d) (plusp = %d, sensedir = %d) ",
	       x->querystart_trimmed,x->queryend_trimmed,
	       x->chrnum,x->genomicstart - x->chroffset,x->genomicend - x->chroffset,
	       x->refalt_score_within_trims,x->refalt_nmatches_plus_spliced_trims,x->nindels,x->chrnum,x->plusp,x->sensedir);
	Stage3end_print_substrings(x);
	Transcript_print_nums(x->transcripts_consistent);
	Transcript_print_nums(x->transcripts_inconsistent);
	printf("\n");
#endif
	*out++ = x;

      } else {
#ifdef DEBUG4
	printf("  Eliminating hit %p %d..%d, #%d:%u..%u, score %d, nmatches %d (nindels %d, chrnum %d) (plusp = %d, sensedir = %d) ",
	       x,x->querystart_trimmed,x->queryend_trimmed,
	       x->chrnum,x->genomicstart - x->chroffset,x->genomicend - x->chroffset,
	       x->refalt_score_within_trims,x->refalt_nmatches_plus_spliced_trims,x->nindels,x->chrnum,x->plusp,x->sensedir);
	Stage3end_print_substrings(x);
	Transcript_print_nums(x->transcripts_consistent);
	Transcript_print_nums(x->transcripts_inconsistent);
	printf("\n");
#endif
	/* Stage3end_free(&x); -- Cannot free, because newladder and ladder might share this hit */
	*duplicates = Hitlist_push(*duplicates,hitlistpool,(void *) x);
      }
    }

    *nunique = out - unique;
    FREE(hits);
  }

  FREE(eliminate);

#ifdef DEBUG4
  for (i = 0; i < *nunique; i++) {
    x = unique[i];
    printf("  Final %d: %d..%d, #%d:%u..%u (plusp = %d, sensedir = %d) ",
	   i,x->querystart_trimmed,x->queryend_trimmed,
	   x->chrnum,x->genomicstart - x->chroffset,x->genomicend - x->chroffset,x->plusp,x->sensedir);
    Stage3end_print_substrings(x);
    Transcript_print_nums(x->transcripts_consistent);
    Transcript_print_nums(x->transcripts_inconsistent);
    printf("\n");
  }
#endif

  debug4(printf("Exited Stage3end_remove_duplicates_array with %d hits\n",*nunique));
  return unique;
}



#if 0
static bool
extra_ambiguous_ends_p (List_T substrings) {
  int nambiguous;
  List_T p;

  p = substrings;
  nambiguous = 0;
  while (Substring_ambiguous_p((Substring_T) List_head(p)) == true) {
    p = List_next(p);
    nambiguous += 1;
  }
  if (nambiguous > 1) {
    return true;
  }

  substrings = List_reverse(substrings);

  p = substrings;
  nambiguous = 0;
  while (Substring_ambiguous_p((Substring_T) List_head(p)) == true) {
    p = List_next(p);
    nambiguous += 1;
  }

  substrings = List_reverse(substrings);

  if (nambiguous > 1) {
    return true;
  } else {
    return false;
  }
}
#endif


/* Used for eliminating exact duplicates.  Also sorts secondarily by hittype. */
static int
hit_sort_cmp (const void *a, const void *b) {
  Stage3end_T x = * (Stage3end_T *) a;
  Stage3end_T y = * (Stage3end_T *) b;
  
  debug4(printf("Comparing %s: %d..%d, #%d:%u..%u, circularalias %d, nmatches %d (%d to_trims), score %d with %s: %d..%d, #%d:%u..%u, circularalias %d, nmatches %d (%d to_trims), score %d\n",
		Method_string(x->method),x->querystart_trimmed,x->queryend_trimmed,
		x->chrnum,x->genomicstart-x->chroffset,x->genomicend-x->chroffset,
		x->circularalias,x->refalt_nmatches_plus_spliced_trims,x->refalt_nmatches_to_trims,x->refalt_score_within_trims,
		Method_string(y->method),y->querystart_trimmed,y->queryend_trimmed,
		y->chrnum,y->genomicstart-y->chroffset,y->genomicend-y->chroffset,
		y->circularalias,y->refalt_nmatches_plus_spliced_trims,x->refalt_nmatches_to_trims,y->refalt_score_within_trims));

  if (altlocp[x->chrnum] == true && altlocp[y->chrnum] == true) {
    if (alias_ends[y->chrnum] >= alias_starts[x->chrnum] &&
	alias_starts[y->chrnum] <= alias_ends[x->chrnum]) {
      /* The primary regions overlap */
      return 0;
    } else if (alias_starts[x->chrnum] < alias_starts[y->chrnum]) {
      return -1;
    } else if (alias_starts[y->chrnum] < alias_starts[x->chrnum]) {
      return +1;
    } else if (alias_ends[x->chrnum] < alias_ends[y->chrnum]) {
      return -1;
    } else if (alias_ends[y->chrnum] < alias_ends[x->chrnum]) {
      return +1;
    } else {
      return 0;
    }

  } else if (altlocp[x->chrnum] == true) {
    if (y->genomicend >= alias_starts[x->chrnum] &&
	y->genomicstart <= alias_ends[x->chrnum]) {
      /* y overlaps with the primary region for x */
      return +1;		/* Put primary region first */
    }
    /* Don't overlap, so fall through to rest of procedure */

  } else if (altlocp[y->chrnum] == true) {
    if (alias_ends[y->chrnum] >= x->genomicstart &&
	alias_starts[y->chrnum] <= x->genomicend) {
      /* x overlaps with the primary region for y */
      return -1;		/* Put primary region first */
    }
    /* Don't overlap, so fall through to rest of procedure */
  }


  if (x->plusp > y->plusp) {
    return -1;
  } else if (y->plusp > x->plusp) {
    return +1;

  } else if (x->low_chrbound < y->low_chrbound) {
    debug4(printf("Returning -1 for low\n"));
    return -1;
  } else if (y->low_chrbound < x->low_chrbound) {
    debug4(printf("Returning +1 for low\n"));
    return +1;

  } else if (x->high_chrbound < y->high_chrbound) {
    debug4(printf("Returning -1 for high\n"));
    return -1;
  } else if (y->high_chrbound < x->high_chrbound) {
    debug4(printf("Returning +1 for high\n"));
    return +1;

    /* We want to maximizing trimming here to be consistent with transcripts */
  } else if (x->queryend_trimmed - x->querystart_trimmed <
	     y->queryend_trimmed - y->querystart_trimmed) {
    debug4(printf(" => loses by trimming\n"));
    return -1;
  } else if (y->queryend_trimmed - y->querystart_trimmed <
	     x->queryend_trimmed - x->querystart_trimmed) {
    debug4(printf(" => wins by trimming\n"));
    return +1;

  } else if (x->refalt_score_within_trims < y->refalt_score_within_trims) {
    return -1;
  } else if (y->refalt_score_within_trims < x->refalt_score_within_trims) {
    return +1;
  } else if (x->refalt_nmatches_plus_spliced_trims > y->refalt_nmatches_plus_spliced_trims) {
    return -1;
  } else if (y->refalt_nmatches_plus_spliced_trims > x->refalt_nmatches_plus_spliced_trims) {
    return +1;
  } else if (x->ref_nmatches_plus_spliced_trims > y->ref_nmatches_plus_spliced_trims) {
    return -1;
  } else if (y->ref_nmatches_plus_spliced_trims > x->ref_nmatches_plus_spliced_trims) {
    return +1;

  } else if (x->altlocp < y->altlocp) {
    return -1;
  } else if (y->altlocp < x->altlocp) {
    return +1;


  } else if (x->sensedir != 0 && y->sensedir == 0) {
    return -1;
  } else if (y->sensedir != 0 && x->sensedir == 0) {
    return +1;

  } else if (x->splice_score > y->splice_score) {
    debug4(printf(" => loses by splice score\n"));
    return -1;
  } else if (y->splice_score > x->splice_score) {
    debug4(printf(" => wins by splice score\n"));
    return +1;

    /* Prioritize first method used */
  } else if (x->method < y->method) {
    return -1;
  } else if (y->method < x->method) {
    return +1;

  } else {
    debug4(printf("Returning 0 for equivalent\n"));
    return 0;
  }
}



#if 0
/* Same as hit_sort_cmp, except for hittype, nmatches_to_trims, and indel_low */
static int
hit_equiv_cmp (Stage3end_T x, Stage3end_T y) {

  if (altlocp[x->chrnum] == true && altlocp[y->chrnum] == true) {
    if (alias_ends[y->chrnum] >= alias_starts[x->chrnum] &&
	alias_starts[y->chrnum] <= alias_ends[x->chrnum]) {
      /* The primary regions overlap */
      return 0;
    }

  } else if (altlocp[x->chrnum] == true) {
    if (y->genomicend >= alias_starts[x->chrnum] &&
	y->genomicstart <= alias_ends[x->chrnum]) {
      /* y overlaps with the primary region for x */
      return 0;
    }

  } else if (altlocp[y->chrnum] == true) {
    if (alias_ends[y->chrnum] >= x->genomicstart &&
	alias_starts[y->chrnum] <= x->genomicend) {
      /* x overlaps with the primary region for y */
      return 0;
    }
  }

  if (x->plusp > y->plusp) {
    return -1;
  } else if (y->plusp > x->plusp) {
    return +1;
  } else if (x->low_chrbound < y->low_chrbound) {
    return -1;
  } else if (y->low_chrbound < x->low_chrbound) {
    return +1;
  } else if (x->high_chrbound < y->high_chrbound) {
    return +1;
  } else if (y->high_chrbound < x->high_chrbound) {
    return -1;

  } else if (x->refalt_score_within_trims < y->refalt_score_within_trims) {
    return -1;
  } else if (y->refalt_score_within_trims < x->refalt_score_within_trims) {
    return +1;
  } else if (x->refalt_nmatches_plus_spliced_trims > y->refalt_nmatches_plus_spliced_trims) {
    return -1;
  } else if (y->refalt_nmatches_plus_spliced_trims > x->refalt_nmatches_plus_spliced_trims) {
    return +1;
  } else if (x->ref_nmatches_plus_spliced_trims > y->ref_nmatches_plus_spliced_trims) {
    return -1;
  } else if (y->ref_nmatches_plus_spliced_trims > x->ref_nmatches_plus_spliced_trims) {
    return +1;

#if 0
    /* Causes hits to not be recognized as equivalent */
  } else if (x->nsplices < y->nsplices) {
    return -1;
  } else if (y->nsplices < x->nsplices) {
    return +1;
#endif

#if 0
  } else if (y->start_amb_length + y->end_amb_length == 0 &&
	     x->start_amb_length + x->end_amb_length > 0) {
    return -1;
  } else if (x->start_amb_length + x->end_amb_length == 0 &&
	     y->start_amb_length + y->end_amb_length > 0) {
    return +1;
#endif

#if 0
  } else if (x->indel_low < y->indel_low) {
    return -1;
  } else if (y->indel_low < x->indel_low) {
    return +1;
#endif

#if 0
    /* Used for sorting but not equiv */
  } else if (x->sensedir != 0 && y->sensedir == 0) {
    return -1;
  } else if (y->sensedir != 0 && x->sensedir == 0) {
    return +1;
#endif

#if 0
  } else if (x->sensedir == y->sensedir) {
    return 0;
  } else if (x->sensedir > y->sensedir) {
    return +1;
  } else if (y->sensedir > x->sensedir) {
    return -1;
#endif

  } else if (x->splice_score > y->splice_score) {
    debug4(printf(" => loses by splice score\n"));
    return -1;

  } else if (y->splice_score > x->splice_score) {
    debug4(printf(" => wins by splice score\n"));
    return +1;

  } else {
    debug4(printf(" => identical for sorting purposes\n"));
    return 0;
  }
}
#endif


int
Stage3end_hit_goodness_cmp (bool *equalp, Stage3end_T hit,
			    Stage3end_T best_hit, bool finalp) {
  double prob1, prob2;

#ifdef PRE_RESOLVE_MULTIMAPPING
  if (Stage3end_tally(x) > TALLY_RATIO*Stage3end_tally(y)) {
    debug4(printf("  #%d overlaps #%d and tally %ld > %f*%ld, so marking %d for elimination\n",
		  i,j,x->tally,TALLY_RATIO,y->tally,j));
    eliminate[j] = true;
  } else if (Stage3end_tally(y) > TALLY_RATIO*Stage3end_tally(x)) {
    debug4(printf("  #%d overlaps #%d and tally %f*%ld < %ld, so marking %d for elimination\n",
		  i,j,TALLY_RATIO,x->tally,y->tally,i));
    eliminate[i] = true;
  }
#endif

  *equalp = false;

#if 0
  /* Don't want to use nmatches_to_trims */
  /* Favors definitive splices over ambiguous ones (by using nmatches_to_trims) */
  if (known_ambiguous_p(hit) == true && known_ambiguous_p(best_hit) == false) {
    return -1;
  } else if (known_ambiguous_p(hit) == false && known_ambiguous_p(best_hit) == true) {
    return +1;
  }
#endif

  if (hit->refalt_nmatches_plus_spliced_trims > best_hit->refalt_nmatches_plus_spliced_trims + NMATCHES_SLOP) {
    /* Significantly more matches */
    debug4(printf("More matches (to_trims)\n"));
    return +1;
  } else if (hit->refalt_nmatches_plus_spliced_trims < best_hit->refalt_nmatches_plus_spliced_trims - NMATCHES_SLOP) {
    /* Significantly fewer matches */
    debug4(printf("Fewer matches (to_trims)\n"));
    return -1;

#if 0
  } else if (hit->nsplices > best_hit->nsplices) {
    debug4(printf("  => loses by nsplices: %d > %d in best\n",hit->nsplices,best_hit->nsplices));
    return -1;
  } else if (hit->nsplices < best_hit->nsplices) {
    debug4(printf("  => wins by nsplices: %d < %d in best\n",hit->nsplices,best_hit->nsplices));
    return +1;
#endif

  } else if (hit->hittype > best_hit->hittype) {
    debug4(printf("  => loses by hittype\n"));
    return -1;
  } else if (hit->hittype < best_hit->hittype) {
    debug4(printf("  => wins by hittype\n"));
    return +1;

#if 0
  } else if (start_amb_length(hit) + end_amb_length(hit) > 0 &&
	     start_amb_length(best_hit) + end_amb_length(best_hit) == 0) {
    debug4(printf("  => loses by ambiguity\n"));
    return -1;
  } else if (start_amb_length(hit) + end_amb_length(hit) == 0 &&
	     start_amb_length(best_hit) + end_amb_length(best_hit) > 0) {
    debug4(printf("  => wins by ambiguity\n"));
    return +1;
#endif

  } else if (hit->nindels > best_hit->nindels) {
    debug4(printf("  => loses by nindels\n"));
    return -1;
  } else if (hit->nindels < best_hit->nindels) {
    debug4(printf("  => wins by nindels\n"));
    return +1;

  } else if (hit->distant_splice_i >= 0 && best_hit->distant_splice_i < 0) {
    debug4(printf("  => loses because distant splice\n"));
    return -1;
  } else if (hit->distant_splice_i < 0 && best_hit->distant_splice_i >= 0) {
    debug4(printf("  => wins because not distant splice\n"));
    return +1;

  } else if (finalp == false) {
    debug4(printf("  => indistinguishable\n"));
    return 0;

  } else if (hit->hittype == TRANSLOC_SPLICE && best_hit->hittype == TRANSLOC_SPLICE) {
    prob1 = hit->splice_score;
    prob2 = best_hit->splice_score;

    if (prob1 < prob2) {
      debug4(printf("  => loses by TRANSLOC_SPLICE splice prob %f vs %f\n",prob1,prob2));
      return -1;
    } else if (prob1 > prob2) {
      debug4(printf("  => wins by TRANSLOC_SPLICE splice prob %f vs %f\n",prob1,prob2));
      return +1;
    } else {
      debug4(printf("  => equal\n"));
      *equalp = true;
      return 0;
    }

  } else {
    prob1 = Stage3end_prob(hit);
    prob2 = Stage3end_prob(best_hit);
    if (prob1 < prob2) {
      debug4(printf("  => loses by splice prob %f vs %f\n",prob1,prob2));
      return -1;
    } else if (prob1 > prob2) {
      debug4(printf("  => wins by splice prob %f vs %f\n",prob1,prob2));
      return +1;
    }

    if (hit->genomiclength > best_hit->genomiclength) {
      debug4(printf("  => loses by genomiclength: %u > %u\n",
		    hit->genomiclength,best_hit->genomiclength));
      return -1;
    } else if (hit->genomiclength < best_hit->genomiclength) {
      debug4(printf("  => wins by genomiclength: %u < %u\n",
		    hit->genomiclength,best_hit->genomiclength));
      return +1;

    } else {
      debug4(printf("  => equal\n"));
      *equalp = true;
      return 0;
    }
  }
}


/* Not clear how to handle altloc */
static bool
hit_subsumption (Stage3end_T x, Stage3end_T y) {
  if (x->chrnum != y->chrnum) {
    /* Previously true for straddles, but then corrected that issue */
    /* Now potentially true for lefts below 0 */
    return false;
  } else if (x->plusp != y->plusp) {
    return false;		/* Different strands */
  } else if (x->low_chrbound <= y->low_chrbound && x->high_chrbound >= y->high_chrbound) {
    return true;
  } else if (y->low_chrbound <= x->low_chrbound && y->high_chrbound >= x->high_chrbound) {
    return true;
  } else {
    return false;
  }
}

/* Not clear how to handle altloc */
static bool
hit_endpoint_equivp (Stage3end_T x, Stage3end_T y) {
  if (x->plusp != y->plusp) {
    return false;		/* Different strands */
  } else if (x->genomicstart != y->genomicstart) {
    return false;
  } else if (x->genomicend != y->genomicend) {
    return false;
  } else {
    return true;
  }
}


static bool
hit_bad_superstretch_p (Stage3end_T hit_k, Stage3end_T *hits, int k, int j, bool finalp) {
  int a;
  bool equalp;

  for (a = k+1; a <= j; a++) {
    if (hit_subsumption(hit_k,hits[a]) == true) {
      debug4(printf("Testing %d because stretches over %d",k,a));
      if (Stage3end_hit_goodness_cmp(&equalp,hits[a],hit_k,finalp) > 0 || equalp == true) {
	debug4(printf(" => eliminating\n"));
	return true;
      }
      debug4(printf("\n"));
    }
  }
  return false;
}


static List_T
remove_overlaps_distant (List_T hitlist, Hitlistpool_T hitlistpool) {
  List_T unique = NULL;
  T best_hit, hit, *hits;
  int cmp;
  int n, i, j, k, besti;
  bool *eliminate, equalp;
#ifdef PRE_RESOLVE_MULTIMAPPING
  long int best_tally;
#endif

  if ((n = List_length(hitlist)) == 0) {
    return (List_T) NULL;
  } else {
#ifdef USE_ALLOCA_FOR_HITS
    eliminate = (bool *) CALLOCA(n,sizeof(bool));
    hits = (T *) MALLOCA(n * sizeof(T));
    List_fill_array((void **) hits,hitlist);
    Hitlist_free(&hitlist);
#else
    eliminate = (bool *) CALLOC(n,sizeof(bool));
    hits = (T *) List_to_array(hitlist,NULL);
    Hitlist_free(&hitlist);
#endif
  }

  debug4(printf("Step 0.  Checking for duplicates among distant\n"));
  qsort(hits,n,sizeof(Stage3end_T),hit_sort_cmp);

  /* Find clusters from left */
  i = 0;
  while (i < n) {
    j = i;
    while (j+1 < n && hit_endpoint_equivp(hits[i],hits[j+1]) == true) {
      j = j+1;
    }

    if (j > i) {
      debug4(printf("Cluster from %d up through %d\n",i,j));

      best_hit = hits[i];
      besti = i;
      debug4(printf("Assume best is %d\n",besti));

      for (k = i+1; k <= j; k++) {
	cmp = Stage3end_hit_goodness_cmp(&equalp,hits[k],best_hit,/*finalp*/true);
	debug4(printf("Comparison of %d with best %d yields %d\n",k,besti,cmp));
	if (cmp > 0) {
	  best_hit = hits[k];
	  besti = k;
	  debug4(printf("Best is now %d\n",besti));
	}
      }

      for (k = i; k <= j; k++) {
	if (k == besti) {
	  /* Skip */
	} else if (Stage3end_hit_goodness_cmp(&equalp,hits[k],best_hit,/*finalp*/true) < 0 || equalp == true) {
	  debug4(printf("  Eliminating hit %d from left, because beaten by %d\n",k,besti));
	  eliminate[k] = true;
	}
      }
    }
      
    i = j+1;
  }

  for (i = n-1; i >= 0; i--) {
    hit = hits[i];
    if (eliminate[i] == false) {
      unique = Hitlist_push(unique,hitlistpool,(void *) hit);
    } else if (hit->paired_usedp == true) {
      unique = Hitlist_push(unique,hitlistpool,(void *) hit);
    } else {
      Stage3end_free(&hit);
    }
  }

#ifdef USE_ALLOCA_FOR_HITS
  FREEA(hits);
  FREEA(eliminate);
#else
  FREE(hits);
  FREE(eliminate);
#endif

  debug4(printf("Returning %d unique distant splices\n",List_length(unique)));
  return unique;
}


/* Tries to match Stage3pair_remove_overlaps */
List_T
Stage3end_remove_overlaps (List_T hitlist, Hitlistpool_T hitlistpool,
			   int querylength, bool finalp) {
  List_T optimal, distant = NULL, local = NULL, p;
  /* T besthit; -- Needed only when we transferred transcripts */
  T hit, *hits, *prev;

  int best_querylength, best_nmatches_to_trims, best_nsegments;
  double max_splice_score;

  int nkept, n, i, j, k;
  bool *eliminate, keptp;
#ifdef PRE_RESOLVE_MULTIMAPPING
  long int best_tally;
#endif

  
  debug4(printf("Entered Stage3end_remove_overlaps with %d hits: %s\n",
		List_length(hitlist),finalp == true ? "FINAL" : "not final"));

  for (p = hitlist; p != NULL; p = List_next(p)) {
    hit = (T) List_head(p);
    if (hit->distant_splice_i < 0) {
      local = Hitlist_push(local,hitlistpool,(void *) hit);
    } else {
      distant = Hitlist_push(distant,hitlistpool,(void *) hit);
    }
  }
  Hitlist_free(&hitlist);
  
  distant = remove_overlaps_distant(distant,hitlistpool);

  if ((n = List_length(local)) == 0) {
    return distant;
  } else {
#ifdef USE_ALLOCA_FOR_HITS
    eliminate = (bool *) CALLOCA(n,sizeof(bool));
    hits = (T *) MALLOCA(n * sizeof(T));
    List_fill_array((void **) hits,local);
    Hitlist_free(&local);
#else
    eliminate = (bool *) CALLOC(n,sizeof(bool));
    hits = (T *) List_to_array(local,NULL);
    Hitlist_free(&local);
#endif
  }
  /* local alignments are in hits, but distant alignments are in distant */


  /* Step 1.  Check for exact duplicates */
  /* Probably don't want to eliminate aliases at this point */
  debug4(printf("Step 1.  Checking for exact duplicates\n"));
  qsort(hits,n,sizeof(Stage3end_T),hit_sort_cmp);

  debug4(
	 for (i = 0; i < n; i++) {
	   hit = hits[i];
	   printf("  Initial %d (%s): %p %d..%d, #%d:%u..%u, circularalias %d, nmatches %d (%d to_trims), score %d",
		  i,Method_string(hit->method),hit,
		  hit->querystart_trimmed,hit->queryend_trimmed,
		  hit->chrnum,hit->genomicstart-hit->chroffset,hit->genomicend-hit->chroffset,
		  hit->circularalias,hit->refalt_nmatches_plus_spliced_trims,hit->refalt_nmatches_to_trims,hit->refalt_score_within_trims);
	   Transcript_print_list_debug(hit->transcripts_consistent);
	   Transcript_print_list_debug(hit->transcripts_inconsistent);
	   printf("\n");
	 }
	 );

  i = 0;
  while (i < n) {
    j = i+1;
    debug4(printf(" %d,%d",i,j));
    while (j < n && hit_equal(hits[j],hits[i]) == true) {
      debug4(printf("  %d is identical to %d => eliminating\n",j,i));
      eliminate[j] = true;
      j++;
    }
    i = j;
  }
  debug4(printf("\n"));


  nkept = 0;
  for (i = 0; i < n; i++) {
    if (eliminate[i] == false) {
      nkept++;
    } else if (hits[i]->paired_usedp == true) {
      nkept++;
    }
  }
  if (nkept == 0) {
    /* All entries eliminated one another, so keep the first one */
    eliminate[0] = false;
    nkept = 1;
  }

  prev = hits;
#ifdef USE_ALLOCA_FOR_HITS
  hits = (Stage3end_T *) MALLOCA(nkept * sizeof(Stage3end_T));
#else
  hits = (Stage3end_T *) MALLOC(nkept * sizeof(Stage3end_T));
#endif

  for (i = 0, j = 0; i < n; i++) {
    hit = prev[i];
    if (eliminate[i] == false) {
      debug4(printf("  Keeping %d..%d, #%d:%u..%u, nmatches (trimmed) %d (plusp = %d, sensedir = %d)\n",
		    hit->querystart_trimmed,hit->queryend_trimmed,
hit->chrnum,hit->low_trimmed - hit->chroffset,hit->high_trimmed - hit->chroffset,hit->refalt_nmatches_plus_spliced_trims,
		    hit->plusp,hit->sensedir));
      /* besthit = */ hits[j++] = hit;
    } else if (hit->paired_usedp == true) {
      debug4(printf("  Already paired %d..%d, #%d:%u..%u, nmatches (trimmed) %d (plusp = %d, sensedir = %d)\n",
		    hit->querystart_trimmed,hit->queryend_trimmed,
		    hit->chrnum,hit->low_trimmed - hit->chroffset,hit->high_trimmed - hit->chroffset,hit->refalt_nmatches_plus_spliced_trims,
		    hit->plusp,hit->sensedir));
      hits[j++] = hit;
    } else {
      debug4(printf("  Eliminating hit %p %d..%d, #%d:%u..%u, nmatches (trimmed) %d (plusp = %d, sensedir = %d)\n",
		    hit,hit->querystart_trimmed,hit->queryend_trimmed,
		    hit->chrnum,hit->low_trimmed - hit->chroffset,hit->high_trimmed - hit->chroffset,hit->refalt_nmatches_plus_spliced_trims,
		    hit->plusp,hit->sensedir));
      /* transfer_transcripts(besthit,hit,listpool); */
      Stage3end_free(&hit);
    }
  }

#ifdef USE_ALLOCA_FOR_HITS
  FREEA(prev);
#else
  FREE(prev);
#endif


  /* Step 2: Check for superstretches */
  hitlist = (List_T) NULL;
  n = nkept;
  debug4(printf("Step 2.  Checking for superstretches among %d hits within subsumption clusters\n",n));

  for (i = 0; i < n; i++) {
    eliminate[i] = false;
  }

  debug4(
	 for (i = 0; i < n; i++) {
	   hit = hits[i];
	   printf("  Initial %d (%s): %p %d..%d, #%d:%u..%u, nmatches %d (%d to_trims), score %d",
		  i,Method_string(hit->method),hit,
		  hit->querystart_trimmed,hit->queryend_trimmed,
		  hit->chrnum,hit->genomicstart-hit->chroffset,hit->genomicend-hit->chroffset,
		  hit->refalt_nmatches_plus_spliced_trims,hit->refalt_nmatches_to_trims,hit->refalt_score_within_trims);
	   Transcript_print_list_debug(hit->transcripts_consistent);
	   Transcript_print_list_debug(hit->transcripts_inconsistent);
	   printf("\n");
	 }
	 );

  /* Find clusters */
  i = 0;
  while (i < n) {
    j = i;
    /* Previously checked if (hits[i]->distant_splice_p == false) */
    while (j+1 < n && hit_subsumption(hits[i],hits[j+1]) == true) {
      j = j+1;
    }

    if (j > i) {
      debug4(printf("Cluster from %d up through %d\n",i,j));

      /* Find bad superstretches */
      for (k = i; k <= j; k++) {
	/* Previously checked if (hits[i]->distant_splice_p == false) */
	if (hit_bad_superstretch_p(hits[k],hits,k,j,finalp) == true) {
	  eliminate[k] = true;
	  /* parenti[k] = j; */
	}
      }
    }

    i = j+1;
  }

  nkept = 0;
  for (i = 0; i < n; i++) {
    if (eliminate[i] == false) {
      nkept++;
    } else if (hits[i]->paired_usedp == true) {
      nkept++;
    }
  }
  if (nkept == 0) {
    /* All entries eliminated one another, so keep the first one */
    eliminate[0] = false;
    nkept = 1;
  }


  for (i = 0, j = 0; i < n; i++) {
    hit = hits[i];
    if (eliminate[i] == false) {
      debug4(printf("  Keeping %d..%d, #%d:%u..%u, nmatches (trimmed) %d (plusp = %d, sensedir = %d)\n",
		    hit->querystart_trimmed,hit->queryend_trimmed,
		    hit->chrnum,hit->low_trimmed - hit->chroffset,hit->high_trimmed - hit->chroffset,hit->refalt_nmatches_plus_spliced_trims,
		    hit->plusp,hit->sensedir));
      hitlist = Hitlist_push(hitlist,hitlistpool,(void *) hit);
    } else if (hit->paired_usedp == true) {
      debug4(printf("  Already paired %d..%d, #%d:%u..%u, nmatches (trimmed) %d (plusp = %d, sensedir = %d)\n",
		    hit->querystart_trimmed,hit->queryend_trimmed,
		    hit->chrnum,hit->low_trimmed - hit->chroffset,hit->high_trimmed - hit->chroffset,hit->refalt_nmatches_plus_spliced_trims,
		    hit->plusp,hit->sensedir));
      hitlist = Hitlist_push(hitlist,hitlistpool,(void *) hit);
    } else {
      debug4(printf("  Eliminating hit %p %d..%d, #%d:%u..%u, nmatches (trimmed) %d (plusp = %d, sensedir = %d)\n",
		    hit,hit->querystart_trimmed,hit->queryend_trimmed,
		    hit->chrnum,hit->low_trimmed - hit->chroffset,hit->high_trimmed - hit->chroffset,hit->refalt_nmatches_plus_spliced_trims,
		    hit->plusp,hit->sensedir));
      /* parent = prev[parenti[i]]; */
      /* Stage3end_transfer_transcripts_one(parent,hit); */
      Stage3end_free(&hit);
    }
  }

#ifdef USE_ALLOCA_FOR_HITS
  FREEA(hits);
  FREEA(eliminate);
#else
  FREE(hits);
  FREE(eliminate);
#endif


  /* Prune based on nmatches adjusted by score to get a tradeoff between matches and parsimony */
  /* Same as step 1 of Stage3pair_optimal_score_final */
  if (hitlist == NULL) {
    return (List_T) NULL;
  } else {
    optimal = (List_T) NULL;
  }
  

  debug8(printf("  Step 3.  Maximize querylength\n"));
  keptp = false;
  hits = (T *) List_to_array_n(&n,hitlist);
  eliminate = (bool *) CALLOC(n,sizeof(bool));
  qsort(hits,n,sizeof(T),hit_position_cmp);
  i = 0;
  while (i < n) {
    j = i+1;
    while (j < n && hit_overlap_p(hits[j],hits[i]) == true) {
      j++;
    }
    if (j - 1 > 1) {
      debug4(printf("Found a group from %d to %d\n",i,j));
      best_querylength = 0;
      for (k = i; k < j; k++) {
	hit = hits[k];
	if ((querylength = hit->queryend_trimmed - hit->querystart_trimmed) > best_querylength) {
	  best_querylength = querylength;
	  /* besthit = hit; */
	}
      }
      debug4(printf("best_querylength %d\n",best_querylength));
      
      for (k = i; k < j; k++) {
	hit = hits[k];
	if (hit->queryend_trimmed - hit->querystart_trimmed < best_querylength) {
	  debug4(printf("Within loci end: Eliminating hit %p at %d..%d, %u..%u with nmatches %d (%d+ to trims) and querylength %d\n",
			hit,hit->querystart_trimmed,hit->queryend_trimmed,
			hit->low_trimmed - hit->chroffset,hit->high_trimmed - hit->chroffset,
			hit->refalt_nmatches_plus_spliced_trims,hit->refalt_nmatches_to_trims,
			hit->queryend_trimmed - hit->querystart_trimmed));
			eliminate[k] = true;
	} else {
	  debug4(printf("Within loci end: Keeping hit %p at %d..%d, %u..%u with nmatches %d (%d+ to trims) and querylength %d\n",
			hit,hit->querystart_trimmed,hit->queryend_trimmed,
			hit->low_trimmed - hit->chroffset,hit->high_trimmed - hit->chroffset,
			hit->refalt_nmatches_plus_spliced_trims,hit->refalt_nmatches_to_trims,
			hit->queryend_trimmed - hit->querystart_trimmed));
	  keptp = true;
	}
      }
    }

    i = j;
  }
  
  if (keptp == false) {
    optimal = hitlist;
  } else {
    for (k = 0; k < n; k++) {
      hit = hits[k];
      if (eliminate[k] == true) {
	debug4(printf("Within loci end: Eliminating hit %p at %d..%d, %u..%u with nsegments %d, nmatches %d (%d to_trims), sensedir %d, splice score %f\n",
		      hit,hit->querystart_trimmed,hit->queryend_trimmed,
		      hit->low_trimmed - hit->chroffset,hit->high_trimmed - hit->chroffset,
		      hit->nsegments,
		      hit->refalt_nmatches_plus_spliced_trims,hit->refalt_nmatches_to_trims,
		      hit->sensedir,hit->splice_score));
	/* transfer_transcripts(besthit,hit,listpool); */
	Stage3end_free(&hit);
	/* eliminatedp = true; */
      } else {
	optimal = Hitlist_push(optimal,hitlistpool,(void *) hit);
      }
    }
    Hitlist_free(&hitlist);
  }
  FREE(hits);
  FREE(eliminate);
  if ((hitlist = optimal) == NULL) {
    return (List_T) NULL;
  } else {
    optimal = (List_T) NULL;
  }
  

  debug4(printf("  Step 4.  Maximize best_nmatches_to_trims\n"));

  keptp = false;
  hits = (T *) List_to_array_n(&n,hitlist);
  eliminate = (bool *) CALLOC(n,sizeof(bool));
  qsort(hits,n,sizeof(T),hit_position_cmp);
  i = 0;
  while (i < n) {
    j = i+1;
    while (j < n && hit_overlap_p(hits[j],hits[i]) == true) {
      j++;
    }
    if (j - 1 > 1) {
      debug4(printf("Found a group from %d to %d\n",i,j));
      best_nmatches_to_trims = 0;
      for (k = i; k < j; k++) {
	hit = hits[k];
	if (hit->refalt_nmatches_to_trims - hit->nindels > best_nmatches_to_trims) {
	  best_nmatches_to_trims = hit->refalt_nmatches_to_trims - hit->nindels;
	  /* besthit = hit; */
	}
      }
      debug4(printf("best_nmatches_to_trims = %d\n",best_nmatches_to_trims));
      
      for (k = i; k < j; k++) {
	hit = hits[k];
	if (hit->refalt_nmatches_to_trims - hit->nindels < best_nmatches_to_trims) {
	  debug4(printf("Within loci end: Eliminating hit %p at %d..%d, %u..%u with nmatches %d (%d+ to trims)\n",
			hit,hit->querystart_trimmed,hit->queryend_trimmed,
			hit->low_trimmed - hit->chroffset,hit->high_trimmed - hit->chroffset,
			hit->refalt_nmatches_plus_spliced_trims,hit->refalt_nmatches_to_trims));
	  eliminate[k] = true;
	} else {
	  debug4(printf("Within loci end: Keeping hit %p at %d..%d, %u..%u with nmatches %d (%d+ to trims)\n",
			hit,hit->querystart_trimmed,hit->queryend_trimmed,
			hit->low_trimmed - hit->chroffset,hit->high_trimmed - hit->chroffset,
			hit->refalt_nmatches_plus_spliced_trims,hit->refalt_nmatches_to_trims));
	  keptp = true;
	}
      }
    }

    i = j;
  }
  
  if (keptp == false) {
    optimal = hitlist;
  } else {
    for (k = 0; k < n; k++) {
      hit = hits[k];
      if (eliminate[k] == true) {
	debug4(printf("Within loci end: Eliminating hit %p at %d..%d, %u..%u with nsegments %d, nmatches %d (%d to_trims), sensedir %d, splice score %f\n",
		      hit,hit->querystart_trimmed,hit->queryend_trimmed,
		      hit->low_trimmed - hit->chroffset,hit->high_trimmed - hit->chroffset,
		      hit->nsegments,
		      hit->refalt_nmatches_plus_spliced_trims,hit->refalt_nmatches_to_trims,
		      hit->sensedir,hit->splice_score));
	/* transfer_transcripts(besthit,hit,listpool); */
	Stage3end_free(&hit);
	/* eliminatedp = true; */
      } else {
	optimal = Hitlist_push(optimal,hitlistpool,(void *) hit);
      }
    }
    Hitlist_free(&hitlist);
  }
  FREE(hits);
  FREE(eliminate);
  if ((hitlist = optimal) == NULL) {
    return (List_T) NULL;
  } else {
    optimal = (List_T) NULL;
  }


  /* Eliminate within loci: minimize nsegments and maximize splice score */
  /* Since we have achieved same number of matches, we should minimize nsegments to achieve parsimony */
  debug4(printf("  Step 5.  Minimize nsegments and splice score\n"));

  keptp = false;
  hits = (T *) List_to_array_n(&n,hitlist);
  eliminate = (bool *) CALLOC(n,sizeof(bool));
  qsort(hits,n,sizeof(T),hit_position_cmp);
  i = 0;
  while (i < n) {
    j = i+1;
    while (j < n && hit_overlap_p(hits[j],hits[i]) == true) {
      j++;
    }
    if (j - 1 > 1) {
      debug4(printf("Found a group from %d to %d\n",i,j));
      best_nsegments = querylength;
      max_splice_score = 0.0;
      for (k = i; k < j; k++) {
	hit = hits[k];
	if (hit->nsegments < best_nsegments) {
	  best_nsegments = hit->nsegments;
	  max_splice_score = hit->splice_score;
	  /* besthit = hit; */
	} else if (hit->nsegments == best_nsegments) {
	  max_splice_score = hit->splice_score;
	  /* besthit = hit; */
	}
      }
      debug4(printf("best_nsegments %d, max_splice_score %f\n",
		    best_nsegments,max_splice_score));
      
      for (k = i; k < j; k++) {
	hit = hits[k];
	if (hit->nsegments > best_nsegments) {
	  debug4(printf("Within loci end (nsegments %d < %d): Marking hit %p for elimination at %d..%d, %u..%u with nsegments %d, nmatches %d (%d to_trims), sensedir %d, splice score %f\n",
			hit->nsegments,best_nsegments,hit,
			hit->querystart_trimmed,hit->queryend_trimmed,
			hit->low_trimmed - hit->chroffset,hit->high_trimmed - hit->chroffset,
			hit->nsegments,hit->refalt_nmatches_plus_spliced_trims,
			hit->refalt_nmatches_to_trims,hit->sensedir,hit->splice_score));
	  eliminate[k] = true;
	} else if (hit->splice_score < max_splice_score - SPLICE_SCORE_SLOP) {
	  debug4(printf("Within loci end (splice_score w/slop %f < %f): Marking hit %p for elimination at %d..%d, %u..%u with nsegments %d, nmatches %d (%d to_trims), sensedir %d, splice score %f\n",
			hit->splice_score,max_splice_score,hit,
			hit->querystart_trimmed,hit->queryend_trimmed,
			hit->low_trimmed - hit->chroffset,hit->high_trimmed - hit->chroffset,
			hit->nsegments,hit->refalt_nmatches_plus_spliced_trims,
			hit->refalt_nmatches_to_trims,hit->sensedir,hit->splice_score));
	  eliminate[k] = true;
	} else {
	  keptp = true;
	}
      }
    }

    i = j;
  }
  
  if (keptp == false) {
    optimal = hitlist;
  } else {
    for (k = 0; k < n; k++) {
      hit = hits[k];
      if (eliminate[k] == true) {
	debug4(printf("Within loci end: Eliminating hit %p at %d..%d, %u..%u with nsegments %d, nmatches %d (%d to_trims), sensedir %d, splice score %f\n",
		      hit,hit->querystart_trimmed,hit->queryend_trimmed,
		      hit->low_trimmed - hit->chroffset,hit->high_trimmed - hit->chroffset,
		      hit->nsegments,
		      hit->refalt_nmatches_plus_spliced_trims,hit->refalt_nmatches_to_trims,
		      hit->sensedir,hit->splice_score));
	/* transfer_transcripts(besthit,hit,listpool); */
	Stage3end_free(&hit);
	/* eliminatedp = true; */
      } else {
	optimal = Hitlist_push(optimal,hitlistpool,(void *) hit);
      }
    }
    Hitlist_free(&hitlist);
  }
  FREE(hits);
  FREE(eliminate);
  hitlist = optimal;

  /* Step 6.  Removing outerlength not applicable to a single end */

  return List_append(hitlist,distant);
}



#ifdef PRE_RESOLVE_MULTIMAPPING
List_T
Stage3end_resolve_multimapping (List_T hits, Hitlistpool_T hitlistpool) {
  List_T resolve1, resolve2, resolve3, p;
  Stage3end_T hit;

  /* Overlap_T best_overlap; */
  long int best_tally;
  double tally_threshold;
  bool runlengthp;

  if (List_length(hits) <= 1) {
    return hits;
  }

  resolve1 = hits;

  if (tally_iit == NULL) {
    resolve2 = resolve1;
  } else {
    best_tally = 0L;
    for (p = resolve1; p != NULL; p = p->rest) {
      hit = (Stage3end_T) p->first;
      if ((hit->tally = Stage3end_compute_tally(hit)) > best_tally) {
	best_tally = hit->tally;
      }
    }
    if (best_tally == 0L) {
      resolve2 = resolve1;
    } else {
      resolve2 = (List_T) NULL;
#ifdef USE_TALLY_RATIO
      tally_threshold = (double) best_tally / TALLY_RATIO;
#else
      tally_threshold = 1.0;
#endif
      for (p = resolve1; p != NULL; p = p->rest) {
	hit = (Stage3end_T) p->first;
	if ((double) hit->tally < tally_threshold) {
	  Stage3end_free(&hit);
	} else {
	  resolve2 = Hitlist_push(resolve2,hitlistpool,(void *) hit);
	}
      }
      Hitlist_free(&resolve1);
    }
  }


  if (List_length(resolve2) <= 1) {
    return resolve2;
  }

  if (runlength_iit == NULL) {
    resolve3 = resolve2;
  } else {
    runlengthp = false;
    for (p = resolve2; p != NULL; p = p->rest) {
      hit = (Stage3end_T) p->first;
      if (Stage3end_runlength_p(hit) == true) {
	runlengthp = true;
      }
    }
    if (runlengthp == false) {
      resolve3 = resolve2;
    } else {
      resolve3 = (List_T) NULL;
      for (p = resolve2; p != NULL; p = p->rest) {
	hit = (Stage3end_T) p->first;
	if (Stage3end_runlength_p(hit) == false) {
	  Stage3end_free(&hit);
	} else {
	  resolve3 = Hitlist_push(resolve3,hitlistpool,(void *) hit);
	}
      }
      Hitlist_free(&resolve2);
    }
  }


  return resolve3;
}
#endif


/* pairtype can be CONCORDANT, CONCORDANT_TRANSLOCATIONS, PAIRED_INVERSION, PAIRED_SCRAMBLE, PAIRED_TOOLONG, UNPAIRED */
Pairtype_T
Stage3_determine_pairtype (T hit5, T hit3) {
  Univcoord_T genomicstart5, genomicend5, genomicstart3, genomicend3;
  Chrpos_T pairmax;

  debug14(printf("Entered Stage3_determine_pairtype\n"));
  if (hit5->distant_splice_i >= 0 || hit3->distant_splice_i >= 0) {
    debug14(printf("Returning translocations based on distant_splice_i\n"));
    return CONCORDANT_TRANSLOCATIONS;

  } else if (Transcript_concordant_p(hit5->transcripts_consistent,hit3->transcripts_consistent) == true) {
    debug14(printf("Returning concordant based on transcriptome\n"));
    return CONCORDANT;

  } else if (hit5->effective_chrnum != hit3->effective_chrnum) {
    debug14(printf("Returning unpaired\n"));
    return UNPAIRED;

  } else if (hit5->plusp != hit3->plusp) {
    debug14(printf("Returning paired_inversion\n"));
    return PAIRED_INVERSION;

  } else if (hit5->plusp == true) {
    genomicstart5 = hit5->genomicstart;
    genomicend5 = hit5->genomicend;
    genomicstart3 = hit3->genomicstart;
    genomicend3 = hit3->genomicend;

    if (hit5->circularalias == 0 && hit3->circularalias == 0) {
      /* Keep coordinates as is */
    } else if (hit5->circularalias == 0) {
      if (hit3->circularalias == -1) {
	debug14(printf("Have to alias hit3\n"));
	genomicstart3 += hit3->chrlength;
	genomicend3 += hit3->chrlength;
      }
    } else if (hit3->circularalias == 0) {
      if (hit5->circularalias == +1) {
	debug14(printf("Have to unalias hit5\n"));
	genomicstart5 -= hit5->chrlength;
	genomicend5 -= hit5->chrlength;
      }
    }

    if (genomicend3 < genomicstart5) {
      debug14(printf("(plus) hit3 genomicend %u < hit5 genomicstart %u => Returning paired_scramble\n",
		     hit3->genomicend,hit5->genomicstart));
      return PAIRED_SCRAMBLE;
    } else {
      if (circularp[hit5->effective_chrnum] == true) {
	pairmax = pairmax_circular;
      } else {
	pairmax = pairmax_linear;
      }

      if (genomicstart3 > genomicend5 + pairmax) {
	debug14(printf("Returning paired_toolong\n"));
	return PAIRED_TOOLONG;
      } else {
	debug14(printf("Returning concordant\n"));
	return CONCORDANT;
      }
    }

  } else {
    genomicstart5 = hit5->genomicstart;
    genomicend5 = hit5->genomicend;
    genomicstart3 = hit3->genomicstart;
    genomicend3 = hit3->genomicend;

    if (hit5->circularalias == 0 && hit3->circularalias == 0) {
      /* Keep coordinates as is */
    } else if (hit5->circularalias == 0) {
      if (hit3->circularalias == +1) {
	debug14(printf("Have to unalias hit3\n"));
	genomicstart3 -= hit3->chrlength;
	genomicend3 -= hit3->chrlength;
      }
    } else if (hit3->circularalias == 0) {
      if (hit5->circularalias == -1) {
	debug14(printf("Have to alias hit5\n"));
	genomicstart5 += hit5->chrlength;
	genomicend5 += hit5->chrlength;
      }
    }

    if (genomicend3 > genomicstart5) {
      debug14(printf("(minus) hit3 genomicend %u > hit5 genomicstart %u => Returning paired_scramble\n",
		     genomicend3,genomicstart5));
      return PAIRED_SCRAMBLE;
    } else {
      if (circularp[hit3->effective_chrnum] == true) {
	pairmax = pairmax_circular;
      } else {
	pairmax = pairmax_linear;
      }

      if (genomicstart3 + pairmax < genomicend5) {
	debug14(printf("Returning paired_toolong\n"));
	return PAIRED_TOOLONG;
      } else {
	debug14(printf("Returning concordant\n"));
	return CONCORDANT;
      }
    }
  }
}


Pairtype_T
Stage3pair_determine_pairtype (Stage3pair_T this) {
  return Stage3_determine_pairtype(this->hit5,this->hit3);
}

bool
Stage3pair_circularp (Stage3pair_T this) {
  return this->circularp;
}

bool
Stage3pair_altlocp (Stage3pair_T this) {
  if (altlocp[this->hit5->chrnum] == true) {
    return true;
  } else if (altlocp[this->hit3->chrnum] == true) {
    return true;
  } else {
    return false;
  }
}


#if 0
static char *
unpaired_type_text (T hit5, T hit3) {
  if (hit5->chrnum != hit3->chrnum) {
    return UNPAIRED_INTERCHROM_TEXT;
  } else if (hit5->plusp != hit3->plusp) {
    return PAIRED_INVERSION_TEXT;
  } else if (hit5->plusp == true) {
    if (hit3->genomicstart < hit5->genomicstart) {
      return PAIRED_SCRAMBLE_TEXT;
    } else {
      return UNPAIRED_TOOLONG_TEXT;
    }
  } else {
    if (hit5->genomicstart < hit3->genomicstart) {
      return PAIRED_SCRAMBLE_TEXT;
    } else {
      return UNPAIRED_TOOLONG_TEXT;
    }
  }
}
#endif




/* Has a copy in pair.c */
static void
print_pair_info (Filestring_T fp, Stage3pair_T stage3pair, int insertlength, int pairscore) {
  Pairtype_T pairtype;

  pairtype = Stage3pair_determine_pairtype(stage3pair);

#if 0
  assert(hit5->effective_chrnum == hit3->effective_chrnum); /* Same chromosomes */
  /* Doesn't hold for paired (inversion) */
  assert(hit5->plusp == hit3->plusp);	/* Same direction */
#endif

#ifndef NO_COMPARE
  FPRINTF(fp,"pair_score:%d",pairscore);
  FPRINTF(fp,",insert_length:%d",insertlength);
#endif

  switch (pairtype) {
  case CONCORDANT: break;
  case CONCORDANT_TRANSLOCATIONS: break;
  case PAIRED_INVERSION: FPRINTF(fp,",pairtype:inversion"); break;
  case PAIRED_SCRAMBLE: FPRINTF(fp,",pairtype:scramble"); break;
  case PAIRED_TOOLONG: FPRINTF(fp,",pairtype:toolong"); break;
  case UNPAIRED: abort();
  case PAIRED_UNSPECIFIED: abort(); /* Used only as an initial pairtype */
  case UNSPECIFIED: abort(); /* Used only as an initial pairtype */
  }

  return;
}




static void
print_substrings (Filestring_T fp, Stage3pair_T stage3pair, T this,
		  int score, Univ_IIT_T chromosome_iit, Shortread_T queryseq,
		  Shortread_T headerseq, char *acc_suffix, bool invertp,
		  T hit5, T hit3, int insertlength,
		  int pairscore, int mapq_score) {
  char *single_chr, *chr;
  bool allocp, alloc1p, pairinfo_printed_p = false;
  List_T substrings, junctions, p, q;
  Substring_T substring;
  Junction_T pre_junction, post_junction;
  int nblocks;

  if (this->chrnum == 0) {
    single_chr = (char *) NULL;
    alloc1p = false;
  } else {
    single_chr = Univ_IIT_label(chromosome_iit,this->chrnum,&alloc1p);
  }
  if (invertp == true) {
    substrings = this->substrings_Nto1;
    junctions = this->junctions_Nto1;
  } else {
    substrings = this->substrings_1toN;
    junctions = this->junctions_1toN;
  }

  if (output_type == M8_OUTPUT) {
    for (p = substrings; p != NULL; p = List_next(p)) {
      substring = (Substring_T) List_head(p);
      if (Substring_has_alts_p(substring) == true) {
	/* Skip */
      } else {
	if ((chr = single_chr) == NULL) {
	  chr = Univ_IIT_label(chromosome_iit,Substring_chrnum(substring),&allocp);
	}
	Substring_print_m8(fp,substring,headerseq,acc_suffix,chr,invertp);
	if (single_chr == NULL && allocp == true) {
	  FREE(chr);
	}
      }
    }

  } else {
    if ((nblocks = List_length(substrings)) == 1) {
      post_junction = (Junction_T) NULL;
    } else {
      post_junction = (Junction_T) List_head(junctions);
    }
    substring = (Substring_T) List_head(substrings);
    if (Substring_has_alts_p(substring) == true) {
      nblocks -= 1;
    }
    substring = (Substring_T) List_last_value(substrings,NULL);
    if (Substring_has_alts_p(substring) == true) {
      nblocks -= 1;
    }


    /* First line */
    substring = (Substring_T) List_head(substrings);
    if (Substring_has_alts_p(substring) == true) {
      /* Skip */
    } else {
      if ((chr = single_chr) == NULL) {
	chr = Univ_IIT_label(chromosome_iit,Substring_chrnum(substring),&allocp);
      }
      FPRINTF(fp," ");
      Substring_print_alignment(fp,/*pre_junction*/NULL,substring,post_junction,queryseq,chr,invertp);
      if (single_chr == NULL && allocp == true) {
	FREE(chr);
      }

      /* Alignment info */
#ifndef NO_COMPARE      
      FPRINTF(fp,"\tsegs:%d,align_score:%d,mapq:%d",nblocks,score,mapq_score);
      if (method_print_p == true) {      
	Method_print(fp,this->method);
      }
#endif
    
#if 0
      /* Transcriptome info */
      /* Print only in SAM format */
#endif

      /* Pairing info */
      if (hit5 != NULL && hit3 != NULL) {
	FPRINTF(fp,"\t");
	print_pair_info(fp,stage3pair,insertlength,pairscore);
      }
      pairinfo_printed_p = true;

      FPRINTF(fp,"\n");
    }

    if ((p = List_next(substrings)) == NULL) {
      /* Done */
    } else {
      /* Middle lines */
      for (q = List_next(junctions); q != NULL; p = List_next(p), q = List_next(q)) {
	pre_junction = post_junction;
	post_junction = List_head(q);

	substring = (Substring_T) List_head(p);
	if (Substring_has_alts_p(substring) == true) {
	  /* Skip */
	} else {
	  if (pairinfo_printed_p == true) {
	    FPRINTF(fp,",");
	  } else {
	    FPRINTF(fp," ");
	  }
	  if ((chr = single_chr) == NULL) {
	    chr = Univ_IIT_label(chromosome_iit,Substring_chrnum(substring),&allocp);
	  }
	  Substring_print_alignment(fp,pre_junction,substring,post_junction,queryseq,chr,invertp);
	  if (single_chr == NULL && allocp == true) {
	    FREE(chr);
	  }

	  if (pairinfo_printed_p == false) {
	    /* Alignment info if not already printed */
#ifndef NO_COMPARE
	    FPRINTF(fp,"\tsegs:%d,align_score:%d,mapq:%d",nblocks,score,mapq_score);
	    if (method_print_p == true) {
	      Method_print(fp,this->method);
	    }
#endif
    
#if 0
	    /* Transcriptome info if not already printed */
	    /* Print only in SAM format */
#endif
	    
	    /* Pairing info if not already printed */
	    if (hit5 != NULL && hit3 != NULL) {
	      FPRINTF(fp,"\t");
	      print_pair_info(fp,stage3pair,insertlength,pairscore);
	    }
	    pairinfo_printed_p = true;
	  }

	  FPRINTF(fp,"\n");
	}
      }

      /* Last line */
      pre_junction = post_junction;

      substring = (Substring_T) List_head(p);
      if (Substring_has_alts_p(substring) == true) {
	/* Skip */
      } else {
	if (pairinfo_printed_p == true) {
	  FPRINTF(fp,",");
	} else {
	  FPRINTF(fp," ");
	}
	if ((chr = single_chr) == NULL) {
	  chr = Univ_IIT_label(chromosome_iit,Substring_chrnum(substring),&allocp);
	}
	Substring_print_alignment(fp,pre_junction,substring,/*post_junction*/NULL,queryseq,chr,invertp);
	if (single_chr == NULL && allocp == true) {
	  FREE(chr);
	}

	if (pairinfo_printed_p == false) {
	  /* Alignment info if not already printed */
#ifndef NO_COMPARE
	  FPRINTF(fp,"\tsegs:%d,align_score:%d,mapq:%d",nblocks,score,mapq_score);
	  if (method_print_p == true) {
	    Method_print(fp,this->method);
	  }
#endif
	  
#if 0
	  /* Transcriptome info if not already printed */
	  /* Print only in SAM format */
#endif
	  
	  /* Pairing info if not already printed */
	  if (hit5 != NULL && hit3 != NULL) {
	    FPRINTF(fp,"\t");
	    print_pair_info(fp,stage3pair,insertlength,pairscore);
	  }
	  /* pairinfo_printed_p = true; */
	}
	FPRINTF(fp,"\n");
      }
    }
  }

  if (alloc1p == true) {
    FREE(single_chr);
  }
}



/* May substitute paired-end loglik for single-end loglik */
void
Stage3end_print (Filestring_T fp, Stage3pair_T stage3pair, T this,
		 Univ_IIT_T chromosome_iit, Shortread_T queryseq, Shortread_T headerseq,
		 char *acc_suffix, bool invertp, T hit5, T hit3, int insertlength,
		 int pairscore, int mapq_score) {

  /* TODO: Instead of score_within_trims, which contains penalties for
     ambiguous lengths, use (querylength - this->nmatches_plus_spliced_trims) instead */
  print_substrings(fp,stage3pair,this,this->refalt_score_within_trims,
		   chromosome_iit,queryseq,headerseq,acc_suffix,invertp,
		   hit5,hit3,insertlength,pairscore,mapq_score);

  return;
}


static void
print_query_header (Filestring_T fp, char initchar, Shortread_T queryseq, bool invertp) {
  FPRINTF(fp,"%c",initchar);
  if (invertp == false) {
    Shortread_print_oneline(fp,queryseq);
  } else {
    Shortread_print_oneline_revcomp(fp,queryseq);
  }

  return;
}



static void
print_barcode_and_quality (Filestring_T fp, Shortread_T queryseq, bool invertp, int quality_shift) {
  char *barcode;

  if ((barcode = Shortread_barcode(queryseq)) != NULL) {
    FPRINTF(fp,"\tbarcode:%s",barcode);
  }

  if (Shortread_quality_string(queryseq) != NULL) {
    FPRINTF(fp,"\t");
    if (invertp == false) {
      Shortread_print_quality(fp,queryseq,/*hardclip_low*/0,/*hardclip_high*/0,
			      quality_shift,/*show_chopped_p*/true);
    } else {
      Shortread_print_quality_revcomp(fp,queryseq,/*hardclip_low*/0,/*hardclip_high*/0,
				      quality_shift,/*show_chopped_p*/true);
    }
  }

  return;
}


bool
Stage3pair_print_end (Filestring_T fp, Result_T result, Resulttype_T resulttype,
		      char initchar, bool firstp, Univ_IIT_T chromosome_iit,
		      Shortread_T queryseq, Shortread_T headerseq1, Shortread_T headerseq2,
		      int maxpaths, bool quiet_if_excessive_p, bool invertp, int quality_shift) {
  bool printp = false, excessivep, translocationp, concordant_softclipped_p;
  Stage3pair_T *stage3pairarray, stage3pair;
  T *stage3array, *stage3array_mate, this, hit5, hit3;
  int npaths_primary, npaths_altloc, npaths_mate_primary, npaths_mate_altloc, pathnum;
  int first_absmq, second_absmq;

  if (resulttype == PAIREDEND_NOMAPPING) {
    if (only_concordant_p == true) {
      /* Skip printing */
      Filestring_set_split_output(fp,/*concordant_softclipped_p*/false,OUTPUT_NONE);

    } else if (output_type != M8_OUTPUT) {
      Filestring_set_split_output(fp,/*concordant_softclipped_p*/false,OUTPUT_NM);
      print_query_header(fp,initchar,queryseq,invertp);
      FPRINTF(fp,"\t0 %s",UNPAIRED_TEXT);

      print_barcode_and_quality(fp,queryseq,invertp,quality_shift);
    
      FPRINTF(fp,"\t");
      Shortread_print_header(fp,headerseq1,headerseq2);
      FPRINTF(fp,"\n");
    }

  } else if (resulttype == CONCORDANT_UNIQ) {
    stage3pairarray = (Stage3pair_T *) Result_array(&npaths_primary,&npaths_altloc,&first_absmq,&second_absmq,result);
    stage3pair = stage3pairarray[0];
    hit5 = stage3pair->hit5;
    hit3 = stage3pair->hit3;

    if (stage3pair->circularp == true) {
      Filestring_set_split_output(fp,/*concordant_softclipped_p*/false,OUTPUT_CC);
    } else {
      if (Stage3end_softclippedp(hit5) == true || Stage3end_softclippedp(hit3) == true) {
	Filestring_set_split_output(fp,/*concordant_softclipped_p*/true,OUTPUT_CU);
      } else {
	Filestring_set_split_output(fp,/*concordant_softclipped_p*/false,OUTPUT_CU);
      }
    }

    if (omit_concordant_uniq_p == true && stage3pair->circularp == false) {
      /* Skip printing */
      Filestring_set_split_output(fp,/*concordant_softclipped_p*/false,OUTPUT_NONE);

    } else {
      if (output_type != M8_OUTPUT) {
	print_query_header(fp,initchar,queryseq,invertp);
	FPRINTF(fp,"\t1 %s",CONCORDANT_TEXT);
    
	print_barcode_and_quality(fp,queryseq,invertp,quality_shift);

	FPRINTF(fp,"\t");
	Shortread_print_header(fp,headerseq1,headerseq2);
      }
    
      printp = true;
      if (firstp == true) {
	Stage3end_print(fp,stage3pair,hit5,
			chromosome_iit,queryseq,headerseq1,/*acc_suffix*/"/1",
			invertp,hit5,hit3,stage3pair->insertlength,
			/*pairscore*/stage3pair->hit5->refalt_score_within_trims +
			stage3pair->hit3->refalt_score_within_trims,
			stage3pair->mapq_score);
      } else {
	Stage3end_print(fp,stage3pair,hit3,
			chromosome_iit,queryseq,headerseq1,/*acc_suffix*/"/2",
			invertp,hit5,hit3,stage3pair->insertlength,
			/*pairscore*/stage3pair->hit5->refalt_score_within_trims +
			stage3pair->hit3->refalt_score_within_trims,
			stage3pair->mapq_score);
      }

      if (output_type != M8_OUTPUT) {
	FPRINTF(fp,"\n");
      }
    }

  } else if (resulttype == CONCORDANT_MULT) {
    stage3pairarray = (Stage3pair_T *) Result_array(&npaths_primary,&npaths_altloc,&first_absmq,&second_absmq,result);

    if (omit_concordant_mult_p == true) {
      /* Skip printing */
      Filestring_set_split_output(fp,/*concordant_softclipped_p*/false,OUTPUT_NONE);

    } else if (quiet_if_excessive_p && npaths_primary + npaths_altloc > maxpaths) {
      Filestring_set_split_output(fp,/*concordant_softclipped_p*/false,OUTPUT_CX);
      if (output_type != M8_OUTPUT) {
	print_query_header(fp,initchar,queryseq,invertp);
	FPRINTF(fp,"\t%d %s",npaths_primary + npaths_altloc,CONCORDANT_TEXT);
	
	print_barcode_and_quality(fp,queryseq,invertp,quality_shift);

	FPRINTF(fp,"\t");
	Shortread_print_header(fp,headerseq1,headerseq2);

	/* No further output */
	FPRINTF(fp,"\n");
	printp = false;
      }

    } else {
      concordant_softclipped_p = false;
      for (pathnum = 1; pathnum <= npaths_primary + npaths_altloc && pathnum <= maxpaths; pathnum++) {
	stage3pair = stage3pairarray[pathnum-1];
	hit5 = stage3pair->hit5;
	hit3 = stage3pair->hit3;
	if (Stage3end_softclippedp(hit5) == true || Stage3end_softclippedp(hit3) == true) {
	  concordant_softclipped_p = true;
	}
      }
      Filestring_set_split_output(fp,concordant_softclipped_p,OUTPUT_CM);

      if (output_type != M8_OUTPUT) {
	print_query_header(fp,initchar,queryseq,invertp);
	FPRINTF(fp,"\t%d %s",npaths_primary + npaths_altloc,CONCORDANT_TEXT);
	
	print_barcode_and_quality(fp,queryseq,invertp,quality_shift);
	
	FPRINTF(fp,"\t");
	Shortread_print_header(fp,headerseq1,headerseq2);
      }

      printp = true;
      for (pathnum = 1; pathnum <= npaths_primary + npaths_altloc && pathnum <= maxpaths; pathnum++) {
	stage3pair = stage3pairarray[pathnum-1];
	hit5 = stage3pair->hit5;
	hit3 = stage3pair->hit3;

	if (firstp == true) {
	  Stage3end_print(fp,stage3pair,hit5,
			  chromosome_iit,queryseq,headerseq1,/*acc_suffix*/"/1",
			  invertp,hit5,hit3,stage3pair->insertlength,
			  /*pairscore*/stage3pair->hit5->refalt_score_within_trims +
			  stage3pair->hit3->refalt_score_within_trims,
			  stage3pair->mapq_score);
	} else {
	  Stage3end_print(fp,stage3pair,hit3,
			  chromosome_iit,queryseq,headerseq1,/*acc_suffix*/"/2",
			  invertp,hit5,hit3,stage3pair->insertlength,
			  /*pairscore*/stage3pair->hit5->refalt_score_within_trims +
			  stage3pair->hit3->refalt_score_within_trims,
			  stage3pair->mapq_score);
	}
      }

      if (output_type != M8_OUTPUT) {
	FPRINTF(fp,"\n");
      }
    }

  } else if (only_concordant_p == true) {
    /* Skip printing */
    Filestring_set_split_output(fp,/*concordant_softclipped_p*/false,OUTPUT_NONE);

  } else if (resulttype == CONCORDANT_TRANSLOC) {
    Filestring_set_split_output(fp,/*concordant_softclipped_p*/false,OUTPUT_CT);
    stage3pairarray = (Stage3pair_T *) Result_array(&npaths_primary,&npaths_altloc,&first_absmq,&second_absmq,result);

    if (quiet_if_excessive_p && npaths_primary + npaths_altloc > maxpaths) {
      if (output_type != M8_OUTPUT) {
	/* No xs category for transloc, so ignore quiet-if-excessive_p */
	print_query_header(fp,initchar,queryseq,invertp);
	FPRINTF(fp,"\t%d %s",npaths_primary + npaths_altloc,CONCORDANT_TEXT);
	FPRINTF(fp," (transloc)");
	
	print_barcode_and_quality(fp,queryseq,invertp,quality_shift);

	FPRINTF(fp,"\t");
	Shortread_print_header(fp,headerseq1,headerseq2);

	/* No further output */
	FPRINTF(fp,"\n");
      }

    } else {
      if (output_type != M8_OUTPUT) {
	print_query_header(fp,initchar,queryseq,invertp);
	FPRINTF(fp,"\t%d %s",npaths_primary + npaths_altloc,CONCORDANT_TEXT);
	FPRINTF(fp," (transloc)");

	print_barcode_and_quality(fp,queryseq,invertp,quality_shift);
	
	FPRINTF(fp,"\t");
	Shortread_print_header(fp,headerseq1,headerseq2);
      }

      printp = true;
      for (pathnum = 1; pathnum <= npaths_primary + npaths_altloc && pathnum <= maxpaths; pathnum++) {
	stage3pair = stage3pairarray[pathnum-1];
	hit5 = stage3pair->hit5;
	hit3 = stage3pair->hit3;
	
	if (firstp == true) {
	  Stage3end_print(fp,stage3pair,hit5,
			  chromosome_iit,queryseq,headerseq1,/*acc_suffix*/"/1",
			  invertp,hit5,hit3,stage3pair->insertlength,
			  /*pairscore*/stage3pair->hit5->refalt_score_within_trims +
			  stage3pair->hit3->refalt_score_within_trims,
			  stage3pair->mapq_score);
	} else {
	  Stage3end_print(fp,stage3pair,hit3,
			  chromosome_iit,queryseq,headerseq1,/*acc_suffix*/"/2",
			  invertp,hit5,hit3,stage3pair->insertlength,
			  /*pairscore*/stage3pair->hit5->refalt_score_within_trims +
			  stage3pair->hit3->refalt_score_within_trims,
			  stage3pair->mapq_score);
	}
      }
      
      if (output_type != M8_OUTPUT) {
	FPRINTF(fp,"\n");
      }
    }

  } else if (resulttype == PAIRED_UNIQ_INV || resulttype == PAIRED_UNIQ_SCR || resulttype == PAIRED_UNIQ_TOOLONG) {
    stage3pairarray = (Stage3pair_T *) Result_array(&npaths_primary,&npaths_altloc,&first_absmq,&second_absmq,result);
    stage3pair = stage3pairarray[0];

    if (stage3pair->circularp == true) {
      Filestring_set_split_output(fp,/*concordant_softclipped_p*/false,OUTPUT_PC);
    } else if (resulttype == PAIRED_UNIQ_INV) {
      Filestring_set_split_output(fp,/*concordant_softclipped_p*/false,OUTPUT_PI);
    } else if (resulttype == PAIRED_UNIQ_SCR) {
      Filestring_set_split_output(fp,/*concordant_softclipped_p*/false,OUTPUT_PS);
    } else if (resulttype == PAIRED_UNIQ_TOOLONG) {
      Filestring_set_split_output(fp,/*concordant_softclipped_p*/false,OUTPUT_PL);
    } else {
      fprintf(stderr,"Unexpected resulttype %d\n",resulttype);
      abort();
    }
    
    if (output_type != M8_OUTPUT) {
      print_query_header(fp,initchar,queryseq,invertp);
      FPRINTF(fp,"\t1 %s",PAIRED_TEXT);

      print_barcode_and_quality(fp,queryseq,invertp,quality_shift);

      FPRINTF(fp,"\t");
      Shortread_print_header(fp,headerseq1,headerseq2);
    }

    hit5 = stage3pair->hit5;
    hit3 = stage3pair->hit3;
    
    printp = true;
    if (firstp == true) {
      Stage3end_print(fp,stage3pair,hit5,
		      chromosome_iit,queryseq,headerseq1,/*acc_suffix*/"/1",
		      invertp,hit5,hit3,stage3pair->insertlength,
		      /*pairscore*/stage3pair->hit5->refalt_score_within_trims +
		      stage3pair->hit3->refalt_score_within_trims,
		      stage3pair->mapq_score);
    } else {
      Stage3end_print(fp,stage3pair,hit3,
		      chromosome_iit,queryseq,headerseq1,/*acc_suffix*/"/2",
		      invertp,hit5,hit3,stage3pair->insertlength,
		      stage3pair->hit5->refalt_score_within_trims +
		      stage3pair->hit3->refalt_score_within_trims,
		      stage3pair->mapq_score);
    }

    if (output_type != M8_OUTPUT) {
      FPRINTF(fp,"\n");
    }

  } else if (resulttype == PAIRED_MULT) {
    stage3pairarray = (Stage3pair_T *) Result_array(&npaths_primary,&npaths_altloc,&first_absmq,&second_absmq,result);

    if (quiet_if_excessive_p && npaths_primary + npaths_altloc > maxpaths) {
      Filestring_set_split_output(fp,/*concordant_softclipped_p*/false,OUTPUT_PX);
      if (output_type != M8_OUTPUT) {
	print_query_header(fp,initchar,queryseq,invertp);
	FPRINTF(fp,"\t%d %s",npaths_primary + npaths_altloc,PAIRED_TEXT);
	
	print_barcode_and_quality(fp,queryseq,invertp,quality_shift);

	FPRINTF(fp,"\t");
	Shortread_print_header(fp,headerseq1,headerseq2);

	/* No further output */
	FPRINTF(fp,"\n");
      }

    } else {
      Filestring_set_split_output(fp,/*concordant_softclipped_p*/false,OUTPUT_PM);
      if (output_type != M8_OUTPUT) {
	print_query_header(fp,initchar,queryseq,invertp);
	FPRINTF(fp,"\t%d %s",npaths_primary + npaths_altloc,PAIRED_TEXT);

	print_barcode_and_quality(fp,queryseq,invertp,quality_shift);

	FPRINTF(fp,"\t");
	Shortread_print_header(fp,headerseq1,headerseq2);
      }

      printp = true;
      for (pathnum = 1; pathnum <= npaths_primary + npaths_altloc && pathnum <= maxpaths; pathnum++) {
	stage3pair = stage3pairarray[pathnum-1];
	hit5 = stage3pair->hit5;
	hit3 = stage3pair->hit3;

	if (firstp == true) {
	  Stage3end_print(fp,stage3pair,hit5,
			  chromosome_iit,queryseq,headerseq1,/*acc_suffix*/"/1",
			  invertp,hit5,hit3,stage3pair->insertlength,
			  /*pairscore*/stage3pair->hit5->refalt_score_within_trims +
			  stage3pair->hit3->refalt_score_within_trims,
			  stage3pair->mapq_score);
	} else {
	  Stage3end_print(fp,stage3pair,hit3,
			  chromosome_iit,queryseq,headerseq1,/*acc_suffix*/"/2",
			  invertp,hit5,hit3,stage3pair->insertlength,
			  /*pairscore*/stage3pair->hit5->refalt_score_within_trims +
			  stage3pair->hit3->refalt_score_within_trims,
			  stage3pair->mapq_score);
	}
      }

      if (output_type != M8_OUTPUT) {
	FPRINTF(fp,"\n");
      }
    }
    
  } else {
    /* Print as singles */
    if (firstp == true) {
      /* Get stage3array_mate first to avoid incorrect values for npaths */
      stage3array_mate = (T *) Result_array2(&npaths_mate_primary,&npaths_mate_altloc,&first_absmq,&second_absmq,result);
      stage3array = (T *) Result_array(&npaths_primary,&npaths_altloc,&first_absmq,&second_absmq,result);
    } else {
      /* Get stage3array_mate first to avoid incorrect values for npaths */
      stage3array_mate = (T *) Result_array(&npaths_mate_primary,&npaths_mate_altloc,&first_absmq,&second_absmq,result);
      stage3array = (T *) Result_array2(&npaths_primary,&npaths_altloc,&first_absmq,&second_absmq,result);
    }

    excessivep = false;
    translocationp = false;
    if (resulttype == HALFMAPPING_UNIQ) {
      if (npaths_primary + npaths_altloc > 0 && Stage3end_circularpos(stage3array[0]) > 0) {
	Filestring_set_split_output(fp,/*concordant_softclipped_p*/false,OUTPUT_HC);
      } else if (npaths_mate_primary + npaths_mate_altloc > 0 && Stage3end_circularpos(stage3array_mate[0]) > 0) {
	Filestring_set_split_output(fp,/*concordant_softclipped_p*/false,OUTPUT_HC);
      } else {
	Filestring_set_split_output(fp,/*concordant_softclipped_p*/false,OUTPUT_HU);
      }

    } else if (resulttype == HALFMAPPING_TRANSLOC) {
      Filestring_set_split_output(fp,/*concordant_softclipped_p*/false,OUTPUT_HT);
      translocationp = true;

    } else if (resulttype == HALFMAPPING_MULT) {
      if (quiet_if_excessive_p && npaths_primary + npaths_altloc > maxpaths) {
	Filestring_set_split_output(fp,/*concordant_softclipped_p*/false,OUTPUT_HX);
	excessivep = true;
      } else {
	Filestring_set_split_output(fp,/*concordant_softclipped_p*/false,OUTPUT_HM);
      }

    } else if (resulttype == UNPAIRED_UNIQ) {
      if (npaths_primary + npaths_altloc > 0 && Stage3end_circularpos(stage3array[0]) > 0) {
	Filestring_set_split_output(fp,/*concordant_softclipped_p*/false,OUTPUT_UC);
      } else if (npaths_mate_primary + npaths_mate_altloc > 0 && Stage3end_circularpos(stage3array_mate[0]) > 0) {
	Filestring_set_split_output(fp,/*concordant_softclipped_p*/false,OUTPUT_UC);
      } else {
	Filestring_set_split_output(fp,/*concordant_softclipped_p*/false,OUTPUT_UU);
      }

    } else if (resulttype == UNPAIRED_TRANSLOC) {
      Filestring_set_split_output(fp,/*concordant_softclipped_p*/false,OUTPUT_UT);
      translocationp = true;

    } else if (resulttype == UNPAIRED_MULT) {
      if (quiet_if_excessive_p && npaths_primary + npaths_altloc > maxpaths) {
	Filestring_set_split_output(fp,/*concordant_softclipped_p*/false,OUTPUT_UX);
	excessivep = true;
      } else {
	Filestring_set_split_output(fp,/*concordant_softclipped_p*/false,OUTPUT_UM);
      }

    } else {
      fprintf(stderr,"Resulttype is %s\n",Resulttype_string(resulttype));
      abort();
    }

    if (output_type != M8_OUTPUT) {
      print_query_header(fp,initchar,queryseq,invertp);
      FPRINTF(fp,"\t%d %s",npaths_primary + npaths_altloc,UNPAIRED_TEXT);
      if (translocationp == true) {
	FPRINTF(fp," (transloc)");
      }

      print_barcode_and_quality(fp,queryseq,invertp,quality_shift);

      FPRINTF(fp,"\t");
      Shortread_print_header(fp,headerseq1,headerseq2);
    }

    if (excessivep == true) {
      /* No output */
					      
    } else {
      printp = true;
      if (firstp == true) {
	for (pathnum = 1; pathnum <= npaths_primary + npaths_altloc && pathnum <= maxpaths; pathnum++) {
	  this = stage3array[pathnum-1];
	  Stage3end_print(fp,/*stage3pair*/NULL,this,
			  chromosome_iit,queryseq,headerseq1,/*acc_suffix*/"/1",
			  invertp,/*hit5*/(T) NULL,/*hit3*/(T) NULL,
			  /*insertlength*/0,/*pairscore*/0,this->mapq_score);
	}
      } else {
	for (pathnum = 1; pathnum <= npaths_primary + npaths_altloc && pathnum <= maxpaths; pathnum++) {
	  this = stage3array[pathnum-1];
	  Stage3end_print(fp,/*stage3pair*/NULL,this,
			  chromosome_iit,queryseq,headerseq1,/*acc_suffix*/"/2",
			  invertp,/*hit5*/(T) NULL,/*hit3*/(T) NULL,
			  /*insertlength*/0,/*pairscore*/0,this->mapq_score);
	}
      }
    }

    if (output_type != M8_OUTPUT) {
      FPRINTF(fp,"\n");
    }
  }

  return printp;
}



/* Used only for --merge-overlap features, so obey hardclip and not querystart/queryend */
/* If use querylength_adj, ss.bug.4 fails.  If use querylength, ss.bug.3 fails */
static List_T
Stage3end_convert_to_pairs_out (List_T pairs, T hit, Shortread_T queryseq,
				int hardclip_low, int hardclip_high, int queryseq_offset) {
  List_T p, q;
  /* Chrpos_T genomicpos1, genomicpos2; */
  Substring_T substring, prev_substring;
  Junction_T junction;
  Junctiontype_T type;
  char *deletion_string;

  if (hit->hittype == TRANSLOC_SPLICE) {
    /* Cannot handle translocations within a single GMAP alignment */
    abort();
    return NULL;
    
  } else {
    p = hit->substrings_1toN;
    prev_substring = (Substring_T) List_head(p);
    pairs = Substring_convert_to_pairs_out(pairs,prev_substring,hit->querylength,
					   queryseq,hardclip_low,hardclip_high,queryseq_offset);

    for (q = hit->junctions_1toN, p = List_next(p); p != NULL; q = List_next(q), p = List_next(p)) {
      junction = (Junction_T) List_head(q);
      substring = (Substring_T) List_head(p);
    
      if ((type = Junction_type(junction)) == INS_JUNCTION) {
	pairs = Substring_add_insertion_out(pairs,prev_substring,substring,hit->querylength,
					    /*insertionlength*/Junction_nindels(junction),queryseq,
					    hardclip_low,hardclip_high,queryseq_offset);
      } else if (type == DEL_JUNCTION) {
	deletion_string = Junction_deletion_string(junction,hit->plusp);
	pairs = Substring_add_deletion_out(pairs,prev_substring,substring,hit->querylength,
					   deletion_string,/*deletionlength*/Junction_nindels(junction),
					   hardclip_low,hardclip_high,queryseq_offset);
      } else if (type == SPLICE_JUNCTION) {
	pairs = Substring_add_intron_out(pairs,prev_substring,substring,hit->querylength,
					 hardclip_low,hardclip_high,queryseq_offset);
	
      } else {
	abort();
      }
    
      pairs = Substring_convert_to_pairs_out(pairs,substring,hit->querylength,
					     queryseq,hardclip_low,hardclip_high,queryseq_offset);
      prev_substring = substring;
    }

    debug15(Simplepair_dump_list(pairs,true));
    return pairs;
  }
}


/* Don't want querylength_adj */
struct Simplepair_T *
Stage3pair_merge (int *npairs, int *querylength_merged, char **queryseq_merged, char **quality_merged,
		  Stage3pair_T this, Shortread_T queryseq5, Shortread_T queryseq3,
		  int querylength5, int querylength3, int clipdir,
		  int hardclip5_low, int hardclip5_high, int hardclip3_low, int hardclip3_high) {
  struct Simplepair_T *pairarray, *newpair;
  Simplepair_T oldpair;
  List_T pairs, pairs5, pairs3, p;
  T hit5, hit3;
  int querylengthA, querylengthB;
  char *queryseq_ptr_5, *queryseq_ptr_3, *quality_ptr_5, *quality_ptr_3;
#ifdef CHECK_ASSERTIONS
  Chrpos_T genomicpos1, genomicpos2;
#endif

  hit5 = this->hit5;
  hit3 = this->hit3;
  queryseq_ptr_5 = Shortread_fullpointer_uc(queryseq5);
  queryseq_ptr_3 = Shortread_fullpointer_uc(queryseq3);
  quality_ptr_5 = Shortread_quality_string(queryseq5);
  quality_ptr_3 = Shortread_quality_string(queryseq3);

  if (hit5->plusp == true) {
    if (clipdir > 0) {
      pairs5 = Stage3end_convert_to_pairs_out(NULL,hit5,queryseq5,hardclip5_low,hardclip5_high,/*queryseq_offset*/0);
      pairs5 = Simplepair_strip_gaps_at_head(pairs5);

      pairs3 = Stage3end_convert_to_pairs_out(NULL,hit3,queryseq3,hardclip3_low,hardclip3_high,
					      /*queryseq_offset*/querylength5-hardclip5_low-hardclip5_high-hardclip3_low-hardclip3_high);
      pairs3 = Simplepair_strip_gaps_at_tail(pairs3);

#ifdef CHECK_ASSERTIONS
      genomicpos1 = Simplepair_head_genomepos(pairs5);
      genomicpos2 = Simplepair_last_genomepos(pairs3);
      if (genomicpos2 != genomicpos1 + 1U) {
	printf("Accession %s, plus\n",Shortread_accession(queryseq5));
	printf("Expected genomicpos2 %u == genomicpos1 %u + 1\n",genomicpos2,genomicpos1);
	Simplepair_dump_list(pairs5,true);
	Simplepair_dump_list(pairs3,true);
	abort();
      }
#endif      

      pairs = List_append(pairs3,pairs5);

      querylengthA = querylength5 - hardclip5_low - hardclip5_high;
      querylengthB = querylength3 - hardclip3_low - hardclip3_high;
      *querylength_merged = querylengthA + querylengthB;

      *queryseq_merged = (char *) MALLOC_OUT((querylengthA+querylengthB+1) * sizeof(char));
      strncpy(*queryseq_merged,queryseq_ptr_5,querylengthA);
      strncpy(&((*queryseq_merged)[querylengthA]),&(queryseq_ptr_3[querylength3 - querylengthB]),querylengthB);
      (*queryseq_merged)[querylengthA+querylengthB] = '\0';

      if (quality_ptr_5 == NULL || quality_ptr_3 == NULL) {
	*quality_merged = (char *) NULL;
      } else {
	*quality_merged = (char *) MALLOC_OUT((querylengthA+querylengthB+1) * sizeof(char));
	strncpy(*quality_merged,quality_ptr_5,querylengthA);
	strncpy(&((*quality_merged)[querylengthA]),&(quality_ptr_3[querylength3 - querylengthB]),querylengthB);
	(*quality_merged)[querylengthA+querylengthB] = '\0';
      }

    } else if (clipdir < 0) {
      pairs3 = Stage3end_convert_to_pairs_out(NULL,hit3,queryseq3,hardclip3_low,hardclip3_high,/*queryseq_offset*/0);
      pairs3 = Simplepair_strip_gaps_at_head(pairs3);

      pairs5 = Stage3end_convert_to_pairs_out(NULL,hit5,queryseq5,hardclip5_low,hardclip5_high,
					      /*queryseq_offset*/querylength3-hardclip3_low-hardclip3_high-hardclip5_low-hardclip5_high);
      pairs5 = Simplepair_strip_gaps_at_tail(pairs5);

#ifdef CHECK_ASSERTIONS
      genomicpos1 = Simplepair_head_genomepos(pairs3);
      genomicpos2 = Simplepair_last_genomepos(pairs5);
      if (genomicpos2 != genomicpos1 + 1U) {
	printf("Accession %s, plus, clipdir %d\n",Shortread_accession(queryseq5),clipdir);
	printf("Expected genomicpos2 %u == genomicpos1 %u + 1\n",genomicpos2,genomicpos1);
	printf("Begin of pairs3\n");
	Simplepair_dump_list(pairs3,true);
	printf("Begin of pairs5\n");
	Simplepair_dump_list(pairs5,true);
	abort();
      }
#endif      

      pairs = List_append(pairs5,pairs3);

      querylengthA = querylength3 - hardclip3_low - hardclip3_high;
      querylengthB = querylength5 - hardclip5_low - hardclip5_high;
      *querylength_merged = querylengthA + querylengthB;

      *queryseq_merged = (char *) MALLOC_OUT((querylengthA+querylengthB+1) * sizeof(char));
      strncpy(*queryseq_merged,queryseq_ptr_3,querylengthA);
      strncpy(&((*queryseq_merged)[querylengthA]),&(queryseq_ptr_5[querylength5 - querylengthB]),querylengthB);
      (*queryseq_merged)[querylengthA+querylengthB] = '\0';

      if (quality_ptr_5 == NULL || quality_ptr_3 == NULL) {
	*quality_merged = (char *) NULL;
      } else {
	*quality_merged = (char *) MALLOC_OUT((querylengthA+querylengthB+1) * sizeof(char));
	strncpy(*quality_merged,quality_ptr_3,querylengthA);
	strncpy(&((*quality_merged)[querylengthA]),&(quality_ptr_5[querylength5 - querylengthB]),querylengthB);
	(*quality_merged)[querylengthA+querylengthB] = '\0';
      }

    } else {
      abort();
    }

  } else {
    if (clipdir > 0) {
      pairs3 = Stage3end_convert_to_pairs_out(NULL,hit3,queryseq3,hardclip3_low,hardclip3_high,/*queryseq_offset*/0);
      pairs3 = Simplepair_strip_gaps_at_head(pairs3);

      pairs5 = Stage3end_convert_to_pairs_out(NULL,hit5,queryseq5,hardclip5_low,hardclip5_high,
					      /*queryseq_offset*/querylength3-hardclip3_low-hardclip3_high-hardclip5_low-hardclip5_high);
      pairs5 = Simplepair_strip_gaps_at_tail(pairs5);

#ifdef CHECK_ASSERTIONS
      genomicpos1 = Simplepair_head_genomepos(pairs3);
      genomicpos2 = Simplepair_last_genomepos(pairs5);
      if (genomicpos2 != genomicpos1 - 1U) {
	printf("Accession %s, minus\n",Shortread_accession(queryseq5));
	printf("Expected genomicpos2 %u == genomicpos1 %u - 1\n",genomicpos2,genomicpos1);
	Simplepair_dump_list(pairs3,true);
	Simplepair_dump_list(pairs5,true);
	abort();
      }
#endif      

      pairs = List_append(pairs5,pairs3);

      querylengthA = querylength3 - hardclip3_low - hardclip3_high;
      querylengthB = querylength5 - hardclip5_low - hardclip5_high;
      *querylength_merged = querylengthA + querylengthB;

      *queryseq_merged = (char *) MALLOC_OUT((querylengthA+querylengthB+1) * sizeof(char));
      strncpy(*queryseq_merged,queryseq_ptr_3,querylengthA);
      strncpy(&((*queryseq_merged)[querylengthA]),&(queryseq_ptr_5[querylength5 - querylengthB]),querylengthB);
      (*queryseq_merged)[querylengthA+querylengthB] = '\0';

      if (quality_ptr_5 == NULL || quality_ptr_3 == NULL) {
	*quality_merged = (char *) NULL;
      } else {
	*quality_merged = (char *) MALLOC_OUT((querylengthA+querylengthB+1) * sizeof(char));
	strncpy(*quality_merged,quality_ptr_3,querylengthA);
	strncpy(&((*quality_merged)[querylengthA]),&(quality_ptr_5[querylength5 - querylengthB]),querylengthB);
	(*quality_merged)[querylengthA+querylengthB] = '\0';
      }

    } else if (clipdir < 0) {
      pairs5 = Stage3end_convert_to_pairs_out(NULL,hit5,queryseq5,hardclip5_low,hardclip5_high,/*queryseq_offset*/0);
      pairs5 = Simplepair_strip_gaps_at_head(pairs5);

      pairs3 = Stage3end_convert_to_pairs_out(NULL,hit3,queryseq3,hardclip3_low,hardclip3_high,
					      /*queryseq_offset*/querylength5-hardclip5_low-hardclip5_high-hardclip3_low-hardclip3_high);
      pairs3 = Simplepair_strip_gaps_at_tail(pairs3);

#ifdef CHECK_ASSERTIONS
      genomicpos1 = Simplepair_head_genomepos(pairs5);
      genomicpos2 = Simplepair_last_genomepos(pairs3);
      if (genomicpos2 != genomicpos1 - 1U) {
	printf("Accession %s, minus\n",Shortread_accession(queryseq5));
	printf("Expected genomicpos2 %u == genomicpos1 %u - 1\n",genomicpos2,genomicpos1);
	Simplepair_dump_list(pairs5,true);
	Simplepair_dump_list(pairs3,true);
	abort();
      }
#endif      

      pairs = List_append(pairs3,pairs5);

      querylengthA = querylength5 - hardclip5_low - hardclip5_high;
      querylengthB = querylength3 - hardclip3_low - hardclip3_high;
      *querylength_merged = querylengthA + querylengthB;

      *queryseq_merged = (char *) MALLOC_OUT((querylengthA+querylengthB+1) * sizeof(char));
      strncpy(*queryseq_merged,queryseq_ptr_5,querylengthA);
      strncpy(&((*queryseq_merged)[querylengthA]),&(queryseq_ptr_3[querylength3 - querylengthB]),querylengthB);
      (*queryseq_merged)[querylengthA+querylengthB] = '\0';

      if (quality_ptr_5 == NULL || quality_ptr_3 == NULL) {
	*quality_merged = (char *) NULL;
      } else {
	*quality_merged = (char *) MALLOC_OUT((querylengthA+querylengthB+1) * sizeof(char));
	strncpy(*quality_merged,quality_ptr_5,querylengthA);
	strncpy(&((*quality_merged)[querylengthA]),&(quality_ptr_3[querylength3 - querylengthB]),querylengthB);
	(*quality_merged)[querylengthA+querylengthB] = '\0';
      }

    } else {
      abort();
    }
  }

  pairs = List_reverse(pairs);
  /* Simplepair_dump_list(pairs,true); */

  *npairs = List_length(pairs);
  newpair = pairarray = (struct Simplepair_T *) MALLOC_OUT((*npairs)*sizeof(struct Simplepair_T));
  for (p = pairs; p != NULL; p = p->rest) {
    oldpair = (Simplepair_T) p->first;
    memcpy(newpair++,oldpair,sizeof(struct Simplepair_T));
    Simplepair_free_out(&oldpair);
  }
  List_free_out(&pairs);

  return pairarray;
}


#if 0
static int
compute_insertlength (int *pair_relationship, Stage3pair_T this) {
  T hit5, hit3;
  int querylength5, querylength3;

  hit5 = this->hit5;
  hit3 = this->hit3;
  querylength5 = hit5->querylength;
  querylength3 = hit3->querylength;

  debug10(printf("Computing insertlength on %u..%u to %u..%u\n",
		 hit5->genomicstart - hit5->chroffset,hit5->genomicend - hit5->chroffset,
		 hit3->genomicend - hit3->chroffset,hit3->genomicstart - hit3->chroffset));

  if (hit5->plusp == true && hit3->plusp == false) {
    /* Have 5-start..end and 3-end..start */
    /*   or 3-end..start and 5-start..end */

    *pair_relationship = 0;
    if (hit5->genomicend < hit3->genomicend) {
      return (hit3->genomicend - hit5->genomicend) + querylength5 + querylength3;
    } else if (hit3->genomicstart < hit5->genomicstart) {
      return (hit5->genomicstart - hit3->genomicstart) + querylength5 + querylength3;
    } else {
      return pair_insert_length_unpaired(hit5,hit3);
    }

  } else if (hit5->plusp == false && hit3->plusp == true) {
    /* Have 5-end..start and 3-start..end */
    /*   or 3-start..end and 5-end..start */

    *pair_relationship = 0;
    if (hit5->genomicstart < hit3->genomicstart) {
      return (hit3->genomicstart - hit5->genomicstart) + querylength5 + querylength3;
    } else if (hit3->genomicend < hit5->genomicend) {
      return (hit5->genomicend - hit3->genomicend) + querylength5 + querylength3;
    } else {
      return pair_insert_length_unpaired(hit5,hit3);
    }

  } else if (hit5->plusp == true) {
    /* Concordant directions on same chromosome (plus) */
    debug10(printf("Concordant on plus strand\n"));
    /* Have 5-start..end and 3-start..end */
    if (hit5->genomicend < hit3->genomicstart) {
      /* No overlap */
      *pair_relationship = +1;
      return (hit3->genomicstart - hit5->genomicend) + querylength5 + querylength3;
    } else {
      return pair_insert_length(&(*pair_relationship),hit5,hit3);
    }


  } else {
    /* Concordant directions on same chromosome (minus) */
    debug10(printf("Concordant on minus strand\n"));
    /* Have 3-end..start and 5-end..start */
    if (hit3->genomicstart < hit5->genomicend) {
      /* No overlap */
      *pair_relationship = -1;
      return (hit5->genomicend - hit3->genomicstart) + querylength5 + querylength3;
    } else {
      return pair_insert_length(&(*pair_relationship),hit5,hit3);
    }
  }
}
#endif


/* Need to make a copy of the hit before calling */
static void
resolve_ambiguity_5 (T this, int *mismatch_positions_alloc, Spliceinfo_T spliceinfo,
		     Compress_T query_compress, int alts_resolve) {
  Substring_T substring, anchor;
  Junction_T junction;
  Univcoord_T left, ignore;
  Chrpos_T splice_distance;
  double donor_prob, acceptor_prob;

  substring = (Substring_T) List_head(this->substrings_Nto1);
  anchor = (Substring_T) List_head(List_next(this->substrings_Nto1));
  junction = (Junction_T) List_head(this->junctions_Nto1);
  left = Substring_set_alt(&donor_prob,&acceptor_prob,&ignore,&this->genomicend,substring,alts_resolve);
  if (this->plusp == true) {
    splice_distance = left - Substring_left(anchor);
    this->high_chrbound = this->genomicend - (this->querylength - this->queryend_chrbound);
    this->high_trimmed = this->genomicend - (this->querylength - this->queryend_trimmed);
  } else {
    splice_distance = Substring_left(anchor) - left;
    this->low_chrbound = this->genomicend + (this->querylength - this->queryend_chrbound);
    this->low_trimmed = this->genomicend + (this->querylength - this->queryend_trimmed);
  }
  assert(this->low_trimmed < this->high_trimmed);

  if (splice_distance > 0) {
    Junction_set_unambiguous(junction,splice_distance,donor_prob,acceptor_prob);
  } else {
    this->substrings_Nto1 = List_next(this->substrings_Nto1);
    this->junctions_Nto1 = List_next(this->junctions_Nto1);
    this->substrings_1toN = List_drop_last(this->substrings_1toN,(void **) &substring);
    this->junctions_1toN = List_drop_last(this->junctions_1toN,(void **) &junction);

    this->nsplices -= 1;
    if (this->nsplices == 0) {
      this->splice_score = 0.0;
    } else {
      this->splice_score = (this->splice_score * 2*(this->nsplices+1) - Junction_splice_score(junction)) / (2*this->nsplices);
    }
    this->nsegments -= 1;

    anchor = Substring_extend_anchor_queryend(anchor,substring,mismatch_positions_alloc,spliceinfo,
					      query_compress,genomebits,genomebits_alt,novelsplicingp);
    List_head_set(this->substrings_Nto1,(void *) anchor);
    List_last_set(this->substrings_1toN,(void *) anchor);
    Substring_free(&substring);
    Junction_free(&junction);
    
    /* Update information for hit */
    compute_ends(this,/*first_read_p*/true);
    compute_scores(this);
  }

  return;
}


/* Need to make a copy of the hit before calling */
static void
resolve_ambiguity_3 (T this, int *mismatch_positions_alloc, Spliceinfo_T spliceinfo,
		     Compress_T query_compress, int alts_resolve) {
  Substring_T substring, anchor;
  Junction_T junction;
  Univcoord_T left, ignore;
  Chrpos_T splice_distance;
  double donor_prob, acceptor_prob;

  substring = (Substring_T) List_head(this->substrings_1toN);
  anchor = (Substring_T) List_head(List_next(this->substrings_1toN));
  junction = (Junction_T) List_head(this->junctions_1toN);
  left = Substring_set_alt(&donor_prob,&acceptor_prob,&this->genomicstart,&ignore,substring,alts_resolve);
  if (this->plusp == true) {
    splice_distance = Substring_left(anchor) - left;
    this->low_chrbound = this->genomicstart + this->querystart_chrbound;
    this->low_trimmed = this->genomicstart + this->querystart_trimmed;
  } else {
    splice_distance = left - Substring_left(anchor);
    this->high_chrbound = this->genomicstart - this->querystart_chrbound;
    this->high_trimmed = this->genomicstart - this->querystart_trimmed;
  }
  assert(this->low_trimmed < this->high_trimmed);

  if (splice_distance > 0) {
    Junction_set_unambiguous(junction,splice_distance,donor_prob,acceptor_prob);
  } else {
    this->substrings_1toN = List_next(this->substrings_1toN);
    this->junctions_1toN = List_next(this->junctions_1toN);
    this->substrings_Nto1 = List_drop_last(this->substrings_Nto1,(void **) &substring);
    this->junctions_Nto1 = List_drop_last(this->junctions_Nto1,(void **) &junction);
    this->splice_score = (this->splice_score * 2*this->nsplices - Junction_splice_score(junction)) / (2*(this->nsplices - 1));

    this->nsplices -= 1;
    if (this->nsplices == 0) {
      this->splice_score = 0.0;
    } else {
      this->splice_score = (this->splice_score * 2*(this->nsplices+1) - Junction_splice_score(junction)) / (2*this->nsplices);
    }
    this->nsegments -= 1;

    anchor = Substring_extend_anchor_querystart(anchor,substring,mismatch_positions_alloc,spliceinfo,
						query_compress,genomebits,genomebits_alt,novelsplicingp);
    List_head_set(this->substrings_1toN,(void *) anchor);
    List_last_set(this->substrings_Nto1,(void *) anchor);
    Substring_free(&substring);
    Junction_free(&junction);

    /* Update information for hit */
    compute_ends(this,/*first_read_p*/false);
    compute_scores(this);
  }
	
  return;
}



/* Should not set ambiguous flag in substrings, because resolution of
   an ambiguity depends on a particular pair of ends */

static void
resolve_inside_alts_splice_plus (int *alts_resolve_5, int *alts_resolve_3,
				 int *alts_status_inside, T hit5, T hit3, int querylength5, int querylength3) {
  Chrpos_T best_insertlength, insertlength;
  Univcoord_T genomicstart, genomicend;
  int besti5 = -1, besti3 = -1, i, j;
  int best_nmismatches, nmismatches;

  Substring_T substring5, substring3;
  Univcoord_T *end_alts_coords, *start_alts_coords;
  int *end_alts_nmismatches, *start_alts_nmismatches;
  int end_amb_length_5, start_amb_length_3;


  debug9(printf("resolve plus: hit5 %p (%s) and hit3 %p (%s)\n",
		hit5,Method_string(hit5->method),hit3,Method_string(hit3->method)));

  substring5 = (Substring_T) List_head(hit5->substrings_Nto1); /* the substring for concordance */
  debug9(printf("Testing substring5 %p %d..%d alts_p %d\n",
		substring5,Stage3end_substrings_querystart(hit5),Stage3end_substrings_queryend(hit5),
		Substring_has_alts_p(substring5)));

  substring3 = (Substring_T) List_head(hit3->substrings_1toN); /* the substring for concordance */
  debug9(printf("Testing substring3 %p %d..%d alts_p %d\n",
		substring3,Stage3end_substrings_querystart(hit3),Stage3end_substrings_queryend(hit3),
		Substring_has_alts_p(substring3)));

  if (substring5 != NULL && Substring_has_alts_p(substring5) == true && 
      substring3 != NULL && Substring_has_alts_p(substring3) == true) {
    debug9(printf("Resolve plus case 1: Got alts at 5' and alts at 3':"));
    end_alts_coords = Substring_alts_coords(substring5);
    end_alts_nmismatches = Substring_alts_nmismatches(substring5);
    start_alts_coords = Substring_alts_coords(substring3);
    start_alts_nmismatches = Substring_alts_nmismatches(substring3);
    end_amb_length_5 = end_amb_length(hit5);
    start_amb_length_3 = start_amb_length(hit3);
    
    best_insertlength = (Chrpos_T) -1;
    best_nmismatches = querylength5 + querylength3;
    for (i = 0; i < Substring_alts_ncoords(substring5); i++) {
      genomicend = end_alts_coords[i] + end_amb_length_5;
      for (j = 0; j < Substring_alts_ncoords(substring3); j++) {
	genomicstart = start_alts_coords[j] - start_amb_length_3;
	debug9(printf(" %u,%u",(Chrpos_T) (genomicend - hit5->chroffset),(Chrpos_T) (genomicstart - hit3->chroffset)));
	if (genomicend < genomicstart) {
	  /* Look for valid insertlength */
	  insertlength = genomicstart - genomicend + querylength5 + querylength3;
	  debug9(printf(" (insertlength %u)",insertlength));

	  if (insertlength < best_insertlength) {
	    besti5 = i;
	    besti3 = j;
	    best_insertlength = insertlength;
	    best_nmismatches = end_alts_nmismatches[i] + start_alts_nmismatches[j];
	    debug9(printf("*"));
	  } else if (insertlength == best_insertlength &&
		     (nmismatches = end_alts_nmismatches[i] + start_alts_nmismatches[j]) < best_nmismatches) {
	    besti5 = i;
	    besti3 = j;
	    best_nmismatches = nmismatches;
	    debug9(printf("*"));
	  } else if (nmismatches == best_nmismatches) {
	    debug9(printf("tie"));
	  }
	}
      }
    }

    if (besti5 >= 0 && besti3 >= 0) {
      debug9(printf("\nBEST HAS INSERTLENGTH %u AND NMISMATCHES %d\n",best_insertlength,best_nmismatches));
      *alts_resolve_5 = besti5;
      *alts_resolve_3 = besti3;
      *alts_status_inside = ALTS_RESOLVED_BYLENGTH;
      hit5->genomicend = end_alts_coords[besti5] + end_amb_length_5;
      hit3->genomicstart = start_alts_coords[besti3] - start_amb_length_3;
    }
    debug9(printf("\n"));

  } else if (substring5 != NULL && Substring_has_alts_p(substring5) == true) {
    debug9(printf("Resolve plus case 2: Got alts at 5':"));
    end_alts_coords = Substring_alts_coords(substring5);
    end_alts_nmismatches = Substring_alts_nmismatches(substring5);
    end_amb_length_5 = end_amb_length(hit5);

    best_insertlength = (Chrpos_T) -1;
    best_nmismatches = querylength5;
    for (i = 0; i < Substring_alts_ncoords(substring5); i++) {
      genomicend = end_alts_coords[i] + end_amb_length_5;
      debug9(printf(" %u",(Chrpos_T) (genomicend - hit5->chroffset)));
      if (genomicend < hit3->genomicstart /*allow overlap*/+ querylength3) {
	/* Look for valid insertlength */
	insertlength = hit3->genomicstart - genomicend + querylength5 + querylength3;
	debug9(printf(" (insertlength %u)",insertlength));

	if (insertlength < best_insertlength) {
	  besti5 = i;
	  best_insertlength = insertlength;
	  best_nmismatches = end_alts_nmismatches[i];
	  debug9(printf("*"));
	} else if (insertlength == best_insertlength &&
		   (nmismatches = end_alts_nmismatches[i]) < best_nmismatches) {
	  besti5 = i;
	  best_nmismatches = nmismatches;
	  debug9(printf("*"));
	} else if (nmismatches == best_nmismatches) {
	  debug9(printf("tie"));
	}
      }
    }

    if (besti5 >= 0) {
      debug9(printf("\nBEST HAS INSERTLENGTH %u WITH NMISMATCHES %d\n",best_insertlength,best_nmismatches));
      *alts_resolve_5 = besti5;
      *alts_status_inside = ALTS_RESOLVED_BYLENGTH;
      hit5->genomicend = end_alts_coords[besti5] + end_amb_length_5;
    }
    debug9(printf("\n"));

  } else if (substring3 != NULL && Substring_has_alts_p(substring3) == true) {
    debug9(printf("Resolve plus case 3: Got alts at 3':"));
    start_alts_coords = Substring_alts_coords(substring3);
    start_alts_nmismatches = Substring_alts_nmismatches(substring3);
    start_amb_length_3 = start_amb_length(hit3);
    
    best_insertlength = (Chrpos_T) -1;
    best_nmismatches = querylength3;
    for (j = 0; j < Substring_alts_ncoords(substring3); j++) {
      genomicstart = start_alts_coords[j] - start_amb_length_3;
      debug9(printf(" %u",(Chrpos_T) (genomicstart - hit3->chroffset)));
      if (hit5->genomicend < genomicstart /*allow overlap*/+ querylength5) {
	/* Look for valid insertlength */
	insertlength = genomicstart - hit5->genomicend + querylength5 + querylength3;
	debug9(printf(" (insertlength %u)",insertlength));

	if (insertlength < best_insertlength) {
	  besti3 = j;
	  best_insertlength = insertlength;
	  best_nmismatches = start_alts_nmismatches[j];
	  debug9(printf("*"));
	} else if (insertlength == best_insertlength &&
		   (nmismatches = start_alts_nmismatches[j]) < best_nmismatches) {
	  besti3 = j;
	  best_nmismatches = nmismatches;
	  debug9(printf("*"));
	} else if (nmismatches == best_nmismatches) {
	  debug9(printf("tie"));
	}
      }
    }

    if (besti3 >= 0) {
      debug9(printf("\nBEST HAS INSERTLENGTH %u WITH NMISMATCHES %d\n",best_insertlength,best_nmismatches));
      *alts_resolve_3 = besti3;
      *alts_status_inside = ALTS_RESOLVED_BYLENGTH;
      hit3->genomicstart = start_alts_coords[besti3] - start_amb_length_3;
    }
    debug9(printf("\n"));
  }

  return;
}


static void
resolve_inside_alts_splice_minus (int *alts_resolve_5, int *alts_resolve_3,
				  int *alts_status_inside, T hit5, T hit3, int querylength5, int querylength3) {
  Chrpos_T best_insertlength, insertlength;
  Univcoord_T genomicstart, genomicend;
  int besti5 = -1, besti3 = -1, i, j;
  int best_nmismatches, nmismatches;

  Substring_T substring5, substring3;
  Univcoord_T *end_alts_coords, *start_alts_coords;
  int *end_alts_nmismatches, *start_alts_nmismatches;
  int end_amb_length_5, start_amb_length_3;


  debug9(printf("resolve minus: hit5 %p (%s) and hit3 %p (%s)\n",
		hit5,Method_string(hit5->method),hit3,Method_string(hit3->method)));

  substring5 = (Substring_T) List_head(hit5->substrings_Nto1); /* the substring for concordance */
  debug9(printf("Testing substring5 %p %d..%d alts_p %d\n",
		substring5,Stage3end_substrings_querystart(hit5),Stage3end_substrings_queryend(hit5),
		Substring_has_alts_p(substring5)));

  substring3 = (Substring_T) List_head(hit3->substrings_1toN); /* the substring for concordance */
  debug9(printf("Testing substring3 %p %d..%d alts_p %d\n",
		substring3,Stage3end_substrings_querystart(hit3),Stage3end_substrings_queryend(hit3),
		Substring_has_alts_p(substring3)));

  if (substring5 != NULL && Substring_has_alts_p(substring5) == true &&
      substring3 != NULL && Substring_has_alts_p(substring3) == true) {
    debug9(printf("Resolve minus case 1: Got alts at 5' and alts at 3':"));
    end_alts_coords = Substring_alts_coords(substring5);
    end_alts_nmismatches = Substring_alts_nmismatches(substring5);
    start_alts_coords = Substring_alts_coords(substring3);
    start_alts_nmismatches = Substring_alts_nmismatches(substring3);
    end_amb_length_5 = end_amb_length(hit5);
    start_amb_length_3 = start_amb_length(hit3);

    best_insertlength = (Chrpos_T) -1;
    best_nmismatches = querylength5 + querylength3;
    for (i = 0; i < Substring_alts_ncoords(substring5); i++) {
      genomicend = end_alts_coords[i] - end_amb_length_5;
      for (j = 0; j < Substring_alts_ncoords(substring3); j++) {
	genomicstart = start_alts_coords[j] + start_amb_length_3;
	debug9(printf(" %u,%u",(Chrpos_T) (genomicend - hit5->chroffset),(Chrpos_T) (genomicstart - hit3->chroffset)));
	if (genomicstart < genomicend) {
	  /* Look for valid insertlength */
	  insertlength = genomicend - genomicstart + querylength5 + querylength3;
	  debug9(printf(" (insertlength %u)",insertlength));

	  if (insertlength < best_insertlength) {
	    besti5 = i;
	    besti3 = j;
	    best_insertlength = insertlength;
	    best_nmismatches = end_alts_nmismatches[i] + start_alts_nmismatches[j];
	    debug9(printf("*"));
	  } else if (insertlength == best_insertlength &&
		     (nmismatches = end_alts_nmismatches[i] + start_alts_nmismatches[j]) < best_nmismatches) {
	    besti5 = i;
	    besti3 = j;
	    best_nmismatches = nmismatches;
	    debug9(printf("*"));
	  } else if (nmismatches == best_nmismatches) {
	    debug9(printf("tie"));
	  }
	}
      }
    }

    if (besti5 >= 0 && besti3 >= 0) {
      debug9(printf("\nBEST HAS INSERTLENGTH %u AND NMISMATCHES %d\n",best_insertlength,best_nmismatches));
      *alts_resolve_5 = besti5;
      *alts_resolve_3 = besti3;
      *alts_status_inside = ALTS_RESOLVED_BYLENGTH;
      hit5->genomicend = end_alts_coords[besti5] - end_amb_length_5;
      hit3->genomicstart = start_alts_coords[besti3] + start_amb_length_3;
    }
    debug9(printf("\n"));

  } else if (substring5 != NULL && Substring_has_alts_p(substring5) == true) {
    debug9(printf("Resolve minus case 2: Got alts at 5':"));
    end_alts_coords = Substring_alts_coords(substring5);
    end_alts_nmismatches = Substring_alts_nmismatches(substring5);
    end_amb_length_5 = end_amb_length(hit5);

    best_insertlength = (Chrpos_T) -1;
    best_nmismatches = querylength5;
    for (i = 0; i < Substring_alts_ncoords(substring5); i++) {
      genomicend = end_alts_coords[i] - end_amb_length_5;
      debug9(printf(" %u",(Chrpos_T) (genomicend - hit5->chroffset)));
      debug9(printf(" (%u <? %u + %d)",hit3->genomicstart,genomicend,querylength3));
      if (hit3->genomicstart < genomicend /*allow overlap*/+ querylength3) {
	/* Look for valid insertlength */
	insertlength = genomicend - hit3->genomicstart + querylength5 + querylength3;
	debug9(printf(" (insertlength %u)",insertlength));

	if (insertlength < best_insertlength) {
	  besti5 = i;
	  best_insertlength = insertlength;
	  best_nmismatches = end_alts_nmismatches[i];
	  debug9(printf("*"));
	} else if (insertlength == best_insertlength &&
		   (nmismatches = end_alts_nmismatches[i]) < best_nmismatches) {
	  besti5 = i;
	  best_nmismatches = nmismatches;
	  debug9(printf("*"));
	} else if (nmismatches == best_nmismatches) {
	  debug9(printf("tie"));
	}
      }
    }

    if (besti5 >= 0) {
      debug9(printf("\nBEST HAS INSERTLENGTH %u WITH NMISMATCHES %d\n",best_insertlength,best_nmismatches));
      *alts_resolve_5 = besti5;
      *alts_status_inside = ALTS_RESOLVED_BYLENGTH;
      hit5->genomicend = end_alts_coords[besti5] - end_amb_length_5;
    }
    debug9(printf("\n"));

  } else if (substring3 != NULL && Substring_has_alts_p(substring3) == true) {
    debug9(printf("Resolve minus case 3: Got alts at 3':"));
    start_alts_coords = Substring_alts_coords(substring3);
    start_alts_nmismatches = Substring_alts_nmismatches(substring3);
    start_amb_length_3 = start_amb_length(hit3);

    best_insertlength = (Chrpos_T) -1;
    best_nmismatches = querylength3;
    for (j = 0; j < Substring_alts_ncoords(substring3); j++) {
      genomicstart = start_alts_coords[j] + start_amb_length_3;
      debug9(printf(" %u",(Chrpos_T) (genomicstart - hit3->chroffset)));
      if (genomicstart < hit5->genomicend /*allow overlap*/+ querylength5) {
	/* Look for valid insertlength */
	insertlength = hit5->genomicend - genomicstart + querylength5 + querylength3;
	debug9(printf(" (insertlength %u)",insertlength));

	if (insertlength < best_insertlength) {
	  besti3 = j;
	  best_insertlength = insertlength;
	  best_nmismatches = start_alts_nmismatches[j];
	  debug9(printf("*"));
	} else if (insertlength == best_insertlength &&
		   (nmismatches = start_alts_nmismatches[j]) < best_nmismatches) {
	  besti3 = j;
	  best_nmismatches = nmismatches;
	  debug9(printf("*"));
	} else if (nmismatches == best_nmismatches) {
	  debug9(printf("tie"));
	}
      }
    }

    if (besti3 >= 0) {
      debug9(printf("\nBEST HAS INSERTLENGTH %u WITH NMISMATCHES %d\n",best_insertlength,best_nmismatches));
      *alts_resolve_3 = besti3;
      *alts_status_inside = ALTS_RESOLVED_BYLENGTH;
      hit3->genomicstart = start_alts_coords[besti3] + start_amb_length_3;
    }
    debug9(printf("\n"));
  }

  return;
}


/* #define CHECK_ARRAY 1 */


#ifdef CHECK_ARRAY
/* Taken from eejunctions.c.  For acceptors, so we want the list to be forward */
static Uintlist_T
transcript_exonstarts (char *annot) {
  Uintlist_T exonstarts = NULL;
  char *p;
  Chrpos_T exonstart, exonend;

  /* Skip header */
  p = annot;
  while (*p != '\0' && *p != '\n') {
    p++;
  }
  if (*p == '\n') p++;

  while (*p != '\0') {
    if (sscanf(p,"%u %u",&exonstart,&exonend) != 2) {
      fprintf(stderr,"Can't parse exon coordinates in %s\n",p);
      abort();
    } else {
      exonstarts = Uintlist_push(exonstarts,exonstart);
    }

    while (*p != '\0' && *p != '\n') p++;
    if (*p == '\n') p++;
  }

  /*  Want the list to be forward */
  return Uintlist_reverse(exonstarts);
}
#endif


#ifdef CHECK_ARRAY
static Uintlist_T
transcript_exonends (char *annot) {
  Uintlist_T exonends = NULL;
  char *p;
  Chrpos_T exonstart, exonend;

  /* Skip header */
  p = annot;
  while (*p != '\0' && *p != '\n') {
    p++;
  }
  if (*p == '\n') p++;

  while (*p != '\0') {
    if (sscanf(p,"%u %u",&exonstart,&exonend) != 2) {
      fprintf(stderr,"Can't parse exon coordinates in %s\n",p);
      abort();
    } else {
      exonends = Uintlist_push(exonends,exonend);
    }

    while (*p != '\0' && *p != '\n') p++;
    if (*p == '\n') p++;
  }

  /* Want the list to be backwards */
  return Uintlist_reverse(exonends);
}
#endif


#ifdef CHECK_ARRAY
/* Modified from eejunctions.c.  For donors, so we want the list to be backwards */
static Uintlist_T
transcript_exonends_rev (char *annot) {
  Uintlist_T exonends = NULL;
  char *p;
  Chrpos_T exonstart, exonend;

  /* Skip header */
  p = annot;
  while (*p != '\0' && *p != '\n') {
    p++;
  }
  if (*p == '\n') p++;

  while (*p != '\0') {
    if (sscanf(p,"%u %u",&exonstart,&exonend) != 2) {
      fprintf(stderr,"Can't parse exon coordinates in %s\n",p);
      abort();
    } else {
      exonends = Uintlist_push(exonends,exonend);
    }

    while (*p != '\0' && *p != '\n') p++;
    if (*p == '\n') p++;
  }

  /* Want the list to be backwards */
  return exonends;
}
#endif


/* Intended for unpaired reads */
/* transcriptomebits and transcriptome are defined as static */
void
Stage3pair_resolve_inside_softclips (T hit5, T hit3, Compress_T query5_compress_fwd, Compress_T query5_compress_rev,
				     int querylength5, Compress_T query3_compress_fwd, Compress_T query3_compress_rev,
				     int querylength3, Listpool_T listpool) {
  Substring_T substring5, substring3, donor, acceptor;
  Junction_T junction;
  int *matches, index;
  int nmatches, matchi;
#ifdef CHECK_ARRAY
  char *annot, *restofheader;
  bool allocp;
  Uintlist_T exonstarts, exonends, p;
#endif
  Chrpos_T *exonstarts_array;
  int *exonbounds, exonlength;
  int nexons, exoni;
  
  Chrpos_T exonstart, exonend;
  
  int splice_pos, trimlength;
  Chrnum_T chrnum;
  Chrpos_T exonbound, chrlength, distance;
  Univcoord_T splicecoord_hit = 0, donor_coord, acceptor_coord, chroffset, chrhigh;
  int total_nmismatches_hit, ref_nmismatches_hit, total_nmismatches, ref_nmismatches;
  bool donorp_hit, plusp_hit;
  double donor_prob, acceptor_prob;


  debug3(printf("Stage3end_resolve_inside_softclips: hit5 %p (%s) and hit3 %p (%s)\n",
		hit5,Method_string(hit5->method),hit3,Method_string(hit3->method)));

  substring5 = (Substring_T) List_head(hit5->substrings_Nto1); /* the substring for concordance */
  substring3 = (Substring_T) List_head(hit3->substrings_1toN); /* the substring for concordance */

  /* (1) Align N end of 5' read */
  chrnum = Substring_chrnum(substring3);
  if (Substring_has_alts_p(substring3)) {
    /* Skip */
  } else if (circularp[Substring_chrnum(substring5)] == false && circularp[chrnum] == false &&
	     (trimlength = Substring_trim_queryend(substring5)) >= MIN_RESOLVE_TRIMLENGTH) {
    chroffset = Substring_chroffset(substring3);
    chrhigh = Substring_chrhigh(substring3);
    chrlength = Substring_chrlength(substring3);
    exonbound = Substring_alignend_trim_chr(substring3);

    /* Previously looped through hit3->transcripts, and aligned to transcripts, but that list is not always accurate */
    /* Now aligning to the genome */
    matches = IIT_get_with_divno(&nmatches,transcript_map_iit,chrnum,Substring_chrpos_low(substring3),
				 Substring_chrpos_high(substring3),/*sortp*/false);

    splicecoord_hit = 0;
    for (matchi = 0; matchi < nmatches; matchi++) {
      index = matches[matchi];
      nexons = Transcriptome_exons(&exonbounds,&exonstarts_array,transcriptome,/*trnum*/index);
#ifdef CHECK_ARRAY
      annot = IIT_annotation(&restofheader,transcript_map_iit,matches[matchi],&allocp);
#endif

      if (Substring_plusp(substring3) == true) {
	/* Assume that 5' read is also plus */
	splice_pos = querylength5 - trimlength;
	if (IIT_interval_sign(transcript_map_iit,matches[matchi]) > 0) {
	  /* Looking for an acceptor */
	  debug3(printf("5' case 1 (acceptor): exonstart < exonbound %u\n",exonbound));
#ifdef CHECK_ARRAY
	  exonstarts = transcript_exonstarts(annot);
	  p = Uintlist_next(exonstarts);
#endif
	  exoni = 1;
	  while (exoni < nexons &&
		 (exonstart = exonstarts_array[exoni] - 1 /* 0-based coord */) < exonbound) {
#ifdef CHECK_ARRAY
	    assert(exonstart == Uintlist_head(p) - 1 /* 0-based coord */);
#endif
	    if ((total_nmismatches =
		 Genome_count_mismatches_substring(&ref_nmismatches,genomebits,genomebits_alt,query5_compress_fwd,
						   /*left*/chroffset + exonstart - splice_pos,/*pos5*/splice_pos,
						   /*pos3*/querylength5,/*plusp*/true,/*genestrand*/0)) == 0) {
	      plusp_hit = true;
	      donorp_hit = false;
	      splicecoord_hit = chroffset + exonstart;
	      total_nmismatches_hit = total_nmismatches;
	      ref_nmismatches_hit = ref_nmismatches;
	    }
	    debug3(printf("splicecoord (exonstart) %u, nmismatches %d\n",exonstart,total_nmismatches));
	    exoni++;
#ifdef CHECK_ARRAY
	    p = Uintlist_next(p);
#endif
	  }
#ifdef CHECK_ARRAY
	  Uintlist_free(&exonstarts);
#endif

	} else {
	  /* Looking for a donor */
	  debug3(printf("5' case 2 (donor): exonend < exonbound %u\n",exonbound));
#ifdef CHECK_ARRAY
	  exonends = transcript_exonends_rev(annot);
	  p = Uintlist_next(exonends);
#endif
	  exoni = nexons - 1;
	  exonlength = (--exoni <= 0) ? exonbounds[0] : exonbounds[exoni] - exonbounds[exoni-1];
	  while (exoni >= 0 &&
		 (exonend = exonstarts_array[exoni] - (Chrpos_T) exonlength + 1 - 1 /* 0-based coord */) < exonbound) {
#ifdef CHECK_ARRAY
	    assert(exonend == Uintlist_head(p) - 1 /* 0-based coord */);
#endif
	    if ((total_nmismatches =
		 Genome_count_mismatches_substring(&ref_nmismatches,genomebits,genomebits_alt,query5_compress_fwd,
						   /*left*/chroffset + exonend - splice_pos,/*pos5*/splice_pos,
						   /*pos3*/querylength5,/*plusp*/true,/*genestrand*/0)) == 0) {
	      plusp_hit = true;
	      donorp_hit = true;
	      splicecoord_hit = chroffset + exonend;
	      total_nmismatches_hit = total_nmismatches;
	      ref_nmismatches_hit = ref_nmismatches;
	    }
	    debug3(printf("splicecoord (exonend) %u, nmismatches %d\n",exonend,total_nmismatches));
	    exonlength = (--exoni <= 0) ? exonbounds[0] : exonbounds[exoni] - exonbounds[exoni-1];
#ifdef CHECK_ARRAY
	    p = Uintlist_next(p);
#endif
	  }
#ifdef CHECK_ARRAY
	  Uintlist_free(&exonends);
#endif
	}

      } else {
	/* Assume that 5' read is also minus */
	splice_pos = trimlength;
	if (IIT_interval_sign(transcript_map_iit,matches[matchi]) > 0) {
	  /* Looking for a donor */
	  debug3(printf("5' case 3 (donor): exonend > exonbound %u\n",exonbound));
#ifdef CHECK_ARRAY
	  exonends = transcript_exonends_rev(annot);
	  p = Uintlist_next(exonends);
#endif
	  exoni = nexons - 1;
	  exonlength = (--exoni <= 0) ? exonbounds[0] : exonbounds[exoni] - exonbounds[exoni-1];
	  while (exoni >= 0 &&
		 (exonend = exonstarts_array[exoni] + (Chrpos_T) exonlength - 1) > exonbound) {
#ifdef CHECK_ARRAY
	    assert(exonend == Uintlist_head(p));
#endif
	    if ((total_nmismatches =
		 Genome_count_mismatches_substring(&ref_nmismatches,genomebits,genomebits_alt,query5_compress_rev,
						   /*left*/chroffset + exonend - splice_pos,/*pos5*/0,
						   /*pos3*/splice_pos,/*plusp*/false,/*genestrand*/0)) == 0) {
	      plusp_hit = false;
	      donorp_hit = true;
	      splicecoord_hit = chroffset + exonend;
	      total_nmismatches_hit = total_nmismatches;
	      ref_nmismatches_hit = ref_nmismatches;
	    }
	    debug3(printf("splicecoord (exonend) %u, nmismatches %d\n",exonend,total_nmismatches));
	    exonlength = (--exoni <= 0) ? exonbounds[0] : exonbounds[exoni] - exonbounds[exoni-1];
#ifdef CHECK_ARRAY
	    p = Uintlist_next(p);
#endif
	  }
#ifdef CHECK_ARRAY
	  Uintlist_free(&exonends);
#endif

	} else {
	  /* Looking for an acceptor */
	  debug3(printf("5' case 4 (acceptor): exonstart > exonbound %u\n",exonbound));
#ifdef CHECK_ARRAY
	  exonstarts = transcript_exonstarts(annot);
	  p = Uintlist_next(exonstarts);
#endif
	  exoni = 1;
	  while (exoni < nexons &&
		 (exonstart = exonstarts_array[exoni]) > exonbound) {
#ifdef CHECK_ARRAY
	    assert(exonstart == Uintlist_head(p));
#endif
	    if ((total_nmismatches =
		 Genome_count_mismatches_substring(&ref_nmismatches,genomebits,genomebits_alt,query5_compress_rev,
						   /*left*/chroffset + exonstart - splice_pos,/*pos5*/0,
						   /*pos3*/splice_pos,/*plusp*/false,/*genestrand*/0)) == 0) {
	      plusp_hit = false;
	      donorp_hit = false;
	      splicecoord_hit = chroffset + exonstart;
	      total_nmismatches_hit = total_nmismatches;
	      ref_nmismatches_hit = ref_nmismatches;
	    }
	    debug3(printf("splicecoord (exonstart) %u, nmismatches %d\n",exonstart,total_nmismatches));
	    exoni++;
#ifdef CHECK_ARRAY
	    p = Uintlist_next(p);
#endif
	  }
#ifdef CHECK_ARRAY
	  Uintlist_free(&exonstarts);
#endif
	}
      }
#ifdef CHECK_ARRAY
      if (allocp) {
	FREE(annot);
      }
#endif
    }
    FREE(matches);

    if (splicecoord_hit != 0) {
      if (donorp_hit == false) {
	if (plusp_hit == true) {
	  /* 5' case 1 */
	  splice_pos = querylength5 - trimlength;
	  acceptor_prob = Maxent_hr_acceptor_prob(splicecoord_hit,chroffset);
	  /* printf("(1) acceptor_prob %.2f\n",acceptor_prob); */
	  acceptor = Substring_new_acceptor(total_nmismatches_hit,ref_nmismatches_hit,splicecoord_hit,/*acceptor_knowni*/-1,
					    /*querystart*/splice_pos,/*queryend*/querylength5,/*sitepos*/splice_pos,acceptor_prob,
					    /*splice_querystart_p*/false,/*splicetype_querystart*/END,/*ambig_prob_querystart*/0.0,
					    /*splice_queryend_p*/false,/*splicetype_queryend*/END,/*ambig_prob_queryend*/0.0,
					    /*left*/splicecoord_hit - splice_pos,query5_compress_fwd,
					    genomebits,genomebits_alt,querylength5,/*plusp*/true,
					    /*genestrand*/0,/*sensedir*/SENSE_FORWARD,chrnum,chroffset,chrhigh,chrlength);
	} else {
	  /* 5' case 4 */
	  splice_pos = trimlength;
	  acceptor_prob = Maxent_hr_antiacceptor_prob(splicecoord_hit,chroffset);
	  /* printf("(2) acceptor_prob %.2f\n",acceptor_prob); */
	  acceptor = Substring_new_acceptor(total_nmismatches_hit,ref_nmismatches_hit,splicecoord_hit,/*acceptor_knowni*/-1,
					    /*querystart*/querylength5 - splice_pos,/*queryend*/querylength5,
					    /*sitepos*/splice_pos,acceptor_prob,
					    /*splice_querystart_p*/false,/*splicetype_querystart*/END,/*ambig_prob_querystart*/0.0,
					    /*splice_queryend_p*/false,/*splicetype_queryend*/END,/*ambig_prob_queryend*/0.0,
					    /*left*/splicecoord_hit - splice_pos,query5_compress_rev,
					    genomebits,genomebits_alt,querylength5,/*plusp*/false,
					    /*genestrand*/0,/*sensedir*/SENSE_FORWARD,chrnum,chroffset,chrhigh,chrlength);
	}

	if (acceptor != NULL) {
	  hit5->other_chrnum = hit5->chrnum;
	  hit5->effective_chrnum = chrnum;
	  hit5->nsegments += 1;
	  hit5->nsplices += 1;
	  hit5->sensedir = SENSE_FORWARD;

	  donor = substring5;
	  if (Substring_plusp(donor) == true) {
	    donor_coord = Substring_left(donor) + Substring_queryend(donor);
	    donor_prob = Maxent_hr_donor_prob(donor_coord,Substring_chroffset(donor));
	    /* printf("(1) Donor %d..%d, prob %.2f\n",Substring_querystart(donor),Substring_queryend(donor),donor_prob); */
	  } else {
	    donor_coord = Substring_left(donor) + querylength5 - Substring_queryend(donor);
	    donor_prob = Maxent_hr_antidonor_prob(donor_coord,Substring_chroffset(donor));
	    /* printf("(2) Donor %d..%d, prob %.2f\n",Substring_querystart(donor),Substring_queryend(donor),donor_prob); */
	  }
	  Substring_set_donor(donor,donor_coord,/*donor_known_i*/-1,/*sensedir*/SENSE_FORWARD,
			      /*sitepos*/Substring_queryend(donor),donor_prob);

	  hit5->plusp = Substring_plusp(acceptor);
	  hit5->genomicend = Substring_genomicend(acceptor);
	  hit5->substrings_1toN = List_reverse(Listpool_push(List_reverse(hit5->substrings_1toN),listpool,(void *) acceptor));
	  hit5->substrings_Nto1 = Listpool_push(hit5->substrings_Nto1,listpool,(void *) acceptor);

	  if (Substring_chrnum(donor) == Substring_chrnum(acceptor) &&
	      Substring_plusp(donor) == Substring_plusp(acceptor) &&
	      SENSE_CONSISTENT_P(Substring_sensedir(donor),Substring_sensedir(acceptor))) {
	    hit5->hittype = SAMECHR_SPLICE;
	    hit5->chrnum = Substring_chrnum(donor);
	    hit5->chroffset = Substring_chroffset(donor);
	    hit5->chrhigh = Substring_chrhigh(donor);
	    hit5->chrlength = Substring_chrlength(donor);
	    if (merge_samechr_p == true) {
	      hit5->distant_splice_i = -1;
	      distance = plusp_hit == true ? Substring_left(acceptor) - Substring_left(donor) : Substring_left(donor) - Substring_left(acceptor);
	      junction = Junction_new_splice(distance,hit5->sensedir,donor_prob,acceptor_prob);
	    } else {
	      hit5->distant_splice_i = List_length(hit5->substrings_Nto1) - 1;
	      hit5->substring_donor = donor;
	      hit5->substring_acceptor = acceptor;
	      junction = Junction_new_chimera(donor_prob,acceptor_prob);
	    }
	    
	  } else {
	    hit5->hittype = TRANSLOC_SPLICE;
	    hit5->chrnum = 0;
	    hit5->chroffset = 0;
	    hit5->chrhigh = 0;
	    hit5->chrlength = 0;
	    hit5->distant_splice_i = List_length(hit5->substrings_Nto1) - 1;
	    hit5->substring_donor = donor;
	    hit5->substring_acceptor = acceptor;
	    junction = Junction_new_chimera(donor_prob,acceptor_prob);
	  }
	  
	  hit5->junctions_1toN = List_reverse(Listpool_push(List_reverse(hit5->junctions_1toN),listpool,(void *) junction));
	  hit5->junctions_Nto1 = Listpool_push(hit5->junctions_Nto1,listpool,(void *) junction);
	  /* hit5->circularpos = compute_circularpos(&hit5->circularalias,hit5); -- disallowing circular chromosomes */
	  compute_ends(hit5,/*first_read_p*/true);
	  compute_scores(hit5);
	}

      } else {
	if (plusp_hit == true) {
	  /* 5' case 2 */
	  splice_pos = querylength5 - trimlength;
	  donor_prob = Maxent_hr_antidonor_prob(splicecoord_hit,chroffset);
	  /* printf("(3) donor_prob %.2f\n",donor_prob); */
	  donor = Substring_new_donor(total_nmismatches_hit,ref_nmismatches_hit,splicecoord_hit,/*acceptor_knowni*/-1,
				      /*querystart*/splice_pos,/*queryend*/querylength5,/*sitepos*/splice_pos,donor_prob,
				      /*splice_querystart_p*/false,/*splicetype_querystart*/END,/*ambig_prob_querystart*/0.0,
				      /*splice_queryend_p*/false,/*splicetype_queryend*/END,/*ambig_prob_queryend*/0.0,
				      /*left*/splicecoord_hit - splice_pos,query5_compress_fwd,
				      genomebits,genomebits_alt,querylength5,/*plusp*/true,
				      /*genestrand*/0,/*sensedir*/SENSE_ANTI,chrnum,chroffset,chrhigh,chrlength);
	} else {
	  /* 5' case 3*/
	  splice_pos = trimlength;
	  donor_prob = Maxent_hr_donor_prob(splicecoord_hit,chroffset);
	  /* printf("(4) donor_prob %.2f\n",donor_prob); */
	  donor = Substring_new_donor(total_nmismatches_hit,ref_nmismatches_hit,splicecoord_hit,/*acceptor_knowni*/-1,
				      /*querystart*/querylength5 - splice_pos,/*queryend*/querylength5,
				      /*sitepos*/splice_pos,donor_prob,
				      /*splice_querystart_p*/false,/*splicetype_querystart*/END,/*ambig_prob_querystart*/0.0,
				      /*splice_queryend_p*/false,/*splicetype_queryend*/END,/*ambig_prob_queryend*/0.0,
				      /*left*/splicecoord_hit - splice_pos,query5_compress_rev,
				      genomebits,genomebits_alt,querylength5,/*plusp*/false,
				      /*genestrand*/0,/*sensedir*/SENSE_ANTI,chrnum,chroffset,chrhigh,chrlength);
	}

	if (donor != NULL) {
	  hit5->other_chrnum = hit5->chrnum;
	  hit5->effective_chrnum = chrnum;
	  hit5->nsegments += 1;
	  hit5->nsplices += 1;
	  hit5->sensedir = SENSE_ANTI;

	  acceptor = substring5;
	  if (Substring_plusp(acceptor) == true) {
	    acceptor_coord = Substring_left(acceptor) + Substring_queryend(acceptor);
	    acceptor_prob = Maxent_hr_antiacceptor_prob(acceptor_coord,Substring_chroffset(acceptor));
	    /* printf("(3) Acceptor %d..%d, prob %.2f\n",Substring_querystart(acceptor),Substring_queryend(acceptor),acceptor_prob); */
	  } else {
	    acceptor_coord = Substring_left(acceptor) + querylength5 - Substring_queryend(acceptor);
	    acceptor_prob = Maxent_hr_acceptor_prob(acceptor_coord,Substring_chroffset(acceptor));
	    /* printf("(4) Acceptor %d..%d, prob %.2f\n",Substring_querystart(acceptor),Substring_queryend(acceptor),acceptor_prob); */
	  }
	  Substring_set_acceptor(acceptor,acceptor_coord,/*acceptor_known_i*/-1,/*sensedir*/SENSE_ANTI,
				 /*sitepos*/Substring_queryend(acceptor),acceptor_prob);

	  hit5->plusp = Substring_plusp(donor);
	  hit5->genomicend = Substring_genomicend(donor);
	  hit5->substrings_1toN = List_reverse(Listpool_push(List_reverse(hit5->substrings_1toN),listpool,(void *) donor));
	  hit5->substrings_Nto1 = Listpool_push(hit5->substrings_Nto1,listpool,(void *) donor);

	  if (Substring_chrnum(donor) == Substring_chrnum(acceptor) &&
	      Substring_plusp(donor) == Substring_plusp(acceptor) &&
	      SENSE_CONSISTENT_P(Substring_sensedir(donor),Substring_sensedir(acceptor))) {
	    hit5->hittype = SAMECHR_SPLICE;
	    hit5->chrnum = Substring_chrnum(acceptor);
	    hit5->chroffset = Substring_chroffset(acceptor);
	    hit5->chrhigh = Substring_chrhigh(acceptor);
	    hit5->chrlength = Substring_chrlength(acceptor);
	    if (merge_samechr_p == true) {
	      hit5->distant_splice_i = -1;
	      distance = plusp_hit == true ? Substring_left(donor) - Substring_left(acceptor) : Substring_left(acceptor) - Substring_left(donor);
	      junction = Junction_new_splice(distance,hit5->sensedir,donor_prob,acceptor_prob);
	    } else {
	      hit5->distant_splice_i = List_length(hit5->substrings_Nto1) - 1;
	      hit5->substring_donor = donor;
	      hit5->substring_acceptor = acceptor;
	      junction = Junction_new_chimera(donor_prob,acceptor_prob);
	    }
	    
	  } else {
	    hit5->hittype = TRANSLOC_SPLICE;
	    hit5->chrnum = 0;
	    hit5->chroffset = 0;
	    hit5->chrhigh = 0;
	    hit5->chrlength = 0;
	    hit5->distant_splice_i = List_length(hit5->substrings_Nto1) - 1;
	    hit5->substring_donor = donor;
	    hit5->substring_acceptor = acceptor;
	    junction = Junction_new_chimera(donor_prob,acceptor_prob);
	  }
	  
	  hit5->junctions_1toN = List_reverse(Listpool_push(List_reverse(hit5->junctions_1toN),listpool,(void *) junction));
	  hit5->junctions_Nto1 = Listpool_push(hit5->junctions_Nto1,listpool,(void *) junction);
	  /* hit5->circularpos = compute_circularpos(&hit5->circularalias,hit5); -- disallowing circular chromosomes */
	  compute_ends(hit5,/*first_read_p*/true);
	  compute_scores(hit5);
	}
      }
    }
  }


  /* (2) Align 1 end of 3' read */
  chrnum = Substring_chrnum(substring5);
  if (Substring_has_alts_p(substring5)) {
    /* Skip */
  } else if (circularp[Substring_chrnum(substring3)] == false && circularp[chrnum] == false &&
	     (trimlength = Substring_trim_querystart(substring3)) >= MIN_RESOLVE_TRIMLENGTH) {
    chroffset = Substring_chroffset(substring5);
    chrhigh = Substring_chrhigh(substring5);
    chrlength = Substring_chrlength(substring5);
    exonbound = Substring_alignstart_trim_chr(substring5);

    /* Previously looped through hit5->transcripts, but that list is not always accurate */
    /* Now aligning to the genome */
    matches = IIT_get_with_divno(&nmatches,transcript_map_iit,chrnum,Substring_chrpos_low(substring5),
				 Substring_chrpos_high(substring5),/*sortp*/false);

    splicecoord_hit = 0;
    for (matchi = 0; matchi < nmatches; matchi++) {
      index = matches[matchi];
      nexons = Transcriptome_exons(&exonbounds,&exonstarts_array,transcriptome,/*trnum*/index);
#ifdef CHECK_ARRAY
      annot = IIT_annotation(&restofheader,transcript_map_iit,matches[matchi],&allocp);
#endif

      if (Substring_plusp(substring5) == true) {
	/* Assume that 3' read is also plus */
	splice_pos = trimlength;
	if (IIT_interval_sign(transcript_map_iit,matches[matchi]) > 0) {
	  /* Looking for a donor */
	  debug3(printf("3' case 1 (donor): exonend > exonbound %u\n",exonbound));
#ifdef CHECK_ARRAY
	  exonends = transcript_exonends_rev(annot);
	  p = Uintlist_next(exonends);
#endif
	  exoni = nexons - 1;
	  exonlength = (--exoni <= 0) ? exonbounds[0] : exonbounds[exoni] - exonbounds[exoni-1];
	  while (exoni >= 0 &&
		 (exonend = exonstarts_array[exoni] + (Chrpos_T) exonlength - 1) > exonbound) {
#ifdef CHECK_ARRAY
	    assert(exonend == Uintlist_head(p));
#endif
	    if ((total_nmismatches =
		 Genome_count_mismatches_substring(&ref_nmismatches,genomebits,genomebits_alt,query3_compress_fwd,
						   /*left*/chroffset + exonend - splice_pos,/*pos5*/0,
						   /*pos3*/splice_pos,/*plusp*/true,/*genestrand*/0)) == 0) {
	      plusp_hit = true;
	      donorp_hit = true;
	      splicecoord_hit = chroffset + exonend;
	      total_nmismatches_hit = total_nmismatches;
	      ref_nmismatches_hit = ref_nmismatches;
	    }
	    debug3(printf("splicecoord (exonend) %u, nmismatches %d\n",exonend,total_nmismatches));
	    exonlength = (--exoni <= 0) ? exonbounds[0] : exonbounds[exoni] - exonbounds[exoni-1];
#ifdef CHECK_ARRAY
	    p = Uintlist_next(p);
#endif
	  }
#ifdef CHECK_ARRAY
	  Uintlist_free(&exonends);
#endif

	} else {
	  /* Looking for an acceptor */
	  debug3(printf("3' case 2 (acceptor): exonstart > exonbound %u\n",exonbound));
#ifdef CHECK_ARRAY
	  exonstarts = transcript_exonstarts(annot);
	  p = Uintlist_next(exonstarts);
#endif
	  exoni = 1;
	  while (exoni < nexons &&
		 (exonstart = exonstarts_array[exoni]) > exonbound) {
#ifdef CHECK_ARRAY
	    assert(exonstart == Uintlist_head(p));
#endif
	    if ((total_nmismatches =
		 Genome_count_mismatches_substring(&ref_nmismatches,genomebits,genomebits_alt,query3_compress_fwd,
						   /*left*/chroffset + exonstart - trimlength,/*pos5*/0,
						   /*pos3*/trimlength,/*plusp*/true,/*genestrand*/0)) == 0) {
	      plusp_hit = true;
	      donorp_hit = false;
	      splicecoord_hit = chroffset + exonstart;
	      total_nmismatches_hit = total_nmismatches;
	      ref_nmismatches_hit = ref_nmismatches;
	    }
	    debug3(printf("splicecoord (exonstart) %u, nmismatches %d\n",exonstart,total_nmismatches));
	    exoni++;
#ifdef CHECK_ARRAY
	    p = Uintlist_next(p);
#endif
	  }
#ifdef CHECK_ARRAY
	  Uintlist_free(&exonstarts);
#endif
	}

      } else {
	/* Assume that 3' read is also minus */
	splice_pos = querylength3 - trimlength;
	if (IIT_interval_sign(transcript_map_iit,matches[matchi]) > 0) {
	  /* Looking for an acceptor */
	  debug3(printf("3' case 3 (acceptor): exonstart < exonbound %u\n",exonbound));
#ifdef CHECK_ARRAY
	  exonstarts = transcript_exonstarts(annot);
	  p = Uintlist_next(exonstarts);
#endif
	  exoni = 1;
	  while (exoni < nexons &&
		 (exonstart = exonstarts_array[exoni] - 1 /* 0-based coord */) < exonbound) {
#ifdef CHECK_ARRAY
	    assert(exonstart == Uintlist_head(p) - 1 /* 0-based coord */);
#endif
	    if ((total_nmismatches =
		 Genome_count_mismatches_substring(&ref_nmismatches,genomebits,genomebits_alt,query3_compress_rev,
						   /*left*/chroffset + exonstart - splice_pos,/*pos5*/splice_pos,
						   /*pos3*/querylength3,/*plusp*/false,/*genestrand*/0)) == 0) {
	      plusp_hit = false;
	      donorp_hit = false;
	      splicecoord_hit = chroffset + exonstart;
	      total_nmismatches_hit = total_nmismatches;
	      ref_nmismatches_hit = ref_nmismatches;
	    }
	    debug3(printf("splicecoord (exonstart) %u, nmismatches %d\n",exonstart,total_nmismatches));
	    exoni++;
#ifdef CHECK_ARRAY
	    p = Uintlist_next(p);
#endif
	  }
#ifdef CHECK_ARRAY
	  Uintlist_free(&exonstarts);
#endif

	} else {
	  /* Looking for a donor */
	  debug3(printf("3' case 4 (donor): exonend < exonbound %u\n",exonbound));
#ifdef CHECK_ARRAY
	  exonends = transcript_exonends_rev(annot);
	  p = Uintlist_next(exonends);
#endif
	  exoni = nexons - 1;
	  exonlength = (--exoni <= 0) ? exonbounds[0] : exonbounds[exoni] - exonbounds[exoni-1];
	  while (exoni >= 0 &&
		 (exonend = exonstarts_array[exoni] - (Chrpos_T) exonlength + 1 - 1 /* 0-based coord */) < exonbound) {
#ifdef CHECK_ARRAY
	    assert(exonend == Uintlist_head(p) - 1 /* 0-based coord */);
#endif
	    if ((total_nmismatches =
		 Genome_count_mismatches_substring(&ref_nmismatches,genomebits,genomebits_alt,query3_compress_rev,
						   /*left*/chroffset + exonend - splice_pos,/*pos5*/splice_pos,
						   /*pos3*/querylength3,/*plusp*/false,/*genestrand*/0)) == 0) {
	      plusp_hit = false;
	      donorp_hit = true;
	      splicecoord_hit = chroffset + exonend;
	      total_nmismatches_hit = total_nmismatches;
	      ref_nmismatches_hit = ref_nmismatches;
	    }
	    debug3(printf("splicecoord (exonend) %u, nmismatches %d\n",exonend,total_nmismatches));
	    exonlength = (--exoni <= 0) ? exonbounds[0] : exonbounds[exoni] - exonbounds[exoni-1];
#ifdef CHECK_ARRAY
	    p = Uintlist_next(p);
#endif
	  }
#ifdef CHECK_ARRAY
	  Uintlist_free(&exonends);
#endif
	}
      }
#ifdef CHECK_ARRAY
      if (allocp) {
	FREE(annot);
      }
#endif
    }
    FREE(matches);

    if (splicecoord_hit != 0) {
      if (donorp_hit == true) {
	if (plusp_hit == true) {
	  /* 3' case 2 */
	  splice_pos = trimlength;
	  donor_prob = Maxent_hr_donor_prob(splicecoord_hit,chroffset);
	  /* printf("(5) donor_prob %.2f\n",donor_prob); */
	  donor = Substring_new_donor(total_nmismatches_hit,ref_nmismatches_hit,splicecoord_hit,/*acceptor_knowni*/-1,
				      /*querystart*/0,/*queryend*/splice_pos,/*sitepos*/splice_pos,donor_prob,
				      /*splice_querystart_p*/false,/*splicetype_querystart*/END,/*ambig_prob_querystart*/0.0,
				      /*splice_queryend_p*/false,/*splicetype_queryend*/END,/*ambig_prob_queryend*/0.0,
				      /*left*/splicecoord_hit - splice_pos,query3_compress_fwd,
				      genomebits,genomebits_alt,querylength3,/*plusp*/true,
				      /*genestrand*/0,/*sensedir*/SENSE_FORWARD,chrnum,chroffset,chrhigh,chrlength);
	} else {
	  /* 3' case 3 */
	  splice_pos = querylength3 - trimlength;
	  donor_prob = Maxent_hr_antidonor_prob(splicecoord_hit,chroffset);
	  /* printf("(6) donor_prob %.2f\n",donor_prob); */
	  donor = Substring_new_donor(total_nmismatches_hit,ref_nmismatches_hit,splicecoord_hit,/*acceptor_knowni*/-1,
				      /*querystart*/0,/*queryend*/querylength3 - splice_pos,
				      /*sitepos*/splice_pos,donor_prob,
				      /*splice_querystart_p*/false,/*splicetype_querystart*/END,/*ambig_prob_querystart*/0.0,
				      /*splice_queryend_p*/false,/*splicetype_queryend*/END,/*ambig_prob_queryend*/0.0,
				      /*left*/splicecoord_hit - splice_pos,query3_compress_rev,
				      genomebits,genomebits_alt,querylength3,/*plusp*/false,
				      /*genestrand*/0,/*sensedir*/SENSE_FORWARD,chrnum,chroffset,chrhigh,chrlength);
	}

	if (donor != NULL) {
	  hit3->other_chrnum = hit3->chrnum;
	  hit3->effective_chrnum = chrnum;
	  hit3->nsegments += 1;
	  hit3->nsplices += 1;
	  hit3->sensedir = SENSE_FORWARD;

	  acceptor = substring3;
	  if (Substring_plusp(acceptor) == true) {
	    acceptor_coord = Substring_left(acceptor) + Substring_querystart(acceptor);
	    acceptor_prob = Maxent_hr_acceptor_prob(acceptor_coord,Substring_chroffset(acceptor));
	    /* printf("(5) acceptor %d..%d, prob %.2f\n",Substring_querystart(acceptor),Substring_queryend(acceptor),acceptor_prob); */
	  } else {
	    acceptor_coord = Substring_left(acceptor) + querylength3 - Substring_querystart(acceptor);
	    acceptor_prob = Maxent_hr_antiacceptor_prob(acceptor_coord,Substring_chroffset(acceptor));
	    /* printf("(6) acceptor %d..%d, prob %.2f\n",Substring_querystart(acceptor),Substring_queryend(acceptor),acceptor_prob); */
	  }
	  Substring_set_acceptor(acceptor,acceptor_coord,/*acceptor_known_i*/-1,/*sensedir*/SENSE_FORWARD,
				 /*sitepos*/Substring_querystart(acceptor),acceptor_prob);
	
	  hit3->plusp = Substring_plusp(donor);
	  hit3->genomicstart = Substring_genomicstart(donor);
	  hit3->substrings_1toN = Listpool_push(hit3->substrings_1toN,listpool,(void *) donor);
	  hit3->substrings_Nto1 = List_reverse(Listpool_push(List_reverse(hit3->substrings_Nto1),listpool,(void *) donor));

	  if (Substring_chrnum(donor) == Substring_chrnum(acceptor) &&
	      Substring_plusp(donor) == Substring_plusp(acceptor) &&
	      SENSE_CONSISTENT_P(Substring_sensedir(donor),Substring_sensedir(acceptor))) {
	    hit3->hittype = SAMECHR_SPLICE;
	    hit3->chrnum = Substring_chrnum(donor);
	    hit3->chroffset = Substring_chroffset(donor);
	    hit3->chrhigh = Substring_chrhigh(donor);
	    hit3->chrlength = Substring_chrlength(donor);
	    if (merge_samechr_p == true) {
	      hit3->distant_splice_i = -1;
	      distance = plusp_hit == true ? Substring_left(acceptor) - Substring_left(donor) : Substring_left(donor) - Substring_left(acceptor);
	      junction = Junction_new_splice(distance,hit3->sensedir,donor_prob,acceptor_prob);
	    } else {
	      hit3->distant_splice_i = 0; /* Prepending the segment */
	      hit3->substring_donor = donor;
	      hit3->substring_acceptor = acceptor;
	      junction = Junction_new_chimera(donor_prob,acceptor_prob);
	    }
	    
	  } else {
	    hit3->hittype = TRANSLOC_SPLICE;
	    hit3->chrnum = 0;
	    hit3->chroffset = 0;
	    hit3->chrhigh = 0;
	    hit3->chrlength = 0;
	    hit3->distant_splice_i = 0; /* Prepending the segment */
	    hit3->substring_donor = donor;
	    hit3->substring_acceptor = acceptor;
	    junction = Junction_new_chimera(donor_prob,acceptor_prob);
	  }
	  
	  hit3->junctions_1toN = Listpool_push(hit3->junctions_1toN,listpool,(void *) junction);
	  hit3->junctions_Nto1 = List_reverse(Listpool_push(List_reverse(hit3->junctions_Nto1),listpool,(void *) junction));
	  /* hit3->circularpos = compute_circularpos(&hit3->circularalias,hit3); -- disallowing circular chromosomes */
	  compute_ends(hit3,/*first_read_p*/false);
	  compute_scores(hit3);
	}

      } else {
	if (plusp_hit == true) {
	  /* 3' case 1 */
	  splice_pos = trimlength;
	  acceptor_prob = Maxent_hr_antiacceptor_prob(splicecoord_hit,chroffset);
	  /* printf("(7) acceptor_prob %.2f\n",acceptor_prob); */
	  acceptor = Substring_new_acceptor(total_nmismatches_hit,ref_nmismatches_hit,splicecoord_hit,/*acceptor_knowni*/-1,
					    /*querystart*/0,/*queryend*/splice_pos,/*sitepos*/splice_pos,acceptor_prob,
					    /*splice_querystart_p*/false,/*splicetype_querystart*/END,/*ambig_prob_querystart*/0.0,
					    /*splice_queryend_p*/false,/*splicetype_queryend*/END,/*ambig_prob_queryend*/0.0,
					    /*left*/splicecoord_hit - splice_pos,query3_compress_fwd,
					    genomebits,genomebits_alt,querylength3,/*plusp*/true,
					    /*genestrand*/0,/*sensedir*/SENSE_ANTI,chrnum,chroffset,chrhigh,chrlength);
	} else {
	  /* 3' case 4 */
	  splice_pos = querylength3 - trimlength;
	  acceptor_prob = Maxent_hr_acceptor_prob(splicecoord_hit,chroffset);
	  /* printf("(8) acceptor_prob %.2f\n",acceptor_prob); */
	  acceptor = Substring_new_acceptor(total_nmismatches_hit,ref_nmismatches_hit,splicecoord_hit,/*acceptor_knowni*/-1,
					    /*querystart*/0,/*queryend*/querylength3 - splice_pos,
					    /*sitepos*/splice_pos,acceptor_prob,
					    /*splice_querystart_p*/false,/*splicetype_querystart*/END,/*ambig_prob_querystart*/0.0,
					    /*splice_queryend_p*/false,/*splicetype_queryend*/END,/*ambig_prob_queryend*/0.0,
					    /*left*/splicecoord_hit - splice_pos,query3_compress_rev,
					    genomebits,genomebits_alt,querylength3,/*plusp*/false,
					    /*genestrand*/0,/*sensedir*/SENSE_ANTI,chrnum,chroffset,chrhigh,chrlength);
	}

	if (acceptor != NULL) {
	  hit3->other_chrnum = hit3->chrnum;
	  hit3->effective_chrnum = chrnum;
	  hit3->nsegments += 1;
	  hit3->nsplices += 1;
	  hit3->sensedir = SENSE_ANTI;

	  donor = substring3;
	  if (Substring_plusp(donor) == true) {
	    donor_coord = Substring_left(donor) + Substring_querystart(donor);
	    donor_prob = Maxent_hr_antidonor_prob(donor_coord,Substring_chroffset(donor));
	    /* printf("(7) donor %d..%d, prob %.2f\n",Substring_querystart(donor),Substring_queryend(donor),donor_prob); */
	  } else {
	    donor_coord = Substring_left(donor) + querylength3 - Substring_querystart(donor);
	    donor_prob = Maxent_hr_donor_prob(donor_coord,Substring_chroffset(donor));
	    /* printf("(8) donor %d..%d, prob %.2f\n",Substring_querystart(donor),Substring_queryend(donor),donor_prob); */
	  }
	  Substring_set_donor(donor,donor_coord,/*donor_known_i*/-1,/*sensedir*/SENSE_ANTI,
			      /*sitepos*/Substring_querystart(donor),donor_prob);
	  
	  hit3->plusp = Substring_plusp(acceptor);
	  hit3->genomicstart = Substring_genomicstart(acceptor);
	  hit3->substrings_1toN = Listpool_push(hit3->substrings_1toN,listpool,(void *) acceptor);
	  hit3->substrings_Nto1 = List_reverse(Listpool_push(List_reverse(hit3->substrings_Nto1),listpool,(void *) acceptor));
	  
	  if (Substring_chrnum(donor) == Substring_chrnum(acceptor) &&
	      Substring_plusp(donor) == Substring_plusp(acceptor) &&
	      SENSE_CONSISTENT_P(Substring_sensedir(donor),Substring_sensedir(acceptor))) {
	    hit3->hittype = SAMECHR_SPLICE;
	    hit3->chrnum = Substring_chrnum(acceptor);
	    hit3->chroffset = Substring_chroffset(acceptor);
	    hit3->chrhigh = Substring_chrhigh(acceptor);
	    hit3->chrlength = Substring_chrlength(acceptor);
	    if (merge_samechr_p == true) {
	      hit3->distant_splice_i = -1;
	      distance = plusp_hit == true ? Substring_left(donor) - Substring_left(acceptor) : Substring_left(acceptor) - Substring_left(donor);
	      junction = Junction_new_splice(distance,hit3->sensedir,donor_prob,acceptor_prob);
	    } else {
	      hit3->distant_splice_i = 0; /* Prepending the segment */
	      hit3->substring_donor = donor;
	      hit3->substring_acceptor = acceptor;
	      junction = Junction_new_chimera(donor_prob,acceptor_prob);
	    }
	    
	  } else {
	    hit3->hittype = TRANSLOC_SPLICE;
	    hit3->chrnum = 0;
	    hit3->chroffset = 0;
	    hit3->chrhigh = 0;
	    hit3->chrlength = 0;
	    hit3->distant_splice_i = 0; /* Prepending the segment */
	    hit3->substring_donor = donor;
	    hit3->substring_acceptor = acceptor;
	    junction = Junction_new_chimera(donor_prob,acceptor_prob);
	  }
	  
	  hit3->junctions_1toN = Listpool_push(hit3->junctions_1toN,listpool,(void *) junction);
	  hit3->junctions_Nto1 = List_reverse(Listpool_push(List_reverse(hit3->junctions_Nto1),listpool,(void *) junction));
	  /* hit3->circularpos = compute_circularpos(&hit3->circularalias,hit3); -- disallowing circular chromosomes */
	  compute_ends(hit3,/*first_read_p*/false);
	  compute_scores(hit3);
	}
      }
    }
  }

  return;
}



static void
alias_circular (T hit) {
  Chrpos_T chrlength = hit->chrlength;
  List_T p;
  Substring_T substring;

  assert(hit->circularalias == -1);
  for (p = hit->substrings_1toN; p != NULL; p = List_next(p)) {
    substring = (Substring_T) List_head(p);
    Substring_alias_circular(substring);
  }

  /* Doesn't fix hitpair->low and hitpair->high */
  hit->genomicstart += chrlength;
  hit->genomicend += chrlength;
  hit->low_chrbound += chrlength;
  hit->high_chrbound += chrlength;
  hit->low_trimmed += chrlength;
  hit->high_trimmed += chrlength;

  hit->circularalias = +1;
  debug12(printf("Changing circularalias to be +1\n"));

  return;
}


/* Previously allowed for private5p or private3p to be true.  But now
   always copying (because concordance procedure can delete hits), and
   so private5p and private3p are essentially true. */
Stage3pair_T
Stage3pair_new (T hit5_orig, T hit3_orig, int genestrand, int sensedir,
		int *mismatch_positions_alloc_5, int *mismatch_positions_alloc_3,
		Spliceinfo_T spliceinfo5, Spliceinfo_T spliceinfo3,
		Compress_T query5_compress_fwd, Compress_T query5_compress_rev,
		Compress_T query3_compress_fwd, Compress_T query3_compress_rev,
		Listpool_T listpool, bool expect_concordant_p, bool transcriptome_guided_p) {
  Stage3pair_T new;
  Stage3end_T hit5, hit3;
  Substring_T substring1, substringN;
  int alts_resolve_5, alts_resolve_3;

  /* int found_score = 0; */
  bool overreach5p, overreach3p;
  Chrpos_T pairmax;

  int querylength5 = hit5_orig->querylength;
  int querylength3 = hit3_orig->querylength;


  debug0(printf("\nStage3pair_new called with chrnum %d, %d (effective %d, %d), expect_concordant_p %d\n",
		hit5_orig->chrnum,hit3_orig->chrnum,
		hit5_orig->effective_chrnum,hit3_orig->effective_chrnum,expect_concordant_p));

  /* Always make a copy, because concordance procedure might delete the hit */
  hit5 = Stage3end_copy(hit5_orig,listpool);
  hit3 = Stage3end_copy(hit3_orig,listpool);

  new = (Stage3pair_T) MALLOC_OUT(sizeof(*new));

  new->genestrand = genestrand;
  new->sensedir = sensedir;

  alts_resolve_5 = -1;
  alts_resolve_3 = -1;
  new->alts_status_inside = ALTS_NOT_AMBIGUOUS;


#if 0
  new->mapq_loglik = hit5->mapq_loglik + hit3->mapq_loglik;
  new->mapq_score = 0;
  new->absmq_score = 0;
#endif

  if (hit5->plusp == true && hit3->plusp == false) {
    debug10(printf("plus/minus\n"));
    new->dir = 0;
    
    /* Have 5-start..end and 3-end..start */
    /*   or 3-end..start and 5-start..end */

    new->pair_relationship = 0;

    if (hit5->genomicend < hit3->genomicend) {
      new->insertlength = (hit3->genomicend - hit5->genomicend) + querylength5 + querylength3;
      new->insertlength_expected_sign = insertlength_expected(new->insertlength);
    } else if (hit3->genomicstart < hit5->genomicstart) {
      new->insertlength = (hit5->genomicstart - hit3->genomicstart) + querylength5 + querylength3;
      new->insertlength_expected_sign = insertlength_expected(new->insertlength);
    } else {
      new->insertlength = pair_insert_length_unpaired(hit5,hit3); /* was 0 */
      new->insertlength_expected_sign = false;
    }

  } else if (hit5->plusp == false && hit3->plusp == true) {
    debug10(printf("minus/plus\n"));
    new->dir = 0;
    
    /* Have 5-end..start and 3-start..end */
    /*   or 3-start..end and 5-end..start */

    new->pair_relationship = 0;
    if (hit5->genomicstart < hit3->genomicstart) {
      new->insertlength = (hit3->genomicstart - hit5->genomicstart) + querylength5 + querylength3;
      new->insertlength_expected_sign = insertlength_expected(new->insertlength);
    } else if (hit3->genomicend < hit5->genomicend) {
      new->insertlength = (hit5->genomicend - hit3->genomicend) + querylength5 + querylength3;
      new->insertlength_expected_sign = insertlength_expected(new->insertlength);
    } else {
      new->insertlength = pair_insert_length_unpaired(hit5,hit3); /* was 0 */
      new->insertlength_expected_sign = false;
    }

  } else if (hit5->plusp == true) {
    /* Concordant directions on same chromosome (plus) */
    debug10(printf("*Concordant on plus strand\n"));
    new->dir = +1;

    if (expect_concordant_p == true) {
      overreach5p = overreach3p = false;
      if (hit5->hittype == SPLICE) {

	substringN = (Substring_T) List_head(hit5->substrings_Nto1);
	if (Substring_alignstart_trim(substringN) > hit3->genomicend) {
	  substring1 = (Substring_T) List_head(hit5->substrings_1toN);
	  if (Substring_alignend_trim(substring1) < hit3->genomicstart) {
	    overreach5p = true;
	  }
	}
      }
      if (hit3->hittype == SPLICE) {
	substring1 = (Substring_T) List_head(hit3->substrings_1toN);
	if (Substring_alignend_trim(substring1) < hit5->genomicstart) {
	  substringN = (Substring_T) List_head(hit3->substrings_Nto1);
	  if (Substring_alignstart_trim(substringN) > hit5->genomicend) {
	    overreach3p = true;
	  }
	}
      }

      if (overreach5p == true || overreach3p == true) {
	/* Either overreach */
	debug0(printf("  Returning NULL because of dual overreach\n"));
	Stage3end_free(&hit5);	/* This was the copy */
	Stage3end_free(&hit3);	/* This was the copy */
	FREE_OUT(new);
	return (Stage3pair_T) NULL;

#if 0
      } else if (overreach5p == true) {
	/* Overreach of hit5 */
	debug9(printf("Overreach of hit5 of type SPLICE.  Removing substring2\n"));
	if (hit5->sensedir == SENSE_FORWARD) {
	  copy = Stage3end_new_splice(&found_score,/*nmismatches_donor*/Substring_nmismatches_bothdiff(hit5->substring1),
				      /*nmismatches_acceptor*/0,/*donor*/hit5->substring1,/*acceptor*/NULL,/*distance*/0U,
				      /*shortdistancep*/true,localsplicing_penalty,hit5->querylength,/*amb_length*/0,/*amb_prob*/0.0,
				      /*alts_coords_donor*/NULL,/*alts_coords_acceptor*/NULL,
				      /*alts_nmismatches_donor*/NULL,/*alts_nmismatches_acceptor*/NULL,
				      /*alts_probs_donor*/NULL,/*alts_probs_acceptor*/NULL,
				      /*copy_donor_p*/true,/*copy_acceptor_p*/false,/*first_read_p*/true,
				      /*sensedir*/hit5->sensedir,listpool,hit5->method,hit5->level);
	} else if (hit5->sensedir == SENSE_ANTI) {
	  copy = Stage3end_new_splice(&found_score,/*nmismatches_donor*/0,
				      /*nmismatches_acceptor*/Substring_nmismatches_bothdiff(hit5->substring1),/*donor*/NULL,
				      /*acceptor*/hit5->substring1,/*distance*/0U,
				      /*shortdistancep*/true,localsplicing_penalty,hit5->querylength,/*amb_length*/0,/*amb_prob*/0.0,
				      /*alts_coords_donor*/NULL,/*alts_coords_acceptor*/NULL,
				      /*alts_nmismatches_donor*/NULL,/*alts_nmismatches_acceptor*/NULL,
				      /*alts_probs_donor*/NULL,/*alts_probs_acceptor*/NULL,
				      /*copy_donor_p*/false,/*copy_acceptor_p*/true,/*first_read_p*/true,
				      /*sensedir*/hit5->sensedir,listpool,hit5->method,hit5->level);
	} else {
	  abort();
	}
	Stage3end_free(&hit5);	/* This was the copy */
	hit5 = copy;

      } else if (overreach3p == true) {
	/* Overreach of hit3 */
	debug9(printf("Overreach of hit3 of type SPLICE.  Removing substring1\n"));
	if (hit3->sensedir == SENSE_FORWARD) {
	  copy = Stage3end_new_splice(&found_score,/*nmismatches_donor*/0,
				      /*nmismatches_acceptor*/Substring_nmismatches_bothdiff(hit3->substring2),/*donor*/NULL,
				      /*acceptor*/hit3->substring2,/*distance*/0U,
				      /*shortdistancep*/true,localsplicing_penalty,hit3->querylength,/*amb_length*/0,/*amb_prob*/0.0,
				      /*alts_coords_donor*/NULL,/*alts_coords_acceptor*/NULL,
				      /*alts_nmismatches_donor*/NULL,/*alts_nmismatches_acceptor*/NULL,
				      /*alts_probs_donor*/NULL,/*alts_probs_acceptor*/NULL,
				      /*copy_donor_p*/false,/*copy_acceptor_p*/true,/*first_read_p*/false,
				      /*sensedir*/hit3->sensedir,listpool,hit3->method,hit3->level);
	} else if (hit3->sensedir == SENSE_ANTI) {
	  copy = Stage3end_new_splice(&found_score,/*nmismatches_donor*/Substring_nmismatches_bothdiff(hit3->substring2),
				      /*nmismatches_acceptor*/0,/*donor*/hit3->substring2,/*acceptor*/NULL,/*distance*/0U,
				      /*shortdistancep*/true,localsplicing_penalty,hit3->querylength,/*amb_length*/0,/*amb_prob*/0.0,
				      /*alts_coords_donor*/NULL,/*alts_coords_acceptor*/NULL,
				      /*alts_nmismatches_donor*/NULL,/*alts_nmismatches_acceptor*/NULL,
				      /*alts_probs_donor*/NULL,/*alts_probs_acceptor*/NULL,
				      /*copy_donor_p*/true,/*copy_acceptor_p*/false,/*first_read_p*/false,
				      /*sensedir*/hit3->sensedir,listpool,hit3->method,hit3->level);
	} else {
	  abort();
	}
	Stage3end_free(&hit3);	/* This was the copy */
	hit3 = copy;
#endif
      }

      /* Try to resolve ambiguity on inside of concordant ends */
      debug9(printf("Calling resolve_inside_alts_splice_plus\n"));
      resolve_inside_alts_splice_plus(&alts_resolve_5,&alts_resolve_3,
				      &new->alts_status_inside,hit5,hit3,querylength5,querylength3);
      if (alts_resolve_5 >= 0) {
	resolve_ambiguity_5(hit5,mismatch_positions_alloc_5,spliceinfo5,query5_compress_fwd,alts_resolve_5);
      }
      if (alts_resolve_3 >= 0) {
	resolve_ambiguity_3(hit3,mismatch_positions_alloc_3,spliceinfo3,query3_compress_fwd,alts_resolve_3);
      }

      debug9(printf("For pair %p (%p and %p), set alts_resolve_5 to be %d and alts_resolve_3 to be %d\n",
		    new,hit5,hit3,alts_resolve_5,alts_resolve_3));
    }

    /* Have 5-start..end and 3-start..end */
    if (hit5->genomicend < hit3->genomicstart) {
      /* No overlap */
      new->pair_relationship = +1;
      new->insertlength = (hit3->genomicstart - hit5->genomicend) + querylength5 + querylength3;
      new->insertlength_expected_sign = insertlength_expected(new->insertlength);
      debug10(printf("plus, no overlap: insert length %d = start3 %u - end5 %u + %d + %d\n",
		     new->insertlength,hit3->genomicstart - hit3->chroffset,
		     hit5->genomicend - hit5->chroffset,querylength5,querylength3));
#if 0
    } else if (hit5->genomicend > hit3->genomicend + SUBSUMPTION_SLOP) {
      /* hit5 subsumes hit3 */
      debug10(printf("plus, subsumption %u > %u\n",
		     hit5->genomicend - hit5->chroffset,hit3->genomicend - hit3->chroffset));
      new->pair_relationship = 0;
      new->insertlength = 0;
      new->insertlength_expected_sign = false;
#endif
    } else {
      new->insertlength = pair_insert_length(&new->pair_relationship,hit5,hit3);
      new->insertlength_expected_sign = insertlength_expected(new->insertlength);
    }


  } else {
    /* Concordant directions on same chromosome (minus) */
    debug10(printf("*Concordant on minus strand\n"));
    new->dir = -1;

    if (expect_concordant_p == true) {
      overreach5p = overreach3p = false;
      if (hit5->hittype == SPLICE) {
	debug10(printf("Have splice on 5' end\n"));
	substringN = (Substring_T) List_head(hit5->substrings_Nto1);
	if (Substring_alignstart_trim(substringN) < hit3->genomicend) {
	  substring1 = (Substring_T) List_head(hit5->substrings_1toN);
	  if (Substring_alignend_trim(substring1) > hit3->genomicstart) {
	    overreach5p = true;
	  }
	}
      }
      if (hit3->hittype == SPLICE) {
	debug10(printf("Have splice on 3' end\n"));
	substring1 = (Substring_T) List_head(hit3->substrings_1toN);
	if (Substring_alignend_trim(substring1) > hit5->genomicstart) {
	  substringN = (Substring_T) List_head(hit3->substrings_Nto1);
	  if (Substring_alignstart_trim(substringN) < hit5->genomicend) {
	    overreach3p = true;
	  }
	}
      }

      if (overreach5p == true || overreach3p == true) {
	/* Either overreach */
	debug0(printf("  Returning NULL because of dual overreach\n"));
	Stage3end_free(&hit5); /* This was the copy */
	Stage3end_free(&hit3); /* This was the copy */
	FREE_OUT(new);
	return (Stage3pair_T) NULL;

#if 0
      } else if (overreach5p == true) {
	/* Overreach of hit5 */
	debug9(printf("Overreach of hit5 of type SPLICE.  Removing substring2\n"));
	if (hit5->sensedir == SENSE_FORWARD) {
	  copy = Stage3end_new_splice(&found_score,/*nmismatches_donor*/Substring_nmismatches_bothdiff(hit5->substring1),
				      /*nmismatches_acceptor*/0,/*donor*/hit5->substring1,/*acceptor*/NULL,/*distance*/0U,
				      /*shortdistancep*/true,localsplicing_penalty,hit5->querylength,/*amb_length*/0,/*amb_prob*/0.0,
				      /*alts_coords_donor*/NULL,/*alts_coords_acceptor*/NULL,
				      /*alts_nmismatches_donor*/NULL,/*alts_nmismatches_acceptor*/NULL,
				      /*alts_probs_donor*/NULL,/*alts_probs_acceptor*/NULL,
				      /*copy_donor_p*/true,/*copy_acceptor_p*/false,/*first_read_p*/true,
				      /*sensedir*/hit5->sensedir,listpool,hit5->method,hit5->level);
	} else if (hit5->sensedir == SENSE_ANTI) {
	  copy = Stage3end_new_splice(&found_score,/*nmismatches_donor*/0,
				      /*nmismatches_acceptor*/Substring_nmismatches_bothdiff(hit5->substring1),/*donor*/NULL,
				      /*acceptor*/hit5->substring1,/*distance*/0U,
				      /*shortdistancep*/true,localsplicing_penalty,hit5->querylength,/*amb_length*/0,/*amb_prob*/0.0,
				      /*alts_coords_donor*/NULL,/*alts_coords_acceptor*/NULL,
				      /*alts_nmismatches_donor*/NULL,/*alts_nmismatches_acceptor*/NULL,
				      /*alts_probs_donor*/NULL,/*alts_probs_acceptor*/NULL,
				      /*copy_donor_p*/false,/*copy_acceptor_p*/true,/*first_read_p*/true,
				      /*sensedir*/hit5->sensedir,listpool,hit5->method,hit5->level);
	} else {
	  abort();
	}
	Stage3end_free(&hit5);	/* This was the copy */
	hit5 = copy;

      } else if (overreach3p == true) {
	/* Overreach of hit3 */
	debug9(printf("Overreach of hit3 of type SPLICE.  Removing substring1\n"));
	if (hit3->sensedir == SENSE_FORWARD) {
	  copy = Stage3end_new_splice(&found_score,/*nmismatches_donor*/0,
				      /*nmismatches_acceptor*/Substring_nmismatches_bothdiff(hit3->substring2),/*donor*/NULL,
				      /*acceptor*/hit3->substring2,/*distance*/0U,
				      /*shortdistancep*/true,localsplicing_penalty,hit3->querylength,/*amb_length*/0,/*amb_prob*/0.0,
				      /*alts_coords_donor*/NULL,/*alts_coords_acceptor*/NULL,
				      /*alts_nmismatches_donor*/NULL,/*alts_nmismatches_acceptor*/NULL,
				      /*alts_probs_donor*/NULL,/*alts_probs_acceptor*/NULL,
				      /*copy_donor_p*/false,/*copy_acceptor_p*/true,/*first_read_p*/false,
				      /*sensedir*/hit3->sensedir,listpool,hit3->method,hit3->level);
	} else if (hit3->sensedir == SENSE_ANTI) {
	  copy = Stage3end_new_splice(&found_score,/*nmismatches_donor*/Substring_nmismatches_bothdiff(hit3->substring2),
				      /*nmismatches_acceptor*/0,/*donor*/hit3->substring2,/*acceptor*/NULL,/*distance*/0U,
				      /*shortdistancep*/true,localsplicing_penalty,hit3->querylength,/*amb_length*/0,/*amb_prob*/0.0,
				      /*alts_coords_donor*/NULL,/*alts_coords_acceptor*/NULL,
				      /*alts_nmismatches_donor*/NULL,/*alts_nmismatches_acceptor*/NULL,
				      /*alts_probs_donor*/NULL,/*alts_probs_acceptor*/NULL,
				      /*copy_donor_p*/true,/*copy_acceptor_p*/false,/*first_read_p*/false,
				      /*sensedir*/hit3->sensedir,listpool,hit3->method,hit3->level);
	} else {
	  abort();
	}
	Stage3end_free(&hit3);	/* This was the copy */
	hit3 = copy;
#endif
      }

      /* Try to resolve ambiguity on inside of concordant ends */
      debug9(printf("Calling resolve_inside_alts_splice_minus\n"));
      resolve_inside_alts_splice_minus(&alts_resolve_5,&alts_resolve_3,
				       &new->alts_status_inside,hit5,hit3,querylength5,querylength3);
      if (alts_resolve_5 >= 0) {
	resolve_ambiguity_5(hit5,mismatch_positions_alloc_5,spliceinfo5,query5_compress_rev,alts_resolve_5);
      }
      if (alts_resolve_3 >= 0) {
	resolve_ambiguity_3(hit3,mismatch_positions_alloc_3,spliceinfo3,query3_compress_rev,alts_resolve_3);
      }

      debug9(printf("For pair %p (%p and %p), set alts_resolve_5 to be %d and alts_resolve_3 to be %d\n",
		    new,hit5,hit3,alts_resolve_5,alts_resolve_3));
    }

    /* Have 3-end..start and 5-end..start */
    if (hit3->genomicstart < hit5->genomicend) {
      /* No overlap */
      new->pair_relationship = -1;
      new->insertlength = (hit5->genomicend - hit3->genomicstart) + querylength5 + querylength3;
      new->insertlength_expected_sign = insertlength_expected(new->insertlength);
      debug10(printf("minus, no overlap: insert length %d = end5 %u - start3 %u + %d + %d\n",
		     new->insertlength,hit5->genomicend - hit5->chroffset,
		     hit3->genomicstart - hit3->chroffset,querylength5,querylength3));
#if 0
    } else if (hit3->genomicstart > hit5->genomicstart + SUBSUMPTION_SLOP) {
      /* hit3 subsumes hit5 */
      debug10(printf("minus, subsumption %u > %u\n",
		     hit3->genomicstart - hit3->chroffset,hit5->genomicstart - hit5->chroffset));
      new->pair_relationship = 0;
      new->insertlength = 0;
      new->insertlength_expected_sign = false;
#endif
    } else {
      new->insertlength = pair_insert_length(&new->pair_relationship,hit5,hit3);
      new->insertlength_expected_sign = insertlength_expected(new->insertlength);
    }
  }

  debug10(printf("\nGot initial insertlength of %d\n",new->insertlength));

  new->hit5 = hit5;
  new->hit3 = hit3;

  /* Was new->insertlength <= 0, but this eliminates legitimate overlaps */
  /* Was new->insertlength < -pairmax, but this allows overreach */
  if (new->insertlength <= 0) {	/* Not possible, since insertlength is unsigned */
    /* Not concordant */
#ifdef USE_BINGO
    new->absdifflength_bingo_p = false;
#endif
#ifdef USE_ABSDIFFLENGTH
    new->absdifflength = (Chrpos_T) -1;
#endif

    if (expect_concordant_p == true) {
      debug0(printf("  Returning NULL, because insertlength %u, so not concordant\n",new->insertlength));
      Stage3end_free(&hit5);	/* This was the copy */
      Stage3end_free(&hit3);	/* This was the copy */
      FREE_OUT(new);
      return (Stage3pair_T) NULL;
    }

  } else {
    if (transcriptome_guided_p == true) {
      pairmax = (Chrpos_T) -1;
    } else if (circularp[hit5->effective_chrnum] == true) {
      pairmax = pairmax_circular;
    } else {
      pairmax = pairmax_linear;
    }
    if (new->insertlength > pairmax && expect_concordant_p == true) {
      debug0(printf("  Returning NULL because insertlength %u > pairmax %d\n",new->insertlength,pairmax));
      Stage3end_free(&hit5);	/* This was the copy */
      Stage3end_free(&hit3);	/* This was the copy */
      FREE_OUT(new);
      return (Stage3pair_T) NULL;
      
    } else {
#ifdef USE_ABSDIFFLENGTH
      if (new->insertlength < expected_pairlength) {
	new->absdifflength = expected_pairlength - new->insertlength;
      } else {
	new->absdifflength = new->insertlength - expected_pairlength;
      }
#endif
#ifdef USE_BINGO
      if (new->absdifflength <= pairlength_deviation) {
	new->absdifflength_bingo_p = true;
      } else {
	new->absdifflength_bingo_p = false;
      }
#endif
    }
  }

  if (SENSE_CONSISTENT_P(hit5->sensedir_for_concordance,hit3->sensedir_for_concordance)) {
    debug0(printf("senses %d and %d are consistent\n",hit5->sensedir_for_concordance,hit3->sensedir_for_concordance));
    new->sense_consistent_p = true;

  } else if (expect_concordant_p == true) {
    debug0(printf("  Returning NULL, because senses are not consistent\n"));
    Stage3end_free(&hit5); 	/* This was the copy */
    Stage3end_free(&hit3);	/* This was the copy */
    FREE_OUT(new);
    return (Stage3pair_T) NULL;

  } else {
    debug0(printf("senses are inconsistent, but allowable\n"));
    new->sense_consistent_p = false;
  }

  new->concordant_transcripts_p = Transcript_concordant_p(hit5->transcripts_consistent,hit3->transcripts_consistent);

  /* No longer add scores from hit5 and hit3 */

  /* new->overlap_known_gene_p = false; -- initialized later when resolving multimappers */
  /* new->tally = -1L; */

  new->low_chrbound = (hit5->low_chrbound < hit3->low_chrbound) ? hit5->low_chrbound : hit3->low_chrbound;
  new->high_chrbound = (hit5->high_chrbound > hit3->high_chrbound) ? hit5->high_chrbound : hit3->high_chrbound;
  debug0(printf("hit5 %u..%u and hit3 %u..%u => %u..%u\n",
		hit5->low_chrbound,hit5->high_chrbound,hit3->low_chrbound,hit3->high_chrbound,
		new->low_chrbound,new->high_chrbound));

#if 0
  if (new->low > new->high) {
    fprintf(stderr,"new->low %u > new->high %u, hit5->chrnum %d\n",
	    new->low - new->chroffset,new->high - new->chroffset,hit5->chrnum);
    abort();
  }
#endif

  if (hit5->chrnum == 0 || hit3->chrnum == 0) {
    new->outerlength = querylength5 + querylength3;
  } else {
    assert(new->low_chrbound < new->high_chrbound);
    new->outerlength = new->high_chrbound - new->low_chrbound;
  }

  if (expect_concordant_p == true) {
    hit5_orig->paired_usedp = hit5->paired_usedp = true;
    hit3_orig->paired_usedp = hit3->paired_usedp = true;
  }

  new->nsplices = hit5->nsplices + hit3->nsplices;

  debug0(printf("Created new pair %p from %p and %p (nmatches_to_trims %d+%d) (spliced_trims %d+%d)\n",
		new,hit5,hit3,hit5->refalt_nmatches_to_trims,hit3->refalt_nmatches_to_trims,
		hit5->refalt_nmatches_plus_spliced_trims,hit3->refalt_nmatches_plus_spliced_trims));
  debug0(printf("  methods %s and %s\n",Method_string(hit5->method),Method_string(hit3->method)));
  debug0(printf("  sensedirs %d and %d\n",hit5->sensedir,hit3->sensedir));
  debug0(printf("  chrpos_1toN %u..%u and %u..%u\n",
		hit5->genomicstart - hit5->chroffset,hit5->genomicend - hit5->chroffset,
		hit3->genomicstart - hit3->chroffset,hit3->genomicend - hit3->chroffset));
  debug0(printf("  chrpos_LtoH %u..%u and %u..%u\n",
		hit5->low_trimmed - hit5->chroffset,hit5->high_trimmed - hit5->chroffset,
		hit3->low_trimmed - hit3->chroffset,hit3->high_trimmed - hit3->chroffset));
  debug0(printf("  outerlength %u = %u - %u\n",new->outerlength,new->high_chrbound,new->low_chrbound));

  if (hit5->circularpos < 0 && hit3->circularpos < 0) {
    new->circularp = false;
  } else {
    new->circularp = true;
  }

  /* Fixing insertlength for circular pairs */
  if (new->insertlength > hit5->chrlength) {
    new->insertlength -= hit5->chrlength;
  }

  if (hit5->circularalias == +1) {
    debug0(printf("Unaliasing 5' end\n"));
    unalias_circular(hit5);
  }

  if (hit3->circularalias == +1) {
    debug0(printf("Unaliasing 3' end\n"));
    unalias_circular(hit3);
  }

  /* assert((int) new->insertlength >= 0); */
  return new;
}


/* Used for eliminating exact duplicates.  Also sorts secondarily by hittype. */
static int
hitpair_sort_cmp (const void *a, const void *b) {
  Stage3pair_T x = * (Stage3pair_T *) a;
  Stage3pair_T y = * (Stage3pair_T *) b;
  
  Univcoord_T x_hit5_high, x_hit5_low, y_hit5_high, y_hit5_low;
  Univcoord_T x_hit3_high, x_hit3_low, y_hit3_high, y_hit3_low;
  Univcoord_T x_low, x_high, y_low, y_high;
  
  debug8(printf("  Comparing (%s-%s): %p, %d..%d|%d..%d, %u..%u|%u..%u (dir = %d), circularalias %d|%d, nmatches: %d+%d (%d+%d to trims), amb_lengths %d and %d, sensedirs %d-%d, score %f+%f, ntranscripts:%d+%d and %d+%d, concordant_transcripts:%d\n",
		Method_string(x->hit5->method),Method_string(x->hit3->method),x,
		x->hit5->querystart_trimmed,x->hit5->queryend_trimmed,
		x->hit3->querystart_trimmed,x->hit3->queryend_trimmed,
		x->hit5->low_trimmed - x->hit5->chroffset,x->hit5->high_trimmed - x->hit5->chroffset,
		x->hit3->low_trimmed - x->hit3->chroffset,x->hit3->high_trimmed - x->hit3->chroffset,
		x->dir,x->hit5->circularalias,x->hit3->circularalias,
		x->hit5->refalt_nmatches_plus_spliced_trims,x->hit3->refalt_nmatches_plus_spliced_trims,
		x->hit5->refalt_nmatches_to_trims,x->hit3->refalt_nmatches_to_trims,
		amb_length(x->hit5),amb_length(x->hit3),x->hit5->sensedir,x->hit3->sensedir,
		x->hit5->splice_score,x->hit3->splice_score,
		List_length(x->hit5->transcripts_consistent),List_length(x->hit5->transcripts_inconsistent),
		List_length(x->hit3->transcripts_consistent),List_length(x->hit3->transcripts_inconsistent),
		x->concordant_transcripts_p));

  debug8(printf("       with (%s-%s): %p, %d..%d|%d..%d, %u..%u|%u..%u (dir = %d), circularalias %d|%d, nmatches: %d+%d (%d+%d to trims), amb_lengths %d and %d, sensedirs %d-%d, score %f+%f, ntranscripts:%d+%d and %d+%d, concordant transcripts %d\n",
		Method_string(y->hit5->method),Method_string(y->hit3->method),y,
		y->hit5->querystart_trimmed,y->hit5->queryend_trimmed,
		y->hit3->querystart_trimmed,y->hit3->queryend_trimmed,
		y->hit5->low_trimmed - y->hit5->chroffset,y->hit5->high_trimmed - y->hit5->chroffset,
		y->hit3->low_trimmed - y->hit3->chroffset,y->hit3->high_trimmed - y->hit3->chroffset,
		y->dir,y->hit5->circularalias,y->hit3->circularalias,
		y->hit5->refalt_nmatches_plus_spliced_trims,y->hit3->refalt_nmatches_plus_spliced_trims,
		y->hit5->refalt_nmatches_to_trims,y->hit3->refalt_nmatches_to_trims,
		amb_length(y->hit5),amb_length(y->hit3),y->hit5->sensedir,y->hit3->sensedir,
		y->hit5->splice_score,y->hit3->splice_score,
		List_length(y->hit5->transcripts_consistent),List_length(y->hit5->transcripts_inconsistent),
		List_length(y->hit3->transcripts_consistent),List_length(y->hit3->transcripts_inconsistent),
		y->concordant_transcripts_p));

  x_hit5_low = normalize_coord(x->hit5->low_chrbound,x->hit5->circularalias,x->hit5->chrlength);
  x_hit5_high = normalize_coord(x->hit5->high_chrbound,x->hit5->circularalias,x->hit5->chrlength);

  x_hit3_low = normalize_coord(x->hit3->low_chrbound,x->hit3->circularalias,x->hit3->chrlength);
  x_hit3_high = normalize_coord(x->hit3->high_chrbound,x->hit3->circularalias,x->hit3->chrlength);

  x_low = (x_hit5_low < x_hit3_low) ? x_hit5_low : x_hit3_low;
  x_high = (x_hit5_high > x_hit3_high) ? x_hit5_high : x_hit3_high;


  y_hit5_low = normalize_coord(y->hit5->low_chrbound,y->hit5->circularalias,y->hit5->chrlength);
  y_hit5_high = normalize_coord(y->hit5->high_chrbound,y->hit5->circularalias,y->hit5->chrlength);

  y_hit3_low = normalize_coord(y->hit3->low_chrbound,y->hit3->circularalias,y->hit3->chrlength);
  y_hit3_high = normalize_coord(y->hit3->high_chrbound,y->hit3->circularalias,y->hit3->chrlength);

  y_low = (y_hit5_low < y_hit3_low) ? y_hit5_low : y_hit3_low;
  y_high = (y_hit5_high > y_hit3_high) ? y_hit5_high : y_hit3_high;


  if (x->dir != 0 && y->dir == 0) {
    return -1;
  } else if (x->dir == 0 && y->dir != 0) {
    return +1;
  } else if (x->dir > 0 && y->dir < 0) {
    return -1;
  } else if (x->dir < 0 && y->dir > 0) {
    return +1;

    /* low to high pattern needed for finding overlaps */
  } else if (x_low < y_low) {
    debug8(printf("Returning -1 for low\n"));
    return -1;
  } else if (y_low < x_low) {
    debug8(printf("Returning +1 for low\n"));
    return +1;

  } else if (x_high > y_high) {
    debug8(printf("Returning -1 for high\n"));
    return -1;
  } else if (y_high > x_high) {
    debug8(printf("Returning +1 for high\n"));
    return +1;

    /* Need to check inside ends to avoid declaring unequal hitpairs equal */
  } else if (x_hit5_low < y_hit5_low) {
    debug8(printf("Returning -1 for hit5_low\n"));
    return -1;
  } else if (y_hit5_low < x_hit5_low) {
    debug8(printf("Returning +1 for hit5_low\n"));
    return +1;

  } else if (x_hit5_high < y_hit5_high) {
    debug8(printf("Returning -1 for hit5_high\n"));
    return -1;
  } else if (y_hit5_high < x_hit5_high) {
    debug8(printf("Returning +1 for hit5_high\n"));
    return +1;

  } else if (x_hit3_low < y_hit3_low) {
    debug8(printf("Returning -1 for hit3_low\n"));
    return -1;
  } else if (y_hit3_low < x_hit3_low) {
    debug8(printf("Returning +1 for hit3_low\n"));
    return +1;

  } else if (x_hit3_high < y_hit3_high) {
    debug8(printf("Returning -1 for hit3_high\n"));
    return -1;
  } else if (y_hit3_high < x_hit3_high) {
    debug8(printf("Returning +1 for hit3_high\n"));
    return +1;

  } else if (x->sense_consistent_p == true && y->sense_consistent_p == false) {
    debug8(printf(" => loses by sense_consistent_p\n"));
    return -1;
  } else if (y->sense_consistent_p == true && x->sense_consistent_p == false) {
    debug8(printf(" => wins by sense_consistent_p\n"));
    return +1;

  } else if (x->concordant_transcripts_p == true && y->concordant_transcripts_p == false) {
    debug8(printf(" => loses by concordant_transcripts_p\n"));
    return -1;
  } else if (y->concordant_transcripts_p == true && x->concordant_transcripts_p == false) {
    debug8(printf(" => wins by concordant_transcripts_p\n"));
    return +1;

    /* We want to maximize trimming here to be consistent with transcripts */
  } else if ((x->hit5->queryend_trimmed - x->hit5->querystart_trimmed) +
	     (x->hit3->queryend_trimmed - x->hit3->querystart_trimmed) <
	     (y->hit5->queryend_trimmed - y->hit5->querystart_trimmed) +
	     (y->hit3->queryend_trimmed - y->hit3->querystart_trimmed)) {
    debug8(printf(" => loses by trimming\n"));
    return -1;
  } else if ((y->hit5->queryend_trimmed - y->hit5->querystart_trimmed) +
	     (y->hit3->queryend_trimmed - y->hit3->querystart_trimmed) <
	     (x->hit5->queryend_trimmed - x->hit5->querystart_trimmed) +
	     (x->hit3->queryend_trimmed - x->hit3->querystart_trimmed)) {
    debug8(printf(" => wins by trimming\n"));
    return +1;

  } else if (x->hit5->refalt_score_within_trims +
	     x->hit3->refalt_score_within_trims <
	     y->hit5->refalt_score_within_trims +
	     y->hit3->refalt_score_within_trims) {
    debug8(printf(" => loses by refalt_score_within_trims\n"));
    return -1;
  } else if (y->hit5->refalt_score_within_trims +
	     y->hit3->refalt_score_within_trims <
	     x->hit5->refalt_score_within_trims +
	     x->hit3->refalt_score_within_trims) {
    debug8(printf(" => wins by refalt_score_within_trims\n"));
    return +1;
  } else if (x->hit5->refalt_nmatches_plus_spliced_trims +
	     x->hit3->refalt_nmatches_plus_spliced_trims >
	     y->hit5->refalt_nmatches_plus_spliced_trims +
	     y->hit3->refalt_nmatches_plus_spliced_trims) {
    debug8(printf(" => loses by refalt_nmatches_plus_spliced_trims\n"));
    return -1;
  } else if (y->hit5->refalt_nmatches_plus_spliced_trims +
	     y->hit3->refalt_nmatches_plus_spliced_trims >
	     x->hit5->refalt_nmatches_plus_spliced_trims +
	     x->hit3->refalt_nmatches_plus_spliced_trims) {
    debug8(printf(" => wins by refalt_nmatches_plus_spliced_trims\n"));
    return +1;
  } else if (x->hit5->ref_nmatches_plus_spliced_trims +
	     x->hit3->ref_nmatches_plus_spliced_trims >
	     y->hit5->ref_nmatches_plus_spliced_trims +
	     y->hit3->ref_nmatches_plus_spliced_trims) {
    debug8(printf(" => loses by ref_nmatches_plus_spliced_trims\n"));
    return -1;
  } else if (y->hit5->ref_nmatches_plus_spliced_trims +
	     y->hit3->ref_nmatches_plus_spliced_trims >
	     x->hit5->ref_nmatches_plus_spliced_trims +
	     x->hit3->ref_nmatches_plus_spliced_trims) {
    debug8(printf(" => wins by ref_nmatches_plus_spliced_trims\n"));
    return +1;

  } else if (x->alts_status_inside < y->alts_status_inside) {
    return -1;
  } else if (y->alts_status_inside < x->alts_status_inside) {
    return +1;

  } else if (x->hit5->splice_score + x->hit3->splice_score >
	     y->hit5->splice_score + y->hit3->splice_score) {
    debug8(printf(" => loses by splice score\n"));
    return -1;

  } else if (y->hit5->splice_score + y->hit3->splice_score >
	     x->hit5->splice_score + x->hit3->splice_score) {
    debug8(printf(" => wins by splice score\n"));
    return +1;

    /* Prioritize first method used */
  } else if (x->hit5->method <= y->hit5->method &&
	     x->hit3->method < y->hit3->method) {
    return -1;

  } else if (y->hit5->method <= x->hit5->method &&
	     y->hit3->method < x->hit3->method) {
    return +1;

  } else if (x->hit3->method <= y->hit3->method &&
	     x->hit5->method < y->hit5->method) {
    return -1;

  } else if (y->hit3->method <= x->hit3->method &&
	     y->hit5->method < x->hit5->method) {
    return +1;

  } else {
    debug8(printf(" => identical for sorting purposes\n"));
    return 0;
  }
}


#if 0
/* Same as hitpair_sort_cmp, except for hittype, nmatches_to_trims, and indel_low */
static int
hitpair_equiv_cmp (Stage3pair_T x, Stage3pair_T y) {
  Univcoord_T x_hit5_high, x_hit5_low, y_hit5_high, y_hit5_low;
  Univcoord_T x_hit3_high, x_hit3_low, y_hit3_high, y_hit3_low;
  Univcoord_T x_low, x_high, y_low, y_high;
  
  x_hit5_low = normalize_coord(x->hit5->low_chrbound,x->hit5->circularalias,x->hit5->chrlength);
  x_hit5_high = normalize_coord(x->hit5->high_chrbound,x->hit5->circularalias,x->hit5->chrlength);

  x_hit3_low = normalize_coord(x->hit3->low_chrbound,x->hit3->circularalias,x->hit3->chrlength);
  x_hit3_high = normalize_coord(x->hit3->high_chrbound,x->hit3->circularalias,x->hit3->chrlength);

  x_low = (x_hit5_low < x_hit3_low) ? x_hit5_low : x_hit3_low;
  x_high = (x_hit5_high > x_hit3_high) ? x_hit5_high : x_hit3_high;


  y_hit5_low = normalize_coord(y->hit5->low_chrbound,y->hit5->circularalias,y->hit5->chrlength);
  y_hit5_high = normalize_coord(y->hit5->high_chrbound,y->hit5->circularalias,y->hit5->chrlength);

  y_hit3_low = normalize_coord(y->hit3->low_chrbound,y->hit3->circularalias,y->hit3->chrlength);
  y_hit3_high = normalize_coord(y->hit3->high_chrbound,y->hit3->circularalias,y->hit3->chrlength);

  y_low = (y_hit5_low < y_hit3_low) ? y_hit5_low : y_hit3_low;
  y_high = (y_hit5_high > y_hit3_high) ? y_hit5_high : y_hit3_high;


  if (x->dir != 0 && y->dir == 0) {
    return -1;
  } else if (x->dir == 0 && y->dir != 0) {
    return +1;
  } else if (x->dir > 0 && y->dir < 0) {
    return -1;
  } else if (x->dir < 0 && y->dir > 0) {
    return +1;
  } else if (x_low < y_low) {
    return -1;
  } else if (y_low < x_low) {
    return +1;
  } else if (x_high < y_high) {
    return -1;
  } else if (y_high < x_high) {
    return +1;

  } else if (x_hit5_low < y_hit5_low) {
    return -1;
  } else if (y_hit5_low < x_hit5_low) {
    return +1;
  } else if (x_hit5_high < y_hit5_high) {
    return -1;
  } else if (y_hit5_high < x_hit5_high) {
    return +1;

  } else if (x_hit3_low < y_hit3_low) {
    return -1;
  } else if (y_hit3_low < x_hit3_low) {
    return +1;
  } else if (x_hit3_high < y_hit3_high) {
    return -1;
  } else if (y_hit3_high < x_hit3_high) {
    return +1;

  } else if (x->hit5->refalt_nmatches_plus_spliced_trims +
	     x->hit3->refalt_nmatches_plus_spliced_trims >
	     y->hit5->refalt_nmatches_plus_spliced_trims +
	     y->hit3->refalt_nmatches_plus_spliced_trims) {
    return -1;

  } else if (y->hit5->refalt_nmatches_plus_spliced_trims +
	     y->hit3->refalt_nmatches_plus_spliced_trims >
	     x->hit5->refalt_nmatches_plus_spliced_trims +
	     x->hit3->refalt_nmatches_plus_spliced_trims) {
    return +1;

  } else if (x->hit5->ref_nmatches_plus_spliced_trims +
	     x->hit3->ref_nmatches_plus_spliced_trims >
	     y->hit5->ref_nmatches_plus_spliced_trims +
	     y->hit3->ref_nmatches_plus_spliced_trims) {
    return -1;

  } else if (y->hit5->ref_nmatches_plus_spliced_trims +
	     y->hit3->ref_nmatches_plus_spliced_trims >
	     x->hit5->ref_nmatches_plus_spliced_trims +
	     x->hit3->ref_nmatches_plus_spliced_trims) {
    return +1;

#if 0
    /* Causes hits to not be recognized as equivalent */
  } else if (x->nsplices < y->nsplices) {
    return -1;
  } else if (y->nsplices < x->nsplices) {
    return +1;
#endif

  } else if (x->alts_status_inside < y->alts_status_inside) {
    return -1;
  } else if (y->alts_status_inside < x->alts_status_inside) {
    return +1;

#if 0
  } else if (x->hit5->start_amb_length + x->hit5->end_amb_length +
	     x->hit3->start_amb_length + x->hit3->end_amb_length > 0 &&
	     y->hit5->start_amb_length + y->hit5->end_amb_length +
	     y->hit3->start_amb_length + y->hit3->end_amb_length == 0) {
    return -1;
  } else if (y->hit5->start_amb_length + y->hit5->end_amb_length +
	     y->hit3->start_amb_length + y->hit3->end_amb_length > 0 &&
	     x->hit5->start_amb_length + x->hit5->end_amb_length +
	     x->hit3->start_amb_length + x->hit3->end_amb_length == 0) {
    return +1;
#endif

  } else if (x->sense_consistent_p == true && y->sense_consistent_p == false) {
    return -1;
  } else if (x->sense_consistent_p == false && y->sense_consistent_p == true) {
    return +1;

#if 0
  } else if (x->indel_low < y->indel_low) {
    return -1;
  } else if (y->indel_low < x->indel_low) {
    return +1;
#endif

#if 0
  } else if (x->sense_consistent_p == true) {
    /* Used for sorting, but not equiv */
    if ((x->hit5->sensedir_for_concordance != 0 || x->hit3->sensedir_for_concordance != 0) &&
	(y->hit5->sensedir_for_concordance == 0 && y->hit3->sensedir_for_concordance == 0)) {
      return -1;
    } else if ((y->hit5->sensedir_for_concordance != 0 || y->hit3->sensedir_for_concordance != 0) &&
	       (x->hit5->sensedir_for_concordance == 0 && x->hit3->sensedir_for_concordance == 0)) {
      return +1;
    } else {
      return 0;
    }
#endif

#if 0
  } else if (x->hit5->sensedir_for_concordance == y->hit5->sensedir_for_concordance &&
	     x->hit3->sensedir_for_concordance == y->hit3->sensedir_for_concordance) {
    return 0;
  } else if (x->hit5->sensedir_for_concordance > y->hit5->sensedir_for_concordance) {
    return +1;
  } else if (y->hit5->sensedir_for_concordance > x->hit5->sensedir_for_concordance) {
    return -1;
  } else if (x->hit3->sensedir_for_concordance > y->hit3->sensedir_for_concordance) {
    return +1;
  } else if (y->hit3->sensedir_for_concordance > x->hit3->sensedir_for_concordance) {
    return -1;
#endif

  } else {
    return 0;
  }
}
#endif


static int
hitpair_position_cmp (const void *a, const void *b) {
  Stage3pair_T x = * (Stage3pair_T *) a;
  Stage3pair_T y = * (Stage3pair_T *) b;
  
  if (x->dir < y->dir) {
    return -1;
  } else if (y->dir < x->dir) {
    return +1;
  } else if (x->sensedir < y->sensedir) {
    return -1;
  } else if (y->sensedir < x->sensedir) {
    return +1;

  } else if (x->dir > 0) {
    if (x->hit5->low_chrbound < y->hit5->low_chrbound) {
      return -1;
    } else if (y->hit5->low_chrbound < x->hit5->low_chrbound) {
      return +1;
    } else if (x->hit3->high_chrbound > y->hit3->high_chrbound) {
      return -1;
    } else if (y->hit3->high_chrbound > x->hit3->high_chrbound) {
      return +1;
    } else {
      return 0;
    }

  } else if (x->dir < 0) {
    if (x->hit3->low_chrbound < y->hit3->low_chrbound) {
      return -1;
    } else if (y->hit3->low_chrbound < x->hit3->low_chrbound) {
      return +1;
    } else if (x->hit5->high_chrbound > y->hit5->high_chrbound) {
      return -1;
    } else if (y->hit5->high_chrbound > x->hit5->high_chrbound) {
      return +1;
    } else {
      return 0;
    }

  } else {
    return 0;
  }
}


static bool
hitpair_equal (Stage3pair_T x, Stage3pair_T y) {
  List_T p, q;
  Substring_T substring_x, substring_y;

  if (x->dir != y->dir) {
    return false;		/* Different strands */
  } else {
    p = x->hit5->substrings_1toN;
    q = y->hit5->substrings_1toN;
    while (p != NULL && q != NULL) {
      substring_x = (Substring_T) p->first;
      substring_y = (Substring_T) q->first;
      if (Substring_equal(substring_x,substring_y) == false) {
	return false;
      }
      p = List_next(p);
      q = List_next(q);
    }
    if (p != NULL || q != NULL) {
      return false;
    }

    p = x->hit3->substrings_1toN;
    q = y->hit3->substrings_1toN;
    while (p != NULL && q != NULL) {
      substring_x = (Substring_T) p->first;
      substring_y = (Substring_T) q->first;
      if (Substring_equal(substring_x,substring_y) == false) {
	return false;
      }
      p = List_next(p);
      q = List_next(q);
    }
    if (p != NULL || q != NULL) {
      return false;
    }

    return true;
  }
}


static bool
hitpair_overlap_p (Stage3pair_T x, Stage3pair_T y) {
  /* printf("Checking for overlap of %u..%u and %u..%u ",
     x->low_chrbound,x->high_chrbound,y->low_chrbound,y->high_chrbound); */
  if (x->hit5->chrnum != y->hit5->chrnum) {
    /* printf("=> false\n"); */
    return false;		/* Different chrnums */
  } else if (x->hit3->chrnum != y->hit3->chrnum) {
    return false;		/* Different chrnums */
  } else if (x->dir != y->dir) {
    /* printf("=> false\n"); */
    return false;		/* Different strands */
  } else if (x->high_chrbound < y->low_chrbound) {
    /* printf("=> false\n"); */
    return false;
  } else if (x->low_chrbound > y->high_chrbound) {
    /* printf("=> false\n"); */
    return false;
  } else {
    /* printf("=> true\n"); */
    return true;
  }
}


static bool
hitpair_subsumption (Stage3pair_T x, Stage3pair_T y) {
  if (x->dir != y->dir) {
    return false;		/* Different strands */

  } else if (x->dir == 0) {
    return false;

  } else if (x->sensedir != y->sensedir) {
    return false;

  } else if (x->dir > 0 && x->hit5->low_chrbound <= y->hit5->low_chrbound &&
	     x->hit3->high_chrbound >= y->hit3->high_chrbound) {
    return true;

  } else if (x->dir < 0 && x->hit3->low_chrbound <= y->hit3->low_chrbound &&
	     x->hit5->high_chrbound >= y->hit5->high_chrbound) {
    return true;
    
    /* Test each end of the pair.  Example: 1586..1512 and 1400..1468 should subsume 1586..1512 and 1564..1617 */
  } else if (x->hit5->low_chrbound <= y->hit5->low_chrbound &&
	     x->hit5->high_chrbound >= y->hit5->high_chrbound) {
    return true;
  } else if (y->hit5->low_chrbound <= x->hit5->low_chrbound &&
	     y->hit5->high_chrbound >= x->hit5->high_chrbound) {
    return true;

  } else if (x->hit3->low_chrbound <= y->hit3->low_chrbound &&
	     x->hit3->high_chrbound >= y->hit3->high_chrbound) {
    return true;
  } else if (y->hit3->low_chrbound <= x->hit3->low_chrbound &&
	     y->hit3->high_chrbound >= x->hit3->high_chrbound) {
    return true;

  } else {
    return false;
  }
}


static int
pair_matches_cmp (const void *a, const void *b) {
  Stage3pair_T x = * (Stage3pair_T *) a;
  Stage3pair_T y = * (Stage3pair_T *) b;

  if (x->hit5->refalt_nmatches_plus_spliced_trims +
      x->hit3->refalt_nmatches_plus_spliced_trims >
      y->hit5->refalt_nmatches_plus_spliced_trims +
      y->hit3->refalt_nmatches_plus_spliced_trims) {
    return -1;
  } else if (y->hit5->refalt_nmatches_plus_spliced_trims +
	     y->hit3->refalt_nmatches_plus_spliced_trims >
	     x->hit5->refalt_nmatches_plus_spliced_trims +
	     x->hit3->refalt_nmatches_plus_spliced_trims) {
    return +1;
  } else if (x->hit5->ref_nmatches_plus_spliced_trims +
	     x->hit3->ref_nmatches_plus_spliced_trims >
	     y->hit5->ref_nmatches_plus_spliced_trims +
	     y->hit3->ref_nmatches_plus_spliced_trims) {
    return -1;
  } else if (y->hit5->ref_nmatches_plus_spliced_trims +
	     y->hit3->ref_nmatches_plus_spliced_trims >
	     x->hit5->ref_nmatches_plus_spliced_trims +
	     x->hit3->ref_nmatches_plus_spliced_trims) {
    return +1;
  } else {
    return 0;
  }
}

List_T
Stage3pair_sort_bymatches (List_T hits, Hitlistpool_T hitlistpool) {
  List_T sorted = NULL;
  Stage3pair_T *array;
  int n, i;

  
  if ((n = List_length(hits)) == 0) {
    return (List_T) NULL;
  } else {
#ifdef USE_ALLOCA_FOR_HITS
    array = (Stage3pair_T *) MALLOCA(n * sizeof(Stage3pair_T));
    List_fill_array((void **) array,hits);
    Hitlist_free(&hits);
#else
    array = (Stage3pair_T *) List_to_array(hits,NULL);
    Hitlist_free(&hits);
#endif

    qsort(array,n,sizeof(Stage3pair_T),pair_matches_cmp);
    for (i = n-1; i >= 0; i--) {
      sorted = Hitlist_push(sorted,hitlistpool,(void *) array[i]);
    }
#ifdef USE_ALLOCA_FOR_HITS
    FREEA(array);
#else
    FREE(array);
#endif

    return sorted;
  }
}



#if 0
List_T
Stage3pair_remove_duplicates_exact (List_T hitpairlist) {
  List_T unique = NULL;
  Stage3pair_T hitpair, *hitpairs;
  int n, i, j;
  bool *eliminate;

  debug8(printf("Entered Stage3pair_remove_duplicates_exact with %d pairs\n",n));
  if ((n = List_length(hitpairlist)) == 0) {
    return NULL;
  } else {
#ifdef USE_ALLOCA_FOR_HITS
    eliminate = (bool *) CALLOCA(n,sizeof(bool));
    hitpairs = (Stage3pair_T *) MALLOCA(n * sizeof(Stage3pair_T));
    List_fill_array((void **) hitpairs,hitpairlist);
    Hitlist_free(&hitpairlist);
#else
    eliminate = (bool *) CALLOC(n,sizeof(bool));
    hitpairs = (Stage3pair_T *) List_to_array(hitpairlist,NULL);
    Hitlist_free(&hitpairlist);
#endif
  }

  debug8(printf("Checking for exact duplicates\n"));
  qsort(hitpairs,n,sizeof(Stage3pair_T),hitpair_sort_cmp);

  debug8(
	 for (i = 0; i < n; i++) {
	   hitpair = hitpairs[i];
	   printf("  Initial %d (%s-%s): %p, %d..%d|%d..%d, %u..%u|%u..%u (dir = %d), circularalias %d|%d, nmatches: %d (%d to_trims)\n",
		  i,Method_string(hitpair->hit5->method),Method_string(hitpair->hit3->method),hitpair,
		  hitpair->hit5->querystart_trimmed,hitpair->hit5->queryend_trimmed,
		  hitpair->hit3->querystart_trimmed,hitpair->hit3->queryend_trimmed,
		  hitpair->hit5->low_trimmed - hitpair->hit5->chroffset,hitpair->hit5->high_trimmed - hitpair->hit5->chroffset,
		  hitpair->hit3->low_trimmed - hitpair->hit3->chroffset,hitpair->hit3->high_trimmed - hitpair->hit3->chroffset,
		  hitpair->dir,hitpair->hit5->circularalias,hitpair->hit3->circularalias,
		  hitpair->nmatches_plus_spliced_trims,hitpair->nmatches_to_trims);
	 }
	 );

  i = 0;
  while (i < n) {
    j = i+1;
    while (j < n && hitpair_equal(hitpairs[j],hitpairs[i]) == true) {
      debug8(printf("  %d is identical to %d => eliminating\n",j,i));
      eliminate[j] = true;
      j++;
    }
    i = j;
  }

  for (i = n-1; i >= 0; i--) {
    hitpair = hitpairs[i];
    if (eliminate[i] == false) {
      unique = Hitlist_push(unique,hitlistpool,(void *) hitpair);
    } else {
      Stage3pair_free(&hitpair);
    }
  }

#ifdef USE_ALLOCA_FOR_HITS
  FREEA(hitpairs);
  FREEA(eliminate);
#else
  FREE(hitpairs);
  FREE(eliminate);
#endif

  debug8(printf("Exited Stage3pair_remove_duplicates_exact with %d pairs\n",List_length(unique)));
  return unique;
}
#endif


static int
hitpair_goodness_cmp (bool *equalp, Stage3pair_T hitpair,
		      Stage3pair_T best_hitpair, bool finalp) {
  double prob1, prob2;
  /* Chrpos_T total_querylength, best_total_querylength; */
  double zscore, best_zscore;

#if 0
  int hitpair_nmatches, best_hitpair_nmatches;
  int max_querystart_trimmed, max_queryend_trimmed;
  Stage3end_T hit5, besthit5, hit3, besthit3;

  if (hitpair->absdifflength_bingo_p < best_hitpair->absdifflength_bingo_p) {
    /* k is worse */
    debug8(printf(" => loses by absdifflength (bingo)\n"));
    return -1;
  } else if (hitpair->absdifflength_bingo_p > best_hitpair->absdifflength_bingo_p) {
    /* k is better */
    debug8(printf(" => wins by absdifflength (bingo)\n"));
    return +1;
  }
#endif

#ifdef PRE_RESOLVE_MULTIMAPPING
  if (TALLY_RATIO*Stage3pair_tally(hitpair) < Stage3pair_tally(best_hitpair)) {
    /* k is worse */
    debug8(printf(" => loses by tally\n"));
    return -1;
  } else if (Stage3pair_tally(hitpair) > TALLY_RATIO*Stage3pair_tally(best_hitpair)) {
    /* k is better */
    debug8(printf(" => wins by tally\n"));
    return +1;
  }
#endif

  *equalp = false;

#if 0
  /* Don't want to use nmatches_to_trims */
  /* Previously, we favored ambiguous splices over definitive ones, but
     now that we are generating Stage3end_T objects with and without the
     end exons, we prefer definitive splices */
  if (known_ambiguous_p(hitpair->hit5) == true && known_ambiguous_p(best_hitpair->hit5) == false &&
      known_ambiguous_p(hitpair->hit3) == known_ambiguous_p(best_hitpair->hit3) &&
      hitpair->insertlength <= best_hitpair->insertlength) {
    debug8(printf("Case 1\n"));
    return -1;

  } else if (known_ambiguous_p(hitpair->hit5) == false && known_ambiguous_p(best_hitpair->hit5) == true &&
	     known_ambiguous_p(hitpair->hit3) == known_ambiguous_p(best_hitpair->hit3) &&
	     hitpair->insertlength >= best_hitpair->insertlength) {
    debug8(printf("Case 2\n"));
    return +1;

  } else if (known_ambiguous_p(hitpair->hit3) == true && known_ambiguous_p(best_hitpair->hit3) == false &&
	     known_ambiguous_p(hitpair->hit5) == known_ambiguous_p(best_hitpair->hit5) &&
	     hitpair->insertlength <= best_hitpair->insertlength) {
    debug8(printf("Case 3\n"));
    return -1;

  } else if (known_ambiguous_p(hitpair->hit3) == false && known_ambiguous_p(best_hitpair->hit3) == true &&
	     known_ambiguous_p(hitpair->hit5) == known_ambiguous_p(best_hitpair->hit5) &&
	     hitpair->insertlength > best_hitpair->insertlength) {
    debug8(printf("Case 4\n"));
    return +1;
  }
#endif
 

  if (hitpair->hit5->refalt_nmatches_plus_spliced_trims +
      hitpair->hit3->refalt_nmatches_plus_spliced_trims >
      best_hitpair->hit5->refalt_nmatches_plus_spliced_trims + 
      best_hitpair->hit3->refalt_nmatches_plus_spliced_trims + NMATCHES_SLOP) {
    /* Significantly more matches */
    debug8(printf("More matches (to_trims)\n"));
    return +1;
  } else if (hitpair->hit5->refalt_nmatches_plus_spliced_trims +
	     hitpair->hit3->refalt_nmatches_plus_spliced_trims <
	     best_hitpair->hit5->refalt_nmatches_plus_spliced_trims +
	     best_hitpair->hit3->refalt_nmatches_plus_spliced_trims - NMATCHES_SLOP) {
    /* Fewer matches */
    debug8(printf("Fewer matches (to_trims)\n"));
    return -1;

#if 0
  } else if ((hitpair->hit5->hittype != TRANSCRIPTOME || hitpair->hit3->hittype != TRANSCRIPTOME) &&
	     (best_hitpair->hit5->hittype == TRANSCRIPTOME || best_hitpair->hit3->hittype == TRANSCRIPTOME)) {
    /* k is worse */
    debug8(printf(" => loses by transcriptome\n"));
    return -1;

  } else if ((hitpair->hit5->hittype == TRANSCRIPTOME || hitpair->hit3->hittype == TRANSCRIPTOME) &&
	     (best_hitpair->hit5->hittype != TRANSCRIPTOME || best_hitpair->hit3->hittype != TRANSCRIPTOME)) {
    /* k is better */
    debug8(printf(" => wins by transcriptome\n"));
    return +1;
#endif

#if 0
  } else if (hitpair->nmatches_plus_spliced_trims < best_hitpair->nmatches_plus_spliced_trims - NMATCHES_SLOP) {
    /* k is worse */
    debug8(printf(" => loses by nmatches\n"));
    return -1;
  } else if (hitpair->nmatches_plus_spliced_trims > best_hitpair->nmatches_plus_spliced_trims + NMATCHES_SLOP) {
    /* k is better */
    debug8(printf(" => wins by nmatches\n"));
    return +1;
#endif

#if 0
  } else if (hitpair->nsplices > best_hitpair->nsplices) {
    /* k is worse */
    debug8(printf(" => loses by nsplices: %d > %d in best\n",hitpair->nsplices,best_hitpair->nsplices));
    return -1;
  } else if (hitpair->nsplices < best_hitpair->nsplices) {
    /* k is better */
    debug8(printf(" => wins by nsplices: %d < %d in best\n",hitpair->nsplices,best_hitpair->nsplices));
    return +1;
#endif

  } else if (hitpair->alts_status_inside > best_hitpair->alts_status_inside) {
    /* k is worse */
    debug8(printf(" => loses by alts_status_inside\n"));
    return -1;
  } else if (hitpair->alts_status_inside < best_hitpair->alts_status_inside) {
    /* k is better */
    debug8(printf(" => wins by alts_status_inside\n"));
    return +1;


  } else if (hitpair->hit5->hittype > best_hitpair->hit5->hittype &&
	     hitpair->hit3->hittype >= best_hitpair->hit3->hittype) {
    /* k is worse */
    debug8(printf(" => loses by hittype\n"));
    return -1;

  } else if (hitpair->hit5->hittype >= best_hitpair->hit5->hittype &&
	     hitpair->hit3->hittype > best_hitpair->hit3->hittype) {
    /* k is worse */
    debug8(printf(" => loses by hittype\n"));
    return -1;

  } else if (hitpair->hit5->hittype < best_hitpair->hit5->hittype &&
	     hitpair->hit3->hittype <= best_hitpair->hit3->hittype) {
    /* k is better */
    debug8(printf(" => wins by hittype\n"));
    return +1;

  } else if (hitpair->hit5->hittype <= best_hitpair->hit5->hittype &&
	     hitpair->hit3->hittype < best_hitpair->hit3->hittype) {
    /* k is better */
    debug8(printf(" => wins by hittype\n"));
    return +1;

#if 0
  } else if (n_amb_ends(hitpair->hit5) + n_amb_ends(hitpair->hit3) >
	     n_amb_ends(best_hitpair->hit5) + n_amb_ends(best_hitpair->hit3)) {
    /* k is worse */
    debug8(printf(" => loses by ambiguity\n"));
    return -1;

  } else if (n_amb_ends(hitpair->hit5) + n_amb_ends(hitpair->hit3) <
	     n_amb_ends(best_hitpair->hit5) + n_amb_ends(best_hitpair->hit3)) {
    /* k is better */
    debug8(printf(" => wins by ambiguity\n"));
    return +1;
#endif

  } else if (hitpair->hit5->splice_score + hitpair->hit3->splice_score >
	     best_hitpair->hit5->splice_score + best_hitpair->hit3->splice_score) {
    /* k is worse */
    debug8(printf(" => loses by splice score\n"));
    return -1;

  } else if (hitpair->hit5->splice_score + hitpair->hit3->splice_score >
	     best_hitpair->hit5->splice_score + best_hitpair->hit3->splice_score) {
    /* k is better */
    debug8(printf(" => wins by splice score\n"));
    return +1;

#if 0
  } else if (hitpair->absdifflength < best_hitpair->absdifflength) {
    /* k is worse */
    debug8(printf(" => loses by absdifflength\n"));
    return -1;
  } else if (hitpair->absdifflength > best_hitpair->absdifflength) {
    /* k is better */
    debug8(printf(" => wins by absdifflength\n"));
    return +1;
#endif

  } else if (finalp == false) {
    debug8(printf("  => indistinguishable\n"));
    return 0;

#ifdef USE_ABSDIFFLENGTH
    /* If insert length is within deviation of expected pairlength, favor it */
  } else if (best_hitpair->absdifflength <= (Chrpos_T) pairlength_deviation &&
	     hitpair->absdifflength > (Chrpos_T) pairlength_deviation) {
    /* k is worse */
    debug8(printf(" => loses by absdifflength within deviation %d\n",pairlength_deviation));
    return -1;
  } else if (hitpair->absdifflength <= (Chrpos_T) pairlength_deviation &&
	     best_hitpair->absdifflength > (Chrpos_T) pairlength_deviation) {
    /* k is better */
    debug8(printf(" => wins by absdifflength within deviation %d\n",pairlength_deviation));
    return +1;
#endif

#if 0
    /* Previously favored longer insert lengths to give more compact
       splices.  However, we now accept splices first that give
       expected pairlength */
  } else if (hitpair->insertlength_expected_sign == -1 && best_hitpair->insertlength_expected_sign == +1) {
    /* k is worse */
    debug8(printf(" => loses by insertlength_expected_sign\n"));
    return -1;
  } else if (hitpair->insertlength_expected_sign == +1 && best_hitpair->insertlength_expected_sign == -1) {
    /* k is better */
    debug8(printf(" => wins by insertlength_expected_sign\n"));
    return +1;
#endif

    /* Next we look at splice probability */
  } else {
    debug8(printf(" => prob"));
    prob1 = Stage3end_prob(hitpair->hit5) + Stage3end_prob(hitpair->hit3);
    prob2 = Stage3end_prob(best_hitpair->hit5) + Stage3end_prob(best_hitpair->hit3);
    if (prob1 + 0.3 < prob2) {
      /* k is worse */
      debug8(printf(" => loses by dual splice prob %f vs %f\n",prob1,prob2));
      return -1;
    } else if (prob1 > prob2 + 0.3) {
      /* k is better */
      debug8(printf(" => wins by dual splice prob %f vs %f\n",prob1,prob2));
      return +1;
    } else {
      debug8(printf(" => neither wins\n"));
    }


#if 0
    /* Overlapping ends worse than separate ends */
    total_querylength = (Chrpos_T) (hitpair->hit5->querylength + hitpair->hit3->querylength);
    best_total_querylength = (Chrpos_T) (best_hitpair->hit5->querylength + best_hitpair->hit3->querylength);

    if (hitpair->insertlength <= total_querylength && best_hitpair->insertlength > best_total_querylength) {
      debug8(printf(" => loses by being overlapping\n"));
      return -1;
    } else if (hitpair->insertlength > total_querylength && best_hitpair->insertlength <= best_total_querylength) {
      debug8(printf(" => wins by being separate\n"));
      return +1;

      /* Next, favor shorter outerlengths to give more compact splices or closer pairs */
    } else if (hitpair->outerlength > best_hitpair->outerlength + OUTERLENGTH_SLOP) {
      /* k is worse */
      debug8(printf(" => loses by outerlength\n"));
      return -1;
    } else if (hitpair->outerlength + OUTERLENGTH_SLOP < best_hitpair->outerlength) {
      /* k is better */
      debug8(printf(" => wins by outerlength\n"));
      return +1;
      
    } else {
#if 0
      if (hitpair->insertlength_expected_sign >= 0 && best_hitpair->insertlength_expected_sign >= 0) {
	/* Both insert lengths are short, so favor shorter insert length */
	debug8(printf(" => short insertlengths"));
	/* Favor shorter insert lengths */
	if (hitpair->insertlength > best_hitpair->insertlength) {
	  /* k is worse */
	  debug8(printf(" => loses by insertlength\n"));
	  return -1;
	} else if (hitpair->insertlength < best_hitpair->insertlength) {
	  /* k is better */
	  debug8(printf(" => wins by insertlength\n"));
	  return +1;
	}
      }
#endif

      /* Both insert lengths are long, so favor longer insert length to give more compact splices */
      debug8(printf(" => long insertlengths"));
      if (hitpair->insertlength < best_hitpair->insertlength) {
	/* k is worse */
	debug8(printf(" => loses by insertlength\n"));
	return -1;
      } else if (hitpair->insertlength > best_hitpair->insertlength) {
	/* k is better */
	debug8(printf(" => wins by insertlength\n"));
	return +1;
      }

      debug8(printf("  => equal\n"));
      *equalp = true;
      return 0;
    }
#endif

    /* Look at expected pairlength and pairlength deviation */
    if (hitpair->insertlength < expected_pairlength) {
      zscore = (double) (expected_pairlength - (Chrpos_T) hitpair->insertlength) / (double) pairlength_deviation;
    } else {
      zscore = (double) ((Chrpos_T) hitpair->insertlength - expected_pairlength) / (double) pairlength_deviation;
    }
    if (best_hitpair->insertlength < expected_pairlength) {
      best_zscore = (double) (expected_pairlength - (Chrpos_T) best_hitpair->insertlength) / (double) pairlength_deviation;
    } else {
      best_zscore = (double) ((Chrpos_T) best_hitpair->insertlength - expected_pairlength) / (double) pairlength_deviation;
    }
    debug8(printf("expected_pairlength %u, pairlength_deviation %u\n",expected_pairlength,pairlength_deviation));
    debug8(printf("Comparing insertlength %d (z score %f) with best_insertlength %d (zscore %f)\n",
		  hitpair->insertlength,zscore,best_hitpair->insertlength,best_zscore));

    if (zscore > best_zscore + 1.0) {
      /* k is worse */
      debug8(printf(" => loses by insertlength and zscore\n"));
      return -1;
    } else if (best_zscore > zscore + 1.0) {
      /* k is better */
      debug8(printf(" => wins by insertlength and zscore\n"));
      return +1;
    }
    
    debug8(printf("  => equal\n"));
    *equalp = true;
    return 0;
  }
}


#if 0
static bool
hitpair_bad_superstretch_p (Stage3pair_T hitpair_k, Stage3pair_T *hitpairs, int k, int j,
			    bool finalp) {
  int a;
  bool equalp;

  for (a = k+1; a <= j; a++) {
    if (hitpair_subsumption(hitpair_k,hitpairs[a]) == true) {
      debug8(printf("Testing %d because stretches over %d",k,a));
      if (hitpair_goodness_cmp(&equalp,hitpairs[a],
			       hitpair_k,finalp) > 0 || equalp == true) {
	debug8(printf(" => eliminating\n"));
	return true;
      }
      debug8(printf("\n"));
    }
  }
  return false;
}
#endif


/* Recursive, list-based approach */
static List_T
pair_remove_bad_superstretches (bool *keep_p, Stage3pair_T superstretch, List_T list,
				Hitlistpool_T hitlistpool,
				int querylength5, int querylength3, bool finalp) {
  List_T result = NULL, p, q, r;
  /* Stage3pair_T bestpair; -- Needed when we transferred transcripts; */
  Stage3pair_T stage3pair, hitpair;
  Chrpos_T best_insertlength, best_outerlength;
  Method_T best_method_5, best_method_3;
  int best_nmatches_to_trims, best_nsegments, nsegments;
  double max_splice_score, splice_score;
  bool equalp;

  *keep_p = true;

  p = list;
  while (p != NULL) {
    stage3pair = (Stage3pair_T) List_head(p);

    q = List_next(p);
    while (q != NULL && hitpair_subsumption(stage3pair,(Stage3pair_T) List_head(q)) == true) {
#ifdef DEBUG8
      printf("  This (%s-%s): %p, %d..%d|%d..%d, %u..%u|%u..%u (dir = %d), nmatches: %d+%d (%d+%d to trims), insertlength %d, alts_status_inside %d, amb_lengths %d and %d\n",
	     Method_string(stage3pair->hit5->method),Method_string(stage3pair->hit3->method),stage3pair,
	     stage3pair->hit5->querystart_trimmed,stage3pair->hit5->queryend_trimmed,
	     stage3pair->hit3->querystart_trimmed,stage3pair->hit3->queryend_trimmed,
	     stage3pair->hit5->low_trimmed - stage3pair->hit5->chroffset,stage3pair->hit5->high_trimmed - stage3pair->hit5->chroffset,
	     stage3pair->hit3->low_trimmed - stage3pair->hit3->chroffset,stage3pair->hit3->high_trimmed - stage3pair->hit3->chroffset,
	     stage3pair->dir,stage3pair->hit5->refalt_nmatches_plus_spliced_trims,stage3pair->hit3->refalt_nmatches_plus_spliced_trims,
	     stage3pair->hit5->refalt_nmatches_to_trims,stage3pair->hit3->refalt_nmatches_to_trims,
	     stage3pair->insertlength,stage3pair->alts_status_inside,amb_length(stage3pair->hit5),amb_length(stage3pair->hit3));

      hitpair = (Stage3pair_T) List_head(q);
      printf("subsumes that (%s-%s): %p, %d..%d|%d..%d, %u..%u|%u..%u (dir = %d), nmatches: %d+%d (%d+%d to trims), insertlength %d, alts_status_inside %d, amb_lengths %d and %d\n",
	     Method_string(hitpair->hit5->method),Method_string(hitpair->hit3->method),hitpair,
	     hitpair->hit5->querystart_trimmed,hitpair->hit5->queryend_trimmed,
	     hitpair->hit3->querystart_trimmed,hitpair->hit3->queryend_trimmed,
	     hitpair->hit5->low_trimmed - hitpair->hit5->chroffset,hitpair->hit5->high_trimmed - hitpair->hit5->chroffset,
	     hitpair->hit3->low_trimmed - hitpair->hit3->chroffset,hitpair->hit3->high_trimmed - hitpair->hit3->chroffset,
	     hitpair->dir,hitpair->hit5->refalt_nmatches_plus_spliced_trims,hitpair->hit3->refalt_nmatches_plus_spliced_trims,
	     hitpair->hit5->refalt_nmatches_to_trims,hitpair->hit3->refalt_nmatches_to_trims,
	     hitpair->insertlength,hitpair->alts_status_inside,amb_length(hitpair->hit5),amb_length(hitpair->hit3));
#endif
      q = List_next(q);
    }

    if (q == p) {
      result = Hitlist_push(result,hitlistpool,(void *) stage3pair);
      if (superstretch != NULL && 
	  (hitpair_goodness_cmp(&equalp,stage3pair,superstretch,finalp) > 0 || equalp == true)) {
	*keep_p = false;
      }
      p = List_next(q);

    } else {
      /* Cluster */

      /* (1) Find smallest insert length with slop within loci */
      debug8(printf("(1) Finding smallest insertlength with slop within loci\n"));
      best_insertlength = (Chrpos_T) -1;
      for (r = p; r != q; r = List_next(r)) {
	hitpair = (Stage3pair_T) r->first;
	if (hitpair->insertlength < best_insertlength) {
	  best_insertlength = hitpair->insertlength;
	  /* bestpair = hitpair; */
	}
      }

      for (r = p; r != q; r = List_next(r)) {
	hitpair = (Stage3pair_T) r->first;

	if (hitpair->insertlength > best_insertlength + INSERTLENGTH_SLOP) {  /* Initial slop */
	  debug8(printf("Final (insertlength %u > %u): Eliminating hit pair %p at %d..%d|%d..%d, %u..%u|%u..%u with nmatches %d+%d (%d+%d to trims), ref %d+%d (%d+%d)\n",
			hitpair->insertlength,best_insertlength,hitpair,
			hitpair->hit5->querystart_trimmed,hitpair->hit5->queryend_trimmed,
			hitpair->hit3->querystart_trimmed,hitpair->hit3->queryend_trimmed,
			hitpair->hit5->low_trimmed - hitpair->hit5->chroffset,hitpair->hit5->high_trimmed - hitpair->hit5->chroffset,
			hitpair->hit3->low_trimmed - hitpair->hit3->chroffset,hitpair->hit3->high_trimmed - hitpair->hit3->chroffset,
			hitpair->hit5->refalt_nmatches_plus_spliced_trims,hitpair->hit3->refalt_nmatches_plus_spliced_trims,
			hitpair->hit5->refalt_nmatches_to_trims,hitpair->hit3->refalt_nmatches_to_trims,
			hitpair->hit5->ref_nmatches_plus_spliced_trims,hitpair->hit3->ref_nmatches_plus_spliced_trims,
			hitpair->hit5->ref_nmatches_to_trims,hitpair->hit3->ref_nmatches_to_trims));
	  /* transfer_transcripts(bestpair->hit5,hitpair->hit5,listpool); */
	  /* transfer_transcripts(bestpair->hit3,hitpair->hit3,listpool); */
	  Stage3pair_free(&hitpair);
	  r->first = (Stage3pair_T) NULL;
	  *keep_p = false;

	} else {
	  debug8(printf("Final (insertlength %u, outerlength %u): Keeping hit pair %p at %d..%d|%d..%d, %u..%u|%u..%u (%d+%d substrings) with nmatches %d+%d (%d+%d to trims), ref %d+%d (%d+%d)\n",
			hitpair->insertlength,hitpair->outerlength,hitpair,
			hitpair->hit5->querystart_trimmed,hitpair->hit5->queryend_trimmed,
			hitpair->hit3->querystart_trimmed,hitpair->hit3->queryend_trimmed,
			hitpair->hit5->low_trimmed - hitpair->hit5->chroffset,hitpair->hit5->high_trimmed - hitpair->hit5->chroffset,
			hitpair->hit3->low_trimmed - hitpair->hit3->chroffset,hitpair->hit3->high_trimmed - hitpair->hit3->chroffset,
			List_length(hitpair->hit5->substrings_1toN),List_length(hitpair->hit3->substrings_1toN),
			hitpair->hit5->refalt_nmatches_plus_spliced_trims,hitpair->hit3->refalt_nmatches_plus_spliced_trims,
			hitpair->hit5->refalt_nmatches_to_trims,hitpair->hit3->refalt_nmatches_to_trims,
			hitpair->hit5->ref_nmatches_plus_spliced_trims,hitpair->hit3->ref_nmatches_plus_spliced_trims,
			hitpair->hit5->ref_nmatches_to_trims,hitpair->hit3->ref_nmatches_to_trims));
	  /* result = Hitlist_push(result,hitlistpool,(void *) hitpair); -- wait for last filtering step */
	}
      }


      /* (2) Earlier methods */
      debug8(printf("(2) Earlier methods within loci\n"));
      best_method_5 = best_method_3 = SEGMENT2;
      for (r = p; r != q; r = List_next(r)) {
	hitpair = (Stage3pair_T) r->first;
	if ((hitpair = (Stage3pair_T) r->first) == NULL) {
	  /* Already eliminated */
	} else if (hitpair->hit5->method <= best_method_5 && hitpair->hit3->method <= best_method_3) {
	  best_method_5 = hitpair->hit5->method;
	  best_method_3 = hitpair->hit3->method;
	  /* bestpair = hitpair; */
	}
      }

      debug8(printf("Best method 5: %s\n",Method_string(best_method_5)));
      debug8(printf("Best method 3: %s\n",Method_string(best_method_3)));

      for (r = p; r != q; r = List_next(r)) {
	hitpair = (Stage3pair_T) r->first;

	if ((hitpair = (Stage3pair_T) r->first) == NULL) {
	  /* Already eliminated */

	} else if (hitpair->hit5->method > best_method_5 || hitpair->hit3->method > best_method_3) {
	  debug8(printf("Final (methods %s and %s): Eliminating hit pair %p at %d..%d|%d..%d, %u..%u|%u..%u with nmatches %d+%d (%d+%d to trims), ref %d+%d (%d+%d)\n",
			Method_string(hitpair->hit5->method),Method_string(hitpair->hit3->method),hitpair,
			hitpair->hit5->querystart_trimmed,hitpair->hit5->queryend_trimmed,
			hitpair->hit3->querystart_trimmed,hitpair->hit3->queryend_trimmed,
			hitpair->hit5->low_trimmed - hitpair->hit5->chroffset,hitpair->hit5->high_trimmed - hitpair->hit5->chroffset,
			hitpair->hit3->low_trimmed - hitpair->hit3->chroffset,hitpair->hit3->high_trimmed - hitpair->hit3->chroffset,
			hitpair->hit5->refalt_nmatches_plus_spliced_trims,hitpair->hit3->refalt_nmatches_plus_spliced_trims,
			hitpair->hit5->refalt_nmatches_to_trims,hitpair->hit3->refalt_nmatches_to_trims,
			hitpair->hit5->ref_nmatches_plus_spliced_trims,hitpair->hit3->ref_nmatches_plus_spliced_trims,
			hitpair->hit5->ref_nmatches_to_trims,hitpair->hit3->ref_nmatches_to_trims));
	  /* transfer_transcripts(bestpair->hit5,hitpair->hit5,listpool); */
	  /* transfer_transcripts(bestpair->hit3,hitpair->hit3,listpool); */
	  Stage3pair_free(&hitpair);
	  r->first = (Stage3pair_T) NULL;
	  *keep_p = false;

	} else {
	  debug8(printf("Final (methods %s and %s): Keeping hit pair %p at %d..%d|%d..%d, %u..%u|%u..%u (%d+%d substrings) with nmatches %d+%d (%d+%d to trims), ref %d+%d (%d+%d)\n",
			Method_string(hitpair->hit5->method),Method_string(hitpair->hit3->method),hitpair,
			hitpair->hit5->querystart_trimmed,hitpair->hit5->queryend_trimmed,
			hitpair->hit3->querystart_trimmed,hitpair->hit3->queryend_trimmed,
			hitpair->hit5->low_trimmed - hitpair->hit5->chroffset,hitpair->hit5->high_trimmed - hitpair->hit5->chroffset,
			hitpair->hit3->low_trimmed - hitpair->hit3->chroffset,hitpair->hit3->high_trimmed - hitpair->hit3->chroffset,
			List_length(hitpair->hit5->substrings_1toN),List_length(hitpair->hit3->substrings_1toN),
			hitpair->hit5->refalt_nmatches_plus_spliced_trims,hitpair->hit3->refalt_nmatches_plus_spliced_trims,
			hitpair->hit5->refalt_nmatches_to_trims,hitpair->hit3->refalt_nmatches_to_trims,
			hitpair->hit5->ref_nmatches_plus_spliced_trims,hitpair->hit3->ref_nmatches_plus_spliced_trims,
			hitpair->hit5->ref_nmatches_to_trims,hitpair->hit3->ref_nmatches_to_trims));
	  /* result = Hitlist_push(result,hitlistpool,(void *) hitpair); -- wait for last filtering step */
	}
      }


      /* (3) Find most matches to trims */
      debug8(printf("(3) Finding most matches to trims within loci\n"));
      best_nmatches_to_trims = 0;
      for (r = p; r != q; r = List_next(r)) {
	hitpair = (Stage3pair_T) r->first;
	if ((hitpair = (Stage3pair_T) r->first) == NULL) {
	  /* Already eliminated */
	} else if (hitpair->hit5->refalt_nmatches_to_trims + hitpair->hit3->refalt_nmatches_to_trims > best_nmatches_to_trims) {
	  best_nmatches_to_trims = hitpair->hit5->refalt_nmatches_to_trims + hitpair->hit3->refalt_nmatches_to_trims;
	  /* bestpair = hitpair; */
	}
      }

      for (r = p; r != q; r = List_next(r)) {
	hitpair = (Stage3pair_T) r->first;

	if ((hitpair = (Stage3pair_T) r->first) == NULL) {
	  /* Already eliminated */

	} else if (hitpair->hit5->refalt_nmatches_to_trims + hitpair->hit3->refalt_nmatches_to_trims < best_nmatches_to_trims) {
	  debug8(printf("Final (nmatches_to_trims %d < %d): Eliminating hit pair %p at %d..%d|%d..%d, %u..%u|%u..%u with nmatches %d+%d (%d+%d to trims), ref %d+%d (%d+%d)\n",
			hitpair->hit5->refalt_nmatches_to_trims + hitpair->hit3->refalt_nmatches_to_trims,best_nmatches_to_trims,hitpair,
			hitpair->hit5->querystart_trimmed,hitpair->hit5->queryend_trimmed,
			hitpair->hit3->querystart_trimmed,hitpair->hit3->queryend_trimmed,
			hitpair->hit5->low_trimmed - hitpair->hit5->chroffset,hitpair->hit5->high_trimmed - hitpair->hit5->chroffset,
			hitpair->hit3->low_trimmed - hitpair->hit3->chroffset,hitpair->hit3->high_trimmed - hitpair->hit3->chroffset,
			hitpair->hit5->refalt_nmatches_plus_spliced_trims,hitpair->hit3->refalt_nmatches_plus_spliced_trims,
			hitpair->hit5->refalt_nmatches_to_trims,hitpair->hit3->refalt_nmatches_to_trims,
			hitpair->hit5->ref_nmatches_plus_spliced_trims,hitpair->hit3->ref_nmatches_plus_spliced_trims,
			hitpair->hit5->ref_nmatches_to_trims,hitpair->hit3->ref_nmatches_to_trims));
	  /* transfer_transcripts(bestpair->hit5,hitpair->hit5,listpool); */
	  /* transfer_transcripts(bestpair->hit3,hitpair->hit3,listpool); */
	  Stage3pair_free(&hitpair);
	  r->first = (Stage3pair_T) NULL;
	  *keep_p = false;

	} else {
	  debug8(printf("Final (nmatches_to_trims %d == %d): Keeping hit pair %p at %d..%d|%d..%d, %u..%u|%u..%u (%d+%d substrings) with nmatches %d+%d (%d+%d to trims), ref %d+%d (%d+%d)\n",
			hitpair->hit5->refalt_nmatches_to_trims + hitpair->hit3->refalt_nmatches_to_trims,best_nmatches_to_trims,hitpair,
			hitpair->hit5->querystart_trimmed,hitpair->hit5->queryend_trimmed,
			hitpair->hit3->querystart_trimmed,hitpair->hit3->queryend_trimmed,
			hitpair->hit5->low_trimmed - hitpair->hit5->chroffset,hitpair->hit5->high_trimmed - hitpair->hit5->chroffset,
			hitpair->hit3->low_trimmed - hitpair->hit3->chroffset,hitpair->hit3->high_trimmed - hitpair->hit3->chroffset,
			List_length(hitpair->hit5->substrings_1toN),List_length(hitpair->hit3->substrings_1toN),
			hitpair->hit5->refalt_nmatches_plus_spliced_trims,hitpair->hit3->refalt_nmatches_plus_spliced_trims,
			hitpair->hit5->refalt_nmatches_to_trims,hitpair->hit3->refalt_nmatches_to_trims,
			hitpair->hit5->ref_nmatches_plus_spliced_trims,hitpair->hit3->ref_nmatches_plus_spliced_trims,
			hitpair->hit5->ref_nmatches_to_trims,hitpair->hit3->ref_nmatches_to_trims));
	  /* result = Hitlist_push(result,hitlistpool,(void *) hitpair); -- wait for last filtering step */
	}
      }


      /* (4) Find best nsegments and splice score */
      debug8(printf("(4) Finding best nsegments and splice score within loci\n"));
      best_nsegments = querylength5 + querylength3;
      max_splice_score = 0.0;
      for (r = p; r != q; r = List_next(r)) {
	if ((hitpair = (Stage3pair_T) r->first) == NULL) {
	  /* Already eliminated */
	} else if ((nsegments = hitpair->hit5->nsegments + hitpair->hit3->nsegments) < best_nsegments) {
	  best_nsegments = nsegments;
	  max_splice_score = hitpair->hit5->splice_score + hitpair->hit3->splice_score;
	  /* bestpair = hitpair; */
	  
	} else if (nsegments == best_nsegments) {
	  if ((splice_score = hitpair->hit5->splice_score + hitpair->hit3->splice_score) > max_splice_score) {
	    max_splice_score = splice_score;
	    /* bestpair = hitpair; */
	  }
	}
      }
      debug8(printf("best_nsegments %d, max_splice_score %f\n",best_nsegments,max_splice_score));
      
      for (r = p; r != q; r = List_next(r)) {
	if ((hitpair = (Stage3pair_T) r->first) == NULL) {
	  /* Already eliminated */

	} else if ((nsegments = hitpair->hit5->nsegments + hitpair->hit3->nsegments) > best_nsegments) {
	  debug8(printf("Within loci pair (nsegments %d > %d): Eliminating hit pair %p at %d..%d|%d..%d, %u..%u|%u..%u with nsegments %d+%d, pairlength %u, nmatches %d+%d (%d+%d to trims), sensedirs %d and %d, splice scores %f and %f\n",
			nsegments,best_nsegments,hitpair,
			hitpair->hit5->querystart_trimmed,hitpair->hit5->queryend_trimmed,
			hitpair->hit3->querystart_trimmed,hitpair->hit3->queryend_trimmed,
			hitpair->hit5->low_trimmed - hitpair->hit5->chroffset,hitpair->hit5->high_trimmed - hitpair->hit5->chroffset,
			hitpair->hit3->low_trimmed - hitpair->hit3->chroffset,hitpair->hit3->high_trimmed - hitpair->hit3->chroffset,
			hitpair->hit5->nsegments,hitpair->hit3->nsegments,hitpair->insertlength,
			hitpair->hit5->refalt_nmatches_plus_spliced_trims,hitpair->hit3->refalt_nmatches_plus_spliced_trims,
			hitpair->hit5->refalt_nmatches_to_trims,hitpair->hit3->refalt_nmatches_to_trims,
			hitpair->hit5->sensedir,hitpair->hit3->sensedir,hitpair->hit5->splice_score,hitpair->hit3->splice_score));
	  /* transfer_transcripts(bestpair->hit5,hitpair->hit5,listpool); */
	  /* transfer_transcripts(bestpair->hit3,hitpair->hit3,listpool); */
	  Stage3pair_free(&hitpair);
	  r->first = (Stage3pair_T) NULL;
	  *keep_p = false;

	} else if (hitpair->hit5->splice_score + hitpair->hit3->splice_score < max_splice_score - SPLICE_SCORE_SLOP) {
	  debug8(printf("Within loci pair (splice_score w/slop %f < %f): Eliminating hit pair %p at %d..%d|%d..%d, %u..%u|%u..%u with nsegments %d+%d, pairlength %u, nmatches %d+%d (%d+%d to trims), sensedirs %d and %d, splice scores %f and %f\n",
			hitpair->hit5->splice_score + hitpair->hit3->splice_score,max_splice_score,hitpair,
			hitpair->hit5->querystart_trimmed,hitpair->hit5->queryend_trimmed,
			hitpair->hit3->querystart_trimmed,hitpair->hit3->queryend_trimmed,
			hitpair->hit5->low_trimmed - hitpair->hit5->chroffset,hitpair->hit5->high_trimmed - hitpair->hit5->chroffset,
			hitpair->hit3->low_trimmed - hitpair->hit3->chroffset,hitpair->hit3->high_trimmed - hitpair->hit3->chroffset,
			hitpair->hit5->nsegments,hitpair->hit3->nsegments,hitpair->insertlength,
			hitpair->hit5->refalt_nmatches_plus_spliced_trims,hitpair->hit3->refalt_nmatches_plus_spliced_trims,hitpair->hit5->refalt_nmatches_to_trims,hitpair->hit3->refalt_nmatches_to_trims,
			hitpair->hit5->sensedir,hitpair->hit3->sensedir,hitpair->hit5->splice_score,hitpair->hit3->splice_score));
	  /* transfer_transcripts(bestpair->hit5,hitpair->hit5,listpool); */
	  /* transfer_transcripts(bestpair->hit3,hitpair->hit3,listpool); */
	  Stage3pair_free(&hitpair);
	  r->first = (Stage3pair_T) NULL;
	  *keep_p = false;
	  
	} else {
	  debug8(printf("Keeping hit pair %p at %d..%d|%d..%d, %u..%u|%u..%u with nsegments %d+%d, pairlength %u, nmatches %d+%d (%d+%d to_trims), sensedirs %d and %d, splice scores %f and %f\n",
			hitpair,hitpair->hit5->querystart_trimmed,hitpair->hit5->queryend_trimmed,
			hitpair->hit3->querystart_trimmed,hitpair->hit3->queryend_trimmed,
			hitpair->hit5->low_trimmed - hitpair->hit5->chroffset,hitpair->hit5->high_trimmed - hitpair->hit5->chroffset,
			hitpair->hit3->low_trimmed - hitpair->hit3->chroffset,hitpair->hit3->high_trimmed - hitpair->hit3->chroffset,
			hitpair->hit5->nsegments,hitpair->hit3->nsegments,hitpair->insertlength,
			hitpair->hit5->refalt_nmatches_plus_spliced_trims,hitpair->hit3->refalt_nmatches_plus_spliced_trims,hitpair->hit5->refalt_nmatches_to_trims,hitpair->hit3->refalt_nmatches_to_trims,
			hitpair->hit5->sensedir,hitpair->hit3->sensedir,hitpair->hit5->splice_score,hitpair->hit3->splice_score));
	  /* result = Hitlist_push(result,hitlistpool,(void *) hitpair);  -- wait until last filtering step */
	}
      }


      /* (5) Find smallest outerlength within loci */
      debug8(printf("(5) Finding smallest outerlength within loci"));
      best_outerlength = (Chrpos_T) -1;
      for (r = p; r != q; r = List_next(r)) {
	if ((hitpair = (Stage3pair_T) r->first) == NULL) {
	  /* Already eliminated */
	} else if (hitpair->outerlength < best_outerlength) {
	  best_outerlength = hitpair->outerlength;
	  /* bestpair = hitpair; */
	}
      }
      debug8(printf(" => %u\n",best_outerlength));

      for (r = p; r != q; r = List_next(r)) {
	if ((hitpair = (Stage3pair_T) r->first) == NULL) {
	  /* Already eliminated */

	} else if (hitpair->outerlength > best_outerlength /*+ OUTERLENGTH_SLOP*/) {  /* No slop for final */
	  debug8(printf("Final (outerlength %u > %u): Eliminating hit pair %p at %d..%d|%d..%d, %u..%u|%u..%u with nmatches %d+%d (%d+%d to trims)\n",
			hitpair->outerlength,best_outerlength /*+ OUTERLENGTH_SLOP*/,hitpair,
			hitpair->hit5->querystart_trimmed,hitpair->hit5->queryend_trimmed,
			hitpair->hit3->querystart_trimmed,hitpair->hit3->queryend_trimmed,
			hitpair->hit5->low_trimmed - hitpair->hit5->chroffset,hitpair->hit5->high_trimmed - hitpair->hit5->chroffset,
			hitpair->hit3->low_trimmed - hitpair->hit3->chroffset,hitpair->hit3->high_trimmed - hitpair->hit3->chroffset,
			hitpair->hit5->refalt_nmatches_plus_spliced_trims,hitpair->hit3->refalt_nmatches_plus_spliced_trims,
			hitpair->hit5->refalt_nmatches_to_trims,hitpair->hit3->refalt_nmatches_to_trims));
	  /* transfer_transcripts(bestpair->hit5,hitpair->hit5,listpool); */
	  /* transfer_transcripts(bestpair->hit3,hitpair->hit3,listpool); */
	  Stage3pair_free(&hitpair);
	  r->first = (Stage3pair_T) NULL;
	  *keep_p = false;

	} else {
	  debug8(printf("Final (outerlength %u): Keeping hit pair %p at %d..%d|%d..%d, %u..%u|%u..%u (%d+%d substrings) with nmatches %d+%d (%d+%d to trims)\n",
			hitpair->outerlength,hitpair,
			hitpair->hit5->querystart_trimmed,hitpair->hit5->queryend_trimmed,
			hitpair->hit3->querystart_trimmed,hitpair->hit3->queryend_trimmed,
			hitpair->hit5->low_trimmed - hitpair->hit5->chroffset,hitpair->hit5->high_trimmed - hitpair->hit5->chroffset,
			hitpair->hit3->low_trimmed - hitpair->hit3->chroffset,hitpair->hit3->high_trimmed - hitpair->hit3->chroffset,
			List_length(hitpair->hit5->substrings_1toN),List_length(hitpair->hit3->substrings_1toN),
			hitpair->hit5->refalt_nmatches_plus_spliced_trims,hitpair->hit3->refalt_nmatches_plus_spliced_trims,
			hitpair->hit5->refalt_nmatches_to_trims,hitpair->hit3->refalt_nmatches_to_trims));
	  /* result = Hitlist_push(result,hitlistpool,(void *) hitpair); -- wait for last filtering step */
	}
      }


      /* (6) Find smallest insert length without slop within loci */
      debug8(printf("(6) Finding smallest insertlength without slop within loci on %d hitpairs\n",List_length(p)));
      best_insertlength = (Chrpos_T) -1;
      for (r = p; r != q; r = List_next(r)) {
	if ((hitpair = (Stage3pair_T) r->first) == NULL) {
	  /* Already eliminated */
	} else if (hitpair->insertlength < best_insertlength) {
	  best_insertlength = hitpair->insertlength;
	  /* bestpair = hitpair; */
	}
      }
      debug8(printf(" => %u\n",best_insertlength));

      for (r = p; r != q; r = List_next(r)) {
	if ((hitpair = (Stage3pair_T) r->first) == NULL) {
	  /* Already eliminated */
	  debug8(printf("Already eliminated\n"));

	} else if (hitpair->insertlength > best_insertlength /*+ INSERTLENGTH_SLOP*/) {  /* No slop for final */
	  debug8(printf("Final (insertlength %u > %u): Eliminating hit pair %p at %d..%d|%d..%d, %u..%u|%u..%u with nmatches %d+%d (%d+%d to trims), ref %d+%d (%d+%d)\n",
			hitpair->insertlength,best_insertlength,hitpair,
			hitpair->hit5->querystart_trimmed,hitpair->hit5->queryend_trimmed,
			hitpair->hit3->querystart_trimmed,hitpair->hit3->queryend_trimmed,
			hitpair->hit5->low_trimmed - hitpair->hit5->chroffset,hitpair->hit5->high_trimmed - hitpair->hit5->chroffset,
			hitpair->hit3->low_trimmed - hitpair->hit3->chroffset,hitpair->hit3->high_trimmed - hitpair->hit3->chroffset,
			hitpair->hit5->refalt_nmatches_plus_spliced_trims,hitpair->hit3->refalt_nmatches_plus_spliced_trims,
			hitpair->hit5->refalt_nmatches_to_trims,hitpair->hit3->refalt_nmatches_to_trims,
			hitpair->hit5->ref_nmatches_plus_spliced_trims,hitpair->hit3->ref_nmatches_plus_spliced_trims,
			hitpair->hit5->ref_nmatches_to_trims,hitpair->hit3->ref_nmatches_to_trims));
	  /* transfer_transcripts(bestpair->hit5,hitpair->hit5,listpool); */
	  /* transfer_transcripts(bestpair->hit3,hitpair->hit3,listpool); */
	  Stage3pair_free(&hitpair);
	  r->first = (Stage3pair_T) NULL;
	  *keep_p = false;

	} else {
	  debug8(printf("Final (insertlength %u, outerlength %u): Keeping hit pair %p at %d..%d|%d..%d, %u..%u|%u..%u (%d+%d substrings) with nmatches %d+%d (%d+%d to trims), ref %d+%d (%d+%d)\n",
			hitpair->insertlength,hitpair->outerlength,hitpair,
			hitpair->hit5->querystart_trimmed,hitpair->hit5->queryend_trimmed,
			hitpair->hit3->querystart_trimmed,hitpair->hit3->queryend_trimmed,
			hitpair->hit5->low_trimmed - hitpair->hit5->chroffset,hitpair->hit5->high_trimmed - hitpair->hit5->chroffset,
			hitpair->hit3->low_trimmed - hitpair->hit3->chroffset,hitpair->hit3->high_trimmed - hitpair->hit3->chroffset,
			List_length(hitpair->hit5->substrings_1toN),List_length(hitpair->hit3->substrings_1toN),
			hitpair->hit5->refalt_nmatches_plus_spliced_trims,hitpair->hit3->refalt_nmatches_plus_spliced_trims,
			hitpair->hit5->refalt_nmatches_to_trims,hitpair->hit3->refalt_nmatches_to_trims,
			hitpair->hit5->ref_nmatches_plus_spliced_trims,hitpair->hit3->ref_nmatches_plus_spliced_trims,
			hitpair->hit5->ref_nmatches_to_trims,hitpair->hit3->ref_nmatches_to_trims));
	  result = Hitlist_push(result,hitlistpool,(void *) hitpair); /* Push because this is the last filtering step */
	  debug8(printf("  result now has length %d\n",List_length(result)));
	}
      }

#if 0
      /* (7) Find best concordant velocity */
      if (transcriptome != NULL) {
	debug8(printf("(7) Finding best velocity\n"));
	best_velocity = V_INVALID;
	/* bestpair = (Stage3pair_T) NULL; */
	for (r = p; r != q; r = List_next(r)) {
	  if ((hitpair = (Stage3pair_T) r->first) == NULL) {
	    /* Already eliminated */

	  } else {
	    remap_transcriptome(hitpair->hit5,listpool);
	    remap_transcriptome(hitpair->hit3,listpool);
	    
	    if (Transcript_concordant_p(/*transcripts5*/hitpair->hit5->transcripts_consistent,
					/*transcripts3*/hitpair->hit3->transcripts_consistent) == true &&
		accept_velocity > best_velocity) {
	      best_velocity = accept_velocity;
	      /* bestpair = hitpair; */
	    }
	  }
	}
	debug8(printf(" => %d\n",best_velocity));

	for (r = p; r != q; r = List_next(r)) {
	  if ((hitpair = (Stage3pair_T) r->first) == NULL) {
	    /* Already eliminated */

	  } else if (bestpair != NULL &&
		     (Transcript_concordant_p(/*transcripts5*/hitpair->hit5->transcripts_consistent,
					      /*transcripts3*/hitpair->hit3->transcripts_consistent) == false ||
		      accept_velocity < best_velocity)) {
	    
	    debug8(printf("Final (insertlength %u > %u): Eliminating hit pair %p at %d..%d|%d..%d, %u..%u|%u..%u with nmatches %d+%d (%d+%d to trims), ref %d+%d (%d+%d)\n",
			  hitpair->insertlength,best_insertlength,hitpair,
			  hitpair->hit5->querystart_trimmed,hitpair->hit5->queryend_trimmed,
			  hitpair->hit3->querystart_trimmed,hitpair->hit3->queryend_trimmed,
			  hitpair->hit5->low_trimmed - hitpair->hit5->chroffset,hitpair->hit5->high_trimmed - hitpair->hit5->chroffset,
			  hitpair->hit3->low_trimmed - hitpair->hit3->chroffset,hitpair->hit3->high_trimmed - hitpair->hit3->chroffset,
			  hitpair->hit5->refalt_nmatches_plus_spliced_trims,hitpair->hit3->refalt_nmatches_plus_spliced_trims,
			  hitpair->hit5->refalt_nmatches_to_trims,hitpair->hit3->refalt_nmatches_to_trims,
			  hitpair->hit5->ref_nmatches_plus_spliced_trims,hitpair->hit3->ref_nmatches_plus_spliced_trims,
			  hitpair->hit5->ref_nmatches_to_trims,hitpair->hit3->ref_nmatches_to_trims));
	    /* transfer_transcripts(bestpair->hit5,hitpair->hit5,listpool); */
	    /* transfer_transcripts(bestpair->hit3,hitpair->hit3,listpool); */
	    Stage3pair_free(&hitpair);
	    r->first = (Stage3pair_T) NULL;
	    *keep_p = false;
	    
	  } else {
	    debug8(printf("Final (insertlength %u, outerlength %u): Keeping hit pair %p at %d..%d|%d..%d, %u..%u|%u..%u (%d+%d substrings) with nmatches %d+%d (%d+%d to trims), ref %d+%d (%d+%d)\n",
			  hitpair->insertlength,hitpair->outerlength,hitpair,
			  hitpair->hit5->querystart_trimmed,hitpair->hit5->queryend_trimmed,
			  hitpair->hit3->querystart_trimmed,hitpair->hit3->queryend_trimmed,
			  hitpair->hit5->low_trimmed - hitpair->hit5->chroffset,hitpair->hit5->high_trimmed - hitpair->hit5->chroffset,
			  hitpair->hit3->low_trimmed - hitpair->hit3->chroffset,hitpair->hit3->high_trimmed - hitpair->hit3->chroffset,
			  List_length(hitpair->hit5->substrings_1toN),List_length(hitpair->hit3->substrings_1toN),
			  hitpair->hit5->refalt_nmatches_plus_spliced_trims,hitpair->hit3->refalt_nmatches_plus_spliced_trims,
			  hitpair->hit5->refalt_nmatches_to_trims,hitpair->hit3->refalt_nmatches_to_trims,
			  hitpair->hit5->ref_nmatches_plus_spliced_trims,hitpair->hit3->ref_nmatches_plus_spliced_trims,
			  hitpair->hit5->ref_nmatches_to_trims,hitpair->hit3->ref_nmatches_to_trims));
	    result = Hitlist_push(result,hitlistpool,(void *) hitpair);
	    debug8(printf("  result now has length %d\n",List_length(result)));
	  }
	}
      }
#endif

      p = q;
    }
  }

  Hitlist_free(&list);

  debug8(printf("pair_remove_bad_superstretches returning result of length %d\n",List_length(result)));
  return List_reverse(result);
}


static List_T
pair_remove_overlaps (List_T hitpairlist, Hitlistpool_T hitlistpool,
		      int querylength5, int querylength3, bool translocp, bool finalp) {
  List_T unique = NULL;
  /* Stage3pair_T parent; -- Needed when we transferred transcripts */
  Stage3pair_T hitpair, *hitpairs;
  int nkept, n, i, j;
  bool *eliminate;
  int *parenti;
  bool keep_p;

  n = List_length(hitpairlist);
  debug8(printf("  Entering pair_remove_overlaps with %d pairs: %s\n",
		n,finalp == true ? "FINAL" : "not final"));

  if (n <= 1) {
    debug8(printf("  Exiting pair_remove_overlaps with %d < 2 pairs\n",n));
    return hitpairlist;
  } else {
#ifdef USE_ALLOCA_FOR_HITS
    eliminate = (bool *) CALLOCA(n,sizeof(bool));
    parenti = (int *) CALLOCA(n,sizeof(int));
    hitpairs = (Stage3pair_T *) MALLOCA(n * sizeof(Stage3pair_T));
    List_fill_array((void **) hitpairs,hitpairlist);
    Hitlist_free(&hitpairlist);
#else
    eliminate = (bool *) CALLOC(n,sizeof(bool));
    parenti = (int *) CALLOC(n,sizeof(int));
    hitpairs = (Stage3pair_T *) List_to_array(hitpairlist,NULL);
    Hitlist_free(&hitpairlist);
#endif
  }

  /* Step 1.  Check for exact duplicates */
  debug8(printf("  Step 1.  Checking for exact duplicates\n"));
  qsort(hitpairs,n,sizeof(Stage3pair_T),hitpair_sort_cmp);

  debug8(
	 for (i = 0; i < n; i++) {
	   hitpair = hitpairs[i];
	   printf("  Initial %d (%s-%s): %p, %d..%d|%d..%d, %u..%u|%u..%u (dir = %d), circularalias %d|%d, nmatches: %d+%d (%d+%d to trims), amb_lengths %d and %d, sensedirs %d and %d.",
		  i,Method_string(hitpair->hit5->method),Method_string(hitpair->hit3->method),hitpair,
		  hitpair->hit5->querystart_trimmed,hitpair->hit5->queryend_trimmed,
		  hitpair->hit3->querystart_trimmed,hitpair->hit3->queryend_trimmed,
		  hitpair->hit5->low_trimmed - hitpair->hit5->chroffset,hitpair->hit5->high_trimmed - hitpair->hit5->chroffset,
		  hitpair->hit3->low_trimmed - hitpair->hit3->chroffset,hitpair->hit3->high_trimmed - hitpair->hit3->chroffset,
		  hitpair->dir,hitpair->hit5->circularalias,hitpair->hit3->circularalias,
		  hitpair->hit5->refalt_nmatches_plus_spliced_trims,hitpair->hit3->refalt_nmatches_plus_spliced_trims,
		  hitpair->hit5->refalt_nmatches_to_trims,hitpair->hit3->refalt_nmatches_to_trims,
		  amb_length(hitpair->hit5),amb_length(hitpair->hit3),hitpair->hit5->sensedir,hitpair->hit3->sensedir);
	   if (hitpair->hit5->hittype == TRANSLOC_SPLICE) {
	     printf("  5' TRANSLOC splice probs %f",hitpair->hit5->splice_score);
	   }
	   if (hitpair->hit3->hittype == TRANSLOC_SPLICE) {
	     printf("  3' TRANSLOC splice probs %f",hitpair->hit3->splice_score);
	   }
	   printf("\n");
	 }
	 );

  i = 0;
  while (i < n) {
    j = i+1;
    debug8(printf(" %d,%d",i,j));
    while (j < n && hitpair_equal(hitpairs[j],hitpairs[i]) == true) {
      debug8(printf("  %d is identical to %d => eliminating\n",j,i));
      eliminate[j] = true;
      parenti[j] = i;
      j++;
    }
    i = j;
  }
  debug8(printf("\n"));

  nkept = 0;
  for (i = 0; i < n; i++) {
    if (eliminate[i] == false) {
      nkept++;
    }
  }
  debug8(printf("nkept = %d\n",nkept));

  if (nkept == 0) {
    /* All entries eliminated one another, so keep the first one */
    debug8(printf("All entries eliminate one another, so keep the first one\n"));
    eliminate[0] = false;
    nkept = 1;
  }

  for (i = n - 1; i >= 0; --i) {
    hitpair = hitpairs[i];
    if (eliminate[i] == false) {
      debug8(printf("  Keeping %s|%s %d..%d|%d..%d, %u..%u|%u..%u, nmatches (trimmed) %d+%d, score %d+%d, (dir = %d)\n",
		    Method_string(hitpair->hit5->method),Method_string(hitpair->hit3->method),
		    hitpair->hit5->querystart_trimmed,hitpair->hit5->queryend_trimmed,
		    hitpair->hit3->querystart_trimmed,hitpair->hit3->queryend_trimmed,
		    hitpair->hit5->low_trimmed - hitpair->hit5->chroffset,hitpair->hit5->high_trimmed - hitpair->hit5->chroffset,
		    hitpair->hit3->low_trimmed - hitpair->hit3->chroffset,hitpair->hit3->high_trimmed - hitpair->hit3->chroffset,
		    hitpair->hit5->refalt_nmatches_plus_spliced_trims,hitpair->hit3->refalt_nmatches_plus_spliced_trims,
		    hitpair->hit5->refalt_score_overall,hitpair->hit3->refalt_score_overall,hitpair->dir));
      unique = Hitlist_push(unique,hitlistpool,(void *) hitpair);

    } else {
      debug8(printf("  Eliminating hit pair %p %s|%s %d..%d|%d..%d, %u..%u|%u..%u, nmatches (trimmed) %d+%d, score %d+%d, (dir = %d)\n",
		    hitpair,Method_string(hitpair->hit5->method),Method_string(hitpair->hit3->method),
		    hitpair->hit5->querystart_trimmed,hitpair->hit5->queryend_trimmed,
		    hitpair->hit3->querystart_trimmed,hitpair->hit3->queryend_trimmed,
		    hitpair->hit5->low_trimmed - hitpair->hit5->chroffset,hitpair->hit5->high_trimmed - hitpair->hit5->chroffset,
		    hitpair->hit3->low_trimmed - hitpair->hit3->chroffset,hitpair->hit3->high_trimmed - hitpair->hit3->chroffset,
		    hitpair->hit5->refalt_nmatches_plus_spliced_trims,hitpair->hit3->refalt_nmatches_plus_spliced_trims,
		    hitpair->hit5->refalt_score_overall,hitpair->hit3->refalt_score_overall,hitpair->dir));

      /* parent = hitpairs[parenti[i]]; */
      /* transfer_transcripts(parent->hit5,hitpair->hit5,listpool); */
      /* transfer_transcripts(parent->hit3,hitpair->hit3,listpool); */
      Stage3pair_free(&hitpair);
    }
  }

#ifdef USE_ALLOCA_FOR_HITS
  FREEA(hitpairs);
  FREEA(eliminate);
  FREEA(parenti);
#else
  FREE(hitpairs);
  FREE(eliminate);
  FREE(parenti);
#endif


  debug8(printf("  Step 2.  Checking for bad superstretches\n"));
  if (0 && translocp == true) {
    return unique;
  } else {
    return pair_remove_bad_superstretches(&keep_p,/*superstretch*/NULL,unique,
					  hitlistpool,querylength5,querylength3,finalp);
  }
}


static int
calc_insertlength_score (Chrpos_T insertlength) {
  if (insertlength > 80000) {
    return 2;
  } else if (insertlength > 1000) {
    return 1;
  } else {
    return 0;
  }
}


List_T
Stage3pair_remove_overlaps (List_T hitpairlist, Hitlistpool_T hitlistpool,
			    int querylength5, int querylength3, bool translocp, bool finalp) {
  List_T optimal, unique_separate, unique_overlapping,
    separate = NULL, overlapping = NULL, p;
  /* Stage3pair_T bestpair; -- Needed when we transferred transcripts */
  Stage3pair_T hitpair_separate, hitpair_overlapping, *hitpairs, hitpair;

  Stage3pair_T *array_separate, *array_overlapping;
  Univcoord_T low, high;

  int best_querylength5, best_querylength3,
    trimmed_querylength_5, trimmed_querylength_3,
    best_nmatches_to_trims, score;
  int best_nsegments, nsegments;
  int best_insertlength_score, insertlength_score;
  double max_splice_score, splice_score;
  Chrpos_T best_outerlength;

  bool subsumedp, equalp, *eliminate, keptp;
  int n_separate, n_overlapping, n, i, j, k;


  debug8(printf("Entered Stage3pair_remove_overlaps with %d hitpairs\n",List_length(hitpairlist)));
  for (p = hitpairlist; p != NULL; p = List_next(p)) {
    hitpair = (Stage3pair_T) List_head(p);
    if (hitpair->insertlength <= (Chrpos_T) (hitpair->hit5->querylength + hitpair->hit3->querylength)) {
      overlapping = Hitlist_push(overlapping,hitlistpool,(void *) hitpair);
    } else {
      separate = Hitlist_push(separate,hitlistpool,(void *) hitpair);
    }
  }
  Hitlist_free(&hitpairlist);

  debug8(printf("Calling Stage3pair_remove_overlaps for separate pair ends\n"));
  unique_separate = pair_remove_overlaps(separate,hitlistpool,
					 querylength5,querylength3,translocp,finalp);

  debug8(printf("Calling Stage3pair_remove_overlaps for overlapping pair ends\n"));
  unique_overlapping = pair_remove_overlaps(overlapping,hitlistpool,
					    querylength5,querylength3,translocp,finalp);
  
  if (unique_overlapping == NULL) {
    debug8(printf("Unique overlapping is NULL\n"));
    hitpairlist = unique_separate;
  } else if (unique_separate == NULL) {
    debug8(printf("Unique separate is NULL\n"));
    hitpairlist = unique_overlapping;
  } else {
    debug8(printf("Have both overlapping and separate\n"));
    n_overlapping = List_length(unique_overlapping);
#ifdef USE_ALLOCA_FOR_HITS
    array_overlapping = (Stage3pair_T *) MALLOCA(n_overlapping * sizeof(Stage3pair_T));
    List_fill_array((void **) array_overlapping,unique_overlapping);
#else
    array_overlapping = (Stage3pair_T *) List_to_array(unique_overlapping,NULL);
#endif

    n_separate = List_length(unique_separate);
#ifdef USE_ALLOCA_FOR_HITS
    array_separate = (Stage3pair_T *) MALLOCA(n_separate * sizeof(Stage3pair_T));
    List_fill_array((void **) array_separate,unique_separate);
#else
    array_separate = (Stage3pair_T *) List_to_array(unique_separate,NULL);
#endif

    qsort(array_overlapping,n_overlapping,sizeof(Stage3pair_T),hitpair_position_cmp);
    qsort(array_separate,n_separate,sizeof(Stage3pair_T),hitpair_position_cmp);

    /* 1.  First, favor overlapping (with smaller insertlengths) */
    /* Keep unique_overlapping and filter unique_separate into indep_separate */
    Hitlist_free(&unique_separate);
    unique_separate = (List_T) NULL;

    i = j = 0;
    for (i = 0; i < n_separate; i++) {
      hitpair_separate = array_separate[i];
      low = hitpair_separate->low_chrbound;
      high = hitpair_separate->high_chrbound;
      while (j >= 0 && array_overlapping[j]->high_chrbound >= low) {
	j--;
      }
      j += 1;

      subsumedp = false;
      while (j < n_overlapping && subsumedp == false && array_overlapping[j]->low_chrbound <= high) {
	if (hitpair_goodness_cmp(&equalp,array_overlapping[j],
				 hitpair_separate,finalp) > 0) {
	  debug8(printf("overlapping pair %d better than separate pair %d\n",j,i));
	  subsumedp = hitpair_subsumption(hitpair_separate,array_overlapping[j]);
	  debug8(printf("  checking if separate pair %d subsumes overlapping pair %d => %d\n",
			i,j,subsumedp));
	}
	j++;
      }
      j -= 1;

      if (subsumedp == true) {
	Stage3pair_free(&hitpair_separate);
      } else {
        unique_separate = Hitlist_push(unique_separate,hitlistpool,(void *) hitpair_separate);
      }
    }

#ifdef USE_ALLOCA_FOR_HITS
    FREEA(array_separate);
#else
    FREE(array_separate);
#endif

    if ((n_separate = List_length(unique_separate)) == 0) {
#ifdef USE_ALLOCA_FOR_HITS
      FREEA(array_overlapping);
#else
      FREE(array_overlapping);
#endif
      hitpairlist = unique_overlapping;

    } else {
#ifdef USE_ALLOCA_FOR_HITS
      array_separate = (Stage3pair_T *) MALLOCA(n_separate * sizeof(Stage3pair_T));
      List_fill_array((void **) array_separate,unique_separate);
#else
      array_separate = (Stage3pair_T *) List_to_array(unique_separate,NULL);
#endif

      /* 2.  Second, favor separate (with larger insertlengths) */
      /* Keep indep_separate and filter unique_overlapping into indep_overlapping */
      Hitlist_free(&unique_overlapping);
      unique_overlapping = (List_T) NULL;

      i = j = 0;
      for (i = 0; i < n_overlapping; i++) {
	hitpair_overlapping = array_overlapping[i];
	low = hitpair_overlapping->low_chrbound;
	high = hitpair_overlapping->high_chrbound;
	while (j >= 0 && array_separate[j]->high_chrbound >= low) {
	  j--;
	}
	j += 1;

	subsumedp = false;
	while (j < n_separate && subsumedp == false && array_separate[j]->low_chrbound <= high) {
	  if (hitpair_goodness_cmp(&equalp,array_separate[j],
				   hitpair_overlapping,finalp) > 0) {
	    debug8(printf("separate pair %d better than overlapping pair %d\n",j,i));
	    subsumedp = hitpair_subsumption(array_separate[j],hitpair_overlapping);
	    debug8(printf("  checking if separate pair %d subsumes overlapping pair %d => %d\n",
			  j,i,subsumedp));
	  }
	  j++;
	}
	j -= 1;
	
	if (subsumedp == true) {
	  Stage3pair_free(&hitpair_overlapping);
	} else {
	  unique_overlapping = Hitlist_push(unique_overlapping,hitlistpool,(void *) hitpair_overlapping);
	}
      }
    }

#ifdef USE_ALLOCA_FOR_HITS
    FREEA(array_separate);
    FREEA(array_overlapping);
#else
    FREE(array_separate);
    FREE(array_overlapping);
#endif

    hitpairlist = List_append(unique_overlapping,unique_separate);
  }


  /* Prune based on nmatches adjusted by score to get a tradeoff between matches and parsimony */
  /* Same as step 1 of Stage3pair_optimal_score_final */
  if (hitpairlist == NULL) {
    return (List_T) NULL;
  } else {
    optimal = (List_T) NULL;
  }
  

  debug8(printf("  Step 3.  Maximize querylengths\n"));
  keptp = false;
  hitpairs = (Stage3pair_T *) List_to_array_n(&n,hitpairlist);
  eliminate = (bool *) CALLOC(n,sizeof(bool));
  qsort(hitpairs,n,sizeof(Stage3pair_T),hitpair_position_cmp);
  i = 0;
  while (i < n) {
    j = i+1;
    while (j < n && hitpair_overlap_p(hitpairs[j],hitpairs[i]) == true) {
      j++;
    }
    if (j - i > 1) {
      debug8(printf("Found a group from %d to %d\n",i,j));
      best_querylength5 = 0;
      best_querylength3 = 0;

      for (k = i; k < j; k++) {
	hitpair = hitpairs[k];
	if ((trimmed_querylength_5 = hitpair->hit5->queryend_trimmed - hitpair->hit5->querystart_trimmed) > best_querylength5) {
	  best_querylength5 = trimmed_querylength_5;
	}
	if ((trimmed_querylength_3 = hitpair->hit3->queryend_trimmed - hitpair->hit3->querystart_trimmed) > best_querylength3) {
	  best_querylength3 = trimmed_querylength_3;
	}
      }
      debug8(printf("best_querylength5 = %d, best_querylength3 = %d\n",best_querylength5,best_querylength3));
      
      for (k = i; k < j; k++) {
	hitpair = hitpairs[k];
	if (hitpair->hit5->queryend_trimmed - hitpair->hit5->querystart_trimmed < best_querylength5 &&
	    hitpair->hit3->queryend_trimmed - hitpair->hit3->querystart_trimmed < best_querylength3) {
	    debug8(printf("Within loci pair: Eliminating hit pair %p at %d..%d|%d..%d, %u..%u|%u..%u with nmatches %d+%d (%d+%d to trims) and querylengths %d and %d\n",
			  hitpair,hitpair->hit5->querystart_trimmed,hitpair->hit5->queryend_trimmed,
			  hitpair->hit3->querystart_trimmed,hitpair->hit3->queryend_trimmed,
			  hitpair->hit5->low_trimmed - hitpair->hit5->chroffset,hitpair->hit5->high_trimmed - hitpair->hit5->chroffset,
			  hitpair->hit3->low_trimmed - hitpair->hit3->chroffset,hitpair->hit3->high_trimmed - hitpair->hit3->chroffset,
			  hitpair->hit5->refalt_nmatches_plus_spliced_trims,hitpair->hit3->refalt_nmatches_plus_spliced_trims,
			  hitpair->hit5->refalt_nmatches_to_trims,hitpair->hit3->refalt_nmatches_to_trims,
			  hitpair->hit5->queryend_trimmed - hitpair->hit5->querystart_trimmed,
			  hitpair->hit3->queryend_trimmed - hitpair->hit3->querystart_trimmed));
	    eliminate[k] = true;
	} else {
	  debug8(printf("Within loci pair: Keeping hit pair %p, %d..%d|%d..%d at %u..%u|%u..%u with nmatches %d+%d (%d+%d to trims) and querylengths %d and %d\n",
			hitpair,hitpair->hit5->querystart_trimmed,hitpair->hit5->queryend_trimmed,
			hitpair->hit3->querystart_trimmed,hitpair->hit3->queryend_trimmed,
			hitpair->hit5->low_trimmed - hitpair->hit5->chroffset,hitpair->hit5->high_trimmed - hitpair->hit5->chroffset,
			hitpair->hit3->low_trimmed - hitpair->hit3->chroffset,hitpair->hit3->high_trimmed - hitpair->hit3->chroffset,
			hitpair->hit5->refalt_nmatches_plus_spliced_trims,hitpair->hit3->refalt_nmatches_plus_spliced_trims,
			hitpair->hit5->refalt_nmatches_to_trims,hitpair->hit3->refalt_nmatches_to_trims,
			hitpair->hit5->queryend_trimmed - hitpair->hit5->querystart_trimmed,
			hitpair->hit3->queryend_trimmed - hitpair->hit3->querystart_trimmed));
	  keptp = true;
	  /* bestpair = hitpair; */
	}
      }
    }

    i = j;
  }
  

  if (keptp == false) {
    optimal = hitpairlist;
  } else {
    for (k = 0; k < n; k++) {
      hitpair = hitpairs[k];
      if (eliminate[k] == true) {
	debug8(printf("Within loci pair: Eliminating hit pair %p at %d..%d|%d..%d, %u..%u|%u..%u with nsegments %d+%d, pairlength %u, nmatches %d+%d (%d+%d to_trims), sensedirs %d and %d, splice scores %f and %f\n",
		      hitpair,
		      hitpair->hit5->querystart_trimmed,hitpair->hit5->queryend_trimmed,
		      hitpair->hit3->querystart_trimmed,hitpair->hit3->queryend_trimmed,
		      hitpair->hit5->low_trimmed - hitpair->hit5->chroffset,hitpair->hit5->high_trimmed - hitpair->hit5->chroffset,
		      hitpair->hit3->low_trimmed - hitpair->hit3->chroffset,hitpair->hit3->high_trimmed - hitpair->hit3->chroffset,
		      hitpair->hit5->nsegments,hitpair->hit3->nsegments,hitpair->insertlength,
		      hitpair->hit5->refalt_nmatches_plus_spliced_trims,hitpair->hit3->refalt_nmatches_plus_spliced_trims,hitpair->hit5->refalt_nmatches_to_trims,hitpair->hit3->refalt_nmatches_to_trims,
		      hitpair->hit5->sensedir,hitpair->hit3->sensedir,hitpair->hit5->splice_score,hitpair->hit3->splice_score));
	/* transfer_transcripts(bestpair->hit5,hitpair->hit5,listpool); */
	/* transfer_transcripts(bestpair->hit3,hitpair->hit3,listpool); */
	Stage3pair_free(&hitpair);
	/* eliminatedp = true; */
      } else {
	optimal = Hitlist_push(optimal,hitlistpool,(void *) hitpair);
      }
    }
    Hitlist_free(&hitpairlist);
  }
  FREE(hitpairs);
  FREE(eliminate);
  if ((hitpairlist = optimal) == NULL) {
    return (List_T) NULL;
  } else {
    optimal = (List_T) NULL;
  }
  

  debug8(printf("  Step 4.  Maximize best_nmatches_to_trims\n"));

  keptp = false;
  hitpairs = (Stage3pair_T *) List_to_array_n(&n,hitpairlist);
  eliminate = (bool *) CALLOC(n,sizeof(bool));
  qsort(hitpairs,n,sizeof(Stage3pair_T),hitpair_position_cmp);
  i = 0;
  while (i < n) {
    j = i+1;
    while (j < n && hitpair_overlap_p(hitpairs[j],hitpairs[i]) == true) {
      j++;
    }
    if (j - i > 1) {
      debug8(printf("Found a group from %d to %d\n",i,j));
      best_nmatches_to_trims = 0;
      for (k = i; k < j; k++) {
	hitpair = hitpairs[k];
	if ((score = hitpair->hit5->refalt_nmatches_to_trims - hitpair->hit5->nindels +
	     hitpair->hit3->refalt_nmatches_to_trims - hitpair->hit3->nindels) > best_nmatches_to_trims) {
	  best_nmatches_to_trims = score;
	  /* bestpair = hitpair; */
	}
      }
      debug8(printf("best_nmatches_to_trims %d\n",best_nmatches_to_trims));
      
      for (k = i; k < j; k++) {
	hitpair = hitpairs[k];
	/* Do not allow slop for final */
	if ((score = hitpair->hit5->refalt_nmatches_to_trims - hitpair->hit5->nindels +
	     hitpair->hit3->refalt_nmatches_to_trims - hitpair->hit3->nindels) < best_nmatches_to_trims /*- NMATCHES_TO_TRIMS_SLOP*/) {
	  debug8(printf("Within loci pair (nmatches_to_trims %d < %d): Marking hit pair %p for elimination at %d..%d|%d..%d, %u..%u|%u..%u with nsegments %d+%d, pairlength %u, nmatches %d+%d (%d+%d to_trims), sensedirs %d and %d, splice scores %f and %f\n",
			score,best_nmatches_to_trims /*- NMATCHES_TO_TRIMS_SLOP*/,hitpair,
			hitpair->hit5->querystart_trimmed,hitpair->hit5->queryend_trimmed,
			hitpair->hit3->querystart_trimmed,hitpair->hit3->queryend_trimmed,
			hitpair->hit5->low_trimmed - hitpair->hit5->chroffset,hitpair->hit5->high_trimmed - hitpair->hit5->chroffset,
			hitpair->hit3->low_trimmed - hitpair->hit3->chroffset,hitpair->hit3->high_trimmed - hitpair->hit3->chroffset,
			hitpair->hit5->nsegments,hitpair->hit3->nsegments,hitpair->insertlength,
			hitpair->hit5->refalt_nmatches_plus_spliced_trims,hitpair->hit3->refalt_nmatches_plus_spliced_trims,
			hitpair->hit5->refalt_nmatches_to_trims,hitpair->hit3->refalt_nmatches_to_trims,
			hitpair->hit5->sensedir,hitpair->hit3->sensedir,hitpair->hit5->splice_score,hitpair->hit3->splice_score));
	  eliminate[k] = true;
	} else {
	  keptp = true;
	}
      }
    }

    i = j;
  }
  
  if (keptp == false) {
    optimal = hitpairlist;
  } else {
    for (k = 0; k < n; k++) {
      hitpair = hitpairs[k];
      if (eliminate[k] == true) {
	debug8(printf("Within loci pair: Eliminating hit pair %p at %d..%d|%d..%d, %u..%u|%u..%u with nsegments %d+%d, pairlength %u, nmatches %d+%d (%d+%d to_trims), sensedirs %d and %d, splice scores %f and %f\n",
		      hitpair,
		      hitpair->hit5->querystart_trimmed,hitpair->hit5->queryend_trimmed,
		      hitpair->hit3->querystart_trimmed,hitpair->hit3->queryend_trimmed,
		      hitpair->hit5->low_trimmed - hitpair->hit5->chroffset,hitpair->hit5->high_trimmed - hitpair->hit5->chroffset,
		      hitpair->hit3->low_trimmed - hitpair->hit3->chroffset,hitpair->hit3->high_trimmed - hitpair->hit3->chroffset,
		      hitpair->hit5->nsegments,hitpair->hit3->nsegments,hitpair->insertlength,
		      hitpair->hit5->refalt_nmatches_plus_spliced_trims,hitpair->hit3->refalt_nmatches_plus_spliced_trims,hitpair->hit5->refalt_nmatches_to_trims,hitpair->hit3->refalt_nmatches_to_trims,
		      hitpair->hit5->sensedir,hitpair->hit3->sensedir,hitpair->hit5->splice_score,hitpair->hit3->splice_score));
	/* transfer_transcripts(bestpair->hit5,hitpair->hit5,listpool); */
	/* transfer_transcripts(bestpair->hit3,hitpair->hit3,listpool); */
	Stage3pair_free(&hitpair);
	/* eliminatedp = true; */
      } else {
	optimal = Hitlist_push(optimal,hitlistpool,(void *) hitpair);
      }
    }
    Hitlist_free(&hitpairlist);
  }
  FREE(hitpairs);
  FREE(eliminate);
  if ((hitpairlist = optimal) == NULL) {
    return (List_T) NULL;
  } else {
    optimal = (List_T) NULL;
  }


  /* Eliminate within loci (2) : minimize nsegments and maximize splice score (for approximately equal insertlengths) */
  /* Since we have achieved same number of matches, we should minimize nsegments to achieve parsimony */
  debug8(printf("  Step 5.  Minimize nsegments and splice score (for approximately equal insertlengths)\n"));

  keptp = false;
  hitpairs = (Stage3pair_T *) List_to_array_n(&n,hitpairlist);
  eliminate = (bool *) CALLOC(n,sizeof(bool));
  qsort(hitpairs,n,sizeof(Stage3pair_T),hitpair_position_cmp);
  i = 0;
  while (i < n) {
    j = i+1;
    while (j < n && hitpair_overlap_p(hitpairs[j],hitpairs[i]) == true) {
      j++;
    }
    if (j - i > 1) {
      debug8(printf("Found a group from %d to %d\n",i,j));
      best_nsegments = querylength5 + querylength3;
      best_insertlength_score = 99;
      max_splice_score = 0.0;
      for (k = i; k < j; k++) {
	hitpair = hitpairs[k];
	if ((nsegments = hitpair->hit5->nsegments + hitpair->hit3->nsegments) < best_nsegments) {
	  best_nsegments = nsegments;
	  best_insertlength_score = calc_insertlength_score(hitpair->insertlength);
	  max_splice_score = hitpair->hit5->splice_score + hitpair->hit3->splice_score;
	  /* bestpair = hitpair; */

	} else if (nsegments == best_nsegments) {
	  if ((insertlength_score = calc_insertlength_score(hitpair->insertlength)) < best_insertlength_score) {
	    best_insertlength_score = insertlength_score;
	    max_splice_score = hitpair->hit5->splice_score + hitpair->hit3->splice_score;
	    /* bestpair = hitpair; */

	  } else if (insertlength_score == best_insertlength_score) {
	    if ((splice_score = hitpair->hit5->splice_score + hitpair->hit3->splice_score) > max_splice_score) {
	      max_splice_score = splice_score;
	      /* bestpair = hitpair; */
	    }
	  }
	}
      }
      debug8(printf("best_nsegments %d, best_insertlength_score %d, max_splice_score %f\n",
		    best_nsegments,best_insertlength_score,max_splice_score));
      
      for (k = i; k < j; k++) {
	hitpair = hitpairs[k];
	if ((nsegments = hitpair->hit5->nsegments + hitpair->hit3->nsegments) > best_nsegments) {
	  debug8(printf("Within loci pair (nsegments %d > %d): Marking hit pair %p for elimination at %u..%u|%u..%u with nsegments %d+%d, pairlength %u, nmatches %d+%d (%d+%d to_trims), sensedirs %d and %d, splice scores %f and %f\n",
			nsegments,best_nsegments,
			hitpair,hitpair->hit5->low_trimmed - hitpair->hit5->chroffset,hitpair->hit5->high_trimmed - hitpair->hit5->chroffset,
			hitpair->hit3->low_trimmed - hitpair->hit3->chroffset,hitpair->hit3->high_trimmed - hitpair->hit3->chroffset,
			hitpair->hit5->nsegments,hitpair->hit3->nsegments,hitpair->insertlength,
			hitpair->hit5->refalt_nmatches_plus_spliced_trims,hitpair->hit3->refalt_nmatches_plus_spliced_trims,
			hitpair->hit5->refalt_nmatches_to_trims,hitpair->hit3->refalt_nmatches_to_trims,
			hitpair->hit5->sensedir,hitpair->hit3->sensedir,hitpair->hit5->splice_score,hitpair->hit3->splice_score));
	  eliminate[k] = true;

	} else if (calc_insertlength_score(hitpair->insertlength) > best_insertlength_score) {
	  debug8(printf("Within loci pair (insertlength score %d > %d): Marking hit pair %p for elimination at %u..%u|%u..%u with nsegments %d+%d, pairlength %u, nmatches %d+%d (%d+%d to_trims), sensedirs %d and %d, splice scores %f and %f\n",
			calc_insertlength_score(hitpair->insertlength),best_insertlength_score,
			hitpair,hitpair->hit5->low_trimmed - hitpair->hit5->chroffset,hitpair->hit5->high_trimmed - hitpair->hit5->chroffset,
			hitpair->hit3->low_trimmed - hitpair->hit3->chroffset,hitpair->hit3->high_trimmed - hitpair->hit3->chroffset,
			hitpair->hit5->nsegments,hitpair->hit3->nsegments,hitpair->insertlength,
			hitpair->hit5->refalt_nmatches_plus_spliced_trims,hitpair->hit3->refalt_nmatches_plus_spliced_trims,hitpair->hit5->refalt_nmatches_to_trims,hitpair->hit3->refalt_nmatches_to_trims,
			hitpair->hit5->sensedir,hitpair->hit3->sensedir,hitpair->hit5->splice_score,hitpair->hit3->splice_score));
	  eliminate[k] = true;

	} else if (hitpair->hit5->splice_score + hitpair->hit3->splice_score < max_splice_score - SPLICE_SCORE_SLOP) {
	  debug8(printf("Within loci pair (splice_score w/slop %f < %f): Marking hit pair %p for elimination at %u..%u|%u..%u with nsegments %d+%d, pairlength %u, nmatches %d+%d (%d+%d to_trims), sensedirs %d and %d, splice scores %f and %f\n",
			hitpair->hit5->splice_score + hitpair->hit3->splice_score,max_splice_score,
			hitpair,hitpair->hit5->low_trimmed - hitpair->hit5->chroffset,hitpair->hit5->high_trimmed - hitpair->hit5->chroffset,
			hitpair->hit3->low_trimmed - hitpair->hit3->chroffset,hitpair->hit3->high_trimmed - hitpair->hit3->chroffset,
			hitpair->hit5->nsegments,hitpair->hit3->nsegments,hitpair->insertlength,
			hitpair->hit5->refalt_nmatches_plus_spliced_trims,hitpair->hit3->refalt_nmatches_plus_spliced_trims,hitpair->hit5->refalt_nmatches_to_trims,hitpair->hit3->refalt_nmatches_to_trims,
			hitpair->hit5->sensedir,hitpair->hit3->sensedir,hitpair->hit5->splice_score,hitpair->hit3->splice_score));
	  eliminate[k] = true;

	} else {
	  keptp = true;
	}
      }
    }

    i = j;
  }
  
  if (keptp == false) {
    optimal = hitpairlist;
  } else {
    for (k = 0; k < n; k++) {
      hitpair = hitpairs[k];
      if (eliminate[k] == true) {
	debug8(printf("Within loci pair: Eliminating hit pair %p at %u..%u|%u..%u with nsegments %d+%d, pairlength %u, nmatches %d+%d (%d+%d to_trims), sensedirs %d and %d, splice scores %f and %f\n",
		      hitpair,hitpair->hit5->low_trimmed - hitpair->hit5->chroffset,hitpair->hit5->high_trimmed - hitpair->hit5->chroffset,
		      hitpair->hit3->low_trimmed - hitpair->hit3->chroffset,hitpair->hit3->high_trimmed - hitpair->hit3->chroffset,
		      hitpair->hit5->nsegments,hitpair->hit3->nsegments,hitpair->insertlength,
		      hitpair->hit5->refalt_nmatches_plus_spliced_trims,hitpair->hit3->refalt_nmatches_plus_spliced_trims,hitpair->hit5->refalt_nmatches_to_trims,hitpair->hit3->refalt_nmatches_to_trims,
		      hitpair->hit5->sensedir,hitpair->hit3->sensedir,hitpair->hit5->splice_score,hitpair->hit3->splice_score));
	/* transfer_transcripts(bestpair->hit5,hitpair->hit5,listpool); */
	/* transfer_transcripts(bestpair->hit3,hitpair->hit3,listpool); */
	Stage3pair_free(&hitpair);
	/* eliminatedp = true; */
      } else {
	optimal = Hitlist_push(optimal,hitlistpool,(void *) hitpair);
      }
    }
    Hitlist_free(&hitpairlist);
  }
  FREE(hitpairs);
  FREE(eliminate);
  if ((hitpairlist = optimal) == NULL) {
    return (List_T) NULL;
  } else {
    optimal = (List_T) NULL;
  }
  

  /* Eliminate within loci: minimize outerlength */
  debug8(printf("  Step 6.  Minimize outerlength\n"));

  keptp = false;
  hitpairs = (Stage3pair_T *) List_to_array_n(&n,hitpairlist);
  eliminate = (bool *) CALLOC(n,sizeof(bool));
  qsort(hitpairs,n,sizeof(Stage3pair_T),hitpair_position_cmp);
  i = 0;
  while (i < n) {
    j = i+1;
    while (j < n && hitpair_overlap_p(hitpairs[j],hitpairs[i]) == true) {
      j++;
    }
    if (j - i > 1) {
      debug8(printf("Found a group from %d to %d\n",i,j));
      best_outerlength = (Chrpos_T) -1U;
      for (k = i; k < j; k++) {
	hitpair = hitpairs[k];
	if (hitpair->outerlength < best_outerlength) {
	  best_outerlength = hitpair->outerlength;
	  /* bestpair = hitpair; */
	}
      }
      debug8(printf("best_outerlength %u\n",best_outerlength));
      
      for (k = i; k < j; k++) {
	hitpair = hitpairs[k];
	if (hitpair->outerlength > best_outerlength) {
	  debug8(printf("Within loci pair (outerlength %u > %u): Eliminating hit pair %p at %u..%u|%u..%u with nmatches %d+%d (%d+%d to trims)\n",
			hitpair->outerlength,best_outerlength /*+ OUTERLENGTH_SLOP*/,
			hitpair,hitpair->hit5->low_trimmed - hitpair->hit5->chroffset,hitpair->hit5->high_trimmed - hitpair->hit5->chroffset,
			hitpair->hit3->low_trimmed - hitpair->hit3->chroffset,hitpair->hit3->high_trimmed - hitpair->hit3->chroffset,
			hitpair->hit5->refalt_nmatches_plus_spliced_trims,hitpair->hit3->refalt_nmatches_plus_spliced_trims,
			hitpair->hit5->refalt_nmatches_to_trims,hitpair->hit3->refalt_nmatches_to_trims));
	  eliminate[k] = true;

	} else {
	  debug8(printf("Within loci pair (outerlength %u == %u): Keeping hit pair %p at %u..%u|%u..%u with nmatches %d+%d (%d+%d to trims)\n",
			hitpair->outerlength,best_outerlength /*+ OUTERLENGTH_SLOP*/,
			hitpair,hitpair->hit5->low_trimmed - hitpair->hit5->chroffset,hitpair->hit5->high_trimmed - hitpair->hit5->chroffset,
			hitpair->hit3->low_trimmed - hitpair->hit3->chroffset,hitpair->hit3->high_trimmed - hitpair->hit3->chroffset,
			hitpair->hit5->refalt_nmatches_plus_spliced_trims,hitpair->hit3->refalt_nmatches_plus_spliced_trims,
			hitpair->hit5->refalt_nmatches_to_trims,hitpair->hit3->refalt_nmatches_to_trims));
	  keptp = true;
	}
      }
    }

    i = j;
  }
  
  if (keptp == false) {
    optimal = hitpairlist;
  } else {
    for (k = 0; k < n; k++) {
      hitpair = hitpairs[k];
      if (eliminate[k] == true) {
	debug8(printf("Within loci pair: Eliminating hit pair %p at %u..%u|%u..%u with nsegments %d+%d, pairlength %u, nmatches %d+%d (%d+%d to_trims), sensedirs %d and %d, splice scores %f and %f\n",
		      hitpair,hitpair->hit5->low_trimmed - hitpair->hit5->chroffset,hitpair->hit5->high_trimmed - hitpair->hit5->chroffset,
		      hitpair->hit3->low_trimmed - hitpair->hit3->chroffset,hitpair->hit3->high_trimmed - hitpair->hit3->chroffset,
		      hitpair->hit5->nsegments,hitpair->hit3->nsegments,hitpair->insertlength,
		      hitpair->hit5->refalt_nmatches_plus_spliced_trims,hitpair->hit3->refalt_nmatches_plus_spliced_trims,hitpair->hit5->refalt_nmatches_to_trims,hitpair->hit3->refalt_nmatches_to_trims,
		      hitpair->hit5->sensedir,hitpair->hit3->sensedir,hitpair->hit5->splice_score,hitpair->hit3->splice_score));
	/* transfer_transcripts(bestpair->hit5,hitpair->hit5,listpool); */
	/* transfer_transcripts(bestpair->hit3,hitpair->hit3,listpool); */
	Stage3pair_free(&hitpair);
	/* eliminatedp = true; */
      } else {
	optimal = Hitlist_push(optimal,hitlistpool,(void *) hitpair);
      }
    }
    Hitlist_free(&hitpairlist);
  }
  FREE(hitpairs);
  FREE(eliminate);
  hitpairlist = optimal;


  return hitpairlist;
}


#ifdef PRE_RESOLVE_MULTIMAPPING
List_T
Stage3pair_resolve_multimapping (List_T hitpairs, Hitlistpool_T hitlistpool) {
  List_T resolve1, resolve2, resolve3, p;
  Stage3pair_T hitpair;

  long int best_tally;
  double tally_threshold;
  bool runlengthp;


  if (List_length(hitpairs) <= 1) {
    return hitpairs;
  }

#if 0
  if (genes_iit == NULL) {
    resolve1 = hitpairs;
  } else {
    best_overlap = NO_KNOWN_GENE;
    for (p = hitpairs; p != NULL; p = p->rest) {
      hitpair = (Stage3pair_T) p->first;
      if ((hitpair->gene_overlap = Stage3pair_gene_overlap(hitpair)) > best_overlap) {
	best_overlap = hitpair->gene_overlap;
      }
    }
    if (best_overlap == NO_KNOWN_GENE) {
      resolve1 = hitpairs;
    } else {
      resolve1 = (List_T) NULL;
      for (p = hitpairs; p != NULL; p = p->rest) {
	hitpair = (Stage3pair_T) p->first;
	if (hitpair->gene_overlap < best_overlap) {
	  Stage3pair_free(&hitpair);
	} else {
	  resolve1 = Hitlist_push(resolve1,hitlistpool,(void *) hitpair);
	}
      }
      Hitlist_free(&hitpairs);
    }
  }
      
  if (List_length(resolve1) <= 1) {
    return resolve1;
  }
#else
  resolve1 = hitpairs;
#endif

  if (tally_iit == NULL) {
    resolve2 = resolve1;
  } else {
    best_tally = 0L;
    for (p = resolve1; p != NULL; p = p->rest) {
      hitpair = (Stage3pair_T) p->first;
      if ((hitpair->tally = Stage3end_compute_tally(hitpair->hit5) + Stage3end_compute_tally(hitpair->hit3)) > best_tally) {
	best_tally = hitpair->tally;
      }
    }
    if (best_tally == 0L) {
      resolve2 = resolve1;
    } else {
      resolve2 = (List_T) NULL;
#ifdef USE_TALLY_RATIO
      tally_threshold = (double) best_tally / TALLY_RATIO;
#else
      tally_threshold = 1.0;
#endif
      for (p = resolve1; p != NULL; p = p->rest) {
	hitpair = (Stage3pair_T) p->first;
	if ((double) hitpair->tally < tally_threshold) {
	  Stage3pair_free(&hitpair);
	} else {
	  resolve2 = Hitlist_push(resolve2,hitlistpool,(void *) hitpair);
	}
      }
      Hitlist_free(&resolve1);
    }
  }

  if (List_length(resolve2) <= 1) {
    return resolve2;
  }

  if (runlength_iit == NULL) {
    resolve3 = resolve2;
  } else {
    runlengthp = false;
    for (p = resolve2; p != NULL; p = p->rest) {
      hitpair = (Stage3pair_T) p->first;
      if (Stage3end_runlength_p(hitpair->hit5) == true || Stage3end_runlength_p(hitpair->hit3) == true) {
	runlengthp = true;
      }
    }
    if (runlengthp == false) {
      resolve3 = resolve2;
    } else {
      resolve3 = (List_T) NULL;
      for (p = resolve2; p != NULL; p = p->rest) {
	hitpair = (Stage3pair_T) p->first;
	if (Stage3end_runlength_p(hitpair->hit5) == false && Stage3end_runlength_p(hitpair->hit3) == false) {
	  Stage3pair_free(&hitpair);
	} else {
	  resolve3 = Hitlist_push(resolve3,hitlistpool,(void *) hitpair);
	}
      }
      Hitlist_free(&resolve2);
    }
  }


  return resolve3;
}
#endif


#if 0
/* Eliminates entire pair even if only one end is bad.  Should filter each end, and not each pair */
List_T
Stage3pair_filter (List_T hits, Hitlistpool_T hitlistpool,
		   int max_mismatches_5, int max_mismatches_3,
		   int min_coverage_5, int min_coverage_3) {
  List_T newhits = NULL, p;
  Stage3end_T hit5, hit3;
  Stage3pair_T hitpair;

  /* Previously had option filter_within_trims_p to look at refalt_score_overall */
  for (p = hits; p != NULL; p = List_next(p)) {
    hitpair = (Stage3pair_T) List_head(p);
    hit5 = hitpair->hit5;
    hit3 = hitpair->hit3;
    debug(printf("refalt_score_within_trims is %d and %d\n",hit5->refalt_score_within_trims,hit3->refalt_score_within_trims));

    if (hit5->refalt_score_within_trims > max_mismatches_5 || hit3->refalt_score_within_trims > max_mismatches_3) {
      Stage3pair_free(&hitpair);
    } else if (hit5->queryend_trimmed - hit5->querystart_trimmed < min_coverage_5 &&
	       hit3->queryend_trimmed - hit3->querystart_trimmed < min_coverage_3) {
      Stage3pair_free(&hitpair);
    } else {
      newhits = Hitlist_push(newhits,hitlistpool,(void *) hitpair);
    }
  }

  Hitlist_free(&hits);
  return newhits;
}
#endif


Stage3pair_T *
Stage3pair_eval_and_sort (int npaths, int *first_absmq, int *second_absmq,
			  Stage3pair_T *stage3pairarray,
			  char *queryuc_ptr_5, char *queryuc_ptr_3,
			  char *quality_string_5, char *quality_string_3,
			  Listpool_T listpool) {
  float maxlik, loglik;

  float total, q;
  int mapq_score;

  int compute_npaths;
  int randomi, i;
  Stage3pair_T temp, hitpair;

  if (npaths == 0) {
    /* Skip */
    *first_absmq = 0;
    *second_absmq = 0;

  } else if (npaths == 1) {
    hitpair = stage3pairarray[0];
    hitpair->mapq_loglik = MAPQ_MAXIMUM_SCORE;
    hitpair->mapq_score = MAPQ_max_quality_score(quality_string_5,hitpair->hit5->querylength);
    if ((mapq_score = MAPQ_max_quality_score(quality_string_3,hitpair->hit3->querylength)) > stage3pairarray[0]->mapq_score) {
      hitpair->mapq_score = mapq_score;
    }
    hitpair->absmq_score = MAPQ_MAXIMUM_SCORE;

    Stage3end_display_prep(hitpair->hit5,listpool,queryuc_ptr_5,/*first_read_p*/true);
    Stage3end_display_prep(hitpair->hit3,listpool,queryuc_ptr_3,/*first_read_p*/false);

    *first_absmq = hitpair->absmq_score;
    *second_absmq = 0;

  } else {

    /* Resolve ambiguities, needed for computing mapq and finding concordant transcripts */
    for (i = 0; i < npaths; i++) {
      hitpair = stage3pairarray[i];
      Stage3end_display_prep(hitpair->hit5,listpool,queryuc_ptr_5,/*first_read_p*/true);
      Stage3end_display_prep(hitpair->hit3,listpool,queryuc_ptr_3,/*first_read_p*/false);
    }


    /* Compute mapq_loglik */
    for (i = 0; i < npaths; i++) {
      hitpair = stage3pairarray[i];
      hitpair->mapq_loglik =
	Stage3end_compute_mapq(hitpair->hit5,quality_string_5,genomebits,genomebits_alt);
      hitpair->mapq_loglik +=
	Stage3end_compute_mapq(hitpair->hit3,quality_string_3,genomebits,genomebits_alt);
    }

    /* Sort by nmatches, then mapq, and then insert length */
    qsort(stage3pairarray,npaths,sizeof(Stage3pair_T),Stage3pair_output_cmp);

    if (want_random_p) {
      /* Randomize among best alignments */
      i = 1;
      while (i < npaths && Stage3pair_output_cmp(&(stage3pairarray[i]),&(stage3pairarray[0])) == 0) {
	i++;
      }
      if (i > 1) {		/* i is number of ties */
	/* randomi = (int) ((double) i * rand()/((double) RAND_MAX + 1.0)); */
	randomi = (int) (rand() / (((double) RAND_MAX + 1.0) / (double) i));
	/* fprintf(stderr,"%d dups => random %d\n",i,randomi); */
	temp = stage3pairarray[0];
	stage3pairarray[0] = stage3pairarray[randomi];
	stage3pairarray[randomi] = temp;
      }
    }

    /* Enforce monotonicity */
    for (i = npaths - 1; i > 0; i--) {
      if (stage3pairarray[i-1]->mapq_loglik < stage3pairarray[i]->mapq_loglik) {
	stage3pairarray[i-1]->mapq_loglik = stage3pairarray[i]->mapq_loglik;
      }
    }
    maxlik = stage3pairarray[0]->mapq_loglik;

    /* Subtract maxlik to avoid underflow */
    for (i = 0; i < npaths; i++) {
      stage3pairarray[i]->mapq_loglik -= maxlik;
    }

#if 0
    /* Save on computation if possible */
    /* Doesn't work */
    if (npaths < maxpaths) {
      compute_npaths = npaths;
    } else {
      compute_npaths = maxpaths;
    }
    if (compute_npaths < 2) {
      compute_npaths = 2;
    }
#else
    compute_npaths = npaths;
#endif


    /* Compute absolute mapq */
    for (i = 0; i < compute_npaths; i++) {
      loglik = stage3pairarray[i]->mapq_loglik + MAPQ_MAXIMUM_SCORE;
      if (loglik < 0.0) {
	loglik = 0.0;
      }
      stage3pairarray[i]->absmq_score = rint(loglik);
    }
    *first_absmq = stage3pairarray[0]->absmq_score;
    *second_absmq = stage3pairarray[1]->absmq_score;


    /* Compute Bayesian mapq */
    total = 0.0;
    for (i = 0; i < npaths; i++) {
      total += (stage3pairarray[i]->mapq_loglik = fasterexp(stage3pairarray[i]->mapq_loglik));
    }

    /* Obtain posterior probabilities of being true */
    for (i = 0; i < compute_npaths; i++) {
      stage3pairarray[i]->mapq_loglik /= total;
    }

    /* Convert to Phred scores */
    for (i = 0; i < compute_npaths; i++) {
      if ((q = 1.0 - stage3pairarray[i]->mapq_loglik) < 2.5e-10 /* 10^-9.6 */) {
	stage3pairarray[i]->mapq_score = 96;
      } else {
	stage3pairarray[i]->mapq_score = rint(-10.0 * log10(q));
      }
    }

#if 0
    /* Apply filtering for mapq unique -- currently not used since mapq_unique_score is high */
    if (stage3pairarray[0]->mapq_score >= mapq_unique_score &&
	stage3pairarray[1]->mapq_score < mapq_unique_score) {
      for (i = 1; i < *npaths; i++) {
	Stage3pair_free(&(stage3pairarray[i]));
      }
      *npaths = 1;
    }
#endif
  }

  return stage3pairarray;
}


static List_T
Stage3pair_optimal_score_prefinal (bool *eliminatedp, List_T hitpairlist,
				   Hitlistpool_T hitlistpool, int querylength5, int querylength3) {
  List_T optimal = NULL, p, q;
  Stage3pair_T hitpair;
  T hit5, hit3;
  Substring_T substring;
  Junction_T junction;
  int cutoff_level_5, cutoff_level_3, ref_nmismatches;
  int n;
  int minscore5 = querylength5, minscore3 = querylength3, minscore = querylength5 + querylength3;
#ifdef USE_OPTIMAL_SCORE_BINGO
  int minscore_bingo = querylength5 + querylength3;
#endif
  int querystart_trimmed_5 = 0, queryend_trimmed_5 = querylength5, querystart_trimmed_3 = 0, queryend_trimmed_3 = querylength3;


#if 0 /* DISTANT_SPLICE_SPECIAL */
  bool shortdistance_p = false;
#endif


  *eliminatedp = false;
  n = List_length(hitpairlist);
  debug8(printf("\nEntered Stage3pair_optimal_score_prefinal with %d hitpairs\n",n));
  
  if (n <= 1) {
    return hitpairlist;
  }


  /* Use eventrim for comparing alignments.  Previously picked
     smallest trims, but now picking largest ones */
  for (p = hitpairlist; p != NULL; p = p->rest) {
    hitpair = (Stage3pair_T) p->first;
    hit5 = hitpair->hit5;
    hit3 = hitpair->hit3;

    debug8(printf("hit5 %u..%u method %s, nsegments %d, nindels %d, querystart_trimmed: %d%s, queryend_trimmed %d%s, start_ambig %d, end_ambig %d, sensedir %d, splice score %f\n",
		  hit5->genomicstart - hit5->chroffset,hit5->genomicend - hit5->chroffset,Method_string(hit5->method),
		  hit5->nsegments,hit5->nindels,hit5->querystart_trimmed,hit5->querystart_trimmed_splicep ? " (splice)" : "",
		  hit5->queryend_trimmed,hit5->queryend_trimmed_splicep ? " (splice)" : "",
		  start_amb_length(hit5),end_amb_length(hit5),hit5->sensedir,hit5->splice_score));

    debug8(printf("hit3 %u..%u method %s, nsegments %d, nindels %d, querystart_trimmed %d%s, queryend_trimmed %d%s, start_ambig %d, end_ambig %d, sensedir %d, splice score %f\n\n",
		  hit3->genomicstart - hit3->chroffset,hit3->genomicend - hit3->chroffset,Method_string(hit3->method),
		  hit3->nsegments,hit3->nindels,hit3->querystart_trimmed,hit3->querystart_trimmed_splicep ? " (splice)" : "",
		  hit3->queryend_trimmed,hit3->queryend_trimmed_splicep ? " (splice)" : "",
		  start_amb_length(hit3),end_amb_length(hit3),hit3->sensedir,hit3->splice_score));

    if (hit5->querystart_trimmed_splicep == true) {
      /* Skip */
    } else if (hit5->querystart_trimmed > querystart_trimmed_5) {
      querystart_trimmed_5 = hit5->querystart_trimmed;
    }
    if (hit5->queryend_trimmed_splicep == true) {
      /* Skip */
    } else if (hit5->queryend_trimmed < queryend_trimmed_5) {
      queryend_trimmed_5 = hit5->queryend_trimmed;
    }

    if (hit3->querystart_trimmed_splicep == true) {
      /* Skip */
    } else if (hit3->querystart_trimmed > querystart_trimmed_3) {
      querystart_trimmed_3 = hit3->querystart_trimmed;
    }
    if (hit3->queryend_trimmed_splicep == true) {
      /* Skip */
    } else if (hit3->queryend_trimmed < queryend_trimmed_3) {
      queryend_trimmed_3 = hit3->queryend_trimmed;
    }
  }

  if (querystart_trimmed_5 == querylength5) {
    querystart_trimmed_5 = 0;
  }
  if (queryend_trimmed_5 == 0) {
    queryend_trimmed_5 = querylength5;
  }
  if (querystart_trimmed_3 == querylength3) {
    querystart_trimmed_3 = 0;
  }
  if (queryend_trimmed_3 == 0) {
    queryend_trimmed_3 = querylength3;
  }

  debug8(printf("overall 5': querystart_trimmed %d, queryend_trimmed %d\n",querystart_trimmed_5,queryend_trimmed_5));
  debug8(printf("overall 3': querystart_trimmed %d, queryend_trimmed %d\n",querystart_trimmed_3,queryend_trimmed_3));


  for (p = hitpairlist; p != NULL; p = p->rest) {
    hitpair = (Stage3pair_T) p->first;
    hit5 = hitpair->hit5;
    hit3 = hitpair->hit3;

#ifdef CONSIDER_ENDS_IN_EVAL
    hit5->score_eventrim = hit5->querystart_trimmed / 8 + (hit5->querylength - hit5->queryend_trimmed) / 8;
#else
    hit5->score_eventrim = 0;
#endif

    debug8(printf("score 5' OTHER:"));

    if (querystart_trimmed_5 >= queryend_trimmed_5) {
      for (q = hit5->substrings_1toN; q != NULL; q = List_next(q)) {
	substring = (Substring_T) List_head(q);
	hit5->score_eventrim += Substring_nmismatches_bothdiff(substring);
      }

    } else {
      for (q = hit5->substrings_1toN; q != NULL; q = List_next(q)) {
	substring = (Substring_T) List_head(q);
	hit5->score_eventrim += Substring_count_mismatches_region(&ref_nmismatches,substring,querystart_trimmed_5,queryend_trimmed_5,
								  genomebits,genomebits_alt);
	debug8(printf("  substring (%d..%d) %d.",querystart_trimmed_5,queryend_trimmed_5,
		      Substring_count_mismatches_region(&ref_nmismatches,substring,querystart_trimmed_5,queryend_trimmed_5,
							genomebits,genomebits_alt)));
      }
    }

    for (q = hit5->junctions_1toN; q != NULL; q = List_next(q)) {
      junction = (Junction_T) List_head(q);
      if (Junction_nindels(junction) > 0) {
	hit5->score_eventrim += indel_penalty_middle;
	debug8(printf(" => add %d.",indel_penalty_middle));
      }
    }


#if 0
    /* Accept a single indel */
#ifdef SCORE_INDELS_EVENTRIM
    if (hit5->hittype == INSERTION || hit5->hittype == DELETION) {
      debug8(printf("  indel at %d",hit5->indel_pos));
      if (hit5->indel_pos > querystart_trimmed_5 && hit5->indel_pos < queryend_trimmed_5) {
	hit5->score_eventrim += indel_penalty_middle;
	debug8(printf(" => add %d.",indel_penalty_middle));
      }
    }
#endif
#endif
    debug8(printf("  RESULT: %d\n",hit5->score_eventrim));

    if (hitpair->hit5->score_eventrim < minscore5) {
      minscore5 = hitpair->hit5->score_eventrim;
    }


#ifdef CONSIDER_ENDS_IN_EVAL
    hit3->score_eventrim = hit3->querystart_trimmed / 8 + (hit3->querylength - hit3->queryend_trimmed) / 8;
#else
    hit3->score_eventrim = 0;
#endif

    debug8(printf("score 3' OTHER:"));

    if (querystart_trimmed_3 >= queryend_trimmed_3) {
      for (q = hit3->substrings_1toN; q != NULL; q = List_next(q)) {
	substring = (Substring_T) List_head(q);
	hit3->score_eventrim += Substring_nmismatches_bothdiff(substring);
      }

    } else {
      for (q = hit3->substrings_1toN; q != NULL; q = List_next(q)) {
	substring = (Substring_T) List_head(q);
	hit3->score_eventrim += Substring_count_mismatches_region(&ref_nmismatches,substring,querystart_trimmed_3,queryend_trimmed_3,
								  genomebits,genomebits_alt);
	debug8(printf("  substring (%d..%d) %d.",querystart_trimmed_3,queryend_trimmed_3,
		      Substring_count_mismatches_region(&ref_nmismatches,substring,querystart_trimmed_3,queryend_trimmed_3,
							genomebits,genomebits_alt)));
      }
    }

    for (q = hit3->junctions_1toN; q != NULL; q = List_next(q)) {
      junction = (Junction_T) List_head(q);
      if (Junction_nindels(junction) > 0) {
	hit3->score_eventrim += indel_penalty_middle;
	debug8(printf(" => add %d.",indel_penalty_middle));
      }
    }

#if 0
    /* Accept a single indel */
#ifdef SCORE_INDELS_EVENTRIM
    if (hit3->hittype == INSERTION || hit3->hittype == DELETION) {
      debug8(printf("  indel at %d",hit3->indel_pos));
      if (hit3->indel_pos > querystart_trimmed_3 && hit3->indel_pos < queryend_trimmed_3) {
	hit3->score_eventrim += indel_penalty_middle;
	debug8(printf(" => add %d.",indel_penalty_middle));
      }
    }
#endif
#endif
    debug8(printf("  RESULT: %d\n",hit3->score_eventrim));

    if (hitpair->hit3->score_eventrim < minscore3) {
      minscore3 = hitpair->hit3->score_eventrim;
    }


    /* Compute for hitpair */
    debug8(printf("hitpair score_eventrim %d = %d + %d\n",
		  hit5->score_eventrim + hit3->score_eventrim,
		  hit5->score_eventrim,hit3->score_eventrim));
    hitpair->score_eventrim = hit5->score_eventrim + hit3->score_eventrim;
    if (hitpair->score_eventrim < minscore) {
      minscore = hitpair->score_eventrim;
    }

  }
  debug8(printf("MINSCORE: %d\n",minscore));


  /* Prefinal: Use score_eventrim */
  debug8(printf("Stage3pair_optimal_score_prefinal over %d pairs: minscore = %d and %d + subopt:%d\n",
		n,minscore5,minscore3,subopt_levels));

  /* finalp == false.  Add suboptimal_mismatches to each end. */
  minscore5 += subopt_levels;
  minscore3 += subopt_levels;
  cutoff_level_5 = minscore5;
  cutoff_level_3 = minscore3;

  for (p = hitpairlist; p != NULL; p = p->rest) {
    hitpair = (Stage3pair_T) p->first;

    if (hitpair->hit5->score_eventrim > cutoff_level_5 + SCORE_EVENTRIM_SLOP && hitpair->hit3->score_eventrim > cutoff_level_3 + SCORE_EVENTRIM_SLOP) {
      debug8(printf("Prefinal: Eliminating hit pair %p at %u..%u|%u..%u with score_eventrim_5 %d > cutoff_level_5 %d and score_eventrim_3 %d > cutoff_level_3 %d, sensedirs %d and %d, splice scores %f and %f\n",
		    hitpair,hitpair->hit5->low_trimmed - hitpair->hit5->chroffset,hitpair->hit5->high_trimmed - hitpair->hit5->chroffset,
		    hitpair->hit3->low_trimmed - hitpair->hit3->chroffset,hitpair->hit3->high_trimmed - hitpair->hit3->chroffset,
		    hitpair->hit5->score_eventrim,cutoff_level_5,hitpair->hit3->score_eventrim,cutoff_level_3,
		    hitpair->hit5->sensedir,hitpair->hit3->sensedir,hitpair->hit5->splice_score,hitpair->hit3->splice_score));
      Stage3pair_free(&hitpair);
      *eliminatedp = true;

    } else {
      debug8(printf("Prefinal: Keeping hit pair %p at %u..%u|%u..%u with score_eventrim_5 %d <= cutoff_level_5 %d or score_eventrim_3 %d <= cutoff_level_3 %d, sensedirs %d and %d, splice scores %f and %f\n",
		    hitpair,hitpair->hit5->low_trimmed - hitpair->hit5->chroffset,hitpair->hit5->high_trimmed - hitpair->hit5->chroffset,
		    hitpair->hit3->low_trimmed - hitpair->hit3->chroffset,hitpair->hit3->high_trimmed - hitpair->hit3->chroffset,
		    hitpair->hit5->score_eventrim,cutoff_level_5,hitpair->hit3->score_eventrim,cutoff_level_3,
		    hitpair->hit5->sensedir,hitpair->hit3->sensedir,hitpair->hit5->splice_score,hitpair->hit3->splice_score));
      optimal = Hitlist_push(optimal,hitlistpool,(void *) hitpair);
    }
  }
  Hitlist_free(&hitpairlist);


#if 0
  /* Filter on nsegments */
  if (finalp == true && optimal != NULL) {
    hitpairlist = optimal;
    optimal = (List_T) NULL;

    hitpair = (Stage3pair_T) hitpairlist->first;
    best_nsegments = hitpair->hit5->nsegments + hitpair->hit3->nsegments;
    best_nsegments_5 = hitpair->hit5->nsegments;
    best_nsegments_3 = hitpair->hit3->nsegments;

    for (p = hitpairlist; p != NULL; p = p->rest) {
      hitpair = (Stage3pair_T) p->first;
      if (hitpair->hit5->nsegments + hitpair->hit3->nsegments < best_nsegments) {
	best_nsegments = hitpair->hit5->nsegments + hitpair->hit3->nsegments;
      }
      if (hitpair->hit5->nsegments < best_nsegments_5) {
	best_nsegments_5 = hitpair->hit5->nsegments;
      }
      if (hitpair->hit3->nsegments < best_nsegments_3) {
	best_nsegments_3 = hitpair->hit3->nsegments;
      }
    }

    for (p = hitpairlist; p != NULL; p = p->rest) {
      hitpair = (Stage3pair_T) p->first;
      if (hitpair->hit5->nsegments + hitpair->hit3->nsegments > best_nsegments + 2) {
	debug8(printf("Eliminating hit pair %p with nsegments %d+%d, sensedirs %d and %d, splice scores %f and %f\n",
		      hitpair,hitpair->hit5->nsegments,hitpair->hit3->nsegments,
		      hitpair->hit5->sensedir,hitpair->hit3->sensedir,hitpair->hit5->splice_score,hitpair->hit3->splice_score));
	Stage3pair_free(&hitpair);
	*eliminatedp = true;
      } else {
	debug8(printf("Keeping hit pair %p with nsegments %d+%d, sensedirs %d and %d, splice scores %f and %f\n",
		      hitpair,hitpair->hit5->nsegments,hitpair->hit3->nsegments,
		      hitpair->hit5->sensedir,hitpair->hit3->sensedir,hitpair->hit5->splice_score,hitpair->hit3->splice_score));
	optimal = Hitlist_push(optimal,hitlistpool,(void *) hitpair);
      }
    }

    Hitlist_free(&hitpairlist);
  }
#endif


#if 0
  /* Filter on pairlength */
  if (optimal != NULL) {
    hitpairlist = optimal;
    optimal = (List_T) NULL;

    hitpair = (Stage3pair_T) hitpairlist->first;
    best_absdifflength = hitpair->absdifflength;
    best_outerlength = hitpair->outerlength;

    for (p = hitpairlist; p != NULL; p = p->rest) {
      hitpair = (Stage3pair_T) p->first;
      if (hitpair->absdifflength < best_absdifflength) {
	best_absdifflength = hitpair->absdifflength;
	best_outerlength = hitpair->outerlength;
      } else if (hitpair->absdifflength > best_absdifflength) {
	/* Skip */
      } else if (hitpair->outerlength < best_outerlength) {
	best_outerlength = hitpair->outerlength;
      }
    }

    for (p = hitpairlist; p != NULL; p = p->rest) {
      hitpair = (Stage3pair_T) p->first;
      if (hitpair->absdifflength > best_absdifflength) {
	debug8(printf("Eliminating hit pair %p with absdifflength %d\n",hitpair,hitpair->absdifflength));
	Stage3pair_free(&hitpair);
	*eliminatedp = true;
      } else if (hitpair->outerlength > best_outerlength + OUTERLENGTH_SLOP) {
	debug8(printf("Eliminating hit pair %p with outerlength %u\n",hitpair,hitpair->outerlength));
	Stage3pair_free(&hitpair);
	*eliminatedp = true;
      } else {
	debug8(printf("Keeping hit pair %p with absdifflength %d and outerlength %d\n",
		      hitpair,hitpair->absdifflength,hitpair->outerlength));
	optimal = Hitlist_push(optimal,hitlistpool,(void *) hitpair);
      }
    }

    Hitlist_free(&hitpairlist);
  }
#endif

  debug8(printf("Exiting Stage3pair_optimal_score_prefinal with %d hits\n",List_length(optimal)));
  return optimal;
}


/* Desired criteria: (A) within locus: (A.1) nsegments within locus,
   to get most complete alignment; (A.2) insertlength; and (A.3)
   splice_score, to get the correct sensedir.  (B) between loci:
   nmatches (and not nmatches_to_trims), to end alignments at the
   splice site */

#if 0
static List_T
Stage3pair_optimal_score_final_old (bool *eliminatedp, List_T hitpairlist,
				    Hitlistpool_T hitlistpool, int querylength5, int querylength3) {
  List_T optimal = NULL, p;
  Stage3pair_T *hitpairs, hitpair;
  int n, i, j, k;
  int best_nsegments, nsegments;
  int best_insertlength_score, insertlength_score;
  int best_nmatches_to_trims, nmatches_to_trims;
  double max_splice_score, splice_score;
  int max_nmatches = 0, cutoff_level;
  /* int trim5_left, trim5_right, trim3_left, trim3_right, min_trim; */
  bool *eliminate, keptp;

  /* Relies on Path_solve_from_diagonals to maximize the number of segments at each locus */

  *eliminatedp = false;
  n = List_length(hitpairlist);
  debug8(printf("\nEntered Stage3pair_optimal_score_final with %d hitpairs\n",n));
  
  if (n <= 1) {
    return hitpairlist;
  }

#ifdef DEBUG8
  for (p = hitpairlist; p != NULL; p = p->rest) {
    hitpair = (Stage3pair_T) p->first;
    printf("%p %p %u..%u|%u..%u methods %s and %s, nsegments %d+%d, nmatches %d+%d (%d+%d to trims), pairlength %u, outerlength %u, sensedirs %d and %d, splice scores %f and %f\n",
	   hitpair->hit5,hitpair->hit3,
	   hitpair->hit5->low_trimmed - hitpair->hit5->chroffset,hitpair->hit5->high_trimmed - hitpair->hit5->chroffset,
	   hitpair->hit3->low_trimmed - hitpair->hit3->chroffset,hitpair->hit3->high_trimmed - hitpair->hit3->chroffset,
	   Method_string(hitpair->hit5->method),Method_string(hitpair->hit3->method),
	   hitpair->hit5->nsegments,hitpair->hit3->nsegments,
	   hitpair->hit5->refalt_nmatches_plus_spliced_trims,hitpair->hit3->refalt_nmatches_plus_spliced_trims,
	   hitpair->hit5->refalt_nmatches_to_trims,hitpair->hit3->refalt_nmatches_to_trims,
	   hitpair->insertlength,hitpair->outerlength,
	   hitpair->hit5->sensedir,hitpair->hit3->sensedir,hitpair->hit5->splice_score,hitpair->hit3->splice_score);
  }
#endif


  /* Prune based on refalt_nmatches_plus_spliced_trims (to get the splice ends) */
  max_nmatches = 0;
  for (p = hitpairlist; p != NULL; p = p->rest) {
    hitpair = (Stage3pair_T) p->first;
    if (hitpair->hit5->refalt_nmatches_plus_spliced_trims + hitpair->hit3->refalt_nmatches_plus_spliced_trims > max_nmatches) {
      max_nmatches = hitpair->hit5->refalt_nmatches_plus_spliced_trims + hitpair->hit3->refalt_nmatches_plus_spliced_trims;
      assert(max_nmatches <= querylength5 + querylength3);
    }
  }

  /* May not want to be greedy on cutoff level here.  Might want to raise subopt_levels */
  cutoff_level = max_nmatches - subopt_levels;
  debug8(printf("(1) refalt cutoff level %d = max_nmatches %d\n",cutoff_level,max_nmatches));

  for (p = hitpairlist; p != NULL; p = p->rest) {
    hitpair = (Stage3pair_T) p->first;

    if (hitpair->hit5->refalt_nmatches_plus_spliced_trims + hitpair->hit3->refalt_nmatches_plus_spliced_trims < cutoff_level /*- NMATCHES_SLOP*/) {
      debug8(printf("Final (nmatches %d < %d): Eliminating hit pair %p at %u..%u|%u..%u with nmatches %d+%d (%d+%d to_trims) < cutoff_level %d, sensedirs %d and %d, splice scores %f and %f\n",
		    hitpair->hit5->refalt_nmatches_plus_spliced_trims + hitpair->hit3->refalt_nmatches_plus_spliced_trims,cutoff_level /*- NMATCHES_SLOP*/,
		    hitpair,hitpair->hit5->low_trimmed - hitpair->hit5->chroffset,hitpair->hit5->high_trimmed - hitpair->hit5->chroffset,
		    hitpair->hit3->low_trimmed - hitpair->hit3->chroffset,hitpair->hit3->high_trimmed - hitpair->hit3->chroffset,
		    hitpair->hit5->refalt_nmatches_plus_spliced_trims,hitpair->hit3->refalt_nmatches_plus_spliced_trims,
		    hitpair->hit5->refalt_nmatches_to_trims,hitpair->hit3->refalt_nmatches_to_trims,cutoff_level,
		    hitpair->hit5->sensedir,hitpair->hit3->sensedir,hitpair->hit5->splice_score,hitpair->hit3->splice_score));
      Stage3pair_free(&hitpair);
      *eliminatedp = true;

    } else {
      debug8(printf("Final (nmatches %d >= %d): Keeping hit pair %p at %u..%u|%u..%u (%d+%d substrings) with nmatches %d+%d (%d+%d to_trims) >= cutoff_level %d, sensedirs %d and %d, splice scores %f and %f\n",
		    hitpair->hit5->refalt_nmatches_plus_spliced_trims + hitpair->hit3->refalt_nmatches_plus_spliced_trims,cutoff_level /*- NMATCHES_SLOP*/,
		    hitpair,hitpair->hit5->low_trimmed - hitpair->hit5->chroffset,hitpair->hit5->high_trimmed - hitpair->hit5->chroffset,
		    hitpair->hit3->low_trimmed - hitpair->hit3->chroffset,hitpair->hit3->high_trimmed - hitpair->hit3->chroffset,
		    List_length(hitpair->hit5->substrings_1toN),List_length(hitpair->hit3->substrings_1toN),
		    hitpair->hit5->refalt_nmatches_plus_spliced_trims,hitpair->hit3->refalt_nmatches_plus_spliced_trims,
		    hitpair->hit5->refalt_nmatches_to_trims,hitpair->hit3->refalt_nmatches_to_trims,cutoff_level,
		    hitpair->hit5->sensedir,hitpair->hit3->sensedir,hitpair->hit5->splice_score,hitpair->hit3->splice_score));
      optimal = Hitlist_push(optimal,hitlistpool,(void *) hitpair);
    }
  }
  Hitlist_free(&hitpairlist);
  hitpairlist = optimal;
  optimal = (List_T) NULL;


  /* Prune based on ref_nmatches_plus_spliced_trims (to get the splice ends) */
  max_nmatches = 0;
  for (p = hitpairlist; p != NULL; p = p->rest) {
    hitpair = (Stage3pair_T) p->first;
    if (hitpair->hit5->ref_nmatches_plus_spliced_trims + hitpair->hit3->ref_nmatches_plus_spliced_trims > max_nmatches) {
      max_nmatches = hitpair->hit5->ref_nmatches_plus_spliced_trims + hitpair->hit3->ref_nmatches_plus_spliced_trims;
      assert(max_nmatches <= querylength5 + querylength3);
    }
  }

  /* May not want to be greedy on cutoff level here.  Might want to raise subopt_levels */
  cutoff_level = max_nmatches - subopt_levels;
  debug8(printf("(2) ref cutoff level %d = max_nmatches %d\n",cutoff_level,max_nmatches));

  for (p = hitpairlist; p != NULL; p = p->rest) {
    hitpair = (Stage3pair_T) p->first;

    if (hitpair->hit5->ref_nmatches_plus_spliced_trims + hitpair->hit3->ref_nmatches_plus_spliced_trims < cutoff_level /*- NMATCHES_SLOP*/) {
      debug8(printf("Final (nmatches %d < %d): Eliminating hit pair %p at %u..%u|%u..%u with nmatches %d+%d (%d+%d to_trims) < cutoff_level %d, sensedirs %d and %d, splice scores %f and %f\n",
		    hitpair->hit5->ref_nmatches_plus_spliced_trims + hitpair->hit3->ref_nmatches_plus_spliced_trims,cutoff_level /*- NMATCHES_SLOP*/,
		    hitpair,hitpair->hit5->low_trimmed - hitpair->hit5->chroffset,hitpair->hit5->high_trimmed - hitpair->hit5->chroffset,
		    hitpair->hit3->low_trimmed - hitpair->hit3->chroffset,hitpair->hit3->high_trimmed - hitpair->hit3->chroffset,
		    hitpair->hit5->ref_nmatches_plus_spliced_trims,hitpair->hit3->ref_nmatches_plus_spliced_trims,
		    hitpair->hit5->ref_nmatches_to_trims,hitpair->hit3->ref_nmatches_to_trims,cutoff_level,
		    hitpair->hit5->sensedir,hitpair->hit3->sensedir,hitpair->hit5->splice_score,hitpair->hit3->splice_score));
      Stage3pair_free(&hitpair);
      *eliminatedp = true;

    } else {
      debug8(printf("Final (nmatches %d >= %d): Keeping hit pair %p at %u..%u|%u..%u (%d+%d substrings) with nmatches %d+%d (%d+%d to_trims) >= cutoff_level %d, sensedirs %d and %d, splice scores %f and %f\n",
		    hitpair->hit5->ref_nmatches_plus_spliced_trims + hitpair->hit3->ref_nmatches_plus_spliced_trims,cutoff_level /*- NMATCHES_SLOP*/,
		    hitpair,hitpair->hit5->low_trimmed - hitpair->hit5->chroffset,hitpair->hit5->high_trimmed - hitpair->hit5->chroffset,
		    hitpair->hit3->low_trimmed - hitpair->hit3->chroffset,hitpair->hit3->high_trimmed - hitpair->hit3->chroffset,
		    List_length(hitpair->hit5->substrings_1toN),List_length(hitpair->hit3->substrings_1toN),
		    hitpair->hit5->ref_nmatches_plus_spliced_trims,hitpair->hit3->ref_nmatches_plus_spliced_trims,
		    hitpair->hit5->ref_nmatches_to_trims,hitpair->hit3->ref_nmatches_to_trims,cutoff_level,
		    hitpair->hit5->sensedir,hitpair->hit3->sensedir,hitpair->hit5->splice_score,hitpair->hit3->splice_score));
      optimal = Hitlist_push(optimal,hitlistpool,(void *) hitpair);
    }
  }
  Hitlist_free(&hitpairlist);
  hitpairlist = optimal;
  optimal = (List_T) NULL;


  /* Prune based on refalt_nmatches_to_trims */
  best_nmatches_to_trims = 0;
  for (p = hitpairlist; p != NULL; p = p->rest) {
    hitpair = (Stage3pair_T) p->first;
    if (hitpair->hit5->refalt_nmatches_to_trims + hitpair->hit3->refalt_nmatches_to_trims > best_nmatches_to_trims) {
      best_nmatches_to_trims = hitpair->hit5->refalt_nmatches_to_trims + hitpair->hit3->refalt_nmatches_to_trims;
      assert(best_nmatches_to_trims <= querylength5 + querylength3);
    }
  }

  cutoff_level = best_nmatches_to_trims - subopt_levels;
  debug8(printf("cutoff level %d = best_nmatches_to_trims %d\n",cutoff_level,best_nmatches_to_trims));

  /* Do not allow slop for final */
  for (p = hitpairlist; p != NULL; p = p->rest) {
    hitpair = (Stage3pair_T) p->first;

    if (hitpair->hit5->refalt_nmatches_to_trims + hitpair->hit3->refalt_nmatches_to_trims < cutoff_level /*- NMATCHES_TO_TRIMS_SLOP*/) {
      debug8(printf("Final (nmatches_to_trims %d < %d): Eliminating hit pair %p at %u..%u|%u..%u with nmatches %d+%d (%d+%d to trims) < cutoff_level %d, sensedirs %d and %d, splice scores %f and %f\n",
		    hitpair->hit5->refalt_nmatches_to_trims + hitpair->hit3->refalt_nmatches_to_trims,cutoff_level /*- NMATCHES_TO_TRIMS_SLOP*/,
		    hitpair,hitpair->hit5->low_trimmed - hitpair->hit5->chroffset,hitpair->hit5->high_trimmed - hitpair->hit5->chroffset,
		    hitpair->hit3->low_trimmed - hitpair->hit3->chroffset,hitpair->hit3->high_trimmed - hitpair->hit3->chroffset,
		    hitpair->hit5->refalt_nmatches_plus_spliced_trims,hitpair->hit3->refalt_nmatches_plus_spliced_trims,
		    hitpair->hit5->refalt_nmatches_to_trims,hitpair->hit3->refalt_nmatches_to_trims,cutoff_level,
		    hitpair->hit5->sensedir,hitpair->hit3->sensedir,hitpair->hit5->splice_score,hitpair->hit3->splice_score));
      Stage3pair_free(&hitpair);
      *eliminatedp = true;

    } else {
      debug8(printf("Final (nmatches %d (%d ref) to trims >= %d): Keeping hit pair %p at %u..%u|%u..%u (%d+%d substrings) with nmatches %d+%d (%d+%d to trims) >= cutoff_level %d, sensedirs %d and %d, splice scores %f and %f\n",
		    hitpair->hit5->refalt_nmatches_to_trims + hitpair->hit3->refalt_nmatches_to_trims,
		    hitpair->hit5->ref_nmatches_to_trims + hitpair->hit3->ref_nmatches_to_trims,cutoff_level /*- NMATCHES_TO_TRIMS_SLOP*/,
		    hitpair,hitpair->hit5->low_trimmed - hitpair->hit5->chroffset,hitpair->hit5->high_trimmed - hitpair->hit5->chroffset,
		    hitpair->hit3->low_trimmed - hitpair->hit3->chroffset,hitpair->hit3->high_trimmed - hitpair->hit3->chroffset,
		    List_length(hitpair->hit5->substrings_1toN),List_length(hitpair->hit3->substrings_1toN),
		    hitpair->hit5->refalt_nmatches_plus_spliced_trims,hitpair->hit3->refalt_nmatches_plus_spliced_trims,
		    hitpair->hit5->refalt_nmatches_to_trims,hitpair->hit3->refalt_nmatches_to_trims,cutoff_level,
		    hitpair->hit5->sensedir,hitpair->hit3->sensedir,hitpair->hit5->splice_score,hitpair->hit3->splice_score));
      optimal = Hitlist_push(optimal,hitlistpool,(void *) hitpair);
    }
  }
  Hitlist_free(&hitpairlist);
  if ((hitpairlist = optimal) == NULL) {
    return (List_T) NULL;
  } else {
    optimal = (List_T) NULL;
  }


  /* Eliminate within loci (1): refalt_nmatches_to_trims_only */
  keptp = false;
  hitpairs = (Stage3pair_T *) List_to_array_n(&n,hitpairlist);
  eliminate = (bool *) CALLOC(n,sizeof(bool));
  qsort(hitpairs,n,sizeof(Stage3pair_T),hitpair_position_cmp);
  i = 0;
  while (i < n) {
    j = i+1;
    while (j < n && hitpair_overlap_p(hitpairs[j],hitpairs[i]) == true) {
      j++;
    }
    if (j - i > 1) {
      debug8(printf("Found a group from %d to %d\n",i,j));
      best_nmatches_to_trims = 0;
      for (k = i; k < j; k++) {
	hitpair = hitpairs[k];
	if ((nmatches_to_trims = hitpair->hit5->refalt_nmatches_to_trims + hitpair->hit3->refalt_nmatches_to_trims) > best_nmatches_to_trims) {
	  best_nmatches_to_trims = nmatches_to_trims;
	}
      }
      debug8(printf("best_nmatches_to_trims %d\n",best_nmatches_to_trims));
      
      for (k = i; k < j; k++) {
	hitpair = hitpairs[k];
	/* Do not allow slop for final */
	if ((nmatches_to_trims = hitpair->hit5->refalt_nmatches_to_trims + hitpair->hit3->refalt_nmatches_to_trims) < best_nmatches_to_trims /*- NMATCHES_TO_TRIMS_SLOP*/) {
	  debug8(printf("Within loci pair (nmatches_to_trims %d < %d): Marking hit pair %p for elimination at %u..%u|%u..%u with nsegments %d+%d, pairlength %u, nmatches %d+%d (%d+%d to_trims), sensedirs %d and %d, splice scores %f and %f\n",
			nmatches_to_trims,best_nmatches_to_trims /*- NMATCHES_TO_TRIMS_SLOP*/,
			hitpair,hitpair->hit5->low_trimmed - hitpair->hit5->chroffset,hitpair->hit5->high_trimmed - hitpair->hit5->chroffset,
			hitpair->hit3->low_trimmed - hitpair->hit3->chroffset,hitpair->hit3->high_trimmed - hitpair->hit3->chroffset,
			hitpair->hit5->nsegments,hitpair->hit3->nsegments,hitpair->insertlength,
			hitpair->hit5->refalt_nmatches_plus_spliced_trims,hitpair->hit3->refalt_nmatches_plus_spliced_trims,
			hitpair->hit5->refalt_nmatches_to_trims,hitpair->hit3->refalt_nmatches_to_trims,
			hitpair->hit5->sensedir,hitpair->hit3->sensedir,hitpair->hit5->splice_score,hitpair->hit3->splice_score));
	  eliminate[k] = true;
	} else {
	  keptp = true;
	}
      }
    }

    i = j;
  }
  
  if (keptp == false) {
    optimal = hitpairlist;
  } else {
    for (k = 0; k < n; k++) {
      hitpair = hitpairs[k];
      if (eliminate[k] == true) {
	debug8(printf("Within loci pair: Eliminating hit pair %p at %u..%u|%u..%u with nsegments %d+%d, pairlength %u, nmatches %d+%d (%d+%d to_trims), sensedirs %d and %d, splice scores %f and %f\n",
		      hitpair,hitpair->hit5->low_trimmed - hitpair->hit5->chroffset,hitpair->hit5->high_trimmed - hitpair->hit5->chroffset,
		      hitpair->hit3->low_trimmed - hitpair->hit3->chroffset,hitpair->hit3->high_trimmed - hitpair->hit3->chroffset,
		      hitpair->hit5->nsegments,hitpair->hit3->nsegments,hitpair->insertlength,
		      hitpair->hit5->refalt_nmatches_plus_spliced_trims,hitpair->hit3->refalt_nmatches_plus_spliced_trims,
		      hitpair->hit5->refalt_nmatches_to_trims,hitpair->hit3->refalt_nmatches_to_trims,
		      hitpair->hit5->sensedir,hitpair->hit3->sensedir,hitpair->hit5->splice_score,hitpair->hit3->splice_score));
	Stage3pair_free(&hitpair);
	*eliminatedp = true;
      } else {
	optimal = Hitlist_push(optimal,hitlistpool,(void *) hitpair);
      }
    }
    Hitlist_free(&hitpairlist);
  }
  FREE(hitpairs);
  FREE(eliminate);
  if ((hitpairlist = optimal) == NULL) {
    return (List_T) NULL;
  } else {
    optimal = (List_T) NULL;
  }


  /* Eliminate within loci (2): nsegments and splice score */
  keptp = false;
  hitpairs = (Stage3pair_T *) List_to_array_n(&n,hitpairlist);
  eliminate = (bool *) CALLOC(n,sizeof(bool));
  qsort(hitpairs,n,sizeof(Stage3pair_T),hitpair_position_cmp);
  i = 0;
  while (i < n) {
    j = i+1;
    while (j < n && hitpair_overlap_p(hitpairs[j],hitpairs[i]) == true) {
      j++;
    }
    if (j - i > 1) {
      debug8(printf("Found a group from %d to %d\n",i,j));
      best_nsegments = 0;
      best_insertlength_score = 99;
      max_splice_score = 0.0;
      for (k = i; k < j; k++) {
	hitpair = hitpairs[k];
	if ((nsegments = hitpair->hit5->nsegments + hitpair->hit3->nsegments) > best_nsegments) {
	  best_nsegments = nsegments;
	  best_insertlength_score = calc_insertlength_score(hitpair->insertlength);
	  max_splice_score = hitpair->hit5->splice_score + hitpair->hit3->splice_score;

	} else if (nsegments == best_nsegments) {
	  if ((insertlength_score = calc_insertlength_score(hitpair->insertlength)) < best_insertlength_score) {
	    best_insertlength_score = insertlength_score;
	    max_splice_score = hitpair->hit5->splice_score + hitpair->hit3->splice_score;

	  } else if (insertlength_score == best_insertlength_score) {
	    if ((splice_score = hitpair->hit5->splice_score + hitpair->hit3->splice_score) > max_splice_score) {
	      max_splice_score = splice_score;
	    }
	  }
	}
      }
      debug8(printf("best_nsegments %d, best_insertlength_score %d, max_splice_score %f\n",
		    best_nsegments,best_insertlength_score,max_splice_score));
      
      for (k = i; k < j; k++) {
	hitpair = hitpairs[k];
	if ((nsegments = hitpair->hit5->nsegments + hitpair->hit3->nsegments) < best_nsegments) {
	  debug8(printf("Within loci pair (nsegments %d < %d): Marking hit pair %p for elimination at %u..%u|%u..%u with nsegments %d+%d, pairlength %u, nmatches %d+%d (%d+%d to_trims), sensedirs %d and %d, splice scores %f and %f\n",
			nsegments,best_nsegments,
			hitpair,hitpair->hit5->low_trimmed - hitpair->hit5->chroffset,hitpair->hit5->high_trimmed - hitpair->hit5->chroffset,
			hitpair->hit3->low_trimmed - hitpair->hit3->chroffset,hitpair->hit3->high_trimmed - hitpair->hit3->chroffset,
			hitpair->hit5->nsegments,hitpair->hit3->nsegments,hitpair->insertlength,
			hitpair->hit5->refalt_nmatches_plus_spliced_trims,hitpair->hit3->refalt_nmatches_plus_spliced_trims,
			hitpair->hit5->refalt_nmatches_to_trims,hitpair->hit3->refalt_nmatches_to_trims,
			hitpair->hit5->sensedir,hitpair->hit3->sensedir,hitpair->hit5->splice_score,hitpair->hit3->splice_score));
	  eliminate[k] = true;

	} else if (calc_insertlength_score(hitpair->insertlength) > best_insertlength_score) {
	  debug8(printf("Within loci pair (insertlength score %d > %d): Marking hit pair %p for elimination at %u..%u|%u..%u with nsegments %d+%d, pairlength %u, nmatches %d+%d (%d+%d to_trims), sensedirs %d and %d, splice scores %f and %f\n",
			calc_insertlength_score(hitpair->insertlength),best_insertlength_score,
			hitpair,hitpair->hit5->low_trimmed - hitpair->hit5->chroffset,hitpair->hit5->high_trimmed - hitpair->hit5->chroffset,
			hitpair->hit3->low_trimmed - hitpair->hit3->chroffset,hitpair->hit3->high_trimmed - hitpair->hit3->chroffset,
			hitpair->hit5->nsegments,hitpair->hit3->nsegments,hitpair->insertlength,
			hitpair->hit5->refalt_nmatches_plus_spliced_trims,hitpair->hit3->refalt_nmatches_plus_spliced_trims,hitpair->hit5->refalt_nmatches_to_trims,hitpair->hit3->refalt_nmatches_to_trims,
			hitpair->hit5->sensedir,hitpair->hit3->sensedir,hitpair->hit5->splice_score,hitpair->hit3->splice_score));
	  eliminate[k] = true;

	} else if (hitpair->hit5->splice_score + hitpair->hit3->splice_score < max_splice_score - SPLICE_SCORE_SLOP) {
	  debug8(printf("Within loci pair (splice_score w/slop %f < %f): Marking hit pair %p for elimination at %u..%u|%u..%u with nsegments %d+%d, pairlength %u, nmatches %d+%d (%d+%d to_trims), sensedirs %d and %d, splice scores %f and %f\n",
			hitpair->hit5->splice_score + hitpair->hit3->splice_score,max_splice_score,
			hitpair,hitpair->hit5->low_trimmed - hitpair->hit5->chroffset,hitpair->hit5->high_trimmed - hitpair->hit5->chroffset,
			hitpair->hit3->low_trimmed - hitpair->hit3->chroffset,hitpair->hit3->high_trimmed - hitpair->hit3->chroffset,
			hitpair->hit5->nsegments,hitpair->hit3->nsegments,hitpair->insertlength,
			hitpair->hit5->refalt_nmatches_plus_spliced_trims,hitpair->hit3->refalt_nmatches_plus_spliced_trims,hitpair->hit5->refalt_nmatches_to_trims,hitpair->hit3->refalt_nmatches_to_trims,
			hitpair->hit5->sensedir,hitpair->hit3->sensedir,hitpair->hit5->splice_score,hitpair->hit3->splice_score));
	  eliminate[k] = true;

	} else {
	  keptp = true;
	}
      }
    }

    i = j;
  }
  
  if (keptp == false) {
    optimal = hitpairlist;
  } else {
    for (k = 0; k < n; k++) {
      hitpair = hitpairs[k];
      if (eliminate[k] == true) {
	debug8(printf("Within loci pair: Eliminating hit pair %p at %u..%u|%u..%u with nsegments %d+%d, pairlength %u, nmatches %d+%d (%d+%d to_trims), sensedirs %d and %d, splice scores %f and %f\n",
		      hitpair,hitpair->hit5->low_trimmed - hitpair->hit5->chroffset,hitpair->hit5->high_trimmed - hitpair->hit5->chroffset,
		      hitpair->hit3->low_trimmed - hitpair->hit3->chroffset,hitpair->hit3->high_trimmed - hitpair->hit3->chroffset,
		      hitpair->hit5->nsegments,hitpair->hit3->nsegments,hitpair->insertlength,
		      hitpair->hit5->refalt_nmatches_plus_spliced_trims,hitpair->hit3->refalt_nmatches_plus_spliced_trims,hitpair->hit5->refalt_nmatches_to_trims,hitpair->hit3->refalt_nmatches_to_trims,
		      hitpair->hit5->sensedir,hitpair->hit3->sensedir,hitpair->hit5->splice_score,hitpair->hit3->splice_score));
	Stage3pair_free(&hitpair);
	*eliminatedp = true;
      } else {
	optimal = Hitlist_push(optimal,hitlistpool,(void *) hitpair);
      }
    }
    Hitlist_free(&hitpairlist);
  }
  FREE(hitpairs);
  FREE(eliminate);
  hitpairlist = optimal;
  /* optimal = (List_T) NULL; */


#if 0
  /* Filter on trim amount */
  hitpairlist = optimal;
  optimal = (List_T) NULL;
  min_trim = querylength5 + querylength3;
  for (p = hitpairlist; p != NULL; p = p->rest) {
    hitpair = (Stage3pair_T) p->first;

    if (hitpair->hit5->querystart_trimmed_splicep == true) {
      /* Skip */
      trim5_left = 0;
    } else {
      trim5_left = hitpair->hit5->querystart_trimmed;
    }
    if (hitpair->hit5->queryend_trimmed_splicep == true) {
      /* Skip */
      trim5_right = 0;
    } else {
      trim5_right = hitpair->hit5->querylength - hitpair->hit5->queryend_trimmed;
    }

    if (hitpair->hit3->querystart_trimmed_splicep == true) {
      /* Skip */
      trim3_left = 0;
    } else {
      trim3_left = hitpair->hit3->querystart_trimmed;
    }
    if (hitpair->hit3->queryend_trimmed_splicep == true) {
      /* Skip */
      trim3_right = 0;
    } else {
      trim3_right = hitpair->hit3->querylength - hitpair->hit3->queryend_trimmed;
    }

    if (trim5_left + trim5_right + trim3_left + trim3_right < min_trim) {
      min_trim = trim5_left + trim5_right + trim3_left + trim3_right;
    }
  }

  for (p = hitpairlist; p != NULL; p = p->rest) {
    hitpair = (Stage3pair_T) p->first;

    if (hitpair->hit5->querystart_trimmed_splicep == true) {
      /* Skip */
      trim5_left = 0;
    } else {
      trim5_left = hitpair->hit5->querystart_trimmed;
    }
    if (hitpair->hit5->queryend_trimmed_splicep == true) {
      /* Skip */
      trim5_right = 0;
    } else {
      trim5_right = hitpair->hit5->querylength - hitpair->hit5->queryend_trimmed;
    }

    if (hitpair->hit3->querystart_trimmed_splicep == true) {
      /* Skip */
      trim3_left = 0;
    } else {
      trim3_left = hitpair->hit3->querystart_trimmed;
    }
    if (hitpair->hit3->queryend_trimmed_splicep == true) {
      /* Skip */
      trim3_right = 0;
    } else {
      trim3_right = hitpair->hit3->querylength - hitpair->hit3->queryend_trimmed;
    }

    if (trim5_left + trim5_right + trim3_left + trim3_right > min_trim) {
      debug8(printf("Final (trim): Eliminating hit pair %p at %u..%u|%u..%u for trim %d+%d+%d+%d\n",
		    hitpair,hitpair->hit5->low_trimmed - hitpair->hit5->chroffset,hitpair->hit5->high_trimmed - hitpair->hit5->chroffset,
		    hitpair->hit3->low_trimmed - hitpair->hit3->chroffset,hitpair->hit3->high_trimmed - hitpair->hit3->chroffset,
		    trim5_left,trim5_right,trim3_left,trim3_right));
      Stage3pair_free(&hitpair);
      *eliminatedp = true;

    } else {
      debug8(printf("Final (trim): Keeping hit pair %p at %u..%u|%u..%u (%d+%d substrings) for trim %d+%d+%d+%d\n",
		    hitpair,hitpair->hit5->low_trimmed - hitpair->hit5->chroffset,hitpair->hit5->high_trimmed - hitpair->hit5->chroffset,
		    hitpair->hit3->low_trimmed - hitpair->hit3->chroffset,hitpair->hit3->high_trimmed - hitpair->hit3->chroffset,
		    List_length(hitpair->hit5->substrings_1toN),List_length(hitpair->hit3->substrings_1toN),
		    trim5_left,trim5_right,trim3_left,trim3_right));
      optimal = Hitlist_push(optimal,hitlistpool,(void *) hitpair);
    }
  }
  Hitlist_free(&hitpairlist);
  hitpairlist = optimal;
  optimal = (List_T) NULL;
#endif


#if 0
  /* Not good, especially for homologous chromosomes.  Use insert_length only within loci, not between */
  /* Then find smallest insert length and outerlength across loci */
  best_insertlength = (Chrpos_T) -1;
  for (p = hitpairlist; p != NULL; p = p->rest) {
    hitpair = (Stage3pair_T) p->first;
    if (hitpair->insertlength < best_insertlength) {
      best_insertlength = hitpair->insertlength;
    }
  }

  for (p = hitpairlist; p != NULL; p = p->rest) {
    hitpair = (Stage3pair_T) p->first;

    if (hitpair->insertlength > best_insertlength /*+ INSERTLENGTH_SLOP*/) {  /* No slop for final */
      debug8(printf("Final (insertlength %u > %u): Eliminating hit pair %p at %u..%u|%u..%u with nmatches %d+%d (%d+%d to_trims) < cutoff_level %d, sensedirs %d and %d, splice scores %f and %f\n",
		    hitpair->insertlength,best_insertlength,
		    hitpair,hitpair->hit5->low_trimmed - hitpair->hit5->chroffset,hitpair->hit5->high_trimmed - hitpair->hit5->chroffset,
		    hitpair->hit3->low_trimmed - hitpair->hit3->chroffset,hitpair->hit3->high_trimmed - hitpair->hit3->chroffset,
		    hitpair->hit5->refalt_nmatches_plus_spliced_trims,hitpair->hit3->refalt_nmatches_plus_spliced_trims,
		    hitpair->hit5->refalt_nmatches_to_trims,hitpair->hit3->refalt_nmatches_to_trims,cutoff_level,
		    hitpair->hit5->sensedir,hitpair->hit3->sensedir,hitpair->hit5->splice_score,hitpair->hit3->splice_score));
      Stage3pair_free(&hitpair);
      *eliminatedp = true;

    } else {
      debug8(printf("Final (insertlength %u, outerlength %u): Keeping hit pair %p at %u..%u|%u..%u (%d+%d substrings) with nmatches %d+%d (%d+%d to_trims) >= cutoff_level %d, sensedirs %d and %d, splice scores %f and %f\n",
		    hitpair->insertlength,hitpair->outerlength,
		    hitpair,hitpair->hit5->low_trimmed - hitpair->hit5->chroffset,hitpair->hit5->high_trimmed - hitpair->hit5->chroffset,
		    hitpair->hit3->low_trimmed - hitpair->hit3->chroffset,hitpair->hit3->high_trimmed - hitpair->hit3->chroffset,
		    List_length(hitpair->hit5->substrings_1toN),List_length(hitpair->hit3->substrings_1toN),
		    hitpair->hit5->refalt_nmatches_plus_spliced_trims,hitpair->hit3->refalt_nmatches_plus_spliced_trims,
		    hitpair->hit5->refalt_nmatches_to_trims,hitpair->hit3->refalt_nmatches_to_trims,cutoff_level,
		    hitpair->hit5->sensedir,hitpair->hit3->sensedir,hitpair->hit5->splice_score,hitpair->hit3->splice_score));
      optimal = Hitlist_push(optimal,hitlistpool,(void *) hitpair);
    }
  }
  Hitlist_free(&hitpairlist);
  hitpairlist = optimal;
  optimal = (List_T) NULL;
#endif

#if 0
  /* Not good, especially for homologous chromosomes.  Use outerlength only within loci, not between */
  /* Finally find smallest outerlength across loci */
  best_outerlength = (Chrpos_T) -1;
  for (p = hitpairlist; p != NULL; p = p->rest) {
    hitpair = (Stage3pair_T) p->first;
    if (hitpair->outerlength < best_outerlength) {
      best_outerlength = hitpair->outerlength;
    }
  }

  for (p = hitpairlist; p != NULL; p = p->rest) {
    hitpair = (Stage3pair_T) p->first;

    if (hitpair->outerlength > best_outerlength /*+ OUTERLENGTH_SLOP*/) {
      debug8(printf("Final (outerlength %u > %u): Eliminating hit pair %p at %u..%u|%u..%u with nmatches %d+%d (%d+%d to trims) < cutoff_level %d, sensedirs %d and %d, splice scores %f and %f\n",
		    hitpair->outerlength,best_outerlength /*+ OUTERLENGTH_SLOP*/,
		    hitpair,hitpair->hit5->low_trimmed - hitpair->hit5->chroffset,hitpair->hit5->high_trimmed - hitpair->hit5->chroffset,
		    hitpair->hit3->low_trimmed - hitpair->hit3->chroffset,hitpair->hit3->high_trimmed - hitpair->hit3->chroffset,
		    hitpair->hit5->refalt_nmatches_plus_spliced_trims,hitpair->hit3->refalt_nmatches_plus_spliced_trims,
		    hitpair->hit5->refalt_nmatches_to_trims,hitpair->hit3->refalt_nmatches_to_trims,cutoff_level,
		    hitpair->hit5->sensedir,hitpair->hit3->sensedir,hitpair->hit5->splice_score,hitpair->hit3->splice_score));
      Stage3pair_free(&hitpair);
      *eliminatedp = true;

    } else {
      debug8(printf("Final (outerlength %u): Keeping hit pair %p at %u..%u|%u..%u (%d+%d substrings) with nmatches %d+%d (%d+%d to trims) >= cutoff_level %d, sensedirs %d and %d, splice scores %f and %f\n",
		    hitpair->outerlength,
		    hitpair,hitpair->hit5->low_trimmed - hitpair->hit5->chroffset,hitpair->hit5->high_trimmed - hitpair->hit5->chroffset,
		    hitpair->hit3->low_trimmed - hitpair->hit3->chroffset,hitpair->hit3->high_trimmed - hitpair->hit3->chroffset,
		    List_length(hitpair->hit5->substrings_1toN),List_length(hitpair->hit3->substrings_1toN),
		    hitpair->hit5->refalt_nmatches_plus_spliced_trims,hitpair->hit3->refalt_nmatches_plus_spliced_trims,
		    hitpair->hit5->refalt_nmatches_to_trims,hitpair->hit3->refalt_nmatches_to_trims,cutoff_level,
		    hitpair->hit5->sensedir,hitpair->hit3->sensedir,hitpair->hit5->splice_score,hitpair->hit3->splice_score));
      optimal = Hitlist_push(optimal,hitlistpool,(void *) hitpair);
    }
  }
  Hitlist_free(&hitpairlist);
  hitpairlist = optimal;
  /* optimal = (List_T) NULL; */
#endif

  debug8(printf("Exiting Stage3pair_optimal_score_final with %d hits\n",List_length(hitpairlist)));
  return hitpairlist;
}
#endif


static List_T
Stage3pair_optimal_score_final (bool *eliminatedp, List_T hitpairlist, Hitlistpool_T hitlistpool) {
  List_T optimal = NULL, p;
  Stage3pair_T hitpair;
  int n;
  int max_adj_nmatches, score;
  /* int best_nmatches_to_trims; */
  int cutoff_level;
  /* Chrpos_T best_outerlength, best_insertlength; */
  /* int trim5_left, trim5_right, trim3_left, trim3_right, min_trim; */

  /* Relies on Path_solve_from_diagonals to maximize the number of segments at each locus */

  *eliminatedp = false;
  n = List_length(hitpairlist);
  debug8(printf("\nEntered Stage3pair_optimal_score_final with %d hitpairs\n",n));
  
  if (n <= 1) {
    return hitpairlist;
  }

#ifdef DEBUG8
  for (p = hitpairlist; p != NULL; p = p->rest) {
    hitpair = (Stage3pair_T) p->first;
    printf("%p %p %u..%u|%u..%u methods %s and %s, nsegments %d+%d, nmatches %d+%d (%d+%d to trims), scores %d+%d, pairlength %u, outerlength %u, sensedirs %d and %d, splice scores %f and %f\n",
	   hitpair->hit5,hitpair->hit3,
	   hitpair->hit5->low_trimmed - hitpair->hit5->chroffset,hitpair->hit5->high_trimmed - hitpair->hit5->chroffset,
	   hitpair->hit3->low_trimmed - hitpair->hit3->chroffset,hitpair->hit3->high_trimmed - hitpair->hit3->chroffset,
	   Method_string(hitpair->hit5->method),Method_string(hitpair->hit3->method),
	   hitpair->hit5->nsegments,hitpair->hit3->nsegments,
	   hitpair->hit5->refalt_nmatches_plus_spliced_trims,hitpair->hit3->refalt_nmatches_plus_spliced_trims,
	   hitpair->hit5->refalt_nmatches_to_trims,hitpair->hit3->refalt_nmatches_to_trims,
	   hitpair->hit5->refalt_score_overall,hitpair->hit3->refalt_score_overall,
	   hitpair->insertlength,hitpair->outerlength,
	   hitpair->hit5->sensedir,hitpair->hit3->sensedir,hitpair->hit5->splice_score,hitpair->hit3->splice_score);
  }
  printf("\n");
#endif

#if 0
  /* Can lead to incorrect answers */
  /* (1) Prune based on insertlength */
  debug8(printf("(1) Finding smallest insertlength with slop across loci"));
  optimal = (List_T) NULL;

  best_insertlength = (Chrpos_T) -1;
  for (p = hitpairlist; p != NULL; p = p->rest) {
    hitpair = (Stage3pair_T) p->first;
    if (hitpair->insertlength < best_insertlength) {
      best_insertlength = hitpair->insertlength;
    }
  }
  debug8(printf(" => %u\n",best_insertlength));

  for (p = hitpairlist; p != NULL; p = p->rest) {
    hitpair = (Stage3pair_T) p->first;

    if (hitpair->insertlength > best_insertlength + INSERTLENGTH_SLOP) {
      debug8(printf("Final (nmatches_to_trims %d < %d): Eliminating hit pair %p at %u..%u|%u..%u with insertlength %u > %u + %u\n",
		    hitpair->hit5->ref_nmatches_to_trims + hitpair->hit3->ref_nmatches_to_trims,cutoff_level /*- NMATCHES_TO_TRIMS_SLOP*/,
		    hitpair,hitpair->hit5->low_trimmed - hitpair->hit5->chroffset,hitpair->hit5->high_trimmed - hitpair->hit5->chroffset,
		    hitpair->hit3->low_trimmed - hitpair->hit3->chroffset,hitpair->hit3->high_trimmed - hitpair->hit3->chroffset,
		    hitpair->insertlength,best_insertlength,INSERTLENGTH_SLOP));
      Stage3pair_free(&hitpair);
      *eliminatedp = true;

    } else {
      debug8(printf("Final (nmatches_to_trims %d < %d): Keeping hit pair %p at %u..%u|%u..%u with insertlength %u <= %u + %u\n",
		    hitpair->hit5->ref_nmatches_to_trims + hitpair->hit3->ref_nmatches_to_trims,cutoff_level /*- NMATCHES_TO_TRIMS_SLOP*/,
		    hitpair,hitpair->hit5->low_trimmed - hitpair->hit5->chroffset,hitpair->hit5->high_trimmed - hitpair->hit5->chroffset,
		    hitpair->hit3->low_trimmed - hitpair->hit3->chroffset,hitpair->hit3->high_trimmed - hitpair->hit3->chroffset,
		    hitpair->insertlength,best_insertlength,INSERTLENGTH_SLOP));
      optimal = Hitlist_push(optimal,hitlistpool,(void *) hitpair);
    }
  }
  Hitlist_free(&hitpairlist);
  hitpairlist = optimal;
#endif


  /* (1) Prune based on nmatches adjusted by score to get a tradeoff between matches and parsimony */
  /* Previously subtracted refalt_score_overall, but better not to */
  debug8(printf("(1) Finding nmatches adjusted by score across loci"));
  optimal = (List_T) NULL;

  max_adj_nmatches = 0;
  for (p = hitpairlist; p != NULL; p = p->rest) {
    hitpair = (Stage3pair_T) p->first;
    if ((score = hitpair->hit5->refalt_nmatches_plus_spliced_trims + hitpair->hit3->refalt_nmatches_plus_spliced_trims)
	> max_adj_nmatches) {
      max_adj_nmatches = score;
    }
  }

  /* May not want to be greedy on cutoff level here.  Might want to raise subopt_levels */
  cutoff_level = max_adj_nmatches - subopt_levels;
  debug8(printf(" => refalt cutoff level %d = max_adj_nmatches %d - subopt_levels %d\n",
		cutoff_level,max_adj_nmatches,subopt_levels));

  for (p = hitpairlist; p != NULL; p = p->rest) {
    hitpair = (Stage3pair_T) p->first;

    if (hitpair->hit5->refalt_nmatches_plus_spliced_trims + hitpair->hit3->refalt_nmatches_plus_spliced_trims
	< cutoff_level /*- NMATCHES_SLOP*/) {
      debug8(printf("Final (adj nmatches %d < %d): Eliminating hit pair %p at %u..%u|%u..%u with nmatches %d+%d (%d+%d to_trims) < cutoff_level %d, sensedirs %d and %d, splice scores %f and %f\n",
		    hitpair->hit5->refalt_nmatches_plus_spliced_trims + hitpair->hit3->refalt_nmatches_plus_spliced_trims,
		    cutoff_level /*- NMATCHES_SLOP*/,
		    hitpair,hitpair->hit5->low_trimmed - hitpair->hit5->chroffset,hitpair->hit5->high_trimmed - hitpair->hit5->chroffset,
		    hitpair->hit3->low_trimmed - hitpair->hit3->chroffset,hitpair->hit3->high_trimmed - hitpair->hit3->chroffset,
		    hitpair->hit5->refalt_nmatches_plus_spliced_trims,hitpair->hit3->refalt_nmatches_plus_spliced_trims,
		    hitpair->hit5->refalt_nmatches_to_trims,hitpair->hit3->refalt_nmatches_to_trims,cutoff_level,
		    hitpair->hit5->sensedir,hitpair->hit3->sensedir,hitpair->hit5->splice_score,hitpair->hit3->splice_score));
      Stage3pair_free(&hitpair);
      *eliminatedp = true;

    } else {
      debug8(printf("Final (adj nmatches %d >= %d): Keeping hit pair %p at %u..%u|%u..%u (%d+%d substrings) with nmatches %d+%d (%d+%d to_trims) >= cutoff_level %d, sensedirs %d and %d, splice scores %f and %f\n",
		    hitpair->hit5->refalt_nmatches_plus_spliced_trims + hitpair->hit3->refalt_nmatches_plus_spliced_trims,
		    cutoff_level /*- NMATCHES_SLOP*/,
		    hitpair,hitpair->hit5->low_trimmed - hitpair->hit5->chroffset,hitpair->hit5->high_trimmed - hitpair->hit5->chroffset,
		    hitpair->hit3->low_trimmed - hitpair->hit3->chroffset,hitpair->hit3->high_trimmed - hitpair->hit3->chroffset,
		    List_length(hitpair->hit5->substrings_1toN),List_length(hitpair->hit3->substrings_1toN),
		    hitpair->hit5->refalt_nmatches_plus_spliced_trims,hitpair->hit3->refalt_nmatches_plus_spliced_trims,
		    hitpair->hit5->refalt_nmatches_to_trims,hitpair->hit3->refalt_nmatches_to_trims,cutoff_level,
		    hitpair->hit5->sensedir,hitpair->hit3->sensedir,hitpair->hit5->splice_score,hitpair->hit3->splice_score));
      optimal = Hitlist_push(optimal,hitlistpool,(void *) hitpair);
    }
  }
  Hitlist_free(&hitpairlist);
  hitpairlist = optimal;

#if 0
  /* (2) Prune based on ref_nmatches_to_trims */
  optimal = (List_T) NULL;

  best_nmatches_to_trims = 0;
  for (p = hitpairlist; p != NULL; p = p->rest) {
    hitpair = (Stage3pair_T) p->first;
    if (hitpair->hit5->ref_nmatches_to_trims + hitpair->hit3->ref_nmatches_to_trims > best_nmatches_to_trims) {
      best_nmatches_to_trims = hitpair->hit5->ref_nmatches_to_trims + hitpair->hit3->ref_nmatches_to_trims;
      assert(best_nmatches_to_trims <= querylength5 + querylength3);
    }
  }

  cutoff_level = best_nmatches_to_trims - subopt_levels;
  debug8(printf("cutoff level %d = best_nmatches_to_trims %d\n",cutoff_level,best_nmatches_to_trims));

  /* Do not allow slop for final */
  for (p = hitpairlist; p != NULL; p = p->rest) {
    hitpair = (Stage3pair_T) p->first;

    if (hitpair->hit5->ref_nmatches_to_trims + hitpair->hit3->ref_nmatches_to_trims < cutoff_level /*- NMATCHES_TO_TRIMS_SLOP*/) {
      debug8(printf("Final (nmatches_to_trims %d < %d): Eliminating hit pair %p at %u..%u|%u..%u with nmatches %d+%d (%d+%d to trims) < cutoff_level %d, sensedirs %d and %d, splice scores %f and %f\n",
		    hitpair->hit5->ref_nmatches_to_trims + hitpair->hit3->ref_nmatches_to_trims,cutoff_level /*- NMATCHES_TO_TRIMS_SLOP*/,
		    hitpair,hitpair->hit5->low_trimmed - hitpair->hit5->chroffset,hitpair->hit5->high_trimmed - hitpair->hit5->chroffset,
		    hitpair->hit3->low_trimmed - hitpair->hit3->chroffset,hitpair->hit3->high_trimmed - hitpair->hit3->chroffset,
		    hitpair->hit5->ref_nmatches_plus_spliced_trims,hitpair->hit3->ref_nmatches_plus_spliced_trims,
		    hitpair->hit5->ref_nmatches_to_trims,hitpair->hit3->ref_nmatches_to_trims,cutoff_level,
		    hitpair->hit5->sensedir,hitpair->hit3->sensedir,hitpair->hit5->splice_score,hitpair->hit3->splice_score));
      Stage3pair_free(&hitpair);
      *eliminatedp = true;

    } else {
      debug8(printf("Final (nmatches_to_trims %d >= %d): Keeping hit pair %p at %u..%u|%u..%u (%d+%d substrings) with nmatches %d+%d (%d+%d to trims) >= cutoff_level %d, sensedirs %d and %d, splice scores %f and %f\n",
		    hitpair->hit5->ref_nmatches_to_trims + hitpair->hit3->ref_nmatches_to_trims,cutoff_level /*- NMATCHES_TO_TRIMS_SLOP*/,
		    hitpair,hitpair->hit5->low_trimmed - hitpair->hit5->chroffset,hitpair->hit5->high_trimmed - hitpair->hit5->chroffset,
		    hitpair->hit3->low_trimmed - hitpair->hit3->chroffset,hitpair->hit3->high_trimmed - hitpair->hit3->chroffset,
		    List_length(hitpair->hit5->substrings_1toN),List_length(hitpair->hit3->substrings_1toN),
		    hitpair->hit5->ref_nmatches_plus_spliced_trims,hitpair->hit3->ref_nmatches_plus_spliced_trims,
		    hitpair->hit5->ref_nmatches_to_trims,hitpair->hit3->ref_nmatches_to_trims,cutoff_level,
		    hitpair->hit5->sensedir,hitpair->hit3->sensedir,hitpair->hit5->splice_score,hitpair->hit3->splice_score));
      optimal = Hitlist_push(optimal,hitlistpool,(void *) hitpair);
    }
  }
  Hitlist_free(&hitpairlist);
  hitpairlist = optimal;
#endif

#if 0
  /* (3) Prune based on outerlength */
  debug8(printf("(3) Finding smallest outerlength across loci"));
  optimal = (List_T) NULL;

  best_outerlength = (Chrpos_T) -1;
  for (p = hitpairlist; p != NULL; p = p->rest) {
    hitpair = (Stage3pair_T) p->first;
    if (hitpair->outerlength < best_outerlength) {
      best_outerlength = hitpair->outerlength;
    }
  }
  debug8(printf(" => %u\n",best_outerlength));

  for (p = hitpairlist; p != NULL; p = p->rest) {
    hitpair = (Stage3pair_T) p->first;

    if (hitpair->outerlength > best_outerlength + OUTERLENGTH_SLOP) {
      debug8(printf("Final (nmatches_to_trims %d < %d): Eliminating hit pair %p at %u..%u|%u..%u with outerlength %u > %u + %u\n",
		    hitpair->hit5->ref_nmatches_to_trims + hitpair->hit3->ref_nmatches_to_trims,cutoff_level /*- NMATCHES_TO_TRIMS_SLOP*/,
		    hitpair,hitpair->hit5->low_trimmed - hitpair->hit5->chroffset,hitpair->hit5->high_trimmed - hitpair->hit5->chroffset,
		    hitpair->hit3->low_trimmed - hitpair->hit3->chroffset,hitpair->hit3->high_trimmed - hitpair->hit3->chroffset,
		    hitpair->outerlength,best_outerlength,OUTERLENGTH_SLOP));
      Stage3pair_free(&hitpair);
      *eliminatedp = true;

    } else {
      debug8(printf("Final (nmatches_to_trims %d < %d): Keeping hit pair %p at %u..%u|%u..%u with outerlength %u <= %u + %u\n",
		    hitpair->hit5->ref_nmatches_to_trims + hitpair->hit3->ref_nmatches_to_trims,cutoff_level /*- NMATCHES_TO_TRIMS_SLOP*/,
		    hitpair,hitpair->hit5->low_trimmed - hitpair->hit5->chroffset,hitpair->hit5->high_trimmed - hitpair->hit5->chroffset,
		    hitpair->hit3->low_trimmed - hitpair->hit3->chroffset,hitpair->hit3->high_trimmed - hitpair->hit3->chroffset,
		    hitpair->outerlength,best_outerlength,OUTERLENGTH_SLOP));
      optimal = Hitlist_push(optimal,hitlistpool,(void *) hitpair);
    }
  }
  Hitlist_free(&hitpairlist);
  hitpairlist = optimal;
#endif



  debug8(printf("Exiting Stage3pair_optimal_score_final with %d hits\n",List_length(hitpairlist)));
  return hitpairlist;
}



List_T
Stage3pair_optimal_score (List_T hitpairlist, Hitlistpool_T hitlistpool,
			  int querylength5, int querylength3, bool finalp) {
  List_T optimal;
  bool eliminatedp;

  if (finalp == false) {
    optimal = Stage3pair_optimal_score_prefinal(&eliminatedp,hitpairlist,hitlistpool,
						querylength5,querylength3);
    while (eliminatedp == true) {
      optimal = Stage3pair_optimal_score_prefinal(&eliminatedp,optimal,hitlistpool,
						  querylength5,querylength3);
    }

  } else {
    optimal = Stage3pair_optimal_score_final(&eliminatedp,hitpairlist,hitlistpool);
    while (eliminatedp == true) {
      optimal = Stage3pair_optimal_score_final(&eliminatedp,optimal,hitlistpool);
    }
  }

  return optimal;
}


#if 0
/* Called when computing GMAP alignment in stage1hr.c */
bool
Stage3pair_sense_consistent_p (List_T hitpairlist) {
  Stage3pair_T hitpair;
  T hit5, hit3;
  List_T p;

  for (p = hitpairlist; p != NULL; p = List_next(p)) {
    hitpair = (Stage3pair_T) List_head(p);
    hit5 = hitpair->hit5;
    hit3 = hitpair->hit3;
    if (hit5->sensedir_for_concordance == hit3->sensedir_for_concordance) {
      return true;
    }
  }
  return false;
}
#endif


/* Want to unalias plus and alias minus */
List_T
Stage3end_linearize_5 (List_T hitlist) {
  T hit;
  List_T p;
#ifdef DEBUG12
  Chrpos_T chrlength;
#endif

  for (p = hitlist; p != NULL; p = List_next(p)) {
    hit = (T) List_head(p);
    debug12(chrlength = hit->chrlength);
    debug12(printf("Looking at 5' end %u..%u against chrlength %u\n",
		   hit->genomicstart - hit->chroffset,hit->genomicend - hit->chroffset,chrlength));

    if (hit->circularalias == 0) {
      /* Skip */

    } else if (hit->circularalias == +1) {
      if (hit->plusp == true) {
	unalias_circular(hit);
      }

    } else if (hit->circularalias == -1) {
      if (hit->plusp == false) {
	alias_circular(hit);
      }
    }
  }

  return hitlist;
}


/* Want to alias plus and unalias minus */
List_T
Stage3end_linearize_3 (List_T hitlist) {
  T hit;
  List_T p;
#ifdef DEBUG12
  Chrpos_T chrlength;
#endif

  for (p = hitlist; p != NULL; p = List_next(p)) {
    hit = (T) List_head(p);
    debug12(chrlength = hit->chrlength);
    debug12(printf("Looking at 3' end %u..%u against chrlength %u\n",
		   hit->genomicstart - hit->chroffset,hit->genomicend - hit->chroffset,chrlength));

    if (hit->circularalias == 0) {
      /* Skip */

    } else if (hit->circularalias == -1) {
      if (hit->plusp == true) {
	alias_circular(hit);
      }

    } else if (hit->circularalias == +1) {
      if (hit->plusp == false) {
	unalias_circular(hit);
      }
    }
  }

  return hitlist;
}



List_T
Stage3pair_remove_circular_alias (List_T hitpairlist, Hitlistpool_T hitlistpool) {
  List_T newlist = NULL, p;
  Stage3pair_T hitpair;
  /* Univcoord_T low_trimmed; */

  debug12(printf("Stage3pair_remove_circular_alias called with %d hitpairs\n",
		 List_length(hitpairlist)));
  for (p = hitpairlist; p != NULL; p = p->rest) {
    hitpair = (Stage3pair_T) p->first;
    debug12(printf("Hitpair has circularalias %d and %d\n",
		   hitpair->hit5->circularalias,hitpair->hit3->circularalias));

#if 0
    /* Not sure if this is necessary */
    if (hitpair->hit5->circularalias == +1 && hitpair->hit3->circularalias == +1) {
      /* First, try to salvage alias +1 */
      unalias_circular(hitpair->hit5);
      unalias_circular(hitpair->hit3);
    }
#endif

#if 0
    if (hitpair->hit5->plusp == true) {
      low_trimmed = hitpair->hit5->low_trimmed;
    } else {
      low_trimmed = hitpair->hit3->low_trimmed;
    }
#endif

    if (hitpair->low_chrbound >= hitpair->hit5->chroffset + hitpair->hit5->chrlength) {
      /* Both ends in circular alias */
      debug12(printf("Both ends in circular alias\n"));
      Stage3pair_free(&hitpair);

    } else {
      newlist = Hitlist_push(newlist,hitlistpool,(void *) hitpair);
    }
  }

  Hitlist_free(&hitpairlist);
  return newlist;
}


