/* PROGRAM:     examine
 * FILE:        $Header: /home/egg/src/RCS/examine.c,v 1.1 1998/07/21 11:39:04 ghn Exp $
 * PURPOSE:     Testing data retrieval from database
 * AUTHOR:      Greg Nelson
 * DATE:        98-05-09
 *
 * REVISED:     $Log: examine.c,v $
 * REVISED:     Revision 1.1  1998/07/21 11:39:04  ghn
 * REVISED:     Initial revision
 * REVISED:
 * Copyright 1998 - Greg Nelson
 * Redistributable under the terms of the GNU Public Licence (GPL)
 */

#include <stdio.h>
#include <stdlib.h>
#include "global.h"
#include "storage.h"

EggEntry eggtable[MAX_EGGS];

int main(int argc, char *argv[]) {
  int i, j, k, trials;
  FILE *fp;
  EggCarton pktbuf;

  pgmname = argv[0];

  if (argc != 1 && argc != 2) {
    printf("Usage: %s [infile]\n", pgmname);
    exit(-1);
  }
  
  InitStorage(NULL);

  if (argc == 1) fp = stdin;
  else fp = fopen(argv[1], "r");

  trials = 0;
  while (1) {
    i = LoadPacket(fp, &pktbuf);
    if (i < 0) {
      printf("Total trials: %d\n", trials);
      exit(-1);
    }

    printf("Packet of %d records read\n", pktbuf.hdr.numrec);
    for (j = 0; j < pktbuf.hdr.numrec; j++) {
      printf("Record: %d points\n  %ld: ",
	     pktbuf.hdr.samp_rec,
	     pktbuf.records[j].timestamp);
      for (k = 0; k < pktbuf.hdr.samp_rec; k++) {
	printf("%3d ", pktbuf.records[j].trials[k]);
	trials++;
      }
      printf("\n");
    }
  }

  return 0;
}
