#!/bin/bash
# This is a slightly modified version of upstream's scripts/run_tests.py

TESTS_CORE=(cache config cookies downloader extractor oauth postprocessor text util)
TESTS_RESULTS=(results)


# select tests
case "${1:-${GALLERYDL_TESTS:-core}}" in
    core)    TESTS=( ${TESTS_CORE[@]}    );;
    results) TESTS=( ${TESTS_RESULTS[@]} );;
    *)       TESTS=(                     );;
esac


# transform each array element to test_###.py
TESTS=( ${TESTS[@]/#/test_} )
TESTS=( ${TESTS[@]/%/.py}   )


# run 'nosetests3' with selected tests
# (or all tests if ${TESTS} is empty)
nosetests3 --verbose -w "test" ${TESTS[@]}
