# Функции округления

## floor(x\[, N\])
Возвращает наибольшее круглое число, которое меньше или равно, чем x.
Круглым называется число, кратное 1 / 10N или ближайшее к нему число соответствующего типа данных, если 1 / 10N не представимо точно.
N - целочисленная константа, не обязательный параметр. По умолчанию - ноль, что означает - округлять до целого числа.
N может быть отрицательным.

Примеры: `floor(123.45, 1) = 123.4, floor(123.45, -1) = 120.`

`x` - любой числовой тип. Результат - число того же типа.
Для целочисленных аргументов имеет смысл округление с отрицательным значением N (для неотрицательных N, функция ничего не делает).
В случае переполнения при округлении (например, floor(-128, -1)), возвращается implementation specific результат.

## ceil(x\[, N\])
Возвращает наименьшее круглое число, которое больше или равно, чем x.
В остальном, аналогично функции floor, см. выше.

## round(x\[, N\])

Реализует [банковское округление](https://en.wikipedia.org/wiki/Rounding#Round_half_to_even), т.е. округление до ближайшего чётного.

**Аргументы функции**

- `x` — число для округления. [Тип](../../data_types/index.md#data_types) — любой числовой.
- `N` — позиция цифры после запятой, до которой следует округлять.

**Возвращаемое значение**

Округлённое число того же типа, что и входное число `x`.

**Пример**

``` sql
SELECT
    number / 2 AS x,
    round(x)
FROM system.numbers
LIMIT 10
```
```
┌───x─┬─round(divide(number, 2))─┐
│   0 │                        0 │
│ 0.5 │                        0 │
│   1 │                        1 │
│ 1.5 │                        2 │
│   2 │                        2 │
│ 2.5 │                        2 │
│   3 │                        3 │
│ 3.5 │                        4 │
│   4 │                        4 │
│ 4.5 │                        4 │
└─────┴──────────────────────────┘
```

## roundToExp2(num)
Принимает число. Если число меньше единицы - возвращает 0. Иначе округляет число вниз до ближайшей (целой неотрицательной) степени двух.

## roundDuration(num)
Принимает число. Если число меньше единицы - возвращает 0. Иначе округляет число вниз до чисел из набора: 1, 10, 30, 60, 120, 180, 240, 300, 600, 1200, 1800, 3600, 7200, 18000, 36000. Эта функция специфична для Яндекс.Метрики и предназначена для реализации отчёта по длительности визита.

## roundAge(num)
Принимает число. Если число меньше 18 - возвращает 0. Иначе округляет число вниз до чисел из набора: 18, 25, 35, 45, 55. Эта функция специфична для Яндекс.Метрики и предназначена для реализации отчёта по возрасту посетителей.

[Оригинальная статья](https://clickhouse.yandex/docs/ru/query_language/functions/rounding_functions/) <!--hide-->
