package org.bouncycastle.pqc.crypto.test;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.SecureRandom;
import java.util.HashMap;

import junit.framework.TestCase;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.pqc.crypto.crystals.dilithium.DilithiumKeyGenerationParameters;
import org.bouncycastle.pqc.crypto.crystals.dilithium.DilithiumKeyPairGenerator;
import org.bouncycastle.pqc.crypto.crystals.dilithium.DilithiumParameters;
import org.bouncycastle.pqc.crypto.crystals.dilithium.DilithiumPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.crystals.dilithium.DilithiumPublicKeyParameters;
import org.bouncycastle.pqc.crypto.crystals.dilithium.DilithiumSigner;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Hex;

public class CrystalsDilithiumTest
    extends TestCase
{

    /*
    count = 0
    seed = 061550234D158C5EC95595FE04EF7A25767F2E24CC2BC479D09D86DC9ABCFDE7056A8C266F9EF97ED08541DBD2E1FFA1
    mlen = 33
    msg = D81C4D8D734FCBFBEADE3D3F8A039FAA2A2C9957E835AD55B22E75BF57BB556AC8
    pk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
    sk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
    smlen = 3326
    sm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
    */
    public void testDilithium()
    {
        String seed = "061550234D158C5EC95595FE04EF7A25767F2E24CC2BC479D09D86DC9ABCFDE7056A8C266F9EF97ED08541DBD2E1FFA1";
        String pk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
        String sk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

        NISTSecureRandom random = new NISTSecureRandom(Hex.decode(seed), null);

        DilithiumKeyPairGenerator keyGen = new DilithiumKeyPairGenerator();

        keyGen.init(new DilithiumKeyGenerationParameters(random, DilithiumParameters.dilithium3));

        AsymmetricCipherKeyPair keyPair = keyGen.generateKeyPair();

        assertTrue(Arrays.areEqual(Hex.decode(sk), ((DilithiumPrivateKeyParameters)keyPair.getPrivate()).getPrivateKey()));
        DilithiumPublicKeyParameters dPub = (DilithiumPublicKeyParameters)keyPair.getPublic();
        assertTrue(Arrays.areEqual(Hex.decode(pk), Arrays.concatenate(dPub.getRho(), dPub.getT1())));
    }

    public void testRNG()
    {
        String temp = "061550234D158C5EC95595FE04EF7A25767F2E24CC2BC479D09D86DC9ABCFDE7056A8C266F9EF97ED08541DBD2E1FFA1";
        byte[] seed = Hex.decode(temp);

        NISTSecureRandom r = new NISTSecureRandom(seed, null);

        String testBytesString = "7C9935A0B07694AA0C6D10E4DB6B1ADD2FD81A25CCB148032DCD739936737F2D";
        byte[] testBytes = Hex.decode(testBytesString);

        byte[] randBytes = new byte[testBytes.length];
        r.nextBytes(randBytes);

        assertTrue(Arrays.areEqual(randBytes, testBytes));
    }

    public void testVectors()
        throws Exception
    {
        String[] files = new String[]{
            "PQCsignKAT_Dilithium2.rsp",
            "PQCsignKAT_Dilithium3.rsp",
            "PQCsignKAT_Dilithium5.rsp",
            "PQCsignKAT_Dilithium2-AES.rsp",
            "PQCsignKAT_Dilithium3-AES.rsp",
            "PQCsignKAT_Dilithium5-AES.rsp"
        };

        DilithiumParameters[] parameters = new DilithiumParameters[]{
            DilithiumParameters.dilithium2,
            DilithiumParameters.dilithium3,
            DilithiumParameters.dilithium5,
            DilithiumParameters.dilithium2_aes,
            DilithiumParameters.dilithium3_aes,
            DilithiumParameters.dilithium5_aes
        };

        TestSampler sampler = new TestSampler();
        for (int fileindex = 0; fileindex < files.length; fileindex++)
        {
            String name = files[fileindex];
            System.out.println("testing: " + name);
            InputStream src = CrystalsDilithiumTest.class.getResourceAsStream("/org/bouncycastle/pqc/crypto/test/dilithium/" + name);
            BufferedReader bin = new BufferedReader(new InputStreamReader(src));
            String line = null;
            HashMap<String, String> buf = new HashMap<String, String>();
            while ((line = bin.readLine()) != null)
            {
                line = line.trim();

                if (line.startsWith("#"))
                {
                    continue;
                }
                if (line.length() == 0)
                {
                    if (buf.size() > 0)
                    {
                        String count = (String)buf.get("count");
                        if (sampler.skipTest(count))
                        {
                            continue;
                        }
                        System.out.println("test case: " + count);

                        byte[] seed = Hex.decode((String)buf.get("seed")); // seed for Dilithium secure random
                        byte[] pk = Hex.decode((String)buf.get("pk"));     // public key
                        byte[] sk = Hex.decode((String)buf.get("sk"));     // private key
                        byte[] sm = Hex.decode((String)buf.get("sm"));     // signed message
                        int sm_len = Integer.parseInt((String)buf.get("smlen"));
                        byte[] msg = Hex.decode((String)buf.get("msg")); // message
                        int m_len = Integer.parseInt((String)buf.get("mlen"));

                        NISTSecureRandom random = new NISTSecureRandom(seed, null);

                        // keygen
                        DilithiumKeyGenerationParameters kparam = new DilithiumKeyGenerationParameters(random, parameters[fileindex]);
                        DilithiumKeyPairGenerator kpg = new DilithiumKeyPairGenerator();
                        kpg.init(kparam);

                        AsymmetricCipherKeyPair ackp = kpg.generateKeyPair();
                        DilithiumPublicKeyParameters dPub = (DilithiumPublicKeyParameters)ackp.getPublic();
                        byte[] respk = Arrays.concatenate(dPub.getRho(), dPub.getT1());
                        // System.out.println("pk = ");
                        // Helper.printByteArray(pk);
                        byte[] ressk = ((DilithiumPrivateKeyParameters)ackp.getPrivate()).getEncoded();

                        //keygen
                        assertTrue(name + " " + count + " public key", Arrays.areEqual(respk, pk));
                        assertTrue(name + " " + count + " secret key", Arrays.areEqual(ressk, sk));

                        // sign
                        DilithiumSigner signer = new DilithiumSigner();
                        DilithiumPrivateKeyParameters skparam = (DilithiumPrivateKeyParameters)ackp.getPrivate();

                        signer.init(true, skparam);

                        byte[] sigGenerated = signer.generateSignature(msg);
                        byte[] attachedSig = Arrays.concatenate(sigGenerated, msg);

                        // verify
                        DilithiumSigner verifier = new DilithiumSigner();
                        DilithiumPublicKeyParameters pkparam = dPub;
                        verifier.init(false, pkparam);

                        boolean vrfyrespass = verifier.verifySignature(msg, sigGenerated);
                        sigGenerated[3]++; // changing the signature by 1 byte should cause it to fail
                        boolean vrfyresfail = verifier.verifySignature(msg, sigGenerated);

                        // print results
                            /*
                            System.out.println("--Keygen");
                            boolean kgenpass = true;
                            if (!Arrays.areEqual(respk, pk)) {
                                System.out.println("  == Keygen: pk do not match");
                                kgenpass = false;
                            }
                            if (!Arrays.areEqual(ressk, sk)) {
                                System.out.println("  == Keygen: sk do not match");
                                kgenpass = false;
                            }
                            if (kgenpass) {
                                System.out.println("  ++ Keygen pass");
                            } else {
                                System.out.println("  == Keygen failed");
                                return;
                            }

                            System.out.println("--Sign");
                            boolean spass = true;
                            if (!Arrays.areEqual(ressm, sm)) {
                                System.out.println("  == Sign: signature do not match");
                                spass = false;
                            }
                            if (spass) {
                                System.out.println("  ++ Sign pass");
                            } else {
                                System.out.println("  == Sign failed");
                                return;
                            }

                            System.out.println("--Verify");
                            if (vrfyrespass && !vrfyresfail) {
                                System.out.println("  ++ Verify pass");
                            } else {
                                System.out.println("  == Verify failed");
                                return;
                            }
                             */
                        // AssertTrue

                        //sign
                        // System.out.println("attached Sig = ");
                        // Helper.printByteArray(attachedSig);
                        // System.out.println("sm = ");
                        // Helper.printByteArray(sm);
                        assertTrue(name + " " + count + " signature", Arrays.areEqual(attachedSig, sm));
                        //verify
                        assertTrue(name + " " + count + " verify failed when should pass", vrfyrespass);
                        assertFalse(name + " " + count + " verify passed when should fail", vrfyresfail);

                    }
                    buf.clear();

                    continue;
                }

                int a = line.indexOf("=");
                if (a > -1)
                {
                    buf.put(line.substring(0, a).trim(), line.substring(a + 1).trim());
                }


            }
            System.out.println("testing successful!");
        }
    }

    public void testDilithiumRandom()
    {
        byte[] msg = Strings.toByteArray("Hello World!");
        DilithiumKeyPairGenerator keyGen = new DilithiumKeyPairGenerator();

        SecureRandom random = new SecureRandom();

        keyGen.init(new DilithiumKeyGenerationParameters(random, DilithiumParameters.dilithium3));

        for (int i = 0; i != 1000; i++)
        {
            AsymmetricCipherKeyPair keyPair = keyGen.generateKeyPair();

            // sign
            DilithiumSigner signer = new DilithiumSigner();
            DilithiumPrivateKeyParameters skparam = (DilithiumPrivateKeyParameters)keyPair.getPrivate();
            ParametersWithRandom skwrand = new ParametersWithRandom(skparam, random);
            signer.init(true, skwrand);

            byte[] sigGenerated = signer.generateSignature(msg);

            // verify
            DilithiumSigner verifier = new DilithiumSigner();
            DilithiumPublicKeyParameters pkparam = (DilithiumPublicKeyParameters)keyPair.getPublic();
            verifier.init(false, pkparam);

            assertTrue("count = " + i, verifier.verifySignature(msg, sigGenerated));
        }
    }
}
