/*

    Bist: a chemical drawing tool
    Copyright (C) 2008 Valerio Benfante

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/




#include <config.h>
#include <config_path.h>
#include <global.hpp>

#include <cairo/cairo.h>
#include <pango/pangocairo.h>
#include <cairo_t_singleton.hpp>
#include <glib.h>



#include <command_line.hpp>


#include <sys/stat.h>
#include <dirent.h>
#include <cerrno>


#include <cstdio>
#include <expat.h>

#include <FL/Fl_Image.H>
#include <FL/Fl_Pixmap.H>
#include <FL/Fl.H>
#include <FL/fl_draw.H>
#include <FL/Fl.H>
#include <FL/Fl_Double_Window.H>
#include <FL/Fl_Scroll.H>
#include <FL/Fl_Menu_Bar.H>
#include <FL/Fl_Menu_Item.H>
#include <FL/Fl_Toggle_Button.H>
#include <FL/Fl_Menu_Button.H>
#include <FL/Fl_Choice.H>
#include <FL/Fl_File_Chooser.H>
#include <FL/Fl_Light_Button.H>
#include <FL/Fl_Help_Dialog.H>


#include <interfacce.hpp>
#include <legame.hpp>
#include <etichetta.hpp>
#include <multiline_label.hpp>
#include <multifont_label.hpp>
#include <paragraph_text.hpp>
#include <atomo.hpp>
#include <procedura.hpp>
#include <gruppo.hpp>
#include <immagine.hpp>
#include <immagine_cml.hpp>
#include <immagine_mol.hpp>
#include <bist_plugin.hpp>
#include <mol_canvas.hpp>

#include <util.hpp>

#include <finestra_pr.hpp>
#include <editor.hpp>
#include <bond_prop.hpp>
#include <string_prop.hpp>

#include <prefs.hpp>


extern Preferences  __pref;



void print_version(){
  cout << ELF << " " << VERSION << endl;
}


void print_help(char* nome){
  cout << ELF << " " << _("Usage") << ":" << endl
       << "--help -h\t" << _("Print this message and exit") << endl
       << "--version -v\t" << _("Print version and package name and exit") << endl
       << "--convert-to -c\t" << _("Format of the converted file") << endl
       << "--input-file -f\t" << _("Input file(s) to convert") << endl;
}

void convert_to_vector_format(string in,string out, const char* format){

  immagine imm(true);
  imm.filebist(in);
  imm.start();
  export_image_to_vector_file(imm,out,false);

}


