
#line 3 "mealmaster.cc"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 6
#define YY_FLEX_SUBMINOR_VERSION 0
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#endif /* ! C99 */

#endif /* ! FLEXINT_H */

#ifdef __cplusplus

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

/* C99 requires __STDC__ to be defined as 1. */
#if defined (__STDC__)

#define YY_USE_CONST

#endif	/* defined (__STDC__) */
#endif	/* ! __cplusplus */

#ifdef YY_USE_CONST
#define yyconst const
#else
#define yyconst
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (yy_start) = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START (((yy_start) - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart(yyin  )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k.
 * Moreover, YY_BUF_SIZE is 2*YY_READ_BUF_SIZE in the general case.
 * Ditto for the __ia64__ case accordingly.
 */
#define YY_BUF_SIZE 32768
#else
#define YY_BUF_SIZE 16384
#endif /* __ia64__ */
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t yy_size_t;
#endif

extern yy_size_t yyleng;

extern FILE *yyin, *yyout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

    #define YY_LESS_LINENO(n)
    #define YY_LINENO_REWIND_TO(ptr)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = (yy_hold_char); \
		YY_RESTORE_YY_MORE_OFFSET \
		(yy_c_buf_p) = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, (yytext_ptr)  )

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	yy_size_t yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */
    
	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* Stack of input buffers. */
static size_t yy_buffer_stack_top = 0; /**< index of top of stack. */
static size_t yy_buffer_stack_max = 0; /**< capacity of stack. */
static YY_BUFFER_STATE * yy_buffer_stack = 0; /**< Stack as an array. */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( (yy_buffer_stack) \
                          ? (yy_buffer_stack)[(yy_buffer_stack_top)] \
                          : NULL)

/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE (yy_buffer_stack)[(yy_buffer_stack_top)]

/* yy_hold_char holds the character lost when yytext is formed. */
static char yy_hold_char;
static int yy_n_chars;		/* number of characters read into yy_ch_buf */
yy_size_t yyleng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = (char *) 0;
static int yy_init = 0;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow yywrap()'s to do buffer switches
 * instead of setting up a fresh yyin.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

void yyrestart (FILE *input_file  );
void yy_switch_to_buffer (YY_BUFFER_STATE new_buffer  );
YY_BUFFER_STATE yy_create_buffer (FILE *file,int size  );
void yy_delete_buffer (YY_BUFFER_STATE b  );
void yy_flush_buffer (YY_BUFFER_STATE b  );
void yypush_buffer_state (YY_BUFFER_STATE new_buffer  );
void yypop_buffer_state (void );

static void yyensure_buffer_stack (void );
static void yy_load_buffer_state (void );
static void yy_init_buffer (YY_BUFFER_STATE b,FILE *file  );

#define YY_FLUSH_BUFFER yy_flush_buffer(YY_CURRENT_BUFFER )

YY_BUFFER_STATE yy_scan_buffer (char *base,yy_size_t size  );
YY_BUFFER_STATE yy_scan_string (yyconst char *yy_str  );
YY_BUFFER_STATE yy_scan_bytes (yyconst char *bytes,yy_size_t len  );

void *yyalloc (yy_size_t  );
void *yyrealloc (void *,yy_size_t  );
void yyfree (void *  );

#define yy_new_buffer yy_create_buffer

#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer(yyin,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}

#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer(yyin,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */

#define yywrap() (/*CONSTCOND*/1)
#define YY_SKIP_YYWRAP

typedef unsigned char YY_CHAR;

FILE *yyin = (FILE *) 0, *yyout = (FILE *) 0;

typedef int yy_state_type;

extern int yylineno;

int yylineno = 1;

extern char *yytext;
#ifdef yytext_ptr
#undef yytext_ptr
#endif
#define yytext_ptr yytext

static yy_state_type yy_get_previous_state (void );
static yy_state_type yy_try_NUL_trans (yy_state_type current_state  );
static int yy_get_next_buffer (void );
#if defined(__GNUC__) && __GNUC__ >= 3
__attribute__((__noreturn__))
#endif
static void yy_fatal_error (yyconst char msg[]  );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	(yytext_ptr) = yy_bp; \
	yyleng = (size_t) (yy_cp - yy_bp); \
	(yy_hold_char) = *yy_cp; \
	*yy_cp = '\0'; \
	(yy_c_buf_p) = yy_cp;

#define YY_NUM_RULES 65
#define YY_END_OF_BUFFER 66
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static yyconst flex_int16_t yy_accept[275] =
    {   0,
        0,    0,    0,    0,    0,    0,    7,    7,    0,    0,
       11,   11,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,   48,   48,    0,    0,
        0,    0,    0,    0,   51,   51,   55,   55,   57,   57,
       66,    3,    2,    3,    3,    3,    3,   63,    5,   63,
       62,    4,   63,   60,   61,   60,   60,    8,   63,    7,
       64,   63,    9,   63,   13,   63,   11,   12,   14,   63,
       63,   16,   19,   63,   17,   18,   20,   63,   27,   27,
       27,   22,   21,   27,   40,   40,   40,   40,   39,   43,
       44,   43,   43,   43,   43,   43,   43,   43,   43,   43,

       43,   43,   43,   43,   43,   43,   43,   43,   43,   43,
       46,   46,   46,   46,   45,   50,   63,   49,   48,   31,
       63,   32,   32,   29,   35,   63,   34,   33,   37,   37,
       37,   37,   36,   53,   63,   52,   51,   54,   63,   56,
       55,   56,   58,   59,   63,   57,    2,    0,    0,    5,
        0,   61,    8,    7,   64,    0,   13,   11,   12,    0,
        0,   16,   19,   18,   20,   20,    0,    0,   22,   21,
        0,   22,    0,   41,   44,   42,   47,   50,   48,   31,
       30,   35,   38,   36,   53,   51,   54,   54,    0,    0,
        0,   55,    0,   59,   57,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,   28,    0,   26,
        0,    6,    0,    0,   15,   23,   26,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,   25,
        0,   10,    0,   24,    0,   24,    0,    0,    0,    0,
        1,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0
    } ;

static yyconst YY_CHAR yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    4,    1,    1,    1,    1,    1,    1,    5,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    6,    7,    7,    7,    7,    7,    7,    7,    7,
        7,    7,    7,    8,    9,   10,   11,   12,   12,   12,
       12,   12,   12,   12,   12,   12,   12,   13,    7,    7,
        7,    7,    7,    7,   14,    7,   15,    7,   16,    7,
        7,    7,    7,    7,    7,   17,   18,    7,    7,    7,
        7,   19,   20,   21,    7,    7,    7,    7,   22,    7,
        7,    7,    7,    7,    7,    7,   23,   24,   25,   26,

       27,   28,   29,    7,   30,    7,   31,   32,   33,   34,
       35,   36,   37,   38,   39,   40,    7,   41,    7,   42,
        7,   43,    7,    7,    7,    7,    7,    7,    7,    7,
        7,    7,    7,    7,    7,    7,    7,    7,    7,    7,
        7,    7,    7,    7,    7,    7,    7,    7,    7,    7,
        7,    7,    7,    7,    7,    7,    7,    7,    7,    7,
        7,    7,    7,    7,    7,    7,    7,    7,    7,    7,
        7,    7,    7,    7,    7,    7,    7,    7,    7,    7,
        7,    7,    7,    7,    7,    7,    7,    7,    7,    7,
        7,    7,    7,    7,    7,    7,    7,    7,    7,    7,

        7,    7,    7,    7,    7,    7,    7,    7,    7,    7,
        7,    7,    7,    7,    7,    7,    7,    7,    7,    7,
        7,    7,    7,    7,    7,    7,    7,    7,    7,    7,
        7,    7,    7,    7,    7,    7,    7,    7,    7,    7,
        7,    7,    7,    7,    7,    7,    7,    7,    7,    7,
        7,    7,    7,    7,    7
    } ;

static yyconst YY_CHAR yy_meta[44] =
    {   0,
        1,    1,    2,    2,    1,    3,    4,    5,    6,    4,
        4,    4,    4,    4,    4,    4,    4,    4,    4,    4,
        4,    4,    4,    4,    4,    4,    4,    4,    4,    4,
        4,    4,    4,    4,    4,    4,    4,    4,    4,    4,
        4,    4,    4
    } ;

static yyconst flex_uint16_t yy_base[300] =
    {   0,
        0,    3,   10,   19,   23,   29,   34,   40,   43,   47,
       62,   70,   76,   80,   56,   85,  102,  108,  114,  132,
       51,   88,  150,    0,  124,  142,  193,  199,  205,  216,
      227,  232,  236,  241,  253,  259,  265,  274,  283,  288,
      695,  696,  696,  691,  696,  684,  674,  696,  696,  688,
      696,  696,  660,  696,  696,  686,  696,  696,  685,    0,
      696,  684,  696,  653,  696,  654,    0,  547,  696,  525,
      521,  538,  696,  546,  696,    0,  696,  544,  291,  696,
      537,  533,    7,  526,  696,  696,  540,  696,  696,  696,
      696,  538,  696,  534,  532,  501,  275,  273,  511,  501,

      116,  503,  218,  284,  488,  109,  489,   44,  290,  514,
      696,  696,  515,  696,  696,  696,  511,  696,    0,  696,
      508,  492,  696,  696,  696,  499,  696,  696,  696,  696,
      498,  696,  487,  696,  495,  696,    0,  696,  493,  314,
        0,  318,  696,  696,  489,    0,  696,  482,  470,  696,
      447,  696,  696,    0,  696,  438,  696,    0,  471,  432,
      439,  446,  696,    0,  696,  696,  454,  322,  439,   89,
      439,  435,  421,  696,  696,  696,  696,  696,    0,  696,
      425,  696,  696,  423,  696,    0,  696,  696,  430,  327,
      334,    0,  209,  696,    0,  421,  405,  387,  383,  365,

      364,  338,  385,  372,  379,  360,  347,  341,  328,  325,
      343,  336,  317,  321,  306,  273,  272,  287,  353,  357,
      334,  346,  292,  244,  244,  266,  365,  696,  248,  217,
      358,  219,  184,   92,  119,  246,  115,  365,   68,   74,
      381,  371,   30,  389,  368,   17,  396,  389,   23,  405,
      395,  696,  414,   14,  403,    5,  411,  407,  428,  438,
      696,    7,  446,  449,  451,  456,  472,  503,  477,  482,
      521,  490,  509,  696,  554,  560,  566,  572,  578,  584,
      590,  596,  602,  608,  614,  620,  626,  632,  638,  644,
      648,  652,  656,  659,  662,  665,  668,  674,  680

    } ;

static yyconst flex_int16_t yy_def[300] =
    {   0,
      275,  275,  276,  276,  277,  277,  278,  278,  276,  276,
      279,  279,  276,  276,  276,  276,  280,  280,  281,  281,
      282,  282,  274,   23,  283,  283,  284,  284,  285,  285,
      286,  286,  287,  287,  288,  288,  289,  289,  290,  290,
      274,  274,  274,  274,  274,  274,  274,  274,  274,  274,
      274,  274,  274,  274,  274,  274,  274,  274,  274,  291,
      274,  274,  274,  274,  274,  274,  292,  274,  274,  274,
      274,  274,  274,  274,  274,  293,  274,  274,  274,  274,
      274,  274,  274,  274,  274,  274,  274,  274,  274,  274,
      274,  274,  274,  274,  274,  274,  274,  274,  274,  274,

      274,  274,  274,  274,  274,  274,  274,  274,  274,  274,
      274,  274,  274,  274,  274,  274,  274,  274,  294,  274,
      274,  274,  274,  274,  274,  274,  274,  274,  274,  274,
      274,  274,  274,  274,  274,  274,  295,  274,  274,  274,
      296,  274,  274,  274,  274,  297,  274,  274,  274,  274,
      274,  274,  274,  291,  274,  274,  274,  292,  274,  274,
      274,  274,  274,  293,  274,  274,  274,  274,  274,  274,
      274,  274,  274,  274,  274,  274,  274,  274,  294,  274,
      274,  274,  274,  274,  274,  295,  274,  274,  274,  274,
      274,  296,  274,  274,  297,  274,  274,  274,  274,  274,

      274,  274,  274,  274,  274,  274,  274,  274,  274,  274,
      274,  274,  274,  298,  274,  274,  274,  274,  274,  274,
      298,  298,  274,  274,  274,  274,  274,  274,  274,  274,
      298,  274,  274,  274,  274,  274,  274,  298,  274,  274,
      274,  298,  274,  274,  298,  274,  274,  298,  274,  274,
      298,  274,  274,  274,  298,  274,  298,  298,  299,  299,
      274,  274,  299,  299,  299,  299,  299,  299,  299,  299,
      299,  299,  299,    0,  274,  274,  274,  274,  274,  274,
      274,  274,  274,  274,  274,  274,  274,  274,  274,  274,
      274,  274,  274,  274,  274,  274,  274,  274,  274

    } ;

static yyconst flex_uint16_t yy_nxt[740] =
    {   0,
      274,  274,   43,   44,   45,   43,   44,   45,   46,  261,
      256,   46,   49,   50,   51,   52,  169,   47,  170,  256,
       47,   49,   50,   51,   52,   55,   56,   57,  252,  249,
       53,   55,   56,   57,   48,   48,   58,   59,   51,   53,
       48,   48,   58,   59,   51,   61,   62,   51,   63,   61,
       62,   51,   63,   86,   87,   88,   89,   64,   61,   62,
       51,   64,   48,   48,   65,   66,   51,   72,  246,   68,
       48,   48,   65,   66,   51,  176,  176,   68,   61,   62,
       51,   69,   61,   62,   51,   69,  226,   61,   62,   51,
       86,   87,   88,   89,  243,   70,   72,   71,  169,   70,

      170,   71,   48,   48,   73,   74,   51,   75,   48,   48,
       73,   74,   51,   75,   48,   48,   77,   78,   51,   79,
      237,  176,   81,   82,  235,   83,  112,  113,  114,  115,
      240,   84,   48,   48,   77,   78,   51,   79,  176,  176,
       81,   82,  176,   83,  112,  113,  114,  115,  176,   84,
       90,   90,   91,   92,   93,   94,   90,   90,   90,   90,
       90,   90,   90,   90,   90,   90,   90,   90,   90,   90,
       95,   90,   90,   96,   97,   98,   99,  100,  101,   90,
      102,  103,  104,   90,  105,  106,  107,   90,  108,  109,
       90,  110,   90,   48,   48,  116,  117,   51,  118,   48,

       48,  116,  117,   51,  118,   48,   48,  120,  121,   51,
      122,  188,  189,  239,  193,  124,   48,   48,  120,  121,
       51,  122,  237,  176,  232,  230,  124,   48,   48,  125,
      126,   51,   48,   48,  125,  126,   51,  128,  130,  131,
      132,  176,  128,  130,  131,  132,  176,  133,  166,  167,
      228,  241,  133,   48,   48,  134,  135,   51,  136,   48,
       48,  134,  135,   51,  136,   48,   48,  138,  139,   51,
      140,  235,  234,  142,   48,   48,  138,  139,   51,  140,
      176,  233,  142,   48,  143,  144,  145,   51,   48,  143,
      144,  145,   51,  166,  167,  176,  168,  232,  176,  226,

      169,  176,  170,  176,  176,  225,  176,  224,  176,  176,
      176,  176,  176,  176,  176,  176,  188,  189,  223,  190,
      188,  189,  191,  193,  166,  167,  191,  202,  176,  188,
      189,  169,  190,  170,  220,  191,  188,  189,  222,  193,
      166,  167,  191,  211,  220,  166,  167,  169,  219,  170,
      218,  222,  169,  222,  170,  166,  167,  217,  227,  228,
      229,  231,  169,  222,  170,  230,  222,  166,  167,  216,
      236,  238,  231,  215,  169,  222,  170,  214,  222,  245,
      238,  242,  222,  166,  167,  248,  244,  214,  222,  213,
      222,  166,  167,  212,  247,  210,  242,  222,  166,  167,

      248,  250,  251,  222,  231,  209,  222,  166,  167,  208,
      253,  251,  222,  254,  255,  231,  166,  167,  207,  253,
      222,  222,  206,  257,  222,  259,  258,  222,  222,  205,
      261,  262,  188,  255,  184,  222,  181,  258,  204,  222,
      261,  262,  257,  222,  259,  263,  172,  203,  261,  262,
      172,  261,  262,  261,  262,  263,  166,  162,  261,  262,
      263,  264,  265,  263,  267,  201,  263,  266,  263,  200,
      263,  265,  264,  263,  261,  262,  159,  199,  263,  261,
      262,  263,  266,  263,  261,  262,  198,  197,  263,  268,
      196,  194,  261,  262,  263,  187,  270,  185,  184,  263,

      183,  182,  271,  181,  268,  261,  262,  263,  273,  263,
      180,  261,  262,  178,  263,  270,  269,  177,  264,  176,
      263,  271,  263,  261,  262,  269,  263,  273,  176,  264,
      176,  176,  176,  176,  176,  263,  272,  176,  263,  176,
      175,  263,  174,  173,  172,  171,  165,  272,  163,  162,
      161,  160,  159,  263,   42,   42,   42,   42,   42,   42,
       48,   48,   48,   48,   48,   48,   54,   54,   54,   54,
       54,   54,   60,   60,   60,   60,   60,   60,   67,   67,
       67,   67,   67,   67,   76,   76,   76,   76,   76,   76,
       80,   80,   80,   80,   80,   80,   85,   85,   85,   85,

       85,   85,  111,  111,  111,  111,  111,  111,  119,  119,
      119,  119,  119,  119,  123,  123,  123,  123,  123,  123,
      127,  127,  127,  127,  127,  127,  129,  129,  129,  129,
      129,  129,  137,  137,  137,  137,  137,  137,  141,  141,
      141,  141,  141,  141,  146,  146,  146,  146,  146,  146,
      154,  154,  154,  154,  158,  158,  157,  158,  164,  164,
      164,  164,  179,  179,  179,  186,  186,  186,  192,  192,
      195,  195,  195,  195,  221,  156,  221,  221,  221,  221,
      260,  260,  260,  260,  260,  260,  155,  153,  152,  151,
      150,  149,  148,  147,  274,   41,  274,  274,  274,  274,

      274,  274,  274,  274,  274,  274,  274,  274,  274,  274,
      274,  274,  274,  274,  274,  274,  274,  274,  274,  274,
      274,  274,  274,  274,  274,  274,  274,  274,  274,  274,
      274,  274,  274,  274,  274,  274,  274,  274,  274
    } ;

static yyconst flex_int16_t yy_chk[740] =
    {   0,
        0,    0,    1,    1,    1,    2,    2,    2,    1,  262,
      256,    2,    3,    3,    3,    3,   83,    1,   83,  254,
        2,    4,    4,    4,    4,    5,    5,    5,  249,  246,
        3,    6,    6,    6,    7,    7,    7,    7,    7,    4,
        8,    8,    8,    8,    8,    9,    9,    9,    9,   10,
       10,   10,   10,   21,   21,   21,   21,    9,   15,   15,
       15,   10,   11,   11,   11,   11,   11,   15,  243,   11,
       12,   12,   12,   12,   12,  108,  108,   12,   13,   13,
       13,   13,   14,   14,   14,   14,  240,   16,   16,   16,
       22,   22,   22,   22,  239,   13,   16,   13,  170,   14,

      170,   14,   17,   17,   17,   17,   17,   17,   18,   18,
       18,   18,   18,   18,   19,   19,   19,   19,   19,   19,
      237,  101,   19,   19,  235,   19,   25,   25,   25,   25,
      234,   19,   20,   20,   20,   20,   20,   20,  101,  106,
       20,   20,  106,   20,   26,   26,   26,   26,  106,   20,
       23,   23,   23,   23,   23,   23,   23,   23,   23,   23,
       23,   23,   23,   23,   23,   23,   23,   23,   23,   23,
       23,   23,   23,   23,   23,   23,   23,   23,   23,   23,
       23,   23,   23,   23,   23,   23,   23,   23,   23,   23,
       23,   23,   23,   27,   27,   27,   27,   27,   27,   28,

       28,   28,   28,   28,   28,   29,   29,   29,   29,   29,
       29,  193,  193,  233,  193,   29,   30,   30,   30,   30,
       30,   30,  230,  103,  232,  230,   30,   31,   31,   31,
       31,   31,   32,   32,   32,   32,   32,   31,   33,   33,
       33,  103,   32,   34,   34,   34,  103,   33,  236,  236,
      229,  236,   34,   35,   35,   35,   35,   35,   35,   36,
       36,   36,   36,   36,   36,   37,   37,   37,   37,   37,
       37,  226,  225,   37,   38,   38,   38,   38,   38,   38,
       97,  224,   38,   39,   39,   39,   39,   39,   40,   40,
       40,   40,   40,   79,   79,  109,   79,  223,   97,  218,

       79,   98,   79,   97,   98,  217,   97,  216,   97,  104,
       98,   98,  104,  109,   97,  104,  140,  140,  215,  140,
      142,  142,  140,  142,  168,  168,  142,  168,  109,  190,
      190,  168,  190,  168,  213,  190,  191,  191,  214,  191,
      202,  202,  191,  202,  212,  211,  211,  202,  211,  202,
      210,  221,  211,  214,  211,  219,  219,  209,  219,  220,
      220,  222,  219,  222,  219,  220,  221,  227,  227,  208,
      227,  231,  222,  207,  227,  231,  227,  206,  222,  242,
      231,  238,  238,  241,  241,  245,  241,  205,  242,  204,
      231,  244,  244,  203,  244,  201,  238,  238,  247,  247,

      245,  247,  248,  242,  248,  200,  248,  250,  250,  199,
      250,  248,  251,  250,  251,  248,  253,  253,  198,  253,
      255,  248,  197,  255,  258,  258,  257,  251,  257,  196,
      259,  259,  189,  251,  184,  255,  181,  257,  173,  258,
      260,  260,  255,  257,  258,  259,  172,  171,  263,  263,
      169,  264,  264,  265,  265,  260,  167,  162,  266,  266,
      259,  263,  264,  263,  266,  161,  264,  265,  265,  160,
      260,  264,  263,  266,  267,  267,  159,  156,  263,  269,
      269,  264,  265,  265,  270,  270,  151,  149,  266,  267,
      148,  145,  272,  272,  269,  139,  269,  135,  133,  270,

      131,  126,  270,  122,  267,  268,  268,  272,  272,  269,
      121,  273,  273,  117,  270,  269,  268,  113,  268,  110,
      268,  270,  272,  271,  271,  268,  273,  272,  107,  268,
      105,  102,  100,   99,   96,  268,  271,   95,  271,   94,
       92,  273,   87,   84,   82,   81,   78,  271,   74,   72,
       71,   70,   68,  271,  275,  275,  275,  275,  275,  275,
      276,  276,  276,  276,  276,  276,  277,  277,  277,  277,
      277,  277,  278,  278,  278,  278,  278,  278,  279,  279,
      279,  279,  279,  279,  280,  280,  280,  280,  280,  280,
      281,  281,  281,  281,  281,  281,  282,  282,  282,  282,

      282,  282,  283,  283,  283,  283,  283,  283,  284,  284,
      284,  284,  284,  284,  285,  285,  285,  285,  285,  285,
      286,  286,  286,  286,  286,  286,  287,  287,  287,  287,
      287,  287,  288,  288,  288,  288,  288,  288,  289,  289,
      289,  289,  289,  289,  290,  290,  290,  290,  290,  290,
      291,  291,  291,  291,  292,  292,   66,  292,  293,  293,
      293,  293,  294,  294,  294,  295,  295,  295,  296,  296,
      297,  297,  297,  297,  298,   64,  298,  298,  298,  298,
      299,  299,  299,  299,  299,  299,   62,   59,   56,   53,
       50,   47,   46,   44,   41,  274,  274,  274,  274,  274,

      274,  274,  274,  274,  274,  274,  274,  274,  274,  274,
      274,  274,  274,  274,  274,  274,  274,  274,  274,  274,
      274,  274,  274,  274,  274,  274,  274,  274,  274,  274,
      274,  274,  274,  274,  274,  274,  274,  274,  274
    } ;

static yy_state_type yy_last_accepting_state;
static char *yy_last_accepting_cpos;

extern int yy_flex_debug;
int yy_flex_debug = 0;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *yytext;
#line 1 "mealmaster.ll"
#line 2 "mealmaster.ll"
/* AnyMeal recipe management software
   Copyright (C) 2020 Jan Wedekind

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>. */
#include <cassert>
#include <ios>
#include <sstream>
#include "mealmaster.hh"

// ftp://ftp.gnu.org/old-gnu/Manuals/flex-2.5.4/html_mono/flex.html
std::istream *yystream;
Ingredient ingredient_;
std::string right_continuation;
std::vector<Ingredient> right_column;
Recipe recipe;
int newlines;
std::string buffer;
std::string section;
std::ostringstream error_message;
int ingredient_column;

extern int yylex(void);

int line_no;

#define YY_INPUT(buffer, result, max_size) { \
  yystream->read(buffer, max_size); \
  result = yystream->gcount(); \
}

Recipe parse_mealmaster(std::istream &stream) {
  recipe = Recipe();
  yystream = &stream;
  line_no = 1;
  error_message.str("");
  error_message.clear();
  newlines = 0;
  ingredient_column = 0;
  right_continuation.clear();
  right_column.clear();
  int result = yylex();
  yyrestart(NULL);
  yy_start = 1;
  if (result)
    throw parse_exception(error_message.str());
  return recipe;
}

void flush_right_column(void) {
  if (!recipe.ingredients().empty() && !right_continuation.empty()) {
    recipe.ingredients().back().add_text(right_continuation.c_str());
  };
  for (std::vector<Ingredient>::iterator i=right_column.begin(); i!=right_column.end(); i++) {
    recipe.add_ingredient(*i);
  };
  right_continuation.clear();
  right_column.clear();
}

void add_text_to_ingredient(const char *text) {
  if (ingredient_column) {
    if (!right_column.empty())
      right_column.back().add_text(text);
    else
      right_continuation += text;
  } else {
    assert(!recipe.ingredients().empty());
    recipe.ingredients().back().add_text(text);
  };
}



#line 810 "mealmaster.cc"

#define INITIAL 0
#define title 1
#define error 2
#define titletext 3
#define categories 4
#define categoriestext 5
#define servings 6
#define servingsamount 7
#define servingsunit 8
#define body 9
#define unit1 10
#define unit2 11
#define unit3 12
#define ingredienttext 13
#define amount 14
#define amount2 15
#define fraction 16
#define ingredientcont 17
#define sectionheader 18
#define instructionstext 19

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

static int yy_init_globals (void );

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int yylex_destroy (void );

int yyget_debug (void );

void yyset_debug (int debug_flag  );

YY_EXTRA_TYPE yyget_extra (void );

void yyset_extra (YY_EXTRA_TYPE user_defined  );

FILE *yyget_in (void );

void yyset_in  (FILE * _in_str  );

FILE *yyget_out (void );

void yyset_out  (FILE * _out_str  );

yy_size_t yyget_leng (void );

char *yyget_text (void );

int yyget_lineno (void );

void yyset_lineno (int _line_number  );

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int yywrap (void );
#else
extern int yywrap (void );
#endif
#endif

#ifndef YY_NO_UNPUT
    
    static void yyunput (int c,char *buf_ptr  );
    
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy (char *,yyconst char *,int );
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * );
#endif

#ifndef YY_NO_INPUT

#ifdef __cplusplus
static int yyinput (void );
#else
static int input (void );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k */
#define YY_READ_BUF_SIZE 16384
#else
#define YY_READ_BUF_SIZE 8192
#endif /* __ia64__ */
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO do { if (fwrite( yytext, yyleng, 1, yyout )) {} } while (0)
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		size_t n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = fread(buf, 1, max_size, yyin))==0 && ferror(yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(yyin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int yylex (void);

#define YY_DECL int yylex (void)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK /*LINTED*/break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	yy_state_type yy_current_state;
	char *yy_cp, *yy_bp;
	int yy_act;
    
	if ( !(yy_init) )
		{
		(yy_init) = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! (yy_start) )
			(yy_start) = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			yyensure_buffer_stack ();
			YY_CURRENT_BUFFER_LVALUE =
				yy_create_buffer(yyin,YY_BUF_SIZE );
		}

		yy_load_buffer_state( );
		}

	{
#line 101 "mealmaster.ll"


#line 1050 "mealmaster.cc"

	while ( /*CONSTCOND*/1 )		/* loops until end-of-file is reached */
		{
		yy_cp = (yy_c_buf_p);

		/* Support of yytext. */
		*yy_cp = (yy_hold_char);

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = (yy_start);
yy_match:
		do
			{
			YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)] ;
			if ( yy_accept[yy_current_state] )
				{
				(yy_last_accepting_state) = yy_current_state;
				(yy_last_accepting_cpos) = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 275 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			++yy_cp;
			}
		while ( yy_current_state != 274 );
		yy_cp = (yy_last_accepting_cpos);
		yy_current_state = (yy_last_accepting_state);

yy_find_action:
		yy_act = yy_accept[yy_current_state];

		YY_DO_BEFORE_ACTION;

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = (yy_hold_char);
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			goto yy_find_action;

case 1:
/* rule 1 can match eol */
YY_RULE_SETUP
#line 103 "mealmaster.ll"
{
  line_no++;
  BEGIN(title);
}
	YY_BREAK
case 2:
/* rule 2 can match eol */
YY_RULE_SETUP
#line 108 "mealmaster.ll"
{
  line_no++;
}
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 112 "mealmaster.ll"

	YY_BREAK
case 4:
YY_RULE_SETUP
#line 114 "mealmaster.ll"

	YY_BREAK
case 5:
/* rule 5 can match eol */
YY_RULE_SETUP
#line 115 "mealmaster.ll"
{
  line_no++;
}
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 118 "mealmaster.ll"
{
  BEGIN(titletext);
}
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 122 "mealmaster.ll"
{
  recipe.set_title(yytext);
}
	YY_BREAK
case 8:
/* rule 8 can match eol */
YY_RULE_SETUP
#line 125 "mealmaster.ll"
{
  line_no++;
  BEGIN(categories);
}
	YY_BREAK
case 9:
YY_RULE_SETUP
#line 130 "mealmaster.ll"

	YY_BREAK
case 10:
YY_RULE_SETUP
#line 131 "mealmaster.ll"
{
  BEGIN(categoriestext);
  // TODO: default category if list is empty
}
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 136 "mealmaster.ll"
{
  recipe.add_category(yytext);
}
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 139 "mealmaster.ll"

	YY_BREAK
case 13:
/* rule 13 can match eol */
YY_RULE_SETUP
#line 140 "mealmaster.ll"
{
  line_no++;
  BEGIN(servings);
}
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 145 "mealmaster.ll"

	YY_BREAK
case 15:
YY_RULE_SETUP
#line 146 "mealmaster.ll"
{
  BEGIN(servingsamount);
}
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 150 "mealmaster.ll"
{
  recipe.set_servings(atoi(yytext));
  BEGIN(servingsunit);
}
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 155 "mealmaster.ll"

	YY_BREAK
case 18:
YY_RULE_SETUP
#line 156 "mealmaster.ll"
{
  recipe.set_servings_unit(yytext);
}
	YY_BREAK
case 19:
/* rule 19 can match eol */
YY_RULE_SETUP
#line 159 "mealmaster.ll"
{
  line_no++;
  ingredient_ = Ingredient();
  buffer.clear();
  BEGIN(body);
}
	YY_BREAK
case 20:
/* rule 20 can match eol */
YY_RULE_SETUP
#line 166 "mealmaster.ll"
{
  line_no++;
  ingredient_column = 0;
  if (!recipe.instructions().empty())
    newlines++;
}
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 172 "mealmaster.ll"
{
  buffer += yytext;
  ingredient_.set_amount_integer(atoi(yytext));
  BEGIN(amount);
}
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 177 "mealmaster.ll"
{
  buffer += yytext;
  ingredient_.set_amount_float(atof(yytext));
  BEGIN(unit1);
}
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 182 "mealmaster.ll"
{
  buffer += yytext;
  BEGIN(unit1);
}
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 186 "mealmaster.ll"
{
  buffer += yytext;
  if (!recipe.ingredients().empty()) {
    if (!recipe.ingredient_sections().empty() && recipe.ingredient_sections().back().first == recipe.ingredients().size()) {
      error_message << "Ingredient section starting with ingredient continuation in line " << line_no;
      BEGIN(error);
    } else {
      add_text_to_ingredient(" ");
      BEGIN(ingredientcont);
    };
  } else {
    error_message << "Unexpected ingredient continuation in line " << line_no;
    BEGIN(error);
  };
}
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 201 "mealmaster.ll"
{
  buffer += yytext;
  if (recipe.instructions().empty()) {
    ingredient_.set_unit("  ");
    BEGIN(ingredienttext);
  } else {
    BEGIN(instructionstext);
  };
}
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 210 "mealmaster.ll"
{
  section.clear();
  flush_right_column();
  BEGIN(sectionheader);
}
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 215 "mealmaster.ll"
{
  unput(*yytext);
  BEGIN(instructionstext);
}
	YY_BREAK
case 28:
/* rule 28 can match eol */
YY_RULE_SETUP
#line 219 "mealmaster.ll"
{
  line_no++;
  flush_right_column();
  BEGIN(INITIAL);
  return 0;
}
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 226 "mealmaster.ll"
{
  buffer += yytext;
  ingredient_.set_amount_numerator(ingredient_.amount_integer());
  ingredient_.set_amount_integer(0);
  BEGIN(fraction);
}
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 232 "mealmaster.ll"
{
  buffer += yytext;
  ingredient_.set_amount_numerator(atoi(yytext));
  BEGIN(amount2);
}
	YY_BREAK
case 31:
/* rule 31 can match eol */
YY_RULE_SETUP
#line 237 "mealmaster.ll"
{
  unput('\n');
  BEGIN(instructionstext);
}
	YY_BREAK
case 32:
YY_RULE_SETUP
#line 241 "mealmaster.ll"
{
  unput(*yytext);
  BEGIN(unit1);
}
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 246 "mealmaster.ll"
{
  buffer += yytext;
  BEGIN(fraction);
}
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 250 "mealmaster.ll"
{
  unput(*yytext);
  BEGIN(instructionstext);
}
	YY_BREAK
case 35:
/* rule 35 can match eol */
YY_RULE_SETUP
#line 254 "mealmaster.ll"
{
  unput('\n');
  BEGIN(instructionstext);
}
	YY_BREAK
case 36:
YY_RULE_SETUP
#line 259 "mealmaster.ll"
{
  buffer += yytext;
  ingredient_.set_amount_denominator(atoi(yytext));
  BEGIN(unit1);
}
	YY_BREAK
case 37:
/* rule 37 can match eol */
YY_RULE_SETUP
#line 264 "mealmaster.ll"
{
  unput(*yytext);
  BEGIN(instructionstext);
}
	YY_BREAK
case 38:
/* rule 38 can match eol */
YY_RULE_SETUP
#line 268 "mealmaster.ll"
{
  unput('\n');
  BEGIN(instructionstext);
}
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 273 "mealmaster.ll"
{
  buffer += yytext;
  BEGIN(unit2);
}
	YY_BREAK
case 40:
/* rule 40 can match eol */
YY_RULE_SETUP
#line 277 "mealmaster.ll"
{
  unput(*yytext);
  BEGIN(instructionstext);
}
	YY_BREAK
case 41:
/* rule 41 can match eol */
YY_RULE_SETUP
#line 281 "mealmaster.ll"
{
  unput('\n');
  BEGIN(instructionstext);
}
	YY_BREAK
case 42:
YY_RULE_SETUP
#line 286 "mealmaster.ll"
{
  buffer += yytext;
  ingredient_.set_unit(yytext);
  BEGIN(unit3);
}
	YY_BREAK
case 43:
YY_RULE_SETUP
#line 291 "mealmaster.ll"
{
  unput(*yytext);
  BEGIN(instructionstext);
}
	YY_BREAK
case 44:
/* rule 44 can match eol */
YY_RULE_SETUP
#line 295 "mealmaster.ll"
{
  unput('\n');
  BEGIN(instructionstext);
}
	YY_BREAK
case 45:
YY_RULE_SETUP
#line 300 "mealmaster.ll"
{
  buffer += yytext;
  if (buffer.length() == 11) {
    BEGIN(ingredienttext);
  } else {
    BEGIN(instructionstext);
  };
}
	YY_BREAK
case 46:
/* rule 46 can match eol */
YY_RULE_SETUP
#line 308 "mealmaster.ll"
{
  unput(*yytext);
  BEGIN(instructionstext);
}
	YY_BREAK
case 47:
/* rule 47 can match eol */
YY_RULE_SETUP
#line 312 "mealmaster.ll"
{
  unput('\n');
  BEGIN(instructionstext);
}
	YY_BREAK
case 48:
YY_RULE_SETUP
#line 317 "mealmaster.ll"
{
  buffer += yytext;
  ingredient_.add_text(yytext);
}
	YY_BREAK
case 49:
YY_RULE_SETUP
#line 321 "mealmaster.ll"
{
  buffer += yytext;
  if (buffer.length() == 41) {
    while (!ingredient_.text().empty() && ingredient_.text()[ingredient_.text().length() - 1] == ' ')
      ingredient_.text() = ingredient_.text().substr(0, ingredient_.text().length() - 1);
    recipe.add_ingredient(ingredient_);
    ingredient_ = Ingredient();
    ingredient_column = 1;
    buffer.clear();
    BEGIN(body);
  } else
    ingredient_.add_text(yytext);
}
	YY_BREAK
case 50:
/* rule 50 can match eol */
YY_RULE_SETUP
#line 334 "mealmaster.ll"
{
  line_no++;
  if (recipe.instructions().empty()) {
    if (ingredient_column)
      right_column.push_back(ingredient_);
    else
      recipe.add_ingredient(ingredient_);
    BEGIN(body);
  } else {
    error_message << "Stray ingredient in line " << line_no;
    BEGIN(error);
  };
  ingredient_column = 0;
  ingredient_ = Ingredient();
  buffer.clear();
}
	YY_BREAK
case 51:
YY_RULE_SETUP
#line 351 "mealmaster.ll"
{
  buffer += yytext;
  add_text_to_ingredient(yytext);
}
	YY_BREAK
case 52:
YY_RULE_SETUP
#line 355 "mealmaster.ll"
{
  buffer += yytext;
  if (buffer.length() == 41) {
    while (!recipe.ingredients().back().text().empty() && recipe.ingredients().back().text()[recipe.ingredients().back().text().length() - 1] == ' ') {
      std::string text = recipe.ingredients().back().text();
      recipe.ingredients().back().text() = text.substr(0, text.length() - 1);
    };
    ingredient_column = 1;
    buffer.clear();
    BEGIN(body);
  } else
    add_text_to_ingredient(" ");
}
	YY_BREAK
case 53:
/* rule 53 can match eol */
YY_RULE_SETUP
#line 368 "mealmaster.ll"
{
  line_no++;
  ingredient_ = Ingredient();
  buffer.clear();
  ingredient_column = 0;
  BEGIN(body);
}
	YY_BREAK
case 54:
/* rule 54 can match eol */
YY_RULE_SETUP
#line 376 "mealmaster.ll"
{
  line_no++;
  // Add a section to the ingredients or to the instructions.
  if (recipe.instructions().empty()) {
    if (!recipe.ingredient_sections().empty() && recipe.ingredient_sections().back().first == recipe.ingredients().size()) {
      error_message << "Empty ingredient section in line " << line_no;
      BEGIN(error);
    } else {
      recipe.add_ingredient_section(recipe.ingredients().size(), section.c_str());
      BEGIN(body);
    };
  } else {
    recipe.add_instruction_section(recipe.instructions().size(), section.c_str());
    recipe.add_instruction("");
    BEGIN(body);
  };
  newlines = 0;
  ingredient_ = Ingredient();
  buffer.clear();
}
	YY_BREAK
case 55:
YY_RULE_SETUP
#line 396 "mealmaster.ll"
{
  section += yytext;
}
	YY_BREAK
case 56:
YY_RULE_SETUP
#line 399 "mealmaster.ll"
{
  section += yytext;
}
	YY_BREAK
case 57:
YY_RULE_SETUP
#line 403 "mealmaster.ll"
{
  buffer += yytext;
}
	YY_BREAK
case 58:
YY_RULE_SETUP
#line 406 "mealmaster.ll"
{
  buffer += "    ";
}
	YY_BREAK
case 59:
/* rule 59 can match eol */
YY_RULE_SETUP
#line 409 "mealmaster.ll"
{
  line_no++;
  if (ingredient_column) {
    // Overlong ingredient line.
    recipe.ingredients().back().add_text(" ");
    recipe.ingredients().back().add_text(buffer.c_str());
  } else {
    // Remove up to two leading spaces.
    for (int i=0; i<2; i++) {
      if (!buffer.empty() && buffer[0] == ' ')
        buffer = buffer.substr(1, buffer.length() - 1);
    };
    // Remove trailing spaces.
    while (!buffer.empty() && buffer[buffer.length() - 1] == ' ')
      buffer = buffer.substr(0, buffer.length() - 1);
    bool force_newline;
    // A colon forces a new line.
    if (!buffer.empty() && buffer[0] == ':') {
      force_newline = true;
      buffer = buffer.substr(1, buffer.length() - 1);
    } else if (!buffer.empty() && buffer[0] == ' ') {
      force_newline = true;
    } else
      force_newline = false;
    if (newlines >= 1) {
      recipe.add_instruction("");
      recipe.add_instruction(buffer.c_str());
    } else
      if (recipe.instructions().size() && !force_newline)
        recipe.append_instruction(buffer.c_str());
      else
        recipe.add_instruction(buffer.c_str());
    if (!recipe.ingredient_sections().empty()) {
      std::pair<int, std::string> section = recipe.ingredient_sections().back();
      // If there is a section at the end of the ingredients, it needs to be moved into the list of instruction sections.
      if (section.first == recipe.ingredients().size()) {
        recipe.ingredient_sections().pop_back();
        recipe.add_instruction_section(0, section.second.c_str());
      };
    };
  };
  newlines = 0;
  ingredient_column = 0;
  ingredient_ = Ingredient();
  buffer.clear();
  BEGIN(body);
}
	YY_BREAK
case 60:
YY_RULE_SETUP
#line 457 "mealmaster.ll"

	YY_BREAK
case 61:
/* rule 61 can match eol */
YY_RULE_SETUP
#line 458 "mealmaster.ll"
{
  line_no++;
}
	YY_BREAK
case 62:
YY_RULE_SETUP
#line 462 "mealmaster.ll"

	YY_BREAK
case 63:
YY_RULE_SETUP
#line 464 "mealmaster.ll"
{
  error_message << "Problem in state " << YY_START << " and line " << line_no << ": unexpected character ";
  if (*yytext < ' ')
    error_message << "0x" << std::hex << (int)*yytext << std::dec;
  else
    error_message << "'" << *yytext << "'";
  BEGIN(error);
}
	YY_BREAK
case 64:
/* rule 64 can match eol */
YY_RULE_SETUP
#line 473 "mealmaster.ll"
{
  error_message << "Problem in state " << YY_START << " and line " << line_no << ": unexpected newline";
  BEGIN(error);
}
	YY_BREAK
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(title):
case YY_STATE_EOF(error):
case YY_STATE_EOF(titletext):
case YY_STATE_EOF(categories):
case YY_STATE_EOF(categoriestext):
case YY_STATE_EOF(servings):
case YY_STATE_EOF(servingsamount):
case YY_STATE_EOF(servingsunit):
case YY_STATE_EOF(body):
case YY_STATE_EOF(unit1):
case YY_STATE_EOF(unit2):
case YY_STATE_EOF(unit3):
case YY_STATE_EOF(ingredienttext):
case YY_STATE_EOF(amount):
case YY_STATE_EOF(amount2):
case YY_STATE_EOF(fraction):
case YY_STATE_EOF(ingredientcont):
case YY_STATE_EOF(sectionheader):
case YY_STATE_EOF(instructionstext):
#line 478 "mealmaster.ll"
{
  if (error_message.str().empty())
    error_message << "Unexpected end of file";
  return 1;
}
	YY_BREAK
case 65:
YY_RULE_SETUP
#line 483 "mealmaster.ll"
ECHO;
	YY_BREAK
#line 1764 "mealmaster.cc"

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - (yytext_ptr)) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = (yy_hold_char);
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * yylex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = yyin;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (yy_c_buf_p) <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			(yy_c_buf_p) = (yytext_ptr) + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = (yytext_ptr) + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++(yy_c_buf_p);
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = (yy_last_accepting_cpos);
				yy_current_state = (yy_last_accepting_state);
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(yy_did_buffer_switch_on_eof) = 0;

				if ( yywrap( ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					(yy_c_buf_p) = (yytext_ptr) + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(yy_c_buf_p) =
					(yytext_ptr) + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				(yy_c_buf_p) =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)];

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of user's declarations */
} /* end of yylex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (void)
{
    	char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	char *source = (yytext_ptr);
	yy_size_t number_to_move, i;
	int ret_val;

	if ( (yy_c_buf_p) > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (yy_c_buf_p) - (yytext_ptr) - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (yy_size_t) ((yy_c_buf_p) - (yytext_ptr)) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars) = 0;

	else
		{
			yy_size_t num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER_LVALUE;

			int yy_c_buf_p_offset =
				(int) ((yy_c_buf_p) - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				yy_size_t new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					yyrealloc((void *) b->yy_ch_buf,b->yy_buf_size + 2  );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = 0;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			(yy_c_buf_p) = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			(yy_n_chars), num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	if ( (yy_n_chars) == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			yyrestart(yyin  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if ((int) ((yy_n_chars) + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		int new_size = (yy_n_chars) + number_to_move + ((yy_n_chars) >> 1);
		YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *) yyrealloc((void *) YY_CURRENT_BUFFER_LVALUE->yy_ch_buf,new_size  );
		if ( ! YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in yy_get_next_buffer()" );
	}

	(yy_n_chars) += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] = YY_END_OF_BUFFER_CHAR;

	(yytext_ptr) = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (void)
{
	yy_state_type yy_current_state;
	char *yy_cp;
    
	yy_current_state = (yy_start);

	for ( yy_cp = (yytext_ptr) + YY_MORE_ADJ; yy_cp < (yy_c_buf_p); ++yy_cp )
		{
		YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			(yy_last_accepting_state) = yy_current_state;
			(yy_last_accepting_cpos) = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 275 )
				yy_c = yy_meta[(unsigned int) yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state )
{
	int yy_is_jam;
    	char *yy_cp = (yy_c_buf_p);

	YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		(yy_last_accepting_state) = yy_current_state;
		(yy_last_accepting_cpos) = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 275 )
			yy_c = yy_meta[(unsigned int) yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
	yy_is_jam = (yy_current_state == 274);

		return yy_is_jam ? 0 : yy_current_state;
}

#ifndef YY_NO_UNPUT

    static void yyunput (int c, char * yy_bp )
{
	char *yy_cp;
    
    yy_cp = (yy_c_buf_p);

	/* undo effects of setting up yytext */
	*yy_cp = (yy_hold_char);

	if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
		{ /* need to shift things up to make room */
		/* +2 for EOB chars. */
		yy_size_t number_to_move = (yy_n_chars) + 2;
		char *dest = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[
					YY_CURRENT_BUFFER_LVALUE->yy_buf_size + 2];
		char *source =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move];

		while ( source > YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			*--dest = *--source;

		yy_cp += (int) (dest - source);
		yy_bp += (int) (dest - source);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars =
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_buf_size;

		if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
			YY_FATAL_ERROR( "flex scanner push-back overflow" );
		}

	*--yy_cp = (char) c;

	(yytext_ptr) = yy_bp;
	(yy_hold_char) = *yy_cp;
	(yy_c_buf_p) = yy_cp;
}

#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (void)
#else
    static int input  (void)
#endif

{
	int c;
    
	*(yy_c_buf_p) = (yy_hold_char);

	if ( *(yy_c_buf_p) == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( (yy_c_buf_p) < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			/* This was really a NUL. */
			*(yy_c_buf_p) = '\0';

		else
			{ /* need more input */
			yy_size_t offset = (yy_c_buf_p) - (yytext_ptr);
			++(yy_c_buf_p);

			switch ( yy_get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					yyrestart(yyin );

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( yywrap( ) )
						return EOF;

					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(yy_c_buf_p) = (yytext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (yy_c_buf_p);	/* cast for 8-bit char's */
	*(yy_c_buf_p) = '\0';	/* preserve yytext */
	(yy_hold_char) = *++(yy_c_buf_p);

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * 
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void yyrestart  (FILE * input_file )
{
    
	if ( ! YY_CURRENT_BUFFER ){
        yyensure_buffer_stack ();
		YY_CURRENT_BUFFER_LVALUE =
            yy_create_buffer(yyin,YY_BUF_SIZE );
	}

	yy_init_buffer(YY_CURRENT_BUFFER,input_file );
	yy_load_buffer_state( );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * 
 */
    void yy_switch_to_buffer  (YY_BUFFER_STATE  new_buffer )
{
    
	/* TODO. We should be able to replace this entire function body
	 * with
	 *		yypop_buffer_state();
	 *		yypush_buffer_state(new_buffer);
     */
	yyensure_buffer_stack ();
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	yy_load_buffer_state( );

	/* We don't actually know whether we did this switch during
	 * EOF (yywrap()) processing, but the only time this flag
	 * is looked at is after yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(yy_did_buffer_switch_on_eof) = 1;
}

static void yy_load_buffer_state  (void)
{
    	(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	(yytext_ptr) = (yy_c_buf_p) = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	yyin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	(yy_hold_char) = *(yy_c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * 
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE yy_create_buffer  (FILE * file, int  size )
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) yyalloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_buf_size = (yy_size_t)size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) yyalloc(b->yy_buf_size + 2  );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	yy_init_buffer(b,file );

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with yy_create_buffer()
 * 
 */
    void yy_delete_buffer (YY_BUFFER_STATE  b )
{
    
	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		yyfree((void *) b->yy_ch_buf  );

	yyfree((void *) b  );
}

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a yyrestart() or at EOF.
 */
    static void yy_init_buffer  (YY_BUFFER_STATE  b, FILE * file )

{
	int oerrno = errno;
    
	yy_flush_buffer(b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then yy_init_buffer was _probably_
     * called from yyrestart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * 
 */
    void yy_flush_buffer (YY_BUFFER_STATE  b )
{
    	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		yy_load_buffer_state( );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  
 */
void yypush_buffer_state (YY_BUFFER_STATE new_buffer )
{
    	if (new_buffer == NULL)
		return;

	yyensure_buffer_stack();

	/* This block is copied from yy_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		(yy_buffer_stack_top)++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from yy_switch_to_buffer. */
	yy_load_buffer_state( );
	(yy_did_buffer_switch_on_eof) = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  
 */
void yypop_buffer_state (void)
{
    	if (!YY_CURRENT_BUFFER)
		return;

	yy_delete_buffer(YY_CURRENT_BUFFER );
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if ((yy_buffer_stack_top) > 0)
		--(yy_buffer_stack_top);

	if (YY_CURRENT_BUFFER) {
		yy_load_buffer_state( );
		(yy_did_buffer_switch_on_eof) = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void yyensure_buffer_stack (void)
{
	yy_size_t num_to_alloc;
    
	if (!(yy_buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
		num_to_alloc = 1; /* After all that talk, this was set to 1 anyways... */
		(yy_buffer_stack) = (struct yy_buffer_state**)yyalloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );
								  
		memset((yy_buffer_stack), 0, num_to_alloc * sizeof(struct yy_buffer_state*));
				
		(yy_buffer_stack_max) = num_to_alloc;
		(yy_buffer_stack_top) = 0;
		return;
	}

	if ((yy_buffer_stack_top) >= ((yy_buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		yy_size_t grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (yy_buffer_stack_max) + grow_size;
		(yy_buffer_stack) = (struct yy_buffer_state**)yyrealloc
								((yy_buffer_stack),
								num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset((yy_buffer_stack) + (yy_buffer_stack_max), 0, grow_size * sizeof(struct yy_buffer_state*));
		(yy_buffer_stack_max) = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * 
 * @return the newly allocated buffer state object. 
 */
YY_BUFFER_STATE yy_scan_buffer  (char * base, yy_size_t  size )
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) yyalloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_buffer()" );

	b->yy_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = 0;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	yy_switch_to_buffer(b  );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to yylex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 * 
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       yy_scan_bytes() instead.
 */
YY_BUFFER_STATE yy_scan_string (yyconst char * yystr )
{
    
	return yy_scan_bytes(yystr,strlen(yystr) );
}

/** Setup the input buffer state to scan the given bytes. The next call to yylex() will
 * scan from a @e copy of @a bytes.
 * @param yybytes the byte buffer to scan
 * @param _yybytes_len the number of bytes in the buffer pointed to by @a bytes.
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_bytes  (yyconst char * yybytes, yy_size_t  _yybytes_len )
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	yy_size_t i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = _yybytes_len + 2;
	buf = (char *) yyalloc(n  );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = yy_scan_buffer(buf,n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in yy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yy_fatal_error (yyconst char* msg )
{
			(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		yytext[yyleng] = (yy_hold_char); \
		(yy_c_buf_p) = yytext + yyless_macro_arg; \
		(yy_hold_char) = *(yy_c_buf_p); \
		*(yy_c_buf_p) = '\0'; \
		yyleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the current line number.
 * 
 */
int yyget_lineno  (void)
{
        
    return yylineno;
}

/** Get the input stream.
 * 
 */
FILE *yyget_in  (void)
{
        return yyin;
}

/** Get the output stream.
 * 
 */
FILE *yyget_out  (void)
{
        return yyout;
}

/** Get the length of the current token.
 * 
 */
yy_size_t yyget_leng  (void)
{
        return yyleng;
}

/** Get the current token.
 * 
 */

char *yyget_text  (void)
{
        return yytext;
}

/** Set the current line number.
 * @param _line_number line number
 * 
 */
void yyset_lineno (int  _line_number )
{
    
    yylineno = _line_number;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param _in_str A readable stream.
 * 
 * @see yy_switch_to_buffer
 */
void yyset_in (FILE *  _in_str )
{
        yyin = _in_str ;
}

void yyset_out (FILE *  _out_str )
{
        yyout = _out_str ;
}

int yyget_debug  (void)
{
        return yy_flex_debug;
}

void yyset_debug (int  _bdebug )
{
        yy_flex_debug = _bdebug ;
}

static int yy_init_globals (void)
{
        /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from yylex_destroy(), so don't allocate here.
     */

    (yy_buffer_stack) = 0;
    (yy_buffer_stack_top) = 0;
    (yy_buffer_stack_max) = 0;
    (yy_c_buf_p) = (char *) 0;
    (yy_init) = 0;
    (yy_start) = 0;

/* Defined in main.c */
#ifdef YY_STDINIT
    yyin = stdin;
    yyout = stdout;
#else
    yyin = (FILE *) 0;
    yyout = (FILE *) 0;
#endif

    /* For future reference: Set errno on error, since we are called by
     * yylex_init()
     */
    return 0;
}

/* yylex_destroy is for both reentrant and non-reentrant scanners. */
int yylex_destroy  (void)
{
    
    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		yy_delete_buffer(YY_CURRENT_BUFFER  );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		yypop_buffer_state();
	}

	/* Destroy the stack itself. */
	yyfree((yy_buffer_stack) );
	(yy_buffer_stack) = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * yylex() is called, initialization will occur. */
    yy_init_globals( );

    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, yyconst char * s2, int n )
{
		
	int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * s )
{
	int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *yyalloc (yy_size_t  size )
{
			return (void *) malloc( size );
}

void *yyrealloc  (void * ptr, yy_size_t  size )
{
		
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
}

void yyfree (void * ptr )
{
			free( (char *) ptr );	/* see yyrealloc() for (char *) cast */
}

#define YYTABLES_NAME "yytables"

#line 483 "mealmaster.ll"



