/*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*\

File:		octapi_largmath.h

Copyright (c) 2001 Octasic Inc. All rights reserved.
    
Description: 

This source code is Octasic Confidential. Use of and access to this code
is covered by the Octasic Device Enabling Software License Agreement. 
Acknowledgement of the Octasic Device Enabling Software License was 
required for access to this code. A copy was also provided with the release.


$Octasic_Release: OCT610xAPI-01.00-PR37 $

$Octasic_Revision: 5 $

\*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/
#ifndef __OCTAPI_LARGMATH_H__
#define __OCTAPI_LARGMATH_H__



#include "octdef.h"



#define OCTAPI_LM_DIVISION_BY_ZERO 0xFFFF
#define OCTAPI_LM_OVERFLOW 0xFFFE
#define OCTAPI_LM_ARRAY_SIZE_MISMATCH 0xFFFD

#define OCTAPI_LM_MAX_OPTIMIZE_MUL 10

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus*/

#define octapi_lm_add( a, alen, b, blen, z,  zlen)					OctApiLmAdd( (PUINT32) a, (USHORT) alen, (PUINT32) b, (USHORT) blen, (PUINT32) z, (USHORT) zlen )
#define octapi_lm_subtract( a, alen, bneg, blen, z,  zlen, neg)		OctApiLmSubtract( (PUINT32) a, (USHORT) alen, (PUINT32) bneg, (USHORT) blen, (PUINT32) z, (USHORT) zlen, (USHORT*) neg )
#define octapi_lm_compare( a, alen, bneg, blen, neg)				OctApiLmCompare( (PUINT32) a, (USHORT) alen, (PUINT32) bneg, (USHORT) blen, (USHORT*) neg )
#define octapi_lm_multiply( a, b, ablen, z)							OctApiLmMultiply( (PUINT32) a, (PUINT32) b, (USHORT) ablen, (PUINT32) z )
#define octapi_lm_divide( n, d, q, r, ndqrlen)						OctApiLmDivide( (PUINT32) n, (PUINT32) d, (PUINT32) q, (PUINT32) r, (USHORT) ndqrlen )
#define octapi_lm_shiftright1( a, alen)								OctApiLmShiftRight1( (PUINT32) a, (USHORT) alen )
#define octapi_lm_shiftn( a, alen, shiftleft, shiftn)				OctApiLmShiftn( (PUINT32) a, (USHORT) alen, (USHORT) shiftleft, (USHORT) shiftn )
#define octapi_lm_getmsb( a, alen, msb_pos)							OctApiLmGetMsb( (PUINT32) a, (USHORT) alen, (USHORT*) msb_pos )
	

static UINT32 OctApiLmAdd( PUINT32 a, USHORT alen, PUINT32 b, USHORT blen, PUINT32 z, USHORT zlen );
static UINT32 OctApiLmSubtract( PUINT32 a, USHORT alen, PUINT32 bneg, USHORT blen, PUINT32 z, USHORT zlen, PUSHORT neg );
UINT32 OctApiLmCompare( PUINT32 a, USHORT alen, PUINT32 bneg, USHORT blen, PUSHORT neg );
UINT32 OctApiLmMultiply( PUINT32 a, PUINT32 b, USHORT ablen, PUINT32 z );
UINT32 OctApiLmDivide( PUINT32 n, PUINT32 d, PUINT32 q, PUINT32 r, USHORT ndqrlen );
UINT32 OctApiLmShiftRight1( PUINT32 a, USHORT alen );
UINT32 OctApiLmShiftn( PUINT32 a, USHORT alen, USHORT shiftleft, USHORT shiftn );
UINT32 OctApiLmGetMsb( PUINT32 a, USHORT alen, PUSHORT msb_pos );

#ifdef __cplusplus
}
#endif /* __cplusplus*/

#endif /*__OCTAPI_LARGMATH_H__*/
