# -*- coding: utf-8 -*-
##############################################################################
#
# Copyright (c) 2006 TINY SPRL. (http://tiny.be) All Rights Reserved.
#
# WARNING: This program as such is intended to be used by professional
# programmers who take the whole responsability of assessing all potential
# consequences resulting from its eventual inadequacies and bugs
# End users who are looking for a ready-to-use solution with commercial
# garantees and support are strongly adviced to contract a Free Software
# Service Company
#
# This program is Free Software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
##############################################################################

import time
from report import report_sxw
from osv import osv

class order(report_sxw.rml_parse):
	def __init__(self, cr, uid, context):
		super(order, self).__init__(cr, uid, context)
		self.localcontext.update({
			'time': time,
			'get_line_tax': self._get_line_tax,
		})
	def _get_line_tax(self, line_obj):
		self.cr.execute("SELECT tax_id FROM sale_order_tax WHERE order_line_id=%d" % (line_obj.id))
		res = self.cr.fetchall() or None
		if not res:
			return ""
		if isinstance(res, list):
			tax_ids = [t[0] for t in res]
		else:
			tax_ids = res[0]
		res = [tax.name for tax in osv.osv_pools.get('account.tax').browse(self.cr, self.uid, tax_ids)]
		return ",\n ".join(res)

report_sxw.report_sxw('report.sale.order','sale.order','addons/sale/report/order.rml',parser=order)
