##############################################################################
#
# Copyright (c) 2006 TINY SPRL. (http://tiny.be) All Rights Reserved.
#
# $Id: used_in.py 2579 2006-03-30 15:51:04Z ged $
#
# WARNING: This program as such is intended to be used by professional
# programmers who take the whole responsability of assessing all potential
# consequences resulting from its eventual inadequacies and bugs
# End users who are looking for a ready-to-use solution with commercial
# garantees and support are strongly adviced to contract a Free Software
# Service Company
#
# This program is Free Software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
##############################################################################

import sql_db
from osv.osv import osv_pools
from report.interface import report_rml


class report_custom(report_rml):
	def __init__(self, name, table, tmpl, xsl):
		report_rml.__init__(self, name, table, tmpl, xsl)

	def create_xml(self, uid, ids, datas, context={}):
		datas.setdefault('form', {})
		cr = sql_db.db.cursor()
		bom_table = osv_pools.get('mrp.bom')
		boms = bom_table.search(cr, uid, [('product_id', '=', ids[0])])
		used_in = boms
		for bom in bom_table.browse(cr, uid, boms):
			starting_bom = bom
			while starting_bom.bom_id:
				if starting_bom.bom_id.id not in used_in:
					used_in.append(starting_bom.bom_id.id)
				starting_bom = starting_bom.bom_id
		datas['form']['used_in'] = bom_table.browse(cr, uid, used_in)
		cr.close()
		return super(report_custom, self).create_xml(uid, ids, datas, context)

report_custom('report.mrp.product.used_in', 'product.product', 'addons/mrp/report/used_in.xml', 'addons/mrp/report/used_in.xsl')
