#!/bin/sh
# @(#)oarch.sh  1.9 05/07/28 Copyright 2005 J. Schilling
###########################################################################
# Written 2005 by J. Schilling
###########################################################################
# A simulation of $(OARCH) from the Schily Makefile system
###########################################################################
# The contents of this file are subject to the terms of the
# Common Development and Distribution License, Version 1.0 only.
# (the "License").  You may not use this file except in compliance
# with the License.
#
# See the file CDDL.Schily.txt in this distribution for details.
#
# When distributing Covered Code, include this CDDL HEADER in each
# file and include the License file CDDL.Schily.txt from this distribution.
###########################################################################

cflag=FALSE
oflag=FALSE
pflag=FALSE
if [ .$1 = .-c ]; then
	cflag=TRUE
fi
if [ .$1 = .-o ]; then
	oflag=TRUE
fi
if [ .$1 = .-p ]; then
	pflag=TRUE
fi

MACHCMD="((mach || uname -p || true)		2> /dev/null)"
ARCHCMD="((arch || /usr/ucb/arch || true)	2> /dev/null)"

XP_ARCH=`eval ${MACHCMD} | tr '[A-Z]' '[a-z]' | tr ', /\\()"' ',//////' | tr ',/' ',\-'`
XK_ARCH=`uname -m    | tr '[A-Z]' '[a-z]' | tr ', /\\()"' ',//////' | tr ',/' ',\-'`
XM_ARCH=`eval ${ARCHCMD} | tr '[A-Z]' '[a-z]' | tr ', /\\()"' ',//////' | tr ',/' ',\-'`

#echo XP_ARCH $XP_ARCH
#echo XK_ARCH $XK_ARCH
#echo XM_ARCH $XM_ARCH

P_ARCH="${XP_ARCH}"
K_ARCH="${XK_ARCH}"
M_ARCH="${XM_ARCH}"

if [ ."$XP_ARCH" = .unknown ]; then
	P_ARCH="${K_ARCH}"
fi
if [ ."$XP_ARCH" = . ]; then
	P_ARCH="${K_ARCH}"
fi

if [ ."${XM_ARCH}" = . ]; then
	M_ARCH="${K_ARCH}"
fi

OSNAME=`uname -s | tr '[A-Z]' '[a-z]' | tr ', /\\()"' ',//////' | tr ',/' ',\-'`
OSREL=`uname -r | tr '[A-Z]' '[a-z]' | tr ', /\\()"' ',//////' | tr ',/' ',\-'`

O_ARCH="$OSNAME"

case "$OSREL" in
	cygwin*) O_ARCH=cygwin32_nt;;
esac
if [ ."$OSNAME" = .bsd-os ]; then
	case "$OSREL" in
		3.*)	O_ARCH=bsd-os3;;
		4.*)	O_ARCH=bsd-os;;
	esac
fi
if [ ."$OSNAME" = .bsd-os ]; then
	case "$OSREL" in
		3.*)	O_ARCH=bsd-os3;;
		4.*)	O_ARCH=bsd-os;;
	esac
fi
if [ ."$OSNAME" = .dgux ]; then
	case "$OSREL" in
		r4.*)	O_ARCH=dgux4;;
		5.4r3*)	O_ARCH=dgux3;;
	esac
fi
if [ ."$OSNAME" = .irix64 ]; then
	O_ARCH=irix
fi
if [ ."$OSNAME" = .mac-os ]; then
	case "$OSREL" in
		9.*)	O_ARCH=mac-os9;;
		10.*)	O_ARCH=mac-os10;;
	esac
fi
case "$OSREL" in
	mingw*) O_ARCH= mingw32_nt;;
esac
if [ ."$OSNAME" = .newsos ]; then
	case "$OSREL" in
		5.*)	O_ARCH=newsos5;;
		6.*)	O_ARCH=newsos6;;
	esac
fi
if [ ."$OSNAME" = .openunix ]; then
	O_ARCH=unixware
fi
if [ ."$OSNAME" = .os-2 ]; then
	O_ARCH=os2
fi
if [ ."$OSNAME" = .sco_sv ]; then
	O_ARCH=openserver
fi
if [ ."$OSNAME" = .sunos ]; then
	case "$OSREL" in
		4.*)	O_ARCH=sunos4;;
		5.*)	O_ARCH=sunos5;;
	esac
fi
if [ ."$OSNAME" = .unix_sv ]; then
	O_ARCH=unixware
fi

MARCH="$M_ARCH"
if [ ."$ARCH" != . ]; then
	MARCH="$ARCH"
fi

PARCH="$P_ARCH"
if [ ."$ARCH" != . ]; then
	PARCH="$ARCH"
fi

confdir=
if [ -z "$confdir" ]; then
	#
	# Try the directory containing this script.
	#
	prog=$0 
	confdir=`echo $prog|sed 's,/[^/][^/]*$,,'` 
	test ".$confdir" = ".$prog" && confdir=. 
	confdir=$confdir
fi 

CC="`grep '^DEFCCOM' $confdir/../incs/Dcc.${PARCH}-${O_ARCH} 2>/dev/null | sed -e 's,^DEFCCOM=[      ]*,,'`"
if [ ".$CC" = . ]; then
	CC="`grep '^DEFCCOM' $confdir/../DEFAULTS/Defaults.${O_ARCH} 2>/dev/null | sed -e 's,^DEFCCOM=[ 	]*,,'`"
fi
if [ ".$CC" = . ]; then
	CC=cc
fi

C_ARCH="`sh $confdir/../conf/cc-config.sh -echo $CC ${O_ARCH}`"

OARCH="${PARCH}-${O_ARCH}-${C_ARCH}"

#echo
#echo P_ARCH $P_ARCH
#echo K_ARCH $K_ARCH
#echo M_ARCH $M_ARCH
#echo OSNAME $OSNAME
#echo OSREL  $OSREL
#echo OARCH  "$OARCH"

if [ $cflag = TRUE ]; then
	echo "${C_ARCH}"
	exit
fi
if [ $oflag = TRUE ]; then
	echo "${O_ARCH}"
	exit
fi
if [ $pflag = TRUE ]; then
	echo "${PARCH}"
	exit
fi
echo "$OARCH"
