/***************************************************************************
 $RCSfile$
                             -------------------
    cvs         : $Id$
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/



#ifdef HAVE_CONFIG_H
# include <config.h>
#endif


#define COLUMN_EMPTY                0
#define COLUMN_LOCAL_BANKCODE       1
#define COLUMN_LOCAL_ACCOUNTNUMBER  2
#define COLUMN_LOCAL_NAME           3
#define COLUMN_REMOTE_BANKCODE      4
#define COLUMN_REMOTE_ACCOUNTNUMBER 5
#define COLUMN_REMOTE_NAME          6
#define COLUMN_UNIQUE_ID            7
#define COLUMN_VALUTA_DATE          8
#define COLUMN_DATE                 9
#define COLUMN_VALUE                10
#define COLUMN_CUST_REF             11
#define COLUMN_BANK_REF             12
#define COLUMN_PRIMANOTA            13
#define COLUMN_REMOTE_NAME_PURPOSE  14
#define COLUMN_CATEGORY             15
#define COLUMN_PURPOSE              16

#define COLUMN_LOCAL_ACCOUNT        17
#define COLUMN_REMOTE_ACCOUNT       18

#define COLUMN_PAYEE                19

#include "kbanking.h"
#include "simplereport.h"
#include "editsimplereport.h"
#include "transfinder.h"
#include "transaction.h"
#include "account.h"

#include <gwenhywfar/gui.h>

#include <qwidget.h>
#include <qstring.h>
#include <qwidget.h>

#define I18N_NOOP(msg) msg



SimpleReport::SimpleReport(KBanking *app)
:Report(app, QString("SimpleReport")){


}



SimpleReport::~SimpleReport(){
}



QString SimpleReport::shortDescription(){
  return QWidget::tr("Simple transaction reports");
}



QString SimpleReport::longDescription(){
  return QWidget::tr
    (
     "<qt>"
     "This module allows creating of simple transaction reports."
     "</qt>"
    );
}



bool SimpleReport::initProfile(GWEN_DB_NODE *dbProfile, QWidget *parent){
  EditSimpleReport w(app(), dbProfile, parent);

  w.setCaption(QWidget::tr("Create new profile"));
  if (w.exec()!=QDialog::Accepted)
    return false;

  return true;
}



bool SimpleReport::editProfile(GWEN_DB_NODE *dbProfile, QWidget *parent){
  EditSimpleReport w(app(), dbProfile, parent);

  w.setCaption(QWidget::tr("Edit profile"));
  if (w.exec()!=QDialog::Accepted)
    return false;

  return true;
}




QString SimpleReport::handleTransaction(GWEN_DB_NODE *dbProfile,
                                        QWidget *parent,
                                        RefPointer<Transaction> t) {
  QString qs;
  std::string s;

  // handle transactions
  int i;

  qs="<tr>";

  for (i=0; ; i++) {
    const std::list<std::string> sl;
    std::list<std::string>::const_iterator sit;
    const GWEN_TIME *ti;
    const AB_VALUE *v;
    int j, k;

    j=GWEN_DB_GetIntValue(dbProfile, "column", i, 0);
    if (!j)
      break;
    switch(j) {
    case COLUMN_LOCAL_BANKCODE:
      qs+="<td>";
      qs+=QString::fromUtf8(t.ref().getLocalBankCode().c_str());
      break;

    case COLUMN_LOCAL_ACCOUNTNUMBER:
      qs+="<td>";
      qs+=QString::fromUtf8(t.ref().getLocalAccountNumber().c_str());
      break;

    case COLUMN_LOCAL_NAME:
      qs+="<td>";
      qs+=QString::fromUtf8(t.ref().getLocalName().c_str());
      break;

    case COLUMN_REMOTE_BANKCODE:
      qs+="<td>";
      qs+=QString::fromUtf8(t.ref().getRemoteBankCode().c_str());
      break;

    case COLUMN_REMOTE_ACCOUNTNUMBER:
      qs+="<td>";
      qs+=QString::fromUtf8(t.ref().getRemoteAccountNumber().c_str());
      break;

    case COLUMN_REMOTE_NAME:
      qs+="<td>";
      k=0;
      for (sit=t.ref().getRemoteName().begin();
           sit!=t.ref().getRemoteName().end();
           sit++) {
        if (k++)
          qs+="<br>";
        qs+=QString::fromUtf8((*sit).c_str());
      }
      break;

    case COLUMN_UNIQUE_ID:
      qs+="<td>";
      qs+=QString::number(t.ref().getTransactionId());
      break;

    case COLUMN_VALUTA_DATE:
      qs+="<td>";
      ti=t.ref().getValutaDate();
      if (ti) {
        GWEN_BUFFER *tbuf;

        tbuf=GWEN_Buffer_new(0, 32, 0, 1);
        if (!GWEN_Time_toString(ti,
                                tr("YYYY/MM/DD").latin1(),
                                tbuf)) {
          qs+=QString::fromUtf8(GWEN_Buffer_GetStart(tbuf));
        }
        GWEN_Buffer_free(tbuf);
      }
      break;

    case COLUMN_DATE:
      qs+="<td>";
      ti=t.ref().getDate();
      if (ti) {
        GWEN_BUFFER *tbuf;

        tbuf=GWEN_Buffer_new(0, 32, 0, 1);
        if (!GWEN_Time_toString(ti,
                                tr("YYYY/MM/DD").latin1(),
                                tbuf)) {
          qs+=QString::fromUtf8(GWEN_Buffer_GetStart(tbuf));
        }
        GWEN_Buffer_free(tbuf);
      }
      break;

    case COLUMN_VALUE:
      qs+="<td align=\"right\">";
      v=t.ref().getValue();
      if (v) {
        char numbuf[32];

        if (GWEN_DB_GetIntValue(dbProfile, "useColours", 0, 0)) {
	  if (AB_Value_IsPositive(v))
            qs+="<font color=\"dark green\">";
          else
            qs+="<font color=red>";
        }
#if !defined(__GNUC__) && defined(WIN32)
        // This is MSVC compiler which doesnt have snprintf()
        sprintf(numbuf, "%.2lf", AB_Value_GetValueAsDouble(v));
#else
	snprintf(numbuf, sizeof(numbuf), "%.2lf",
		 AB_Value_GetValueAsDouble(v));
#endif
        qs+=numbuf;
        qs+=" ";
        qs+=AB_Value_GetCurrency(v);
        if (GWEN_DB_GetIntValue(dbProfile, "useColours", 0, 0))
          qs+="</font>";
      }
      break;

    case COLUMN_CUST_REF:
      qs+="<td>";
      qs+=QString::fromUtf8(t.ref().getCustomerReference().c_str());
      break;

    case COLUMN_BANK_REF:
      qs+="<td>";
      qs+=QString::fromUtf8(t.ref().getBankReference().c_str());
      break;

    case COLUMN_PRIMANOTA:
      qs+="<td>";
      qs+=QString::fromUtf8(t.ref().getPrimanota().c_str());
      break;

    case COLUMN_REMOTE_NAME_PURPOSE:
      qs+="<td>";
      k=0;
      for (sit=t.ref().getRemoteName().begin();
           sit!=t.ref().getRemoteName().end();
           sit++) {
        if (k++)
          qs+="<br>";
        qs+=QString::fromUtf8((*sit).c_str());
      }
      if (k)
        qs+="<br>";
      for (sit=t.ref().getPurpose().begin();
           sit!=t.ref().getPurpose().end();
           sit++) {
        if (k++)
          qs+="<br>";
        qs+=QString::fromUtf8((*sit).c_str());
      }
      break;

    case COLUMN_CATEGORY:
      qs+="<td>";
      qs+=QString::fromUtf8(t.ref().getCategory().c_str());
      break;

    case COLUMN_PURPOSE:
      qs+="<td>";
      k=0;
      for (sit=t.ref().getPurpose().begin();
           sit!=t.ref().getPurpose().end();
           sit++) {
        if (k++)
          qs+="<br>";
        qs+=QString::fromUtf8((*sit).c_str());
      }
      break;


    case COLUMN_LOCAL_ACCOUNT:
      qs+="<td>";
      qs+=QString::fromUtf8(t.ref().getLocalBankCode().c_str());
      qs+="<br>";
      qs+=QString::fromUtf8(t.ref().getLocalAccountNumber().c_str());
      break;

    case COLUMN_REMOTE_ACCOUNT:
      qs+="<td>";
      qs+=QString::fromUtf8(t.ref().getRemoteBankCode().c_str());
      qs+="<br>";
      qs+=QString::fromUtf8(t.ref().getRemoteAccountNumber().c_str());
      break;

    case COLUMN_PAYEE:
      qs+="<td>";
      s=t.ref().getPayee();
      if (!s.empty()) {
        Payee *p;

        p=app()->findPayeeById(s.c_str());
        if (p)
          qs+=QString::fromUtf8(p->name().c_str());
      }
      break;

    case COLUMN_EMPTY:
    default:
      qs+="<td>";
      break;
    } // switch
    qs+="</td>";
  } // for

  qs+="</tr>\n";

  return qs;
}



QString SimpleReport::handleMonth(GWEN_DB_NODE *dbProfile,
                                  QWidget *parent,
                                  Report::Month *m){
  QString qs;
  int i;
  std::list<RefPointer<Transaction> > tl;
  std::list<RefPointer<Transaction> >::iterator it;
  const char *monthNames[12]={
    I18N_NOOP("January"), I18N_NOOP("February"), I18N_NOOP("March"),
    I18N_NOOP("April"), I18N_NOOP("May"), I18N_NOOP("June"),
    I18N_NOOP("July"), I18N_NOOP("August"), I18N_NOOP("September"),
    I18N_NOOP("October"), I18N_NOOP("November"), I18N_NOOP("December")};

  qs=tr("<h3>Transactions for %1 %2</h3>\n")
    .arg(tr(monthNames[m->getMonth()]))
    .arg(m->getYear());

  if (GWEN_DB_GetIntValue(dbProfile, "border", 0, 0))
    qs+=tr("<table border=\"1\">\n");
  else
    qs+=tr("<table>\n");
  qs+=tr("<tr>");

  for (i=0; ; i++) {
    int j;

    j=GWEN_DB_GetIntValue(dbProfile, "column", i, 0);
    if (!j)
      break;
    qs+="<th align=\"center\">";
    switch(j) {
    case COLUMN_LOCAL_BANKCODE:       qs+=tr("Local<br>Bank"); break;
    case COLUMN_LOCAL_ACCOUNTNUMBER:  qs+=tr("Local<br>Account"); break;
    case COLUMN_LOCAL_NAME:           qs+=tr("Local<br>Name"); break;
    case COLUMN_REMOTE_BANKCODE:      qs+=tr("Remote<br>Bank"); break;
    case COLUMN_REMOTE_ACCOUNTNUMBER: qs+=tr("Remote<br>Account"); break;
    case COLUMN_REMOTE_NAME:          qs+=tr("Remote<br>Name"); break;
    case COLUMN_UNIQUE_ID:            qs+=tr("Unique<br>Id"); break;
    case COLUMN_VALUTA_DATE:          qs+=tr("Valuta<br>Date"); break;
    case COLUMN_DATE:                 qs+=tr("Date"); break;
    case COLUMN_VALUE:                qs+=tr("Value"); break;
    case COLUMN_CUST_REF:             qs+=tr("Customer<br>Reference"); break;
    case COLUMN_BANK_REF:             qs+=tr("Bank<br>Reference"); break;
    case COLUMN_PRIMANOTA:            qs+=tr("Primanota"); break;
    case COLUMN_REMOTE_NAME_PURPOSE:  qs+=tr("Remote Name<br>Purpose"); break;
    case COLUMN_CATEGORY:             qs+=tr("Category"); break;
    case COLUMN_PURPOSE:              qs+=tr("Purpose"); break;
    case COLUMN_LOCAL_ACCOUNT:        qs+=tr("Local<br>Account"); break;
    case COLUMN_REMOTE_ACCOUNT:       qs+=tr("Remote<br>Account"); break;
    case COLUMN_PAYEE:                qs+=tr("Payee"); break;
    case COLUMN_EMPTY:
    default:
      break;
    } // switch
    qs+="</th>";
  } // for
  qs+="</tr>\n";

  // handle transactions
  m->gatherTransactions(tl);
  sortTransactions(tl);
  for (it=tl.begin(); it!=tl.end(); it++) {
    qs+=handleTransaction(dbProfile, parent, *it);
  }

  qs+="</table>";

  return qs;
}



QString SimpleReport::handleAccount(GWEN_DB_NODE *dbProfile,
                                    QWidget *parent,
                                    Report::AccountData *ad){
  Account *a;
  std::string bankName;
  std::string accountName;
  QString qs;
  std::list<Year*>::iterator yit;
  std::list<RefPointer<Transaction> >::iterator it;

  a=ad->getAccount();
  if (GWEN_DB_GetIntValue(dbProfile, "useAccountName", 0, 0)) {
    if (!(a->getAccountName().empty()))
      accountName=a->getAccountName();
  }
  if (GWEN_DB_GetIntValue(dbProfile, "useBankName", 0, 0)) {
    if (!(a->getBankName().empty()))
      bankName=a->getBankName();
  }

  qs=tr("<h2>Transaction Report for Account <i>%1</i> at <i>%2</i> </h2>\n")
    .arg(QString::fromUtf8(accountName.c_str()))
    .arg(QString::fromUtf8(bankName.c_str()));

  if (GWEN_DB_GetIntValue(dbProfile, "showBalance", 0, 0)) {
    const AB_ACCOUNT_STATUS *ast;

    ast=a->getAccountStatus();
    if (ast) {
      const AB_BALANCE *bb;

      bb=AB_AccountStatus_GetBookedBalance(ast);
      if (bb) {
        const GWEN_TIME *ti;

        ti=AB_Balance_GetTime(bb);
        if (ti) {
          const AB_VALUE *val;

          val=AB_Balance_GetValue(bb);
          if (val) {
            GWEN_BUFFER *tbuf;
            const char *currency;

            // now we have all we need for a balance statement
            currency=AB_Value_GetCurrency(val);
            if (!currency)
              currency="EUR";
            tbuf=GWEN_Buffer_new(0, 32, 0, 1);
            GWEN_Time_toString(ti,
                               tr("YYYY/MM/DD (hh:mm)").latin1(),
                               tbuf);
            qs+=tr("<b>Account balance</b> on %1: %2 %3<br>\n")
	      .arg(QString::fromUtf8(GWEN_Buffer_GetStart(tbuf)))
              .arg(AB_Value_GetValueAsDouble(val), 10, 'f', 2)
              .arg(QString::fromUtf8(currency));
          }
        }
      }
    }
  } // if showBalance

  qs+="<br>";


  for (yit=ad->years().begin();
       yit!=ad->years().end();
       yit++) {
    std::list<Month*>::iterator mit;

    for (mit=(*yit)->months().begin();
         mit!=(*yit)->months().end();
         mit++) {
      qs+=handleMonth(dbProfile, parent, *mit);
    }
  } // for

  return qs;
}



bool SimpleReport::useProfile(GWEN_DB_NODE *dbProfile, QWidget *parent){
  QString qs;
  std::list<RefPointer<Transaction> > tl;
  std::list<RefPointer<Transaction> >::iterator it;
  std::list<AccountData*> adl;
  std::list<AccountData*>::iterator ait;
  RefPointer<Transaction> t;

  TransactionFinder tf(app(),
                       app()->getTransactionMatcherRules(),
                       "default",
                       TRANSFINDER_FLAGS_USE_CATEGORY |
                       TRANSFINDER_FLAGS_EXT_PAYEES,
                       parent, "TransactionFinder",
                       true);
  tf.init();
  if (tf.exec()!=QDialog::Accepted) {
    DBG_WARN(0, "User aborted");
    return false;
  }
  app()->setTransactionMatcherRules(tf.getRules());
  tl=tf.getMatchingTransactions();
  tf.fini();

  if (tl.empty()) {
    DBG_ERROR(0, "No transactions");
    return false;
  }
  t=tl.front();

  for (it=tl.begin(); it!=tl.end(); it++) {
    DBG_ERROR(0, "Adding Transaction");
    addTransaction(adl, *it, false);
  } // for


  qs=tr("<html>");

  DBG_ERROR(0, "Printing report...");
  for (ait=adl.begin(); ait!=adl.end(); ait++) {
    qs+="<page>";
    DBG_ERROR(0, "Handling account");
    (*ait)->sort();
    qs+=handleAccount(dbProfile, parent, *ait);
    qs+="</page>";
  } // for

  qs+=tr("</html>");

  GWEN_Gui_Print(KBanking::QStringToUtf8String(tr("Transaction Report)")).c_str(),
		 "REPORT:SIMPLEREPORT",
		 KBanking::QStringToUtf8String(shortDescription()).c_str(),
		 KBanking::QStringToUtf8String(qs).c_str(),
		 0);

  DBG_ERROR(0, "Printing report... done");

  return true;
}



















