/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: view3d.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: vg $ $Date: 2007/04/11 16:47:26 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _E3D_VIEW3D_HXX
#define _E3D_VIEW3D_HXX

#ifndef _SVDVIEW_HXX
#include <svx/svdview.hxx>
#endif

#ifndef _SVX_DEF3D_HXX
#include <svx/def3d.hxx>
#endif

#ifndef _E3D_DEFLT3D_HXX
#include <svx/deflt3d.hxx>
#endif

#ifndef _BGFX_POINT_B2DPOINT_HXX
#include <basegfx/point/b2dpoint.hxx>
#endif

#ifndef INCLUDED_SVXDLLAPI_H
#include "svx/svxdllapi.h"
#endif

//************************************************************
//   Vorausdeklarationen
//************************************************************

class E3dObject;
class E3dScene;
class SceneList;
class Impl3DMirrorConstructOverlay;

/*************************************************************************
|*
|* Ableitung von SdrView zur Bearbeitung von 3D-Objekten
|*
\************************************************************************/

class SVX_DLLPUBLIC E3dView : public SdrView
{
protected:
	E3dDefaultAttributes		a3DDefaultAttr;
	MouseEvent					aMouseEvent;					// Die Parameter der letzten Events (Mouse, Keyboard)
	Color						aDefaultLightColor;             // dito mit den Farben
	Color						aDefaultAmbientColor;

	double						fDefaultScaleX;                 // Verzerrungen
	double						fDefaultScaleY;
	double						fDefaultScaleZ;
	double						fDefaultRotateX;                // und Drehungen
	double						fDefaultRotateY;
	double						fDefaultRotateZ;
	double						fDefaultExtrusionDeepth;        // Extrusionstiefe
	double						fDefaultLightIntensity;         // Intensitaeten der beiden (notwendigen) Licht-
	double						fDefaultAmbientIntensity;       // quellen
	long						nHDefaultSegments;              // wieviele HSegmente braucht mein Lathe-Ojekt
	long						nVDefaultSegments;              // wieviele VSegmente braucht mein Lathe-Ojekt

	E3dDragConstraint			eDragConstraint;

	// Migrate selections
	Impl3DMirrorConstructOverlay*					mpMirrorOverlay;

	BOOL						bDoubleSided;

	void InitView();

	void ImpCreate3DObject(E3dScene* pScene, SdrObject* pObj, BOOL bExtrude, double fDepth, basegfx::B2DHomMatrix& rLatheMat);
	void ImpCreateSingle3DObjectFlat(E3dScene* pScene, SdrObject* pObj, BOOL bExtrude, double fDepth, basegfx::B2DHomMatrix& rLatheMat);
	void ImpChangeSomeAttributesFor3DConversion(SdrObject* pObj);
	void ImpChangeSomeAttributesFor3DConversion2(SdrObject* pObj);

	void InitScene(E3dScene* pScene, double fW, double fH, double fCamZ);
	void ImpIsConvertTo3DPossible(SdrObject* pObj, BOOL& rAny3D, BOOL& rGroupSelected) const;
	void BreakSingle3DObj(E3dObject* pObj);

public:
	TYPEINFO();
	E3dView(SdrModel* pModel, OutputDevice* pOut = 0L);
	virtual ~E3dView();

	// Alle markierten Objekte auf dem angegebenen OutputDevice ausgeben.
	virtual void DrawMarkedObj(OutputDevice& rOut, const Point& rOfs) const;

	// Zugriff auf die Default-Attribute
	E3dDefaultAttributes& Get3DDefaultAttributes() { return a3DDefaultAttr; }
	virtual BOOL BegDragObj(const Point& rPnt, OutputDevice* pOut = NULL, SdrHdl* pHdl = NULL, short nMinMov = -3, SdrDragMethod* pForcedMeth = NULL);
	virtual	void CheckPossibilities();

	// Event setzen/rausruecken
	void SetMouseEvent(const MouseEvent& rNew) { aMouseEvent = rNew; }
	const MouseEvent& GetMouseEvent() { return aMouseEvent; }

	// Model holen ueberladen, da bei einzelnen 3D Objekten noch eine Szene
	// untergeschoben werden muss
	virtual SdrModel* GetMarkedObjModel() const;

	// Bei Paste muss - falls in eine Scene eingefuegt wird - die
	// Objekte der Szene eingefuegt werden, die Szene selbst aber nicht
	using SdrView::Paste;
	virtual BOOL Paste(const SdrModel& rMod, const Point& rPos, SdrObjList* pLst=NULL, UINT32 nOptions=0);

	// #83403# Service routine used from local Clone() and from SdrCreateView::EndCreateObj(...)
	BOOL ImpCloneAll3DObjectsToDestScene(E3dScene* pSrcScene, E3dScene* pDstScene, Point aOffset);

	BOOL HasMarkedScene();
	E3dScene* GetMarkedScene();

	BOOL IsConvertTo3DObjPossible() const;
	void ConvertMarkedObjTo3D(BOOL bExtrude=TRUE, basegfx::B2DPoint aPnt1 = basegfx::B2DPoint(0.0, 0.0), basegfx::B2DPoint aPnt2 = basegfx::B2DPoint(0.0, 1.0));

	// Nachtraeglichhe Korrekturmoeglichkeit um alle Extrudes in einer
	// bestimmten Tiefensortierung anzulegen
	void DoDepthArrange(E3dScene* pScene, double fDepth);
	void ConvertMarkedToPolyObj(BOOL bLineToArea);
	E3dScene* SetCurrent3DObj(E3dObject* p3DObj);
	void Start3DCreation();

	// migration of overlay
	sal_Bool Is3DRotationCreationActive() const { return (0L != mpMirrorOverlay); }

	virtual void MovAction(const Point& rPnt);
	void End3DCreation(BOOL bUseDefaultValuesForMirrorAxes=FALSE);
	void ResetCreationActive();

	double GetDefaultCamPosZ();

	double &DefaultScaleX ()
	{
		return fDefaultScaleX;
	}

	double DefaultScaleX () const
	{
		return fDefaultScaleX;
	}

	double &DefaultScaleY ()
	{
		return fDefaultScaleY;
	}

	double DefaultScaleY () const
	{
		return fDefaultScaleY;
	}

	double &DefaultScaleZ ()
	{
		return fDefaultScaleZ;
	}

	double DefaultScaleZ () const
	{
		return fDefaultScaleZ;
	}

	double &DefaultRotateX ()
	{
		return fDefaultRotateX;
	}

	double DefaultRotateX () const
	{
		return fDefaultRotateX;
	}

	double &DefaultRotateY ()
	{
		return fDefaultRotateY;
	}

	double DefaultRotateY () const
	{
		return fDefaultRotateY;
	}

	double &DefaultRotateZ ()
	{
		return fDefaultRotateZ;
	}

	double DefaultRotateZ () const
	{
		return fDefaultRotateZ;
	}

	double &DefaultExtrusionDeepth ()
	{
		return fDefaultExtrusionDeepth;
	}

	double DefaultExtrusionDeepth () const
	{
		return fDefaultExtrusionDeepth;
	}

	double GetDefaultCamFocal();

	double &DefaultLightIntensity ()
	{
		return fDefaultLightIntensity;
	}

	double DefaultLightIntensity () const
	{
		return fDefaultLightIntensity;
	}

	double &DefaultAmbientIntensity ()
	{
		return fDefaultAmbientIntensity;
	}

	double DefaultAmbientIntensity () const
	{
		return fDefaultAmbientIntensity;
	}

	const Color &DefaultLightColor () const
	{
		return aDefaultLightColor;
	}

	Color DefaultLightColor ()
	{
		return aDefaultLightColor;
	}

	const Color &DefaultAmbientColor () const
	{
		return aDefaultAmbientColor;
	}

	Color DefaultAmbientColor ()
	{
		return aDefaultAmbientColor;
	}

	long GetHDefaultSegments() const { return nHDefaultSegments; }
	void SetHDefaultSegments(long nSegs) { nHDefaultSegments = nSegs; }

	long GetVDefaultSegments() const { return nVDefaultSegments; }
	void SetVDefaultSegments(long nSegs) { nVDefaultSegments = nSegs; }

	BOOL IsBreak3DObjPossible() const;
	void Break3DObj();

	BOOL DoubleSided () const
	{
		return bDoubleSided;
	}

	BOOL &DoubleSided ()
	{
		return bDoubleSided;
	}

	void MergeScenes();
	SfxItemSet Get3DAttributes(E3dScene* pInScene = NULL, BOOL bOnly3DAttr=FALSE) const;
	void Set3DAttributes(const SfxItemSet& rAttr, E3dScene* pInScene = NULL, BOOL bOnly3DAttr=FALSE);
};

#endif			// _E3D_VIEW3D_HXX
