/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: activityparameters.hxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: kz $ $Date: 2006/12/13 15:25:17 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef INCLUDED_SLIDESHOW_ACTIVITYPARAMETERS_HXX
#define INCLUDED_SLIDESHOW_ACTIVITYPARAMETERS_HXX

#include "event.hxx"
#include "eventqueue.hxx"
#include "expressionnode.hxx"
#include "wakeupevent.hxx"

#include <boost/optional.hpp>
#include <vector>

namespace slideshow {
namespace internal {

/** Parameter struct for animation activities
    
    This struct contains all common parameters needed to
    initialize the activities generated by the ActivityFactory.
*/
struct ActivityParameters
{            
    /** Create 
        
        @param rEndEvent
        Event to be fired, when the activity ends.
        
        @param rEventQueue
        Queue to add end event to
        
        @param nMinDuration
        Minimal duration of the activity (might actually be
        longer because of nMinNumberOfFrames). Note that this
        duration must always be the <em>simple</em> duration,
        i.e. without any repeat.
        
        @param rRepeats
        Number of repeats. If this parameter is invalid,
        infinite repeat is assumed.
        
        @param nAccelerationFraction
        Value between 0 and 1, denoting the fraction of the
        total simple duration, which the animation should
        accelerate.
        
        @param nDecelerationFraction 
        Value between 0 and 1, denoting the fraction of the
        total simple duration, which the animation should
        decelerate. Note that the ranges
        [0,nAccelerationFraction] and
        [nDecelerationFraction,1] must be non-overlapping!
        
        @param bAutoReverse
        When true, at the end of the simple duration, the
        animation plays reversed to the start value. Note that
        nMinDuration still specifies the simple duration,
        i.e. when bAutoReverse is true, the implicit duration
        doubles.
    */
    ActivityParameters(
        const EventSharedPtr&                       rEndEvent,
        EventQueue&                                 rEventQueue,
        ActivitiesQueue&                            rActivitiesQueue,
        double                                      nMinDuration,
        ::boost::optional<double> const&            rRepeats,
        double                                      nAccelerationFraction,
        double                                      nDecelerationFraction,
        sal_uInt32                                  nMinNumberOfFrames,
        bool                                        bAutoReverse )
        : mrEndEvent( rEndEvent ),
          mpWakeupEvent(),
          mrEventQueue( rEventQueue ),
          mrActivitiesQueue( rActivitiesQueue ),
          mpFormula(),
          maDiscreteTimes(),
          mnMinDuration( nMinDuration ),
          mrRepeats( rRepeats ),
          mnAccelerationFraction( nAccelerationFraction ),
          mnDecelerationFraction( nDecelerationFraction ),
          mnMinNumberOfFrames( nMinNumberOfFrames ),
          mbAutoReverse( bAutoReverse ) {}
    
    /// End event to fire, when activity is over
    const EventSharedPtr&                       mrEndEvent;
    /// Wakeup event to use for discrete activities
    WakeupEventSharedPtr                        mpWakeupEvent;
    
    /// EventQueue to add events to
    EventQueue&                                 mrEventQueue;
    
    /// ActivitiesQueue to add events to
    ActivitiesQueue&                            mrActivitiesQueue;
    
    /// Optional formula
    ExpressionNodeSharedPtr                     mpFormula;
    
    /// Key times, for discrete and key time activities
    ::std::vector< double >                     maDiscreteTimes;
    
    /// Total duration of activity (including all repeats)
    const double                                mnMinDuration;
    ::boost::optional<double> const&            mrRepeats;
    const double                                mnAccelerationFraction;
    const double                                mnDecelerationFraction;
    
    /// Minimal number of frames this activity must render
    const sal_uInt32                            mnMinNumberOfFrames;
    
    /// When true, activity is played reversed after mnDuration.
    const bool                                  mbAutoReverse;
};

} // namespace internal
} // namespace presentation

#endif /* INCLUDED_SLIDESHOW_ACTIVITYPARAMETERS_HXX */

