 /*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: NTable.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/17 02:31:02 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 *    Contributor(s): Jayant Madavi_______________________________________
 *
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_connectivity.hxx"

#include "NTable.hxx"
#ifndef _CONNECTIVITY_EVOAB_TABLES_HXX_
#include "NTables.hxx"
#endif
#ifndef _CONNECTIVITY_EVOAB_COLUMNS_HXX_
#include "NColumns.hxx"
#endif
#ifndef _CONNECTIVITY_EVOAB_CATALOG_HXX__
#include "NCatalog.hxx"
#endif

using namespace connectivity;
using namespace ::comphelper;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::beans;
using namespace ::com::sun::star::sdbcx;
using namespace ::com::sun::star::sdbc;
using namespace ::com::sun::star::container;
using namespace ::com::sun::star::lang;
using namespace connectivity::evoab;
// -------------------------------------------------------------------------
OEvoabTable::OEvoabTable( sdbcx::OCollection* _pTables, OEvoabConnection* _pConnection) 
	: OEvoabTable_TYPEDEF(_pTables, sal_True),
	m_pConnection(_pConnection)
{
	construct();
}
// -------------------------------------------------------------------------
OEvoabTable::OEvoabTable( sdbcx::OCollection* _pTables,
	            OEvoabConnection* _pConnection,
	            const ::rtl::OUString& _Name,
	            const ::rtl::OUString& _Type,
	            const ::rtl::OUString& _Description ,
	            const ::rtl::OUString& _SchemaName,
	            const ::rtl::OUString& _CatalogName
	            ) : OEvoabTable_TYPEDEF(_pTables,sal_True,
	                              _Name,
	                              _Type,
	                              _Description,
	                              _SchemaName,
	                              _CatalogName),
	                m_pConnection(_pConnection)
{
	construct();
}
// -------------------------------------------------------------------------
void OEvoabTable::refreshColumns()
{
	TStringVector aVector;

	if (!isNew())
	{
	    Reference< XResultSet > xResult = m_pConnection->getMetaData()->getColumns(
				Any(),
				m_SchemaName,
				m_Name,
				::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("%")));

	    if (xResult.is())
	    {
		Reference< XRow > xRow(xResult, UNO_QUERY);
		while (xResult->next())
				aVector.push_back(xRow->getString(4));
	    }
	}
	if (m_pColumns)
	    m_pColumns->reFill(aVector);
	else
	    m_pColumns  = new OEvoabColumns(this,m_aMutex,aVector);
}
