/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: XXmlReader.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: hbrinkm $ $Date: 2006/11/01 09:14:36 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include <odiapi/xxml/XXmlReader.hxx>
#include <libxml/parser.h>


#include <com/sun/star/io/XInputStream.hpp>
#include <com/sun/star/io/XSeekable.hpp>

#ifndef _COM_SUN_STAR_EMBED_ELEMENTMODES_HPP_
#include <com/sun/star/embed/ElementModes.hpp>
#endif
#include <rtl/string.hxx>

using namespace ::com::sun::star;




namespace writerfilter { namespace xxml {


class ValueImpl : public Value
{
public:
	int len;
	const sal_Char *value;
	class XXmlReaderDirectImpl *parser;
public:
	virtual rtl::OUString getOUString() const
	{
		return rtl::OUString((const sal_Char *)value, len, RTL_TEXTENCODING_UTF8);
	}
	virtual rtl::OString getOString() const
	{
		return rtl::OString((const sal_Char *)value, len);
	}
	virtual std::string getString() const
	{
		return std::string(value, len);
	}
	virtual QName_t getQName() const
	{
		return 0;
	}


};



class XXmlReaderDirectImpl : public XXmlReader
{
private:
	ContentHandler &handler;
	static const xmlSAXHandler handlerStruct;
	std::auto_ptr<QNameTokenizerContext> context;

	inline void startElement(const sal_Char *name, const sal_Char **atts)
	{
		context->enterScope();

		const sal_Char **atts_=atts;
		if (atts_!=NULL)
		{
			while(*atts_!=NULL) { 
				const sal_Char *attrName=*atts_;
				atts_++;
				const sal_Char *attrValue=*atts_;
				atts_++;
				context->addBinding(attrName, attrValue); 
			};
		}
		QName_t nameId;
		QName::tokenizer().insert(name, *context, &nameId, false);

		static const size_t maxIDs=100;
		static QName_t attsIDs[maxIDs]; // maximal 100 ids
		static Value* attsValuePtr[maxIDs]; // maximal 100 ids

		atts_=atts;
		if (atts_!=NULL)
		{
			static ValueImpl attsValue[maxIDs];
			int numOfAtts=0;
			while(*atts_!=NULL && sal::static_int_cast<size_t>(numOfAtts)<maxIDs) { 
				if (QName::tokenizer().insert(*(atts_++), *context, &attsIDs[numOfAtts], true)) {
					attsValue[numOfAtts].value=*atts_;
					attsValue[numOfAtts].len=rtl_str_getLength(*atts_);
					attsValue[numOfAtts].parser=this;
					attsValuePtr[numOfAtts]=&attsValue[numOfAtts];
					numOfAtts++;
				}		
				atts_++;
			};
			handler.startElement(nameId, attsIDs, (const Value **)attsValuePtr, numOfAtts);
		}
		else
		{
			handler.startElement(nameId, attsIDs, (const Value **)attsValuePtr, 0);
		}

	}

	void endElement(const sal_Char *name)
	{
		QName_t nameId;
		QName::tokenizer().insert(name, *context, &nameId, false);
		handler.endElement(nameId);
		context->leaveScope();
	}


	static void startElement(void *ctx, const xmlChar *name, const xmlChar **atts)
	{
		XXmlReaderDirectImpl *p=(XXmlReaderDirectImpl *)ctx;
		p->startElement((const sal_Char *)name, (const sal_Char **)atts);
	}

	static void endElement(void *ctx, const xmlChar *name)
	{
		XXmlReaderDirectImpl *p=(XXmlReaderDirectImpl *)ctx;
		p->endElement((const sal_Char *)name);
	}
	static void characters(void * ctx, const xmlChar * ch, int len)
	{
		XXmlReaderDirectImpl *p=(XXmlReaderDirectImpl *)ctx;
		static ValueImpl value;
		value.len=len;
		value.value=(const sal_Char*)ch;
		value.parser=p;
		p->handler.characters(value);
	}


public:
	XXmlReaderDirectImpl(ContentHandler &handler_) :
		handler(handler_)
	{
		context=QName::tokenizer().createQNameTokenizerContext();
	}
    
    virtual ~XXmlReaderDirectImpl() {}

	virtual void read(const sal_Char *filename)
	{
	char buf[10*1024];
	int len;
	FILE *f =fopen(filename, "r");
	len=fread(buf, sizeof(char), sizeof(buf), f);
	if (len>=0)
	{
		handler.startDocument();
		xmlParserCtxtPtr p = xmlCreatePushParserCtxt((xmlSAXHandlerPtr)&handlerStruct, this, buf, len, filename);
		while(len>0) {
			len=fread(buf, sizeof(char), sizeof(buf), f);
			int err;
			if (len>=0 && (err=xmlParseChunk(p, buf, len, (len==0)))!=0) {
				break;
			}

		};
		handler.endDocument();
		xmlFreeParserCtxt(p);
	}
	fclose(f);
	}

	virtual void read(uno::Reference<io::XInputStream> stream, const sal_Char *filename=NULL)
	{
		const sal_Int32 bufSize=1000*1024;
		::com::sun::star::uno::Sequence< ::sal_Int8 > buf(bufSize);
		int len;
		uno::Reference< io::XSeekable > xSeekable(stream, uno::UNO_QUERY);
		if (xSeekable.is())
		{
			handler.startReading(sal::static_int_cast<size_t>(xSeekable->getLength()));
		}
		else
		{
			handler.startReading(0);
		}

		len=stream->readSomeBytes(buf, bufSize);
		if (len>=0)
		{
			handler.startDocument();
			xmlParserCtxtPtr p = xmlCreatePushParserCtxt((xmlSAXHandlerPtr)&handlerStruct, this, (const char*)buf.getArray(), len, filename);
			while(len>0) {
				handler.continueReading(len);
				len=stream->readSomeBytes(buf, bufSize);
				int err;
				if (len>=0 && (err=xmlParseChunk(p, (const char*)buf.getArray(), len, (len==0)))!=0) {
					break;
				}	
			};
			handler.endDocument();
			xmlFreeParserCtxt(p);
		}
		stream->closeInput();
		handler.endReading();
	}

	void read(uno::Reference<embed::XStorage> xStorage, ::rtl::OUString &streamName)
	{
		try {
		uno::Reference<io::XStream> stream=xStorage->openStreamElement(streamName, embed::ElementModes::READ );
		QNameTokenizer& tok=QName::tokenizer();
		rtl::OString streamName8;
		streamName.convertToString(&streamName8, RTL_TEXTENCODING_ASCII_US, RTL_UNICODETOTEXT_FLAGS_INVALID_ERROR);
		QName_t streamNameToken=tok.insert("", streamName8.getStr());
		handler.startStream(streamNameToken);
			read(stream->getInputStream(), (sal_Char*)xStorage.get());
		handler.endStream(streamNameToken);
		} catch (io::IOException &)
		{
			// no nothing
		}
	}
#if 0
	void read(uno::Reference<embed::XStorage> xStorage, const char *fileName=NULL)
	{
		/*
		uno::Reference< container::XNameAccess > xNameAccess(xStorage, uno::UNO_QUERY_THROW);
			uno::Sequence< ::rtl::OUString > names=xNameAccess->getElementNames();
			for(int i=0;i<names.getLength();i++)
			{
				rtl::OUString &name=names[i];
				wprintf(L"name=%s isStreamElement=%i isStorageElement=%i\n", name.getStr(), xStorage->isStreamElement(name), xStorage->isStorageElement(name));
			}
		*/
		read(xStorage, rtl::OUString::createFromAscii("settings.xml"));
		read(xStorage, rtl::OUString::createFromAscii("meta.xml"));
		read(xStorage, rtl::OUString::createFromAscii("styles.xml"));
		read(xStorage, rtl::OUString::createFromAscii("content.xml"));
	}
#endif 
};

const xmlSAXHandler XXmlReaderDirectImpl::handlerStruct = {
		NULL, /* internalSubset */
		NULL, /* isStandalone */
		NULL, /* hasInternalSubset */
		NULL, /* hasExternalSubset */
		NULL, /* resolveEntity */
		NULL, /* getEntity */
		NULL, /* entityDecl */
		NULL, /* notationDecl */
		NULL, /* attributeDecl */
		NULL, /* elementDecl */
		NULL, /* unparsedEntityDecl */
		NULL, /* setDocumentLocator */
		NULL, /* startDocument */
		NULL, /* endDocument */
		XXmlReaderDirectImpl::startElement, /* startElement */
		XXmlReaderDirectImpl::endElement, /* endElement */
		NULL, /* reference */
		XXmlReaderDirectImpl::characters, /* characters */
		NULL, /* ignorableWhitespace */
		NULL, /* processingInstruction */
		NULL, /* comment */
		NULL, /* xmlParserWarning */
		NULL, /* xmlParserError */
		NULL, /* xmlParserError */
		NULL /* getParameterEntity */
};


std::auto_ptr<XXmlReader>  XXmlReader::createXXmlReader(ContentHandler &handler)
{
	return std::auto_ptr<XXmlReader> (new XXmlReaderDirectImpl(handler));
}

} } /* writerfilter.xxml */
