/***************************************************************************
                          chatnotification.cpp  -  description
                             -------------------
    begin                : Fri Jan 31 2003
    copyright            : (C) 2003 by Mike K. Bennett
    email                : mkb137b@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "chatnotification.h"

#include <kdebug.h>
#include <kiconloader.h>
#include <klocale.h>
#include <knotifyclient.h>

#include "../chat/chatwindow.h"
#include "../contact/contact.h"
#include "../currentaccount.h"
#include "../kmessdebug.h"
#include "../systemtraywidget.h"

#include "balloonwidget.h"
#include "notificationwidget.h"
#include "notificationitem.h"

// The constructor
ChatNotification::ChatNotification( BalloonWidget *balloonWidget )
 : balloonWidget_( balloonWidget ),
   chatWindow_(0)
{
  notificationWidget_ = new NotificationWidget( balloonWidget );
  notificationWidget_->setCaption( i18n( "New chat notification:" ) );

  notificationWidget_->setPaletteBackgroundColor( "#FFDEC5" );

  connect( notificationWidget_,  SIGNAL(   clicked( QStringList, QObject * ) ),
           this,                   SLOT(   clicked( QStringList, QObject * ) ) );
}



// The destructor
ChatNotification::~ChatNotification()
{
#ifdef KMESSDEBUG_CHATNOTIFICATION
  kdDebug() << "DESTROYED ChatNotification" << endl;
#endif
}


// The balloon was clicked
void ChatNotification::clicked( QStringList /*stringList*/, QObject *object )
{
  QWidget *widget = (QWidget *) object;

#ifdef KMESSTEST
  ASSERT( chatWindow_ != 0 );
#endif
#ifdef KMESSDEBUG_CHATNOTIFICATION
  kdDebug() << "ChatNotification - Balloon clicked." << endl;
#endif
  if ( widget != 0 )
  {
#ifdef KMESSDEBUG_CHATNOTIFICATION
    kdDebug() << "ChatNotification - Showing the chat window with caption " << widget->caption() << "." << endl;
#endif
    widget->hide();
    widget->showNormal();  // Why doesn't this work?
  }
}



// Called when a new chat is started
void ChatNotification::newChat(const Contact *contact, QString message, ChatWindow *chatWindow)
{
#ifdef KMESSTEST
  ASSERT( contact != 0 );
  ASSERT( chatWindow != 0 );
#endif
#ifdef KMESSDEBUG_CHATNOTIFICATION
  kdDebug() << "ChatNotification - New chat." << endl;
#endif
  if ( contact == 0 )
  {
    kdDebug() << "ChatNotification::newChat - WARNING - Contact is null!" << endl;
    return;
  }
  QPixmap     pixmap;
  QString     text;
  KIconLoader *loader = KGlobal::iconLoader();

  // Save the chat window
  chatWindow_ = chatWindow;
  // Try to get the contact's picture
  pixmap.load( contact->getContactPicturePath() );
  // If the pixmap couldn't be loaded, use the generic "online" icon
  if ( pixmap.isNull() )
  {
    pixmap = loader->loadIcon("online", KIcon::User);
  }
  text =  contact->getFriendlyName() + " " + i18n("says: ") + "\n";
  text += "\"" + message + "\"";

  // Show the popup balloon
  //showBalloon( text, pixmap, "#FFDEC5" );
  new NotificationItem( notificationWidget_, 0, text, contact->getContactPicturePath(), 0, chatWindow );

  // Send a system notification.
#if KDE_IS_VERSION(3,2,0)
  KNotifyClient::event(chatWindow_->winId(), "chat start", text );
#else
  // winid() only required for flashing taskbar anyway, only supported since KDE 3.2
  KNotifyClient::event("chat start", text );
#endif
}

#include "chatnotification.moc"
