/***************************************************************************
 *   Copyright (C) 2006 by bysk                                           *
 *   buysk@pf.pl                                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "led_notify.h"
#include "chat_manager.h"

#include <X11/Xlib.h>

int LedNotify::NUMLOCK_LED = 1;
int LedNotify::CAPSLOCK_LED = 2;
int LedNotify::SCROLLLOCK_LED = 3;

LedNotify* led_notify_session;

extern "C" int led_notify_init()
{
	kdebugf();
	led_notify_session = new LedNotify();
	kdebugf2();
	return 0;
}

extern "C" void led_notify_close()
{
	kdebugf();
	delete led_notify_session;
	led_notify_session = NULL;
	kdebugf2();
}

LedNotify::LedNotify(QObject* parent, const char* name)
:
	Notifier(parent, name),
	ledHighlight_( false ),
	blinking_( false ),
	msgOrChat_( false )
{
	config_file.addVariable("Notify", "NewChat_LED", false);
	config_file.addVariable("Notify", "NewMessage_LED", false);
	
	ConfigDialog::addVGroupBox("Notify", "Notify",
		QT_TRANSLATE_NOOP("@default", "LED configuration"), 0, Expert);
	ConfigDialog::addSpinBox("Notify", "LED configuration",
		QT_TRANSLATE_NOOP("@default", "Blinking delay (msec):"),"LEDdelay",50,10000,1,500 );
	
	QMap<QString, QString> s;
	s["NewChat"]=SLOT(newChat(Protocol *, UserListElements, const QString &, time_t));
	s["NewMessage"]=SLOT(newMessage(Protocol *, UserListElements, const QString &, time_t, bool &));
	
	notify->registerNotifier("LED", this, s);
	
	timer = new QTimer(this);
	connect(timer, SIGNAL(timeout()), this, SLOT(blink()));
}

LedNotify::~LedNotify()
{
	disconnect(timer, SIGNAL(timeout()), this, SLOT(blink()));
	notify->unregisterNotifier("LED");
	
	ConfigDialog::removeControl("Notify", "Blinking delay (msec):");
	ConfigDialog::removeControl("Notify", "LED configuration");
	
	if( ledHighlight_ )
		setLed( SCROLLLOCK_LED, false );
}

void LedNotify::newChat(Protocol *protocol, UserListElements senders, const QString &msg, time_t t)
{
	kdebugf();
	
	if( blinking_ )
		return;
	
	msgOrChat_ = false;
	blinking_ = true;
	ledHighlight_ = false;
	
	timer->start(config_file.readNumEntry("Notify", "LEDdelay"));
	blink();
	kdebugf2();
}

void LedNotify::newMessage(Protocol *protocol, UserListElements senders, const QString &msg, time_t t, bool &grab)
{
	kdebugf();
	
	if( blinking_ )
		return;
	
	newMsgSenders = senders;
	Chat* chat = chat_manager->findChat(newMsgSenders);
	if(chat->isActiveWindow())
		return;
	
	msgOrChat_ = true;
	blinking_ = true;
	ledHighlight_ = false;
	
	timer->start(config_file.readNumEntry("Notify", "LEDdelay"));
	blink();
	kdebugf2();
}

void LedNotify::blink(void)
{
	kdebugf();

	static bool stopBlinking_;
	
	stopBlinking_ = false;
	
	if( blinking_ )
	{
		if( msgOrChat_ )
		{
			Chat* chat = chat_manager->findChat(newMsgSenders);
			if( chat != NULL )
			{
				if(chat->isActiveWindow())
					stopBlinking_ = true;
			}
			else
				stopBlinking_ = true;
		}
		else if( !pending.pendingMsgs() )
			stopBlinking_ = true;
	}
	else
		stopBlinking_ = true;
		
	if( stopBlinking_ )
	{
		timer->stop();
		blinking_ = false;
		if( !ledHighlight_ )
			return;
	}
	
	ledHighlight_ = !ledHighlight_;
	setLed( SCROLLLOCK_LED, ledHighlight_ );
	
	kdebugf2();
}

void LedNotify::setLed( int led, bool highlight )
{
	static Display* theDisplay = QPaintDevice::x11AppDisplay();
	static XKeyboardControl values;
	
	values.led = led;
	values.led_mode = (highlight ? LedModeOn : LedModeOff);

	XChangeKeyboardControl(theDisplay, KBLed | KBLedMode, &values);
}
