; Dia -- an diagram creation/manipulation program
; Copyright (C) 1998-2008 Alexander Larsson, Lars Clausen and others
;  
; dia-installer.nsi : Nullsoft Installation System (NSIS) script
; Copyright (C) 2000-2004 Herman Bloggs, Steffen Macke
; Copyright (C) 2005-2009 Steffen Macke <sdteffen@sdteffen.de>
;  
; This program is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.

; You should have received a copy of the GNU General Public License
; along with this program; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

; NOTE: this .NSI script is designed for NSIS v2.0

;--------------------------------
;Global Variables
Var name

;--------------------------------
;Configuration

;The name var is set in .onInit
Name $name

; Uninstall only the installed files and folders
!define UninstLog "uninstall.log"
Var UninstLog

; Where the GTK+ binares are installed. Set in .onInit 
Var GTKBIN

; Add file macro
!macro File FilePath FileName
 !define FileID ${__LINE__}
 ;IfFileExists "$OUTDIR\${FileName}" NoExtract_${FileID}
 File "${FilePath}${FileName}"
 NoExtract_${FileID}:
 FileWrite $UninstLog "$OUTDIR\${FileName}$\r$\n"
 !undef FileID
!macroend
!define File "!insertmacro File"
 
; Set output path macro
!macro SetOutPath Path
 SetOutPath "${Path}"
 FileWrite $UninstLog "${PATH}$\r$\n"
!macroend
!define SetOutPath "!insertmacro SetOutPath"
 
Section -openlogfile
 SetOutPath "$INSTDIR"
 !ifndef DIA_INCLUDE_GTK
 ; Check if install directory is pre 0.95
 IfFileExists "$INSTDIR\bin\libgtk-win32-2.0-0.dll" abort_no_overinstall continue_install
 abort_no_overinstall:
   MessageBox MB_OK|MB_ICONEXCLAMATION $(DIA_NO_INSTALL_OVER)
   Abort $(DIA_NO_INSTALL_OVER)
 continue_install:
 !endif
 IfFileExists "$INSTDIR\${UninstLog}" +3
 FileOpen $UninstLog "$INSTDIR\${UninstLog}" w
 Goto +4
  SetFileAttributes "$INSTDIR\${UninstLog}" NORMAL
  FileOpen $UninstLog "$INSTDIR\${UninstLog}" a
  FileSeek $UninstLog 0 END
SectionEnd
; Allow to build two different versions of the installer
!ifdef DIA_INCLUDE_GTK
OutFile "dia-setup-${DIA_VERSION}.exe"
!else
OutFile "dia-setup-no-gtk-${DIA_VERSION}.exe"
!endif
SetCompressor LZMA
;DirShow show
ShowInstDetails show
ShowUninstDetails show
SetDateSave on

; $name and $INSTDIR are set in .onInit function..

!include "MUI.nsh"
;!include "Sections.nsh"

;--------------------------------
;Defines

!define DIA_REG_KEY				"SOFTWARE\Dia"
!define DIA_UNINSTALL_KEY			"SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\Dia"
!define HKLM_APP_PATHS_KEY			"SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\diaw.exe"
!define HKLM_CMD_PATHS_KEY			"SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\dia.exe"
!define DIA_STARTUP_RUN_KEY			"SOFTWARE\Microsoft\Windows\CurrentVersion\Run"
!define DIA_UNINST_EXE				"dia-${DIA_VERSION}-uninstall.exe"

XPStyle On
  
VIAddVersionKey "ProductName" "Dia for Windows"
VIAddVersionKey "CompanyName" "The Dia Developers"
VIAddVersionKey "LegalCopyright" "(c) 2003-2009 Alexander Larsson and others"
VIAddVersionKey "FileDescription" "Dia for Windows Installer"
VIAddVersionKey "FileVersion" "0.97.0.3"
VIProductVersion "0.97.0.3"

;--------------------------------
;Modern UI Configuration

  !define MUI_ICON				"dia-install.ico"
  !define MUI_UNICON				"dia-uninstall.ico"
  !define MUI_WELCOMEFINISHPAGE_BITMAP 		"dia-intro.bmp"
  !define MUI_HEADERIMAGE
  !define MUI_HEADERIMAGE_BITMAP		"dia-header.bmp"
  !define MUI_HEADERIMAGE_UNBITMAP		"dia-header.bmp"

  ; Alter License section
  !define MUI_LICENSEPAGE_BUTTON		$(DIA_LICENSE_BUTTON)
  !define MUI_LICENSEPAGE_TEXT_BOTTOM		$(DIA_LICENSE_BOTTOM_TEXT)

  !define MUI_COMPONENTSPAGE_SMALLDESC
  !define MUI_ABORTWARNING

  ;Finish Page config
  !define MUI_FINISHPAGE_RUN
  !define MUI_FINISHPAGE_RUN_FUNCTION "LaunchDia"

  !define MUI_FINISHPAGE_RUN_NOTCHECKED
  !define MUI_FINISHPAGE_LINK			$(DIA_FINISH_VISIT_WEB_SITE)
  !define MUI_FINISHPAGE_LINK_LOCATION          "http://dia-installer.de/"

;--------------------------------
;Pages
  
  !insertmacro MUI_PAGE_WELCOME
  !insertmacro MUI_PAGE_LICENSE			"..\..\COPYING"
  !insertmacro MUI_PAGE_COMPONENTS

  ; Dia install dir page
  !insertmacro MUI_PAGE_DIRECTORY

  !insertmacro MUI_PAGE_INSTFILES
  !insertmacro MUI_PAGE_FINISH

  !insertmacro MUI_UNPAGE_WELCOME
  !insertmacro MUI_UNPAGE_CONFIRM
  !insertmacro MUI_UNPAGE_INSTFILES
  !insertmacro MUI_UNPAGE_FINISH

;--------------------------------
;Languages
 
  ;; English goes first because its the default. The rest are
  ;; in alphabetical order (at least the strings actually displayed
  ;; will be).

  !insertmacro MUI_LANGUAGE "English"
  !insertmacro MUI_LANGUAGE "French"
  !insertmacro MUI_LANGUAGE "German"
  !insertmacro MUI_LANGUAGE "Hungarian"
  !insertmacro MUI_LANGUAGE "Slovak"
  !insertmacro MUI_LANGUAGE "Slovenian"

;--------------------------------
;Translations

  !define DIA_DEFAULT_LANGFILE "locale\english.nsh"

  !include "langmacros.nsh"
  
  !insertmacro DIA_MACRO_INCLUDE_LANGFILE "ENGLISH" "locale\english.nsh"
  !insertmacro DIA_MACRO_INCLUDE_LANGFILE "FRENCH" "locale\french.nsh"
  !insertmacro DIA_MACRO_INCLUDE_LANGFILE "GERMAN" "locale\german.nsh"
  !insertmacro DIA_MACRO_INCLUDE_LANGFILE "HUNGARIAN" "locale\hungarian.nsh"
  !insertmacro DIA_MACRO_INCLUDE_LANGFILE "SLOVAK" "locale\slovak.nsh"
  !insertmacro DIA_MACRO_INCLUDE_LANGFILE "SLOVENIAN" "locale\slovenian.nsh"

;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Start Install Sections ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  
;--------------------------------
;Dia Install Section

Section $(DIA_SECTION_TITLE) SecDia
  SetOverwrite On
  SectionIn 1 RO

  ; Check install rights..
  Call CheckUserInstallRights
  Pop $R0

  StrCmp $R0 "NONE" dia_none
  StrCmp $R0 "HKLM" dia_hklm dia_hkcu
   
  dia_hklm:
    WriteRegStr HKLM "${HKLM_APP_PATHS_KEY}" "" "$INSTDIR\bin\diaw.exe"
    WriteRegStr HKLM "${HKLM_APP_PATHS_KEY}" "Path" "$R1\bin;$GTKBIN"
    WriteRegStr HKLM "${HKLM_CMD_PATHS_KEY}" "" "$INSTDIR\bin\dia.exe"
    WriteRegStr HKLM "${HKLM_CMD_PATHS_KEY}" "Path" "$R1\bin;$GTKBIN"
    WriteRegStr HKLM ${DIA_REG_KEY} "" "$INSTDIR"
    WriteRegStr HKLM ${DIA_REG_KEY} "Version" "${DIA_VERSION}"
    WriteRegStr HKLM "${DIA_UNINSTALL_KEY}" "DisplayName" $(DIA_UNINSTALL_DESC)
    WriteRegStr HKLM "${DIA_UNINSTALL_KEY}" "UninstallString" "$INSTDIR\${DIA_UNINST_EXE}"
    WriteRegStr HKLM "${DIA_UNINSTALL_KEY}" "DisplayIcon" "$INSTDIR\${DIA_UNINST_EXE}"
    ; Sets scope of the desktop and Start Menu entries for all users.
    SetShellVarContext "all"
    Goto dia_install_files

  dia_hkcu:
    WriteRegStr HKCU ${DIA_REG_KEY} "" "$INSTDIR"
    WriteRegStr HKCU ${DIA_REG_KEY} "Version" "${DIA_VERSION}"
    WriteRegStr HKCU "${DIA_UNINSTALL_KEY}" "DisplayName" $(DIA_UNINSTALL_DESC)
    WriteRegStr HKCU "${DIA_UNINSTALL_KEY}" "UninstallString" "$INSTDIR\${DIA_UNINST_EXE}"
    WriteRegStr HKCU "${DIA_UNINSTALL_KEY}" "DisplayIcon" "$INSTDIR\${DIA_UNINST_EXE}"

    Goto dia_install_files

  dia_none:

  dia_install_files:
  
    WriteRegStr HKEY_CLASSES_ROOT ".dia" "" "diaFile"
    WriteRegStr HKEY_CLASSES_ROOT ".dia" "Content Type" "application/dia"
    WriteRegStr HKEY_CLASSES_ROOT "diaFile" "" "diaFile"
    WriteRegBin HKEY_CLASSES_ROOT "diaFile" "EditFlags" 00000100
    WriteRegStr HKEY_CLASSES_ROOT "diaFile\Shell\open\command" "" '"$INSTDIR\bin\dia-win-remote.exe" diaw.exe --integrated "%1"'
    WriteRegStr HKEY_CLASSES_ROOT "diaFile\DefaultIcon" "" "$INSTDIR\etc\dia-diagram.ico,0"
    WriteRegStr HKEY_CLASSES_ROOT "diaFile\Shell\createcgm" "" "Create CGM image"
    WriteRegStr HKEY_CLASSES_ROOT "diaFile\Shell\createcgm\command" "" '"$INSTDIR\bin\dia.exe" -t cgm "%1"'
    WriteRegStr HKEY_CLASSES_ROOT "diaFile\Shell\createdxf" "" "Create DXF drawing"
    WriteRegStr HKEY_CLASSES_ROOT "diaFile\Shell\createdxf\command" "" '"$INSTDIR\bin\dia.exe" -t dxf "%1"'
    WriteRegStr HKEY_CLASSES_ROOT "diaFile\Shell\createeps" "" "Create EPS file"
    WriteRegStr HKEY_CLASSES_ROOT "diaFile\Shell\createeps\command" "" '"$INSTDIR\bin\dia.exe" -t eps "%1"'
    WriteRegStr HKEY_CLASSES_ROOT "diaFile\Shell\createhpgl" "" "Create HPGL file"
    WriteRegStr HKEY_CLASSES_ROOT "diaFile\Shell\createhpgl\command" "" '"$INSTDIR\bin\dia.exe" -t hpgl "%1"'
    WriteRegStr HKEY_CLASSES_ROOT "diaFile\Shell\createmp" "" "Create TeX Metapost macros"
    WriteRegStr HKEY_CLASSES_ROOT "diaFile\Shell\createmp\command" "" '"$INSTDIR\bin\dia.exe" -t mp "%1"'
    WriteRegStr HKEY_CLASSES_ROOT "diaFile\Shell\createpng" "" "Create PNG image"
    WriteRegStr HKEY_CLASSES_ROOT "diaFile\Shell\createpng\command" "" '"$INSTDIR\bin\dia.exe" -t png "%1"'
    WriteRegStr HKEY_CLASSES_ROOT "diaFile\Shell\createsvg" "" "Create SVG image"
    WriteRegStr HKEY_CLASSES_ROOT "diaFile\Shell\createsvg\command" "" '"$INSTDIR\bin\dia.exe" -t svg "%1"'
    WriteRegStr HKEY_CLASSES_ROOT "diaFile\Shell\createshape" "" "Create dia shape"
    WriteRegStr HKEY_CLASSES_ROOT "diaFile\Shell\createshape\command" "" '"$INSTDIR\bin\dia.exe" -t shape "%1"'
    WriteRegStr HKEY_CLASSES_ROOT "diaFile\Shell\createtex" "" "Create TeX PSTricks macros"
    WriteRegStr HKEY_CLASSES_ROOT "diaFile\Shell\createtex\command" "" '"$INSTDIR\bin\dia.exe" -t tex "%1"'
    WriteRegStr HKEY_CLASSES_ROOT "diaFile\Shell\createwmf" "" "Create Windows Meta File"
    WriteRegStr HKEY_CLASSES_ROOT "diaFile\Shell\createwmf\command" "" '"$INSTDIR\bin\dia.exe" -t wmf "%1"'
    WriteRegStr HKEY_CLASSES_ROOT "diaFile\Shell\createwpg" "" "Create WPG image"
    WriteRegStr HKEY_CLASSES_ROOT "diaFile\Shell\createwpg\command" "" '"$INSTDIR\bin\dia.exe" -t wpg "%1"'
    WriteRegStr HKEY_CLASSES_ROOT "diaFile\Shell\createfig" "" "Create XFig drawing"
    WriteRegStr HKEY_CLASSES_ROOT "diaFile\Shell\createfig\command" "" '"$INSTDIR\bin\dia.exe" -t fig "%1"'

${SetOutPath} "$INSTDIR"
${File} "..\..\data\" "dia-splash.png"

${SetOutPath} "$INSTDIR\bin"
; jEdit replacement: (^.*\\)(.*)$ 
; \${File} "$1" "$2"
${File} "..\..\build\win32\bin\" "dia.exe"
${File} "..\..\build\win32\bin\" "diaw.exe"
${File} "..\..\app\" "dia-win-remote.exe"
${File} "..\..\build\win32\bin\" "dia-app.dll"
${File} "..\..\..\bin\" "libart_lgpl_2-2.dll"
${File} "..\..\..\bin\" "libcairo-2.dll"
${File} "..\..\build\win32\bin\" "libdia.dll"
${File} "..\..\..\bin\" "iconv.dll"
${File} "..\..\..\bin\" "intl.dll"
${File} "..\..\..\bin\" "libxml2.dll"
${File} "..\..\..\bin\" "libxslt.dll"
${SetOutPath} "$INSTDIR\etc"
${File} ".\" "dia-diagram.ico"
${SetOutPath} "$INSTDIR\dia"
${File} "..\..\objects\AADL\" "aadl.dll"
${File} "..\..\plug-ins\cairo\" "cairo.dll"
${File} "..\..\plug-ins\cgm\" "cgm.dll"
${File} "..\..\objects\chronogram\" "chronogram.dll"
${File} "..\..\objects\custom\" "custom.dll"
${File} "..\..\objects\custom_lines\" "custom_lines.dll"
${File} "..\..\objects\Database\" "Database.dll"
# TODO: re-enable drs plug-in once its ready
#${File} "..\..\plug-ins\drs\" "drs.dll"
${File} "..\..\plug-ins\dxf\" "dxf.dll"
${File} "..\..\objects\er\" "er.dll"
${File} "..\..\objects\flowchart\" "flowchart.dll"
${File} "..\..\objects\FS\" "fs.dll"
${File} "..\..\objects\GRAFCET\" "grafcet.dll"
${File} "..\..\plug-ins\hpgl\" "hpgl.dll"
${File} "..\..\objects\Istar\" "Istar.dll"
${File} "..\..\objects\Jackson\" "Jackson.dll"
${File} "..\..\objects\KAOS\" "Kaos.dll"
${File} "..\..\plug-ins\libart\" "libart.dll"
${File} "..\..\plug-ins\metapost\" "metapost.dll"
${File} "..\..\objects\misc\" "misc.dll"
${File} "..\..\objects\network\" "network.dll"
${File} "..\..\plug-ins\pixbuf\" "pixbuf.dll"
${File} "..\..\plug-ins\postscript\" "postscript.dll"
${File} "..\..\plug-ins\pstricks\" "pstricks.dll"
${File} "..\..\objects\SADT\" "sadt.dll"
${File} "..\..\plug-ins\shape\" "shape.dll"
${File} "..\..\objects\SISSI\" "sissi.dll"
${File} "..\..\objects\standard\" "standard.dll"
${File} "..\..\plug-ins\svg\" "svg.dll"
${File} "..\..\objects\UML\" "uml.dll"
${File} "..\..\plug-ins\vdx\" "vdx.dll"
${File} "..\..\plug-ins\wmf\" "wmf.dll"
${File} "..\..\plug-ins\wpg\" "wpg.dll"
${File} "..\..\plug-ins\xfig\" "xfig.dll"
${File} "..\..\plug-ins\xslt\" "xslt.dll"

${SetOutPath} "$INSTDIR\shapes\Assorted"
${File} "..\..\shapes\Assorted\" "arrow-chevron.png"
${File} "..\..\shapes\Assorted\" "arrow-chevron.shape"
${File} "..\..\shapes\Assorted\" "arrow-down.png"
${File} "..\..\shapes\Assorted\" "arrow-down.shape"
${File} "..\..\shapes\Assorted\" "arrow-left-notched.png"
${File} "..\..\shapes\Assorted\" "arrow-left-notched.shape"
${File} "..\..\shapes\Assorted\" "arrow-left-right-up.png"
${File} "..\..\shapes\Assorted\" "arrow-left-right-up.shape"
${File} "..\..\shapes\Assorted\" "arrow-left-right.png"
${File} "..\..\shapes\Assorted\" "arrow-left-right.shape"
${File} "..\..\shapes\Assorted\" "arrow-left-up.png"
${File} "..\..\shapes\Assorted\" "arrow-left-up.shape"
${File} "..\..\shapes\Assorted\" "arrow-left.png"
${File} "..\..\shapes\Assorted\" "arrow-left.shape"
${File} "..\..\shapes\Assorted\" "arrow-pentagon.png"
${File} "..\..\shapes\Assorted\" "arrow-pentagon.shape"
${File} "..\..\shapes\Assorted\" "arrow-quad.png"
${File} "..\..\shapes\Assorted\" "arrow-quad.shape"
${File} "..\..\shapes\Assorted\" "arrow-right-notched.png"
${File} "..\..\shapes\Assorted\" "arrow-right-notched.shape"
${File} "..\..\shapes\Assorted\" "arrow-right.png"
${File} "..\..\shapes\Assorted\" "arrow-right.shape"
${File} "..\..\shapes\Assorted\" "arrow-turn-up.png"
${File} "..\..\shapes\Assorted\" "arrow-turn-up.shape"
${File} "..\..\shapes\Assorted\" "arrow-up-down-left.png"
${File} "..\..\shapes\Assorted\" "arrow-up-down-left.shape"
${File} "..\..\shapes\Assorted\" "arrow-up-down.png"
${File} "..\..\shapes\Assorted\" "arrow-up-down.shape"
${File} "..\..\shapes\Assorted\" "arrow-up.png"
${File} "..\..\shapes\Assorted\" "arrow-up.shape"
${File} "..\..\shapes\Assorted\" "circle-quarter.png"
${File} "..\..\shapes\Assorted\" "circle-quarter.shape"
${File} "..\..\shapes\Assorted\" "circle.png"
${File} "..\..\shapes\Assorted\" "circle.shape"
${File} "..\..\shapes\Assorted\" "cross-maltese.png"
${File} "..\..\shapes\Assorted\" "cross-maltese.shape"
${File} "..\..\shapes\Assorted\" "cross-swiss.png"
${File} "..\..\shapes\Assorted\" "cross-swiss.shape"
${File} "..\..\shapes\Assorted\" "diamond.png"
${File} "..\..\shapes\Assorted\" "diamond.shape"
${File} "..\..\shapes\Assorted\" "heart.png"
${File} "..\..\shapes\Assorted\" "heart.shape"
${File} "..\..\shapes\Assorted\" "heptagon.png"
${File} "..\..\shapes\Assorted\" "heptagon.shape"
${File} "..\..\shapes\Assorted\" "hexagon.png"
${File} "..\..\shapes\Assorted\" "hexagon.shape"
${File} "..\..\shapes\Assorted\" "moon-quarter.png"
${File} "..\..\shapes\Assorted\" "moon-quarter.shape"
${File} "..\..\shapes\Assorted\" "octagon.png"
${File} "..\..\shapes\Assorted\" "octagon.shape"
${File} "..\..\shapes\Assorted\" "parallelogram-horizontal.png"
${File} "..\..\shapes\Assorted\" "parallelogram-horizontal.shape"
${File} "..\..\shapes\Assorted\" "parallelogram-vertical.png"
${File} "..\..\shapes\Assorted\" "parallelogram-vertical.shape"
${File} "..\..\shapes\Assorted\" "pentagon.png"
${File} "..\..\shapes\Assorted\" "pentagon.shape"
${File} "..\..\shapes\Assorted\" "square.png"
${File} "..\..\shapes\Assorted\" "square.shape"
${File} "..\..\shapes\Assorted\" "star4.png"
${File} "..\..\shapes\Assorted\" "star4.shape"
${File} "..\..\shapes\Assorted\" "star4curved.png"
${File} "..\..\shapes\Assorted\" "star4curved.shape"
${File} "..\..\shapes\Assorted\" "star5.png"
${File} "..\..\shapes\Assorted\" "star5.shape"
${File} "..\..\shapes\Assorted\" "star6.png"
${File} "..\..\shapes\Assorted\" "star6.shape"
${File} "..\..\shapes\Assorted\" "star7.png"
${File} "..\..\shapes\Assorted\" "star7.shape"
${File} "..\..\shapes\Assorted\" "star8.png"
${File} "..\..\shapes\Assorted\" "star8.shape"
${File} "..\..\shapes\Assorted\" "star8curved.png"
${File} "..\..\shapes\Assorted\" "star8curved.shape"
${File} "..\..\shapes\Assorted\" "star8sharp.png"
${File} "..\..\shapes\Assorted\" "star8sharp.shape"
${File} "..\..\shapes\Assorted\" "sun.png"
${File} "..\..\shapes\Assorted\" "sun.shape"
${File} "..\..\shapes\Assorted\" "trapezoid.png"
${File} "..\..\shapes\Assorted\" "trapezoid.shape"
${File} "..\..\shapes\Assorted\" "triangle-isoceles.png"
${File} "..\..\shapes\Assorted\" "triangle-isoceles.shape"
${File} "..\..\shapes\Assorted\" "triangle-rightangle.png"
${File} "..\..\shapes\Assorted\" "triangle-rightangle.shape"
${SetOutPath} "$INSTDIR\shapes\BPMN"
${File} "..\..\shapes\BPMN\" "Activity-Looping.png"
${File} "..\..\shapes\BPMN\" "Activity-Looping.shape"
${File} "..\..\shapes\BPMN\" "Ad-Hoc-Collapsed-Sub-Process.png"
${File} "..\..\shapes\BPMN\" "Ad-Hoc-Collapsed-Sub-Process.shape"
${File} "..\..\shapes\BPMN\" "Collapsed-Sub-Process.png"
${File} "..\..\shapes\BPMN\" "Collapsed-Sub-Process.shape"
${File} "..\..\shapes\BPMN\" "Compensation-Collapsed-Sub-Process.png"
${File} "..\..\shapes\BPMN\" "Compensation-Collapsed-Sub-Process.shape"
${File} "..\..\shapes\BPMN\" "Compensation.png"
${File} "..\..\shapes\BPMN\" "Compensation.shape"
${File} "..\..\shapes\BPMN\" "Data-Object.png"
${File} "..\..\shapes\BPMN\" "Data-Object.shape"
${File} "..\..\shapes\BPMN\" "End-Event-Cancel.png"
${File} "..\..\shapes\BPMN\" "End-Event-Cancel.shape"
${File} "..\..\shapes\BPMN\" "End-Event-Compensation.png"
${File} "..\..\shapes\BPMN\" "End-Event-Compensation.shape"
${File} "..\..\shapes\BPMN\" "End-Event-Error.png"
${File} "..\..\shapes\BPMN\" "End-Event-Error.shape"
${File} "..\..\shapes\BPMN\" "End-Event-Link.png"
${File} "..\..\shapes\BPMN\" "End-Event-Link.shape"
${File} "..\..\shapes\BPMN\" "End-Event-Message.png"
${File} "..\..\shapes\BPMN\" "End-Event-Message.shape"
${File} "..\..\shapes\BPMN\" "End-Event-Multiple.png"
${File} "..\..\shapes\BPMN\" "End-Event-Multiple.shape"
${File} "..\..\shapes\BPMN\" "End-Event-Terminate.png"
${File} "..\..\shapes\BPMN\" "End-Event-Terminate.shape"
${File} "..\..\shapes\BPMN\" "End-Event.png"
${File} "..\..\shapes\BPMN\" "End-Event.shape"
${File} "..\..\shapes\BPMN\" "Gateway-Complex.png"
${File} "..\..\shapes\BPMN\" "Gateway-Complex.shape"
${File} "..\..\shapes\BPMN\" "Gateway-Exclusive-XOR-Data-Based.png"
${File} "..\..\shapes\BPMN\" "Gateway-Exclusive-XOR-Data-Based.shape"
${File} "..\..\shapes\BPMN\" "Gateway-Exclusive-XOR-Event-Based.png"
${File} "..\..\shapes\BPMN\" "Gateway-Exclusive-XOR-Event-Based.shape"
${File} "..\..\shapes\BPMN\" "Gateway-Inclusive-OR.png"
${File} "..\..\shapes\BPMN\" "Gateway-Inclusive-OR.shape"
${File} "..\..\shapes\BPMN\" "Gateway-Parallel-AND.png"
${File} "..\..\shapes\BPMN\" "Gateway-Parallel-AND.shape"
${File} "..\..\shapes\BPMN\" "Gateway.png"
${File} "..\..\shapes\BPMN\" "Gateway.shape"
${File} "..\..\shapes\BPMN\" "Group.png"
${File} "..\..\shapes\BPMN\" "Group.shape"
${File} "..\..\shapes\BPMN\" "Intermediate-Event-Cancel.png"
${File} "..\..\shapes\BPMN\" "Intermediate-Event-Cancel.shape"
${File} "..\..\shapes\BPMN\" "Intermediate-Event-Compensation.png"
${File} "..\..\shapes\BPMN\" "Intermediate-Event-Compensation.shape"
${File} "..\..\shapes\BPMN\" "Intermediate-Event-Error.png"
${File} "..\..\shapes\BPMN\" "Intermediate-Event-Error.shape"
${File} "..\..\shapes\BPMN\" "Intermediate-Event-Link.png"
${File} "..\..\shapes\BPMN\" "Intermediate-Event-Link.shape"
${File} "..\..\shapes\BPMN\" "Intermediate-Event-Message.png"
${File} "..\..\shapes\BPMN\" "Intermediate-Event-Message.shape"
${File} "..\..\shapes\BPMN\" "Intermediate-Event-Multiple.png"
${File} "..\..\shapes\BPMN\" "Intermediate-Event-Multiple.shape"
${File} "..\..\shapes\BPMN\" "Intermediate-Event-Rule.png"
${File} "..\..\shapes\BPMN\" "Intermediate-Event-Rule.shape"
${File} "..\..\shapes\BPMN\" "Intermediate-Event-Timer.png"
${File} "..\..\shapes\BPMN\" "Intermediate-Event-Timer.shape"
${File} "..\..\shapes\BPMN\" "Intermediate-Event.png"
${File} "..\..\shapes\BPMN\" "Intermediate-Event.shape"
${File} "..\..\shapes\BPMN\" "Looping-Collapsed-Sub-Process.png"
${File} "..\..\shapes\BPMN\" "Looping-Collapsed-Sub-Process.shape"
${File} "..\..\shapes\BPMN\" "Multiple-Instance-Collapsed-Sub-Process.png"
${File} "..\..\shapes\BPMN\" "Multiple-Instance-Collapsed-Sub-Process.shape"
${File} "..\..\shapes\BPMN\" "Multiple-Instance-Task.png"
${File} "..\..\shapes\BPMN\" "Multiple-Instance-Task.shape"
${File} "..\..\shapes\BPMN\" "Start-Event-Link.png"
${File} "..\..\shapes\BPMN\" "Start-Event-Link.shape"
${File} "..\..\shapes\BPMN\" "Start-Event-Message.png"
${File} "..\..\shapes\BPMN\" "Start-Event-Message.shape"
${File} "..\..\shapes\BPMN\" "Start-Event-Multiple.png"
${File} "..\..\shapes\BPMN\" "Start-Event-Multiple.shape"
${File} "..\..\shapes\BPMN\" "Start-Event-Rule.png"
${File} "..\..\shapes\BPMN\" "Start-Event-Rule.shape"
${File} "..\..\shapes\BPMN\" "Start-Event-Timer.shape"
${File} "..\..\shapes\BPMN\" "Start-Event-Timer.png"
${File} "..\..\shapes\BPMN\" "Start-Event.png"
${File} "..\..\shapes\BPMN\" "Start-Event.shape"
${File} "..\..\shapes\BPMN\" "Task.png"
${File} "..\..\shapes\BPMN\" "Task.shape"
${File} "..\..\shapes\BPMN\" "Text-Annotation.png"
${File} "..\..\shapes\BPMN\" "Text-Annotation.shape"
${File} "..\..\shapes\BPMN\" "Transaction.png"
${File} "..\..\shapes\BPMN\" "Transaction.shape"
${SetOutPath} "$INSTDIR\shapes\ChemEng"
${File} "..\..\shapes\ChemEng\" "ACgen.png"
${File} "..\..\shapes\ChemEng\" "ACgen.shape"
${File} "..\..\shapes\ChemEng\" "aircooler.png"
${File} "..\..\shapes\ChemEng\" "aircooler.shape"
${File} "..\..\shapes\ChemEng\" "airforced.png"
${File} "..\..\shapes\ChemEng\" "airforced.shape"
${File} "..\..\shapes\ChemEng\" "airinduced.png"
${File} "..\..\shapes\ChemEng\" "airinduced.shape"
${File} "..\..\shapes\ChemEng\" "autoclave.png"
${File} "..\..\shapes\ChemEng\" "autoclave.shape"
${File} "..\..\shapes\ChemEng\" "bigtraycol.png"
${File} "..\..\shapes\ChemEng\" "bigtraycol.shape"
${File} "..\..\shapes\ChemEng\" "centrifuge.png"
${File} "..\..\shapes\ChemEng\" "centrifuge.shape"
${File} "..\..\shapes\ChemEng\" "coil.png"
${File} "..\..\shapes\ChemEng\" "coil.shape"
${File} "..\..\shapes\ChemEng\" "coilv.png"
${File} "..\..\shapes\ChemEng\" "coilv.shape"
${File} "..\..\shapes\ChemEng\" "compr.png"
${File} "..\..\shapes\ChemEng\" "compr.shape"
${File} "..\..\shapes\ChemEng\" "coveredtank.png"
${File} "..\..\shapes\ChemEng\" "coveredtank.shape"
${File} "..\..\shapes\ChemEng\" "cyclone.png"
${File} "..\..\shapes\ChemEng\" "cyclone.shape"
${File} "..\..\shapes\ChemEng\" "displa.png"
${File} "..\..\shapes\ChemEng\" "displa.shape"
${File} "..\..\shapes\ChemEng\" "doublepipe.png"
${File} "..\..\shapes\ChemEng\" "doublepipe.shape"
${File} "..\..\shapes\ChemEng\" "ejector.png"
${File} "..\..\shapes\ChemEng\" "ejector.shape"
${File} "..\..\shapes\ChemEng\" "fan.png"
${File} "..\..\shapes\ChemEng\" "fan.shape"
${File} "..\..\shapes\ChemEng\" "filter.png"
${File} "..\..\shapes\ChemEng\" "filter.shape"
${File} "..\..\shapes\ChemEng\" "fixedroof.png"
${File} "..\..\shapes\ChemEng\" "fixedroof.shape"
${File} "..\..\shapes\ChemEng\" "floatingroof.png"
${File} "..\..\shapes\ChemEng\" "floatingroof.shape"
${File} "..\..\shapes\ChemEng\" "flowfan.png"
${File} "..\..\shapes\ChemEng\" "flowfan.shape"
${File} "..\..\shapes\ChemEng\" "fluidcont.png"
${File} "..\..\shapes\ChemEng\" "fluidcont.shape"
${File} "..\..\shapes\ChemEng\" "furnace.png"
${File} "..\..\shapes\ChemEng\" "furnace.shape"
${File} "..\..\shapes\ChemEng\" "gasholder.png"
${File} "..\..\shapes\ChemEng\" "gasholder.shape"
${File} "..\..\shapes\ChemEng\" "hx.png"
${File} "..\..\shapes\ChemEng\" "hx.shape"
${File} "..\..\shapes\ChemEng\" "hxv.png"
${File} "..\..\shapes\ChemEng\" "hxv.shape"
${File} "..\..\shapes\ChemEng\" "kettle.png"
${File} "..\..\shapes\ChemEng\" "kettle.shape"
${File} "..\..\shapes\ChemEng\" "knockout.png"
${File} "..\..\shapes\ChemEng\" "knockout.shape"
${File} "..\..\shapes\ChemEng\" "measure.png"
${File} "..\..\shapes\ChemEng\" "measure.shape"
${File} "..\..\shapes\ChemEng\" "mixer.png"
${File} "..\..\shapes\ChemEng\" "mixer.shape"
${File} "..\..\shapes\ChemEng\" "plate.png"
${File} "..\..\shapes\ChemEng\" "plate.shape"
${File} "..\..\shapes\ChemEng\" "pneum.png"
${File} "..\..\shapes\ChemEng\" "pneum.shape"
${File} "..\..\shapes\ChemEng\" "pneumv.png"
${File} "..\..\shapes\ChemEng\" "pneumv.shape"
${File} "..\..\shapes\ChemEng\" "pnuemv.png"
${File} "..\..\shapes\ChemEng\" "pnuemv.shape"
${File} "..\..\shapes\ChemEng\" "prv.png"
${File} "..\..\shapes\ChemEng\" "prv.shape"
${File} "..\..\shapes\ChemEng\" "pump.png"
${File} "..\..\shapes\ChemEng\" "pump.shape"
${File} "..\..\shapes\ChemEng\" "reactor.png"
${File} "..\..\shapes\ChemEng\" "reactor.shape"
${File} "..\..\shapes\ChemEng\" "recipr.png"
${File} "..\..\shapes\ChemEng\" "recipr.shape"
${File} "..\..\shapes\ChemEng\" "regval.png"
${File} "..\..\shapes\ChemEng\" "regval.shape"
${File} "..\..\shapes\ChemEng\" "regvalv.png"
${File} "..\..\shapes\ChemEng\" "regvalv.shape"
${File} "..\..\shapes\ChemEng\" "SaT-fixedtube.png"
${File} "..\..\shapes\ChemEng\" "SaT-fixedtube.shape"
${File} "..\..\shapes\ChemEng\" "SaT-floatinghead.png"
${File} "..\..\shapes\ChemEng\" "SaT-floatinghead.shape"
${File} "..\..\shapes\ChemEng\" "sealedtank.png"
${File} "..\..\shapes\ChemEng\" "sealedtank.shape"
${File} "..\..\shapes\ChemEng\" "settling.png"
${File} "..\..\shapes\ChemEng\" "settling.shape"
${File} "..\..\shapes\ChemEng\" "spray.png"
${File} "..\..\shapes\ChemEng\" "spray.shape"
${File} "..\..\shapes\ChemEng\" "spraydrier.png"
${File} "..\..\shapes\ChemEng\" "spraydrier.shape"
${File} "..\..\shapes\ChemEng\" "storagesphere.png"
${File} "..\..\shapes\ChemEng\" "storagesphere.shape"
${File} "..\..\shapes\ChemEng\" "tank.png"
${File} "..\..\shapes\ChemEng\" "tank.shape"
${File} "..\..\shapes\ChemEng\" "traycol.png"
${File} "..\..\shapes\ChemEng\" "traycol.shape"
${File} "..\..\shapes\ChemEng\" "val.png"
${File} "..\..\shapes\ChemEng\" "val.shape"
${File} "..\..\shapes\ChemEng\" "valv.png"
${File} "..\..\shapes\ChemEng\" "valv.shape"
${File} "..\..\shapes\ChemEng\" "vessel.png"
${File} "..\..\shapes\ChemEng\" "vessel.shape"
${File} "..\..\shapes\ChemEng\" "wcool.png"
${File} "..\..\shapes\ChemEng\" "wcool.shape"
${File} "..\..\shapes\ChemEng\" "wcoolv.png"
${File} "..\..\shapes\ChemEng\" "wcoolv.shape"
${SetOutPath} "$INSTDIR\shapes\Circuit"
${File} "..\..\shapes\Circuit\" "ground.png"
${File} "..\..\shapes\Circuit\" "ground.shape"
${File} "..\..\shapes\Circuit\" "ground.png"
${File} "..\..\shapes\Circuit\" "hcapacitor.png"
${File} "..\..\shapes\Circuit\" "hcapacitor.shape"
${File} "..\..\shapes\Circuit\" "hcapacitor.png"
${File} "..\..\shapes\Circuit\" "hdiode.png"
${File} "..\..\shapes\Circuit\" "hdiode.shape"
${File} "..\..\shapes\Circuit\" "hdiode.png"
${File} "..\..\shapes\Circuit\" "hfuse_de.png"
${File} "..\..\shapes\Circuit\" "hfuse_de.shape"
${File} "..\..\shapes\Circuit\" "hfuse_de.png"
${File} "..\..\shapes\Circuit\" "hinductor.png"
${File} "..\..\shapes\Circuit\" "hinductor.shape"
${File} "..\..\shapes\Circuit\" "hinductor.png"
${File} "..\..\shapes\Circuit\" "hinductor_de.png"
${File} "..\..\shapes\Circuit\" "hinductor_de.shape"
${File} "..\..\shapes\Circuit\" "hinductor_de.png"
${File} "..\..\shapes\Circuit\" "hjumper.png"
${File} "..\..\shapes\Circuit\" "hjumper.shape"
${File} "..\..\shapes\Circuit\" "hled_de.png"
${File} "..\..\shapes\Circuit\" "hled_de.shape"
${File} "..\..\shapes\Circuit\" "hled_de.png"
${File} "..\..\shapes\Circuit\" "hpowersource_de.png"
${File} "..\..\shapes\Circuit\" "hpowersource_de.shape"
${File} "..\..\shapes\Circuit\" "hpowersource_de.png"
${File} "..\..\shapes\Circuit\" "hresistor.png"
${File} "..\..\shapes\Circuit\" "hresistor.shape"
${File} "..\..\shapes\Circuit\" "hresistor.png"
${File} "..\..\shapes\Circuit\" "hresistor_de.png"
${File} "..\..\shapes\Circuit\" "hresistor_de.shape"
${File} "..\..\shapes\Circuit\" "hresistor_de.png"
${File} "..\..\shapes\Circuit\" "hzener.png"
${File} "..\..\shapes\Circuit\" "hzener.shape"
${File} "..\..\shapes\Circuit\" "hzener.png"
${File} "..\..\shapes\Circuit\" "lamp_de.png"
${File} "..\..\shapes\Circuit\" "lamp_de.shape"
${File} "..\..\shapes\Circuit\" "lamp_de.png"
${File} "..\..\shapes\Circuit\" "microphone_de.png"
${File} "..\..\shapes\Circuit\" "microphone_de.shape"
${File} "..\..\shapes\Circuit\" "microphone_de.png"
${File} "..\..\shapes\Circuit\" "nmos_de.png"
${File} "..\..\shapes\Circuit\" "nmos_de.shape"
${File} "..\..\shapes\Circuit\" "nmos_de.png"
${File} "..\..\shapes\Circuit\" "npn.png"
${File} "..\..\shapes\Circuit\" "npn.shape"
${File} "..\..\shapes\Circuit\" "npn.png"
${File} "..\..\shapes\Circuit\" "opamp.png"
${File} "..\..\shapes\Circuit\" "opamp.shape"
${File} "..\..\shapes\Circuit\" "opamp.png"
${File} "..\..\shapes\Circuit\" "pmos_de.png"
${File} "..\..\shapes\Circuit\" "pmos_de.shape"
${File} "..\..\shapes\Circuit\" "pmos_de.png"
${File} "..\..\shapes\Circuit\" "pnp.png"
${File} "..\..\shapes\Circuit\" "pnp.shape"
${File} "..\..\shapes\Circuit\" "pnp.png"
${File} "..\..\shapes\Circuit\" "README"
${File} "..\..\shapes\Circuit\" "speaker_de.png"
${File} "..\..\shapes\Circuit\" "speaker_de.shape"
${File} "..\..\shapes\Circuit\" "speaker_de.png"
${File} "..\..\shapes\Circuit\" "vcapacitor.png"
${File} "..\..\shapes\Circuit\" "vcapacitor.shape"
${File} "..\..\shapes\Circuit\" "vcapacitor.png"
${File} "..\..\shapes\Circuit\" "vdiode.png"
${File} "..\..\shapes\Circuit\" "vdiode.shape"
${File} "..\..\shapes\Circuit\" "vdiode.png"
${File} "..\..\shapes\Circuit\" "vfuse_de.png"
${File} "..\..\shapes\Circuit\" "vfuse_de.shape"
${File} "..\..\shapes\Circuit\" "vfuse_de.png"
${File} "..\..\shapes\Circuit\" "vinductor.png"
${File} "..\..\shapes\Circuit\" "vinductor.shape"
${File} "..\..\shapes\Circuit\" "vinductor.png"
${File} "..\..\shapes\Circuit\" "vinductor_de.png"
${File} "..\..\shapes\Circuit\" "vinductor_de.shape"
${File} "..\..\shapes\Circuit\" "vinductor_de.png"
${File} "..\..\shapes\Circuit\" "vled_de.png"
${File} "..\..\shapes\Circuit\" "vled_de.shape"
${File} "..\..\shapes\Circuit\" "vled_de.png"
${File} "..\..\shapes\Circuit\" "vpowersource_de.png"
${File} "..\..\shapes\Circuit\" "vpowersource_de.shape"
${File} "..\..\shapes\Circuit\" "vpowersource_de.png"
${File} "..\..\shapes\Circuit\" "vresistor.png"
${File} "..\..\shapes\Circuit\" "vresistor.shape"
${File} "..\..\shapes\Circuit\" "vresistor.png"
${File} "..\..\shapes\Circuit\" "vresistor_de.png"
${File} "..\..\shapes\Circuit\" "vresistor_de.shape"
${File} "..\..\shapes\Circuit\" "vresistor_de.png"
${File} "..\..\shapes\Circuit\" "vzener.png"
${File} "..\..\shapes\Circuit\" "vzener.shape"
${File} "..\..\shapes\Circuit\" "vzener.png"
${SetOutPath} "$INSTDIR\shapes\Cisco"
${File} "..\..\shapes\Cisco\" "1000.png"
${File} "..\..\shapes\Cisco\" "1000.shape"
${File} "..\..\shapes\Cisco\" "100baset_hub.png"
${File} "..\..\shapes\Cisco\" "100baset_hub.shape"
${File} "..\..\shapes\Cisco\" "10700.png"
${File} "..\..\shapes\Cisco\" "10700.shape"
${File} "..\..\shapes\Cisco\" "15200.png"
${File} "..\..\shapes\Cisco\" "15200.shape"
${File} "..\..\shapes\Cisco\" "15800.png"
${File} "..\..\shapes\Cisco\" "15800.shape"
${File} "..\..\shapes\Cisco\" "3174.png"
${File} "..\..\shapes\Cisco\" "3174.shape"
${File} "..\..\shapes\Cisco\" "3x74.png"
${File} "..\..\shapes\Cisco\" "3x74.shape"
${File} "..\..\shapes\Cisco\" "5000.png"
${File} "..\..\shapes\Cisco\" "5000.shape"
${File} "..\..\shapes\Cisco\" "5002.png"
${File} "..\..\shapes\Cisco\" "5002.shape"
${File} "..\..\shapes\Cisco\" "5500.png"
${File} "..\..\shapes\Cisco\" "5500.shape"
${File} "..\..\shapes\Cisco\" "6701.png"
${File} "..\..\shapes\Cisco\" "6701.shape"
${File} "..\..\shapes\Cisco\" "6705.png"
${File} "..\..\shapes\Cisco\" "6705.shape"
${File} "..\..\shapes\Cisco\" "6732.png"
${File} "..\..\shapes\Cisco\" "6732.shape"
${File} "..\..\shapes\Cisco\" "7500ars.png"
${File} "..\..\shapes\Cisco\" "7500ars.shape"
${File} "..\..\shapes\Cisco\" "7505.png"
${File} "..\..\shapes\Cisco\" "7505.shape"
${File} "..\..\shapes\Cisco\" "7507.png"
${File} "..\..\shapes\Cisco\" "7507.shape"
${File} "..\..\shapes\Cisco\" "accesspoint.png"
${File} "..\..\shapes\Cisco\" "accesspoint.shape"
${File} "..\..\shapes\Cisco\" "access_gateway.png"
${File} "..\..\shapes\Cisco\" "access_gateway.shape"
${File} "..\..\shapes\Cisco\" "access_server.png"
${File} "..\..\shapes\Cisco\" "access_server.shape"
${File} "..\..\shapes\Cisco\" "adm.png"
${File} "..\..\shapes\Cisco\" "adm.shape"
${File} "..\..\shapes\Cisco\" "androgynous_person.png"
${File} "..\..\shapes\Cisco\" "androgynous_person.shape"
${File} "..\..\shapes\Cisco\" "antenna.png"
${File} "..\..\shapes\Cisco\" "antenna.shape"
${File} "..\..\shapes\Cisco\" "asic.png"
${File} "..\..\shapes\Cisco\" "asic.shape"
${File} "..\..\shapes\Cisco\" "ata.png"
${File} "..\..\shapes\Cisco\" "ata.shape"
${File} "..\..\shapes\Cisco\" "atm3800.png"
${File} "..\..\shapes\Cisco\" "atm3800.shape"
${File} "..\..\shapes\Cisco\" "atm_fast_gigabit_etherswitch.png"
${File} "..\..\shapes\Cisco\" "atm_fast_gigabit_etherswitch.shape"
${File} "..\..\shapes\Cisco\" "atm_router.shape"
${File} "..\..\shapes\Cisco\" "atm_switch.png"
${File} "..\..\shapes\Cisco\" "atm_switch.shape"
${File} "..\..\shapes\Cisco\" "atm_tag_switch_router.png"
${File} "..\..\shapes\Cisco\" "atm_tag_switch_router.shape"
${File} "..\..\shapes\Cisco\" "automatic_protection_switching.png"
${File} "..\..\shapes\Cisco\" "automatic_protection_switching.shape"
${File} "..\..\shapes\Cisco\" "bbfw.png"
${File} "..\..\shapes\Cisco\" "bbfw.shape"
${File} "..\..\shapes\Cisco\" "bbfw_media.png"
${File} "..\..\shapes\Cisco\" "bbfw_media.shape"
${File} "..\..\shapes\Cisco\" "bbs.png"
${File} "..\..\shapes\Cisco\" "bbs.shape"
${File} "..\..\shapes\Cisco\" "bbsm.png"
${File} "..\..\shapes\Cisco\" "bbsm.shape"
${File} "..\..\shapes\Cisco\" "branch_office.png"
${File} "..\..\shapes\Cisco\" "branch_office.shape"
${File} "..\..\shapes\Cisco\" "branch_office_blue.png"
${File} "..\..\shapes\Cisco\" "branch_office_blue.shape"
${File} "..\..\shapes\Cisco\" "branch_office_subdued.png"
${File} "..\..\shapes\Cisco\" "branch_office_subdued.shape"
${File} "..\..\shapes\Cisco\" "breakout_box.png"
${File} "..\..\shapes\Cisco\" "breakout_box.shape"
${File} "..\..\shapes\Cisco\" "bridge.png"
${File} "..\..\shapes\Cisco\" "bridge.shape"
${File} "..\..\shapes\Cisco\" "broadband_router.png"
${File} "..\..\shapes\Cisco\" "broadband_router.shape"
${File} "..\..\shapes\Cisco\" "bts10200.png"
${File} "..\..\shapes\Cisco\" "bts10200.shape"
${File} "..\..\shapes\Cisco\" "ca.png"
${File} "..\..\shapes\Cisco\" "ca.shape"
${File} "..\..\shapes\Cisco\" "cable_modem.png"
${File} "..\..\shapes\Cisco\" "cable_modem.shape"
${File} "..\..\shapes\Cisco\" "callmanager.png"
${File} "..\..\shapes\Cisco\" "callmanager.shape"
${File} "..\..\shapes\Cisco\" "car.png"
${File} "..\..\shapes\Cisco\" "car.shape"
${File} "..\..\shapes\Cisco\" "carrier_routing_system.png"
${File} "..\..\shapes\Cisco\" "carrier_routing_system.shape"
${File} "..\..\shapes\Cisco\" "catalyst_access_gateway.png"
${File} "..\..\shapes\Cisco\" "catalyst_access_gateway.shape"
${File} "..\..\shapes\Cisco\" "cddi_fddi_concentrator.png"
${File} "..\..\shapes\Cisco\" "cddi_fddi_concentrator.shape"
${File} "..\..\shapes\Cisco\" "cdm.png"
${File} "..\..\shapes\Cisco\" "cdm.shape"
${File} "..\..\shapes\Cisco\" "cellular_phone.png"
${File} "..\..\shapes\Cisco\" "cellular_phone.shape"
${File} "..\..\shapes\Cisco\" "centri_firewall.png"
${File} "..\..\shapes\Cisco\" "centri_firewall.shape"
${File} "..\..\shapes\Cisco\" "channelized_pipe.png"
${File} "..\..\shapes\Cisco\" "channelized_pipe.shape"
${File} "..\..\shapes\Cisco\" "ciscosecurity.png"
${File} "..\..\shapes\Cisco\" "ciscosecurity.shape"
${File} "..\..\shapes\Cisco\" "ciscoworks.png"
${File} "..\..\shapes\Cisco\" "ciscoworks.shape"
${File} "..\..\shapes\Cisco\" "ciscoworks_man.png"
${File} "..\..\shapes\Cisco\" "ciscoworks_man.shape"
${File} "..\..\shapes\Cisco\" "cisco_hub.png"
${File} "..\..\shapes\Cisco\" "cisco_hub.shape"
${File} "..\..\shapes\Cisco\" "class45_switch.png"
${File} "..\..\shapes\Cisco\" "class45_switch.shape"
${File} "..\..\shapes\Cisco\" "cloud.png"
${File} "..\..\shapes\Cisco\" "cloud.shape"
${File} "..\..\shapes\Cisco\" "cloud_dark.png"
${File} "..\..\shapes\Cisco\" "cloud_dark.shape"
${File} "..\..\shapes\Cisco\" "cloud_gold.png"
${File} "..\..\shapes\Cisco\" "cloud_gold.shape"
${File} "..\..\shapes\Cisco\" "cloud_white.png"
${File} "..\..\shapes\Cisco\" "cloud_white.shape"
${File} "..\..\shapes\Cisco\" "communications_server.png"
${File} "..\..\shapes\Cisco\" "communications_server.shape"
${File} "..\..\shapes\Cisco\" "concatenated_payload.png"
${File} "..\..\shapes\Cisco\" "concatenated_payload.shape"
${File} "..\..\shapes\Cisco\" "content_engine.png"
${File} "..\..\shapes\Cisco\" "content_engine.shape"
${File} "..\..\shapes\Cisco\" "content_router.png"
${File} "..\..\shapes\Cisco\" "content_router.shape"
${File} "..\..\shapes\Cisco\" "content_service_module.png"
${File} "..\..\shapes\Cisco\" "content_service_module.shape"
${File} "..\..\shapes\Cisco\" "content_switch.png"
${File} "..\..\shapes\Cisco\" "content_switch.shape"
${File} "..\..\shapes\Cisco\" "csm-s.png"
${File} "..\..\shapes\Cisco\" "csm-s.shape"
${File} "..\..\shapes\Cisco\" "css1100.png"
${File} "..\..\shapes\Cisco\" "css1100.shape"
${File} "..\..\shapes\Cisco\" "csu_dsu.png"
${File} "..\..\shapes\Cisco\" "csu_dsu.shape"
${File} "..\..\shapes\Cisco\" "cte.png"
${File} "..\..\shapes\Cisco\" "cte.shape"
${File} "..\..\shapes\Cisco\" "data_center_switch.png"
${File} "..\..\shapes\Cisco\" "data_center_switch.shape"
${File} "..\..\shapes\Cisco\" "data_center_switch_reversed.png"
${File} "..\..\shapes\Cisco\" "data_center_switch_reversed.shape"
${File} "..\..\shapes\Cisco\" "data_switch_processor.png"
${File} "..\..\shapes\Cisco\" "data_switch_processor.shape"
${File} "..\..\shapes\Cisco\" "detector.png"
${File} "..\..\shapes\Cisco\" "detector.shape"
${File} "..\..\shapes\Cisco\" "digital_cross-connect.png"
${File} "..\..\shapes\Cisco\" "digital_cross-connect.shape"
${File} "..\..\shapes\Cisco\" "directory_server.png"
${File} "..\..\shapes\Cisco\" "directory_server.shape"
${File} "..\..\shapes\Cisco\" "director_fcis.png"
${File} "..\..\shapes\Cisco\" "director_fcis.shape"
${File} "..\..\shapes\Cisco\" "diskette.png"
${File} "..\..\shapes\Cisco\" "diskette.shape"
${File} "..\..\shapes\Cisco\" "disk_subsystem.png"
${File} "..\..\shapes\Cisco\" "disk_subsystem.shape"
${File} "..\..\shapes\Cisco\" "distributed_director.png"
${File} "..\..\shapes\Cisco\" "distributed_director.shape"
${File} "..\..\shapes\Cisco\" "dot_dot.png"
${File} "..\..\shapes\Cisco\" "dot_dot.shape"
${File} "..\..\shapes\Cisco\" "dpt.png"
${File} "..\..\shapes\Cisco\" "dpt.shape"
${File} "..\..\shapes\Cisco\" "dslam.png"
${File} "..\..\shapes\Cisco\" "dslam.shape"
${File} "..\..\shapes\Cisco\" "dual_mode_accesspoint.png"
${File} "..\..\shapes\Cisco\" "dual_mode_accesspoint.shape"
${File} "..\..\shapes\Cisco\" "dwdm_filter.png"
${File} "..\..\shapes\Cisco\" "dwdm_filter.shape"
${File} "..\..\shapes\Cisco\" "edge_label_switch_router.png"
${File} "..\..\shapes\Cisco\" "edge_label_switch_router_with_netflow.png"
${File} "..\..\shapes\Cisco\" "edge_label_switch_router_with_netflow.shape"
${File} "..\..\shapes\Cisco\" "end_office.png"
${File} "..\..\shapes\Cisco\" "end_office.shape"
${File} "..\..\shapes\Cisco\" "etherclient.png"
${File} "..\..\shapes\Cisco\" "etherclient.shape"
${File} "..\..\shapes\Cisco\" "fax.png"
${File} "..\..\shapes\Cisco\" "fax.shape"
${File} "..\..\shapes\Cisco\" "fc_storage.png"
${File} "..\..\shapes\Cisco\" "fc_storage.shape"
${File} "..\..\shapes\Cisco\" "fddi_ring.png"
${File} "..\..\shapes\Cisco\" "fddi_ring.shape"
${File} "..\..\shapes\Cisco\" "file_cabinet.png"
${File} "..\..\shapes\Cisco\" "file_cabinet.shape"
${File} "..\..\shapes\Cisco\" "file_engine.png"
${File} "..\..\shapes\Cisco\" "file_engine.shape"
${File} "..\..\shapes\Cisco\" "file_server.png"
${File} "..\..\shapes\Cisco\" "file_server.shape"
${File} "..\..\shapes\Cisco\" "firewall.png"
${File} "..\..\shapes\Cisco\" "firewall.shape"
${File} "..\..\shapes\Cisco\" "firewall_horizontal.png"
${File} "..\..\shapes\Cisco\" "firewall_horizontal.shape"
${File} "..\..\shapes\Cisco\" "firewall_subdued.png"
${File} "..\..\shapes\Cisco\" "firewall_subdued.shape"
${File} "..\..\shapes\Cisco\" "front_end_processor.png"
${File} "..\..\shapes\Cisco\" "front_end_processor.shape"
${File} "..\..\shapes\Cisco\" "fwsm.png"
${File} "..\..\shapes\Cisco\" "fwsm.shape"
${File} "..\..\shapes\Cisco\" "gatekeeper.png"
${File} "..\..\shapes\Cisco\" "gatekeeper.shape"
${File} "..\..\shapes\Cisco\" "general_appliance.png"
${File} "..\..\shapes\Cisco\" "general_appliance.shape"
${File} "..\..\shapes\Cisco\" "generic_building.png"
${File} "..\..\shapes\Cisco\" "generic_building.shape"
${File} "..\..\shapes\Cisco\" "generic_building_blue.png"
${File} "..\..\shapes\Cisco\" "generic_building_blue.shape"
${File} "..\..\shapes\Cisco\" "generic_building_subdued.png"
${File} "..\..\shapes\Cisco\" "generic_building_subdued.shape"
${File} "..\..\shapes\Cisco\" "generic_gateway.png"
${File} "..\..\shapes\Cisco\" "generic_gateway.shape"
${File} "..\..\shapes\Cisco\" "generic_processor.png"
${File} "..\..\shapes\Cisco\" "generic_processor.shape"
${File} "..\..\shapes\Cisco\" "generic_softswitch.png"
${File} "..\..\shapes\Cisco\" "generic_softswitch.shape"
${File} "..\..\shapes\Cisco\" "gigabit_switch_router_atm_tag.png"
${File} "..\..\shapes\Cisco\" "gigabit_switch_router_atm_tag.shape"
${File} "..\..\shapes\Cisco\" "government_building.png"
${File} "..\..\shapes\Cisco\" "government_building.shape"
${File} "..\..\shapes\Cisco\" "guard.png"
${File} "..\..\shapes\Cisco\" "guard.shape"
${File} "..\..\shapes\Cisco\" "h323.png"
${File} "..\..\shapes\Cisco\" "h323.shape"
${File} "..\..\shapes\Cisco\" "handheld.png"
${File} "..\..\shapes\Cisco\" "handheld.shape"
${File} "..\..\shapes\Cisco\" "headphones.png"
${File} "..\..\shapes\Cisco\" "headphones.shape"
${File} "..\..\shapes\Cisco\" "home_office.png"
${File} "..\..\shapes\Cisco\" "home_office.shape"
${File} "..\..\shapes\Cisco\" "hootphone.png"
${File} "..\..\shapes\Cisco\" "hootphone.shape"
${File} "..\..\shapes\Cisco\" "host.png"
${File} "..\..\shapes\Cisco\" "host.shape"
${File} "..\..\shapes\Cisco\" "house.png"
${File} "..\..\shapes\Cisco\" "house.shape"
${File} "..\..\shapes\Cisco\" "house_blue.png"
${File} "..\..\shapes\Cisco\" "house_blue.shape"
${File} "..\..\shapes\Cisco\" "hp_mini.png"
${File} "..\..\shapes\Cisco\" "hp_mini.shape"
${File} "..\..\shapes\Cisco\" "hub.png"
${File} "..\..\shapes\Cisco\" "hub.shape"
${File} "..\..\shapes\Cisco\" "hub_subdued.png"
${File} "..\..\shapes\Cisco\" "hub_subdued.shape"
${File} "..\..\shapes\Cisco\" "iad_router.png"
${File} "..\..\shapes\Cisco\" "iad_router.shape"
${File} "..\..\shapes\Cisco\" "ibm_mainframe.png"
${File} "..\..\shapes\Cisco\" "ibm_mainframe.shape"
${File} "..\..\shapes\Cisco\" "ibm_mainframe_with_fep.png"
${File} "..\..\shapes\Cisco\" "ibm_mainframe_with_fep.shape"
${File} "..\..\shapes\Cisco\" "ibm_mini.png"
${File} "..\..\shapes\Cisco\" "ibm_mini.shape"
${File} "..\..\shapes\Cisco\" "ibm_tower.png"
${File} "..\..\shapes\Cisco\" "ibm_tower.shape"
${File} "..\..\shapes\Cisco\" "icm.png"
${File} "..\..\shapes\Cisco\" "icm.shape"
${File} "..\..\shapes\Cisco\" "ics.png"
${File} "..\..\shapes\Cisco\" "ics.shape"
${File} "..\..\shapes\Cisco\" "intelliswitch_stack.png"
${File} "..\..\shapes\Cisco\" "intelliswitch_stack.shape"
${File} "..\..\shapes\Cisco\" "ios_firewall.png"
${File} "..\..\shapes\Cisco\" "ios_firewall.shape"
${File} "..\..\shapes\Cisco\" "ios_slb.png"
${File} "..\..\shapes\Cisco\" "ios_slb.shape"
${File} "..\..\shapes\Cisco\" "ip.png"
${File} "..\..\shapes\Cisco\" "ip.shape"
${File} "..\..\shapes\Cisco\" "iptv_broadcast_server.png"
${File} "..\..\shapes\Cisco\" "iptv_broadcast_server.shape"
${File} "..\..\shapes\Cisco\" "iptv_content_manager.png"
${File} "..\..\shapes\Cisco\" "iptv_content_manager.shape"
${File} "..\..\shapes\Cisco\" "ip_dsl.png"
${File} "..\..\shapes\Cisco\" "ip_dsl.shape"
${File} "..\..\shapes\Cisco\" "ip_old-style.png"
${File} "..\..\shapes\Cisco\" "ip_old-style.shape"
${File} "..\..\shapes\Cisco\" "ip_phone.png"
${File} "..\..\shapes\Cisco\" "ip_phone.shape"
${File} "..\..\shapes\Cisco\" "ip_softphone.png"
${File} "..\..\shapes\Cisco\" "ip_softphone.shape"
${File} "..\..\shapes\Cisco\" "ip_telephony_router.png"
${File} "..\..\shapes\Cisco\" "ip_telephony_router.shape"
${File} "..\..\shapes\Cisco\" "ip_transport_concentrator.png"
${File} "..\..\shapes\Cisco\" "ip_transport_concentrator.shape"
${File} "..\..\shapes\Cisco\" "iscsi_switch.png"
${File} "..\..\shapes\Cisco\" "iscsi_switch.shape"
${File} "..\..\shapes\Cisco\" "isdn_switch.png"
${File} "..\..\shapes\Cisco\" "isdn_switch.shape"
${File} "..\..\shapes\Cisco\" "itp.png"
${File} "..\..\shapes\Cisco\" "itp.shape"
${File} "..\..\shapes\Cisco\" "jbod.png"
${File} "..\..\shapes\Cisco\" "jbod.shape"
${File} "..\..\shapes\Cisco\" "key.png"
${File} "..\..\shapes\Cisco\" "key.shape"
${File} "..\..\shapes\Cisco\" "label_switch_router.png"
${File} "..\..\shapes\Cisco\" "label_switch_router.shape"
${File} "..\..\shapes\Cisco\" "lan2lan_switch.png"
${File} "..\..\shapes\Cisco\" "lan2lan_switch.shape"
${File} "..\..\shapes\Cisco\" "lan_to_lan.png"
${File} "..\..\shapes\Cisco\" "lan_to_lan.shape"
${File} "..\..\shapes\Cisco\" "laptop.png"
${File} "..\..\shapes\Cisco\" "laptop.shape"
${File} "..\..\shapes\Cisco\" "layer3_switch.png"
${File} "..\..\shapes\Cisco\" "layer3_switch.shape"
${File} "..\..\shapes\Cisco\" "layer_2_remote_switch.png"
${File} "..\..\shapes\Cisco\" "layer_2_remote_switch.shape"
${File} "..\..\shapes\Cisco\" "lightweight_ap.png"
${File} "..\..\shapes\Cisco\" "lightweight_ap.shape"
${File} "..\..\shapes\Cisco\" "localdirector.png"
${File} "..\..\shapes\Cisco\" "localdirector.shape"
${File} "..\..\shapes\Cisco\" "location_server.png"
${File} "..\..\shapes\Cisco\" "location_server.shape"
${File} "..\..\shapes\Cisco\" "lock.png"
${File} "..\..\shapes\Cisco\" "lock.shape"
${File} "..\..\shapes\Cisco\" "lock_and_key.png"
${File} "..\..\shapes\Cisco\" "lock_and_key.shape"
${File} "..\..\shapes\Cisco\" "longreach_cpe.png"
${File} "..\..\shapes\Cisco\" "longreach_cpe.shape"
${File} "..\..\shapes\Cisco\" "macintosh.png"
${File} "..\..\shapes\Cisco\" "macintosh.shape"
${File} "..\..\shapes\Cisco\" "mac_woman.png"
${File} "..\..\shapes\Cisco\" "mac_woman.shape"
${File} "..\..\shapes\Cisco\" "mac_woman_right.png"
${File} "..\..\shapes\Cisco\" "mac_woman_right.shape"
${File} "..\..\shapes\Cisco\" "man.png"
${File} "..\..\shapes\Cisco\" "man.shape"
${File} "..\..\shapes\Cisco\" "man_blue.png"
${File} "..\..\shapes\Cisco\" "man_blue.shape"
${File} "..\..\shapes\Cisco\" "man_gold.png"
${File} "..\..\shapes\Cisco\" "man_gold.shape"
${File} "..\..\shapes\Cisco\" "man_red.png"
${File} "..\..\shapes\Cisco\" "man_red.shape"
${File} "..\..\shapes\Cisco\" "man_woman.png"
${File} "..\..\shapes\Cisco\" "man_woman.shape"
${File} "..\..\shapes\Cisco\" "mas_gateway.png"
${File} "..\..\shapes\Cisco\" "mas_gateway.shape"
${File} "..\..\shapes\Cisco\" "mau.png"
${File} "..\..\shapes\Cisco\" "mau.shape"
${File} "..\..\shapes\Cisco\" "mcu.png"
${File} "..\..\shapes\Cisco\" "mcu.shape"
${File} "..\..\shapes\Cisco\" "mdu.png"
${File} "..\..\shapes\Cisco\" "mdu.shape"
${File} "..\..\shapes\Cisco\" "me1100.png"
${File} "..\..\shapes\Cisco\" "me1100.shape"
${File} "..\..\shapes\Cisco\" "medium_building.png"
${File} "..\..\shapes\Cisco\" "medium_building.shape"
${File} "..\..\shapes\Cisco\" "medium_building_blue.png"
${File} "..\..\shapes\Cisco\" "medium_building_blue.shape"
${File} "..\..\shapes\Cisco\" "medium_building_subdued.png"
${File} "..\..\shapes\Cisco\" "medium_building_subdued.shape"
${File} "..\..\shapes\Cisco\" "metro1500.png"
${File} "..\..\shapes\Cisco\" "metro1500.shape"
${File} "..\..\shapes\Cisco\" "mgx8220.png"
${File} "..\..\shapes\Cisco\" "mgx8220.shape"
${File} "..\..\shapes\Cisco\" "mgx8240.png"
${File} "..\..\shapes\Cisco\" "mgx8240.shape"
${File} "..\..\shapes\Cisco\" "mgx8260.png"
${File} "..\..\shapes\Cisco\" "mgx8260.shape"
${File} "..\..\shapes\Cisco\" "mgx_8000_series_voice_gateway.png"
${File} "..\..\shapes\Cisco\" "mgx_8000_series_voice_gateway.shape"
${File} "..\..\shapes\Cisco\" "microphone.png"
${File} "..\..\shapes\Cisco\" "microphone.shape"
${File} "..\..\shapes\Cisco\" "microwebserver.png"
${File} "..\..\shapes\Cisco\" "microwebserver.shape"
${File} "..\..\shapes\Cisco\" "mini_vax.png"
${File} "..\..\shapes\Cisco\" "mini_vax.shape"
${File} "..\..\shapes\Cisco\" "mobile_access_ip_phone.png"
${File} "..\..\shapes\Cisco\" "mobile_access_ip_phone.shape"
${File} "..\..\shapes\Cisco\" "mobile_access_router.png"
${File} "..\..\shapes\Cisco\" "mobile_access_router.shape"
${File} "..\..\shapes\Cisco\" "modem.png"
${File} "..\..\shapes\Cisco\" "modem.shape"
${File} "..\..\shapes\Cisco\" "moh_server.png"
${File} "..\..\shapes\Cisco\" "moh_server.shape"
${File} "..\..\shapes\Cisco\" "monitor.png"
${File} "..\..\shapes\Cisco\" "monitor.shape"
${File} "..\..\shapes\Cisco\" "multi-fabric_server_switch.png"
${File} "..\..\shapes\Cisco\" "multi-fabric_server_switch.shape"
${File} "..\..\shapes\Cisco\" "multilayer_remote_switch.png"
${File} "..\..\shapes\Cisco\" "multilayer_remote_switch.shape"
${File} "..\..\shapes\Cisco\" "multilayer_switch.png"
${File} "..\..\shapes\Cisco\" "multilayer_switch.shape"
${File} "..\..\shapes\Cisco\" "multilayer_switch_with_silicon.png"
${File} "..\..\shapes\Cisco\" "multilayer_switch_with_silicon.shape"
${File} "..\..\shapes\Cisco\" "multilayer_switch_with_silicon_subdued.png"
${File} "..\..\shapes\Cisco\" "multilayer_switch_with_silicon_subdued.shape"
${File} "..\..\shapes\Cisco\" "multiswitch_device.png"
${File} "..\..\shapes\Cisco\" "multiswitch_device.shape"
${File} "..\..\shapes\Cisco\" "mux.png"
${File} "..\..\shapes\Cisco\" "mux.shape"
${File} "..\..\shapes\Cisco\" "nat.png"
${File} "..\..\shapes\Cisco\" "nat.shape"
${File} "..\..\shapes\Cisco\" "netflow_router.png"
${File} "..\..\shapes\Cisco\" "netflow_router.shape"
${File} "..\..\shapes\Cisco\" "netranger.png"
${File} "..\..\shapes\Cisco\" "netranger.shape"
${File} "..\..\shapes\Cisco\" "netsonar.png"
${File} "..\..\shapes\Cisco\" "netsonar.shape"
${File} "..\..\shapes\Cisco\" "network_management.png"
${File} "..\..\shapes\Cisco\" "network_management.shape"
${File} "..\..\shapes\Cisco\" "newton.png"
${File} "..\..\shapes\Cisco\" "newton.shape"
${File} "..\..\shapes\Cisco\" "octel.png"
${File} "..\..\shapes\Cisco\" "octel.shape"
${File} "..\..\shapes\Cisco\" "ons15104.png"
${File} "..\..\shapes\Cisco\" "ons15104.shape"
${File} "..\..\shapes\Cisco\" "ons15540.png"
${File} "..\..\shapes\Cisco\" "ons15540.shape"
${File} "..\..\shapes\Cisco\" "optical_amplifier.png"
${File} "..\..\shapes\Cisco\" "optical_amplifier.shape"
${File} "..\..\shapes\Cisco\" "optical_cross-connect.png"
${File} "..\..\shapes\Cisco\" "optical_cross-connect.shape"
${File} "..\..\shapes\Cisco\" "optical_fiber.png"
${File} "..\..\shapes\Cisco\" "optical_fiber.shape"
${File} "..\..\shapes\Cisco\" "optical_services_router.png"
${File} "..\..\shapes\Cisco\" "optical_services_router.shape"
${File} "..\..\shapes\Cisco\" "optical_transport.png"
${File} "..\..\shapes\Cisco\" "optical_transport.shape"
${File} "..\..\shapes\Cisco\" "pad.png"
${File} "..\..\shapes\Cisco\" "pad.shape"
${File} "..\..\shapes\Cisco\" "pager.png"
${File} "..\..\shapes\Cisco\" "pager.shape"
${File} "..\..\shapes\Cisco\" "pbx.png"
${File} "..\..\shapes\Cisco\" "pbx.shape"
${File} "..\..\shapes\Cisco\" "pbx_switch.png"
${File} "..\..\shapes\Cisco\" "pbx_switch.shape"
${File} "..\..\shapes\Cisco\" "pc.png"
${File} "..\..\shapes\Cisco\" "pc.shape"
${File} "..\..\shapes\Cisco\" "pc_adapter_card.png"
${File} "..\..\shapes\Cisco\" "pc_adapter_card.shape"
${File} "..\..\shapes\Cisco\" "pc_card.png"
${File} "..\..\shapes\Cisco\" "pc_card.shape"
${File} "..\..\shapes\Cisco\" "pc_man.png"
${File} "..\..\shapes\Cisco\" "pc_man.shape"
${File} "..\..\shapes\Cisco\" "pc_man_left.png"
${File} "..\..\shapes\Cisco\" "pc_man_left.shape"
${File} "..\..\shapes\Cisco\" "pc_router_card.png"
${File} "..\..\shapes\Cisco\" "pc_router_card.shape"
${File} "..\..\shapes\Cisco\" "pc_software.png"
${File} "..\..\shapes\Cisco\" "pc_software.shape"
${File} "..\..\shapes\Cisco\" "pc_video.png"
${File} "..\..\shapes\Cisco\" "pc_video.shape"
${File} "..\..\shapes\Cisco\" "pc_with_router-based_software.png"
${File} "..\..\shapes\Cisco\" "pc_with_router-based_software.shape"
${File} "..\..\shapes\Cisco\" "pda.png"
${File} "..\..\shapes\Cisco\" "pda.shape"
${File} "..\..\shapes\Cisco\" "phone.png"
${File} "..\..\shapes\Cisco\" "phone.shape"
${File} "..\..\shapes\Cisco\" "phone_2.png"
${File} "..\..\shapes\Cisco\" "phone_2.shape"
${File} "..\..\shapes\Cisco\" "phone_appliance.png"
${File} "..\..\shapes\Cisco\" "phone_appliance.shape"
${File} "..\..\shapes\Cisco\" "phone_ethernet.png"
${File} "..\..\shapes\Cisco\" "phone_ethernet.shape"
${File} "..\..\shapes\Cisco\" "phone_fax.png"
${File} "..\..\shapes\Cisco\" "phone_fax.shape"
${File} "..\..\shapes\Cisco\" "phone_feature.png"
${File} "..\..\shapes\Cisco\" "phone_feature.shape"
${File} "..\..\shapes\Cisco\" "pix_firewall.png"
${File} "..\..\shapes\Cisco\" "pix_firewall.shape"
${File} "..\..\shapes\Cisco\" "pix_firewall_left.png"
${File} "..\..\shapes\Cisco\" "pix_firewall_left.shape"
${File} "..\..\shapes\Cisco\" "printer.png"
${File} "..\..\shapes\Cisco\" "printer.shape"
${File} "..\..\shapes\Cisco\" "programmable_switch.png"
${File} "..\..\shapes\Cisco\" "programmable_switch.shape"
${File} "..\..\shapes\Cisco\" "protocol_translator.png"
${File} "..\..\shapes\Cisco\" "protocol_translator.shape"
${File} "..\..\shapes\Cisco\" "pxf.png"
${File} "..\..\shapes\Cisco\" "pxf.shape"
${File} "..\..\shapes\Cisco\" "radio_tower.png"
${File} "..\..\shapes\Cisco\" "radio_tower.shape"
${File} "..\..\shapes\Cisco\" "ratemux.png"
${File} "..\..\shapes\Cisco\" "ratemux.shape"
${File} "..\..\shapes\Cisco\" "relational_database.png"
${File} "..\..\shapes\Cisco\" "relational_database.shape"
${File} "..\..\shapes\Cisco\" "repeater.png"
${File} "..\..\shapes\Cisco\" "repeater.shape"
${File} "..\..\shapes\Cisco\" "router.png"
${File} "..\..\shapes\Cisco\" "router.shape"
${File} "..\..\shapes\Cisco\" "router_in_building.png"
${File} "..\..\shapes\Cisco\" "router_in_building.shape"
${File} "..\..\shapes\Cisco\" "router_subdued.png"
${File} "..\..\shapes\Cisco\" "router_subdued.shape"
${File} "..\..\shapes\Cisco\" "router_with_firewall.png"
${File} "..\..\shapes\Cisco\" "router_with_firewall.shape"
${File} "..\..\shapes\Cisco\" "router_with_silicon_switch.png"
${File} "..\..\shapes\Cisco\" "router_with_silicon_switch.shape"
${File} "..\..\shapes\Cisco\" "route_switch_processor.png"
${File} "..\..\shapes\Cisco\" "route_switch_processor.shape"
${File} "..\..\shapes\Cisco\" "route_switch_processor_with_si.png"
${File} "..\..\shapes\Cisco\" "route_switch_processor_with_si.shape"
${File} "..\..\shapes\Cisco\" "rps.png"
${File} "..\..\shapes\Cisco\" "rps.shape"
${File} "..\..\shapes\Cisco\" "running_man.png"
${File} "..\..\shapes\Cisco\" "running_man.shape"
${File} "..\..\shapes\Cisco\" "running_man_subdued.png"
${File} "..\..\shapes\Cisco\" "running_man_subdued.shape"
${File} "..\..\shapes\Cisco\" "running_woman.png"
${File} "..\..\shapes\Cisco\" "running_woman.shape"
${File} "..\..\shapes\Cisco\" "satellite.png"
${File} "..\..\shapes\Cisco\" "satellite.shape"
${File} "..\..\shapes\Cisco\" "satellite_dish.png"
${File} "..\..\shapes\Cisco\" "satellite_dish.shape"
${File} "..\..\shapes\Cisco\" "sc2200.png"
${File} "..\..\shapes\Cisco\" "sc2200.shape"
${File} "..\..\shapes\Cisco\" "sc2200_vsc3000_host.png"
${File} "..\..\shapes\Cisco\" "sc2200_vsc3000_host.shape"
${File} "..\..\shapes\Cisco\" "scanner.png"
${File} "..\..\shapes\Cisco\" "scanner.shape"
${File} "..\..\shapes\Cisco\" "security_appliance.png"
${File} "..\..\shapes\Cisco\" "security_appliance.shape"
${File} "..\..\shapes\Cisco\" "server_switch.png"
${File} "..\..\shapes\Cisco\" "server_switch.shape"
${File} "..\..\shapes\Cisco\" "server_with_pc_router.png"
${File} "..\..\shapes\Cisco\" "server_with_pc_router.shape"
${File} "..\..\shapes\Cisco\" "service_control.png"
${File} "..\..\shapes\Cisco\" "service_control.shape"
${File} "..\..\shapes\Cisco\" "sip_proxy_server.png"
${File} "..\..\shapes\Cisco\" "sip_proxy_server.shape"
${File} "..\..\shapes\Cisco\" "sitting_woman.png"
${File} "..\..\shapes\Cisco\" "sitting_woman.shape"
${File} "..\..\shapes\Cisco\" "small_business.png"
${File} "..\..\shapes\Cisco\" "small_business.shape"
${File} "..\..\shapes\Cisco\" "small_hub.png"
${File} "..\..\shapes\Cisco\" "small_hub.shape"
${File} "..\..\shapes\Cisco\" "softphone.png"
${File} "..\..\shapes\Cisco\" "softphone.shape"
${File} "..\..\shapes\Cisco\" "software-based_router_on_file_server.png"
${File} "..\..\shapes\Cisco\" "software-based_router_on_file_server.shape"
${File} "..\..\shapes\Cisco\" "sonet_mux.png"
${File} "..\..\shapes\Cisco\" "sonet_mux.shape"
${File} "..\..\shapes\Cisco\" "speaker.png"
${File} "..\..\shapes\Cisco\" "speaker.shape"
${File} "..\..\shapes\Cisco\" "ssl_terminator.png"
${File} "..\..\shapes\Cisco\" "ssl_terminator.shape"
${File} "..\..\shapes\Cisco\" "standing_man.png"
${File} "..\..\shapes\Cisco\" "standing_man.shape"
${File} "..\..\shapes\Cisco\" "standing_woman.png"
${File} "..\..\shapes\Cisco\" "standing_woman.shape"
${File} "..\..\shapes\Cisco\" "stb.png"
${File} "..\..\shapes\Cisco\" "stb.shape"
${File} "..\..\shapes\Cisco\" "storage_array.png"
${File} "..\..\shapes\Cisco\" "storage_array.shape"
${File} "..\..\shapes\Cisco\" "storage_router.png"
${File} "..\..\shapes\Cisco\" "storage_router.shape"
${File} "..\..\shapes\Cisco\" "storage_solution_engine.png"
${File} "..\..\shapes\Cisco\" "storage_solution_engine.shape"
${File} "..\..\shapes\Cisco\" "stp.png"
${File} "..\..\shapes\Cisco\" "stp.shape"
${File} "..\..\shapes\Cisco\" "sun_workstation.png"
${File} "..\..\shapes\Cisco\" "sun_workstation.shape"
${File} "..\..\shapes\Cisco\" "supercomputer.png"
${File} "..\..\shapes\Cisco\" "supercomputer.shape"
${File} "..\..\shapes\Cisco\" "svx.png"
${File} "..\..\shapes\Cisco\" "svx.shape"
${File} "..\..\shapes\Cisco\" "switch_processor.png"
${File} "..\..\shapes\Cisco\" "switch_processor.shape"
${File} "..\..\shapes\Cisco\" "system_controller.png"
${File} "..\..\shapes\Cisco\" "system_controller.shape"
${File} "..\..\shapes\Cisco\" "tablet.png"
${File} "..\..\shapes\Cisco\" "tablet.shape"
${File} "..\..\shapes\Cisco\" "tape_array.png"
${File} "..\..\shapes\Cisco\" "tape_array.shape"
${File} "..\..\shapes\Cisco\" "tdm_router.png"
${File} "..\..\shapes\Cisco\" "tdm_router.shape"
${File} "..\..\shapes\Cisco\" "telecommuter.png"
${File} "..\..\shapes\Cisco\" "telecommuter.shape"
${File} "..\..\shapes\Cisco\" "telecommuter_house.png"
${File} "..\..\shapes\Cisco\" "telecommuter_house.shape"
${File} "..\..\shapes\Cisco\" "telecommuter_house_router.png"
${File} "..\..\shapes\Cisco\" "telecommuter_house_router.shape"
${File} "..\..\shapes\Cisco\" "telecommuter_house_subdued.png"
${File} "..\..\shapes\Cisco\" "telecommuter_house_subdued.shape"
${File} "..\..\shapes\Cisco\" "terminal.png"
${File} "..\..\shapes\Cisco\" "terminal.shape"
${File} "..\..\shapes\Cisco\" "terminal_server.png"
${File} "..\..\shapes\Cisco\" "terminal_server.shape"
${File} "..\..\shapes\Cisco\" "tokenring.png"
${File} "..\..\shapes\Cisco\" "tokenring.shape"
${File} "..\..\shapes\Cisco\" "transpath.png"
${File} "..\..\shapes\Cisco\" "transpath.shape"
${File} "..\..\shapes\Cisco\" "truck.png"
${File} "..\..\shapes\Cisco\" "truck.shape"
${File} "..\..\shapes\Cisco\" "turret.png"
${File} "..\..\shapes\Cisco\" "turret.shape"
${File} "..\..\shapes\Cisco\" "tv.png"
${File} "..\..\shapes\Cisco\" "tv.shape"
${File} "..\..\shapes\Cisco\" "ubr910_cable_dsu.png"
${File} "..\..\shapes\Cisco\" "ubr910_cable_dsu.shape"
${File} "..\..\shapes\Cisco\" "umg_series.png"
${File} "..\..\shapes\Cisco\" "umg_series.shape"
${File} "..\..\shapes\Cisco\" "unity_express.png"
${File} "..\..\shapes\Cisco\" "unity_express.shape"
${File} "..\..\shapes\Cisco\" "unity_server.png"
${File} "..\..\shapes\Cisco\" "unity_server.shape"
${File} "..\..\shapes\Cisco\" "universal_gateway.png"
${File} "..\..\shapes\Cisco\" "universal_gateway.shape"
${File} "..\..\shapes\Cisco\" "university.png"
${File} "..\..\shapes\Cisco\" "university.shape"
${File} "..\..\shapes\Cisco\" "ups.png"
${File} "..\..\shapes\Cisco\" "ups.shape"
${File} "..\..\shapes\Cisco\" "video_camera.png"
${File} "..\..\shapes\Cisco\" "video_camera.shape"
${File} "..\..\shapes\Cisco\" "video_camera_right.png"
${File} "..\..\shapes\Cisco\" "video_camera_right.shape"
${File} "..\..\shapes\Cisco\" "vip.png"
${File} "..\..\shapes\Cisco\" "vip.shape"
${File} "..\..\shapes\Cisco\" "virtual_layer_switch.png"
${File} "..\..\shapes\Cisco\" "virtual_layer_switch.shape"
${File} "..\..\shapes\Cisco\" "vn2900.png"
${File} "..\..\shapes\Cisco\" "vn2900.shape"
${File} "..\..\shapes\Cisco\" "vn5900.png"
${File} "..\..\shapes\Cisco\" "vn5900.shape"
${File} "..\..\shapes\Cisco\" "vn5902.png"
${File} "..\..\shapes\Cisco\" "vn5902.shape"
${File} "..\..\shapes\Cisco\" "voice-enabled_access_server.png"
${File} "..\..\shapes\Cisco\" "voice-enabled_access_server.shape"
${File} "..\..\shapes\Cisco\" "voice-enabled_atm_switch.png"
${File} "..\..\shapes\Cisco\" "voice-enabled_atm_switch.shape"
${File} "..\..\shapes\Cisco\" "voice-enabled_router.png"
${File} "..\..\shapes\Cisco\" "voice-enabled_router.shape"
${File} "..\..\shapes\Cisco\" "voice_switch2.png"
${File} "..\..\shapes\Cisco\" "voice_switch2.shape"
${File} "..\..\shapes\Cisco\" "vpn_concentrator.png"
${File} "..\..\shapes\Cisco\" "vpn_concentrator.shape"
${File} "..\..\shapes\Cisco\" "vpn_gateway.png"
${File} "..\..\shapes\Cisco\" "vpn_gateway.shape"
${File} "..\..\shapes\Cisco\" "vsc3000.png"
${File} "..\..\shapes\Cisco\" "vsc3000.shape"
${File} "..\..\shapes\Cisco\" "wan.png"
${File} "..\..\shapes\Cisco\" "wan.shape"
${File} "..\..\shapes\Cisco\" "wavelength_router.png"
${File} "..\..\shapes\Cisco\" "wavelength_router.shape"
${File} "..\..\shapes\Cisco\" "wdm.png"
${File} "..\..\shapes\Cisco\" "wdm.shape"
${File} "..\..\shapes\Cisco\" "web_browser.png"
${File} "..\..\shapes\Cisco\" "web_browser.shape"
${File} "..\..\shapes\Cisco\" "web_cluster.png"
${File} "..\..\shapes\Cisco\" "web_cluster.shape"
${File} "..\..\shapes\Cisco\" "wi-fi_tag.png"
${File} "..\..\shapes\Cisco\" "wi-fi_tag.shape"
${File} "..\..\shapes\Cisco\" "wireless.png"
${File} "..\..\shapes\Cisco\" "wireless.shape"
${File} "..\..\shapes\Cisco\" "wireless_bridge.png"
${File} "..\..\shapes\Cisco\" "wireless_bridge.shape"
${File} "..\..\shapes\Cisco\" "wireless_connectivity.png"
${File} "..\..\shapes\Cisco\" "wireless_connectivity.shape"
${File} "..\..\shapes\Cisco\" "wireless_location_appliance.png"
${File} "..\..\shapes\Cisco\" "wireless_location_appliance.shape"
${File} "..\..\shapes\Cisco\" "wireless_router.png"
${File} "..\..\shapes\Cisco\" "wireless_router.shape"
${File} "..\..\shapes\Cisco\" "wireless_transport.png"
${File} "..\..\shapes\Cisco\" "wireless_transport.shape"
${File} "..\..\shapes\Cisco\" "wlan_controller.png"
${File} "..\..\shapes\Cisco\" "wlan_controller.shape"
${File} "..\..\shapes\Cisco\" "woman.png"
${File} "..\..\shapes\Cisco\" "woman.shape"
${File} "..\..\shapes\Cisco\" "woman_blue.png"
${File} "..\..\shapes\Cisco\" "woman_blue.shape"
${File} "..\..\shapes\Cisco\" "woman_gold.png"
${File} "..\..\shapes\Cisco\" "woman_gold.shape"
${File} "..\..\shapes\Cisco\" "woman_red.png"
${File} "..\..\shapes\Cisco\" "woman_red.shape"
${File} "..\..\shapes\Cisco\" "workgroup_director.png"
${File} "..\..\shapes\Cisco\" "workgroup_director.shape"
${File} "..\..\shapes\Cisco\" "workgroup_fcis.png"
${File} "..\..\shapes\Cisco\" "workgroup_fcis.shape"
${File} "..\..\shapes\Cisco\" "workgroup_switch.png"
${File} "..\..\shapes\Cisco\" "workgroup_switch.shape"
${File} "..\..\shapes\Cisco\" "workgroup_switch_subdued.png"
${File} "..\..\shapes\Cisco\" "workgroup_switch_subdued.shape"
${File} "..\..\shapes\Cisco\" "workgroup_switch_voice-enabled.png"
${File} "..\..\shapes\Cisco\" "workgroup_switch_voice-enabled.shape"
${File} "..\..\shapes\Cisco\" "workstation.png"
${File} "..\..\shapes\Cisco\" "workstation.shape"
${File} "..\..\shapes\Cisco\" "www_server.png"
${File} "..\..\shapes\Cisco\" "www_server.shape"
${SetOutPath} "$INSTDIR\shapes\Civil"
${File} "..\..\shapes\Civil\" "bvrest.png"
${File} "..\..\shapes\Civil\" "bvrest.shape"
${File} "..\..\shapes\Civil\" "bvrest.png"
${File} "..\..\shapes\Civil\" "civil_aerator.png"
${File} "..\..\shapes\Civil\" "civil_aerator.shape"
${File} "..\..\shapes\Civil\" "civil_aerator.png"
${File} "..\..\shapes\Civil\" "civil_arrow_right.png"
${File} "..\..\shapes\Civil\" "civil_arrow_right.shape"
${File} "..\..\shapes\Civil\" "civil_arrow_right.png"
${File} "..\..\shapes\Civil\" "civil_arrow_up.png"
${File} "..\..\shapes\Civil\" "civil_arrow_up.shape"
${File} "..\..\shapes\Civil\" "civil_arrow_up.png"
${File} "..\..\shapes\Civil\" "civil_backflow_preventer.png"
${File} "..\..\shapes\Civil\" "civil_backflow_preventer.shape"
${File} "..\..\shapes\Civil\" "civil_backflow_preventer.png"
${File} "..\..\shapes\Civil\" "civil_basin.png"
${File} "..\..\shapes\Civil\" "civil_basin.shape"
${File} "..\..\shapes\Civil\" "civil_basin.png"
${File} "..\..\shapes\Civil\" "civil_container.png"
${File} "..\..\shapes\Civil\" "civil_container.shape"
${File} "..\..\shapes\Civil\" "civil_container.png"
${File} "..\..\shapes\Civil\" "civil_final-settling_basin.png"
${File} "..\..\shapes\Civil\" "civil_final-settling_basin.shape"
${File} "..\..\shapes\Civil\" "civil_final-settling_basin.png"
${File} "..\..\shapes\Civil\" "civil_frequency_converter.png"
${File} "..\..\shapes\Civil\" "civil_frequency_converter.shape"
${File} "..\..\shapes\Civil\" "civil_frequency_converter.png"
${File} "..\..\shapes\Civil\" "civil_gas_bottle.png"
${File} "..\..\shapes\Civil\" "civil_gas_bottle.shape"
${File} "..\..\shapes\Civil\" "civil_gas_bottle.png"
${File} "..\..\shapes\Civil\" "civil_horizontal_limiting_line.png"
${File} "..\..\shapes\Civil\" "civil_horizontal_limiting_line.shape"
${File} "..\..\shapes\Civil\" "civil_horizontal_limiting_line.png"
${File} "..\..\shapes\Civil\" "civil_horizontal_valve.png"
${File} "..\..\shapes\Civil\" "civil_horizontal_valve.shape"
${File} "..\..\shapes\Civil\" "civil_horizontal_valve.png"
${File} "..\..\shapes\Civil\" "civil_motor.png"
${File} "..\..\shapes\Civil\" "civil_motor.shape"
${File} "..\..\shapes\Civil\" "civil_motor.png"
${File} "..\..\shapes\Civil\" "civil_preliminary_clarification_tank.png"
${File} "..\..\shapes\Civil\" "civil_preliminary_clarification_tank.shape"
${File} "..\..\shapes\Civil\" "civil_preliminary_clarification_tank.png"
${File} "..\..\shapes\Civil\" "civil_rotor.png"
${File} "..\..\shapes\Civil\" "civil_rotor.shape"
${File} "..\..\shapes\Civil\" "civil_rotor.png"
${File} "..\..\shapes\Civil\" "civil_soil.png"
${File} "..\..\shapes\Civil\" "civil_soil.shape"
${File} "..\..\shapes\Civil\" "civil_soil.png"
${File} "..\..\shapes\Civil\" "civil_vertical_limiting_line.png"
${File} "..\..\shapes\Civil\" "civil_vertical_limiting_line.shape"
${File} "..\..\shapes\Civil\" "civil_vertical_limiting_line.png"
${File} "..\..\shapes\Civil\" "civil_vertical_propeller.png"
${File} "..\..\shapes\Civil\" "civil_vertical_propeller.shape"
${File} "..\..\shapes\Civil\" "civil_vertical_propeller.png"
${File} "..\..\shapes\Civil\" "hcompressor.png"
${File} "..\..\shapes\Civil\" "hcompressor.shape"
${File} "..\..\shapes\Civil\" "hcompressor.png"
${File} "..\..\shapes\Civil\" "hpump.png"
${File} "..\..\shapes\Civil\" "hpump.shape"
${File} "..\..\shapes\Civil\" "hpump.png"
${File} "..\..\shapes\Civil\" "hrest.png"
${File} "..\..\shapes\Civil\" "hrest.shape"
${File} "..\..\shapes\Civil\" "hrest.png"
${File} "..\..\shapes\Civil\" "line.png"
${File} "..\..\shapes\Civil\" "line.shape"
${File} "..\..\shapes\Civil\" "line.png"
${File} "..\..\shapes\Civil\" "vcompressor.png"
${File} "..\..\shapes\Civil\" "vcompressor.shape"
${File} "..\..\shapes\Civil\" "vcompressor.png"
${File} "..\..\shapes\Civil\" "vpump.png"
${File} "..\..\shapes\Civil\" "vpump.shape"
${File} "..\..\shapes\Civil\" "vpump.png"
${File} "..\..\shapes\Civil\" "vrest.png"
${File} "..\..\shapes\Civil\" "vrest.shape"
${File} "..\..\shapes\Civil\" "vrest.png"
${File} "..\..\shapes\Civil\" "water_level.png"
${File} "..\..\shapes\Civil\" "water_level.shape"
${File} "..\..\shapes\Civil\" "water_level.png"
${SetOutPath} "$INSTDIR\shapes\Contact"
${File} "..\..\shapes\Contact\" "c_if.png"
${File} "..\..\shapes\Contact\" "c_if.shape"
${File} "..\..\shapes\Contact\" "c_if.png"
${File} "..\..\shapes\Contact\" "c_ifnot.png"
${File} "..\..\shapes\Contact\" "c_ifnot.shape"
${File} "..\..\shapes\Contact\" "c_ifnot.png"
${File} "..\..\shapes\Contact\" "c_lamp.png"
${File} "..\..\shapes\Contact\" "c_lamp.shape"
${File} "..\..\shapes\Contact\" "c_lamp.png"
${File} "..\..\shapes\Contact\" "c_relay.png"
${File} "..\..\shapes\Contact\" "c_relay.shape"
${File} "..\..\shapes\Contact\" "c_relay.png"
${File} "..\..\shapes\Contact\" "l_if.png"
${File} "..\..\shapes\Contact\" "l_if.shape"
${File} "..\..\shapes\Contact\" "l_if.png"
${File} "..\..\shapes\Contact\" "l_ifnot.png"
${File} "..\..\shapes\Contact\" "l_ifnot.shape"
${File} "..\..\shapes\Contact\" "l_ifnot.png"
${File} "..\..\shapes\Contact\" "l_out.png"
${File} "..\..\shapes\Contact\" "l_out.shape"
${File} "..\..\shapes\Contact\" "l_out.png"
${File} "..\..\shapes\Contact\" "l_outj.png"
${File} "..\..\shapes\Contact\" "l_outj.shape"
${File} "..\..\shapes\Contact\" "l_outj.png"
${File} "..\..\shapes\Contact\" "l_outnot.png"
${File} "..\..\shapes\Contact\" "l_outnot.shape"
${File} "..\..\shapes\Contact\" "l_outnot.png"
${File} "..\..\shapes\Contact\" "l_outr.png"
${File} "..\..\shapes\Contact\" "l_outr.shape"
${File} "..\..\shapes\Contact\" "l_outr.png"
${File} "..\..\shapes\Contact\" "l_outrcep.png"
${File} "..\..\shapes\Contact\" "l_outrcep.shape"
${File} "..\..\shapes\Contact\" "l_outrcep.png"
${File} "..\..\shapes\Contact\" "l_outs.png"
${File} "..\..\shapes\Contact\" "l_outs.shape"
${File} "..\..\shapes\Contact\" "l_outs.png"
${File} "..\..\shapes\Contact\" "l_sout.png"
${File} "..\..\shapes\Contact\" "l_sout.shape"
${File} "..\..\shapes\Contact\" "l_sout.png"
${File} "..\..\shapes\Contact\" "l_soutnot.png"
${File} "..\..\shapes\Contact\" "l_soutnot.shape"
${File} "..\..\shapes\Contact\" "l_soutnot.png"
${File} "..\..\shapes\Contact\" "l_soutr.png"
${File} "..\..\shapes\Contact\" "l_soutr.shape"
${File} "..\..\shapes\Contact\" "l_soutr.png"
${File} "..\..\shapes\Contact\" "l_souts.png"
${File} "..\..\shapes\Contact\" "l_souts.shape"
${File} "..\..\shapes\Contact\" "l_souts.png"
${SetOutPath} "$INSTDIR\shapes\Cybernetics"
${File} "..\..\shapes\Cybernetics\" "b-integrator.png"
${File} "..\..\shapes\Cybernetics\" "b-integrator.shape"
${File} "..\..\shapes\Cybernetics\" "b-minus.png"
${File} "..\..\shapes\Cybernetics\" "b-minus.shape"
${File} "..\..\shapes\Cybernetics\" "b-sens.png"
${File} "..\..\shapes\Cybernetics\" "b-sens.shape"
${File} "..\..\shapes\Cybernetics\" "delta-t.png"
${File} "..\..\shapes\Cybernetics\" "delta-t.shape"
${File} "..\..\shapes\Cybernetics\" "empty-func.png"
${File} "..\..\shapes\Cybernetics\" "empty-func.shape"
${File} "..\..\shapes\Cybernetics\" "factor-0to-1.png"
${File} "..\..\shapes\Cybernetics\" "factor-0to-1.shape"
${File} "..\..\shapes\Cybernetics\" "factor-0to1.png"
${File} "..\..\shapes\Cybernetics\" "factor-0to1.shape"
${File} "..\..\shapes\Cybernetics\" "factor-greater1.png"
${File} "..\..\shapes\Cybernetics\" "factor-greater1.shape"
${File} "..\..\shapes\Cybernetics\" "factor-smaller-1.png"
${File} "..\..\shapes\Cybernetics\" "factor-smaller-1.shape"
${File} "..\..\shapes\Cybernetics\" "full-wave-rectifier.png"
${File} "..\..\shapes\Cybernetics\" "full-wave-rectifier.shape"
${File} "..\..\shapes\Cybernetics\" "half-wave-rectifier.png"
${File} "..\..\shapes\Cybernetics\" "half-wave-rectifier.shape"
${File} "..\..\shapes\Cybernetics\" "hpf.png"
${File} "..\..\shapes\Cybernetics\" "hpf.shape"
${File} "..\..\shapes\Cybernetics\" "l-integrator.png"
${File} "..\..\shapes\Cybernetics\" "l-integrator.shape"
${File} "..\..\shapes\Cybernetics\" "l-minus.png"
${File} "..\..\shapes\Cybernetics\" "l-minus.shape"
${File} "..\..\shapes\Cybernetics\" "l-sens.png"
${File} "..\..\shapes\Cybernetics\" "l-sens.shape"
${File} "..\..\shapes\Cybernetics\" "lpf.png"
${File} "..\..\shapes\Cybernetics\" "lpf.shape"
${File} "..\..\shapes\Cybernetics\" "negative-shift.png"
${File} "..\..\shapes\Cybernetics\" "negative-shift.shape"
${File} "..\..\shapes\Cybernetics\" "positive-shift.png"
${File} "..\..\shapes\Cybernetics\" "positive-shift.shape"
${File} "..\..\shapes\Cybernetics\" "product.png"
${File} "..\..\shapes\Cybernetics\" "product.shape"
${File} "..\..\shapes\Cybernetics\" "r-integrator.png"
${File} "..\..\shapes\Cybernetics\" "r-integrator.shape"
${File} "..\..\shapes\Cybernetics\" "r-minus.png"
${File} "..\..\shapes\Cybernetics\" "r-minus.shape"
${File} "..\..\shapes\Cybernetics\" "r-sens.png"
${File} "..\..\shapes\Cybernetics\" "r-sens.shape"
${File} "..\..\shapes\Cybernetics\" "relay.png"
${File} "..\..\shapes\Cybernetics\" "relay.shape"
${File} "..\..\shapes\Cybernetics\" "saturation.png"
${File} "..\..\shapes\Cybernetics\" "saturation.shape"
${File} "..\..\shapes\Cybernetics\" "sigmoid.png"
${File} "..\..\shapes\Cybernetics\" "sigmoid.shape"
${File} "..\..\shapes\Cybernetics\" "sine.png"
${File} "..\..\shapes\Cybernetics\" "sine.shape"
${File} "..\..\shapes\Cybernetics\" "sum.png"
${File} "..\..\shapes\Cybernetics\" "sum.shape"
${File} "..\..\shapes\Cybernetics\" "t-integrator.png"
${File} "..\..\shapes\Cybernetics\" "t-integrator.shape"
${File} "..\..\shapes\Cybernetics\" "t-minus.png"
${File} "..\..\shapes\Cybernetics\" "t-minus.shape"
${File} "..\..\shapes\Cybernetics\" "t-sens.png"
${File} "..\..\shapes\Cybernetics\" "t-sens.shape"
${SetOutPath} "$INSTDIR\shapes\Electric"
${File} "..\..\shapes\Electric\" "cnx.png"
${File} "..\..\shapes\Electric\" "cnx.shape"
${File} "..\..\shapes\Electric\" "cnx.png"
${File} "..\..\shapes\Electric\" "command.png"
${File} "..\..\shapes\Electric\" "command.shape"
${File} "..\..\shapes\Electric\" "command.png"
${File} "..\..\shapes\Electric\" "contact_f.png"
${File} "..\..\shapes\Electric\" "contact_f.shape"
${File} "..\..\shapes\Electric\" "contact_f.png"
${File} "..\..\shapes\Electric\" "contact_o.png"
${File} "..\..\shapes\Electric\" "contact_o.shape"
${File} "..\..\shapes\Electric\" "contact_o.png"
${File} "..\..\shapes\Electric\" "intpos_f.png"
${File} "..\..\shapes\Electric\" "intpos_f.shape"
${File} "..\..\shapes\Electric\" "intpos_f.png"
${File} "..\..\shapes\Electric\" "intpos_o.png"
${File} "..\..\shapes\Electric\" "intpos_o.shape"
${File} "..\..\shapes\Electric\" "intpos_o.png"
${File} "..\..\shapes\Electric\" "lamp.png"
${File} "..\..\shapes\Electric\" "lamp.shape"
${File} "..\..\shapes\Electric\" "lamp.png"
${File} "..\..\shapes\Electric\" "relay.png"
${File} "..\..\shapes\Electric\" "relay.shape"
${File} "..\..\shapes\Electric\" "relay.png"
${File} "..\..\shapes\Electric\" "vcommand.png"
${File} "..\..\shapes\Electric\" "vcommand.shape"
${File} "..\..\shapes\Electric\" "vcommand.png"
${File} "..\..\shapes\Electric\" "vcontact_f.png"
${File} "..\..\shapes\Electric\" "vcontact_f.shape"
${File} "..\..\shapes\Electric\" "vcontact_f.png"
${File} "..\..\shapes\Electric\" "vcontact_o.png"
${File} "..\..\shapes\Electric\" "vcontact_o.shape"
${File} "..\..\shapes\Electric\" "vcontact_o.png"
${File} "..\..\shapes\Electric\" "vintpos_f.png"
${File} "..\..\shapes\Electric\" "vintpos_f.shape"
${File} "..\..\shapes\Electric\" "vintpos_f.png"
${File} "..\..\shapes\Electric\" "vintpos_o.png"
${File} "..\..\shapes\Electric\" "vintpos_o.shape"
${File} "..\..\shapes\Electric\" "vintpos_o.png"
${File} "..\..\shapes\Electric\" "vlamp.png"
${File} "..\..\shapes\Electric\" "vlamp.shape"
${File} "..\..\shapes\Electric\" "vlamp.png"
${File} "..\..\shapes\Electric\" "vrelay.png"
${File} "..\..\shapes\Electric\" "vrelay.shape"
${File} "..\..\shapes\Electric\" "vrelay.png"
${SetOutPath} "$INSTDIR\shapes\flowchart"
${File} "..\..\shapes\flowchart\" "collate.png"
${File} "..\..\shapes\flowchart\" "collate.shape"
${File} "..\..\shapes\flowchart\" "collate.png"
${File} "..\..\shapes\flowchart\" "datasource.shape"
${File} "..\..\shapes\flowchart\" "datasource.png"
${File} "..\..\shapes\flowchart\" "delay.png"
${File} "..\..\shapes\flowchart\" "delay.shape"
${File} "..\..\shapes\flowchart\" "delay.png"
${File} "..\..\shapes\flowchart\" "display.png"
${File} "..\..\shapes\flowchart\" "display.shape"
${File} "..\..\shapes\flowchart\" "display.png"
${File} "..\..\shapes\flowchart\" "document.png"
${File} "..\..\shapes\flowchart\" "document.shape"
${File} "..\..\shapes\flowchart\" "document.png"
${File} "..\..\shapes\flowchart\" "extract.png"
${File} "..\..\shapes\flowchart\" "extract.shape"
${File} "..\..\shapes\flowchart\" "extract.png"
${File} "..\..\shapes\flowchart\" "intstorage.png"
${File} "..\..\shapes\flowchart\" "intstorage.shape"
${File} "..\..\shapes\flowchart\" "intstorage.png"
${File} "..\..\shapes\flowchart\" "magdisk.png"
${File} "..\..\shapes\flowchart\" "magdisk.shape"
${File} "..\..\shapes\flowchart\" "magdisk.png"
${File} "..\..\shapes\flowchart\" "magdrum.png"
${File} "..\..\shapes\flowchart\" "magdrum.shape"
${File} "..\..\shapes\flowchart\" "magdrum.png"
${File} "..\..\shapes\flowchart\" "magtape.png"
${File} "..\..\shapes\flowchart\" "magtape.shape"
${File} "..\..\shapes\flowchart\" "magtape.png"
${File} "..\..\shapes\flowchart\" "manualinput.png"
${File} "..\..\shapes\flowchart\" "manualinput.shape"
${File} "..\..\shapes\flowchart\" "manualinput.png"
${File} "..\..\shapes\flowchart\" "manualop.png"
${File} "..\..\shapes\flowchart\" "manualop.shape"
${File} "..\..\shapes\flowchart\" "manualop.png"
${File} "..\..\shapes\flowchart\" "merge.png"
${File} "..\..\shapes\flowchart\" "merge.shape"
${File} "..\..\shapes\flowchart\" "merge.png"
${File} "..\..\shapes\flowchart\" "offlinestore.png"
${File} "..\..\shapes\flowchart\" "offlinestore.shape"
${File} "..\..\shapes\flowchart\" "offlinestore.png"
${File} "..\..\shapes\flowchart\" "offpageconn.png"
${File} "..\..\shapes\flowchart\" "offpageconn.shape"
${File} "..\..\shapes\flowchart\" "offpageconn.png"
${File} "..\..\shapes\flowchart\" "or.png"
${File} "..\..\shapes\flowchart\" "or.shape"
${File} "..\..\shapes\flowchart\" "or.png"
${File} "..\..\shapes\flowchart\" "predefdproc.png"
${File} "..\..\shapes\flowchart\" "predefdproc.shape"
${File} "..\..\shapes\flowchart\" "predefdproc.png"
${File} "..\..\shapes\flowchart\" "preparation.png"
${File} "..\..\shapes\flowchart\" "preparation.shape"
${File} "..\..\shapes\flowchart\" "preparation.png"
${File} "..\..\shapes\flowchart\" "punchedcard.png"
${File} "..\..\shapes\flowchart\" "punchedcard.shape"
${File} "..\..\shapes\flowchart\" "punchedcard.png"
${File} "..\..\shapes\flowchart\" "punchedtape.png"
${File} "..\..\shapes\flowchart\" "punchedtape.shape"
${File} "..\..\shapes\flowchart\" "punchedtape.png"
${File} "..\..\shapes\flowchart\" "sort.png"
${File} "..\..\shapes\flowchart\" "sort.shape"
${File} "..\..\shapes\flowchart\" "sort.png"
${File} "..\..\shapes\flowchart\" "sumjunction.png"
${File} "..\..\shapes\flowchart\" "sumjunction.shape"
${File} "..\..\shapes\flowchart\" "sumjunction.png"
${File} "..\..\shapes\flowchart\" "terminal.png"
${File} "..\..\shapes\flowchart\" "terminal.shape"
${File} "..\..\shapes\flowchart\" "terminal.png"
${File} "..\..\shapes\flowchart\" "transaction.png"
${File} "..\..\shapes\flowchart\" "transaction.shape"
${File} "..\..\shapes\flowchart\" "transaction.png"
${File} "..\..\shapes\flowchart\" "transmittape.png"
${File} "..\..\shapes\flowchart\" "transmittape.shape"
${File} "..\..\shapes\flowchart\" "transmittape.png"
${SetOutPath} "$INSTDIR\shapes\Gane_and_Sarson"
${File} "..\..\shapes\Gane_and_Sarson\" "alt-entity.png"
${File} "..\..\shapes\Gane_and_Sarson\" "alt-entity.shape"
${File} "..\..\shapes\Gane_and_Sarson\" "data_store.png"
${File} "..\..\shapes\Gane_and_Sarson\" "data_store.shape"
${File} "..\..\shapes\Gane_and_Sarson\" "entity.png"
${File} "..\..\shapes\Gane_and_Sarson\" "entity.shape"
${File} "..\..\shapes\Gane_and_Sarson\" "process.png"
${File} "..\..\shapes\Gane_and_Sarson\" "process.shape"
${SetOutPath} "$INSTDIR\shapes\jigsaw"
${File} "..\..\shapes\jigsaw\" "part_iiii.png"
${File} "..\..\shapes\jigsaw\" "part_iiii.shape"
${File} "..\..\shapes\jigsaw\" "part_iiii.png"
${File} "..\..\shapes\jigsaw\" "part_iiio.png"
${File} "..\..\shapes\jigsaw\" "part_iiio.shape"
${File} "..\..\shapes\jigsaw\" "part_iiio.png"
${File} "..\..\shapes\jigsaw\" "part_iioi.png"
${File} "..\..\shapes\jigsaw\" "part_iioi.shape"
${File} "..\..\shapes\jigsaw\" "part_iioi.png"
${File} "..\..\shapes\jigsaw\" "part_iioo.png"
${File} "..\..\shapes\jigsaw\" "part_iioo.shape"
${File} "..\..\shapes\jigsaw\" "part_iioo.png"
${File} "..\..\shapes\jigsaw\" "part_ioii.png"
${File} "..\..\shapes\jigsaw\" "part_ioii.shape"
${File} "..\..\shapes\jigsaw\" "part_ioii.png"
${File} "..\..\shapes\jigsaw\" "part_ioio.png"
${File} "..\..\shapes\jigsaw\" "part_ioio.shape"
${File} "..\..\shapes\jigsaw\" "part_ioio.png"
${File} "..\..\shapes\jigsaw\" "part_iooi.png"
${File} "..\..\shapes\jigsaw\" "part_iooi.shape"
${File} "..\..\shapes\jigsaw\" "part_iooi.png"
${File} "..\..\shapes\jigsaw\" "part_iooo.png"
${File} "..\..\shapes\jigsaw\" "part_iooo.shape"
${File} "..\..\shapes\jigsaw\" "part_iooo.png"
${File} "..\..\shapes\jigsaw\" "part_oiii.png"
${File} "..\..\shapes\jigsaw\" "part_oiii.shape"
${File} "..\..\shapes\jigsaw\" "part_oiii.png"
${File} "..\..\shapes\jigsaw\" "part_oiio.png"
${File} "..\..\shapes\jigsaw\" "part_oiio.shape"
${File} "..\..\shapes\jigsaw\" "part_oiio.png"
${File} "..\..\shapes\jigsaw\" "part_oioi.png"
${File} "..\..\shapes\jigsaw\" "part_oioi.shape"
${File} "..\..\shapes\jigsaw\" "part_oioi.png"
${File} "..\..\shapes\jigsaw\" "part_oioo.png"
${File} "..\..\shapes\jigsaw\" "part_oioo.shape"
${File} "..\..\shapes\jigsaw\" "part_oioo.png"
${File} "..\..\shapes\jigsaw\" "part_ooii.png"
${File} "..\..\shapes\jigsaw\" "part_ooii.shape"
${File} "..\..\shapes\jigsaw\" "part_ooii.png"
${File} "..\..\shapes\jigsaw\" "part_ooio.png"
${File} "..\..\shapes\jigsaw\" "part_ooio.shape"
${File} "..\..\shapes\jigsaw\" "part_ooio.png"
${File} "..\..\shapes\jigsaw\" "part_oooi.png"
${File} "..\..\shapes\jigsaw\" "part_oooi.shape"
${File} "..\..\shapes\jigsaw\" "part_oooi.png"
${File} "..\..\shapes\jigsaw\" "part_oooo.png"
${File} "..\..\shapes\jigsaw\" "part_oooo.shape"
${File} "..\..\shapes\jigsaw\" "part_oooo.png"
${SetOutPath} "$INSTDIR\shapes\Lights"
${File} "..\..\shapes\Lights\" "ACL.png"
${File} "..\..\shapes\Lights\" "ACL.shape"
${File} "..\..\shapes\Lights\" "Blacklight.png"
${File} "..\..\shapes\Lights\" "Blacklight.shape"
${File} "..\..\shapes\Lights\" "Blinders.png"
${File} "..\..\shapes\Lights\" "Blinders.shape"
${File} "..\..\shapes\Lights\" "ERS.png"
${File} "..\..\shapes\Lights\" "ERS.shape"
${File} "..\..\shapes\Lights\" "Fresnel.png"
${File} "..\..\shapes\Lights\" "Fresnel.shape"
${File} "..\..\shapes\Lights\" "Moving_head.png"
${File} "..\..\shapes\Lights\" "Moving_head.shape"
${File} "..\..\shapes\Lights\" "PAR.png"
${File} "..\..\shapes\Lights\" "PAR.shape"
${File} "..\..\shapes\Lights\" "PAR_floor.png"
${File} "..\..\shapes\Lights\" "PAR_floor.shape"
${File} "..\..\shapes\Lights\" "PC.png"
${File} "..\..\shapes\Lights\" "PC.shape"
${File} "..\..\shapes\Lights\" "Scanner.png"
${File} "..\..\shapes\Lights\" "Scanner.shape"
${File} "..\..\shapes\Lights\" "Striplight.png"
${File} "..\..\shapes\Lights\" "Striplight.shape"
${File} "..\..\shapes\Lights\" "Stroboscope.png"
${File} "..\..\shapes\Lights\" "Stroboscope.shape"
${File} "..\..\shapes\Lights\" "Structure.png"
${File} "..\..\shapes\Lights\" "Structure.shape"
${SetOutPath} "$INSTDIR\shapes\Logic"
${File} "..\..\shapes\Logic\" "and.png"
${File} "..\..\shapes\Logic\" "and.shape"
${File} "..\..\shapes\Logic\" "buffer.png"
${File} "..\..\shapes\Logic\" "buffer.shape"
${File} "..\..\shapes\Logic\" "connector.png"
${File} "..\..\shapes\Logic\" "connector.shape"
${File} "..\..\shapes\Logic\" "inverter.png"
${File} "..\..\shapes\Logic\" "inverter.shape"
${File} "..\..\shapes\Logic\" "nand.png"
${File} "..\..\shapes\Logic\" "nand.shape"
${File} "..\..\shapes\Logic\" "nor.png"
${File} "..\..\shapes\Logic\" "nor.shape"
${File} "..\..\shapes\Logic\" "not.png"
${File} "..\..\shapes\Logic\" "not.shape"
${File} "..\..\shapes\Logic\" "or.png"
${File} "..\..\shapes\Logic\" "or.shape"
${File} "..\..\shapes\Logic\" "xor.png"
${File} "..\..\shapes\Logic\" "xor.shape"
${SetOutPath} "$INSTDIR\shapes\Map\Isometric"
${File} "..\..\shapes\Map\Isometric\" "Block1.png"
${File} "..\..\shapes\Map\Isometric\" "Block1.shape"
${File} "..\..\shapes\Map\Isometric\" "Block2.png"
${File} "..\..\shapes\Map\Isometric\" "Block2.shape"
${File} "..\..\shapes\Map\Isometric\" "Block3.png"
${File} "..\..\shapes\Map\Isometric\" "Block3.shape"
${File} "..\..\shapes\Map\Isometric\" "Block4.png"
${File} "..\..\shapes\Map\Isometric\" "Block4.shape"
${File} "..\..\shapes\Map\Isometric\" "Block5.png"
${File} "..\..\shapes\Map\Isometric\" "Block5.shape"
${File} "..\..\shapes\Map\Isometric\" "Block6.png"
${File} "..\..\shapes\Map\Isometric\" "Block6.shape"
${File} "..\..\shapes\Map\Isometric\" "Block7.png"
${File} "..\..\shapes\Map\Isometric\" "Block7.shape"
${File} "..\..\shapes\Map\Isometric\" "Car1.png"
${File} "..\..\shapes\Map\Isometric\" "Car1.shape"
${File} "..\..\shapes\Map\Isometric\" "Car2.png"
${File} "..\..\shapes\Map\Isometric\" "Car2.shape"
${File} "..\..\shapes\Map\Isometric\" "Corner1.png"
${File} "..\..\shapes\Map\Isometric\" "Corner1.shape"
${File} "..\..\shapes\Map\Isometric\" "Corner2.png"
${File} "..\..\shapes\Map\Isometric\" "Corner2.shape"
${File} "..\..\shapes\Map\Isometric\" "Crossroads.png"
${File} "..\..\shapes\Map\Isometric\" "Crossroads.shape"
${File} "..\..\shapes\Map\Isometric\" "Elevated.png"
${File} "..\..\shapes\Map\Isometric\" "Elevated.shape"
${File} "..\..\shapes\Map\Isometric\" "Factory.png"
${File} "..\..\shapes\Map\Isometric\" "Factory.shape"
${File} "..\..\shapes\Map\Isometric\" "FootBridge.png"
${File} "..\..\shapes\Map\Isometric\" "FootBridge.shape"
${File} "..\..\shapes\Map\Isometric\" "OneWay.png"
${File} "..\..\shapes\Map\Isometric\" "OneWay.shape"
${File} "..\..\shapes\Map\Isometric\" "RedCar.png"
${File} "..\..\shapes\Map\Isometric\" "RedCar.shape"
${File} "..\..\shapes\Map\Isometric\" "River.png"
${File} "..\..\shapes\Map\Isometric\" "River.shape"
${File} "..\..\shapes\Map\Isometric\" "Road1.png"
${File} "..\..\shapes\Map\Isometric\" "Road1.shape"
${File} "..\..\shapes\Map\Isometric\" "Roof1.png"
${File} "..\..\shapes\Map\Isometric\" "Roof1.shape"
${File} "..\..\shapes\Map\Isometric\" "StraightRoad1.png"
${File} "..\..\shapes\Map\Isometric\" "StraightRoad1.shape"
${File} "..\..\shapes\Map\Isometric\" "T-Junction.png"
${File} "..\..\shapes\Map\Isometric\" "T-Junction.shape"
${File} "..\..\shapes\Map\Isometric\" "Train1.png"
${File} "..\..\shapes\Map\Isometric\" "Train1.shape"
${File} "..\..\shapes\Map\Isometric\" "Train2.png"
${File} "..\..\shapes\Map\Isometric\" "Train2.shape"
${File} "..\..\shapes\Map\Isometric\" "Tree1.png"
${File} "..\..\shapes\Map\Isometric\" "Tree1.shape"
${SetOutPath} "$INSTDIR\shapes\Misc"
${File} "..\..\shapes\Misc\" "expended-node.png"
${File} "..\..\shapes\Misc\" "expended-node.shape"
${File} "..\..\shapes\Misc\" "expensible-node.png"
${File} "..\..\shapes\Misc\" "expensible-node.shape"
${File} "..\..\shapes\Misc\" "file.png"
${File} "..\..\shapes\Misc\" "file.shape"
${File} "..\..\shapes\Misc\" "folder.png"
${File} "..\..\shapes\Misc\" "folder.shape"
${File} "..\..\objects\Misc\pixmaps\" "analog_clock.xpm"
${File} "..\..\objects\Misc\pixmaps\" "newgroup.xpm"
${File} "..\..\objects\Misc\pixmaps\" "tree.xpm"
${SetOutPath} "$INSTDIR\shapes\MSE"
${File} "..\..\shapes\MSE\" "demultiplexer.png"
${File} "..\..\shapes\MSE\" "demultiplexer.shape"
${File} "..\..\shapes\MSE\" "demultiplexer.png"
${File} "..\..\shapes\MSE\" "large_extension_node.png"
${File} "..\..\shapes\MSE\" "large_extension_node.shape"
${File} "..\..\shapes\MSE\" "large_extension_node.png"
${File} "..\..\shapes\MSE\" "multiplexer.png"
${File} "..\..\shapes\MSE\" "multiplexer.shape"
${File} "..\..\shapes\MSE\" "multiplexer.png"
${File} "..\..\shapes\MSE\" "node_center.png"
${File} "..\..\shapes\MSE\" "node_center.shape"
${File} "..\..\shapes\MSE\" "node_center.png"
${File} "..\..\shapes\MSE\" "small_extension_node.png"
${File} "..\..\shapes\MSE\" "small_extension_node.shape"
${File} "..\..\shapes\MSE\" "small_extension_node.png"
${File} "..\..\shapes\MSE\" "tacsat.png"
${File} "..\..\shapes\MSE\" "tacsat.shape"
${File} "..\..\shapes\MSE\" "tacsat.png"
${SetOutPath} "$INSTDIR\shapes\network"
${File} "..\..\shapes\network\" "antenna.png"
${File} "..\..\shapes\network\" "antenna.shape"
${File} "..\..\shapes\network\" "antenna.png"
${File} "..\..\shapes\network\" "computer.png"
${File} "..\..\shapes\network\" "computer.shape"
${File} "..\..\shapes\network\" "computer.png"
${File} "..\..\shapes\network\" "dat_external.png"
${File} "..\..\shapes\network\" "dat_external.shape"
${File} "..\..\shapes\network\" "dat_external.png"
${File} "..\..\shapes\network\" "digitizing_board.png"
${File} "..\..\shapes\network\" "digitizing_board.shape"
${File} "..\..\shapes\network\" "disc.png"
${File} "..\..\shapes\network\" "disc.shape"
${File} "..\..\shapes\network\" "disc.png"
${File} "..\..\shapes\network\" "diskette.png"
${File} "..\..\shapes\network\" "diskette.shape"
${File} "..\..\shapes\network\" "diskette.png"
${File} "..\..\shapes\network\" "firewall.png"
${File} "..\..\shapes\network\" "firewall.shape"
${File} "..\..\shapes\network\" "firewall.png"
${File} "..\..\shapes\network\" "flash.png"
${File} "..\..\shapes\network\" "flash.shape"
${File} "..\..\shapes\network\" "flash.png"
${File} "..\..\shapes\network\" "genmonitor.png"
${File} "..\..\shapes\network\" "genmonitor.shape"
${File} "..\..\shapes\network\" "genmonitor.png"
${File} "..\..\shapes\network\" "hub.png"
${File} "..\..\shapes\network\" "hub.shape"
${File} "..\..\shapes\network\" "hub.png"
${File} "..\..\shapes\network\" "laptop.png"
${File} "..\..\shapes\network\" "laptop.shape"
${File} "..\..\shapes\network\" "mobile_phone.png"
${File} "..\..\shapes\network\" "mobile_phone.shape"
${File} "..\..\shapes\network\" "mobile_phone.png"
${File} "..\..\shapes\network\" "modem.png"
${File} "..\..\shapes\network\" "modem.shape"
${File} "..\..\shapes\network\" "modem.png"
${File} "..\..\shapes\network\" "modularswitch.png"
${File} "..\..\shapes\network\" "modularswitch.shape"
${File} "..\..\shapes\network\" "modularswitch.png"
${File} "..\..\shapes\network\" "monitor.png"
${File} "..\..\shapes\network\" "monitor.shape"
${File} "..\..\shapes\network\" "monitor.png"
${File} "..\..\shapes\network\" "nwcloud.png"
${File} "..\..\shapes\network\" "nwcloud.shape"
${File} "..\..\shapes\network\" "nwcloud.png"
${File} "..\..\shapes\network\" "patch-panel.png"
${File} "..\..\shapes\network\" "patch-panel.shape"
${File} "..\..\shapes\network\" "patch-panel.png"
${File} "..\..\shapes\network\" "pc_bigtower.png"
${File} "..\..\shapes\network\" "pc_bigtower.shape"
${File} "..\..\shapes\network\" "pc_bigtower.png"
${File} "..\..\shapes\network\" "pc_desktop.png"
${File} "..\..\shapes\network\" "pc_desktop.shape"
${File} "..\..\shapes\network\" "pc_desktop.png"
${File} "..\..\shapes\network\" "pc_miditower.png"
${File} "..\..\shapes\network\" "pc_miditower.shape"
${File} "..\..\shapes\network\" "pc_miditower.png"
${File} "..\..\shapes\network\" "pc_minitower.png"
${File} "..\..\shapes\network\" "pc_minitower.shape"
${File} "..\..\shapes\network\" "pc_minitower.png"
${File} "..\..\shapes\network\" "plotter.png"
${File} "..\..\shapes\network\" "plotter.shape"
${File} "..\..\shapes\network\" "printer.png"
${File} "..\..\shapes\network\" "printer.shape"
${File} "..\..\shapes\network\" "printer.png"
${File} "..\..\shapes\network\" "rj45plug.png"
${File} "..\..\shapes\network\" "rj45plug.shape"
${File} "..\..\shapes\network\" "rj45plug.png"
${File} "..\..\shapes\network\" "router-symbol.png"
${File} "..\..\shapes\network\" "router-symbol.shape"
${File} "..\..\shapes\network\" "router-symbol.png"
${File} "..\..\shapes\network\" "sceadplug.png"
${File} "..\..\shapes\network\" "sceadplug.shape"
${File} "..\..\shapes\network\" "sceadplug.png"
${File} "..\..\shapes\network\" "speaker.png"
${File} "..\..\shapes\network\" "speaker.shape"
${File} "..\..\shapes\network\" "speaker.png"
${File} "..\..\shapes\network\" "speaker_amp.png"
${File} "..\..\shapes\network\" "speaker_amp.shape"
${File} "..\..\shapes\network\" "speaker_amp.png"
${File} "..\..\shapes\network\" "switch-atm-symbol.png"
${File} "..\..\shapes\network\" "switch-atm-symbol.shape"
${File} "..\..\shapes\network\" "switch-atm-symbol.png"
${File} "..\..\shapes\network\" "switch-symbol.png"
${File} "..\..\shapes\network\" "switch-symbol.shape"
${File} "..\..\shapes\network\" "switch-symbol.png"
${File} "..\..\shapes\network\" "telephone.png"
${File} "..\..\shapes\network\" "telephone.shape"
${File} "..\..\shapes\network\" "workstation.png"
${File} "..\..\shapes\network\" "workstation.shape"
${File} "..\..\shapes\network\" "workstation.png"
${File} "..\..\shapes\network\" "zip-disk.png"
${File} "..\..\shapes\network\" "zip-disk.shape"
${File} "..\..\shapes\network\" "zip-disk.png"
${SetOutPath} "$INSTDIR\shapes\Pneumatic"
${File} "..\..\shapes\Pneumatic\" "cnx.png"
${File} "..\..\shapes\Pneumatic\" "cnx.shape"
${File} "..\..\shapes\Pneumatic\" "cnx.png"
${File} "..\..\shapes\Pneumatic\" "comelec1.png"
${File} "..\..\shapes\Pneumatic\" "comelec1.shape"
${File} "..\..\shapes\Pneumatic\" "comelec1.png"
${File} "..\..\shapes\Pneumatic\" "comelec2.png"
${File} "..\..\shapes\Pneumatic\" "comelec2.shape"
${File} "..\..\shapes\Pneumatic\" "comelec2.png"
${File} "..\..\shapes\Pneumatic\" "commusc.png"
${File} "..\..\shapes\Pneumatic\" "commusc.shape"
${File} "..\..\shapes\Pneumatic\" "commusc.png"
${File} "..\..\shapes\Pneumatic\" "compb.png"
${File} "..\..\shapes\Pneumatic\" "compb.shape"
${File} "..\..\shapes\Pneumatic\" "compb.png"
${File} "..\..\shapes\Pneumatic\" "compilh.png"
${File} "..\..\shapes\Pneumatic\" "compilh.shape"
${File} "..\..\shapes\Pneumatic\" "compilh.png"
${File} "..\..\shapes\Pneumatic\" "compilp.png"
${File} "..\..\shapes\Pneumatic\" "compilp.shape"
${File} "..\..\shapes\Pneumatic\" "compilp.png"
${File} "..\..\shapes\Pneumatic\" "compush.png"
${File} "..\..\shapes\Pneumatic\" "compush.shape"
${File} "..\..\shapes\Pneumatic\" "compush.png"
${File} "..\..\shapes\Pneumatic\" "comspr.png"
${File} "..\..\shapes\Pneumatic\" "comspr.shape"
${File} "..\..\shapes\Pneumatic\" "comspr.png"
${File} "..\..\shapes\Pneumatic\" "dejack.png"
${File} "..\..\shapes\Pneumatic\" "dejack.shape"
${File} "..\..\shapes\Pneumatic\" "dejack.png"
${File} "..\..\shapes\Pneumatic\" "dist22.png"
${File} "..\..\shapes\Pneumatic\" "dist22.shape"
${File} "..\..\shapes\Pneumatic\" "dist22.png"
${File} "..\..\shapes\Pneumatic\" "dist32.png"
${File} "..\..\shapes\Pneumatic\" "dist32.shape"
${File} "..\..\shapes\Pneumatic\" "dist32.png"
${File} "..\..\shapes\Pneumatic\" "dist42.png"
${File} "..\..\shapes\Pneumatic\" "dist42.shape"
${File} "..\..\shapes\Pneumatic\" "dist42.png"
${File} "..\..\shapes\Pneumatic\" "dist52.png"
${File} "..\..\shapes\Pneumatic\" "dist52.shape"
${File} "..\..\shapes\Pneumatic\" "dist52.png"
${File} "..\..\shapes\Pneumatic\" "drain.png"
${File} "..\..\shapes\Pneumatic\" "drain.shape"
${File} "..\..\shapes\Pneumatic\" "drain.png"
${File} "..\..\shapes\Pneumatic\" "press.png"
${File} "..\..\shapes\Pneumatic\" "press.shape"
${File} "..\..\shapes\Pneumatic\" "press.png"
${File} "..\..\shapes\Pneumatic\" "presshy.png"
${File} "..\..\shapes\Pneumatic\" "presshy.shape"
${File} "..\..\shapes\Pneumatic\" "presshy.png"
${File} "..\..\shapes\Pneumatic\" "presspn.png"
${File} "..\..\shapes\Pneumatic\" "presspn.shape"
${File} "..\..\shapes\Pneumatic\" "presspn.png"
${File} "..\..\shapes\Pneumatic\" "seijack.png"
${File} "..\..\shapes\Pneumatic\" "seijack.shape"
${File} "..\..\shapes\Pneumatic\" "seijack.png"
${File} "..\..\shapes\Pneumatic\" "seojack.png"
${File} "..\..\shapes\Pneumatic\" "seojack.shape"
${File} "..\..\shapes\Pneumatic\" "seojack.png"
${SetOutPath} "$INSTDIR\shapes\RDP"
${File} "..\..\shapes\RDP\" "place.png"
${File} "..\..\shapes\RDP\" "place.shape"
${File} "..\..\shapes\RDP\" "place_marquee.png"
${File} "..\..\shapes\RDP\" "place_marquee.shape"
${File} "..\..\shapes\RDP\" "transition.png"
${File} "..\..\shapes\RDP\" "transition.shape"
${File} "..\..\shapes\RDP\" "t_transition.png"
${File} "..\..\shapes\RDP\" "t_transition.shape"
${SetOutPath} "$INSTDIR\shapes\SDL"
${File} "..\..\shapes\SDL\" "block.png"
${File} "..\..\shapes\SDL\" "block.shape"
${File} "..\..\shapes\SDL\" "block.png"
${File} "..\..\shapes\SDL\" "comment.png"
${File} "..\..\shapes\SDL\" "comment.shape"
${File} "..\..\shapes\SDL\" "comment.png"
${File} "..\..\shapes\SDL\" "decision.png"
${File} "..\..\shapes\SDL\" "decision.shape"
${File} "..\..\shapes\SDL\" "decision.png"
${File} "..\..\shapes\SDL\" "function.png"
${File} "..\..\shapes\SDL\" "function.shape"
${File} "..\..\shapes\SDL\" "function.png"
${File} "..\..\shapes\SDL\" "header.png"
${File} "..\..\shapes\SDL\" "header.shape"
${File} "..\..\shapes\SDL\" "header.png"
${File} "..\..\shapes\SDL\" "inout.png"
${File} "..\..\shapes\SDL\" "inout.shape"
${File} "..\..\shapes\SDL\" "inout.png"
${File} "..\..\shapes\SDL\" "macro.png"
${File} "..\..\shapes\SDL\" "macro.shape"
${File} "..\..\shapes\SDL\" "macro.png"
${File} "..\..\shapes\SDL\" "note.png"
${File} "..\..\shapes\SDL\" "note.shape"
${File} "..\..\shapes\SDL\" "note.png"
${File} "..\..\shapes\SDL\" "process.png"
${File} "..\..\shapes\SDL\" "process.shape"
${File} "..\..\shapes\SDL\" "process.png"
${File} "..\..\shapes\SDL\" "receive.png"
${File} "..\..\shapes\SDL\" "receive.shape"
${File} "..\..\shapes\SDL\" "receive.png"
${File} "..\..\shapes\SDL\" "return.png"
${File} "..\..\shapes\SDL\" "return.shape"
${File} "..\..\shapes\SDL\" "return.png"
${File} "..\..\shapes\SDL\" "save.png"
${File} "..\..\shapes\SDL\" "save.shape"
${File} "..\..\shapes\SDL\" "save.png"
${File} "..\..\shapes\SDL\" "send.png"
${File} "..\..\shapes\SDL\" "send.shape"
${File} "..\..\shapes\SDL\" "send.png"
${File} "..\..\shapes\SDL\" "service.png"
${File} "..\..\shapes\SDL\" "service.shape"
${File} "..\..\shapes\SDL\" "service.png"
${File} "..\..\shapes\SDL\" "state.png"
${File} "..\..\shapes\SDL\" "state.shape"
${File} "..\..\shapes\SDL\" "state.png"
${File} "..\..\shapes\SDL\" "stop.png"
${File} "..\..\shapes\SDL\" "stop.shape"
${File} "..\..\shapes\SDL\" "stop.png"
${File} "..\..\shapes\SDL\" "task.png"
${File} "..\..\shapes\SDL\" "task.shape"
${File} "..\..\shapes\SDL\" "task.png"
${SetOutPath} "$INSTDIR\shapes\sybase"
${File} "..\..\shapes\sybase\" "client.png"
${File} "..\..\shapes\sybase\" "client.shape"
${File} "..\..\shapes\sybase\" "client.png"
${File} "..\..\shapes\sybase\" "dataserver.png"
${File} "..\..\shapes\sybase\" "dataserver.shape"
${File} "..\..\shapes\sybase\" "dataserver.png"
${File} "..\..\shapes\sybase\" "ltm.png"
${File} "..\..\shapes\sybase\" "ltm.shape"
${File} "..\..\shapes\sybase\" "ltm.png"
${File} "..\..\shapes\sybase\" "repserver.png"
${File} "..\..\shapes\sybase\" "repserver.shape"
${File} "..\..\shapes\sybase\" "repserver.png"
${File} "..\..\shapes\sybase\" "rsm.png"
${File} "..\..\shapes\sybase\" "rsm.shape"
${File} "..\..\shapes\sybase\" "rsm.png"
${File} "..\..\shapes\sybase\" "stableq.png"
${File} "..\..\shapes\sybase\" "stableq.shape"
${File} "..\..\shapes\sybase\" "stableq.png"
${SetOutPath} "$INSTDIR\sheets"
${File} "..\..\sheets\" "Assorted.sheet"
${File} "..\..\sheets\" "BPMN.sheet"
${File} "..\..\sheets\" "ChemEng.sheet"
${File} "..\..\sheets\" "chronogram.sheet"
${File} "..\..\sheets\" "Circuit.sheet"
${File} "..\..\sheets\" "ciscocomputer.sheet"
${File} "..\..\sheets\" "ciscohub.sheet"
${File} "..\..\sheets\" "ciscomisc.sheet"
${File} "..\..\sheets\" "cisconetwork.sheet"
${File} "..\..\sheets\" "ciscotelephony.sheet"
${File} "..\..\sheets\" "civil.sheet"
${File} "..\..\sheets\" "Contact.sheet"
${File} "..\..\sheets\" "Cybernetics.sheet"
${File} "..\..\sheets\" "Database.sheet"
${File} "..\..\sheets\" "Electric.sheet"
${File} "..\..\sheets\" "ER.sheet"
${File} "..\..\sheets\" "Flowchart.sheet"
${File} "..\..\sheets\" "FS.sheet"
${File} "..\..\sheets\" "Gane_and_Sarson.sheet"
${File} "..\..\sheets\" "GRAFCET.sheet"
${File} "..\..\sheets\" "IsometricMap.sheet"
${File} "..\..\sheets\" "Istar.sheet"
${File} "..\..\sheets\" "Jackson.sheet"
${File} "..\..\sheets\" "jigsaw.sheet"
${File} "..\..\sheets\" "KAOS.sheet"
${File} "..\..\sheets\" "Lights.sheet"
${File} "..\..\sheets\" "Logic.sheet"
${File} "..\..\sheets\" "Misc.sheet"
${File} "..\..\sheets\" "MSE.sheet"
${File} "..\..\sheets\" "network.sheet"
${File} "..\..\sheets\" "Pneumatic.sheet"
${File} "..\..\sheets\" "SADT.sheet"
${File} "..\..\sheets\" "SDL.sheet"
${File} "..\..\sheets\" "SISSI.sheet"
${File} "..\..\sheets\" "sybase.sheet"
${File} "..\..\sheets\" "UML.sheet"
${SetOutPath} "$INSTDIR\sheets\ER"
${File} "..\..\sheets\ER\" "weakentity.png"
${File} "..\..\sheets\ER\" "weakentity.png"
${SetOutPath} "$INSTDIR\sheets\GRAFCET"
${File} "..\..\sheets\GRAFCET\" "etapei.png"
${File} "..\..\sheets\GRAFCET\" "etapei.png"
${File} "..\..\sheets\GRAFCET\" "etapemc.png"
${File} "..\..\sheets\GRAFCET\" "etapemc.png"
${File} "..\..\sheets\GRAFCET\" "etapeme.png"
${File} "..\..\sheets\GRAFCET\" "etapeme.png"
${File} "..\..\sheets\GRAFCET\" "etapems.png"
${File} "..\..\sheets\GRAFCET\" "etapems.png"
${File} "..\..\sheets\GRAFCET\" "etapesp.png"
${File} "..\..\sheets\GRAFCET\" "etapesp.png"
${File} "..\..\sheets\GRAFCET\" "vergent_and.png"
${File} "..\..\sheets\GRAFCET\" "vergent_and.png"
${SetOutPath} "$INSTDIR\sheets\Istar"
${File} "..\..\sheets\Istar\" "agent.png"
${File} "..\..\sheets\Istar\" "agent.png"
${File} "..\..\sheets\Istar\" "decomposition.png"
${File} "..\..\sheets\Istar\" "decomposition.png"
${File} "..\..\sheets\Istar\" "dependency.png"
${File} "..\..\sheets\Istar\" "dependency.png"
${File} "..\..\sheets\Istar\" "goal.png"
${File} "..\..\sheets\Istar\" "goal.png"
${File} "..\..\sheets\Istar\" "means_ends.png"
${File} "..\..\sheets\Istar\" "means_ends.png"
${File} "..\..\sheets\Istar\" "neg_contrib.png"
${File} "..\..\sheets\Istar\" "neg_contrib.png"
${File} "..\..\sheets\Istar\" "position.png"
${File} "..\..\sheets\Istar\" "position.png"
${File} "..\..\sheets\Istar\" "pos_contrib.png"
${File} "..\..\sheets\Istar\" "pos_contrib.png"
${File} "..\..\sheets\Istar\" "role.png"
${File} "..\..\sheets\Istar\" "role.png"
${File} "..\..\sheets\Istar\" "task.png"
${File} "..\..\sheets\Istar\" "task.png"
${SetOutPath} "$INSTDIR\sheets\Jackson"
${File} "..\..\sheets\Jackson\" "designed_domain.png"
${File} "..\..\sheets\Jackson\" "designed_domain.png"
${File} "..\..\sheets\Jackson\" "machine_domain.png"
${File} "..\..\sheets\Jackson\" "machine_domain.png"
${File} "..\..\sheets\Jackson\" "req_phen.png"
${File} "..\..\sheets\Jackson\" "req_phen.png"
${SetOutPath} "$INSTDIR\sheets\KAOS"
${File} "..\..\sheets\KAOS\" "and-complete-ref.png"
${File} "..\..\sheets\KAOS\" "and-complete-ref.png"
${File} "..\..\sheets\KAOS\" "and-ref.png"
${File} "..\..\sheets\KAOS\" "and-ref.png"
${File} "..\..\sheets\KAOS\" "assumption.png"
${File} "..\..\sheets\KAOS\" "assumption.png"
${File} "..\..\sheets\KAOS\" "capable-of.png"
${File} "..\..\sheets\KAOS\" "capable-of.png"
${File} "..\..\sheets\KAOS\" "conflicts.png"
${File} "..\..\sheets\KAOS\" "conflicts.png"
${File} "..\..\sheets\KAOS\" "controls.png"
${File} "..\..\sheets\KAOS\" "controls.png"
${File} "..\..\sheets\KAOS\" "input.png"
${File} "..\..\sheets\KAOS\" "input.png"
${File} "..\..\sheets\KAOS\" "monitors.png"
${File} "..\..\sheets\KAOS\" "monitors.png"
${File} "..\..\sheets\KAOS\" "obstacle.png"
${File} "..\..\sheets\KAOS\" "obstacle.png"
${File} "..\..\sheets\KAOS\" "obstructs.png"
${File} "..\..\sheets\KAOS\" "obstructs.png"
${File} "..\..\sheets\KAOS\" "op-ref.png"
${File} "..\..\sheets\KAOS\" "op-ref.png"
${File} "..\..\sheets\KAOS\" "or-complete-ref.png"
${File} "..\..\sheets\KAOS\" "or-complete-ref.png"
${File} "..\..\sheets\KAOS\" "or-ref.png"
${File} "..\..\sheets\KAOS\" "or-ref.png"
${File} "..\..\sheets\KAOS\" "output.png"
${File} "..\..\sheets\KAOS\" "output.png"
${File} "..\..\sheets\KAOS\" "performs.png"
${File} "..\..\sheets\KAOS\" "performs.png"
${File} "..\..\sheets\KAOS\" "requirement.png"
${File} "..\..\sheets\KAOS\" "requirement.png"
${File} "..\..\sheets\KAOS\" "responsibility.png"
${File} "..\..\sheets\KAOS\" "responsibility.png"
${File} "..\..\sheets\KAOS\" "softgoal.png"
${File} "..\..\sheets\KAOS\" "softgoal.png"
${SetOutPath} "$INSTDIR\sheets\SISSI"
${File} "..\..\sheets\SISSI\" "1.xml"
${File} "..\..\sheets\SISSI\" "10.xml"
${File} "..\..\sheets\SISSI\" "11.xml"
${File} "..\..\sheets\SISSI\" "12.xml"
${File} "..\..\sheets\SISSI\" "13.xml"
${File} "..\..\sheets\SISSI\" "14.xml"
${File} "..\..\sheets\SISSI\" "15.xml"
${File} "..\..\sheets\SISSI\" "16.xml"
${File} "..\..\sheets\SISSI\" "17.xml"
${File} "..\..\sheets\SISSI\" "18.xml"
${File} "..\..\sheets\SISSI\" "19.xml"
${File} "..\..\sheets\SISSI\" "2.xml"
${File} "..\..\sheets\SISSI\" "20.xml"
${File} "..\..\sheets\SISSI\" "21.xml"
${File} "..\..\sheets\SISSI\" "22.xml"
${File} "..\..\sheets\SISSI\" "23.xml"
${File} "..\..\sheets\SISSI\" "28.xml"
${File} "..\..\sheets\SISSI\" "29.xml"
${File} "..\..\sheets\SISSI\" "3.xml"
${File} "..\..\sheets\SISSI\" "30.xml"
${File} "..\..\sheets\SISSI\" "31.xml"
${File} "..\..\sheets\SISSI\" "32.xml"
${File} "..\..\sheets\SISSI\" "33.xml"
${File} "..\..\sheets\SISSI\" "34.xml"
${File} "..\..\sheets\SISSI\" "35.xml"
${File} "..\..\sheets\SISSI\" "36.xml"
${File} "..\..\sheets\SISSI\" "37.xml"
${File} "..\..\sheets\SISSI\" "38.xml"
${File} "..\..\sheets\SISSI\" "39.xml"
${File} "..\..\sheets\SISSI\" "4.xml"
${File} "..\..\sheets\SISSI\" "40.xml"
${File} "..\..\sheets\SISSI\" "41.xml"
${File} "..\..\sheets\SISSI\" "42.xml"
${File} "..\..\sheets\SISSI\" "43.xml"
${File} "..\..\sheets\SISSI\" "44.xml"
${File} "..\..\sheets\SISSI\" "45.xml"
${File} "..\..\sheets\SISSI\" "46.xml"
${File} "..\..\sheets\SISSI\" "47.xml"
${File} "..\..\sheets\SISSI\" "48.xml"
${File} "..\..\sheets\SISSI\" "5.xml"
${File} "..\..\sheets\SISSI\" "50.xml"
${File} "..\..\sheets\SISSI\" "51.xml"
${File} "..\..\sheets\SISSI\" "52.xml"
${File} "..\..\sheets\SISSI\" "53.xml"
${File} "..\..\sheets\SISSI\" "54.xml"
${File} "..\..\sheets\SISSI\" "55.xml"
${File} "..\..\sheets\SISSI\" "56.xml"
${File} "..\..\sheets\SISSI\" "57.xml"
${File} "..\..\sheets\SISSI\" "58.xml"
${File} "..\..\sheets\SISSI\" "59.xml"
${File} "..\..\sheets\SISSI\" "6.xml"
${File} "..\..\sheets\SISSI\" "60.xml"
${File} "..\..\sheets\SISSI\" "61.xml"
${File} "..\..\sheets\SISSI\" "62.xml"
${File} "..\..\sheets\SISSI\" "63.xml"
${File} "..\..\sheets\SISSI\" "7.xml"
${File} "..\..\sheets\SISSI\" "70.xml"
${File} "..\..\sheets\SISSI\" "71.xml"
${File} "..\..\sheets\SISSI\" "75.xml"
${File} "..\..\sheets\SISSI\" "76.xml"
${File} "..\..\sheets\SISSI\" "8.xml"
${File} "..\..\sheets\SISSI\" "9.xml"
${File} "..\..\sheets\SISSI\" "aircooler.png"
${File} "..\..\sheets\SISSI\" "aircooler_icon.png"
${File} "..\..\sheets\SISSI\" "alarm_center.png"
${File} "..\..\sheets\SISSI\" "analyse.png"
${File} "..\..\sheets\SISSI\" "barriere.png"
${File} "..\..\sheets\SISSI\" "barriere_icon.png"
${File} "..\..\sheets\SISSI\" "camera_interphone.png"
${File} "..\..\sheets\SISSI\" "camera_interphone_icon.png"
${File} "..\..\sheets\SISSI\" "capteur_brise_glace.png"
${File} "..\..\sheets\SISSI\" "capteur_brise_glace_icon.png"
${File} "..\..\sheets\SISSI\" "capteur_faisceau_icon.png"
${File} "..\..\sheets\SISSI\" "capteur_faisceau.png"
${File} "..\..\sheets\SISSI\" "cellular_phone.png"
${File} "..\..\sheets\SISSI\" "cloud.png"
${File} "..\..\sheets\SISSI\" "condensateur.png"
${File} "..\..\sheets\SISSI\" "condensateur_icon.png"
${File} "..\..\sheets\SISSI\" "detecteur_alimentation.png"
${File} "..\..\sheets\SISSI\" "detecteur_alimentation_icon.png"
${File} "..\..\sheets\SISSI\" "detecteur_courant.png"
${File} "..\..\sheets\SISSI\" "detecteur_courant_icon.png"
${File} "..\..\sheets\SISSI\" "detecteur_enthalpie.png"
${File} "..\..\sheets\SISSI\" "detecteur_enthalpie_icon.png"
${File} "..\..\sheets\SISSI\" "detecteur_fumee.png"
${File} "..\..\sheets\SISSI\" "detecteur_fumee_icon.png"
${File} "..\..\sheets\SISSI\" "detecteur_humidite.png"
${File} "..\..\sheets\SISSI\" "detecteur_humidite_icon.png"
${File} "..\..\sheets\SISSI\" "detecteur_lumiere.png"
${File} "..\..\sheets\SISSI\" "detecteur_lumiere_icon.png"
${File} "..\..\sheets\SISSI\" "detecteur_mouvement.png"
${File} "..\..\sheets\SISSI\" "detecteur_mouvement_icon.png"
${File} "..\..\sheets\SISSI\" "detecteur_mouvement_video.png"
${File} "..\..\sheets\SISSI\" "detecteur_mouvement_video_icon.png"
${File} "..\..\sheets\SISSI\" "detecteur_niveau.png"
${File} "..\..\sheets\SISSI\" "detecteur_pression.png"
${File} "..\..\sheets\SISSI\" "detecteur_pression_icon.png"
${File} "..\..\sheets\SISSI\" "detecteur_qualite_air.png"
${File} "..\..\sheets\SISSI\" "detecteur_qualite_air_icon.png"
${File} "..\..\sheets\SISSI\" "detecteur_tension.png"
${File} "..\..\sheets\SISSI\" "detecteur_tension_icon.png"
${File} "..\..\sheets\SISSI\" "detecteur_vehicule.png"
${File} "..\..\sheets\SISSI\" "detecteur_vehicule_icon.png"
${File} "..\..\sheets\SISSI\" "detecteur_vibration.png"
${File} "..\..\sheets\SISSI\" "detecteur_vibration_icon.png"
${File} "..\..\sheets\SISSI\" "digi_code.png"
${File} "..\..\sheets\SISSI\" "digi_code_icon.png"
${File} "..\..\sheets\SISSI\" "diskette.png"
${File} "..\..\sheets\SISSI\" "extincteur.png"
${File} "..\..\sheets\SISSI\" "extincteur_icon.png"
${File} "..\..\sheets\SISSI\" "extracteur_humidite.png"
${File} "..\..\sheets\SISSI\" "extracteur_humidite_icon.png"
${File} "..\..\sheets\SISSI\" "faraday.png"
${File} "..\..\sheets\SISSI\" "file.png"
${File} "..\..\sheets\SISSI\" "file_cabinet.png"
${File} "..\..\sheets\SISSI\" "filtre_air.png"
${File} "..\..\sheets\SISSI\" "filtre_air_icon.png"
${File} "..\..\sheets\SISSI\" "hub.png"
${File} "..\..\sheets\SISSI\" "ibm_mini.png"
${File} "..\..\sheets\SISSI\" "info.png"
${File} "..\..\sheets\SISSI\" "information.png"
${File} "..\..\sheets\SISSI\" "key.png"
${File} "..\..\sheets\SISSI\" "laptop.png"
${File} "..\..\sheets\SISSI\" "lecteur_badge.png"
${File} "..\..\sheets\SISSI\" "lecteur_badge_icon.png"
${File} "..\..\sheets\SISSI\" "lecteur_badge_clavier.png"
${File} "..\..\sheets\SISSI\" "lecteur_badge_clavier_icon.png"
${File} "..\..\sheets\SISSI\" "lecteur_biometrique.png"
${File} "..\..\sheets\SISSI\" "lecteur_biometrique_icon.png"
${File} "..\..\sheets\SISSI\" "logiciel.png"
${File} "..\..\sheets\SISSI\" "meuble.png"
${File} "..\..\sheets\SISSI\" "modem.png"
${File} "..\..\sheets\SISSI\" "onduleur.png"
${File} "..\..\sheets\SISSI\" "onduleur_icon.png"
${File} "..\..\sheets\SISSI\" "ordinateur_portable.gif"
${File} "..\..\sheets\SISSI\" "pc.png"
${File} "..\..\sheets\SISSI\" "pda.png"
${File} "..\..\sheets\SISSI\" "pda_icon.png"
${File} "..\..\sheets\SISSI\" "personne.png"
${File} "..\..\sheets\SISSI\" "phone.png"
${File} "..\..\sheets\SISSI\" "pompe.png"
${File} "..\..\sheets\SISSI\" "pompe_icon.png"
${File} "..\..\sheets\SISSI\" "pompe_rotative.png"
${File} "..\..\sheets\SISSI\" "pompe_rotative_icon.png"
${File} "..\..\sheets\SISSI\" "porte_tambour.png"
${File} "..\..\sheets\SISSI\" "porte_tambour_icon.png"
${File} "..\..\sheets\SISSI\" "relational_database.png"
${File} "..\..\sheets\SISSI\" "router.png"
${File} "..\..\sheets\SISSI\" "safe.png"
${File} "..\..\sheets\SISSI\" "safe_icon.png"
${File} "..\..\sheets\SISSI\" "sauvegarde.png"
${File} "..\..\sheets\SISSI\" "si.png"
${File} "..\..\sheets\SISSI\" "storage_array.png"
${File} "..\..\sheets\SISSI\" "tourniquet.png"
${File} "..\..\sheets\SISSI\" "ventilateur.png"
${File} "..\..\sheets\SISSI\" "ventilateur_axial.png"
${File} "..\..\sheets\SISSI\" "ventilateur_axial_icon.png"
${File} "..\..\sheets\SISSI\" "ventilateur_centrifuge.png"
${File} "..\..\sheets\SISSI\" "ventilateur_centrifuge_icon.png"
${SetOutPath} "$INSTDIR\sheets\UML"
${File} "..\..\sheets\UML\" "aggregation.png"
${File} "..\..\sheets\UML\" "aggregation.png"
${File} "..\..\sheets\UML\" "eventsink.png"
${File} "..\..\sheets\UML\" "eventsink.png"
${File} "..\..\sheets\UML\" "eventsource.png"
${File} "..\..\sheets\UML\" "eventsource.png"
${File} "..\..\sheets\UML\" "receptacle.png"
${File} "..\..\sheets\UML\" "receptacle.png"
${File} "..\..\sheets\UML\" "umlclass_template.png"
${File} "..\..\sheets\UML\" "umlclass_template.png"
${SetOutPath} "$INSTDIR\help\C"
${File} "..\..\build\win32\help\en\" "dia-manual.chm"
${File} "..\..\build\win32\help\en\" "dia-manual.pdf"
${File} "..\..\build\win32\help\C\" "faq.html"
${SetOutPath} "$INSTDIR\help\C\faq_files"
${File} "..\..\build\win32\help\C\faq_files\" "addbend1.png"
${File} "..\..\build\win32\help\C\faq_files\" "addbend2.png"
${File} "..\..\build\win32\help\C\faq_files\" "addbend3.png"
${File} "..\..\build\win32\help\C\faq_files\" "common.css"
${File} "..\..\build\win32\help\C\faq_files\" "layout.css"
${File} "..\..\build\win32\help\C\faq_files\" "print.css"
${File} "..\..\build\win32\help\C\faq_files\" "projection.css"
${File} "..\..\build\win32\help\C\faq_files\" "screen.css"
${File} "..\..\build\win32\help\C\faq_files\" "smile.png"
${File} "..\..\build\win32\help\C\faq_files\" "spacer.png"
${File} "..\..\build\win32\help\C\faq_files\" "zig1.png"
${File} "..\..\build\win32\help\C\faq_files\" "zig2.png"
${File} "..\..\build\win32\help\C\faq_files\" "zig4.png"
${File} "..\..\build\win32\help\C\faq_files\" "zig5.png"

${SetOutPath} "$INSTDIR\help\en"
${File} "..\..\build\win32\help\en\" "dia-manual.chm"
${File} "..\..\build\win32\help\en\" "dia-manual.pdf"

${SetOutPath} "$INSTDIR\help\eu"
${File} "..\..\build\win32\help\eu\" "dia-manual.chm"
${File} "..\..\build\win32\help\eu\" "dia-manual.pdf"

${SetOutPath} "$INSTDIR\help\fr"
${File} "..\..\build\win32\help\fr\" "dia-manual.chm"
${File} "..\..\build\win32\help\fr\" "dia-manual.pdf"

${SetOutPath} "$INSTDIR\help\pl"
${File} "..\..\build\win32\help\pl\" "dia-manual.chm"
${File} "..\..\build\win32\help\pl\" "dia-manual.pdf"

${SetOutPath} "$INSTDIR\samples"
${File} "..\..\samples\" "all_objects.dia"
${File} "..\..\samples\" "arrows.dia"
${File} "..\..\samples\" "chronograms.dia"
${File} "..\..\samples\" "CompositeAction.dia"
${File} "..\..\samples\" "dia_logo.png"
${File} "..\..\samples\" "ER-demo.dia"
${File} "..\..\samples\" "font-sizes.dia"
${File} "..\..\samples\" "grafcet.dia"
${File} "..\..\samples\" "Istar.dia"
${File} "..\..\samples\" "Jackson.dia"
${File} "..\..\samples\" "KAOS.dia"
${File} "..\..\samples\" "Metapost-Testcase.dia"
${File} "..\..\samples\" "render-test.dia"
${File} "..\..\samples\" "SADT.dia"
${File} "..\..\samples\" "TexChars.dia"
${File} "..\..\samples\" "UML-demo.dia"
${File} "..\..\samples\" "UMLPackages.dia"
${File} "..\..\samples\" "undo-check.dia"

${SetOutPath} "$INSTDIR\samples\Fig"
${File} "..\..\samples\Fig\" "Foo.fig"
${File} "..\..\samples\Fig\" "splines.fig"

${SetOutPath} "$INSTDIR\samples\self"
${File} "..\..\samples\self\" "dia-core.dia"
${File} "..\..\samples\self\" "dia-linux-2.dia"
${File} "..\..\samples\self\" "dia-linux-2.dot"
${File} "..\..\samples\self\" "dia-objects.dia"
${File} "..\..\samples\self\" "dia-renderer.dia"
${File} "..\..\samples\self\" "dia-standard-objects.dia"
${File} "..\..\samples\self\" "dia-win32-2.dia"
${File} "..\..\samples\self\" "dia-win32-2.dot"
${File} "..\..\samples\self\" "PyDiaObjects.dia"
${File} "..\..\samples\self\" "umlclass.dia"

${SetOutPath} "$INSTDIR\samples\Visio"
${File} "..\..\samples\Visio\" "visio-schema.xdr"

${SetOutPath} "$INSTDIR\samples\Visio\vdxtosvg"
${File} "..\..\samples\Visio\vdxtosvg\" "animation_tests.png"
${File} "..\..\samples\Visio\vdxtosvg\" "animation_tests.svg"
${File} "..\..\samples\Visio\vdxtosvg\" "animation_tests.vdx"
${File} "..\..\samples\Visio\vdxtosvg\" "basic_tests.png"
${File} "..\..\samples\Visio\vdxtosvg\" "basic_tests.svg"
${File} "..\..\samples\Visio\vdxtosvg\" "basic_tests.vdx"
${File} "..\..\samples\Visio\vdxtosvg\" "BasicShapes.vdx"
${File} "..\..\samples\Visio\vdxtosvg\" "curve_tests.vdx"
${File} "..\..\samples\Visio\vdxtosvg\" "pattern_tests.vdx"
${File} "..\..\samples\Visio\vdxtosvg\" "README"
${File} "..\..\samples\Visio\vdxtosvg\" "seq_test.svg"
${File} "..\..\samples\Visio\vdxtosvg\" "seq_test.vdx"
${File} "..\..\samples\Visio\vdxtosvg\" "text_tests.png"
${File} "..\..\samples\Visio\vdxtosvg\" "text_tests.svg"
${File} "..\..\samples\Visio\vdxtosvg\" "text_tests.vdx"
    
${SetOutPath} "$INSTDIR\xslt"
${File} "..\..\plug-ins\xslt\" "dia-uml.xsl"
${File} "..\..\plug-ins\xslt\" "dia-uml2c++.xsl"
${File} "..\..\plug-ins\xslt\" "dia-uml2componentlist.xsl"
${File} "..\..\plug-ins\xslt\" "dia-uml2cpp.xsl"
${File} "..\..\plug-ins\xslt\" "dia-uml2idl.xsl"
${File} "..\..\plug-ins\xslt\" "dia-uml2java.xsl"
${File} "..\..\plug-ins\xslt\" "dia-uml2owl.xsl"
${File} "..\..\plug-ins\xslt\" "dia-uml2python.xsl"
${File} "..\..\plug-ins\xslt\" "stylesheets.xml"

${SetOutPath} "$INSTDIR\ui"
${File} "..\..\data\" "display-ui.xml"
${File} "..\..\data\" "integrated-ui.xml"
${File} "..\..\data\" "popup-ui.xml"
${File} "..\..\data\" "toolbar-ui.xml"
${File} "..\..\data\" "toolbox-ui.xml"

!ifdef DIA_INCLUDE_GTK
${SetOutPath} "$INSTDIR\bin"
;${File} "..\..\..\bin\" "charset.dll"
;${File} "..\..\..\bin\" "gspawn-win32-helper-console.exe"
;${File} "..\..\..\bin\" "gspawn-win32-helper.exe"
${File} "..\..\..\bin\" "iconv.dll"
;${File} "..\..\..\bin\" "iconv.exe"
${File} "..\..\..\bin\" "intl.dll"
${File} "..\..\..\bin\" "jpeg62.dll"
${File} "..\..\..\bin\" "libatk-1.0-0.dll"
${File} "..\..\..\bin\" "libcairo-2.dll"
;${File} "..\..\..\bin\" "libexpat.dll"
;${File} "..\..\..\bin\" "libfontconfig-1.dll"
;${File} "..\..\..\bin\" "freetype6.dll"
; TODO: Remove the following, once gladewin32 has switched to freetype6.dll
;${File} "..\..\..\bin\" "libfreetype-6.dll"
${File} "..\..\..\bin\" "libgailutil-18.dll"
${File} "..\..\..\bin\" "libgdk-win32-2.0-0.dll"
${File} "..\..\..\bin\" "libgdk_pixbuf-2.0-0.dll"
${File} "..\..\..\bin\" "libgio-2.0-0.dll"
${File} "..\..\..\bin\" "libglib-2.0-0.dll"
${File} "..\..\..\bin\" "libgmodule-2.0-0.dll"
${File} "..\..\..\bin\" "libgobject-2.0-0.dll"
${File} "..\..\..\bin\" "libgthread-2.0-0.dll"
${File} "..\..\..\bin\" "libgtk-win32-2.0-0.dll"
${File} "..\..\..\bin\" "libpango-1.0-0.dll"
${File} "..\..\..\bin\" "libpangocairo-1.0-0.dll"
${File} "..\..\..\bin\" "libpangoft2-1.0-0.dll"
${File} "..\..\..\bin\" "libpangowin32-1.0-0.dll"
;${File} "..\..\..\bin\" "libpng12.dll"
${File} "..\..\..\bin\" "libpng12-0.dll"
;${File} "..\..\..\bin\" "librle3.dll"
${File} "..\..\..\bin\" "libtiff3.dll"
${File} "..\..\..\bin\" "libxml2.dll"
${File} "..\..\..\bin\" "pango-querymodules.exe"
;${File} "..\..\..\bin\" "xmlparse.dll"
;${File} "..\..\..\bin\" "xmltok.dll"
${File} "..\..\..\bin\" "zlib1.dll"
${SetOutPath} "$INSTDIR\etc"
;${SetOutPath} "$INSTDIR\etc\fonts"
;${File} "..\..\..\etc\fonts\" "fonts.conf"
${SetOutPath} "$INSTDIR\etc\gtk-2.0"
${File} "..\..\..\etc\gtk-2.0\" "gdk-pixbuf.loaders"
${File} "..\..\..\etc\gtk-2.0\" "gtk.immodules"
# Workaround 0.96.1 installer bug
RMDir "$INSTDIR\etc\gtk-2.0\gtkrc"

${File} "..\..\..\share\themes\MS-Windows\gtk-2.0\" "gtkrc"
${SetOutPath} "$INSTDIR\etc\pango"
;${File} "..\..\..\etc\pango\" "pango.aliases"
${File} "..\..\..\etc\pango\" "pango.modules"
${SetOutPath} "$INSTDIR\lib"
${SetOutPath} "$INSTDIR\lib\gtk-2.0"
${SetOutPath} "$INSTDIR\lib\gtk-2.0\2.10.0"
${SetOutPath} "$INSTDIR\lib\gtk-2.0\2.10.0\engines"
${File} "..\..\..\lib\gtk-2.0\2.10.0\engines\" "libpixmap.dll"
${File} "..\..\..\lib\gtk-2.0\2.10.0\engines\" "libwimp.dll"
;${SetOutPath} "$INSTDIR\lib\gtk-2.0\2.10.0\immodules"
;${File} "..\..\..\lib\gtk-2.0\2.10.0\immodules\" "im-am-et.dll"
;${File} "..\..\..\lib\gtk-2.0\2.10.0\immodules\" "im-cedilla.dll"
;${File} "..\..\..\lib\gtk-2.0\2.10.0\immodules\" "im-cyrillic-translit.dll"
;${File} "..\..\..\lib\gtk-2.0\2.10.0\immodules\" "im-ime.dll"
;${File} "..\..\..\lib\gtk-2.0\2.10.0\immodules\" "im-inuktitut.dll"
;${File} "..\..\..\lib\gtk-2.0\2.10.0\immodules\" "im-ipa.dll"
;${File} "..\..\..\lib\gtk-2.0\2.10.0\immodules\" "im-thai-broken.dll"
;${File} "..\..\..\lib\gtk-2.0\2.10.0\immodules\" "im-ti-er.dll"
;${File} "..\..\..\lib\gtk-2.0\2.10.0\immodules\" "im-ti-et.dll"
;${File} "..\..\..\lib\gtk-2.0\2.10.0\immodules\" "im-viqr.dll"
${SetOutPath} "$INSTDIR\lib\gtk-2.0\2.10.0\loaders"
${File} "..\..\..\lib\gtk-2.0\2.10.0\loaders\" "libpixbufloader-ani.dll"
${File} "..\..\..\lib\gtk-2.0\2.10.0\loaders\" "libpixbufloader-bmp.dll"
${File} "..\..\..\lib\gtk-2.0\2.10.0\loaders\" "libpixbufloader-gif.dll"
${File} "..\..\..\lib\gtk-2.0\2.10.0\loaders\" "libpixbufloader-icns.dll"
${File} "..\..\..\lib\gtk-2.0\2.10.0\loaders\" "libpixbufloader-ico.dll"
${File} "..\..\..\lib\gtk-2.0\2.10.0\loaders\" "libpixbufloader-jpeg.dll"
${File} "..\..\..\lib\gtk-2.0\2.10.0\loaders\" "libpixbufloader-pcx.dll"
${File} "..\..\..\lib\gtk-2.0\2.10.0\loaders\" "libpixbufloader-png.dll"
${File} "..\..\..\lib\gtk-2.0\2.10.0\loaders\" "libpixbufloader-pnm.dll"
${File} "..\..\..\lib\gtk-2.0\2.10.0\loaders\" "libpixbufloader-ras.dll"
${File} "..\..\..\lib\gtk-2.0\2.10.0\loaders\" "libpixbufloader-tga.dll"
${File} "..\..\..\lib\gtk-2.0\2.10.0\loaders\" "libpixbufloader-tiff.dll"
${File} "..\..\..\lib\gtk-2.0\2.10.0\loaders\" "libpixbufloader-wbmp.dll"
${File} "..\..\..\lib\gtk-2.0\2.10.0\loaders\" "libpixbufloader-xbm.dll"
${File} "..\..\..\lib\gtk-2.0\2.10.0\loaders\" "libpixbufloader-xpm.dll"

${SetOutPath} "$INSTDIR\share"
${SetOutPath} "$INSTDIR\share\themes"
${SetOutPath} "$INSTDIR\share\themes\Default"
${SetOutPath} "$INSTDIR\share\themes\Default\gtk-2.0-key"
${File} "..\..\..\share\themes\Default\gtk-2.0-key\" "gtkrc"
${SetOutPath} "$INSTDIR\share\themes\Emacs"
${SetOutPath} "$INSTDIR\share\themes\Emacs\gtk-2.0-key"
${File} "..\..\..\share\themes\Emacs\gtk-2.0-key\" "gtkrc"
${SetOutPath} "$INSTDIR\share\themes\MS-Windows"
${SetOutPath} "$INSTDIR\share\themes\MS-Windows\gtk-2.0"
${File} "..\..\..\share\themes\MS-Windows\gtk-2.0\" "gtkrc"
${SetOutPath} "$INSTDIR\share\themes\Raleigh"
${SetOutPath} "$INSTDIR\share\themes\Raleigh\gtk-2.0"
${File} "..\..\..\share\themes\Raleigh\gtk-2.0\" "gtkrc"

;${SetOutPath} "$INSTDIR\lib\pango"
;${SetOutPath} "$INSTDIR\lib\pango\1.6.0"
;${SetOutPath} "$INSTDIR\lib\pango\1.6.0\modules"
;${File} "..\..\..\lib\pango\1.6.0\modules\" "pango-arabic-fc.dll"
;${File} "..\..\..\lib\pango\1.6.0\modules\" "pango-arabic-lang.dll"
;${File} "..\..\..\lib\pango\1.6.0\modules\" "pango-basic-fc.dll"
;${File} "..\..\..\lib\pango\1.6.0\modules\" "pango-basic-win32.dll"
;${File} "..\..\..\lib\pango\1.6.0\modules\" "pango-hangul-fc.dll"
;${File} "..\..\..\lib\pango\1.6.0\modules\" "pango-hebrew-fc.dll"
;${File} "..\..\..\lib\pango\1.6.0\modules\" "pango-indic-fc.dll"
;${File} "..\..\..\lib\pango\1.6.0\modules\" "pango-indic-lang.dll"
;${File} "..\..\..\lib\pango\1.6.0\modules\" "pango-khmer-fc.dll"
;${File} "..\..\..\lib\pango\1.6.0\modules\" "pango-syriac-fc.dll"
;${File} "..\..\..\lib\pango\1.6.0\modules\" "pango-thai-fc.dll"
;${File} "..\..\..\lib\pango\1.6.0\modules\" "pango-tibetan-fc.dll"
!endif    
    SetShellVarContext all
    
    CreateDirectory "$SMPROGRAMS\Dia"
    ReadRegStr $0 HKU ".DEFAULT\Software\Microsoft\Windows\CurrentVersion\Explorer\User Shell Folders" "My Pictures"
    SetOutPath "$0"
    CreateShortCut "$SMPROGRAMS\Dia\Dia.lnk" "$INSTDIR\bin\diaw.exe" "--integrated"
    CreateShortCut "$SMPROGRAMS\Dia\Dia Manual (CHM).lnk" "$INSTDIR\help\C\dia-manual.chm"
    CreateShortCut "$SMPROGRAMS\Dia\Dia Manual (PDF).lnk" "$INSTDIR\help\C\dia-manual.pdf"
    CreateShortCut "$SMPROGRAMS\Dia\FAQ.lnk" "$INSTDIR\help\C\faq.html"
    SetOutPath "$INSTDIR"
	
    ; write out uninstaller
    SetOverwrite on
    WriteUninstaller "$INSTDIR\${DIA_UNINST_EXE}"
    SetOverwrite off
    CreateShortCut "$SMPROGRAMS\Dia\Uninstall.lnk" "$INSTDIR\${DIA_UNINST_EXE}"
    
  done:
SectionEnd ; end of default Dia section
  
Section $(TRANSLATIONS_SECTION_TITLE) SecTranslations
  SetOverwrite On
  ${SetOutPath} "$INSTDIR\locale\am\LC_MESSAGES"
  ${File} "..\..\build\win32\locale\am\LC_MESSAGES\" "dia.mo"
  ${SetOutPath} "$INSTDIR\locale\ar\LC_MESSAGES"
  ${File} "..\..\build\win32\locale\ar\LC_MESSAGES\" "dia.mo"
  ${SetOutPath} "$INSTDIR\locale\az\LC_MESSAGES"
  ${File} "..\..\build\win32\locale\az\LC_MESSAGES\" "dia.mo"
  ${SetOutPath} "$INSTDIR\locale\be\LC_MESSAGES"
  ${File} "..\..\build\win32\locale\be\LC_MESSAGES\" "dia.mo"
  ${SetOutPath} "$INSTDIR\locale\bg\LC_MESSAGES"
  ${File} "..\..\build\win32\locale\bg\LC_MESSAGES\" "dia.mo"
  ${SetOutPath} "$INSTDIR\locale\bs\LC_MESSAGES"
  ${File} "..\..\build\win32\locale\bs\LC_MESSAGES\" "dia.mo"
  ${SetOutPath} "$INSTDIR\locale\ca\LC_MESSAGES"
  ${File} "..\..\build\win32\locale\ca\LC_MESSAGES\" "dia.mo"
  ${SetOutPath} "$INSTDIR\locale\cs\LC_MESSAGES"
  ${File} "..\..\build\win32\locale\cs\LC_MESSAGES\" "dia.mo"
  ${SetOutPath} "$INSTDIR\locale\da\LC_MESSAGES"
  ${File} "..\..\build\win32\locale\da\LC_MESSAGES\" "dia.mo"
  ${SetOutPath} "$INSTDIR\locale\de\LC_MESSAGES"
  ${File} "..\..\build\win32\locale\de\LC_MESSAGES\" "dia.mo"
  ${SetOutPath} "$INSTDIR\locale\dz\LC_MESSAGES"
  ${File} "..\..\build\win32\locale\dz\LC_MESSAGES\" "dia.mo"
  ${SetOutPath} "$INSTDIR\locale\el\LC_MESSAGES"
  ${File} "..\..\build\win32\locale\el\LC_MESSAGES\" "dia.mo"
  ${SetOutPath} "$INSTDIR\locale\en_CA\LC_MESSAGES"
  ${File} "..\..\build\win32\locale\en_CA\LC_MESSAGES\" "dia.mo"
  ${SetOutPath} "$INSTDIR\locale\en_GB\LC_MESSAGES"
  ${File} "..\..\build\win32\locale\en_GB\LC_MESSAGES\" "dia.mo"
  ${SetOutPath} "$INSTDIR\locale\es\LC_MESSAGES"
  ${File} "..\..\build\win32\locale\es\LC_MESSAGES\" "dia.mo"
  ${SetOutPath} "$INSTDIR\locale\eu\LC_MESSAGES"
  ${File} "..\..\build\win32\locale\eu\LC_MESSAGES\" "dia.mo"
  ${SetOutPath} "$INSTDIR\locale\fi\LC_MESSAGES"
  ${File} "..\..\build\win32\locale\fi\LC_MESSAGES\" "dia.mo"
  ${SetOutPath} "$INSTDIR\locale\fr\LC_MESSAGES"
  ${File} "..\..\build\win32\locale\fr\LC_MESSAGES\" "dia.mo"
  ${SetOutPath} "$INSTDIR\locale\ga\LC_MESSAGES"
  ${File} "..\..\build\win32\locale\ga\LC_MESSAGES\" "dia.mo"
  ${SetOutPath} "$INSTDIR\locale\gl\LC_MESSAGES"
  ${File} "..\..\build\win32\locale\gl\LC_MESSAGES\" "dia.mo"
  ${SetOutPath} "$INSTDIR\locale\gu\LC_MESSAGES"
  ${File} "..\..\build\win32\locale\gu\LC_MESSAGES\" "dia.mo"
  ${SetOutPath} "$INSTDIR\locale\hr\LC_MESSAGES"
  ${File} "..\..\build\win32\locale\hr\LC_MESSAGES\" "dia.mo"
  ${SetOutPath} "$INSTDIR\locale\hu\LC_MESSAGES"
  ${File} "..\..\build\win32\locale\hu\LC_MESSAGES\" "dia.mo"
  ${SetOutPath} "$INSTDIR\locale\id\LC_MESSAGES"
  ${File} "..\..\build\win32\locale\id\LC_MESSAGES\" "dia.mo"
  ${SetOutPath} "$INSTDIR\locale\is\LC_MESSAGES"
  ${File} "..\..\build\win32\locale\is\LC_MESSAGES\" "dia.mo"
  ${SetOutPath} "$INSTDIR\locale\it\LC_MESSAGES"
  ${File} "..\..\build\win32\locale\it\LC_MESSAGES\" "dia.mo"
  ${SetOutPath} "$INSTDIR\locale\ja\LC_MESSAGES"
  ${File} "..\..\build\win32\locale\ja\LC_MESSAGES\" "dia.mo"
  ${SetOutPath} "$INSTDIR\locale\kn\LC_MESSAGES"
  ${File} "..\..\build\win32\locale\kn\LC_MESSAGES\" "dia.mo"
  ${SetOutPath} "$INSTDIR\locale\ko\LC_MESSAGES"
  ${File} "..\..\build\win32\locale\ko\LC_MESSAGES\" "dia.mo"
  ${SetOutPath} "$INSTDIR\locale\lt\LC_MESSAGES"
  ${File} "..\..\build\win32\locale\lt\LC_MESSAGES\" "dia.mo"
  ${SetOutPath} "$INSTDIR\locale\lv\LC_MESSAGES"
  ${File} "..\..\build\win32\locale\lv\LC_MESSAGES\" "dia.mo"
  ${SetOutPath} "$INSTDIR\locale\mk\LC_MESSAGES"
  ${File} "..\..\build\win32\locale\mk\LC_MESSAGES\" "dia.mo"
  ${SetOutPath} "$INSTDIR\locale\ml\LC_MESSAGES"
  ${File} "..\..\build\win32\locale\ml\LC_MESSAGES\" "dia.mo"
  ${SetOutPath} "$INSTDIR\locale\mn\LC_MESSAGES"
  ${File} "..\..\build\win32\locale\mn\LC_MESSAGES\" "dia.mo"
  ${SetOutPath} "$INSTDIR\locale\ms\LC_MESSAGES"
  ${File} "..\..\build\win32\locale\ms\LC_MESSAGES\" "dia.mo"
  ${SetOutPath} "$INSTDIR\locale\nb\LC_MESSAGES"
  ${File} "..\..\build\win32\locale\nb\LC_MESSAGES\" "dia.mo"
  ${SetOutPath} "$INSTDIR\locale\ne\LC_MESSAGES"
  ${File} "..\..\build\win32\locale\ne\LC_MESSAGES\" "dia.mo"
  ${SetOutPath} "$INSTDIR\locale\nl\LC_MESSAGES"
  ${File} "..\..\build\win32\locale\nl\LC_MESSAGES\" "dia.mo"
  ${SetOutPath} "$INSTDIR\locale\nn\LC_MESSAGES"
  ${File} "..\..\build\win32\locale\nn\LC_MESSAGES\" "dia.mo"
  ${SetOutPath} "$INSTDIR\locale\oc\LC_MESSAGES"
  ${File} "..\..\build\win32\locale\oc\LC_MESSAGES\" "dia.mo"
  ${SetOutPath} "$INSTDIR\locale\pa\LC_MESSAGES"
  ${File} "..\..\build\win32\locale\pa\LC_MESSAGES\" "dia.mo"
  ${SetOutPath} "$INSTDIR\locale\pl\LC_MESSAGES"
  ${File} "..\..\build\win32\locale\pl\LC_MESSAGES\" "dia.mo"
  ${SetOutPath} "$INSTDIR\locale\pt\LC_MESSAGES"
  ${File} "..\..\build\win32\locale\pt\LC_MESSAGES\" "dia.mo"
  ${SetOutPath} "$INSTDIR\locale\pt_BR\LC_MESSAGES"
  ${File} "..\..\build\win32\locale\pt_BR\LC_MESSAGES\" "dia.mo"
  ${SetOutPath} "$INSTDIR\locale\ro\LC_MESSAGES"
  ${File} "..\..\build\win32\locale\ro\LC_MESSAGES\" "dia.mo"
  ${SetOutPath} "$INSTDIR\locale\ru\LC_MESSAGES"
  ${File} "..\..\build\win32\locale\ru\LC_MESSAGES\" "dia.mo"
  ${SetOutPath} "$INSTDIR\locale\rw\LC_MESSAGES"
  ${File} "..\..\build\win32\locale\rw\LC_MESSAGES\" "dia.mo"
  ${SetOutPath} "$INSTDIR\locale\sk\LC_MESSAGES"
  ${File} "..\..\build\win32\locale\sk\LC_MESSAGES\" "dia.mo"
  ${SetOutPath} "$INSTDIR\locale\sl\LC_MESSAGES"
  ${File} "..\..\build\win32\locale\sl\LC_MESSAGES\" "dia.mo"
  ${SetOutPath} "$INSTDIR\locale\sq\LC_MESSAGES"
  ${File} "..\..\build\win32\locale\sq\LC_MESSAGES\" "dia.mo"
  ${SetOutPath} "$INSTDIR\locale\sr\LC_MESSAGES"
  ${File} "..\..\build\win32\locale\sr\LC_MESSAGES\" "dia.mo"
  ${SetOutPath} "$INSTDIR\locale\sr@Latn\LC_MESSAGES"
  ${File} "..\..\build\win32\locale\sr@Latn\LC_MESSAGES\" "dia.mo"
  ${SetOutPath} "$INSTDIR\locale\sv\LC_MESSAGES"
  ${File} "..\..\build\win32\locale\sv\LC_MESSAGES\" "dia.mo"
  ${SetOutPath} "$INSTDIR\locale\th\LC_MESSAGES"
  ${File} "..\..\build\win32\locale\th\LC_MESSAGES\" "dia.mo"
  ${SetOutPath} "$INSTDIR\locale\tr\LC_MESSAGES"
  ${File} "..\..\build\win32\locale\tr\LC_MESSAGES\" "dia.mo"
  ${SetOutPath} "$INSTDIR\locale\uk\LC_MESSAGES"
  ${File} "..\..\build\win32\locale\uk\LC_MESSAGES\" "dia.mo"
  ${SetOutPath} "$INSTDIR\locale\vi\LC_MESSAGES"
  ${File} "..\..\build\win32\locale\vi\LC_MESSAGES\" "dia.mo"
  ${SetOutPath} "$INSTDIR\locale\zh_CN\LC_MESSAGES"
  ${File} "..\..\build\win32\locale\zh_CN\LC_MESSAGES\" "dia.mo"
  ${SetOutPath} "$INSTDIR\locale\zh_HK\LC_MESSAGES"
  ${File} "..\..\build\win32\locale\zh_HK\LC_MESSAGES\" "dia.mo"
  ${SetOutPath} "$INSTDIR\locale\zh_TW\LC_MESSAGES"
  ${File} "..\..\build\win32\locale\zh_TW\LC_MESSAGES\" "dia.mo"
  
  !ifdef DIA_INCLUDE_GTK
${SetOutPath} "$INSTDIR\lib\locale\af"
${SetOutPath} "$INSTDIR\lib\locale\af\LC_MESSAGES"
${File} "..\..\..\share\locale\af\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\af"
${SetOutPath} "$INSTDIR\share\locale\af\LC_MESSAGES"
${File} "..\..\..\share\locale\af\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\af\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\am"
${SetOutPath} "$INSTDIR\lib\locale\am\LC_MESSAGES"
${File} "..\..\..\share\locale\am\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\am"
${SetOutPath} "$INSTDIR\share\locale\am\LC_MESSAGES"
${File} "..\..\..\share\locale\am\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\am\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\am\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\share\locale\ang"
${SetOutPath} "$INSTDIR\share\locale\ang\LC_MESSAGES"
${File} "..\..\..\share\locale\ang\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\ang\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\ar"
${SetOutPath} "$INSTDIR\lib\locale\ar\LC_MESSAGES"
${File} "..\..\..\share\locale\ar\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\ar"
${SetOutPath} "$INSTDIR\share\locale\ar\LC_MESSAGES"
${File} "..\..\..\share\locale\ar\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\ar\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\ar\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\as"
${SetOutPath} "$INSTDIR\lib\locale\as\LC_MESSAGES"
${File} "..\..\..\share\locale\as\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\as"
${SetOutPath} "$INSTDIR\share\locale\as\LC_MESSAGES"
${File} "..\..\..\share\locale\as\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\as\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\as\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\az"
${SetOutPath} "$INSTDIR\lib\locale\az\LC_MESSAGES"
${File} "..\..\..\share\locale\az\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\az"
${SetOutPath} "$INSTDIR\share\locale\az\LC_MESSAGES"
${File} "..\..\..\share\locale\az\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\az\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\az\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\share\locale\az_IR"
${SetOutPath} "$INSTDIR\share\locale\az_IR\LC_MESSAGES"
${File} "..\..\..\share\locale\az_IR\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\az_IR\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\be"
${SetOutPath} "$INSTDIR\lib\locale\be\LC_MESSAGES"
${File} "..\..\..\share\locale\be\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\be"
${SetOutPath} "$INSTDIR\share\locale\be\LC_MESSAGES"
${File} "..\..\..\share\locale\be\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\be\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\be\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\be@latin"
${SetOutPath} "$INSTDIR\lib\locale\be@latin\LC_MESSAGES"
${File} "..\..\..\share\locale\be@latin\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\be@latin"
${SetOutPath} "$INSTDIR\share\locale\be@latin\LC_MESSAGES"
${File} "..\..\..\share\locale\be@latin\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\be@latin\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\be@latin\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\bg"
${SetOutPath} "$INSTDIR\lib\locale\bg\LC_MESSAGES"
${File} "..\..\..\share\locale\bg\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\bg"
${SetOutPath} "$INSTDIR\share\locale\bg\LC_MESSAGES"
${File} "..\..\..\share\locale\bg\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\bg\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\bg\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\bn"
${SetOutPath} "$INSTDIR\lib\locale\bn\LC_MESSAGES"
${File} "..\..\..\share\locale\bn\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\bn"
${SetOutPath} "$INSTDIR\share\locale\bn\LC_MESSAGES"
${File} "..\..\..\share\locale\bn\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\bn\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\bn\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\bn_IN"
${SetOutPath} "$INSTDIR\lib\locale\bn_IN\LC_MESSAGES"
${File} "..\..\..\share\locale\bn_IN\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\bn_IN"
${SetOutPath} "$INSTDIR\share\locale\bn_IN\LC_MESSAGES"
${File} "..\..\..\share\locale\bn_IN\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\bn_IN\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\bn_IN\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\share\locale\br"
${SetOutPath} "$INSTDIR\share\locale\br\LC_MESSAGES"
${File} "..\..\..\share\locale\br\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\br\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\bs"
${SetOutPath} "$INSTDIR\lib\locale\bs\LC_MESSAGES"
${File} "..\..\..\share\locale\bs\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\bs"
${SetOutPath} "$INSTDIR\share\locale\bs\LC_MESSAGES"
${File} "..\..\..\share\locale\bs\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\bs\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\bs\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\ca"
${SetOutPath} "$INSTDIR\lib\locale\ca\LC_MESSAGES"
${File} "..\..\..\share\locale\ca\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\ca"
${SetOutPath} "$INSTDIR\share\locale\ca\LC_MESSAGES"
${File} "..\..\..\share\locale\ca\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\ca\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\ca\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\cs"
${SetOutPath} "$INSTDIR\lib\locale\cs\LC_MESSAGES"
${File} "..\..\..\share\locale\cs\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\cs"
${SetOutPath} "$INSTDIR\share\locale\cs\LC_MESSAGES"
${File} "..\..\..\share\locale\cs\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\cs\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\cs\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\cy"
${SetOutPath} "$INSTDIR\lib\locale\cy\LC_MESSAGES"
${File} "..\..\..\share\locale\cy\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\cy"
${SetOutPath} "$INSTDIR\share\locale\cy\LC_MESSAGES"
${File} "..\..\..\share\locale\cy\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\cy\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\cy\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\da"
${SetOutPath} "$INSTDIR\lib\locale\da\LC_MESSAGES"
${File} "..\..\..\share\locale\da\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\da"
${SetOutPath} "$INSTDIR\share\locale\da\LC_MESSAGES"
${File} "..\..\..\share\locale\da\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\da\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\da\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\de"
${SetOutPath} "$INSTDIR\lib\locale\de\LC_MESSAGES"
${File} "..\..\..\share\locale\de\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\de"
${SetOutPath} "$INSTDIR\share\locale\de\LC_MESSAGES"
${File} "..\..\..\share\locale\de\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\de\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\de\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\dz"
${SetOutPath} "$INSTDIR\lib\locale\dz\LC_MESSAGES"
${File} "..\..\..\share\locale\dz\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\dz"
${SetOutPath} "$INSTDIR\share\locale\dz\LC_MESSAGES"
${File} "..\..\..\share\locale\dz\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\dz\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\dz\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\el"
${SetOutPath} "$INSTDIR\lib\locale\el\LC_MESSAGES"
${File} "..\..\..\share\locale\el\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\el"
${SetOutPath} "$INSTDIR\share\locale\el\LC_MESSAGES"
${File} "..\..\..\share\locale\el\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\el\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\el\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\en_CA"
${SetOutPath} "$INSTDIR\lib\locale\en_CA\LC_MESSAGES"
${File} "..\..\..\share\locale\en_CA\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\en_CA"
${SetOutPath} "$INSTDIR\share\locale\en_CA\LC_MESSAGES"
${File} "..\..\..\share\locale\en_CA\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\en_CA\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\en_CA\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\en_GB"
${SetOutPath} "$INSTDIR\lib\locale\en_GB\LC_MESSAGES"
${File} "..\..\..\share\locale\en_GB\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\en_GB"
${SetOutPath} "$INSTDIR\share\locale\en_GB\LC_MESSAGES"
${File} "..\..\..\share\locale\en_GB\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\en_GB\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\en_GB\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\eo"
${SetOutPath} "$INSTDIR\lib\locale\eo\LC_MESSAGES"
${File} "..\..\..\share\locale\eo\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\eo"
${SetOutPath} "$INSTDIR\share\locale\eo\LC_MESSAGES"
${File} "..\..\..\share\locale\eo\LC_MESSAGES\" "glib20.mo"
${SetOutPath} "$INSTDIR\lib\locale\es"
${SetOutPath} "$INSTDIR\lib\locale\es\LC_MESSAGES"
${File} "..\..\..\share\locale\es\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\es"
${SetOutPath} "$INSTDIR\share\locale\es\LC_MESSAGES"
${File} "..\..\..\share\locale\es\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\es\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\es\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\et"
${SetOutPath} "$INSTDIR\lib\locale\et\LC_MESSAGES"
${File} "..\..\..\share\locale\et\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\et"
${SetOutPath} "$INSTDIR\share\locale\et\LC_MESSAGES"
${File} "..\..\..\share\locale\et\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\et\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\et\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\eu"
${SetOutPath} "$INSTDIR\lib\locale\eu\LC_MESSAGES"
${File} "..\..\..\share\locale\eu\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\eu"
${SetOutPath} "$INSTDIR\share\locale\eu\LC_MESSAGES"
${File} "..\..\..\share\locale\eu\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\eu\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\eu\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\fa"
${SetOutPath} "$INSTDIR\lib\locale\fa\LC_MESSAGES"
${File} "..\..\..\share\locale\fa\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\fa"
${SetOutPath} "$INSTDIR\share\locale\fa\LC_MESSAGES"
${File} "..\..\..\share\locale\fa\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\fa\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\fa\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\fi"
${SetOutPath} "$INSTDIR\lib\locale\fi\LC_MESSAGES"
${File} "..\..\..\share\locale\fi\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\fi"
${SetOutPath} "$INSTDIR\share\locale\fi\LC_MESSAGES"
${File} "..\..\..\share\locale\fi\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\fi\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\fi\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\fr"
${SetOutPath} "$INSTDIR\lib\locale\fr\LC_MESSAGES"
${File} "..\..\..\share\locale\fr\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\fr"
${SetOutPath} "$INSTDIR\share\locale\fr\LC_MESSAGES"
${File} "..\..\..\share\locale\fr\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\fr\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\fr\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\share\locale\ga"
${SetOutPath} "$INSTDIR\share\locale\ga\LC_MESSAGES"
${File} "..\..\..\share\locale\ga\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\lib\locale\ga"
${SetOutPath} "$INSTDIR\lib\locale\ga\LC_MESSAGES"
${File} "..\..\..\share\locale\ga\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\ga\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\ga\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\gl"
${SetOutPath} "$INSTDIR\lib\locale\gl\LC_MESSAGES"
${File} "..\..\..\share\locale\gl\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\gl"
${SetOutPath} "$INSTDIR\share\locale\gl\LC_MESSAGES"
${File} "..\..\..\share\locale\gl\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\gl\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\gl\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\gu"
${SetOutPath} "$INSTDIR\lib\locale\gu\LC_MESSAGES"
${File} "..\..\..\share\locale\gu\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\gu"
${SetOutPath} "$INSTDIR\share\locale\gu\LC_MESSAGES"
${File} "..\..\..\share\locale\gu\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\gu\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\gu\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\he"
${SetOutPath} "$INSTDIR\lib\locale\he\LC_MESSAGES"
${File} "..\..\..\share\locale\he\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\he"
${SetOutPath} "$INSTDIR\share\locale\he\LC_MESSAGES"
${File} "..\..\..\share\locale\he\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\he\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\he\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\hi"
${SetOutPath} "$INSTDIR\lib\locale\hi\LC_MESSAGES"
${File} "..\..\..\share\locale\hi\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\hi"
${SetOutPath} "$INSTDIR\share\locale\hi\LC_MESSAGES"
${File} "..\..\..\share\locale\hi\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\hi\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\hi\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\hr"
${SetOutPath} "$INSTDIR\lib\locale\hr\LC_MESSAGES"
${File} "..\..\..\share\locale\hr\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\hr"
${SetOutPath} "$INSTDIR\share\locale\hr\LC_MESSAGES"
${File} "..\..\..\share\locale\hr\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\hr\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\hr\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\hu"
${SetOutPath} "$INSTDIR\lib\locale\hu\LC_MESSAGES"
${File} "..\..\..\share\locale\hu\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\hu"
${SetOutPath} "$INSTDIR\share\locale\hu\LC_MESSAGES"
${File} "..\..\..\share\locale\hu\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\hu\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\hu\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\share\locale\hy"
${SetOutPath} "$INSTDIR\share\locale\hy\LC_MESSAGES"
${File} "..\..\..\share\locale\hy\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\hy\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\hy\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\share\locale\ia"
${SetOutPath} "$INSTDIR\share\locale\ia\LC_MESSAGES"
${File} "..\..\..\share\locale\ia\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\ia\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\id"
${SetOutPath} "$INSTDIR\lib\locale\id\LC_MESSAGES"
${File} "..\..\..\share\locale\id\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\id"
${SetOutPath} "$INSTDIR\share\locale\id\LC_MESSAGES"
${File} "..\..\..\share\locale\id\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\id\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\id\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\is"
${SetOutPath} "$INSTDIR\lib\locale\is\LC_MESSAGES"
${File} "..\..\..\share\locale\is\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\is"
${SetOutPath} "$INSTDIR\share\locale\is\LC_MESSAGES"
${File} "..\..\..\share\locale\is\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\is\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\is\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\it"
${SetOutPath} "$INSTDIR\lib\locale\it\LC_MESSAGES"
${File} "..\..\..\share\locale\it\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\it"
${SetOutPath} "$INSTDIR\share\locale\it\LC_MESSAGES"
${File} "..\..\..\share\locale\it\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\it\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\it\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\ja"
${SetOutPath} "$INSTDIR\lib\locale\ja\LC_MESSAGES"
${File} "..\..\..\share\locale\ja\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\ja"
${SetOutPath} "$INSTDIR\share\locale\ja\LC_MESSAGES"
${File} "..\..\..\share\locale\ja\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\ja\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\ja\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\ka"
${SetOutPath} "$INSTDIR\lib\locale\ka\LC_MESSAGES"
${File} "..\..\..\share\locale\ka\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\ka"
${SetOutPath} "$INSTDIR\share\locale\ka\LC_MESSAGES"
${File} "..\..\..\share\locale\ka\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\ka\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\ka\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\kn"
${SetOutPath} "$INSTDIR\lib\locale\kn\LC_MESSAGES"
${File} "..\..\..\share\locale\kn\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\lib\locale\ko"
${SetOutPath} "$INSTDIR\lib\locale\ko\LC_MESSAGES"
${File} "..\..\..\share\locale\ko\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\ko"
${SetOutPath} "$INSTDIR\share\locale\ko\LC_MESSAGES"
${File} "..\..\..\share\locale\ko\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\ko\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\ko\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\ku"
${SetOutPath} "$INSTDIR\lib\locale\ku\LC_MESSAGES"
${File} "..\..\..\share\locale\ku\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\ku"
${SetOutPath} "$INSTDIR\share\locale\ku\LC_MESSAGES"
${File} "..\..\..\share\locale\ku\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\ku\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\ku\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\li"
${SetOutPath} "$INSTDIR\lib\locale\li\LC_MESSAGES"
${File} "..\..\..\share\locale\li\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\li"
${SetOutPath} "$INSTDIR\share\locale\li\LC_MESSAGES"
${File} "..\..\..\share\locale\li\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\li\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\lt"
${SetOutPath} "$INSTDIR\lib\locale\lt\LC_MESSAGES"
${File} "..\..\..\share\locale\lt\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\lt"
${SetOutPath} "$INSTDIR\share\locale\lt\LC_MESSAGES"
${File} "..\..\..\share\locale\lt\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\lt\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\lt\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\lv"
${SetOutPath} "$INSTDIR\lib\locale\lv\LC_MESSAGES"
${File} "..\..\..\share\locale\lv\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\lv"
${SetOutPath} "$INSTDIR\share\locale\lv\LC_MESSAGES"
${File} "..\..\..\share\locale\lv\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\lv\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\lv\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\share\locale\mi"
${SetOutPath} "$INSTDIR\share\locale\mi\LC_MESSAGES"
${File} "..\..\..\share\locale\mi\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\mi\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\mk"
${SetOutPath} "$INSTDIR\lib\locale\mk\LC_MESSAGES"
${File} "..\..\..\share\locale\mk\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\mk"
${SetOutPath} "$INSTDIR\share\locale\mk\LC_MESSAGES"
${File} "..\..\..\share\locale\mk\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\mk\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\mk\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\ml"
${SetOutPath} "$INSTDIR\lib\locale\ml\LC_MESSAGES"
${File} "..\..\..\share\locale\ml\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\ml"
${SetOutPath} "$INSTDIR\share\locale\ml\LC_MESSAGES"
${File} "..\..\..\share\locale\ml\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\ml\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\ml\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\mn"
${SetOutPath} "$INSTDIR\lib\locale\mn\LC_MESSAGES"
${File} "..\..\..\share\locale\mn\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\mn"
${SetOutPath} "$INSTDIR\share\locale\mn\LC_MESSAGES"
${File} "..\..\..\share\locale\mn\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\mn\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\mn\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\mr"
${SetOutPath} "$INSTDIR\lib\locale\mr\LC_MESSAGES"
${File} "..\..\..\share\locale\mr\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\mr"
${SetOutPath} "$INSTDIR\share\locale\mr\LC_MESSAGES"
${File} "..\..\..\share\locale\mr\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\mr\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\ms"
${SetOutPath} "$INSTDIR\lib\locale\ms\LC_MESSAGES"
${File} "..\..\..\share\locale\ms\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\ms"
${SetOutPath} "$INSTDIR\share\locale\ms\LC_MESSAGES"
${File} "..\..\..\share\locale\ms\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\ms\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\ms\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\nb"
${SetOutPath} "$INSTDIR\lib\locale\nb\LC_MESSAGES"
${File} "..\..\..\share\locale\nb\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\nb"
${SetOutPath} "$INSTDIR\share\locale\nb\LC_MESSAGES"
${File} "..\..\..\share\locale\nb\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\nb\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\nb\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\ne"
${SetOutPath} "$INSTDIR\lib\locale\ne\LC_MESSAGES"
${File} "..\..\..\share\locale\ne\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\ne"
${SetOutPath} "$INSTDIR\share\locale\ne\LC_MESSAGES"
${File} "..\..\..\share\locale\ne\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\ne\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\ne\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\nl"
${SetOutPath} "$INSTDIR\lib\locale\nl\LC_MESSAGES"
${File} "..\..\..\share\locale\nl\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\nl"
${SetOutPath} "$INSTDIR\share\locale\nl\LC_MESSAGES"
${File} "..\..\..\share\locale\nl\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\nl\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\nl\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\nn"
${SetOutPath} "$INSTDIR\lib\locale\nn\LC_MESSAGES"
${File} "..\..\..\share\locale\nn\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\nn"
${SetOutPath} "$INSTDIR\share\locale\nn\LC_MESSAGES"
${File} "..\..\..\share\locale\nn\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\nn\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\nn\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\share\locale\nso"
${SetOutPath} "$INSTDIR\share\locale\nso\LC_MESSAGES"
${File} "..\..\..\share\locale\nso\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\nso\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\oc\LC_MESSAGES"
${SetOutPath} "$INSTDIR\lib\locale\oc\LC_MESSAGES"
${File} "..\..\..\share\locale\oc\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\oc"
${SetOutPath} "$INSTDIR\share\locale\oc\LC_MESSAGES"
${File} "..\..\..\share\locale\oc\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\oc\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\oc\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\or"
${SetOutPath} "$INSTDIR\lib\locale\or\LC_MESSAGES"
${File} "..\..\..\share\locale\or\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\or"
${SetOutPath} "$INSTDIR\share\locale\or\LC_MESSAGES"
${File} "..\..\..\share\locale\or\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\or\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\or\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\pa"
${SetOutPath} "$INSTDIR\lib\locale\pa\LC_MESSAGES"
${File} "..\..\..\share\locale\pa\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\pa"
${SetOutPath} "$INSTDIR\share\locale\pa\LC_MESSAGES"
${File} "..\..\..\share\locale\pa\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\pa\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\pa\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\pl"
${SetOutPath} "$INSTDIR\lib\locale\pl\LC_MESSAGES"
${File} "..\..\..\share\locale\pl\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\pl"
${SetOutPath} "$INSTDIR\share\locale\pl\LC_MESSAGES"
${File} "..\..\..\share\locale\pl\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\pl\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\pl\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\pt"
${SetOutPath} "$INSTDIR\lib\locale\pt\LC_MESSAGES"
${File} "..\..\..\share\locale\pt\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\pt"
${SetOutPath} "$INSTDIR\share\locale\pt\LC_MESSAGES"
${File} "..\..\..\share\locale\pt\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\pt\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\pt\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\pt_BR"
${SetOutPath} "$INSTDIR\lib\locale\pt_BR\LC_MESSAGES"
${File} "..\..\..\share\locale\pt_BR\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\pt_BR"
${SetOutPath} "$INSTDIR\share\locale\pt_BR\LC_MESSAGES"
${File} "..\..\..\share\locale\pt_BR\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\pt_BR\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\pt_BR\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\ro"
${SetOutPath} "$INSTDIR\lib\locale\ro\LC_MESSAGES"
${File} "..\..\..\share\locale\ro\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\ro"
${SetOutPath} "$INSTDIR\share\locale\ro\LC_MESSAGES"
${File} "..\..\..\share\locale\ro\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\ro\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\ro\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\ru"
${SetOutPath} "$INSTDIR\lib\locale\ru\LC_MESSAGES"
${File} "..\..\..\share\locale\ru\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\ru"
${SetOutPath} "$INSTDIR\share\locale\ru\LC_MESSAGES"
${File} "..\..\..\share\locale\ru\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\ru\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\ru\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\rw"
${SetOutPath} "$INSTDIR\lib\locale\rw\LC_MESSAGES"
${File} "..\..\..\share\locale\rw\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\rw"
${SetOutPath} "$INSTDIR\share\locale\rw\LC_MESSAGES"
${File} "..\..\..\share\locale\rw\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\rw\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\rw\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\sk"
${SetOutPath} "$INSTDIR\lib\locale\sk\LC_MESSAGES"
${File} "..\..\..\share\locale\sk\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\sk"
${SetOutPath} "$INSTDIR\share\locale\sk\LC_MESSAGES"
${File} "..\..\..\share\locale\sk\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\sk\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\sk\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\sl"
${SetOutPath} "$INSTDIR\lib\locale\sl\LC_MESSAGES"
${File} "..\..\..\share\locale\sl\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\sl"
${SetOutPath} "$INSTDIR\share\locale\sl\LC_MESSAGES"
${File} "..\..\..\share\locale\sl\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\sl\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\sl\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\sq"
${SetOutPath} "$INSTDIR\lib\locale\sq\LC_MESSAGES"
${File} "..\..\..\share\locale\sq\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\sq"
${SetOutPath} "$INSTDIR\share\locale\sq\LC_MESSAGES"
${File} "..\..\..\share\locale\sq\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\sq\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\sq\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\sr"
${SetOutPath} "$INSTDIR\lib\locale\sr\LC_MESSAGES"
${File} "..\..\..\share\locale\sr\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\sr"
${SetOutPath} "$INSTDIR\share\locale\sr\LC_MESSAGES"
${File} "..\..\..\share\locale\sr\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\sr\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\sr\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\sr@ije"
${SetOutPath} "$INSTDIR\lib\locale\sr@ije\LC_MESSAGES"
${File} "..\..\..\share\locale\sr@ije\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\sr@ije"
${SetOutPath} "$INSTDIR\share\locale\sr@ije\LC_MESSAGES"
${File} "..\..\..\share\locale\sr@ije\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\sr@ije\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\sr@ije\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\sr@Latn"
${SetOutPath} "$INSTDIR\lib\locale\sr@latin\LC_MESSAGES"
${File} "..\..\..\share\locale\sr@latin\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\sr@latin"
${SetOutPath} "$INSTDIR\share\locale\sr@latin\LC_MESSAGES"
${File} "..\..\..\share\locale\sr@latin\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\sr@latin\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\sr@latin\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\sv"
${SetOutPath} "$INSTDIR\lib\locale\sv\LC_MESSAGES"
${File} "..\..\..\share\locale\sv\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\sv"
${SetOutPath} "$INSTDIR\share\locale\sv\LC_MESSAGES"
${File} "..\..\..\share\locale\sv\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\sv\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\sv\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\ta"
${SetOutPath} "$INSTDIR\lib\locale\ta\LC_MESSAGES"
${File} "..\..\..\share\locale\ta\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\ta"
${SetOutPath} "$INSTDIR\share\locale\ta\LC_MESSAGES"
${File} "..\..\..\share\locale\ta\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\ta\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\ta\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\te"
${SetOutPath} "$INSTDIR\lib\locale\te\LC_MESSAGES"
${File} "..\..\..\share\locale\te\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\te"
${SetOutPath} "$INSTDIR\share\locale\te\LC_MESSAGES"
${File} "..\..\..\share\locale\te\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\te\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\te\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\th"
${SetOutPath} "$INSTDIR\lib\locale\th\LC_MESSAGES"
${File} "..\..\..\share\locale\th\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\th"
${SetOutPath} "$INSTDIR\share\locale\th\LC_MESSAGES"
${File} "..\..\..\share\locale\th\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\th\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\th\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\tk"
${SetOutPath} "$INSTDIR\lib\locale\tk\LC_MESSAGES"
${File} "..\..\..\share\locale\tk\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\tk"
${SetOutPath} "$INSTDIR\share\locale\tk\LC_MESSAGES"
${File} "..\..\..\share\locale\tk\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\tk\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\share\locale\tl"
${SetOutPath} "$INSTDIR\share\locale\tl\LC_MESSAGES"
${File} "..\..\..\share\locale\tl\LC_MESSAGES\" "glib20.mo"
${SetOutPath} "$INSTDIR\lib\locale\tr"
${SetOutPath} "$INSTDIR\lib\locale\tr\LC_MESSAGES"
${File} "..\..\..\share\locale\tr\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\tr"
${SetOutPath} "$INSTDIR\share\locale\tr\LC_MESSAGES"
${File} "..\..\..\share\locale\tr\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\tr\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\tr\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\tt"
${SetOutPath} "$INSTDIR\lib\locale\tt\LC_MESSAGES"
${File} "..\..\..\share\locale\tt\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\tt"
${SetOutPath} "$INSTDIR\share\locale\tt\LC_MESSAGES"
${File} "..\..\..\share\locale\tt\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\tt\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\tt\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\ug"
${SetOutPath} "$INSTDIR\lib\locale\ug\LC_MESSAGES"
${File} "..\..\..\share\locale\ug\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\lib\locale\uk"
${SetOutPath} "$INSTDIR\lib\locale\uk\LC_MESSAGES"
${File} "..\..\..\share\locale\uk\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\uk"
${SetOutPath} "$INSTDIR\share\locale\uk\LC_MESSAGES"
${File} "..\..\..\share\locale\uk\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\uk\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\uk\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\share\locale\ur"
${SetOutPath} "$INSTDIR\share\locale\ur\LC_MESSAGES"
${File} "..\..\..\share\locale\ur\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\ur\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\share\locale\uz"
${SetOutPath} "$INSTDIR\share\locale\uz\LC_MESSAGES"
${File} "..\..\..\share\locale\uz\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\uz\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\share\locale\uz@cyrillic"
${SetOutPath} "$INSTDIR\share\locale\uz@cyrillic\LC_MESSAGES"
${File} "..\..\..\share\locale\uz@cyrillic\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\uz@cyrillic\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\vi"
${SetOutPath} "$INSTDIR\lib\locale\vi\LC_MESSAGES"
${File} "..\..\..\share\locale\vi\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\vi"
${SetOutPath} "$INSTDIR\share\locale\vi\LC_MESSAGES"
${File} "..\..\..\share\locale\vi\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\vi\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\vi\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\wa"
${SetOutPath} "$INSTDIR\lib\locale\wa\LC_MESSAGES"
${File} "..\..\..\share\locale\wa\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\wa"
${SetOutPath} "$INSTDIR\share\locale\wa\LC_MESSAGES"
${File} "..\..\..\share\locale\wa\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\wa\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\wa\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\xh"
${SetOutPath} "$INSTDIR\lib\locale\xh\LC_MESSAGES"
${File} "..\..\..\share\locale\xh\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\xh"
${SetOutPath} "$INSTDIR\share\locale\xh\LC_MESSAGES"
${File} "..\..\..\share\locale\xh\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\xh\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\xh\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\yi"
${SetOutPath} "$INSTDIR\lib\locale\yi\LC_MESSAGES"
${File} "..\..\..\share\locale\yi\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\yi"
${SetOutPath} "$INSTDIR\share\locale\yi\LC_MESSAGES"
${File} "..\..\..\share\locale\yi\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\yi\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\yi\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\zh_CN"
${SetOutPath} "$INSTDIR\lib\locale\zh_CN\LC_MESSAGES"
${File} "..\..\..\share\locale\zh_CN\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\zh_CN"
${SetOutPath} "$INSTDIR\share\locale\zh_CN\LC_MESSAGES"
${File} "..\..\..\share\locale\zh_CN\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\zh_CN\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\zh_CN\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\zh_HK"
${SetOutPath} "$INSTDIR\lib\locale\zh_HK\LC_MESSAGES"
${File} "..\..\..\share\locale\zh_HK\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\zh_HK"
${SetOutPath} "$INSTDIR\share\locale\zh_HK\LC_MESSAGES"
${File} "..\..\..\share\locale\zh_HK\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\zh_HK\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\zh_HK\LC_MESSAGES\" "gtk20.mo"
${SetOutPath} "$INSTDIR\lib\locale\zh_TW"
${SetOutPath} "$INSTDIR\lib\locale\zh_TW\LC_MESSAGES"
${File} "..\..\..\share\locale\zh_TW\LC_MESSAGES\" "atk10.mo"
${SetOutPath} "$INSTDIR\share\locale\zh_TW"
${SetOutPath} "$INSTDIR\share\locale\zh_TW\LC_MESSAGES"
${File} "..\..\..\share\locale\zh_TW\LC_MESSAGES\" "glib20.mo"
${File} "..\..\..\share\locale\zh_TW\LC_MESSAGES\" "gtk20-properties.mo"
${File} "..\..\..\share\locale\zh_TW\LC_MESSAGES\" "gtk20.mo"
  !endif
  
  CreateDirectory "$SMPROGRAMS\Dia\French"
  CreateShortCut "$SMPROGRAMS\Dia\French\Dia Manual (CHM).lnk" "$INSTDIR\help\fr\dia-manual.chm"
  CreateShortCut "$SMPROGRAMS\Dia\French\Dia Manual (PDF).lnk" "$INSTDIR\help\fr\dia-manual.pdf"
  CreateDirectory "$SMPROGRAMS\Dia\Polish"
  CreateShortCut "$SMPROGRAMS\Dia\Polish\Dia Manual (CHM).lnk" "$INSTDIR\help\pl\dia-manual.chm"
  CreateShortCut "$SMPROGRAMS\Dia\Polish\Dia Manual (PDF).lnk" "$INSTDIR\help\pl\dia-manual.pdf"
  CreateDirectory "$SMPROGRAMS\Dia\Basque"
  CreateShortCut "$SMPROGRAMS\Dia\Basque\Dia Manual (CHM).lnk" "$INSTDIR\help\eu\dia-manual.chm"
  CreateShortCut "$SMPROGRAMS\Dia\Basque\Dia Manual (PDF).lnk" "$INSTDIR\help\eu\dia-manual.pdf"
  
SectionEnd

Section /o $(PYTHON_SECTION_TITLE) SecPython
  SectionIn RO
  ClearErrors
  SetOverwrite On
  ${SetOutPath} "$INSTDIR\dia"
  ${File} "..\..\plug-ins\python\" "dia-python.dll"
  ${SetOutPath} "$INSTDIR\bin"
  ${File} "..\..\plug-ins\python\" "dia.pyd"
  ${SetOutPath} "$INSTDIR"
  ${File} "..\..\plug-ins\python\" "allprops.py"
  ${File} "..\..\plug-ins\python\" "aobjects.py"
  ${File} "..\..\plug-ins\python\" "arrange.py"
  ${File} "..\..\plug-ins\python\" "autolayoutforce.py"
  ${File} "..\..\plug-ins\python\" "bbox.py"
  ${File} "..\..\plug-ins\python\" "codegen.py"
  ${File} "..\..\plug-ins\python\" "debug_objects.py"
  ${File} "..\..\plug-ins\python\" "diagx.py"
  ${File} "..\..\plug-ins\python\" "diastddia.py"
  ${File} "..\..\plug-ins\python\" "diasvg.py"
  ${File} "..\..\plug-ins\python\" "diasvg_import.py"
  ${File} "..\..\plug-ins\python\" "dot2dia.py"
  ${File} "..\..\plug-ins\python\" "dot.py"
  ${File} "..\..\plug-ins\python\" "doxrev.py"
  ${File} "..\..\plug-ins\python\" "export-object.py"
  ${File} "..\..\plug-ins\python\" "export-render.py"
  ${File} "..\..\plug-ins\python\" "group_props.py"
  ${File} "..\..\plug-ins\python\" "gtkcons.py"
  ${File} "..\..\plug-ins\python\" "imgmap.py"
  ${File} "..\..\plug-ins\python\" "otypes.py" 
  ${File} "..\..\plug-ins\python\" "pydiadoc.py"
  ${File} "..\..\plug-ins\python\" "python-startup.py"
  ${File} "..\..\plug-ins\python\" "scascale.py"
  ${File} "..\..\plug-ins\python\" "select_by.py"
  ${File} "..\..\plug-ins\python\" "select_empty.py"
  ${File} "..\..\plug-ins\python\" "wdeps.py"
SectionEnd

Section -closelogfile
 FileClose $UninstLog
 SetFileAttributes "$INSTDIR\${UninstLog}" READONLY|SYSTEM|HIDDEN
SectionEnd

;--------------------------------
;Uninstaller Section

Section Uninstall
  
  Call un.CheckUserInstallRights
  Pop $R0
  StrCmp $R0 "NONE" no_rights
  StrCmp $R0 "HKCU" try_hkcu try_hklm

  try_hkcu:
    ReadRegStr $R0 HKCU ${DIA_REG_KEY} ""
    StrCmp $R0 $INSTDIR 0 cant_uninstall
      ; HKCU install path matches our INSTDIR.. so uninstall
      DeleteRegKey HKCU ${DIA_REG_KEY}
      DeleteRegKey HKCU "${DIA_UNINSTALL_KEY}"
      Goto cont_uninstall

  try_hklm:
    ReadRegStr $R0 HKLM ${DIA_REG_KEY} ""
    StrCmp $R0 $INSTDIR 0 try_hkcu
      ; HKLM install path matches our INSTDIR.. so uninstall
      DeleteRegKey HKLM ${DIA_REG_KEY}
      DeleteRegKey HKLM "${DIA_UNINSTALL_KEY}"
      DeleteRegKey HKLM "${HKLM_APP_PATHS_KEY}"
      DeleteRegKey HKLM "${HKLM_CMD_PATHS_KEY}"
      ; Sets start menu and desktop scope to all users..
      SetShellVarContext "all"

  cont_uninstall:
    DeleteRegKey HKEY_CLASSES_ROOT "diaFile"
    DeleteRegKey HKEY_CLASSES_ROOT ".dia"
    
    ; The WinPrefs plugin may have left this behind..
    DeleteRegValue HKCU "${DIA_STARTUP_RUN_KEY}" "Dia"
    DeleteRegValue HKLM "${DIA_STARTUP_RUN_KEY}" "Dia"
    ; Remove Language preference info
    DeleteRegKey HKCU ${DIA_REG_KEY} ;${MUI_LANGDLL_REGISTRY_ROOT} ${MUI_LANGDLL_REGISTRY_KEY}
    
    ; Can't uninstall if uninstall.log is missing!
 IfFileExists "$INSTDIR\${UninstLog}" +3
  MessageBox MB_OK|MB_ICONSTOP "${UninstLog} not found!"
  Goto no_uninstlog
 
 Push $R0
 SetFileAttributes "$INSTDIR\${UninstLog}" NORMAL
 FileOpen $UninstLog "$INSTDIR\${UninstLog}" r
 
 LoopRead:
  ClearErrors
   FileRead $UninstLog $R0
   IfErrors LoopDone
 
   Push $R0
    Call un.TrimNewLines
   Pop $R0
   IfFileExists "$R0\*.*" 0 +3
    RMDir $R0  #is dir
   Goto LoopRead
    Delete $R0 #is file
 
    Goto LoopRead
   LoopDone:
   FileClose $UninstLog
   Delete "$INSTDIR\${UninstLog}"
   Pop $R0
    Delete "$INSTDIR\${DIA_UNINST_EXE}"
    
    no_uninstlog:
    ; Shortcuts..
    Delete "$SMPROGRAMS\Dia\Dia.lnk"
    Delete "$SMPROGRAMS\Dia\Uninstall.lnk"
    Delete "$SMPROGRAMS\Dia\Dia Manual (CHM).lnk"
    Delete "$SMPROGRAMS\Dia\Dia Manual (PDF).lnk"
    Delete "$SMPROGRAMS\Dia\FAQ.lnk"
    Delete "$SMPROGRAMS\Dia\Basque\Dia Manual (CHM).lnk"
    Delete "$SMPROGRAMS\Dia\Basque\Dia Manual (PDF).lnk"
    RMDir "$SMPROGRAMS\Dia\Basque"
    Delete "$SMPROGRAMS\Dia\Polish\Dia Manual (CHM).lnk"
    Delete "$SMPROGRAMS\Dia\Polish\Dia Manual (PDF).lnk"
    RMDir "$SMPROGRAMS\Dia\Polish"
	Delete "$SMPROGRAMS\Dia\French\Dia Manual (CHM).lnk"
    Delete "$SMPROGRAMS\Dia\French\Dia Manual (PDF).lnk"
    RMDir "$SMPROGRAMS\Dia\French"
    RMDir "$SMPROGRAMS\Dia"
    
    IfSilent done
    MessageBox MB_YESNO|MB_ICONEXCLAMATION $(un.DIA_UNINSTALLATION_WARNING) IDNO done
    skip_warning:
    RMDir /r "$INSTDIR"
    
    MessageBox MB_YESNO|MB_ICONEXCLAMATION $(un.DIA_DOTDIA_WARNING) IDNO done
    SetShellVarContext current
    RMDir /r "$PROFILE\.dia"
    
    Goto done

  cant_uninstall:
    IfSilent skip_mb
    MessageBox MB_OK $(un.DIA_UNINSTALL_ERROR_1) IDOK
    skip_mb:
    Quit

  no_rights:
    IfSilent skip_mb1
    MessageBox MB_OK $(un.DIA_UNINSTALL_ERROR_2) IDOK
    skip_mb1:
    Quit

  done:
SectionEnd ; end of uninstall section

;--------------------------------
;Descriptions
!insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
!insertmacro MUI_DESCRIPTION_TEXT ${SecDia} \
	$(DIA_SECTION_DESCRIPTION)
!insertmacro MUI_DESCRIPTION_TEXT ${SecTranslations} \
  	$(TRANSLATIONS_SECTION_DESCRIPTION)	
!insertmacro MUI_DESCRIPTION_TEXT ${SecPython} \
        $(PYTHON_SECTION_DESCRIPTION)     

!insertmacro MUI_FUNCTION_DESCRIPTION_END

;--------------------------------
;Functions

Function CheckUserInstallRights
	ClearErrors
	UserInfo::GetName
	IfErrors Win9x
	Pop $0
	UserInfo::GetAccountType
	Pop $1

	StrCmp $1 "Admin" 0 +3
                StrCpy $1 "HKLM"
		Goto done
	StrCmp $1 "Power" 0 +3
                StrCpy $1 "HKLM"
		Goto done
	StrCmp $1 "User" 0 +3
		StrCpy $1 "HKCU"
		Goto done
	StrCmp $1 "Guest" 0 +3
		StrCpy $1 "NONE"
		Goto done
	; Unknown error
	StrCpy $1 "NONE"
        Goto done

	Win9x:
		StrCpy $1 "HKLM"

	done:
        Push $1
FunctionEnd

Function un.CheckUserInstallRights
	ClearErrors
	UserInfo::GetName
	IfErrors Win9x
	Pop $0
	UserInfo::GetAccountType
	Pop $1

	StrCmp $1 "Admin" 0 +3
                StrCpy $1 "HKLM"
		Goto done
	StrCmp $1 "Power" 0 +3
                StrCpy $1 "HKLM"
		Goto done
	StrCmp $1 "User" 0 +3
		StrCpy $1 "HKCU"
		Goto done
	StrCmp $1 "Guest" 0 +3
		StrCpy $1 "NONE"
		Goto done
	; Unknown error
	StrCpy $1 "NONE"
        Goto done

	Win9x:
		StrCpy $1 "HKLM"

	done:
        Push $1
FunctionEnd

;
; Usage:
;   Push $0 ; Path string
;   Call VerifyDir
;   Pop $0 ; 0 - Bad path  1 - Good path
;
Function VerifyDir
  Pop $0
  Loop:
    IfFileExists $0 dir_exists
    StrCpy $1 $0 ; save last
    Push $0
    Call GetParent
    Pop $0
    StrLen $2 $0
    ; IfFileExists "C:" on xp returns true and on win2k returns false
    ; So we're done in such a case..
    StrCmp $2 "2" loop_done
    Goto Loop

  loop_done:
    StrCpy $1 "$0\diaFooB"
    ; Check if we can create dir on this drive..
    ClearErrors
    CreateDirectory $1
    IfErrors DirBad DirGood

  dir_exists:
    ClearErrors
    FileOpen $1 "$0\diafoo.bar" w
    IfErrors PathBad PathGood

    DirGood:
      RMDir $1
      Goto PathGood1

    DirBad:
      RMDir $1
      Goto PathBad1

    PathBad:
      FileClose $1
      Delete "$0\diafoo.bar"
      PathBad1:
      StrCpy $0 "0"
      Push $0
      Return

    PathGood:
      FileClose $1
      Delete "$0\diafoo.bar"
      PathGood1:
      StrCpy $0 "1"
      Push $0
FunctionEnd

Function .onVerifyInstDir
  Push $INSTDIR
  Call VerifyDir
  Pop $0
  StrCmp $0 "0" 0 dir_good
    Abort
  dir_good:
FunctionEnd

; GetParent
; input, top of stack  (e.g. C:\Program Files\Poop)
; output, top of stack (replaces, with e.g. C:\Program Files)
; modifies no other variables.
;
; Usage:
;   Push "C:\Program Files\Directory\Whatever"
;   Call GetParent
;   Pop $R0
;   ; at this point $R0 will equal "C:\Program Files\Directory"
Function GetParent
   Exch $0 ; old $0 is on top of stack
   Push $1
   Push $2
   StrCpy $1 -1
   loop:
     StrCpy $2 $0 1 $1
     StrCmp $2 "" exit
     StrCmp $2 "\" exit
     IntOp $1 $1 - 1
   Goto loop
   exit:
     StrCpy $0 $0 $1
     Pop $2
     Pop $1
     Exch $0 ; put $0 on top of stack, restore $0 to original value
FunctionEnd

!define SECTION_ENABLE   0xFFFFFFEF
Function .onInit
  StrCpy $name "Dia ${DIA_VERSION}"
  !define MUI_LANGDLL_ALLLANGUAGES
  !insertmacro MUI_LANGDLL_DISPLAY
  ClearErrors
  
  ; Only enable the Python section if python23.dll is in the system path
  SearchPath $0 "python23.dll"
  IfErrors NoPython HasPython
  HasPython:
  SectionGetFlags ${SecPython} $0  
  IntOp $0 $0 & ${SECTION_ENABLE}
  SectionSetFlags ${SecPython} $0
  NoPython: 
  ClearErrors
  
  ; If install path was set on the command, use it.
  StrCmp $INSTDIR "" 0 instdir_done

  Call CheckUserInstallRights
  Pop $0

  StrCmp $0 "HKLM" 0 user_dir
    StrCpy $INSTDIR "$PROGRAMFILES\Dia"
    Goto instdir_done
  user_dir:
    StrCpy $2 "$SMPROGRAMS"
    Push $2
    Call GetParent
    Call GetParent
    Pop $2
    StrCpy $INSTDIR "$2\Dia"

  instdir_done:

  !ifdef DIA_INCLUDE_GTK
  StrCpy $GTKBIN "$INSTDIR\bin"
  !else
  ReadRegStr $GTKBIN HKLM "Software\GTK\2.0" "DllPath"
  ReadRegStr $0 HKLM "Software\GTK\2.0" "Version"
  StrCpy $1 $0 4
  StrCmp $1 "2.0." outdated_gtk
  StrCmp $1 "2.1." outdated_gtk
  StrCmp $1 "2.2." outdated_gtk
  StrCmp $1 "2.3." outdated_gtk
  StrCmp $1 "2.4." outdated_gtk
  StrCmp $1 "2.5." outdated_gtk
  StrCmp $1 "2.6." outdated_gtk
  StrCmp $1 "2.7." outdated_gtk
  StrCmp $1 "2.8." outdated_gtk
  StrCmp $1 "2.9." outdated_gtk
  Goto has_gtk
  no_gtk:
  Push "GTKBIN"         ; push the search string onto the stack
  Push "C:\Program Files\Common Files\GTK\2.0\bin"   ; push a default value onto the stack
  Call GetParameterValue
  Pop $GTKBIN
  IfFileExists "$GTKBIN\libgtk-win32-2.0-0.dll" has_gtk 
  outdated_gtk:
  MessageBox MB_OK|MB_ICONEXCLAMATION $(DIA_NO_GTK)
  Abort $(DIA_NO_GTK)
  has_gtk:
  ;Fix Freetype DLL naming problem gimp-win/gladewin32
  IfFileExists "$GTKBIN\libfreetype-6.dll" has_gladewin32_freetype_dll copy_freetype_dll 
  copy_freetype_dll:
  CopyFiles "$GTKBIN\freetype6.dll" "$GTKBIN\libfreetype-6.dll" 
  has_gladewin32_freetype_dll:
  !endif
FunctionEnd

Function un.TrimNewlines
   Exch $R0
   Push $R1
   Push $R2
   StrCpy $R1 0
 
 loop:
   IntOp $R1 $R1 - 1
   StrCpy $R2 $R0 1 $R1
   StrCmp $R2 "$\r" loop
   StrCmp $R2 "$\n" loop
   IntOp $R1 $R1 + 1
   IntCmp $R1 0 no_trim_needed
   StrCpy $R0 $R0 $R1
 
 no_trim_needed:
   Pop $R2
   Pop $R1
   Exch $R0
 FunctionEnd

; GetParameterValue
; Chris Morgan<cmorgan@alum.wpi.edu> 5/10/2004
; -Updated 4/7/2005 to add support for retrieving a command line switch
;  and additional documentation
;
; Searches the command line input, retrieved using GetParameters, for the
; value of an option given the option name.  If no option is found the
; default value is placed on the top of the stack upon function return.
;
; This function can also be used to detect the existence of just a
; command line switch like /OUTPUT  Pass the default and "OUTPUT"
; on the stack like normal.  An empty return string "" will indicate
; that the switch was found, the default value indicates that
; neither a parameter or switch was found.
;
; Inputs - Top of stack is default if parameter isn't found,
;  second in stack is parameter to search for, ex. "OUTPUT"
; Outputs - Top of the stack contains the value of this parameter
;  So if the command line contained /OUTPUT=somedirectory, "somedirectory"
;  will be on the top of the stack when this function returns
;
; Register usage
;$R0 - default return value if the parameter isn't found
;$R1 - input parameter, for example OUTPUT from the above example
;$R2 - the length of the search, this is the search parameter+2
;      as we have '/OUTPUT='
;$R3 - the command line string
;$R4 - result from StrStr calls
;$R5 - search for ' ' or '"'
 
Function GetParameterValue
  Exch $R0  ; get the top of the stack(default parameter) into R0
  Exch      ; exchange the top of the stack(default) with
            ; the second in the stack(parameter to search for)
  Exch $R1  ; get the top of the stack(search parameter) into $R1
 
  ;Preserve on the stack the registers used in this function
  Push $R2
  Push $R3
  Push $R4
  Push $R5
 
  Strlen $R2 $R1+2    ; store the length of the search string into R2
 
  Call GetParameters  ; get the command line parameters
  Pop $R3             ; store the command line string in R3
 
  # search for quoted search string
  StrCpy $R5 '"'      ; later on we want to search for a open quote
  Push $R3            ; push the 'search in' string onto the stack
  Push '"/$R1='       ; push the 'search for'
  Call StrStr         ; search for the quoted parameter value
  Pop $R4
  StrCpy $R4 $R4 "" 1   ; skip over open quote character, "" means no maxlen
  StrCmp $R4 "" "" next ; if we didn't find an empty string go to next
 
  # search for non-quoted search string
  StrCpy $R5 ' '      ; later on we want to search for a space since we
                      ; didn't start with an open quote '"' we shouldn't
                      ; look for a close quote '"'
  Push $R3            ; push the command line back on the stack for searching
  Push '/$R1='        ; search for the non-quoted search string
  Call StrStr
  Pop $R4
 
  ; $R4 now contains the parameter string starting at the search string,
  ; if it was found
next:
  StrCmp $R4 "" check_for_switch ; if we didn't find anything then look for
                                 ; usage as a command line switch
  # copy the value after /$R1= by using StrCpy with an offset of $R2,
  # the length of '/OUTPUT='
  StrCpy $R0 $R4 "" $R2  ; copy commandline text beyond parameter into $R0
  # search for the next parameter so we can trim this extra text off
  Push $R0
  Push $R5            ; search for either the first space ' ', or the first
                      ; quote '"'
                      ; if we found '"/output' then we want to find the
                      ; ending ", as in '"/output=somevalue"'
                      ; if we found '/output' then we want to find the first
                      ; space after '/output=somevalue'
  Call StrStr         ; search for the next parameter
  Pop $R4
  StrCmp $R4 "" done  ; if 'somevalue' is missing, we are done
  StrLen $R4 $R4      ; get the length of 'somevalue' so we can copy this
                      ; text into our output buffer
  StrCpy $R0 $R0 -$R4 ; using the length of the string beyond the value,
                      ; copy only the value into $R0
  goto done           ; if we are in the parameter retrieval path skip over
                      ; the check for a command line switch
 
; See if the parameter was specified as a command line switch, like '/output'
check_for_switch:
  Push $R3            ; push the command line back on the stack for searching
  Push '/$R1'         ; search for the non-quoted search string
  Call StrStr
  Pop $R4
  StrCmp $R4 "" done  ; if we didn't find anything then use the default
  StrCpy $R0 ""       ; otherwise copy in an empty string since we found the
                      ; parameter, just didn't find a value
 
done:
  Pop $R5
  Pop $R4
  Pop $R3
  Pop $R2
  Pop $R1
  Exch $R0 ; put the value in $R0 at the top of the stack
FunctionEnd

 ; GetParameters
 ; input, none
 ; output, top of stack (replaces, with e.g. whatever)
 ; modifies no other variables.
 
Function GetParameters
 
  Push $R0
  Push $R1
  Push $R2
  Push $R3
  
  StrCpy $R2 1
  StrLen $R3 $CMDLINE
  
  ;Check for quote or space
  StrCpy $R0 $CMDLINE $R2
  StrCmp $R0 '"' 0 +3
    StrCpy $R1 '"'
    Goto loop
  StrCpy $R1 " "
  
  loop:
    IntOp $R2 $R2 + 1
    StrCpy $R0 $CMDLINE 1 $R2
    StrCmp $R0 $R1 get
    StrCmp $R2 $R3 get
    Goto loop
  
  get:
    IntOp $R2 $R2 + 1
    StrCpy $R0 $CMDLINE 1 $R2
    StrCmp $R0 " " get
    StrCpy $R0 $CMDLINE "" $R2
  
  Pop $R3
  Pop $R2
  Pop $R1
  Exch $R0
 
FunctionEnd

!define StrStr "!insertmacro StrStr"
 
!macro StrStr ResultVar String SubString
  Push `${String}`
  Push `${SubString}`
  Call StrStr
  Pop `${ResultVar}`
!macroend
 
Function StrStr
/*After this point:
  ------------------------------------------
  $R0 = SubString (input)
  $R1 = String (input)
  $R2 = SubStringLen (temp)
  $R3 = StrLen (temp)
  $R4 = StartCharPos (temp)
  $R5 = TempStr (temp)*/
 
  ;Get input from user
  Exch $R0
  Exch
  Exch $R1
  Push $R2
  Push $R3
  Push $R4
  Push $R5
 
  ;Get "String" and "SubString" length
  StrLen $R2 $R0
  StrLen $R3 $R1
  ;Start "StartCharPos" counter
  StrCpy $R4 0
 
  ;Loop until "SubString" is found or "String" reaches its end
  loop:
    ;Remove everything before and after the searched part ("TempStr")
    StrCpy $R5 $R1 $R2 $R4
 
    ;Compare "TempStr" with "SubString"
    StrCmp $R5 $R0 done
    ;If not "SubString", this could be "String"'s end
    IntCmp $R4 $R3 done 0 done
    ;If not, continue the loop
    IntOp $R4 $R4 + 1
    Goto loop
  done:
 
/*After this point:
  ------------------------------------------
  $R0 = ResultVar (output)*/
 
  ;Remove part before "SubString" on "String" (if there has one)
  StrCpy $R0 $R1 `` $R4
 
  ;Return output to user
  Pop $R5
  Pop $R4
  Pop $R3
  Pop $R2
  Pop $R1
  Exch $R0
FunctionEnd

Function LaunchDia
  ExecShell "" "$SMPROGRAMS\Dia\Dia.lnk"

FunctionEnd
