// Written by James A. Pattie (james@pcxperience.com) Xperience, Inc. (www.pcxperience.com)

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef __HPP_VIRUSSCANNER
#define __HPP_VIRUSSCANNER
#include "OptionContainer.hpp"
#include "Socket.hpp"
#include "String.hpp"
#include <exception>
#include <fstream>
#include <sys/stat.h>

class VirusScanner {

public:
    long unsigned int file_length;
    int isInfected;
    const char *virname;
    char *tempFileName;
    int tempfileFD;

    VirusScanner();
    ~VirusScanner();

    void handleScanning(Socket *proxysock, Socket *peerconn, String url, int docsize, int contentLength, std::string username, std::string clientip, int filtergroup, std::string location, int reporting_level, int scantype) throw(exception);
    void setTimeout(int t);
    void createTempFile(void) throw(exception);
    bool out(Socket *sock, char *block, int size) throw(exception);
    void in(Socket* sock, Socket* outSock, String url, int docsize, int contentLength, std::string username, std::string clientip, int scantype) throw(exception);
    void scan(Socket *peerconn, String url, std::string username, std::string clientip, int filtergroup, std::string location, int reporting_level, int scantype) throw(exception);
    void sendmail (std::string username, String url, std::string clientip);

private:
    int timeout;
    int trickle_pos;
};

#endif
