/*
** Copyright 1998 - 2006 Double Precision, Inc.
** See COPYING for distribution information.
*/

#include	<string.h>
#include	<stdio.h>
#if HAVE_CONFIG_H
#include	"config.h"
#endif
#if HAVE_UNISTD_H
#include	<unistd.h>
#endif
#include	"afx.h"

static const char rcsid[]="$Id: exception.C,v 2.1 2006/05/28 15:29:51 mrsam Exp $";

// Various exception classes

const char * CException::GetErrorMessage()
{
	return ("ERROR: Program exception.");
}

int CException::GetErrorNumber()
{
	return (0);
}

static inline void ignore_warning(int)
{
}

void CException::ReportError()
{
	const char * p=GetErrorMessage();

	ignore_warning(write(2, p, strlen(p)*sizeof(*p)));
	if (m_module || m_line)
	{
		ignore_warning(write(2, " (", 2));
		if (m_module)
		{
			ignore_warning(write(2, "file ", 5));
			ignore_warning(write(2, m_module,
					     strlen(m_module)*sizeof(*m_module))
				       );
			if (m_line)
				ignore_warning(write(2, ", ", 2));
		}
		if (m_line)
		{
		char	buf[40];

			sprintf(buf, "%d", m_line);
			ignore_warning(write(2, "line ", 5));
			ignore_warning(write(2, buf, strlen(buf)));
		}
		ignore_warning(write(2, ")", 1));
	}
	ignore_warning(write(2, "\n", 1));
}

static CSimpleException out_of_memory("ERROR: Out of memory.");
static CSimpleException internal("ERROR: Internal error detected.");

void AfxThrowMemoryException()
{
	out_of_memory.Throw();
}

void Afx_ThrowInternalException(const char *module, int line)
{
	internal.m_module=module;
	internal.m_line=line;
	internal.Throw();
}

