// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CTypeRecord_h__
#define __CTypeRecord_h__

#ifndef __CTypeInfo_h__
#warning !!!      DO NOT INCLUDE THIS FILE      !!!  
#warning !!! INCLUDE FILE "CTypeInfo.h" INSTEAD !!!  
#endif

namespace Puma {


class CRecord;

class CTypeRecord : public CTypeInfo {
  bool _hasConstMember;

  long int _Size;
  long int _Align;

  CRecord *_Record;

protected:
  CTypeRecord (TypeId, CRecord *);

public:
  ~CTypeRecord ();

  long int Size ();
  long int Align ();

  void hasConstMember (bool);
  bool hasConstMember () const;

  bool isComplete (unsigned long = 0) const;

  CRecord *Record () const;
  void Record (CRecord *);
};

inline CTypeRecord::CTypeRecord (CTypeInfo::TypeId id, CRecord *r) :
  CTypeInfo (&CTYPE_EMPTY, id),
  _hasConstMember (false),
  _Size (0),
  _Align (0),
  _Record (r)
 {}
inline CTypeRecord::~CTypeRecord ()
 {}

inline CRecord *CTypeRecord::Record () const 
 { return _Record; }
inline void CTypeRecord::Record (CRecord *r)
 { _Record = r; }

inline long int CTypeRecord::Align () 
 { return (Size (), _Align); }

inline bool CTypeRecord::hasConstMember () const
 { return _hasConstMember; }
inline void CTypeRecord::hasConstMember (bool v)
 { _hasConstMember = v; }


} // namespace Puma

#endif /* __CTypeRecord_h__ */
