// This file is part of the AspectC++ compiler 'ac++'.
// Copyright (C) 1999-2003  The 'ac++' developers (see aspectc.org)
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __AspectInfo_h__
#define __AspectInfo_h__

#include <list>
using std::list;
#include <set>
using std::set;
#include <string>
using std::string;

#include "ThisJoinPoint.h"

#include "Puma/CClassInfo.h"
#include "Puma/ACAspectInfo.h"
#include "Puma/CTree.h"
#include "Puma/Unit.h"
using namespace Puma;

namespace Puma {
  class ACAspectInfo;
} // namespace Puma

class AdviceInfo;
class IntroductionInfo;
class OrderInfo;

class AspectInfo {
  ACAspectInfo *_aspect;
  ThisJoinPoint _aspectof_tjp;
  CFunctionInfo *_aspectof;
  list<AdviceInfo*> _advice_infos;
  list<IntroductionInfo*> _intro_infos;
  list<OrderInfo*> _order_infos;
    
 public:

  AspectInfo (ACAspectInfo *a) : _aspect (a) {}
  const char *name () const { return _aspect->name (); }
  const Unit &unit () { return *(const Unit*)ClassInfo ()->SourceInfo ()->
			  StartToken ()->token ()->belonging_to (); }
  int line () const { return acnode ()->ClassInfo ()->SourceInfo ()->Line (); }
  ACAspectInfo *acnode () const { return _aspect; }
  CClassInfo *ClassInfo () { return _aspect->ClassInfo (); }

  ThisJoinPoint &aspectof_this_join_point () { return _aspectof_tjp; }
  CFunctionInfo *aspectof ();
  bool default_instance();

  // the list of associated code advice nodes
  list<AdviceInfo*> &advice_infos () { return _advice_infos; }
  
  // the list of associated order advice nodes
  list<OrderInfo*> &order_infos () { return _order_infos; }
  
  // the list of associated introduction nodes
  list<IntroductionInfo*> &intro_infos () { return _intro_infos; }
  
  // generate the invocation function forward declarations
  string ifct_decls () const;

  // generate the invocation function definitions
  string ifct_defs () const;
};

#endif // __AspectInfo_h__
