/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.event;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventBlock;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.event.ListEventPublisher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.List;

public final class ListEventAssembler {
    private EventList sourceList;
    private List atomicChangeBlocks = null;
    private ListEventBlock atomicLatestBlock = null;
    private int[] reorderMap = null;
    private List listeners = new ArrayList();
    private List listenerEvents = new ArrayList();
    private ListEventPublisher publisher = null;
    private int eventLevel = 0;
    private boolean allowNestedEvents = true;
    private boolean allowContradictingEvents = false;

    public ListEventAssembler(EventList sourceList, ListEventPublisher publisher) {
        this.sourceList = sourceList;
        this.publisher = publisher;
    }

    public void beginEvent() {
        this.beginEvent(false);
    }

    public synchronized void beginEvent(boolean allowNestedEvents) {
        if (!this.allowNestedEvents) {
            throw new ConcurrentModificationException("Cannot begin a new event while another event is in progress");
        }
        this.allowNestedEvents = allowNestedEvents;
        if (allowNestedEvents) {
            this.allowContradictingEvents = true;
        }
        if (this.eventLevel == 0) {
            this.prepareEvent();
        }
        ++this.eventLevel;
    }

    private void prepareEvent() {
        this.atomicChangeBlocks = new ArrayList();
        this.atomicLatestBlock = null;
        this.reorderMap = null;
    }

    public void addChange(int type, int startIndex, int endIndex) {
        boolean appendSuccess;
        if (this.atomicLatestBlock != null && (appendSuccess = this.atomicLatestBlock.append(startIndex, endIndex, type))) {
            return;
        }
        this.atomicLatestBlock = new ListEventBlock(startIndex, endIndex, type);
        this.atomicChangeBlocks.add(this.atomicLatestBlock);
    }

    public void addChange(int type, int index) {
        this.addChange(type, index, index);
    }

    public void addInsert(int index) {
        this.addChange(2, index);
    }

    public void addDelete(int index) {
        this.addChange(0, index);
    }

    public void addUpdate(int index) {
        this.addChange(1, index);
    }

    public void addInsert(int startIndex, int endIndex) {
        this.addChange(2, startIndex, endIndex);
    }

    public void addDelete(int startIndex, int endIndex) {
        this.addChange(0, startIndex, endIndex);
    }

    public void addUpdate(int startIndex, int endIndex) {
        this.addChange(1, startIndex, endIndex);
    }

    public void reorder(int[] reorderMap) {
        if (this.atomicChangeBlocks.size() > 0) {
            throw new IllegalStateException("Cannot combine reorder with other change events");
        }
        if (reorderMap.length == 0) {
            return;
        }
        this.addChange(0, 0, reorderMap.length - 1);
        this.addChange(2, 0, reorderMap.length - 1);
        this.reorderMap = reorderMap;
    }

    public void forwardEvent(ListEvent listChanges) {
        if (this.eventLevel == 0) {
            this.atomicChangeBlocks = listChanges.getBlocks();
            this.reorderMap = listChanges.isReordering() ? listChanges.getReorderMap() : null;
            this.fireEvent();
        } else {
            this.beginEvent();
            this.reorderMap = null;
            if (this.atomicChangeBlocks.isEmpty() && listChanges.isReordering()) {
                this.reorder(listChanges.getReorderMap());
            } else {
                while (listChanges.nextBlock()) {
                    this.addChange(listChanges.getType(), listChanges.getBlockStartIndex(), listChanges.getBlockEndIndex());
                }
            }
            this.commitEvent();
        }
    }

    public synchronized void commitEvent() {
        if (this.eventLevel == 0) {
            throw new IllegalStateException("Cannot commit without an event in progress");
        }
        --this.eventLevel;
        this.allowNestedEvents = true;
        if (this.eventLevel == 0) {
            ListEventBlock.sortListEventBlocks(this.atomicChangeBlocks, this.allowContradictingEvents);
            this.fireEvent();
        }
    }

    public boolean isEventEmpty() {
        return this.atomicChangeBlocks == null || this.atomicChangeBlocks.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEvent() {
        try {
            if (this.atomicChangeBlocks.isEmpty()) {
                return;
            }
            ArrayList listenersToNotify = new ArrayList(this.listeners);
            ArrayList listenerEventsToNotify = new ArrayList(this.listenerEvents);
            this.publisher.fireEvent(this.sourceList, listenersToNotify, listenerEventsToNotify);
        }
        finally {
            this.atomicChangeBlocks = null;
            this.atomicLatestBlock = null;
            this.reorderMap = null;
            this.allowContradictingEvents = false;
        }
    }

    List getBlocks() {
        return this.atomicChangeBlocks;
    }

    int[] getReorderMap() {
        return this.reorderMap;
    }

    public synchronized void addListEventListener(ListEventListener listChangeListener) {
        this.listeners.add(listChangeListener);
        this.listenerEvents.add(new ListEvent(this, this.sourceList));
        this.publisher.addDependency(this.sourceList, listChangeListener);
    }

    public synchronized void removeListEventListener(ListEventListener listChangeListener) {
        int index = -1;
        for (int i = 0; i < this.listeners.size(); ++i) {
            if (this.listeners.get(i) != listChangeListener) continue;
            index = i;
            break;
        }
        if (index == -1) {
            throw new IllegalArgumentException("Cannot remove nonexistent listener " + listChangeListener);
        }
        this.listenerEvents.remove(index);
        this.listeners.remove(index);
        this.publisher.removeDependency(this.sourceList, listChangeListener);
    }

    public List getListEventListeners() {
        return Collections.unmodifiableList(this.listeners);
    }
}

