/********************************************************************************
* Copyright (c) Des Herriott 1993, 1994
*               Erik Kunze   1995 - 1999
*
* Permission to use, distribute, and sell this software and its documentation
* for any purpose is hereby granted without fee, provided that the above
* copyright notice appear in all copies and that both that copyright notice and
* this permission notice appear in supporting documentation, and that the name
* of the copyright holder not be used in advertising or publicity pertaining to
* distribution of the software without specific, written prior permission.  The
* copyright holder makes no representations about the suitability of this
* software for any purpose.  It is provided "as is" without express or implied
* warranty. THE CODE MAY NOT BE MODIFIED OR REUSED WITHOUT PERMISSION!
*
* THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
* EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
* PERFORMANCE OF THIS SOFTWARE.
*
* Authors: Des Herriott
*          Erik Kunze
*
* $Id: util.h,v 4.15 1999/03/29 10:35:26 erik Rel $
*******************************************************************************/
#ifndef _XZX_UTIL_H
#define _XZX_UTIL_H
#include <sys/types.h>
#include <stdio.h>
enum { M_INFO, M_WARN, M_PWARN, M_ERR, M_PERR, M_FATAL, M_DEBUG };
enum { FD_UNKNOWN, FD_TTY, FD_FILE, FD_PIPE };
enum {
FT_SNA, FT_Z80, FT_SLT,
FT_TAP, FT_VOC, FT_TZX,
FT_DAT,
FT_DSK, FT_TRD, FT_FDI,
FT_SCL, FT_MGT, FT_IMG,
FT_MDR,
FT_SCR, FT_POK,
FT_UNKNOWN,
FT_ANY, FT_END = -1
};
typedef struct _llist {
struct _llist *next;
void *item;
} Llist;
extern FILE *Fopen(char *, const char *);
extern void *Malloc(size_t, const char *);
extern char *Strdup(const char *, const char *);
extern void *Mmap(char *, int, int *, size_t *);
extern void Munmap(void *, size_t);
extern void OnQuit(void (*)(void));
extern void Quit(int);
#ifdef nec_ews
extern void Msg();
#else
extern void Msg(int, ...);
#endif
extern void IntFrequency(int);
extern int ClassifyDescriptor(int);
extern void SetBlocking(int, int);
extern const char *GetBaseName(char *);
extern int GetFileType(char *);
#ifndef HAVE_STRCASECMP
extern int strcasecmp(const char *, const char *);
extern int strncasecmp(const char *, const char *, int);
#endif
extern const char *FtExt[FT_UNKNOWN];
extern void DestroyList(Llist *, void (*)(void *));
extern Llist *AppendElemList(Llist *, void *);
extern Llist *PrependElemList(Llist *, void *);
extern Llist *RemoveElemList(void *, int (*)(void *, void *), Llist *,
void (*)(void *));
extern Llist *SortedInsertList(void *, int (*)(void *, void *), Llist *);
extern void *RetrieveElemList(Llist *, unsigned int);
#endif
