.\"
.\" Copyright (c) Des Herriott 1993, 1994
.\"               Erik Kunze   1995 - 1999
.\"
.\" Permission to use, distribute, and sell this software and its documentation
.\" for any purpose is hereby granted without fee, provided that the above
.\" copyright notice appear in all copies and that both that copyright notice and
.\" this permission notice appear in supporting documentation, and that the name
.\" of the copyright holder not be used in advertising or publicity pertaining to
.\" distribution of the software without specific, written prior permission.  The
.\" copyright holder makes no representations about the suitability of this
.\" software for any purpose.  It is provided "as is" without express or implied
.\" warranty. THE CODE MAY NOT BE MODIFIED OR REUSED WITHOUT PERMISSION!
.\"
.\" THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
.\" INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
.\" EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
.\" CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
.\" DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
.\" TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
.\" PERFORMANCE OF THIS SOFTWARE.
.\"
.\" Authors: Des Herriott
.\"          Erik Kunze
.\"
.\" $Id: xzx.man,v 4.18 1999/05/11 18:46:08 erik Rel $
.\"
.TH XZX 1
.SH NAME
XZX \- an Sinclair ZX Spectrum emulator
.SH SYNOPSIS
.B xzx
.B [options]
.B [\fIsnaphot-file\fR]
.SH DESCRIPTION
\fBXZX\fR is built on top of a Z-80 emulator, with added routines to support
keyboard and video I/O through an X interface.  The hardware emulation can
operate as a Spectrum 48K, 128K, +2, +3, Pentagon or Scorpion.

\fBXZX\fP supports up to 256K of RAM in Scorpion mode.  Floppy disks are
emulated using files to store the data.  A printer is emulated by sending
its output to standard output.  There is also an emulation of cassette I/O
that uses files for cassette tapes. Sound support is available under most
UNIX systems.
.SH OPTIONS
\fBXZX\fR accepts the following command line options.  Options may also be
specified as X Resources using the same spelling.  Note that the shortest
unique spelling of a resource is acceptable, e.g. "\fIxzx -ma 128\fR" is
equivalent to "\fIxzx -machine 128\fR".
.TP
.BI \-help
Print a synopsis of the accepted options and exit.
.TP
.BI \-version
Print the version and compile-time options of this \fBXZX\fR and exit.
.TP
.BI \-libDir " \fI<path>\fR"
Use \fIpath\fR as the colon-separated directory list to check when loading the
Spectrum ROM and any snapshots specified.  Directories are guaranteed to be
searched in the order they are listed.  Defaults to
"\fI.:/usr/local/lib/xzx\fR".
.TP
.BI \-quiet " \fI<boolean>\fR"
Supresses all non-error messages.  You will see neither warnings nor
informations.  Use at your own risk!  Defaults to \fIfalse\fR.
.TP
.BI \-display " \fI<displayname>\fR"
Set your X display to \fIdisplayname\fR, instead of the default which is to
use the DISPLAY environment variable.
.TP
.BI \-geometry " \fI<geomspec>\fR"
An X11 geometry specification.  The width and height field will be ignored;
only the positioning fields count.
.TP
.BI \-mono " \fI<boolean>\fR"
Force \fBXZX\fR to use only Black and White. In this case, the foreground and
background will contrast, e.g. blue on black will appear as white on black, and
green on white will appear as black on white.
The default for monochrome X servers is halftoning if the scaling factor is
increased.  Defaults to \fIfalse\fR.
.TP
.BI \-private " \fI<boolean>\fR"
Force \fBXZX\fR to use a private colormap at startup.  This is the default if
\fBXZX\fR fails to get all the colours it needs, but be warned, every other
window on your display is likely to go technicolor.  Defaults to \fIfalse\fR.
.TP
.BI \-mitshm " \fI<boolean>\fR"
Boolean specyfying whether XZX should try to use the shared memory extensions
(MITSHM) when starting up.  The shared memory extensions make things a lot
faster, but might not be available on your system, or you might not be allowed
to use them because you are running the emulator on an X terminal, across a
network.  Defaults to \fItrue\fR.
.TP
.BI \-xsync " \fI<boolean>\fR"
Causes the emulator to call the X11 function XSync() before updating the
emulation window: this might be necessary on low-end systems to prevent it
from stealing so many system resources that it would become impossible for
the user to interact with it.  Defaults to \fIfalse\fR.
.TP
.BI \-debug " \fI<n>\fR"
If debug code has been compiled in, specifies the level for debugging.  You
should not have any reason to mess with this one.  It just allows developers
to set the debug level and display debug information depending on what the
debug level is.  Defaults to \fI0\fR.
.TP
.BI \-machine " \fI<48|128|3|Pentagon|Scorpion>\fR"
Specifies the memory model to emulate.  Defaults to \fI48K\fR operation (48).
.TP
.BI \-speed " \fI<n>\fR"
Controls the emulation speed.  The default setting is \fI100\fR, which causes
the emulation to never run faster than the real machine.  A higher value
makes the emulator faster, a lower one makes it slower.  The setting 0 means
to run as fast as possible, without limiting speed. 
.TP
.BI \-fast " \fI<boolean>\fR"
Enables special speed mode.  If this mode is enabled, it will cause the
emulator to disable any speed limit, turn sound emulation off and use a 1/10
refresh rate, so that it will run at the maximum possible speed.  Defaults to
\fIfalse\fR.
.TP
.BI \-scale " \fI<n>\fR"
Specify the Spectrum to X11 pixel magnification.  Valid values are 1, 2 and
3.  Defaults to \fI1\fR.
.TP
.BI \-refresh " \fI<n>\fR"
Specify how often the Spectrum screen is refreshed.  It is refreshed every 
\fIn\fR interrupts, so a lower number means more frequent refreshes.  Specifying
it too low, however, could result in more time being spent in screen painting
than in CPU emulation!  Defaults to every \fI3\fR interrupts, you might get
away with every interrupt if you are lucky.
.TP
.BI \-cache " \fI<boolean>\fR"
Enables a video cache that can speed up the emulation when little graphics
activity is going on; it is especially useful when you run the emulator on a
networked X terminal, as it can reduce the amount of bandwidth required.
Defaults to \fItrue\fR.
.TP
.BI \-noise " \fI<boolean>\fR"
If \fIfalse\fR, then no sound while loading, otherwise you get an approximation
of the sound depending on how many reads from ULA are happening.  Having it
switched on will require more CPU time.  Defaults to \fIfalse\fR.
.PP
It is possible to redefine keys to emulate a Kempston joystick.  The following
options apply.
.TP
.BI \-joyUp " \fI<keysym>\fR"
The key to emulate moving the joystick forwards.  Default is \fIq\fR.
.TP
.BI \-joyDown " \fI<keysym>\fR"
The key to emulate moving the joystick backwards.  Default is \fIa\fR.
.TP
.BI \-joyLeft " \fI<keysym>\fR"
The key to emulate moving the joystick to the left.  Default is \fIo\fR.
.TP
.BI \-joyRight " \fI<keysym>\fR"
The key to emulate moving the joystick to the right.  Default is \fIp\fR.
.TP
.BI \-joyFire " \fI<keysym>\fR"
The key to emulate pressing the joystick Fire button.  Default is
\fIspace\fR.
.PP
A full list of keysyms can be obtained by viewing the file
\fI<X11/keysymdef.h>\fR, and removing the \fIXK_\fR prefix from the
definitions listed there.
.PP
Note that it is possible for a key to emulate both a keyboard keypress and a
joystick movement.  No checks are made to ensure that the same key is not
mapped to two or more joystick directions.  It is also possible to fool
\fBXZX\fR into thinking that the joystick is being simultaneously moved in
opposite directions!
.PP
If \fBXZX\fR is running on Linux or FreeBSD with installed joystick kernel
patches, then it is possible to use a PC analogue or digital joystick to
emulate a Kempston joystick.  In this case, the following options also apply.
.TP
.BI \-joystick " \fI<boolean>\fR"
Enables the usage of the joystick.  The joystick must have been calibrated
before.  Defaults to \fIfalse\fR.
.TP
.BI \-joyDev " \fI<path>\fR"
Use the device specified by \fIpath\fR to read the joystick status,
\fI/dev/js0\fR by default.  You may want to use \fI/dev/js1\fR, depending on
how your system is setup.
.TP
.BI -tolerance " \fI<int>\fR"
This specifies how far from centre the joystick must be displaced before it
registers with \fBXZX\fR as being moved.  The default displacement tolerance is
20.  You may have to experiment with this to get the best response for your
joystick.
.TP
.BI -autofire " \fI<int>\fR"
This specifies how many times in a second the pressing of the fire button
should be simulated.  Defaults to \fI25\fR.
.TP
.BI -juggle " \fI<int>\fR"
This specifies how many times in a second the pressing of the left and
right direction	button should be simulated.  Defaults to \fI25\fR.
.PP
If you are running \fBXZX\fR on a machine with an audio device, such as
\fI/dev/audio\fR, then it is possible to get sound emulation.  The following
options apply.
.TP
.BI -sound " \fI<boolean>\fR"
Turns sound emulation on and off at startup. Sound is \fIdisabled\fR by
default.
.TP
.BI -audioDev " \fI<path>\fR"
Specifies the audio device that \fBXZX\fR uses.  By default, this is
\fI/dev/audio\fR; you should not need to change this, unless your system is set
up very strangely, or you are on an EWS 4800/330, in which case, use
\fI/dev/audio/audio\fR.
.TP
.BI -sample " \fI<n>\fR"
Specify the sampling frequency, ranging from 8000 to 48000 Hz (not all the
sound cards and/or sound drivers can support all the frequencies, so actually
the nearmost candidate will be picked up).  Defaults to \fI8000\fR Hz.
.TP
.BI -volume " \fI<n>\fR"
Sets audio volume for BEEP emulation as a percentage.  Defaults to \fI50\fR.
.PP
In Spectrum 48K and 128K mode the following options apply.
.TP
.BI \-rom48 " \fI<filename>\fR"
Use the romfile specified by \fIfilename\fR in Spectrum 48K mode. The romfile
has to be a raw binary dump, 16K long.  Defaults to \fIspectrum.rom\fR.
.TP
.BI \-issue " \fI<2|3>\fR"
Emulate the specified keyboard issue.  Issue 3 is by far the most
common.  Occasionally a program will need this option to be set to 2 (usually
an old program for instance Spinads) otherwise the keys will not respond.  Note
that all 128K Spectrums were issue 3 and some Spectrum 48K were issue 2, but
not that many.  Defaults to \fI3\fR.
.TP
.BI \-kbdlayout " \fI<filename>\fR"
Use \fIfilename\fR as the file containing an picture of the Spectrum
keyboard.  The file must be in .SCR format and exactly 6912 bytes
long.  Defaults to \fIkeyboard.scr\fR.
.TP
.BI \-rom128 " \fI<filename>\fR"
Use the romfile specified by \fIfilename\fR in Spectrum 128K mode. The romfile
has to be a raw binary dump, 32K long.  \fBXZX\fR will emulate a Spectrum +2 if
the right romfile is provided.  Defaults to \fI128.rom\fR.
.PP
If Spectrum +3 emulation has been compiled in, the following options apply.
.TP
.BI \-rompl3 " \fI<filename>\fR"
Use the romfile specified by \fIfilename\fR in Spectrum +3 mode. The romfile
has to be a raw binary dump, 64K long.  Defaults to \fIplus3.rom\fR.
.TP
.BI \-fd\fI<a|b>\fR " \fI<filename>\fR"
Load disk file \fIfilename\fR into the emulated disk drive \fIA:\fR or
\fIB:\fR.  Defaults to \fIdisk<a|b>.dsk\fR.
.PP
If Pentagon emulation has been compiled in, the following options apply.
.TP
.BI \-pentRom " \fI<filename>\fR"
Use the romfile specified by \fIfilename\fR in Pentagon mode. The romfile
has to be a raw binary dump, 48K long.  Defaults to \fIpentagon.rom\fR.
The romfile is not distributed with \fBXZX\fR.
.PP
If Scorpion emulation has been compiled in, the following options apply.
.TP
.BI \-scorRom " \fI<filename>\fR"
Use the romfile specified by \fIfilename\fR in Scorpion mode. The romfile
has to be a raw binary dump, 64K long.  Defaults to \fIscorpion.rom\fR.
The romfile is not distributed with \fBXZX\fR.
.PP
If ZX Interface I and Microdrive emulation has been compiled in, \fBXZX\fR can
use .MDR files as Microdrive cartridges.  The following options apply.
.TP
.BI -if1 " \fI<boolean>\fR"
Enable or disable the Interface I.  \fIEnabled\fR by default.  In that case,
an image if the Interface I ROM must be present.  The ROM switching is done
in lower 16K.

With the emulator, a new version of the 8K ZX Interface ROM is supported (there
were two different versions of ROMs).  Some ill-based programs will not work
with new the version, but there are also programs which work only with new
version.  Some programs (for example, Beta Basic 3.0.) have two versions, one
for the old ROM and one for the new one.

Turn it off if you want to work without extended basic / microdrive support.
.TP
.BI -if1Rom " \fI<filename>\fR"
Use the romfile specified by \fIfilename\fR as Interface I ROM. The romfile
has to be a raw binary dump, 8 or 16K long.  Defaults to \fIif1.rom\fR.
The romfiles of the Interface I versions 1 and 2 are distributed with
\fBXZX\fR.
.TP
.BI -crlf " \fI<boolean>\fR"
If set to to true, \fBXZX\fR converts linefeeds (ASCII 10) to carriage returns
(ASCII 13) on RS232 input, and vice versa on RS232 output.  This is necessary
if textual data is transferred from Unix to \fBXZX\fR, since the Spectrum
expects to see a carriage return as end-of-line, and Unix uses linefeeds.  Do
not use it if you want to transfer binary data.  See the
"Extensions and Alterations" section below for more details on RS232 I/O.
Default to \fIfalse\fR.
.TP
.BI -strcr " \fI<boolean>\fR"
If set to true, \fBXZX\fR will strip carriage returns on RS232 output.  This
is only useful when listing BASIC programs to the IF1 'T' channel.  Defaults to
\fIfalse\fR.
.TP
.BI -m\fI<n>\fR " \fI<filename>\fR"
Load cartridge file \fIfilename\fR into the emulated Microdrive \fIn\fR.
Defaults to \fIcart<n>.mdr\fR.

A blank, unformatted cartridge file can be created by a command such as
"\fIdd if=/dev/zero of=test.mdr bs=137923 count=1\fR".  A shell script,
\fBmkcart\fR has also been provided to do this.  You can then format it with
the Sinclair BASIC \fBFORMAT\fR command as normal.
.PP
If Multiface emulation has been compiled in, the following options apply.
.TP
.BI -mf " \fI<boolean>\fR"
Enable or disable the Multiface.  \fIDisabled\fR by default.
.TP
.BI -mf128 " \fI<filename>\fR"
Use the romfile specified by \fIfilename\fR as Multiface 128 ROM. The romfile
has to be a raw binary dump, 8K long.  Defaults to \fImf128.rom\fR.  The
romfile is not distributed with \fBXZX\fR.
.TP
.BI -mf3 " \fI<filename>\fR"
Use the romfile specified by \fIfilename\fR as Multiface 3 ROM. The romfile
has to be a raw binary dump, 8K long.  Defaults to \fImf3.rom\fR.  The
romfile is not distributed with \fBXZX\fR.
.PP
If Kempston mouse emulation has been compiled in, the following options apply.
.TP
.BI -kmouse " \fI<boolean>\fR"
Enable or disable Kempston mqouse. \fIDisabled\fR by default.
.TP
.BI -grab " \fI<boolean>\fR"
This option actively grabs control of the pointer.  Further pointer events are
reported only to the emulator.  The pointer is restricted to stay contained in
that window. \fIDisabled\fR by default.
.SH RUNNING THE EMULATOR
If \fBXZX\fR is started with no snapshot file as a command-line argument, it
will reset the machine and start either Sinclair BASIC (48K mode), or display
the start-up menu (128K and +3 modes).  If exactly one argument is passed (not
counting options), \fBXZX\fR will search each directory in turn on its
\fIlibDir\fR resource.  \fBXZX\fR is able to read and write .SNA format
snapshots and any .Z80 format snapshots (including .SLT format), although only
3.05+ format .Z80 snapshots will be written.
.PP
Once the emulator is up and running, the following keys have special meanings:
.TP 12
.B F1
Display HELP screen, that gives meaning of all function keys and the layout of
the Spectrum keyboard.
.TP 12
.B F2
Pops up a file selector for saving a snapshot of the memory of the Spectrum in
whatever current mode it is in.  The format is either .SNA, .Z80 (compatible
with Gerton Lunter's Z80 emulator version 3.05+) or .SLT.  If \fBXZX\fR is in
128K or +3 mode, a .Z80 format snapshot will be dumped no matter what filename is
given.  If \fBXZX\fR is in 48K mode, the decision is the same as for reading
snapshots as described above.
.TP 12
.B F3
Ditto for loading snapshots.
.TP 12
.B F4
Produce a .SCR file containing a screenshot of the screen of the emulator in
the current state.
.TP 12
.B F5
Resets the Spectrum in whatever current mode it is in.
.TP 12
.B F6
Pressing this generates an NMI.  With the default ROMs, this has the effect of
resetting the machine, but some contributed ROMs have hooks for extensions on
receipt of an NMI.  With the Multiface 128 in use this will enter the
Multiface.
.TP 12
.B F7
Calls the the built-in debugger, which contains some options interesting even
to those who has no interest in machine code programming.
.TP 12
.B F9
Choose a certain architecture for the Spectrum emulation and does or does not
perform a reset.
.TP 12
.B F10
Shuts down the emulator cleanly.
.PP
Support for the original Spectrum keyboard is emulated as follows:

Left Shift emulates Caps Shift and this is guaranteed to work (only) for the
basic Spectrum keys, that is letters, numbers and Space.  Alt/Meta emulates
Symbol Shift, Control emulates Extend mode.  Also guaranteed for basic Spectrum
keys.  Return emulates Enter, Backspace and Delete emulate CapsShift-0
(Rubout).  The cursor keys emulate CapsShift-5 to 8, or plain 5 to 8 (Cursor
Joystick).  The Tab key toggles between the two.  Escape emulates CapsShift-1
(Edit).  Right Shift and other local modifier keys(*) work locally: The
character printed on your key is emulated wherever possible.  This actually
goes for all "non-Spectrum" keys with or without local shift.

The keyboard emulation is not perfect and it can get confused at times.  If you
think this has happened, try presssing Bar or Backslash which clears all
Spectrum input ports.

The emulator turns keyboard autorepeat off when the mouse pointer is in the
\fBXZX\fR window.

(*) like some "Alt" keys that are used to get extra characters.  On both DEC
and Sun (when I tried), this key is not decoded as Alt or Meta but as
Mode_switch.
.SH EXTENSIONS AND ALTERATIONS TO THE BASIC
.PP
If \fBXZX\fR has been compiled with the \fIPSEUDO_IO\fR define, it will be
possible to read characters from stdin and write characters to stdout and
stderr using I/O ports.  By default the ports are as follows: reading port
0x00bf (191) will read a character from stdin, returning 255 if no input is
pending; writing port 0x01bf (447) will send a character to stdout; and writing
port 0x02bf (703) will send a character to stderr.  These port numbers can be
overriden at compile\-time by changing the definitions in io.h.  This is not
particularly useful interactively, especially if the Interface I is active, but
has possibilities as an unusual filtering shelltool.
.PP
The BASIC LOAD and SAVE commands will behave differently.  Instead of trying to
read or write data to a tape, SAVE will immediately dump data to a tape file on
disk, and LOAD will try and read data from a tape file on disk.
.PP
If \fBXZX\fR as been compiled with the \fIXZX_IF1\fR define the emulator
behaves as though an Interface I is attached in terms of paging the shadow ROM
in and out, allowing the use of extended basic commands and emulating the
Microdrive hardware.
.PP
The microdrive cartridge file format used is the .MDR format used by several
other Spectrum emulators.
.PP
When the Interface I emulation is active the RS232 channels are connected to
stdio so listings and blocks of code can be obtained and transferred by
appropriate redirections.  For example: "\fIXZX -crlf yes > listing.bas\fR",
followed by the BASIC commands to \fBXZX\fR:
"\fIOPEN #4, 'T': LIST #4: CLOSE #4\fR".  Channel 'T' is a text channel; BASIC
keywords are expanded and end-of-line is converted to CR/LF.  Channel 'B' is a
binary channel; no conversion is performed.  Channel 'T' is only really useful
for listing BASIC programs to the RS232 port, as above.
.PP
\fBXZX\fR tries to emulate RS232 I/O as sensibly as possible, but please note
that piping input to \fBXZX\fR simply does not work well.  Reading input from
terminals & special devices (using the Unix file redirection mechanism) does
work, as does reading from files.
.PP
The +3 floppy disk format used is identical to that of Marco Vieth's Amstrad
CPC emulator.  Disk images should therefore be compatible between the two
emulators, though I have not tested this personally.
.SH BUGS AND DEFICIENCIES
See latest TODO list.
.SH AUTHOR
Erik Kunze <Erik.Kunze@fantasy.muc.de>, Des Herriott, and plenty
others.  See the README and ChangeLog files.
