#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#include "interface.h"

#include "treedata.h"

int do_drag_node(c, e, x, y, f)
tcanvas c;
tevent e;
int x, y;
int (*f)();
{
	static int result;
	static int dragging;
	static int notyet;
	static treenode dragnode;
	static tree dragtree;
	static treetypedata td;
	static nodetypedata nd;
	static double offx, offy;
	static double oldx, oldy;
	static double newx, newy;
	static treenode pn;
	static double pdist, dist;
	static double px, py, dx, dy;
	static double offa, olda;
	static treenode lastnode;
	static unsigned long lasttime;
	static unsigned long thistime;

	result=0;

	if(installing)
	{
		dragging=0;
		lastnode=NULL;
		canvas_add_event_function(do_drag_node, f);
		return(1);
	}
	else if(uninstalling)
	{
		canvas_remove_event_function(do_drag_node);
		return(1);
	}
	else if(printing) printf("zdragnode\n");

	switch(tevent_type(e))
	{
		case te_mousedown:
			if(!dragging)
			{
				dragnode=(treenode)which_node(c, x, y);
				if(dragnode!=NULL)
				{
					thistime=tevent_time(e);
					if(lastnode==dragnode && thistime-lasttime<DBLCLICK)
					{
						/* double clicked on dragnode */
						show_node_info_frame();
						lastnode=NULL;
						result=1;
					}
					else
					{
						lasttime=thistime;
						lastnode=dragnode;
						select_by_state(NodeSubtreeSel, dragnode, 0.0, e);
						/* setup for dragging node */
						pn=parent(dragnode);
						if(pn!=NULL && !globals->autoformat &&
							ndta(dragnode)->selected)
						{
							dragging=1;
							notyet=1;
							install_dragging_function(do_drag_node);
							dragtree=tree_get_tree(dragnode);
							nd=ndta(dragnode)->td;
							td=tdta(dragtree)->td;
							parentdistance(dragnode, &pdist);
							pdist*=td->tscalex;
							/* get parent node x,y */
							px=nodex(ndta(pn)->td, td);
							py=nodey(ndta(pn)->td, td);
							offx=x-nodex(nd, td);
							offy=y-nodey(nd, td);
							oldx=nodex(nd, td);
							oldy=nodey(nd, td);
							drag_node(dragnode, oldx, oldy, c);
						}
					}
					result=1;
				}
			}
			else
				result=1;
			break;
		case te_mouseup:
			if(dragging)
			{
				dragging=0;
				uninstall_dragging_function(do_drag_node);
				drag_node(dragnode, oldx, oldy, c);
				if(tdta(dragtree)->type==Boxed)
				{
					x=0;
					if(notyet)
						y=oldy-nodey(nd, td);
					else
						y=y-offy-nodey(nd, td);
					do_command(EveryNode, NULL, NULL, 0.0, 0.0,
						x, y, 0, 0, MoveNode);
				}
				else
				{
					dx=nodex(nd, td)-px;
					dy=nodey(nd, td)-py;
					olda=atan2(dy, dx);
					if(notyet)
					{
						dx=oldx-px;
						dy=oldy-py;
					}
					else
					{
						dx=x-offx-px;
						dy=y-offy-py;
					}
					offa=atan2(dy, dx)-olda;
					/*dist=hypot(dx, dy);*/
					/*dx*=pdist/dist;*/
					/*dy*=pdist/dist;*/
					/*x=px+dx-nodex(nd, td);*/
					/*y=py+dy-nodey(nd, td);*/
					do_command(EveryNode, NULL, NULL, offa, 0.0,
						0, 0, 0, 0, RotateNode);
				}
				result=1;
			}
			break;
		case te_drag:
			if(dragging)
			{
				/* drag node */
				drag_node(dragnode, oldx, oldy, c);
				if(tdta(dragtree)->type==Boxed)
				{
					newy=y-offy;
					newx=oldx;
				}
				else
				{
					dx=x-offx-px;
					dy=y-offy-py;
					dist=hypot(dx, dy);
					dx*=pdist/dist;
					dy*=pdist/dist;
					newx=px+dx;
					newy=py+dy;
				}
				if(notyet)
				{
					if(fabs(oldx-newx)>5 || fabs(oldy-newy)>5)
					{
						oldx=newx;
						oldy=newy;
						notyet=0;
					}
				}
				else
				{
					oldx=newx;
					oldy=newy;
				}
				drag_node(dragnode, oldx, oldy, c);
				result=1;
			}
			break;
		default:
			if(dragging)
				result=1;
			break;
	}
	return(result);
}
