#include <stdio.h>

#ifdef MEMDBG
#include "memdbg.h"
#endif

#include "treestruct.h"

treenode treeroot(t)
tree t;
{
	if(nottree(t) && notnode(t))
		return(NULL);
	
	if(nottree(t))
		return(((treegen)t)->t->root);
	else
		return(t->root);
}

firstsubtree(n, l)
/* starts up looping on node n,
	access subtree as subtree(firstsubtree(n)) */
treenode n;
list *l;
{
	if(notnode(n))
		return(NULL);
	
	*l=firstnode(n->branches);
	while(*l!=NULL)
	{
		if(((treebranch)nodeobj(*l))->up!=n)
			*l=nextnode(*l);
		else
			break;
	}
}

lastsubtree(n, l)
/* starts up looping on node n, going backward */
treenode n;
list *l;
{
	if(notnode(n))
		return(NULL);
	
	*l=(list)lastnode(n->branches);
	while(*l!=NULL)
	{
		if(((treebranch)nodeobj(*l))->up!=n)
			*l=prevnode(*l);
		else
			break;
	}
}

nextsubtree(n, l)
/* return the next subtree of node n */
treenode n;
list *l;
{
	*l=nextnode(*l);
	while(*l!=NULL)
	{
		if(((treebranch)nodeobj(*l))->up!=n)
			*l=nextnode(*l);
		else
			break;
	}
}

prevsubtree(n, l)
treenode n;
/* return the next subtree of a node, going backward */
list *l;
{
	*l=prevnode(*l);
	while(*l!=NULL)
	{
		if(((treebranch)nodeobj(*l))->up!=n)
			*l=prevnode(*l);
		else
			break;
	}
}
