package test.contrib.bug334;

import java.awt.Color;
import java.awt.Dimension;

import javax.swing.*;
import javax.swing.table.TableCellRenderer;

import org.jvnet.substance.skin.SubstanceBusinessBlackSteelLookAndFeel;

public class TableTest implements Runnable {

	// models
	private TableModel tableModel;

	// components
	private JFrame mainFrame;

	private JSplitPane mainPanel;

	private JTable tableTextField;

	private JTable tableLabel;

	private TableCellRenderer textFieldCellRenderer;

	private TableCellRenderer labelCellRenderer;

	private JScrollPane scrollTableTextField;

	private JScrollPane scrollTableLabel;

	public TableTest() {
		JFrame.setDefaultLookAndFeelDecorated(true);
		JDialog.setDefaultLookAndFeelDecorated(true);
		System.setProperty("sun.awt.noerasebackground", "true");

		// build main frame
		mainFrame = new JFrame();
		mainFrame.setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
		mainFrame.setTitle("Table test");

		mainPanel = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT);
		tableModel = new TableModel(4, 100);

		tableTextField = new JTable();
		tableTextField.setOpaque(false);
		tableTextField.setModel(tableModel);
		tableTextField.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		tableTextField.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
		textFieldCellRenderer = new CustomJTextFieldTableCellRenderer();
		tableTextField.setDefaultRenderer(Object.class, textFieldCellRenderer);
		// table.setSelectionBackground(Color.RED); // does not work

		// used for background selection color also if we have an JTextField as
		// renderer.
		tableTextField.setBackground(Color.RED);
		scrollTableTextField = new JScrollPane(tableTextField);
		scrollTableTextField.setPreferredSize(new Dimension(400, 250));
		mainPanel.add(scrollTableTextField, JSplitPane.LEFT);

		tableLabel = new JTable();
		tableLabel.setModel(tableModel);
		tableLabel.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		tableLabel.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
		labelCellRenderer = new CustomJLabelTableCellRenderer();
		tableLabel.setDefaultRenderer(Object.class, labelCellRenderer);

		scrollTableLabel = new JScrollPane(tableLabel);
		scrollTableLabel.setPreferredSize(new Dimension(400, 250));
		mainPanel.add(scrollTableLabel, JSplitPane.RIGHT);

		mainFrame.setContentPane(mainPanel);
		mainFrame.pack();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Runnable#run()
	 */
	public void run() {
		mainFrame.setVisible(true);
	}

	// starting point
	public static void main(String[] args) throws Exception {
		UIManager.setLookAndFeel(new SubstanceBusinessBlackSteelLookAndFeel());
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				new TableTest().run();
			}
		});
	}

}
