package test.contrib.bug291;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.*;

import org.jvnet.substance.SubstanceLookAndFeel;

public class TestBug291 extends JFrame {

	private static final long serialVersionUID = 4959828151458643370L;

	public TestBug291() {
		super("Test bug 291");
		final TestTableModel model = new TestTableModel();

		this.setLayout(new BorderLayout());
		final JTable table = new JTable(model);
		this.add(new JScrollPane(table), BorderLayout.CENTER);

		JPanel controls = new JPanel(new FlowLayout(FlowLayout.RIGHT));
		this.add(controls, BorderLayout.SOUTH);

		JButton add = new JButton("add");
		add.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				for (int i = 0; i < 4; i++) {
					AudioFile file = new AudioFile();
					file.setName(String.valueOf(System.currentTimeMillis()));
					file.setArtist(String.valueOf(System.currentTimeMillis()));
					model.addSong(file);
				}
			}
		});
		controls.add(add);

		JButton delete = new JButton("delete selected rows");
		delete.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				int[] selectedRows = table.getSelectedRows();
				model.removeSongs(selectedRows);
			}
		});
		controls.add(delete);

		this.setSize(400, 600);
		this.setLocationRelativeTo(null);
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}

	public static void main(String[] args) throws Exception {
		UIManager.setLookAndFeel(new SubstanceLookAndFeel());
		// UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				new TestBug291().setVisible(true);
			}
		});
	}
}