package test.contrib;

import java.awt.BorderLayout;

import javax.swing.*;

public class InteractiveTestTableComboBoxEditor {
	public static void main(String[] args) {
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				try {

					UIManager
							.setLookAndFeel("org.jvnet.substance.SubstanceLookAndFeel");
					final JFrame frame = createFrame();
					frame.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
					System.exit(1);
				}
			}
		});
	}

	private static JFrame createFrame() {
		final JFrame frame = new JFrame();
		JPanel contentPane = (JPanel) (frame.getContentPane());
		contentPane.setLayout(new BorderLayout());
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

		JTable table = new JTable(5, 1);
		contentPane.add(table, BorderLayout.CENTER);

		JComboBox combo = new JComboBox(new Object[] { "aa", "bb", "cc" });
		table.getColumnModel().getColumn(0).setCellEditor(
				new DefaultCellEditor(combo));

		frame.pack();
		return frame;
	}
}