package test.contrib;

import java.awt.BorderLayout;
import java.awt.FlowLayout;

import javax.swing.*;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.AbstractTableModel;

import org.jvnet.substance.SubstanceLookAndFeel;

public class CustomTableUIDelegate {
	public static void main(String[] args) throws Exception {
		UIManager.setLookAndFeel(new SubstanceLookAndFeel());
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				show();
			}
		});
	}

	public static void show() {
		JFrame frame = new JFrame("FFFFFFF");
		JTable table = new JTable();
		table.setUI(new BasicTableUI());
		table.setModel(new AbstractTableModel() {
			public int getRowCount() {
				return 3;
			}

			public int getColumnCount() {
				return 3;
			}

			public Object getValueAt(int rowIndex, int columnIndex) {
				return "DDDDDDDD";
			}
		});
		final BugItem headerBugItem = new BugItem(1, "PREVED");
		frame.getContentPane().setLayout(new FlowLayout());
		frame.getContentPane().add(table);
		frame.getContentPane().add(headerBugItem);
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frame.setSize(200, 200);
		frame.setVisible(true);
	}

	public static class BugItem extends JPanel {
		private JLabel numberIcon;

		public BugItem(Integer number, String itemName) {
			setLayout(new BorderLayout());
			setBorder(new EmptyBorder(0, 0, 0, 0));
			Icon image = UIManager.getIcon("OptionPane.errorIcon");
			numberIcon = new JLabel(itemName, image, SwingConstants.CENTER);
			// uncomment to see it as in 4.1
			// numberIcon.setUI(new BasicLabelUI());
			numberIcon.setHorizontalTextPosition(SwingConstants.CENTER);
			numberIcon.setOpaque(false);
			numberIcon.setVerticalTextPosition(SwingConstants.CENTER);
			add(numberIcon, BorderLayout.WEST);
			setOpaque(false);
		}
	}
}
