package test;

import java.awt.BorderLayout;

import javax.swing.*;
import javax.swing.table.DefaultTableModel;

import org.jvnet.lafwidget.animation.FadeConfigurationManager;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.substance.skin.SubstanceBusinessBlackSteelLookAndFeel;

public class Table30Columns extends JFrame {
	public Table30Columns() {
		super("Table with 30 columns");

		JTable table = new JTable(new DefaultTableModel() {
			@Override
			public int getColumnCount() {
				return 2;
			}

			@Override
			public int getRowCount() {
				return 5;
			}

			@Override
			public Object getValueAt(int row, int column) {
				return row + column;
			}
		});
		table.setColumnSelectionAllowed(true);
		table.setRowSelectionAllowed(true);

		this.add(new JScrollPane(table), BorderLayout.CENTER);
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		this.setSize(400, 400);
		this.setLocationRelativeTo(null);
	}

	public static void main(String[] args) throws Exception {
		UIManager.setLookAndFeel(new SubstanceBusinessBlackSteelLookAndFeel());
		FadeConfigurationManager.getInstance().disallowFades(
				FadeKind.SELECTION, JTable.class);
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				new Table30Columns().setVisible(true);
			}
		});
	}

}
